| package |
package := Package name: 'pst'.
package paxVersion: 0;
	basicComment: 'Pocket Smalltalk - revision 4 beta
Copyright (c) 1998, 1999 by Andrew Brault
GEOS changes and enhancements: Copyright (c) 1999, 2000 by Petr Novak
Toolbar enhancements: Copyright (c) 2000 by Joey Gibson (joeyGibson@mindspring.com)

This product is Open Source - see LICENSE.TXT for more information.
Home page: http://www.pocketsmalltalk.com
GEOS version home page: http://www.i.cz/PeN/pst9110.html
SE version: http://www.joeygibson.com/st

After filing in this package, evaluate the following to open a launcher (you can replace initSystem
with initGeosSystem or initPalmOSSystem):

	Pst initPalmOSSystem.
	PstLauncher show.
'.

package basicPackageVersion: ''.

"Image stripper bytes"
package imageStripperBytes: #[33 83 84 66 32 48 32 70 15 14 0 3 0 0 0 81 73 109 97 103 101 83 116 114 105 112 112 101 114 0 0 0 0 0 0 0 0 54 0 6 0 83 116 114 105 110 103 3 0 0 0 112 115 116 114 0 0 0 28 0 0 0 46 46 92 46 46 92 46 46 92 46 46 92 80 83 84 92 112 111 99 107 101 116 115 116 46 101 120 101 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 114 0 0 0 3 0 0 0 112 115 116 114 0 0 0 22 0 0 0 81 82 117 110 116 105 109 101 83 101 115 115 105 111 110 77 97 110 97 103 101 114 239 191 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ].
"Add the package scripts"

"Add the class names, loose method names, global names, resource names"
package classNames
	add: #Pst;
	add: #PstAboutShell;
	add: #PstAssignmentNode;
	add: #PstBasicObject;
	add: #PstBehavior;
	add: #PstBlockClosure;
	add: #PstBlockNode;
	add: #PstBranchDestinationInstruction;
	add: #PstBranchInstruction;
	add: #PstBreakpointInstruction;
	add: #PstByteIndexableObject;
	add: #PstCallStackFrame;
	add: #PstCascadeNode;
	add: #PstChangeLog;
	add: #PstCharacter;
	add: #PstCharacterLiteralNode;
	add: #PstClass;
	add: #PstClassBrowser;
	add: #PstClassDefiner;
	add: #PstClassLibrary;
	add: #PstCodeGenerator;
	add: #PstCompiledClass;
	add: #PstCompiler;
	add: #PstCompilerError;
	add: #PstCompilerWarning;
	add: #PstConditionalBranchInstruction;
	add: #PstConstant;
	add: #PstConstantsBrowser;
	add: #PstConstantsLibrary;
	add: #PstDeadCodeEliminator;
	add: #PstDebugger;
	add: #PstDirectedSendInstruction;
	add: #PstDocumentationGenerator;
	add: #PstDouble;
	add: #PstFileOutManager;
	add: #PstFullBlockClosure;
	add: #PstGenericCodeGenerator;
	add: #PstGeosAPI;
	add: #PstGeosCodeGenerator;
	add: #PstGeosLibCall;
	add: #PstGeosMessageInstruction;
	add: #PstGeosVMFile;
	add: #PstGeosVMFileBlock;
	add: #PstGlobalVariables;
	add: #PstImageStripper;
	add: #PstIndexableObject;
	add: #PstInspector;
	add: #PstInstruction;
	add: #PstInteger;
	add: #PstInterpreter;
	add: #PstLauncher;
	add: #PstLexer;
	add: #PstLiteralNode;
	add: #PstLongInteger;
	add: #PstMakeFullBlockInstruction;
	add: #PstMessageNode;
	add: #PstMessagePattern;
	add: #PstMetaclass;
	add: #PstMethod;
	add: #PstMethodListBrowser;
	add: #PstMethodNode;
	add: #PstMiscInstruction;
	add: #PstNonlocalReturnInstruction;
	add: #PstNormalObject;
	add: #PstObject;
	add: #PstOSAPI;
	add: #PstOSTrap;
	add: #PstPackage;
	add: #PstPackageBrowser;
	add: #PstPackageLibrary;
	add: #PstPalmOSAPI;
	add: #PstPalmOSTrap;
	add: #PstParseNode;
	add: #PstParser;
	add: #PstPilotCodeGenerator;
	add: #PstPocketSmalltalkGEOS;
	add: #PstPocketSmalltalkPalmOS;
	add: #PstPrimitiveInstruction;
	add: #PstPrimitiveNode;
	add: #PstPrimitiveSet;
	add: #PstPushAnyInstVarInstruction;
	add: #PstPushCharacterInstruction;
	add: #PstPushClassInstruction;
	add: #PstPushCleanBlockInstruction;
	add: #PstPushConstantInstruction;
	add: #PstPushInstVarInstruction;
	add: #PstPushLiteralInstruction;
	add: #PstPushLocalInstruction;
	add: #PstPushSelfInstruction;
	add: #PstPushSharedVarInstruction;
	add: #PstQuasiMethod;
	add: #PstRawInstruction;
	add: #PstResource;
	add: #PstResourceDatabase;
	add: #PstReturnInstruction;
	add: #PstReturnNode;
	add: #PstRuntimeSessionManager;
	add: #PstSendInstruction;
	add: #PstSendSelfInstruction;
	add: #PstSendSuperInstruction;
	add: #PstSendWithReceiverOnTopInstruction;
	add: #PstSharedVarInstruction;
	add: #PstShell;
	add: #PstSmalltalkBlockCompiler;
	add: #PstSmalltalkClassLibrary;
	add: #PstSmalltalkCodeGenerator;
	add: #PstSmalltalkCompiler;
	add: #PstSmalltalkInstruction;
	add: #PstSmalltalkObject;
	add: #PstSmalltalkParser;
	add: #PstSmalltalkSystem;
	add: #PstSourceCodePresenter;
	add: #PstSplash;
	add: #PstStatementsNode;
	add: #PstStatistics;
	add: #PstStoreAnyInstVarInstruction;
	add: #PstStoreInstVarInstruction;
	add: #PstStoreLocalInstruction;
	add: #PstStoreSharedVarInstruction;
	add: #PstSymbol;
	add: #PstSystem;
	add: #PstSystemProperties;
	add: #PstSystrapBrowser;
	add: #PstSysTrapInstruction;
	add: #PstToolbar;
	add: #PstToolbarHelper;
	add: #PstUncommittedPackage;
	add: #PstVariableInstruction;
	add: #PstVariableNode;
	add: #PstVariableReference;
	add: #PstWorkspace;
	yourself.

package methodNames
	add: #Bag -> #asAssociations;
	add: #Collection -> #select:do:;
	add: #Float -> #printString:;
	add: #Object -> #orIfNil:;
	add: #TextEdit -> #onKeyTyped:;
	add: #UndefinedObject -> #orIfNil:;
	add: 'SortedCollection class' -> #sortBlock:withAll:;
	yourself.

package globalNames
	yourself.

package resourceNames
	yourself.

"Binary Global Names"
package binaryGlobalNames: (Set new
	yourself).
"Resource Names"
package allResourceNames: (Set new
	add: #PstAboutShell -> 'Default view';
	add: #PstClassBrowser -> 'Default view';
	add: #PstConstantsBrowser -> 'Default view';
	add: #PstDebugger -> 'Default view';
	add: #PstInspector -> 'Default view';
	add: #PstLauncher -> 'Default view';
	add: #PstMethodListBrowser -> 'Default view';
	add: #PstPackageBrowser -> 'Default view';
	add: #PstSourceCodePresenter -> 'Workspace view';
	add: #PstSystrapBrowser -> 'Default view';
	add: #PstToolbar -> 'PstDebugger Toolbar';
	add: #PstToolbar -> 'PstEditTools Toolbar';
	add: #PstToolbar -> 'PstFileTools Toolbar';
	add: #PstToolbar -> 'PstImage Toolbar';
	add: #PstToolbar -> 'PstTools Toolbar';
	add: #PstToolbar -> 'PstWorkspaceTools Toolbar';
	add: #PstWorkspace -> 'Default view';
	yourself).

"Add the prerequisite names"
package setPrerequisites: (IdentitySet new
	add: 'Application Deployment Kit';
	add: 'Dolphin';
	yourself).

package!

"Class Definitions"!

Object subclass: #Pst
	instanceVariableNames: 'events'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #PstToolbarHelper
	instanceVariableNames: 'launcher containingTool'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Error subclass: #PstCompilerError
	instanceVariableNames: 'message start stop'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Notification subclass: #PstCompilerWarning
	instanceVariableNames: 'message start stop'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
ImageStripper subclass: #PstImageStripper
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Shell subclass: #PstAboutShell
	instanceVariableNames: 'imagePresenter'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Shell subclass: #PstShell
	instanceVariableNames: 'toolbarHelper'
	classVariableNames: 'PstShellIcon'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstShell subclass: #PstClassBrowser
	instanceVariableNames: 'classTree methodTree sourceCode modeList sideList kludge statusModel'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstShell subclass: #PstConstantsBrowser
	instanceVariableNames: 'categoryList constantsList sourceCode statusModel'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstShell subclass: #PstDebugger
	instanceVariableNames: 'interpreter contextList sourceCode localFieldList localFieldSource sourceMode disassemblyMap'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstShell subclass: #PstInspector
	instanceVariableNames: 'fieldList sourceCode historyStack'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstShell subclass: #PstLauncher
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstShell subclass: #PstMethodListBrowser
	instanceVariableNames: 'methodList sourceCode updateBlock'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstShell subclass: #PstPackageBrowser
	instanceVariableNames: 'packageList classList methodList constantList statusModel'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstShell subclass: #PstSystrapBrowser
	instanceVariableNames: 'traps'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstShell subclass: #PstWorkspace
	instanceVariableNames: 'sourceCode'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
RichTextPresenter subclass: #PstSourceCodePresenter
	instanceVariableNames: 'expressionOffset autoindent'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstCallStackFrame
	instanceVariableNames: 'interpreter receiver method localVarBase dataStackPtr instructionPtr closureSet'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstChangeLog
	instanceVariableNames: 'loggingChanges'
	classVariableNames: 'Current'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstClassDefiner
	instanceVariableNames: 'superclass className instVarNames classVarNames classType originalClass originalName mustRecompile undoBlocks renamed instVarNamesLiteral classVarNamesLiteral'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstClassLibrary
	instanceVariableNames: 'indexByName roots'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstCodeGenerator
	instanceVariableNames: 'selectorTable objectTable compiledClassTable classOffsets compiledObjectData globalMap selectorData selectorDataSegments'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstCompiledClass
	instanceVariableNames: 'compiledMethods deferredBlocks sortedMethods'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstCompiler
	instanceVariableNames: 'instructions compilationClass argumentsHere temporariesHere phantoms phantomMax methodSelector sourcePosition'
	classVariableNames: 'ErrorException WarningException'
	poolDictionaries: ''
	classInstanceVariableNames: 'optimizationTable'!
Pst subclass: #PstConstant
	instanceVariableNames: 'name value category package'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstConstantsLibrary
	instanceVariableNames: 'categories constantsByName'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstDeadCodeEliminator
	instanceVariableNames: 'keptBehaviors keptSelectors keptMethods changed'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstDocumentationGenerator
	instanceVariableNames: 'stream currentClass'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstFileOutManager
	instanceVariableNames: 'stream filename lineNumber definingClass definitionSelector methodCategory expectingClassComment'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstGeosVMFile
	instanceVariableNames: 'defaultFilename blocks name token application'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstGeosVMFileBlock
	instanceVariableNames: 'contents id'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstGlobalVariables
	instanceVariableNames: 'variables'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstInstruction
	instanceVariableNames: 'sequenceNumber sourcePosition'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstInterpreter
	instanceVariableNames: 'system primitiveSet dataStack dataStackPtr receiver callStack instructions instructionPtr currentMethod localVarBase synchronize primitiveFailCode closureSet returnedValue debugger'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstLexer
	instanceVariableNames: 'inputStream pushback token value here tokenStart tokenStop joiningKeywords commentMap'
	classVariableNames: 'BinopTable'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstMethod
	instanceVariableNames: 'ownerClass sourceCode selector instructions primitive commentMap keywordMap argumentMap package'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstObject
	instanceVariableNames: 'qclass'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstOSAPI
	instanceVariableNames: ''
	classVariableNames: 'TrapTable'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstOSTrap
	instanceVariableNames: 'name functionNumber returnType argumentTypes'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstPackage
	instanceVariableNames: 'name classes methods constants dontSave'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstPackageLibrary
	instanceVariableNames: 'packages uncommittedPackage defaultPackage projectFilename'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstParseNode
	instanceVariableNames: 'start stop'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstParser
	instanceVariableNames: 'lexer token tokenStart tokenStop value node pushback'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstPrimitiveSet
	instanceVariableNames: 'primitiveMap interpreter'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstQuasiMethod
	instanceVariableNames: 'actualMethod'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstResource
	instanceVariableNames: 'name id contents offset'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstResourceDatabase
	instanceVariableNames: 'resources creatorID databaseType title defaultFilename'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstStatistics
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstSystem
	instanceVariableNames: 'classLibrary constantsLibrary defaultFont properties globals packageLibrary projectFilename'
	classVariableNames: 'CurrentSystem LastArguments'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstSystemProperties
	instanceVariableNames: 'globalCount'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstVariableReference
	instanceVariableNames: 'type name index distance'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstClassLibrary subclass: #PstSmalltalkClassLibrary
	instanceVariableNames: 'messageClass arrayClass blockClosureClass fullBlockClosureClass smallIntegerClass'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstCodeGenerator subclass: #PstSmalltalkCodeGenerator
	instanceVariableNames: 'optimized objectSlotCounter objectList objectSegments lastClassIndex compiledClass classSegments classNameData keepMethodBlock keepBehaviorBlock keepSelectorBlock'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkCodeGenerator subclass: #PstGenericCodeGenerator
	instanceVariableNames: 'outputStream'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkCodeGenerator subclass: #PstGeosCodeGenerator
	instanceVariableNames: 'geosVM fileStream'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkCodeGenerator subclass: #PstPilotCodeGenerator
	instanceVariableNames: 'database fileStream'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstCompiler subclass: #PstSmalltalkCompiler
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkCompiler subclass: #PstSmalltalkBlockCompiler
	instanceVariableNames: 'isFullBlock parent'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstInstruction subclass: #PstSmalltalkInstruction
	instanceVariableNames: 'startIndex code'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkInstruction subclass: #PstBranchDestinationInstruction
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkInstruction subclass: #PstBranchInstruction
	instanceVariableNames: 'destination'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkInstruction subclass: #PstBreakpointInstruction
	instanceVariableNames: 'instruction'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkInstruction subclass: #PstMakeFullBlockInstruction
	instanceVariableNames: 'argumentCount'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkInstruction subclass: #PstMiscInstruction
	instanceVariableNames: 'type'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkInstruction subclass: #PstNonlocalReturnInstruction
	instanceVariableNames: 'distance'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkInstruction subclass: #PstPrimitiveInstruction
	instanceVariableNames: 'primitiveIndex'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkInstruction subclass: #PstPushAnyInstVarInstruction
	instanceVariableNames: 'index'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkInstruction subclass: #PstPushLiteralInstruction
	instanceVariableNames: 'value'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkInstruction subclass: #PstPushSelfInstruction
	instanceVariableNames: 'distance'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkInstruction subclass: #PstRawInstruction
	instanceVariableNames: 'byte comment'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkInstruction subclass: #PstReturnInstruction
	instanceVariableNames: 'specialValue'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkInstruction subclass: #PstSendInstruction
	instanceVariableNames: 'argumentCount selector'
	classVariableNames: 'InlineSelectors'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkInstruction subclass: #PstSharedVarInstruction
	instanceVariableNames: 'ownerClass variableName'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkInstruction subclass: #PstSysTrapInstruction
	instanceVariableNames: 'trapName ignoreReturn'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkInstruction subclass: #PstVariableInstruction
	instanceVariableNames: 'index variableName distance'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstBranchInstruction subclass: #PstConditionalBranchInstruction
	instanceVariableNames: 'condition'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstPushAnyInstVarInstruction subclass: #PstStoreAnyInstVarInstruction
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstPushLiteralInstruction subclass: #PstPushCharacterInstruction
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstPushLiteralInstruction subclass: #PstPushClassInstruction
	instanceVariableNames: 'isMeta'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstPushLiteralInstruction subclass: #PstPushCleanBlockInstruction
	instanceVariableNames: 'homeClass argumentCount'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstPushLiteralInstruction subclass: #PstPushConstantInstruction
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSendInstruction subclass: #PstDirectedSendInstruction
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSendInstruction subclass: #PstSendSelfInstruction
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSendInstruction subclass: #PstSendSuperInstruction
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSendInstruction subclass: #PstSendWithReceiverOnTopInstruction
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSharedVarInstruction subclass: #PstPushSharedVarInstruction
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSharedVarInstruction subclass: #PstStoreSharedVarInstruction
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSysTrapInstruction subclass: #PstGeosMessageInstruction
	instanceVariableNames: 'arguments'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstVariableInstruction subclass: #PstPushInstVarInstruction
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstVariableInstruction subclass: #PstPushLocalInstruction
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstVariableInstruction subclass: #PstStoreInstVarInstruction
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstVariableInstruction subclass: #PstStoreLocalInstruction
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstObject subclass: #PstSmalltalkObject
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkObject subclass: #PstBasicObject
	instanceVariableNames: ''
	classVariableNames: 'FalseObject NilObject TrueObject'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkObject subclass: #PstBehavior
	instanceVariableNames: 'superclass layout methodTable categories'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkObject subclass: #PstBlockClosure
	instanceVariableNames: 'home offset argumentCount'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkObject subclass: #PstDouble
	instanceVariableNames: 'value'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkObject subclass: #PstInteger
	instanceVariableNames: 'value'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkObject subclass: #PstNormalObject
	instanceVariableNames: 'namedSlots'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkObject subclass: #PstSymbol
	instanceVariableNames: 'string'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstBasicObject subclass: #PstCharacter
	instanceVariableNames: 'value'
	classVariableNames: 'AllCharacters Attributes'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstBehavior subclass: #PstClass
	instanceVariableNames: 'name instVarNames isBasic isInstantiable classVariables subclasses comment package'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstBehavior subclass: #PstMetaclass
	instanceVariableNames: 'uniqueInstance'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstBlockClosure subclass: #PstFullBlockClosure
	instanceVariableNames: 'nextOuter'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstInteger subclass: #PstLongInteger
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstNormalObject subclass: #PstIndexableObject
	instanceVariableNames: 'indexedSlots'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstIndexableObject subclass: #PstByteIndexableObject
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstOSAPI subclass: #PstGeosAPI
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstOSAPI subclass: #PstPalmOSAPI
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstOSTrap subclass: #PstGeosLibCall
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstOSTrap subclass: #PstPalmOSTrap
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstPackage subclass: #PstUncommittedPackage
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstParseNode subclass: #PstAssignmentNode
	instanceVariableNames: 'variable value hard'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstParseNode subclass: #PstBlockNode
	instanceVariableNames: 'statements arguments'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstParseNode subclass: #PstCascadeNode
	instanceVariableNames: 'receiver messages'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstParseNode subclass: #PstLiteralNode
	instanceVariableNames: 'value'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstParseNode subclass: #PstMessageNode
	instanceVariableNames: 'receiver arguments keywords selector'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstParseNode subclass: #PstMessagePattern
	instanceVariableNames: 'keywords arguments keywordRanges argumentRanges'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstParseNode subclass: #PstMethodNode
	instanceVariableNames: 'pattern statements primitive commentMap'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstParseNode subclass: #PstPrimitiveNode
	instanceVariableNames: 'index'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstParseNode subclass: #PstReturnNode
	instanceVariableNames: 'value'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstParseNode subclass: #PstStatementsNode
	instanceVariableNames: 'statements temporaries'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstParseNode subclass: #PstVariableNode
	instanceVariableNames: 'name'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstLiteralNode subclass: #PstCharacterLiteralNode
	instanceVariableNames: ''
	classVariableNames: 'Escapes'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstParser subclass: #PstSmalltalkParser
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSystem subclass: #PstSmalltalkSystem
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: 'SystemFileNames'!
PstSmalltalkSystem subclass: #PstPocketSmalltalkGEOS
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkSystem subclass: #PstPocketSmalltalkPalmOS
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
RuntimeSessionManager subclass: #PstRuntimeSessionManager
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Splash subclass: #PstSplash
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Toolbar subclass: #PstToolbar
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
"Loose Methods"!

!Bag methodsFor!

asAssociations
	^contents associations.! !
!Bag categoriesFor: #asAssociations!converting!public! !

!Collection methodsFor!

select: predicate do: action
	self do: [:each |
		(predicate value: each)
			ifTrue: [action value: each]].! !
!Collection categoriesFor: #select:do:!enumerating!public! !

!Float methodsFor!

printString: decimalPlaces
	| stream |
	stream := String new writeStream.
	self printOn: stream decimalPlaces: decimalPlaces.
	^stream contents.! !
!Float categoriesFor: #printString:!printing!public! !

!Object methodsFor!

orIfNil: block
	^self.! !
!Object categoriesFor: #orIfNil:!public!testing! !

!SortedCollection class methodsFor!

sortBlock: sortBlock withAll: contents
	^(self sortBlock: sortBlock)
		addAll: contents;
		yourself.! !
!SortedCollection class categoriesFor: #sortBlock:withAll:!instance creation!public! !

!TextEdit methodsFor!

onKeyTyped: aKeyEvent
	"Handle aKeyEvent. If the receiver is in updatePerChar mode, then we
	update the model immediately after processing the character.
	Implementation Note: Sadly the edit control does not insert tabs if used 
	in conjunction with IsDialogMessage(), even though it says it wants to 
	receive them. We therefore fix this bug overridding WM_GETDLGCODE and never
	allowing it to reach the control. This prevents the control from getting the
	notion that it is in a dialog, and retains the saner behaviour.
	An alternative workaround to implementing WM_GETDLGCODE would be to
	recode this method thus:
		...
		| answer |
		answer := aKeyEvent code == VK_TAB
			ifTrue: [self replaceSelection: String tab. 0]
			ifFalse: [super onChar: aKeyEvent].
		...
	However the WM_GETDLGCODE override is preferred, because it prevents other nasties
	too."

	| answer |
	answer := super onKeyTyped: aKeyEvent.
	self updatePerChar ifTrue: [self apply].
	self presenter trigger: #afterKeyTyped: with: aKeyEvent.
	^answer! !
!TextEdit categoriesFor: #onKeyTyped:!event handling!public! !

!UndefinedObject methodsFor!

orIfNil: block
	^block value.! !
!UndefinedObject categoriesFor: #orIfNil:!public!testing! !

"End of package definition"!



Pst comment: ''!

Pst guid: (GUID fromString: '{3EFACBD2-7FC4-441B-B9E7-8241DE345DD9}')!

!Pst categoriesForClass!No category! !
!Pst methodsFor!

getEvents
	^events.!

initialize
	^self.!

nilEventsDuring: block
	"useful during binary filing"
	| hold |
	hold := events.
	events := nil.
	block value.
	events := hold.!

setEvents: collection
	events := collection.! !
!Pst categoriesFor: #getEvents!events!public! !
!Pst categoriesFor: #initialize!initialization!public! !
!Pst categoriesFor: #nilEventsDuring:!events!public! !
!Pst categoriesFor: #setEvents:!events!public! !

!Pst class methodsFor!

initGeosSystem
	"Pst initSystem"
	PstLexer initialize.
	PstCharacterLiteralNode initialize.
	PstSendInstruction initialize.
	PstSmalltalkCompiler initialize.
	PstSmalltalkBlockCompiler initialize.
	PstSystem resetAs: PstPocketSmalltalkGEOS.!

initPalmOSSystem
	"Pst initSystem"
	PstLexer initialize.
	PstCharacterLiteralNode initialize.
	PstSendInstruction initialize.
	PstSmalltalkCompiler initialize.
	PstSmalltalkBlockCompiler initialize.
	PstSystem resetAs: PstPocketSmalltalkPalmOS.!

initSystem
	"Pst initSystem"
	self initPalmOSSystem!

new
	^super new initialize.! !
!Pst class categoriesFor: #initGeosSystem!initialization!public! !
!Pst class categoriesFor: #initPalmOSSystem!initialization!public! !
!Pst class categoriesFor: #initSystem!initialization!public! !
!Pst class categoriesFor: #new!instance creation!public! !



PstToolbarHelper comment: ''!

PstToolbarHelper guid: (GUID fromString: '{E1A2CE6D-E7EC-47BB-967C-E4779B9596B2}')!

!PstToolbarHelper categoriesForClass!Unclassified! !
!PstToolbarHelper methodsFor!

containingTool
	"Answer the value of the receiver's ''containingTool'' instance variable."

	^containingTool!

containingTool: anObject
	"Set the value of the receiver's ''containingTool'' instance variable to the argument, anObject."

	containingTool := anObject!

launcher
	"Answer the value of the receiver's ''launcher'' instance variable."

	^launcher!

launcher: anObject
	"Set the value of the receiver's ''launcher'' instance variable to the argument, anObject,
	or the first instance of it we can find."

	anObject isNil 
		ifTrue: [launcher := (PstLauncher allInstances) at: 1]
		ifFalse: [launcher := anObject].
!

newProject
	launcher newProject.!

openClassBrowser
	"Open a PstClassbrowser."
	launcher openClassBrowser.!

openClassBrowserOnClass: aClass
	"Open a PstClassbrowser."
	launcher openClassBrowserOnClass: aClass.!

openClassBrowserOnMethod: aMethod
	"Open a PstClassbrowser."
	launcher openClassBrowserOnMethod: aMethod.!

openConstantsBrowser
	launcher openConstantsBrowser.!

openConstantsBrowserOnConstant: aConstant

	launcher openConstantsBrowserOnConstant: aConstant.!

openPackageBrowser
	launcher openPackageBrowser.!

openProject
	launcher openProject.!

openSystrapBrowser
	launcher openSystrapBrowser.!

openWorkspace
	launcher openWorkspace.!

saveProject
	launcher saveProject.! !
!PstToolbarHelper categoriesFor: #containingTool!accessing!public! !
!PstToolbarHelper categoriesFor: #containingTool:!accessing!public! !
!PstToolbarHelper categoriesFor: #launcher!accessing!public! !
!PstToolbarHelper categoriesFor: #launcher:!accessing!public! !
!PstToolbarHelper categoriesFor: #newProject!*-unclassified!public! !
!PstToolbarHelper categoriesFor: #openClassBrowser!*-unclassified!public! !
!PstToolbarHelper categoriesFor: #openClassBrowserOnClass:!*-unclassified!public! !
!PstToolbarHelper categoriesFor: #openClassBrowserOnMethod:!*-unclassified!public! !
!PstToolbarHelper categoriesFor: #openConstantsBrowser!*-unclassified!public! !
!PstToolbarHelper categoriesFor: #openConstantsBrowserOnConstant:!*-unclassified!public! !
!PstToolbarHelper categoriesFor: #openPackageBrowser!*-unclassified!public! !
!PstToolbarHelper categoriesFor: #openProject!*-unclassified!public! !
!PstToolbarHelper categoriesFor: #openSystrapBrowser!*-unclassified!public! !
!PstToolbarHelper categoriesFor: #openWorkspace!*-unclassified!public! !
!PstToolbarHelper categoriesFor: #saveProject!actions-system!public! !

!PstToolbarHelper class methodsFor!

new
	^super new initialize launcher: nil.!

with: aLauncher
	"Answer a new instance of the class, with aLauncher setup as the launcher."

	^super new initialize launcher: aLauncher.! !
!PstToolbarHelper class categoriesFor: #new!*-unclassified!public! !
!PstToolbarHelper class categoriesFor: #with:!instance creation!public! !



PstCompilerError comment: ''!

PstCompilerError guid: (GUID fromString: '{A9A77418-4555-4033-811A-B027F3CA3DF5}')!

!PstCompilerError categoriesForClass!No category! !
!PstCompilerError methodsFor!

message
	"Answer the value of the receiver's instance variable message.
	This method was automatically generated, but may be modified."

	^message!

message: anObject
	"Set the value of the receiver's instance variable message to anObject.
	This method was automatically generated, but may be modified."

	message := anObject!

start
	"Answer the value of the receiver's instance variable start.
	This method was automatically generated, but may be modified."

	^start!

start: anObject
	"Set the value of the receiver's instance variable start to anObject.
	This method was automatically generated, but may be modified."

	start := anObject!

stop
	"Answer the value of the receiver's instance variable stop.
	This method was automatically generated, but may be modified."

	^stop!

stop: anObject
	"Set the value of the receiver's instance variable stop to anObject.
	This method was automatically generated, but may be modified."

	stop := anObject! !
!PstCompilerError categoriesFor: #message!accessing!public! !
!PstCompilerError categoriesFor: #message:!accessing!public! !
!PstCompilerError categoriesFor: #start!accessing!public! !
!PstCompilerError categoriesFor: #start:!accessing!public! !
!PstCompilerError categoriesFor: #stop!accessing!public! !
!PstCompilerError categoriesFor: #stop:!accessing!public! !



PstCompilerWarning comment: ''!

PstCompilerWarning guid: (GUID fromString: '{CCD9F045-7596-4AD4-91B0-0268B7E0F1F1}')!

!PstCompilerWarning categoriesForClass!No category! !
!PstCompilerWarning methodsFor!

message
	"Answer the value of the receiver's instance variable message.
	This method was automatically generated, but may be modified."

	^message!

message: anObject
	"Set the value of the receiver's instance variable message to anObject.
	This method was automatically generated, but may be modified."

	message := anObject!

start
	"Answer the value of the receiver's instance variable start.
	This method was automatically generated, but may be modified."

	^start!

start: anObject
	"Set the value of the receiver's instance variable start to anObject.
	This method was automatically generated, but may be modified."

	start := anObject!

stop
	"Answer the value of the receiver's instance variable stop.
	This method was automatically generated, but may be modified."

	^stop!

stop: anObject
	"Set the value of the receiver's instance variable stop to anObject.
	This method was automatically generated, but may be modified."

	stop := anObject! !
!PstCompilerWarning categoriesFor: #message!accessing!public! !
!PstCompilerWarning categoriesFor: #message:!accessing!public! !
!PstCompilerWarning categoriesFor: #start!accessing!public! !
!PstCompilerWarning categoriesFor: #start:!accessing!public! !
!PstCompilerWarning categoriesFor: #stop!accessing!public! !
!PstCompilerWarning categoriesFor: #stop:!accessing!public! !



PstImageStripper comment: ''!

PstImageStripper guid: (GUID fromString: '{9EA465A6-0816-4B1C-868A-FEAC39AF4AC3}')!

!PstImageStripper categoriesForClass!Unclassified! !
!PstImageStripper methodsFor!

developmentMethodCategoryNames
	"Answer a <collection> of the names of <MethodCategory>s containing only
	development methods which must therefore be stripped from the image when it is deployed."

	| names |
	names := super developmentMethodCategoryNames.
	names remove: 'categories' ifAbsent: [].
	^names
! !
!PstImageStripper categoriesFor: #developmentMethodCategoryNames!constants!public! !



PstAboutShell comment: ''!

PstAboutShell guid: (GUID fromString: '{EC8B4F53-AEED-4619-A91D-4D4BF366050E}')!

!PstAboutShell categoriesForClass!Unclassified! !
!PstAboutShell methodsFor!

createComponents
	"Private - Create the presenters  contained by the receiver."

	super createComponents.
	imagePresenter := self add: ImagePresenter new name: 'imagePresenter'.
	
	imagePresenter value: (Bitmap fromFile: (File composePath: SessionManager current installationDirectory 
			subPath: 'PstSplash.bmp')
			usingLocator: FileLocator absolute).!

ok
	self view close.! !
!PstAboutShell categoriesFor: #createComponents!*-unclassified!private! !
!PstAboutShell categoriesFor: #ok!*-unclassified!public! !



PstShell comment: ''!

PstShell guid: (GUID fromString: '{F0B9A87B-59AB-4F93-B618-9911450935FC}')!

!PstShell categoriesForClass!No category! !
!PstShell methodsFor!

toolbarFileNew
	toolbarHelper newProject.!

toolbarFileOpen
	toolbarHelper openProject.!

toolbarFileSave
	toolbarHelper saveProject.!

toolbarHelper: aToolbarHelper
	"Assigns a PstToolbarHelper to a tool."

	toolbarHelper := aToolbarHelper.
	toolbarHelper containingTool: self.!

toolbarOpenClassBrowser
	"Open a class browser."

	toolbarHelper openClassBrowser.!

toolbarOpenConstantsBrowser
	toolbarHelper openConstantsBrowser.!

toolbarOpenPackageBrowser
	toolbarHelper openPackageBrowser.!

toolbarOpenSystrapBrowser
	toolbarHelper openSystrapBrowser.!

toolbarOpenWorkspace
	toolbarHelper openWorkspace.!

toolbarSaveProject
	toolbarHelper saveProject.! !
!PstShell categoriesFor: #toolbarFileNew!*-unclassified!public! !
!PstShell categoriesFor: #toolbarFileOpen!*-unclassified!public! !
!PstShell categoriesFor: #toolbarFileSave!*-unclassified!public! !
!PstShell categoriesFor: #toolbarHelper:!*-unclassified!public! !
!PstShell categoriesFor: #toolbarOpenClassBrowser!*-unclassified!public! !
!PstShell categoriesFor: #toolbarOpenConstantsBrowser!*-unclassified!public! !
!PstShell categoriesFor: #toolbarOpenPackageBrowser!*-unclassified!public! !
!PstShell categoriesFor: #toolbarOpenSystrapBrowser!*-unclassified!public! !
!PstShell categoriesFor: #toolbarOpenWorkspace!*-unclassified!public! !
!PstShell categoriesFor: #toolbarSaveProject!*-unclassified!public! !

!PstShell class methodsFor!

icon
	PstShellIcon isNil ifTrue: [
		PstShellIcon := Icon fromFile: 'pocketst.ico'].
	^PstShellIcon.! !
!PstShell class categoriesFor: #icon!*-unclassified!public! !



PstClassBrowser comment: ''!

PstClassBrowser guid: (GUID fromString: '{C70501FC-8548-47DF-AAEC-E4E7C21E02A6}')!

!PstClassBrowser categoriesForClass!No category! !
!PstClassBrowser methodsFor!

accept
	"Answer whether compilation succeeded."
	| mode |
	mode := self mode.
	sourceCode view isModified: false.  "hmm..."
	mode == #source ifTrue: [^self acceptSource].
	mode == #class ifTrue: [^self acceptClass].
	mode == #comment ifTrue: [^self acceptComment].!

acceptClass
	[PstClassDefiner new
			redefine: self selectedClass
			as: self sourceString]
		on: PstCompilerError
		do: [:exception |
			sourceCode
				handleError: exception message
				from: exception start
				to: exception stop.
			^false]
		on: PstCompilerWarning
		do: [:exception |
			sourceCode
				handleWarning: exception message
				from: exception start
				to: exception stop.
			exception resume].
	self updateSourcePane.
	^true.  "hrm"!

acceptComment
	self selectedClass isNil ifTrue: [^self].
	self selectedClass comment: self sourceString.
	self updateSourcePane.
	^true.!

acceptSource
	| cls method category |
	cls := self classForMethods.
	cls isNil ifTrue: [^false].
	method := PstSystem current qcompilerClass
		compile: self sourceString
		in: cls
		notifying: sourceCode.
	method isNil ifTrue: [^false].
	category := (cls includesSelector: method selector)
		ifTrue: [cls categoryOfMethod: (cls methodAt: method selector)]
		ifFalse: [self selectedCategory].
	category isNil ifTrue: [category := cls preferredCategoryOf: method selector].
	category isNil ifTrue: [category := 'uncategorized'].
	kludge := method.
	cls 
		installMethod: method 
		classified: category.
	self selectMethodNamed: method selector.
	self statusMessage: 'Accepted ', method fullDisplayString.
	^true.!

addSubclass
	| subclassName |
	subclassName := Prompter 
		prompt: 'Enter a new class name:'
		caption: 'Add subclass'.
	(subclassName isNil or: [subclassName isEmpty])
		ifTrue: [^self].
	(PstParser isValidIdentifier: subclassName)
		ifFalse: [^MessageBox notify: subclassName printString, ' is not a valid
class name.'].
	(self classLibrary hasClassNamed: subclassName)
		ifTrue: [^MessageBox notify: 'There is already a class named ', subclassName, '.'].
	PstClassDefiner new define: (self selectedClass
		definitionForNewSubclass: subclassName).
	self selectClassNamed: subclassName.!

blankRichText
	^self richTextFor: String new.!

browseImplementors
	PstMethodListBrowser showImplementorsOf:
		self selectedMethod selector.!

browseReferencesToClass
	PstMethodListBrowser showMethodsReferringTo: 
		self selectedClass.!

browseReferencesToClassVariable
	| cls varNames varName |
	cls := self selectedClass.
	varNames := cls visibleClassVariableNames.
	varNames isEmpty
		ifTrue: [^MessageBox notify: 'No class variables are visible from ', cls name, '.'].
	varName := ListPrompter
		list: varNames
		caption: 'Select an class variable'.
	varName isNil ifTrue: [^self].
	PstMethodListBrowser
		showMethodsReferringToSharedVariable: varName.!

browseReferencesToInstanceVariable
	| cls instVarName |
	cls := self selectedClass.
	cls allInstVarNames isEmpty
		ifTrue: [^MessageBox notify: cls name, ' defines no instance variables.'].
	instVarName := ListPrompter
		list: cls allInstVarNames
		caption: 'Select an instance variable'.
	instVarName isNil ifTrue: [^self].
	PstMethodListBrowser
		showMethodsOf: cls
		referringToInstanceVariable: instVarName.!

browseSenders
	PstMethodListBrowser showSendersOf:
		self selectedMethod selector.!

canBrowseMetaclasses
	^true.!

categorize
	| category |
	(self selectedMethod isNil
			and: [self selectedCategory notNil])
		ifTrue: [^self renameCategory].
	category := PstSystem lastArgumentFor: #categorize.
	category := Prompter
		on: category
		prompt: 'Which category?'
		caption: 'Categorize'.
	(category isNil or: [category isEmpty]) ifTrue: [^self].
	category := self filterCategory: category.
	category isEmpty ifTrue: [^self].
	PstSystem lastArgumentFor: #categorize put: category.
	self classForMethods
		reclassify: self selectedMethod
		as: category.!

changeClassPackage
	| package |
	package := PstPackage choose.
	package isNil ifTrue: [^self].
	self selectedClass package: package.!

changeMethodPackage
	| package |
	package := PstPackage choose.
	package isNil ifTrue: [^self].
	self selectedMethod package: package.!

checkClassRefsForDelete: cls
	| methods stream |
	methods := PstClassLibrary current
			methodsReferencingClassNamed: cls name.
	methods isEmpty ifTrue: [
		MessageBox notify: 'No methods referenced ', cls name, ', so
deleting it will not cause problems.'.
		^true].
	stream := String new writeStream.
	stream
		print: methods size;
		nextPutAll: ' method';
		nextPutAll: (methods size = 1 ifTrue: [''] ifFalse: ['s']);
		nextPutAll: ' referenced ';
		nextPutAll: cls name;
		nextPut: $.;
		cr;
		nextPutAll: 'Do you want to browse ';
		nextPutAll: (methods size = 1
			ifTrue: ['that method']
			ifFalse: ['those methods']);
		nextPutAll: ' now?'.
	^(MessageBox confirm: stream contents) 
		ifTrue: [
			PstMethodListBrowser
				showMethodsReferencingClassNamed: cls name.
			true]
		ifFalse: [
			(MessageBox confirm: 'Do you want to cancel the deletion of ', cls name, '?') not].!

classForMethods
	"Answer the class that methods are to be taken from (or added to).  This is just the selected class, or the selected class's metaclass, depending on the 'side' we are looking at."
	"This may answer nil, like #selectedClass."
	| class |
	class := self selectedClass.
	class isNil ifTrue: [^nil].
	^self side == #instance
		ifTrue: [class]
		ifFalse: [class qclass].!

classLibrary
	^PstClassLibrary current.!

classSide
	sideList selectionByIndex: 2.!

clearStatus
	statusModel value: ''.!

completeSelector
	Transcript show: 'completing...'; cr.!

createComponents
	super createComponents.
	classTree := self
		add: TreePresenter new
		name: 'classTree'.
	methodTree := self
		add: TreePresenter new
		name: 'methodTree'.
	sourceCode := self
		add: PstSourceCodePresenter new
		name: 'sourceCode'.
	modeList := self
		add: ListPresenter new
		name: 'modeList'.
	self canBrowseMetaclasses ifTrue: [
		sideList := self
			add: ListPresenter new
			name: 'classSide'].!

createSchematicWiring
	| statusItem |
	super createSchematicWiring.
	self
		when: #closeRequested:
		send: #onCloseRequested:
		to: self.
	self hookupToModel.
	modeList list: self modeListChoices.
	self canBrowseMetaclasses ifTrue: [
		sideList list: self sideListChoices.
		sideList
			when: #selectionChanged
			send: #onSideChanged
			to: self.
		sideList
			when: #selectionChanging:
			send: #promptToSaveChanges:
			to: self].
	self updateClassTree.
	modeList
		when: #selectionChanged
		send: #onModeChanged
		to: self.
	modeList
		when: #selectionChanging:
		send: #promptToSaveChanges:
		to: self.
	classTree
		when: #selectionChanged
		send: #onSelectedClassChanged
		to: self.
	classTree
		when: #selectionChanging:
		send: #promptToSaveChanges:
		to: self.
	methodTree
		when: #selectionChanged
		send: #onSelectedMethodChanged
		to: self.
	methodTree
		when: #selectionChanging:
		send: #promptToSaveChanges:
		to: self.
	methodTree
		when: #actionPerformed
		send: #onMethodDoubleClicked
		to: self.
	sourceCode
		when: #completeSelector
		send: #completeSelector
		to: self.
	statusModel := ValueHolder with: String new.
	statusItem := (self view viewNamed: 'status')
		addItem: StatusItem new.
	statusItem model: statusModel.
	statusItem getImageBlock: [:blah | nil].
	"statusItem imageManager: nil."
	self updateFonts.!

currentClassString
	"Always display the class definition even when looking at the metaclass."
	^self richTextFor: self selectedClass definition.!

currentCommentString
	^self richTextFor: (self selectedClass comment isNil
		ifTrue: [String new]
		ifFalse: [self selectedClass comment]).!

currentDisassemblyString
	^self richTextFor: (self selectedMethod isNil
		ifTrue: ['[No method selected]']
		ifFalse: [self selectedMethod disassembly]).!

currentSourceString
	^self selectedMethod isNil 
		ifTrue: [self blankRichText]
		ifFalse: [self selectedMethod richTextSource].!

delete
	| category |
	self selectedMethod isNil 
		ifTrue: [^self deleteCategory].
	(MessageBox confirm: 'Really delete #', self selectedMethod selector, '?')
		ifFalse: [^self].
	category := self selectedMethod category.
	self selectedMethod package: nil.
	self classForMethods removeSelector: 
		self selectedMethod selector.
	(methodTree model includes: category) ifTrue: [
		methodTree 
			selection: category;
			expand: category].
!

deleteCategory
	| category |
	category := self selectedCategory.
	category isNil ifTrue: [
		(MessageBox confirm: 'Really delete all the methods in this class?')
			ifFalse: [^self].
		^self classForMethods removeAllCategories].
	(MessageBox confirm: 'Really delete all the methods
in category ', category printString, '?')
		ifFalse: [^self].
	self classForMethods removeCategory: category.!

deleteClass
	| cls |
	cls := self selectedClass.
	(MessageBox confirm: 'Really delete ', cls name, '?')
		ifFalse: [^self].
	(self checkClassRefsForDelete: cls)
		ifFalse: [^self].
	self classLibrary removeClass: cls ifFail: [:reason |
		^MessageBox notify: cls name, ' cannot be removed because
', reason, '.'].!

detachFromModel
	PstClassLibrary current removeEventsTriggeredFor: self.!

dirty
	"^self textHasBeenChanged."
	^sourceCode view isModified.!

disableSourcePane
	sourceCode view isReadOnly: true.!

doIt
	sourceCode doItFor: self receiverForEvaluations.!

enableSourcePane
	sourceCode view isReadOnly: false.!

filterCategory: category
	^category reject: [:each |
		each == $( or: [each == $)
			or: [each == $']]].!

findClass
	| string classes class |
	string := Prompter
		on: (PstSystem lastArgumentFor: #findClass)
		prompt: 'Find which class?'
		caption: 'Find Class'.
	(string isNil or: [string isEmpty]) ifTrue: [^self].
	PstSystem lastArgumentFor: #findClass put: string.
	classes := (self classLibrary classesMatching: string)
		asSortedCollection: [:left :right |
			left name <= right name].
	classes isEmpty ifTrue: [
		^MessageBox notify: 'There is no class matching ', 
			string printString, '.'].
	class := classes size = 1
		ifTrue: [classes first]
		ifFalse: [
			ListPrompter
				list: classes
				caption: 'Which one did you mean?'].
	class isNil ifTrue: [^self].
	(classTree model includes: class)
		ifTrue: [classTree selection: class].!

hookupToModel
	| library |
	library := PstClassLibrary current.
	library
		when: #addedMethod:to:
		send: #onAddedMethod:to:
		to: self.
	library
		when: #removedMethod:from:
		send: #onRemovedMethod:from:
		to: self.
	library
		when: #reclassifiedMethod:of:
		send: #onReclassifiedMethod:of:
		to: self.
	library
		when: #changedShape:
		send: #onChangedShape:
		to: self.
	library
		when: #addedClass:
		send: #onAddedClass:
		to: self.
	library
		when: #removedClass:
		send: #onRemovedClass:
		to: self.
	library
		when: #changedSuperclassOf:
		send: #onChangedSuperclassOf:
		to: self.
	library
		when: #changedNameOf:
		send: #onChangedNameOf:
		to: self.
	library
		when: #recompiledBehavior:
		send: #onRecompiledBehavior:
		to: self.!

inspectIt
	sourceCode inspectItFor: self receiverForEvaluations.!

instanceSide
	sideList selectionByIndex: 1.!

mode
	^self modeSymbols
		at: (self modeListChoices
			indexOf: modeList selectionOrNil).!

modeListChoices
	^#('Source' 'Class' 'Disassembly' 'Comment').!

modeSymbols
	^#(source class disassembly comment).!

newMethod
	modeList selection: self modeListChoices first.
	sourceCode value: String new.
	sourceCode setFocus.!

onAddedClass: qclass
	self updateClassTree.!

onAddedMethod: method to: class
	class == self classForMethods
		ifTrue: [self updateMethodTree].!

onChangedNameOf: cls
	classTree model refresh: cls.!

onChangedShape: cls
	cls == self selectedClass
		ifTrue: [self updateSourcePane].!

onChangedSuperclassOf: class
	self updateClassTree.!

onCloseRequested: valueHolder
	self detachFromModel.!

onMethodDoubleClicked
	self selectedMethod isNil ifFalse: [
		self selectMethodNamed: self selectedMethod selector].!

onModeChanged
	self updateSourcePane.!

onReclassifiedMethod: method of: class
	class == self classForMethods
		ifTrue: [self updateMethodTree].!

onRecompiledBehavior: behavior
	behavior == self classForMethods
		ifTrue: [self updateMethodTree].!

onRemovedClass: qclass
	classTree model remove: qclass.!

onRemovedMethod: method from: class
	class == self classForMethods
		ifTrue: [self updateMethodTree].!

onSelectedClassChanged
	"Automatically select the 'class' pane."
	modeList selection = 'Comment' ifFalse: [
		modeList selection: (self modeListChoices
			detect: [:each | each = 'Class'])].
	self clearStatus.
	self updateSourcePane.
	self updateMethodTree.!

onSelectedMethodChanged
	"Make sure the 'source' pane is selected."
	self clearStatus.
	kludge := self selectedMethod.
	self selectedMethod isNil ifFalse: [
		modeList selection: (self modeListChoices
			detect: [:each | each = 'Source'])].
	self updateSourcePane.!

onSideChanged
	self clearStatus.
	self updateMethodTree.!

printIt
	sourceCode printItFor: self receiverForEvaluations.!

promptToSaveChanges
	"Answer false if it's OK to change panes."
	| val |
	^self dirty
		ifTrue: [
			"why is this hack necessary?"
			val := (MessageBox confirm: 'Discard changes?') not.
			sourceCode view isModified: true.
			^val]
		ifFalse: [
			sourceCode view isModified: false.
			false].!

promptToSaveChanges: valueHolder
	valueHolder value: self promptToSaveChanges not.
	^valueHolder value.!

queryCommand: commandQuery
	| sym |
	super queryCommand: commandQuery.
	sym := commandQuery command.
	sym == #accept
		ifTrue: [commandQuery enabled: 
			(self selectedClass notNil 
				and: [#(source class comment) includes: self mode])].
	(#(deleteMethod browseSenders browseImplementors changeMethodPackage) 
			includes: sym)
		ifTrue: [commandQuery enabled: self selectedMethod notNil].
	(sym == #quickCategorize or: [sym == #categorize])
		ifTrue: [commandQuery enabled:
			(self selectedMethod notNil 
				or: [self selectedCategory notNil])].
	(#(addSubclass fileOut fileOutHierarchy deleteClass recompileClass recompileHierarchy browseReferencesToClass browseReferencesToInstanceVariable changeClassPackage) 
			includes: sym)
		ifTrue: [commandQuery enabled: self selectedClass notNil].!

quickCategorize
	| category categories |
	self selectedMethod isNil ifTrue: [
		^(MessageBox confirm: 'Recategorize all methods
in category ', self selectedCategory printString, '?')
			ifTrue: [self quickCategorizeCategory]
			ifFalse: [self]].
	category := self classForMethods 
		preferredCategoryOf: self selectedMethod selector.
	categories := self class commonCategories.
	category isNil ifFalse: [
		categories := (Array with: category), categories].
	category := ListPrompter
		list: categories
		caption: 'Categorize'.
	(category isNil or: [category isEmpty]) ifTrue: [^self].
	PstSystem lastArgumentFor: #categorize put: category.
	self classForMethods
		reclassify: self selectedMethod
		as: category.!

quickCategorizeCategory
	| classForMethods category |
	classForMethods := self classForMethods.
	(classForMethods methodsInCategory: 
			self selectedCategory) copy do: [:method |
		category := classForMethods
			preferredCategoryOf: method selector.
		category isNil ifFalse: [
			self classForMethods
				reclassify: method
				as: category]].!

receiverForEvaluations
	^self selectedClass isNil
		ifTrue: [PstBasicObject forNil]
		ifFalse: [self classForMethods].!

recompileClass
	Cursor wait showWhile: [
		self selectedClass safelyRecompile].!

recompileHierarchy
	Cursor wait showWhile: [
		self selectedClass safelyRecompileHierarchy].!

renameCategory
	| category |
	category := Prompter
		on: self selectedCategory
		prompt: 'New name for category?'
		caption: 'Rename Category'.
	(category isNil or: [category isEmpty]) ifTrue: [^self].
	category = self selectedCategory ifTrue: [^self].
	self classForMethods
		renameCategory: self selectedCategory
		to: category.!

richTextFor: string
	| converter |
	converter := RichText rtfConverter.
	converter font: PstSystem current defaultFont.
	converter text: string.
	^converter richText.!

selectClassNamed: className
	(self classLibrary hasClassNamed: className)
		ifTrue: [classTree selection: (self classLibrary classNamed: className)].!

selectedCategory
	| selection tree category |
	selection := methodTree selectionOrNil.
	selection isNil ifTrue: [^nil].
	tree := methodTree model.
	category := (tree parentOf: selection) 
		orIfNil: [selection].
	^category = '(all)'
		ifTrue: [nil]
		ifFalse: [category].!

selectedClass
	^classTree selectionOrNil.!

selectedMethod
	| sel |
	sel := methodTree selectionOrNil.
	sel isNil ifTrue: [^nil].
	^sel class == String  "category?"
		ifTrue: [nil]
		ifFalse: [sel actualMethod].!

selectMethodNamed: selector
	| tree |
	tree := methodTree model.
	tree do: [:each |
		(each class ~~ String
			and: [each isQuasi not
				and: [each selector = selector]])
			ifTrue: [^methodTree selection: each]].!

side
	"Answer whether we are looking at the #instance or #class side."
	| selection |
	selection := sideList selection.
	^selection == self sideListChoices first
		ifTrue: [#instance]
		ifFalse: [#class].!

sideListChoices
	^#('Instance' 'Class').!

sourceString
	^sourceCode view plainText.!

statusMessage: string
	statusModel value: string.!

system
	^PstSystem current.!

textHasBeenChanged
	"Answer whether the source text has been changed from the original."
	"This is used rather than #isModified because #isModified is not reliable."
	| mode text |
	mode := self mode.
	text := sourceCode view plainText.
	text isEmpty ifTrue: [^false].  "special case"
	mode == #source ifTrue: [
		^kludge isNil
			ifTrue: [text notEmpty]
			ifFalse: [kludge sourceCode ~= text]].
	mode == #class ifTrue: [
		^self selectedClass isNil
			ifTrue: [text notEmpty]
			ifFalse: [self selectedClass definition ~= text]].
	mode == #comment ifTrue: [
		^self selectedClass isNil
			ifTrue: [text notEmpty]
			ifFalse: [(self selectedClass comment orIfNil: [String new])
				~= text]].
	^false.!

updateClassTree
	| oldSelection |
	oldSelection := self selectedClass isNil
		ifTrue: [nil]
		ifFalse: [self selectedClass name].
	classTree model: PstClassLibrary current classTree.
	PstClassLibrary current roots do: [:each |
		classTree expand: each].
	self selectClassNamed: oldSelection.!

updateFonts
	| b |
	b := [:presenter |
		presenter isNil ifFalse: [
			presenter view font: self system defaultFont]].
	b 
		value: sourceCode;
		value: classTree;
		value: methodTree;
		value: modeList;
		value: sideList.!

updateMethodTree
	| tree selector |
	selector := self selectedMethod isNil
		ifTrue: [nil]
		ifFalse: [self selectedMethod selector].
	tree := self classForMethods isNil
		ifTrue: [TreeModel new]
		ifFalse: [self classForMethods methodTree].
	methodTree model: tree.
	selector isNil ifFalse: [self selectMethodNamed: selector].!

updateSourcePane
	| mode string |
	self selectedClass isNil ifTrue: [
		self disableSourcePane.
		^sourceCode value: String new].
	mode := self mode.
	(#(source class comment) includes: mode)
		ifTrue: [self enableSourcePane]
		ifFalse: [self disableSourcePane].
	mode == #source ifTrue: [string := self currentSourceString].
	mode == #class ifTrue: [string := self currentClassString].
	mode == #disassembly ifTrue: [string := self currentDisassemblyString].
	mode == #comment ifTrue: [string := self currentCommentString].
	sourceCode setValue: string.
	sourceCode view refreshContents.! !
!PstClassBrowser categoriesFor: #accept!actions!public! !
!PstClassBrowser categoriesFor: #acceptClass!actions!public! !
!PstClassBrowser categoriesFor: #acceptComment!actions!public! !
!PstClassBrowser categoriesFor: #acceptSource!actions!public! !
!PstClassBrowser categoriesFor: #addSubclass!actions!public! !
!PstClassBrowser categoriesFor: #blankRichText!public!utility! !
!PstClassBrowser categoriesFor: #browseImplementors!actions!public! !
!PstClassBrowser categoriesFor: #browseReferencesToClass!actions!public! !
!PstClassBrowser categoriesFor: #browseReferencesToClassVariable!actions!public! !
!PstClassBrowser categoriesFor: #browseReferencesToInstanceVariable!actions!public! !
!PstClassBrowser categoriesFor: #browseSenders!actions!public! !
!PstClassBrowser categoriesFor: #canBrowseMetaclasses!predicates!public! !
!PstClassBrowser categoriesFor: #categorize!actions!public! !
!PstClassBrowser categoriesFor: #changeClassPackage!actions!public! !
!PstClassBrowser categoriesFor: #changeMethodPackage!actions!public! !
!PstClassBrowser categoriesFor: #checkClassRefsForDelete:!actions!public! !
!PstClassBrowser categoriesFor: #classForMethods!accessing!public! !
!PstClassBrowser categoriesFor: #classLibrary!accessing!public! !
!PstClassBrowser categoriesFor: #classSide!actions!public! !
!PstClassBrowser categoriesFor: #clearStatus!public!utility! !
!PstClassBrowser categoriesFor: #completeSelector!public!utility! !
!PstClassBrowser categoriesFor: #createComponents!initialization!public! !
!PstClassBrowser categoriesFor: #createSchematicWiring!initialization!public! !
!PstClassBrowser categoriesFor: #currentClassString!public!updating! !
!PstClassBrowser categoriesFor: #currentCommentString!public!updating! !
!PstClassBrowser categoriesFor: #currentDisassemblyString!public!updating! !
!PstClassBrowser categoriesFor: #currentSourceString!public!updating! !
!PstClassBrowser categoriesFor: #delete!actions!public! !
!PstClassBrowser categoriesFor: #deleteCategory!actions!public! !
!PstClassBrowser categoriesFor: #deleteClass!actions!public! !
!PstClassBrowser categoriesFor: #detachFromModel!initialization!public! !
!PstClassBrowser categoriesFor: #dirty!accessing!public! !
!PstClassBrowser categoriesFor: #disableSourcePane!public!updating! !
!PstClassBrowser categoriesFor: #doIt!evaluating!public! !
!PstClassBrowser categoriesFor: #enableSourcePane!public!updating! !
!PstClassBrowser categoriesFor: #filterCategory:!public!utility! !
!PstClassBrowser categoriesFor: #findClass!actions!public! !
!PstClassBrowser categoriesFor: #hookupToModel!initialization!public! !
!PstClassBrowser categoriesFor: #inspectIt!evaluating!public! !
!PstClassBrowser categoriesFor: #instanceSide!actions!public! !
!PstClassBrowser categoriesFor: #mode!accessing!public! !
!PstClassBrowser categoriesFor: #modeListChoices!accessing!public! !
!PstClassBrowser categoriesFor: #modeSymbols!accessing!public! !
!PstClassBrowser categoriesFor: #newMethod!actions!public! !
!PstClassBrowser categoriesFor: #onAddedClass:!event handling!public! !
!PstClassBrowser categoriesFor: #onAddedMethod:to:!event handling!public! !
!PstClassBrowser categoriesFor: #onChangedNameOf:!event handling!public! !
!PstClassBrowser categoriesFor: #onChangedShape:!event handling!public! !
!PstClassBrowser categoriesFor: #onChangedSuperclassOf:!event handling!public! !
!PstClassBrowser categoriesFor: #onCloseRequested:!event handling!public! !
!PstClassBrowser categoriesFor: #onMethodDoubleClicked!event handling!public! !
!PstClassBrowser categoriesFor: #onModeChanged!event handling!public! !
!PstClassBrowser categoriesFor: #onReclassifiedMethod:of:!event handling!public! !
!PstClassBrowser categoriesFor: #onRecompiledBehavior:!event handling!public! !
!PstClassBrowser categoriesFor: #onRemovedClass:!event handling!public! !
!PstClassBrowser categoriesFor: #onRemovedMethod:from:!event handling!public! !
!PstClassBrowser categoriesFor: #onSelectedClassChanged!event handling!public! !
!PstClassBrowser categoriesFor: #onSelectedMethodChanged!event handling!public! !
!PstClassBrowser categoriesFor: #onSideChanged!event handling!public! !
!PstClassBrowser categoriesFor: #printIt!evaluating!public! !
!PstClassBrowser categoriesFor: #promptToSaveChanges!event handling!public! !
!PstClassBrowser categoriesFor: #promptToSaveChanges:!event handling!public! !
!PstClassBrowser categoriesFor: #queryCommand:!actions!public!updating! !
!PstClassBrowser categoriesFor: #quickCategorize!actions!public! !
!PstClassBrowser categoriesFor: #quickCategorizeCategory!actions!public! !
!PstClassBrowser categoriesFor: #receiverForEvaluations!evaluating!public! !
!PstClassBrowser categoriesFor: #recompileClass!actions!public! !
!PstClassBrowser categoriesFor: #recompileHierarchy!actions!public! !
!PstClassBrowser categoriesFor: #renameCategory!actions!public! !
!PstClassBrowser categoriesFor: #richTextFor:!public!utility! !
!PstClassBrowser categoriesFor: #selectClassNamed:!public!utility! !
!PstClassBrowser categoriesFor: #selectedCategory!accessing!public! !
!PstClassBrowser categoriesFor: #selectedClass!accessing!public! !
!PstClassBrowser categoriesFor: #selectedMethod!accessing!public! !
!PstClassBrowser categoriesFor: #selectMethodNamed:!public!utility! !
!PstClassBrowser categoriesFor: #side!accessing!public! !
!PstClassBrowser categoriesFor: #sideListChoices!accessing!public! !
!PstClassBrowser categoriesFor: #sourceString!accessing!public! !
!PstClassBrowser categoriesFor: #statusMessage:!public!utility! !
!PstClassBrowser categoriesFor: #system!accessing!public! !
!PstClassBrowser categoriesFor: #textHasBeenChanged!public!utility! !
!PstClassBrowser categoriesFor: #updateClassTree!public!updating! !
!PstClassBrowser categoriesFor: #updateFonts!public!updating! !
!PstClassBrowser categoriesFor: #updateMethodTree!public!updating! !
!PstClassBrowser categoriesFor: #updateSourcePane!public!updating! !

!PstClassBrowser class methodsFor!

browse: method
	| shell |
	shell := self show.
	shell selectClassNamed: method ownerClass name.
	shell selectMethodNamed: method selector.!

browseClass: class
	| shell |
	shell := self show.
	class isMeta
		ifTrue: [
			shell classSide.
			shell selectClassNamed: class uniqueInstance name]
		ifFalse: [
			shell instanceSide.
			shell selectClassNamed: class name].
	^shell.!

browseMethod: method
	| shell |
	shell := self browseClass: method ownerClass.
	shell selectMethodNamed: method selector.
	^shell.!

commonCategories
	^#('accessing' 'comparing' 'converting' 'initialization' 'instance creation' 'predicates' 'printing' 'private' 'utility').!

defaultView
	^'Default view'.! !
!PstClassBrowser class categoriesFor: #browse:!public!utility! !
!PstClassBrowser class categoriesFor: #browseClass:!public!utility! !
!PstClassBrowser class categoriesFor: #browseMethod:!public!utility! !
!PstClassBrowser class categoriesFor: #commonCategories!accessing!public! !
!PstClassBrowser class categoriesFor: #defaultView!defaults!public! !



PstConstantsBrowser comment: ''!

PstConstantsBrowser guid: (GUID fromString: '{812CFB02-B11E-4A02-8CA8-A2BEB862E61F}')!

!PstConstantsBrowser categoriesForClass!No category! !
!PstConstantsBrowser methodsFor!

accept
	| object |
	object := PstSmalltalkParser
		parseSimpleLiteral: self sourceString.
	object isNil ifTrue: [
		^MessageBox notify: 'Constants can only have simple literal values.'].
	self selectedConstant value: object.!

addCategory
	| string |
	string := Prompter
		prompt: 'Name for new category?'
		caption: 'Add Category'.
	(string isNil or: [string isEmpty]) ifTrue: [^self].
	(self model hasCategoryNamed: string)
		ifTrue: [^MessageBox notify: 'There is already a category with that name.'].
	self model addCategoryNamed: string.
	self selectCategoryNamed: string.!

addGeosLibrary
	| filename name |
	filename := FileOpenDialog new
		fileTypes: (Array
			with: #('GEOS Dynamic Libraries (*.geo)' '*.geo')
			with: #('GEOS Library Definition (*.ldf)' '*.ldf')
			with: FileDialog allFilesType);
		caption: 'Select Geos Library';
		defaultExtension: 'geo';
		showModal.
	(filename isNil or: [filename isEmpty]) ifTrue: [^self].
	self model ensureCategoryExists: 'Geos Libraries'.
	name := self model nextGeosLibraryConstantName.
	self model
		define: name
		as: (PstByteIndexableObject newString: filename)
		classified: 'Geos Libraries'.
	self selectConstant: (self model constantNamed: name).!

addResourceDatabase
	| filename name |

	filename := FileOpenDialog new
		fileTypes: (Array
			with: #('PalmOS Resource Databases (*.prc)' '*.prc')
			with: #('PalmOS Resources (*.bin)' '*.bin')
			with: FileDialog allFilesType);
		caption: 'Select Resource Database';
		defaultExtension: 'prc';
		showModal.
	(filename isNil or: [filename isEmpty]) ifTrue: [^self].
	self model ensureCategoryExists: 'Resource Databases'.
	name := self model nextResourceDBConstantName.
	self model
		define: name
		as: (PstByteIndexableObject newString: filename)
		classified: 'Resource Databases'.
	self selectConstant: (self model constantNamed: name).!

browseReferencesToConstant
	PstMethodListBrowser showMethodsReferringToConstant:
		self selectedConstant.!

categorizeConstant
	| category constant |
	constant := self selectedConstant.
	category := ListPrompter
		on: constant category
		list: self model categoryNames
		caption: 'Select a Category'.
	category isNil ifTrue: [^self].
	self model reclassify: constant name as: category.
	self selectConstant: constant.!

changePackage
	| package constant |
	constant := self selectedConstant.
	package := PstPackage choose.
	package isNil ifTrue: [^self].
	constant package: package.!

checkConstantRefs: constant for: reason
	| methods stream |
	methods := PstClassLibrary current
			methodsReferringToConstant: constant.
	methods isEmpty ifTrue: [
		MessageBox notify: 'No methods referenced ', constant displayString, 
			', so ', reason, ' it will not cause problems.'.
		^true].
	stream := String new writeStream.
	stream
		print: methods size;
		nextPutAll: ' method';
		nextPutAll: (methods size = 1 ifTrue: [''] ifFalse: ['s']);
		nextPutAll: ' referenced ';
		nextPutAll: constant displayString;
		nextPut: $.;
		cr;
		nextPutAll: 'Do you want to browse ';
		nextPutAll: (methods size = 1
			ifTrue: ['that method']
			ifFalse: ['those methods']);
		nextPutAll: ' now?'.
	^(MessageBox confirm: stream contents) 
		ifTrue: [
			PstMethodListBrowser
				showMethodsReferringToConstant: constant.
			true]
		ifFalse: [
			(MessageBox confirm: 'Do you want to cancel the ', reason, ' of constant ', constant displayString, '?') not].!

createComponents
	super createComponents.
	categoryList := self
		add: ListPresenter new
		name: 'categories'.
	constantsList := self
		add: ListPresenter new
		name: 'constants'.
	sourceCode := self
		add: PstSourceCodePresenter new
		name: 'source'.!

createSchematicWiring
	| statusItem |
	super createSchematicWiring.
	self
		when: #closeRequested:
		send: #onCloseRequested:
		to: self.
	categoryList
		when: #selectionChanged
		send: #updateConstantsList
		to: self.
	constantsList
		when: #selectionChanged
		send: #onSelectedConstantChanged
		to: self.
	self hookupToModel.
	statusModel := ValueHolder with: String new.
	statusItem := (self view viewNamed: 'status')
		addItem: StatusItem new.
	statusItem model: statusModel.
	statusItem getImageBlock: [:blah | nil].
	sourceCode view font: PstSystem current defaultFont.
	self updateCategories.!

deleteCategory
	| category constants |
	category := self selectedCategory.
	constants := (self model categoryNamed: category) copy.
	constants isEmpty ifFalse: [
		(MessageBox confirm: 'Really delete the ',
			(constants size = 1 ifTrue: ['constant']
				ifFalse: [constants size printString, ' constants']),
				' in this category?')
			ifFalse: [^self]].
	constants do: [:constant |
		(self checkConstantRefs: constant  for: 'deleting')
			ifFalse: [^self].
		self model removeConstantNamed: constant name].
	(self model categoryNamed: category) isEmpty
		ifTrue: [self model removeCategory: category].!

deleteConstant
	| constant |
	constant := self selectedConstant.
	(MessageBox confirm: 'Really delete ', constant displayString, '?')
		ifFalse: [^self].
	(self checkConstantRefs: constant for: 'deleting')
		ifFalse: [^self].
	self model removeConstantNamed: constant name.!

detachFromModel
	self model removeEventsTriggeredFor: self.!

findConstant
	| name constant |
	name := Prompter
		prompt: 'Name of constant to find?'
		caption: 'Find Constant'.
	(name isNil or: [name isEmpty]) ifTrue: [^self].
	name := self fixConstantName: name.
	constant := self model findConstant: name, '*'.
	constant isNil
		ifTrue: [MessageBox notify: 'There is no constant with that name.']
		ifFalse: [self selectConstant: constant].!

fixConstantName: string
	^string reject: [:each | each == $#].!

hookupToModel
	self model
		when: #organizationChanged
		send: #updateCategories
		to: self.
	self model
		when: #categoryChanged:
		send: #onCategoryChanged:
		to: self.
	self model
		when: #constantChanged:
		send: #onConstantChanged:
		to: self.!

newConstant
	| string |
	string := Prompter
		prompt: 'Name for new constant?'
		caption: 'New Constant'.
	(string isNil or: [string isEmpty]) ifTrue: [^self].
	string := self fixConstantName: string.
	(PstConstant isValidConstantName: string)
		ifFalse: [^MessageBox notify: string printString, ' is not a valid name for a constant.'].
	(self model hasConstantNamed: string)
		ifTrue: [^MessageBox notify: 'There is already a constant with that name.'].
	self model
		define: string
		as: PstBasicObject forNil
		classified: self selectedCategory.
	self selectConstant: (self model constantNamed: string).!

onCategoryChanged: categoryName
	(self selectedCategory notNil
			and: [self selectedCategory = categoryName])
		ifTrue: [self updateConstantsList].!

onCloseRequested: valueHolder
	self detachFromModel.!

onConstantChanged: constant
	constant == self selectedConstant ifTrue: [
		self updateSourceCode.
		self updateConstantPackage].!

onSelectedConstantChanged
	self updateSourceCode.
	self updateConstantPackage.!

queryCommand: commandQuery
	super queryCommand: commandQuery.
	(#(newConstant deleteCategory renameCategory) 
			includes: commandQuery command)
		ifTrue: [commandQuery enabled: self selectedCategory notNil].
	(#(accept deleteConstant browseReferencesToConstant categorizeConstant changePackage)
			includes: commandQuery command)
		ifTrue: [commandQuery enabled: self selectedConstant notNil].!

renameCategory
	| category newName |
	category := self selectedCategory.
	newName := Prompter
		on: category
		prompt: 'New name for category?'
		caption: 'Rename Category'.
	(newName isNil or: [newName isEmpty]) ifTrue: [^self].
	(self model hasCategoryNamed: newName)
		ifTrue: [^MessageBox notify: 'There is already a category named ', newName printString, '.'].
	self model renameCategory: category to: newName.
	self selectCategoryNamed: newName.!

selectCategoryNamed: categoryName
	categoryList selection: (categoryList list
		detect: [:each | each = categoryName]
		ifNone: [^self]).	!

selectConstant: constant
	self selectCategoryNamed: constant category.
	constantsList selection: constant.!

selectedCategory
	^categoryList selectionOrNil.!

selectedConstant
	^constantsList selectionOrNil.!

sourceString
	^sourceCode view plainText.!

updateCategories
	categoryList list: self model categoryNames.!

updateConstantPackage
	| constant |
	constant := self selectedConstant.
	constant isNil ifTrue: [^statusModel value: ''].
	statusModel value: (constant package isUncommitted
		ifTrue: [constant displayString, ' in no package']
		ifFalse: [constant displayString, ' in package ', constant package displayString]).
!

updateConstantsList
	constantsList list:
		(self selectedCategory isNil
			ifTrue: [#()]
			ifFalse: [self model categoryNamed: self selectedCategory])
				copy "defeat Dolphin 'optimization'".!

updateSourceCode
	| string |
	string := self selectedConstant isNil
		ifTrue: [String new]
		ifFalse: [self selectedConstant value displayString].
	sourceCode value: string.! !
!PstConstantsBrowser categoriesFor: #accept!actions!public! !
!PstConstantsBrowser categoriesFor: #addCategory!actions!public! !
!PstConstantsBrowser categoriesFor: #addGeosLibrary!*-unclassified!public! !
!PstConstantsBrowser categoriesFor: #addResourceDatabase!actions!public! !
!PstConstantsBrowser categoriesFor: #browseReferencesToConstant!actions!public! !
!PstConstantsBrowser categoriesFor: #categorizeConstant!actions!public! !
!PstConstantsBrowser categoriesFor: #changePackage!actions!public! !
!PstConstantsBrowser categoriesFor: #checkConstantRefs:for:!public!utility! !
!PstConstantsBrowser categoriesFor: #createComponents!initialization!public! !
!PstConstantsBrowser categoriesFor: #createSchematicWiring!initialization!public! !
!PstConstantsBrowser categoriesFor: #deleteCategory!actions!public! !
!PstConstantsBrowser categoriesFor: #deleteConstant!actions!public! !
!PstConstantsBrowser categoriesFor: #detachFromModel!initialization!public! !
!PstConstantsBrowser categoriesFor: #findConstant!actions!public! !
!PstConstantsBrowser categoriesFor: #fixConstantName:!public!utility! !
!PstConstantsBrowser categoriesFor: #hookupToModel!initialization!public! !
!PstConstantsBrowser categoriesFor: #newConstant!actions!public! !
!PstConstantsBrowser categoriesFor: #onCategoryChanged:!event handling!public! !
!PstConstantsBrowser categoriesFor: #onCloseRequested:!event handling!public! !
!PstConstantsBrowser categoriesFor: #onConstantChanged:!event handling!public! !
!PstConstantsBrowser categoriesFor: #onSelectedConstantChanged!event handling!public! !
!PstConstantsBrowser categoriesFor: #queryCommand:!actions!public! !
!PstConstantsBrowser categoriesFor: #renameCategory!actions!public! !
!PstConstantsBrowser categoriesFor: #selectCategoryNamed:!public!utility! !
!PstConstantsBrowser categoriesFor: #selectConstant:!public!utility! !
!PstConstantsBrowser categoriesFor: #selectedCategory!accessing!public! !
!PstConstantsBrowser categoriesFor: #selectedConstant!accessing!public! !
!PstConstantsBrowser categoriesFor: #sourceString!accessing!public! !
!PstConstantsBrowser categoriesFor: #updateCategories!public!updating! !
!PstConstantsBrowser categoriesFor: #updateConstantPackage!public!utility! !
!PstConstantsBrowser categoriesFor: #updateConstantsList!public!updating! !
!PstConstantsBrowser categoriesFor: #updateSourceCode!public!updating! !

!PstConstantsBrowser class methodsFor!

browse: constant
	| shell |
	shell := self show.
	shell selectConstant: constant.
	^shell.!

defaultModel
	^PstConstantsLibrary current.!

defaultView
	^'Default view'.! !
!PstConstantsBrowser class categoriesFor: #browse:!public!utility! !
!PstConstantsBrowser class categoriesFor: #defaultModel!defaults!public! !
!PstConstantsBrowser class categoriesFor: #defaultView!defaults!public! !



PstDebugger comment: ''!

PstDebugger guid: (GUID fromString: '{72DABC87-8ECC-47CC-B896-E6E21F728E1C}')!

!PstDebugger categoriesForClass!No category! !
!PstDebugger methodsFor!

checkIfFinished
	interpreter hasMoreInstructions ifFalse: [
		(MessageBox confirm: 'Process finished - close debugger?')
			ifTrue: [self exit]].!

contexts
	^contextList list.!

createComponents
	super createComponents.
	contextList := self
		add: ListPresenter new
		name: 'contextList'.
	localFieldList := self
		add: ListPresenter new
		name: 'localFieldList'.
	localFieldSource := self
		add: PstSourceCodePresenter new
		name: 'localFieldSource'.
	sourceCode := self
		add: PstSourceCodePresenter new
		name: 'sourceCode'.!

createSchematicWiring
	super createSchematicWiring.
	contextList
		when: #selectionChanged
		send: #onSelectedContextChanged
		to: self.
	localFieldList
		when: #selectionChanged
		send: #onSelectedFieldChanged
		to: self.
	localFieldList
		when: #actionPerformed
		send: #onInspectField
		to: self.
	interpreter := model.
	self updateContexts.!

currentDisassemblySourceRange
	| context ip start stop |
	(context := self selectedContext) isNil ifTrue: [^nil].
	ip := context instructionPtr.
	ip isNil ifTrue: [^nil].
	^(ip between: 1 and: disassemblyMap size)
		ifTrue: [disassemblyMap at: ip]
		ifFalse: [nil].!

currentMethodSourceRange
	| context instruction |
	(context := self selectedContext) isNil ifTrue: [^nil].
	context instructionPtr isNil ifTrue: [^nil].
	context instructionPtr > context method instructions size 
		ifTrue: [^nil].
	instruction := context method instructions at: context instructionPtr.
	^instruction sourcePosition.!

dropToSelectedContext
	| context count |
	self selectedContext isNil ifTrue: [^self].
	interpreter dropToFrame: self selectedContext.
	self updateContexts.
	self selectedContextIndex: self contexts size - interpreter callStack size + 1.!

fieldValue	
	| context index |
	(context := self selectedContext) isNil
		ifTrue: [^self].
	index := self selectedFieldIndex.
	index < 1
		ifTrue: [^self].
	^interpreter dataStackAt: (context localVarBase + index -1)
!

fieldValue: text
	localFieldSource setValue: text.
	localFieldSource view refreshContents.!

getLocalSourceCode: index
	| object string |
	object := interpreter dataStackAt:
		self selectedContext localVarBase + index - 1.
	string := PstSystem current qcompilerClass
		evaluate: 'self printString'
		for: object
		notifying: self localSourceCodePart.
	string isNil ifTrue: [^'[error during printing]'].
	^string qclass name = 'String'
		ifTrue: [string convertToString]
		ifFalse: ['[did not print as a string]'].!

highlightSourceRange
	| interval |
	interval := self sourceMode == #source
		ifTrue: [self currentMethodSourceRange]
		ifFalse: [self currentDisassemblySourceRange].
	(interval isNil or: [interval isEmpty]) ifTrue: [^self].
	sourceCode view selectionRange: interval.!

instructionPtrForCursorPosition: position
	^3.!

interpreter: newInterpreter
	interpreter := newInterpreter.
	interpreter debugger: self.
	self updateContexts.!

localFieldNames
	| method stream context |
	stream := Array new writeStream.
	(context := self selectedContext) isNil
		ifTrue: [^stream contents].
	method := context method.
	1 to: method argumentCount do: [:n |
		stream nextPut: 'arg_', n printString].
	1 to: method temporaryCount do: [:n |
		stream nextPut: 'temp_', n printString].
	1 to: context dataStackPtr - context localVarBase - 
			method localVariableCount do: [:n |
		stream nextPut: 'stack_', n printString].
	^stream contents.!

localFieldValue	
	| context index |
	(context := self selectedContext) isNil
		ifTrue: [^''].
	index := self selectedFieldIndex.
	index < 1
		ifTrue: [^''].
	^self stringForValue: (interpreter dataStackAt: (context localVarBase + index -1))!

onInspectField
	PstInspector showOn: self fieldValue.!

onSelectedContextChanged
	self updateSourceCode.
	self updateLocalFields.!

onSelectedFieldChanged
	self updateLocalFieldValue.
!

receiverForMethods
	^self selectedContext isNil
		ifTrue: [PstBasicObject forNil]
		ifFalse: [self selectedContext receiver].!

selectContextIndex: index
	contextList selectionByIndex: index.!

selectedContext
	^contextList selectionOrNil.!

selectedContextIndex
	^contextList selectionByIndex.!

selectedField
	^localFieldList selectionOrNil.!

selectedFieldIndex
	^localFieldList selectionByIndex.!

selectedMethod
	^self selectedContext isNil 
		ifTrue: [nil]
		ifFalse: [self selectedContext method].!

singleStep
	| context destSP destIP |
	self selectedContext isNil ifTrue: [^self].
	destSP := self contexts size - self selectedContextIndex.
	destIP := self selectedContext instructionPtr.
	"Restore the top stack frame for interpretation."
	interpreter restoreCallStackFrame.
	interpreter interpretWhile: [
		(interpreter callStack size > destSP
			or: [interpreter callStack size == destSP
				and: [interpreter instructionPtr = destIP]])
			and: [interpreter hasMoreInstructions]].
	self sourceMode == #source ifTrue: [self skipBoringInstructions].
	interpreter saveCallStackFrame.
	self updateContexts.
	self selectContextIndex: self contexts size - interpreter callStack size + 1.
	self checkIfFinished.
			!

skipBoringInstructions
	interpreter interpretWhile: [
		interpreter hasMoreInstructions
			and: [interpreter peekInstruction hasVisibleEffect not]].!

sourceCode: text
	sourceCode setValue: text.
	sourceCode view refreshContents.!

sourceMode
	^#source.!

stepInto
	| context count |
	self selectedContext isNil ifTrue: [^self].
	"Restore the top stack frame for interpretation."
	interpreter restoreCallStackFrame.
	count := 0.
	interpreter interpretWhile: [
		interpreter hasMoreInstructions and: [(count := count + 1) <= 1]].
	self sourceMode == #source ifTrue: [self skipBoringInstructions].
	interpreter saveCallStackFrame.
	self updateContexts.
	self selectContextIndex: self contexts size - interpreter callStack size + 1.
	self checkIfFinished.!

stringForValue: value
	| string |
	string := localFieldSource
		evaluate: 'self printString'
		for: value.
	string isNil ifTrue: [^'[error during printing]'].
	^string qclass name = 'String'
		ifTrue: [string convertToString]
		ifFalse: ['[did not print as a string]'].!

updateContexts
	contextList list: interpreter callStack reverse.!

updateDisassemblySourceCode
	| string assoc |
	self selectedMethod isNil
		ifTrue: [
			string := ''.
			disassemblyMap := nil]
		ifFalse: [
			assoc := self selectedMethod disassemblyWithMap.
			string := assoc key.
			disassemblyMap := assoc value].
	self sourceCode: string.!

updateLocalFields
	localFieldList list: self localFieldNames.
	self updateLocalFieldValue.
!

updateLocalFieldValue
	self fieldValue: self localFieldValue.!

updateMethodSourceCode
	| string |
	string := self selectedMethod isNil
		ifTrue: ['']
		ifFalse: [self selectedMethod richTextSource].
	self sourceCode: string.!

updateSourceCode
	self sourceMode == #source
		ifTrue: [self updateMethodSourceCode]
		ifFalse: [self updateDisassemblySourceCode].
	self highlightSourceRange.! !
!PstDebugger categoriesFor: #checkIfFinished!actions!public! !
!PstDebugger categoriesFor: #contexts!accessing!public! !
!PstDebugger categoriesFor: #createComponents!initialization!public! !
!PstDebugger categoriesFor: #createSchematicWiring!initialization!public! !
!PstDebugger categoriesFor: #currentDisassemblySourceRange!public!utility! !
!PstDebugger categoriesFor: #currentMethodSourceRange!public!utility! !
!PstDebugger categoriesFor: #dropToSelectedContext!actions!public! !
!PstDebugger categoriesFor: #fieldValue!public!updating! !
!PstDebugger categoriesFor: #fieldValue:!accessing!public! !
!PstDebugger categoriesFor: #getLocalSourceCode:!public!updating! !
!PstDebugger categoriesFor: #highlightSourceRange!public!utility! !
!PstDebugger categoriesFor: #instructionPtrForCursorPosition:!accessing!public! !
!PstDebugger categoriesFor: #interpreter:!initialization!public! !
!PstDebugger categoriesFor: #localFieldNames!public!updating! !
!PstDebugger categoriesFor: #localFieldValue!public!updating! !
!PstDebugger categoriesFor: #onInspectField!event handling!public! !
!PstDebugger categoriesFor: #onSelectedContextChanged!event handling!public! !
!PstDebugger categoriesFor: #onSelectedFieldChanged!event handling!public! !
!PstDebugger categoriesFor: #receiverForMethods!accessing!public! !
!PstDebugger categoriesFor: #selectContextIndex:!actions!public! !
!PstDebugger categoriesFor: #selectedContext!accessing!public! !
!PstDebugger categoriesFor: #selectedContextIndex!accessing!public! !
!PstDebugger categoriesFor: #selectedField!accessing!public! !
!PstDebugger categoriesFor: #selectedFieldIndex!accessing!public! !
!PstDebugger categoriesFor: #selectedMethod!accessing!public! !
!PstDebugger categoriesFor: #singleStep!actions!public! !
!PstDebugger categoriesFor: #skipBoringInstructions!public!utility! !
!PstDebugger categoriesFor: #sourceCode:!accessing!public! !
!PstDebugger categoriesFor: #sourceMode!accessing!public! !
!PstDebugger categoriesFor: #stepInto!actions!public! !
!PstDebugger categoriesFor: #stringForValue:!public!utility! !
!PstDebugger categoriesFor: #updateContexts!public!updating! !
!PstDebugger categoriesFor: #updateDisassemblySourceCode!public!updating! !
!PstDebugger categoriesFor: #updateLocalFields!public!updating! !
!PstDebugger categoriesFor: #updateLocalFieldValue!public!updating! !
!PstDebugger categoriesFor: #updateMethodSourceCode!public!updating! !
!PstDebugger categoriesFor: #updateSourceCode!public!updating! !

!PstDebugger class methodsFor!

debugFor: interpreter
	^self showOn: interpreter.!

defaultModel
	^self shouldNotImplement.!

defaultView
	^'Default view'.! !
!PstDebugger class categoriesFor: #debugFor:!public!utility! !
!PstDebugger class categoriesFor: #defaultModel!*-should not implement!defaults!public! !
!PstDebugger class categoriesFor: #defaultView!defaults!public! !



PstInspector comment: ''!

PstInspector guid: (GUID fromString: '{9965B347-330E-4440-98E2-13AA7966345F}')!

!PstInspector categoriesForClass!No category! !
!PstInspector methodsFor!

accept
	self halt.!

createComponents
	super createComponents.
	historyStack := OrderedCollection new.
	fieldList := self
		add: ListPresenter new
		name: 'fieldList'.
	sourceCode := self
		add: PstSourceCodePresenter new
		name: 'sourceCode'.!

createSchematicWiring
	fieldList list: self fieldNames.
	fieldList
		when: #selectionChanged
		send: #onSelectedFieldChanged
		to: self.
	fieldList
		when: #actionPerformed
		send: #nestedInspect
		to: self.
	sourceCode view font: PstSystem current defaultFont.!

curtail
	historyStack := OrderedCollection new.!

doIt
	sourceCode doItFor: self receiverForEvaluations.!

fieldNames
	| stream |
	stream := Array new writeStream.
	stream
		nextPut: 'self';
		nextPut: 'self class';
		nextPutAll: self model slotNames;
		nextPutAll: 
			((1 to: self model indexedSlotCount)
				collect: [:each | each printString]).
	^stream contents.!

fieldValue
	| field value |
	field := self selectedField.
	field isNil ifTrue: [^nil].
	field = 'self' ifTrue: [^self model].
	field = 'self class' ifTrue: [^self model qclass].
	field first isDigit ifTrue: [^self indexedField: field].
	^self namedField: field.!

fieldValueString
	| value |
	value := self fieldValue.
	^value isNil 
		ifTrue: ['']
		ifFalse: [self stringForValue: value].
	!

indexedField: indexString
	| index |
	index := Integer fromString: indexString.
	^(self model hasIndexedSlotAt: index)
		ifTrue: [self model indexedSlotAt: index]
		ifFalse: [nil].!

inspectIt
	sourceCode inspectItFor: self receiverForEvaluations.!

namedField: indexString
	| index |
	index := self model slotNames indexOf: indexString.
	^(self model hasNamedSlotAt: index)
		ifTrue: [self model namedSlotAt: index]
		ifFalse: [nil].!

nestedInspect
	self push.
	self model: self fieldValue.
	self updateAll.!

onSelectedFieldChanged
	self updateSourceCode.!

pop
	self model: historyStack removeLast.!

popInspect
	self pop.
	self updateAll.!

printIt
	sourceCode printItFor: self receiverForEvaluations.!

push
	historyStack addLast: self model.!

queryCommand: commandQuery
	super queryCommand: commandQuery.
	(#(spawnInspector nestedInspect)
			identityIncludes: commandQuery command)
		ifTrue: [
			^commandQuery enabled: self selectedField notNil].
	(#(popInspect toTopLevel curtail) identityIncludes: commandQuery command)
		ifTrue: [^commandQuery enabled: historyStack notEmpty].!

receiverForEvaluations
	^self model.!

selectedField
	^fieldList selectionOrNil.!

spawnInspector
	self class showOn: self fieldValue.!

stringForValue: value
	| string |
	string := sourceCode
		evaluate: 'self printString'
		for: value.
	string isNil ifTrue: [^'[error during printing]'].
	^string qclass name = 'String'
		ifTrue: [string convertToString]
		ifFalse: ['[did not print as a string]'].!

toTopLevel
	[historyStack isEmpty]
		whileFalse: [self pop].
	self updateAll.!

updateAll
	self 
		updateCaption;
		updateFieldList;
		updateSourceCode.!

updateCaption
	self caption: 'Inspecting: ', self model displayString.!

updateFieldList
	fieldList list: self fieldNames.
!

updateSourceCode
	sourceCode value: self fieldValueString.! !
!PstInspector categoriesFor: #accept!evaluating!public! !
!PstInspector categoriesFor: #createComponents!initialization!public! !
!PstInspector categoriesFor: #createSchematicWiring!initialization!public! !
!PstInspector categoriesFor: #curtail!actions!public! !
!PstInspector categoriesFor: #doIt!evaluating!public! !
!PstInspector categoriesFor: #fieldNames!accessing!public! !
!PstInspector categoriesFor: #fieldValue!accessing!public! !
!PstInspector categoriesFor: #fieldValueString!accessing!public! !
!PstInspector categoriesFor: #indexedField:!accessing!public! !
!PstInspector categoriesFor: #inspectIt!evaluating!public! !
!PstInspector categoriesFor: #namedField:!accessing!public! !
!PstInspector categoriesFor: #nestedInspect!actions!public! !
!PstInspector categoriesFor: #onSelectedFieldChanged!public!updating! !
!PstInspector categoriesFor: #pop!actions!public! !
!PstInspector categoriesFor: #popInspect!actions!public! !
!PstInspector categoriesFor: #printIt!evaluating!public! !
!PstInspector categoriesFor: #push!actions!public! !
!PstInspector categoriesFor: #queryCommand:!actions!public! !
!PstInspector categoriesFor: #receiverForEvaluations!evaluating!public! !
!PstInspector categoriesFor: #selectedField!accessing!public! !
!PstInspector categoriesFor: #spawnInspector!actions!public! !
!PstInspector categoriesFor: #stringForValue:!accessing!public! !
!PstInspector categoriesFor: #toTopLevel!actions!public! !
!PstInspector categoriesFor: #updateAll!public!updating! !
!PstInspector categoriesFor: #updateCaption!public!updating! !
!PstInspector categoriesFor: #updateFieldList!public!updating! !
!PstInspector categoriesFor: #updateSourceCode!public!updating! !

!PstInspector class methodsFor!

defaultModel
	^PstBasicObject forNil.!

defaultView
	^'Default view'.! !
!PstInspector class categoriesFor: #defaultModel!defaults!public! !
!PstInspector class categoriesFor: #defaultView!defaults!public! !



PstLauncher comment: ''!

PstLauncher guid: (GUID fromString: '{1C785371-AEEB-404D-8AA6-2907AD6693E8}')!

!PstLauncher categoriesForClass!No category! !
!PstLauncher methodsFor!

chooseFont
	self system chooseFont.!

clearGlobals
	(MessageBox confirm: 'Really clear all shared variables?')
		ifFalse: [^self].
	self system globals clearAllGlobals.!

createSchematicWiring
	super createSchematicWiring.
	self
		when: #closeRequested:
		send: #onCloseRequested:
		to: self.!

exitSmalltalk
	self exit.!

filenameFromUserUsing: fileDialogClass
reason: reason
	| filename |
	filename := PstSystem lastArgumentFor: reason.
	filename := (fileDialogClass on: filename asValue)
		showModal.
	(filename isNil or: [filename isEmpty])
		ifTrue: [^nil].
	PstSystem lastArgumentFor: reason put: filename.
	^filename.!

findImplementors
	| string |
	string := Prompter
		on: (PstSystem lastArgumentFor: #implementors)
		prompt: 'Implementors of which selector:'
		caption: 'Find Implementors'.
	(string isNil or: [string isEmpty]) ifTrue: [^self].
	PstSystem lastArgumentFor: #implementors put: string.
	PstMethodListBrowser showImplementorsOf: string.!

findMethodsContainingString
	| string |
	string := Prompter
		on: (PstSystem lastArgumentFor: #methodsContainingString)
		prompt: 'Enter text to search for:'
		caption: 'Find Methods Containing String'.
	(string isNil or: [string isEmpty]) ifTrue: [^self].
	PstSystem lastArgumentFor: #methodsContainingString put: string.
	PstMethodListBrowser showMethodsContainingString: string.!

findMethodsReferringTo
	| string value |
	string := Prompter
		on: (PstSystem lastArgumentFor: #methodsReferringTo)
		prompt: 'Enter a value to search for:'
		caption: 'Find Methods Referring To'.
	(string isNil or: [string isEmpty]) ifTrue: [^self].
	PstSystem lastArgumentFor: #methodsReferringTo put: string.
	value := PstSystem current parserClass
		 parseSimpleLiteral: string.
	value isNil ifTrue: [^MessageBox notify: 'That is not a valid literal value.'].
	PstMethodListBrowser showMethodsReferringTo: value.!

findSenders
	| string |
	string := Prompter
		on: (PstSystem lastArgumentFor: #senders)
		prompt: 'Senders of which selector:'
		caption: 'Find Senders'.
	(string isNil or: [string isEmpty]) ifTrue: [^self].
	PstSystem lastArgumentFor: #senders put: string.
	PstMethodListBrowser showSendersOf: string.!

generateCode
	| filename |
	(filename := PstSystem lastArgumentFor: #generatedCode)
		isEmpty ifTrue: [^self generateCodeAs].
	self generateCode: filename.!

generateCode: filename
	| stream optimized |

	PstClassLibrary current checkIfCanGenerateCode: [:message |
		^MessageBox notify: 'Cannot generate code because ', message].
	PstSystem lastArgumentFor: #generatedCode put: filename.
	optimized := PstSystem current
		booleanProperty: 'optimization'
		ifAbsent: [false].
	filename isNil ifTrue: [^self].
	stream := FileStream write: filename text: false.
	[Cursor wait showWhile: [
		PstSystem current codeGeneratorClass
			generateCodeForSystem: self system
			optimized: optimized
			on: stream]] 
		ensure: [stream close].!

generateCodeAs
	| filename |
	filename := PstSystem current defaultCodeFile
		caption: 'Generate Code';
		showModal.
	(filename isNil or: [filename isEmpty]) ifTrue: [^self].

	"If file exists, prompt to overwrite."
	(File exists: filename) 
		ifTrue: [(MessageBox confirm: 'Overwrite generated binary file?' caption: 'Overwrite?')
			ifFalse: [^self]].

	self generateCode: filename.!

initialize
	super initialize.

	self toolbarHelper: (PstToolbarHelper with: self).!

newProject
	(MessageBox confirm: 'Starting a new project will erase any unsaved changes.
Proceed anyway?')
		ifFalse: [^self].
	PstSystem resetAs: PstSystem current class.
	self updateCaption.!

newProjectGeos
	(MessageBox confirm: 'Starting a new project will erase any unsaved changes.
Proceed anyway?')
		ifFalse: [^self].
	PstSystem resetAs: PstPocketSmalltalkGEOS.
	self updateCaption.!

newProjectPalmOS
	(MessageBox confirm: 'Starting a new project will erase any unsaved changes.
Proceed anyway?')
		ifFalse: [^self].
	PstSystem resetAs: PstPocketSmalltalkPalmOS.
	self updateCaption.!

onCloseRequested: valueHolder
	(MessageBox confirm: 'Really exit Pocket Smalltalk?')
		ifFalse: [
			valueHolder value: false.
			^false].
	"Only exit automatically if this is not a development image."
	(SessionManager current respondsTo: #foobar)
		ifTrue: [SessionManager current exit].
	^valueHolder value.!

openClassBrowser
	"PstSystem current classBrowserClass show."
	(PstClassBrowser show) toolbarHelper: (PstToolbarHelper with: self).!

openClassBrowserOnClass: aClass
	"PstSystem current classBrowserClass show."
	|cb|
	cb := PstClassBrowser browseClass: aClass.
	cb toolbarHelper: (PstToolbarHelper with: self).
!

openClassBrowserOnMethod: aMethod

	|cb|
	cb := PstClassBrowser browseMethod: aMethod.
	cb toolbarHelper: (PstToolbarHelper with: self).
!

openConstantsBrowser
	(PstConstantsBrowser show) toolbarHelper: (PstToolbarHelper with: self).!

openConstantsBrowserOnConstant: aConstant

	|cb|
	cb := PstConstantsBrowser browse: aConstant.
	cb toolbarHelper: (PstToolbarHelper with: self).
!

openPackageBrowser
	(PstPackageBrowser show) toolbarHelper: (PstToolbarHelper with: self).!

openProject
	| filename |
	filename := FileOpenDialog new
		fileTypes: (Array
			with: #('Smalltalk Projects (*.pst)' '*.pst')
			with: #('Old Smalltalk Projects (*.prj)' '*.prj')
			with: FileDialog allFilesType);
		defaultExtension: 'prj';
		caption: 'Open Project';
		showModal.
	(filename isNil or: [filename isEmpty])
		ifTrue: [^self].
	PstPackageLibrary current packages size > 1 ifTrue: [
		(MessageBox confirm: 'Opening a project will erase any unsaved changes.
Proceed anyway?')
			ifFalse: [^self]].
	((File splitExtensionFrom: filename) = 'prj')
	ifTrue: [PstSystem current loadOldProject: filename]
	ifFalse: [PstSystem current loadProject: filename].
	self updateCaption.!

openSystrapBrowser
	(PstSystrapBrowser show) toolbarHelper: (PstToolbarHelper with: self).!

openWorkspace
	(PstWorkspace show) toolbarHelper: (PstToolbarHelper with: self).!

queryCommand: commandQuery
	super queryCommand: commandQuery.
	commandQuery command == #emitDebugInfo
		ifTrue: [commandQuery checked: (self system propertyAt: #debug)].!

saveProject
	self system projectFilename isNil
		ifTrue: [^self saveProjectAs].
	self system saveProjectAs: self system projectFilename.!

saveProjectAs
	| filename |
	filename := FileSaveDialog new
		fileTypes: (Array
			with: #('Smalltalk Projects (*.pst)' '*.pst')
			with: #('Smalltalk Old Projects (*.prj)' '*.prj')
			with: FileDialog allFilesType);
		defaultExtension: 'pst';
		caption: 'Save Project';
		showModal.
	(filename isNil or: [filename isEmpty])
		ifTrue: [^self].

	"If file exists, prompt user to overwrite or not."
	(File exists: filename)
		ifTrue: [(MessageBox confirm: 'Overwrite existing project file? This can''t be undone.' caption: 'Overwrite?')
			ifFalse: [^self]].

	self system saveProjectAs: filename.
	self updateCaption.!

showAbout
	PstAboutShell show.!

showInstructionStatistics
	PstStatistics
		display: #instructionStatistics
		caption: 'Instruction Statistics'.!

showMethodStatistics
	PstStatistics
		display: #methodStatistics
		caption: 'Method Statistics'.!

showSelectorsImplementedButNotSent
	| selectors choice |
	selectors := PstClassLibrary current
		selectorsImplementedButNotSent
			asSortedCollection.
	choice := ListPrompter
		list: selectors
		caption: 'Implemented but not Sent'.
	choice isNil ifFalse: [
		PstMethodListBrowser showImplementorsOf: choice].!

showSelectorsSentButNotImplemented
	| selectors choice |
	selectors := PstClassLibrary current
		selectorsSentButNotImplemented
			asSortedCollection.
	choice := ListPrompter
		list: selectors
		caption: 'Sent but not Implemented'.
	choice isNil ifFalse: [
		PstMethodListBrowser showSendersOf: choice].!

system
	^PstSystem current.!

updateCaption
	| projectName systemName |
	projectName := PstSystem current projectFilename.
	systemName := PstSystem current class name.
	self caption: (projectName isNil
		ifTrue: [systemName]
		ifFalse: [systemName, ' - ', projectName]).! !
!PstLauncher categoriesFor: #chooseFont!actions!actions-options!public! !
!PstLauncher categoriesFor: #clearGlobals!actions!actions-options!public! !
!PstLauncher categoriesFor: #createSchematicWiring!initialization!public! !
!PstLauncher categoriesFor: #exitSmalltalk!actions!actions-system!public! !
!PstLauncher categoriesFor: #filenameFromUserUsing:reason:!public!utility! !
!PstLauncher categoriesFor: #findImplementors!actions!actions-search!public! !
!PstLauncher categoriesFor: #findMethodsContainingString!actions!actions-search!public! !
!PstLauncher categoriesFor: #findMethodsReferringTo!actions!actions-search!public! !
!PstLauncher categoriesFor: #findSenders!actions!actions-search!public! !
!PstLauncher categoriesFor: #generateCode!actions!actions-system!public! !
!PstLauncher categoriesFor: #generateCode:!actions!actions-system!public! !
!PstLauncher categoriesFor: #generateCodeAs!actions-system!public! !
!PstLauncher categoriesFor: #initialize!initialization!public! !
!PstLauncher categoriesFor: #newProject!actions!actions-system!public! !
!PstLauncher categoriesFor: #newProjectGeos!actions-system!public! !
!PstLauncher categoriesFor: #newProjectPalmOS!actions-system!public! !
!PstLauncher categoriesFor: #onCloseRequested:!event handling!public! !
!PstLauncher categoriesFor: #openClassBrowser!actions!actions-tools!public! !
!PstLauncher categoriesFor: #openClassBrowserOnClass:!actions!actions-tools!public! !
!PstLauncher categoriesFor: #openClassBrowserOnMethod:!actions!actions-tools!public! !
!PstLauncher categoriesFor: #openConstantsBrowser!actions!actions-tools!public! !
!PstLauncher categoriesFor: #openConstantsBrowserOnConstant:!actions!actions-tools!public! !
!PstLauncher categoriesFor: #openPackageBrowser!actions-tools!public! !
!PstLauncher categoriesFor: #openProject!actions!actions-system!public! !
!PstLauncher categoriesFor: #openSystrapBrowser!actions-tools!public! !
!PstLauncher categoriesFor: #openWorkspace!actions!actions-tools!public! !
!PstLauncher categoriesFor: #queryCommand:!actions!public! !
!PstLauncher categoriesFor: #saveProject!actions-system!public! !
!PstLauncher categoriesFor: #saveProjectAs!actions!actions-system!public! !
!PstLauncher categoriesFor: #showAbout!*-unclassified!public! !
!PstLauncher categoriesFor: #showInstructionStatistics!actions-statistics!public! !
!PstLauncher categoriesFor: #showMethodStatistics!actions-statistics!public! !
!PstLauncher categoriesFor: #showSelectorsImplementedButNotSent!actions!actions-search!public! !
!PstLauncher categoriesFor: #showSelectorsSentButNotImplemented!actions!actions-search!public! !
!PstLauncher categoriesFor: #system!accessing!public! !
!PstLauncher categoriesFor: #updateCaption!public!utility! !

!PstLauncher class methodsFor!

defaultView
	^'Default view'.! !
!PstLauncher class categoriesFor: #defaultView!defaults!public! !



PstMethodListBrowser comment: ''!

PstMethodListBrowser guid: (GUID fromString: '{275558E3-6EF7-47E6-B358-217F8EABEA4C}')!

!PstMethodListBrowser categoriesForClass!No category! !
!PstMethodListBrowser methodsFor!

accept
	"Answer true or false depending on whether compilation succeeded."
	| oldMethod method cls category |
	(oldMethod := self selectedMethod) isNil 
		ifTrue: [^MessageBox notify: '(No method is selected)'].
	category := oldMethod category.
	cls := self selectedMethod ownerClass.
	method := PstSystem current qcompilerClass
		compile: self sourceString
		in: cls
		notifying: sourceCode.
	method isNil ifTrue: [^false].
	cls installMethod: method classified: category.
	self selectMethodNamed: oldMethod selector ownerClass: cls.
	^true.!

browseImplementors
	self class showImplementorsOf: self selectedMethod selector.!

browseSelection
	methodList selectionOrNil isNil ifTrue: [^self].
	PstClassBrowser browseMethod: methodList selectionOrNil.!

browseSenders
	self class showSendersOf: self selectedMethod selector.!

createComponents
	super createComponents.
	methodList := self
		add: ListPresenter new
		name: 'methodList'.
	sourceCode := self
		add: PstSourceCodePresenter new
		name: 'sourceCode'.!

createSchematicWiring
	super createSchematicWiring.
	self model
		when: #addedMethod:to:
		send: #onAddedMethod:to:
		to: self.
	self model
		when: #removedMethod:from:
		send: #onRemovedMethod:from:
		to: self.
	self model
		when: #recompiledBehavior:
		send: #onRecompiledBehavior:
		to: self.
	methodList
		when: #selectionChanged
		send: #onSelectedMethodChanged
		to: self.
	methodList
		when: #actionPerformed
		send: #browseSelection
		to: self.
	methodList view getTextBlock: 
		[:method | method fullDisplayString].
	self updateFonts.!

deleteMethod
	(MessageBox confirm: 'Really delete #', self selectedMethod selector, '?')
		ifFalse: [^self].
	self selectedClass removeSelector: 
		self selectedMethod selector.!

doIt
	sourceCode doItFor: self receiverForEvaluations.!

inspectIt
	sourceCode inspectItFor: self receiverForEvaluations.!

onAddedMethod: method to: class
	self updateMethodList.!

onRecompiledBehavior: behavior
	(methodList list anySatisfy: [:method |
			method ownerClass == behavior])
		ifTrue: [self updateMethodList].!

onRemovedMethod: method from: class
	self updateMethodList.!

onSelectedMethodChanged
	self updateSourceCode.!

printIt
	sourceCode printItFor: self receiverForEvaluations.!

queryCommand: commandQuery
	super queryCommand: commandQuery.
	(#(accept browseSelection browseSenders browseImplementors deleteMethod) 
			includes: commandQuery command)
		ifTrue: [commandQuery enabled: self selectedMethod notNil].!

receiverForEvaluations
	^self selectedClass isNil
		ifTrue: [PstBasicObject forNil]
		ifFalse: [self selectedClass].!

selectedClass
	^self selectedMethod isNil
		ifTrue: [nil]
		ifFalse: [self selectedMethod ownerClass].!

selectedMethod
	^methodList selectionOrNil.!

selectMethodNamed: selector
ownerClass: ownerClass
	| method |
	method := methodList list
		detect: [:each | each selector = selector 
			and: [each ownerClass == ownerClass]]
		ifNone: [nil].
	method isNil ifFalse: [methodList selection: method].!

sourceString
	^sourceCode view plainText.!

updateBlock: block
	updateBlock := block.!

updateFonts
	| b |
	b := [:presenter |
		presenter view font: PstSystem current defaultFont].
	b 
		value: methodList;
		value: sourceCode.!

updateMethodList
	self updateMethodListWith:
		(updateBlock value: self model).!

updateMethodListWith: collection
	| m |
	m := self selectedMethod.
	methodList list: (self model sortMethods: collection).
	(m notNil and: [collection includes: m])
		ifTrue: [methodList selection: m].
	self updateSourceCode.
	methodList list isEmpty
		ifFalse: [methodList selectionByIndex: 1].!

updateSourceCode
	| string |
	string := self selectedMethod isNil
		ifTrue: [String new]
		ifFalse: [self selectedMethod richTextSource].
	sourceCode value: string.! !
!PstMethodListBrowser categoriesFor: #accept!actions!public! !
!PstMethodListBrowser categoriesFor: #browseImplementors!actions!public! !
!PstMethodListBrowser categoriesFor: #browseSelection!actions!public! !
!PstMethodListBrowser categoriesFor: #browseSenders!actions!public! !
!PstMethodListBrowser categoriesFor: #createComponents!initialization!public! !
!PstMethodListBrowser categoriesFor: #createSchematicWiring!initialization!public! !
!PstMethodListBrowser categoriesFor: #deleteMethod!actions!public! !
!PstMethodListBrowser categoriesFor: #doIt!evaluating!public! !
!PstMethodListBrowser categoriesFor: #inspectIt!evaluating!public! !
!PstMethodListBrowser categoriesFor: #onAddedMethod:to:!event handling!public! !
!PstMethodListBrowser categoriesFor: #onRecompiledBehavior:!event handling!public! !
!PstMethodListBrowser categoriesFor: #onRemovedMethod:from:!event handling!public! !
!PstMethodListBrowser categoriesFor: #onSelectedMethodChanged!event handling!public! !
!PstMethodListBrowser categoriesFor: #printIt!evaluating!public! !
!PstMethodListBrowser categoriesFor: #queryCommand:!actions!public! !
!PstMethodListBrowser categoriesFor: #receiverForEvaluations!evaluating!public! !
!PstMethodListBrowser categoriesFor: #selectedClass!accessing!public! !
!PstMethodListBrowser categoriesFor: #selectedMethod!accessing!public! !
!PstMethodListBrowser categoriesFor: #selectMethodNamed:ownerClass:!actions!public! !
!PstMethodListBrowser categoriesFor: #sourceString!accessing!public! !
!PstMethodListBrowser categoriesFor: #updateBlock:!initialization!public! !
!PstMethodListBrowser categoriesFor: #updateFonts!public!updating! !
!PstMethodListBrowser categoriesFor: #updateMethodList!public!updating! !
!PstMethodListBrowser categoriesFor: #updateMethodListWith:!public!updating! !
!PstMethodListBrowser categoriesFor: #updateSourceCode!public!updating! !

!PstMethodListBrowser class methodsFor!

defaultModel
	^PstSystem current classLibrary.!

defaultView
	^'Default view'.!

showImplementorsOf: selector
	^self
		showUsing: [:classLibrary |
			classLibrary methodsWithSelector: selector]
		ifNone: [MessageBox notify: 'No classes implement #', selector, '.']
		caption: 'Implementors of #', selector.!

showMethodsContainingString: string
	^self
		showUsing: [:classLibrary |
			classLibrary methodsContainingString: string]
		ifNone: [MessageBox notify: 'No methods contain that string.']
		caption: 'Methods containing ', string printString.!

showMethodsOf: qclass
referringToInstanceVariable: instVarName
	^self
		showUsing: [:classLibrary |
			qclass methodsReferringToInstanceVariable: instVarName]
		ifNone: [MessageBox notify: 'No methods reference ', instVarName]
		caption: 'Methods referencing ', qclass name, '.', instVarName.!

showMethodsReferencingClassNamed: className
	^self
		showUsing: [:classLibrary |
			classLibrary methodsReferencingClassNamed: className]
		ifNone: [MessageBox notify: 'No methods refer to ', className displayString]
		caption: 'Methods referring to ', className displayString.!

showMethodsReferringTo: value
	^self
		showUsing: [:classLibrary |
			classLibrary methodsReferringTo: value]
		ifNone: [MessageBox notify: 'No methods refer to ', value displayString]
		caption: 'Methods referring to ', value displayString.!

showMethodsReferringToConstant: constant
	^self
		showUsing: [:classLibrary |
			classLibrary methodsReferringToConstant: constant]
		ifNone: [MessageBox notify: 'No methods refer to ', constant displayString]
		caption: 'Methods referring to ', constant displayString.!

showMethodsReferringToSharedVariable: variableName
	^self
		showUsing: [:classLibrary |
			classLibrary methodsReferringToSharedVariable: variableName]
		ifNone: [MessageBox notify: 'No methods refer to ', variableName displayString]
		caption: 'Methods referring to ', variableName displayString.!

showSendersOf: selector
	^self
		showUsing: [:classLibrary |
			classLibrary methodsSending: selector]
		ifNone: [MessageBox notify: 'No methods send #', selector, '.']
		caption: 'Senders of #', selector.!

showUsing: updateBlock 
ifNone: noneBlock
caption: caption
	"Show (and answer) a new instance of the receiver, but only if updateBlock gives a non-empty result.  If it gives an empty result, answer the result of evaluating noneBlock instead."
	| results newModel shell |
	newModel := self defaultModel.
	results := updateBlock value: newModel.
	results isEmpty ifTrue: [^noneBlock value].
	shell := self showOn: newModel.
	shell caption: caption.
	shell updateBlock: updateBlock.
	shell updateMethodListWith: results.
	^shell.! !
!PstMethodListBrowser class categoriesFor: #defaultModel!defaults!public! !
!PstMethodListBrowser class categoriesFor: #defaultView!defaults!public! !
!PstMethodListBrowser class categoriesFor: #showImplementorsOf:!public!utility! !
!PstMethodListBrowser class categoriesFor: #showMethodsContainingString:!public!utility! !
!PstMethodListBrowser class categoriesFor: #showMethodsOf:referringToInstanceVariable:!public!utility! !
!PstMethodListBrowser class categoriesFor: #showMethodsReferencingClassNamed:!public!utility! !
!PstMethodListBrowser class categoriesFor: #showMethodsReferringTo:!public!utility! !
!PstMethodListBrowser class categoriesFor: #showMethodsReferringToConstant:!public!utility! !
!PstMethodListBrowser class categoriesFor: #showMethodsReferringToSharedVariable:!public!utility! !
!PstMethodListBrowser class categoriesFor: #showSendersOf:!public!utility! !
!PstMethodListBrowser class categoriesFor: #showUsing:ifNone:caption:!public!utility! !



PstPackageBrowser comment: ''!

PstPackageBrowser guid: (GUID fromString: '{B6B89C9E-F738-4722-A78E-A0C8C9A17423}')!

!PstPackageBrowser categoriesForClass!No category! !
!PstPackageBrowser methodsFor!

addUncommittedClass
	| class |
	class := self chooseUncommittedClass.
	class isNil ifTrue: [^self].
	class package: self selectedPackage.!

browseImplementors
	PstMethodListBrowser showImplementorsOf:
		self selectedMethod selector.!

browseReferencesToConstant
	PstMethodListBrowser showMethodsReferringToConstant:
		self selectedConstant.
!

browseSelectedClass
	"PstClassBrowser browseClass: self selectedClass."

	toolbarHelper openClassBrowserOnClass: self selectedClass.

!

browseSelectedConstant
	"PstConstantsBrowser browse: self selectedConstant."
	toolbarHelper openConstantsBrowserOnConstant: self selectedConstant.!

browseSelectedMethod
	"PstClassBrowser browseMethod: self selectedMethod."

	toolbarHelper openClassBrowserOnMethod: self selectedMethod.
!

browseSenders
	PstMethodListBrowser showSendersOf:
		self selectedMethod selector.!

chooseUncommittedClass
	| classes |
	classes := PstClassLibrary current uncommittedClasses.
	classes isEmpty ifTrue: [
		MessageBox notify: 'All classes are already assigned to packages.'.
		^nil].
	^ListPrompter
		list: classes
		caption: 'Select a Class'.!

createComponents
	super createComponents.
	packageList := self
		add: ListPresenter new
		name: 'packageList'.
	classList := self
		add: ListPresenter new
		name: 'classList'.
	methodList := self
		add: ListPresenter new
		name: 'methodList'.
	constantList := self
		add: ListPresenter new
		name: 'constantList'.!

createSchematicWiring
	| statusItem |
	super createSchematicWiring.
	self model
		when: #changed
		send: #updatePackageList
		to: self.
	self model
		when: #defaultPackageChanged
		send: #updateDefaultPackage
		to: self.
	self model
		when: #classesChangedFor:
		send: #updateClassesFor:
		to: self.
	self model
		when: #methodsChangedFor:
		send: #updateMethodsFor:
		to: self.
	self model
		when: #constantsChangedFor:
		send: #updateConstantsFor:
		to: self.
	packageList
		when: #selectionChanged
		send: #onSelectedPackageChanged
		to: self.
	packageList
		when: #actionPerformed
		send: #showSelectedPackage
		to: self.
	classList
		when: #actionPerformed
		send: #browseSelectedClass
		to: self.
	methodList
		when: #actionPerformed
		send: #browseSelectedMethod
		to: self.
	constantList
		when: #actionPerformed
		send: #browseSelectedConstant
		to: self.
	methodList view getTextBlock: 
		[:method | method fullDisplayString].
	statusModel := ValueHolder with: String new.
	statusItem := (self view viewNamed: 'status')
		addItem: StatusItem new.
	statusItem model: statusModel.
	statusItem getImageBlock: [:blah | nil].
	self updatePackageList.!

dontSavePackageWithProject
	self selectedPackage dontSave:
		self selectedPackage dontSave not.!

generateDocumentation
	| filename directory indexName |
	(MessageBox confirm: 'Automatically generate HTML documentation for this package?')
		ifFalse: [^self].
	filename := FileSaveDialog new
		value: (PstDocumentationGenerator
			defaultFilenameForPackage: self selectedPackage);
		fileTypes: (Array
			with: #('HTML Files (*.html)' '*.html')
			with: FileSaveDialog allFilesType);
		defaultExtension: 'html';
		caption: 'Name Index HTML File';
		showModal.
	(filename isNil or: [filename isEmpty]) ifTrue: [^self].
	directory := File splitPathFrom: filename.
	indexName := File splitStemFrom: filename.
	Cursor wait showWhile: [
		PstDocumentationGenerator
			writePackageDocumentation: self selectedPackage
			toDirectory: directory
			indexFileNamed: indexName].
	MessageBox notify: 'Documentation generated.'.!

installPackage
	| filename |
	filename := FileOpenDialog new
		caption: 'Install Package';
		fileTypes: #(('Smalltalk Source Files (*.st)' '*.st') ('All Files (*.*)' '*.*'));
		defaultExtension: 'st';
		showModal.
	(filename isNil or: [filename isEmpty]) ifTrue: [^self].
	(self model hasPackageNamed: filename) 
		ifTrue: [(MessageBox confirm: 'Reload this package?')
			ifFalse: [^self]].
	self model deferUpdatesDuring: 
		[self model installPackageNamed: filename].!

moveSelectedClass
	| package |
	package := PstPackage choose.
	package isNil ifTrue: [^self].
	self selectedClass package: package.!

moveSelectedConstant
	| package |
	package := PstPackage choose.
	package isNil ifTrue: [^self].
	self selectedConstant package: package.!

moveSelectedPackageToFront
	| package |
	package := self selectedPackage.
	self model movePackageToFront: package.
	packageList selection: package.!

newPackage
	| filename |
	filename := FileSaveDialog new
		caption: 'New Package';
		fileTypes: #(('Smalltalk Source Files (*.st)' '*.st') ('All Files (*.*)' '*.*'));
		defaultExtension: 'st';
		showModal.
	(filename isNil or: [filename isEmpty]) ifTrue: [^self].
	(self model hasPackageNamed: filename) 
		ifTrue: [(MessageBox confirm: 'Replace the loaded package?')
			ifFalse: [^self]].
	self model createPackageNamed: filename.!

onSelectedPackageChanged
	self
		updateClassList;
		updateMethodList;
		updateConstantList.!

onViewOpened
	super onViewOpened.
	self updateDefaultPackage.!

queryCommand: query
	| symbol |
	super queryCommand: query.
	symbol := query command.
	(#(browseSelectedClass removeSelectedClass moveSelectedClass)
			identityIncludes: symbol)
		ifTrue: [query enabled: self selectedClass notNil].
	(#(addUncommittedClass savePackage savePackageAs moveSelectedPackageToFront dontSavePackageWithProject generateDocumentation) 
			identityIncludes: symbol) 
		ifTrue: [query enabled: (self selectedPackage notNil
				and: [self selectedPackage isUncommitted not])].
	symbol == #dontSavePackageWithProject ifTrue: [
		query isEnabled ifTrue: [
			query checked: self selectedPackage dontSave]].
	(#(removeSelectedMethod browseSelectedMethod browseImplementors browseSenders) 
			identityIncludes: symbol)
		ifTrue: [query enabled: self selectedMethod notNil].
	(#(moveSelectedConstant browseSelectedConstant browseReferencesToConstant removeSelectedConstant)
			identityIncludes: symbol)
		ifTrue: [query enabled: self selectedConstant notNil].!

removePackage
	self selectedPackage isNil ifTrue: [^self].  "shouldn't happen"

	(MessageBox confirm: 'Really remove ', (self selectedPackage baseFilename), ' from project?')
		ifFalse: [^self].

	PstPackageLibrary current removePackage: self selectedPackage.!

removeSelectedClass
	(MessageBox confirm: 'Remove ', self selectedClass displayString, ' from this package?')
		ifFalse: [^self].
	self selectedClass package: PstPackage uncommitted.!

removeSelectedConstant
	| constant |
	constant := self selectedConstant.
	(MessageBox confirm: 'Remove ', 
			constant displayString, ' from this package?')
		ifFalse: [^self].
	constant package:PstPackage uncommitted.!

removeSelectedMethod
	| method |
	method := self selectedMethod.
	(MessageBox confirm: 'Remove ', 
			method fullDisplayString, ' from this package?')
		ifFalse: [^self].
	method package: method ownerClass package.!

savePackage
	self selectedPackage save.!

savePackageAs
	| dialog filename package |
	package := self selectedPackage.
	dialog := FileSaveDialog on: package filename asValue.
	filename := dialog
		fileTypes: (Array
			with: #('Smalltalk Source Files' '*.st')
			with: dialog allFilesType);
		caption: 'Save Package';
		defaultExtension: 'st';
		showModal.
	(filename isNil or: [filename isEmpty])
		ifTrue: [^self].
	package saveAs: filename.!

selectedClass
	^classList selectionOrNil.!

selectedConstant
	^constantList selectionOrNil.!

selectedMethod
	^methodList selectionOrNil.!

selectedPackage
	^packageList selectionOrNil.!

setSelectedPackageAsDefault
	self selectedPackage isNil ifTrue: [^self].  "shouldn't happen"
	PstPackageLibrary current defaultPackage: self selectedPackage.!

showSelectedPackage
	| package string |
	(package := self selectedPackage) isNil ifTrue: [^self].
	string := package isUncommitted
		ifTrue: ['Uncommitted package']
		ifFalse: [package filename].
	^MessageBox notify: string.!

statusMessage: string
	statusModel value: string.!

updateClassesFor: package
	package == self selectedPackage 
		ifTrue: [self updateClassList].!

updateClassList
	classList list: (self selectedPackage isNil
		ifTrue: [#()]
		ifFalse: [self selectedPackage classes copy]).!

updateConstantList
	constantList list: (self selectedPackage isNil
		ifTrue: [#()]
		ifFalse: [self selectedPackage constants copy]).!

updateConstantsFor: package
	package == self selectedPackage 
		ifTrue: [self updateConstantList].!

updateDefaultPackage
	| package |
	package := PstPackage default.
	self statusMessage: (package isUncommitted
		ifTrue: ['No default package']
		ifFalse: ['Default: ', package displayString]).!

updateMethodList
	methodList list: (self selectedPackage isNil
		ifTrue: [#()]
		ifFalse: [self selectedPackage methods copy]).!

updateMethodsFor: package
	package == self selectedPackage 
		ifTrue: [self updateMethodList].!

updatePackageList
	packageList list: self model packages copy.! !
!PstPackageBrowser categoriesFor: #addUncommittedClass!actions!public! !
!PstPackageBrowser categoriesFor: #browseImplementors!actions!public! !
!PstPackageBrowser categoriesFor: #browseReferencesToConstant!actions!public! !
!PstPackageBrowser categoriesFor: #browseSelectedClass!actions!public! !
!PstPackageBrowser categoriesFor: #browseSelectedConstant!actions!public! !
!PstPackageBrowser categoriesFor: #browseSelectedMethod!actions!public! !
!PstPackageBrowser categoriesFor: #browseSenders!actions!public! !
!PstPackageBrowser categoriesFor: #chooseUncommittedClass!public!utility! !
!PstPackageBrowser categoriesFor: #createComponents!initialization!public! !
!PstPackageBrowser categoriesFor: #createSchematicWiring!initialization!public! !
!PstPackageBrowser categoriesFor: #dontSavePackageWithProject!actions!public! !
!PstPackageBrowser categoriesFor: #generateDocumentation!actions!public! !
!PstPackageBrowser categoriesFor: #installPackage!actions!public! !
!PstPackageBrowser categoriesFor: #moveSelectedClass!actions!public! !
!PstPackageBrowser categoriesFor: #moveSelectedConstant!actions!public! !
!PstPackageBrowser categoriesFor: #moveSelectedPackageToFront!actions!public! !
!PstPackageBrowser categoriesFor: #newPackage!actions!public! !
!PstPackageBrowser categoriesFor: #onSelectedPackageChanged!event handling!public! !
!PstPackageBrowser categoriesFor: #onViewOpened!event handling!public! !
!PstPackageBrowser categoriesFor: #queryCommand:!actions!public! !
!PstPackageBrowser categoriesFor: #removePackage!actions!public! !
!PstPackageBrowser categoriesFor: #removeSelectedClass!actions!public! !
!PstPackageBrowser categoriesFor: #removeSelectedConstant!actions!public! !
!PstPackageBrowser categoriesFor: #removeSelectedMethod!actions!public! !
!PstPackageBrowser categoriesFor: #savePackage!actions!public! !
!PstPackageBrowser categoriesFor: #savePackageAs!actions!public! !
!PstPackageBrowser categoriesFor: #selectedClass!accessing!public! !
!PstPackageBrowser categoriesFor: #selectedConstant!accessing!public! !
!PstPackageBrowser categoriesFor: #selectedMethod!accessing!public! !
!PstPackageBrowser categoriesFor: #selectedPackage!accessing!public! !
!PstPackageBrowser categoriesFor: #setSelectedPackageAsDefault!actions!public! !
!PstPackageBrowser categoriesFor: #showSelectedPackage!actions!public! !
!PstPackageBrowser categoriesFor: #statusMessage:!public!utility! !
!PstPackageBrowser categoriesFor: #updateClassesFor:!public!updating! !
!PstPackageBrowser categoriesFor: #updateClassList!public!updating! !
!PstPackageBrowser categoriesFor: #updateConstantList!public!updating! !
!PstPackageBrowser categoriesFor: #updateConstantsFor:!public!updating! !
!PstPackageBrowser categoriesFor: #updateDefaultPackage!public!updating! !
!PstPackageBrowser categoriesFor: #updateMethodList!public!updating! !
!PstPackageBrowser categoriesFor: #updateMethodsFor:!public!updating! !
!PstPackageBrowser categoriesFor: #updatePackageList!public!updating! !

!PstPackageBrowser class methodsFor!

defaultModel
	^PstPackageLibrary current.!

defaultView
	^'Default view'.! !
!PstPackageBrowser class categoriesFor: #defaultModel!defaults!public! !
!PstPackageBrowser class categoriesFor: #defaultView!defaults!public! !



PstSystrapBrowser comment: ''!

PstSystrapBrowser guid: (GUID fromString: '{9063B9D2-D246-4D79-BF57-4DA49282A4F4}')!

!PstSystrapBrowser categoriesForClass!No category! !
!PstSystrapBrowser methodsFor!

createComponents
	super createComponents.
	traps := self
		add: ListPresenter new
		name: 'traps'.
	self updateTraps.!

createSchematicWiring
	super createSchematicWiring.
	traps view imageManager: nil.
	traps view primaryColumn
		getTextBlock: [:trap | trap trapNumber printStringRadix: 16 showRadix: false];
		sortBlock: [:left :right | left trapNumber <= right trapNumber].
	traps view columns first
		getTextBlock: [:trap | trap prototype];
		sortBlock: [:left :right | left name <= right name].
	traps
		when: #actionPerformed
		send: #showPrototype
		to: self.!

findSystrap
	| string trap |
	string := Prompter
		prompt: 'Function name to search for?'
		caption: 'Find Systrap'.
	(string isNil or: [string isEmpty]) ifTrue: [^self].
	trap := traps list
		detect: [:each | string match: each name]
		ifNone: [^MessageBox notify: 'No such systrap.'].
	traps selection: trap.!

onResized: sizeEvent
	| width |
	self view isOpen ifFalse: [^self].
	"width := traps view clientWidth."
	width := sizeEvent width - 25.
	traps view primaryColumn width: width // 4.
	traps view columns first width: (width * 3) // 4.
	^super onResized: sizeEvent.!

showPrototype
	| trap |
	trap := traps selectionOrNil.
	trap isNil ifTrue: [^self].
	MessageBox notify: trap prototype.!

updateTraps
	traps list: PstSystem current apiClass sortedTraps.! !
!PstSystrapBrowser categoriesFor: #createComponents!initialization!public! !
!PstSystrapBrowser categoriesFor: #createSchematicWiring!initialization!public! !
!PstSystrapBrowser categoriesFor: #findSystrap!actions!public! !
!PstSystrapBrowser categoriesFor: #onResized:!event handling!public! !
!PstSystrapBrowser categoriesFor: #showPrototype!actions!public! !
!PstSystrapBrowser categoriesFor: #updateTraps!public!updating! !

!PstSystrapBrowser class methodsFor!

defaultModel
	^PstSystem current apiClass.!

defaultView
	^'Default view'.! !
!PstSystrapBrowser class categoriesFor: #defaultModel!defaults!public! !
!PstSystrapBrowser class categoriesFor: #defaultView!defaults!public! !



PstWorkspace comment: ''!

PstWorkspace guid: (GUID fromString: '{630D0381-52ED-4857-A86F-D06C65ACC36C}')!

!PstWorkspace categoriesForClass!No category! !
!PstWorkspace methodsFor!

createComponents
	super createComponents.
	sourceCode := self
		add: PstSourceCodePresenter new
		name: 'sourceCode'.!

createSchematicWiring
	super createSchematicWiring.
	sourceCode view font: PstSystem current defaultFont.!

doIt
	sourceCode doItFor: self receiverForEvaluations.!

inspectIt
	sourceCode inspectItFor: self receiverForEvaluations.!

printIt
	sourceCode printItFor: self receiverForEvaluations.!

receiverForEvaluations
	^PstBasicObject forNil.! !
!PstWorkspace categoriesFor: #createComponents!initialization!public! !
!PstWorkspace categoriesFor: #createSchematicWiring!initialization!public! !
!PstWorkspace categoriesFor: #doIt!evaluating!public! !
!PstWorkspace categoriesFor: #inspectIt!evaluating!public! !
!PstWorkspace categoriesFor: #printIt!evaluating!public! !
!PstWorkspace categoriesFor: #receiverForEvaluations!evaluating!public! !

!PstWorkspace class methodsFor!

defaultView
	^'Default view'.! !
!PstWorkspace class categoriesFor: #defaultView!defaults!public! !



PstSourceCodePresenter comment: ''!

PstSourceCodePresenter guid: (GUID fromString: '{229241B7-DEC8-4EBA-A695-F7942D2A23FD}')!

!PstSourceCodePresenter categoriesForClass!No category! !
!PstSourceCodePresenter methodsFor!

afterKeyTyped: keyEvent
	(keyEvent code == 13 and: [autoindent])
		ifTrue: [self performAutoIndent].!

createSchematicWiring
	self
		when: #afterKeyTyped:
		send: #afterKeyTyped:
		to: self.!

doItFor: receiver
	| expression |
	expression := self selectedExpression.
	expression isNil ifTrue: [^self].
	self evaluate: expression for: receiver.!

evaluate: expression for: receiver
	| result |
	Cursor wait showWhile: [
		result := PstSystem current qcompilerClass
			evaluate: expression
			for: receiver
			notifying: self].
	^result.!

handleError: message from: start to: stop
	self highlightErrorFrom: start to: stop.
	MessageBox notify: 'Error: ', message, '.'.!

handleWarning: message from: start to: stop
	self highlightErrorFrom: start to: stop.
	MessageBox notify: 'Warning: ', message, '.'.!

highlightErrorFrom: start to: stop
	(start isNil or: [stop isNil])
		ifTrue: [^self].
	self view
		selectionStart: start + expressionOffset
		end: stop + expressionOffset.!

initialize
	super initialize.
	autoindent := true.
	self resetExpressionOffset.!

initialWhitespaceOf: string
	| readStream writeStream |
	readStream := string readStream.
	writeStream := String new writeStream.
	[readStream atEnd not and: [readStream peek isSeparator]] 
		whileTrue: [writeStream nextPut: readStream next].
	^writeStream contents.
		!

inspectItFor: receiver
	| expression result printString |
	expression := self selectedExpression.
	result := expression isNil 
		ifTrue: [PstBasicObject forNil]
		ifFalse: [self evaluate: expression for: receiver].
	result isNil ifTrue: [^self].
	PstInspector showOn: result.!

performAutoIndent
	| thisLine start end string |
	thisLine := self view currentLine.  "line 1 is the top"
	thisLine == 1 ifTrue: [^self].  "no previous indentation"
	start := self view positionAtLine: thisLine - 1.
	end := start + (self view lineLength: thisLine - 1) - 1.
	string := self view plainText copyFrom: start to: end.
	self replaceSelection: (self initialWhitespaceOf: string).!

printItFor: receiver
	| expression result printString position |
	expression := self selectedExpression.
	result := expression isNil 
		ifTrue: [PstBasicObject forNil]
		ifFalse: [self evaluate: expression for: receiver].
	result isNil ifTrue: [^self].
	result := self
		evaluate: 'self printString'
		for: result.
	result isNil ifTrue: [^self].
	printString := result qclass name = 'String'
		ifTrue: [result convertToString]
		ifFalse: ['[unprintable]'].
	position := self view selectionRange stop + 1.
	self view
		caretPosition: position;
		replaceSelection: printString;
		selectionRange: (position to: position + printString size - 1).!

resetExpressionOffset
	expressionOffset := 0.!

selectedExpression
	"Answer the currently selected area of text (for do-it, etc.), or nil if no area is selected."
	| range |
	range := self view selectionRange.
	range isEmpty ifTrue: [^nil].
	expressionOffset := range first - 1.
	^self view plainText
		copyFrom: range first
		to: range last.! !
!PstSourceCodePresenter categoriesFor: #afterKeyTyped:!event handling!public! !
!PstSourceCodePresenter categoriesFor: #createSchematicWiring!initialization!public! !
!PstSourceCodePresenter categoriesFor: #doItFor:!evaluating!public! !
!PstSourceCodePresenter categoriesFor: #evaluate:for:!evaluating!public! !
!PstSourceCodePresenter categoriesFor: #handleError:from:to:!error handling!public! !
!PstSourceCodePresenter categoriesFor: #handleWarning:from:to:!error handling!public! !
!PstSourceCodePresenter categoriesFor: #highlightErrorFrom:to:!error handling!public! !
!PstSourceCodePresenter categoriesFor: #initialize!initialization!public! !
!PstSourceCodePresenter categoriesFor: #initialWhitespaceOf:!public!utility! !
!PstSourceCodePresenter categoriesFor: #inspectItFor:!evaluating!public! !
!PstSourceCodePresenter categoriesFor: #performAutoIndent!public!utility! !
!PstSourceCodePresenter categoriesFor: #printItFor:!evaluating!public! !
!PstSourceCodePresenter categoriesFor: #resetExpressionOffset!public!utility! !
!PstSourceCodePresenter categoriesFor: #selectedExpression!evaluating!public! !



PstCallStackFrame comment: ''!

PstCallStackFrame guid: (GUID fromString: '{D93C8E16-6F47-4DD0-BC2F-0154EDD098E4}')!

!PstCallStackFrame categoriesForClass!No category! !
!PstCallStackFrame methodsFor!

closureSet
	^closureSet.!

dataStackPtr
	^dataStackPtr.!

dataStackPtr: ptr

	dataStackPtr := ptr!

displayOn: stream
	receiver isBlockClosure ifTrue: [
		stream nextPutAll: '[] in '.
		^receiver isFullBlockClosure
			ifTrue: [
				receiver nextOuter = 0
					ifTrue: [
						stream 
							nextPutAll: 'expired context ';
							nextPutAll: receiver home fullDisplayString]
					ifFalse: [
						(interpreter callStack at: receiver nextOuter) 
							displayOn: stream]]
			ifFalse: [receiver home displayOn: stream]].
	receiver qclass displayOn: stream.
	receiver qclass == method ownerClass ifFalse: [
		stream
			nextPut: $(;
			display: method ownerClass;
			nextPut: $)].
	stream
		nextPutAll: '>>#';
		nextPutAll: method selector.!

instructionPtr
	^instructionPtr.!

instructionPtr: ptr

	^instructionPtr := ptr.!

interpreter: interp
receiver: r
method: m
localVarBase: l
dataStackPtr: d
instructionPtr: i
closureSet: s
	interpreter := interp.
	receiver := r.
	method := m.
	localVarBase := l.
	dataStackPtr := d.
	instructionPtr := i.
	closureSet := s.!

localVarBase
	^localVarBase.!

method
	^method.!

printOn: stream
	super printOn: stream.
	stream
		nextPutAll: ' (';
		print: self method;
		nextPut: $).!

receiver
	^receiver.! !
!PstCallStackFrame categoriesFor: #closureSet!accessing!public! !
!PstCallStackFrame categoriesFor: #dataStackPtr!accessing!public! !
!PstCallStackFrame categoriesFor: #dataStackPtr:!accessing!public! !
!PstCallStackFrame categoriesFor: #displayOn:!printing!public! !
!PstCallStackFrame categoriesFor: #instructionPtr!accessing!public! !
!PstCallStackFrame categoriesFor: #instructionPtr:!accessing!public! !
!PstCallStackFrame categoriesFor: #interpreter:receiver:method:localVarBase:dataStackPtr:instructionPtr:closureSet:!initialization!public! !
!PstCallStackFrame categoriesFor: #localVarBase!accessing!public! !
!PstCallStackFrame categoriesFor: #method!accessing!public! !
!PstCallStackFrame categoriesFor: #printOn:!printing!public! !
!PstCallStackFrame categoriesFor: #receiver!accessing!public! !



PstChangeLog comment: ''!

PstChangeLog guid: (GUID fromString: '{451D8302-78BD-4F52-B6FC-441AC9318991}')!

!PstChangeLog categoriesForClass!No category! !
!PstChangeLog methodsFor!

addedMethod: method to: behavior
	| entry |
	loggingChanges ifFalse: [^self].
	self withStreamDo: [:stream |
		| manager |
		manager := PstFileOutManager on: stream.
		method fileOutOn: manager].!

checkpoint
	loggingChanges ifFalse: [^self].
	self withStreamDo: [:stream |
		stream 
			nextPutAll: '"Checkpoint - ';
			display: TimeStamp current;
			nextPutAll: '"!!'; cr; cr].!

detachFromClassLibrary
	PstClassLibrary current removeEventsTriggeredFor: self.!

exists
	^File exists: self filename.!

filename
	^SessionManager current imageBase, 'pocketst.chg'.!

hookupToClassLibrary
	PstClassLibrary current
		when: #addedMethod:to:
		send: #addedMethod:to:
		to: self;

		when: #removedMethod:from:
		send: #removedMethod:from:
		to: self;

		when: #checkpoint
		send: #checkpoint
		to: self;

		yourself.!

initialize
	super initialize.
	loggingChanges := true.!

loggingChanges
	^loggingChanges.!

loggingChanges: object
	loggingChanges := object.!

noLoggingDuring: block
	| prev |
	prev := loggingChanges.
	loggingChanges := false.
	block ensure: [loggingChanges := prev].!

removedMethod: method from: behavior
	| entry |
	loggingChanges ifFalse: [^self].
	self withStreamDo: [:stream |
		stream
			nextPutAll: '"Removed: ';
			nextPutAll: method fullDisplayString;
			nextPutAll: '"!!';
			cr; cr].!

withStreamDo: block
	| fileStream filer |
	self assert: [loggingChanges].
	fileStream := FileStream
		write: self filename
		mode: #append.
	fileStream beText.
	[block value: fileStream] ensure: [fileStream close].! !
!PstChangeLog categoriesFor: #addedMethod:to:!change log events!public! !
!PstChangeLog categoriesFor: #checkpoint!change log events!public! !
!PstChangeLog categoriesFor: #detachFromClassLibrary!change log events!public! !
!PstChangeLog categoriesFor: #exists!accessing!public! !
!PstChangeLog categoriesFor: #filename!accessing!public! !
!PstChangeLog categoriesFor: #hookupToClassLibrary!change log events!public! !
!PstChangeLog categoriesFor: #initialize!initialization!public! !
!PstChangeLog categoriesFor: #loggingChanges!accessing!public! !
!PstChangeLog categoriesFor: #loggingChanges:!accessing!public! !
!PstChangeLog categoriesFor: #noLoggingDuring:!public!utility! !
!PstChangeLog categoriesFor: #removedMethod:from:!change log events!public! !
!PstChangeLog categoriesFor: #withStreamDo:!public!utility! !

!PstChangeLog class methodsFor!

current
	^Current.!

reset
	"PstChangeLog reset."
	Current isNil ifFalse: [Current detachFromClassLibrary].
	Current := self new.
	Current hookupToClassLibrary.! !
!PstChangeLog class categoriesFor: #current!accessing!public! !
!PstChangeLog class categoriesFor: #reset!accessing!public! !



PstClassDefiner comment: ''!

PstClassDefiner guid: (GUID fromString: '{A8A53124-C34F-4417-BB72-CB5024453665}')!

!PstClassDefiner categoriesForClass!No category! !
!PstClassDefiner methodsFor!

browseReferencesToOldClass
	| methods stream |
	methods := PstSystem current classLibrary
			methodsReferencingClassNamed: originalName.
	methods isEmpty ifTrue: [
		^MessageBox notify: 'No methods referenced ', originalName, ', so
renaming will not cause problems.'].
	stream := String new writeStream.
	stream
		print: methods size;
		nextPutAll: ' method';
		nextPutAll: (methods size = 1 ifTrue: [''] ifFalse: ['s']);
		nextPutAll: ' referenced ';
		nextPutAll: originalName;
		nextPut: $.;
		cr;
		nextPutAll: 'Do you want to browse ';
		nextPutAll: (methods size = 1
			ifTrue: ['that method']
			ifFalse: ['those methods']);
		nextPutAll: ' now?'.
	(MessageBox confirm: stream contents) 
		ifTrue: [
			(Smalltalk at: #PstMethodListBrowser)
				showMethodsReferencingClassNamed: originalName]
		ifFalse: [
			(MessageBox confirm: 'Do you want to abort
changes to ', originalName, '?')
				ifTrue: [self undoChanges]].!

changeClassName
	| previousName |
	previousName := originalClass name.
	previousName = className ifFalse: [
		undoBlocks add: [originalClass changeNameTo: previousName].
		originalClass changeNameTo: className.
		renamed := true].!

changeClassVars
	| previousClassVars |
	previousClassVars := originalClass classVariables.
	previousClassVars = classVarNames ifFalse: [
		undoBlocks add: [originalClass classVariables: classVarNames].
		originalClass classVariables: classVarNames.
		mustRecompile := true].!

changeInstVars
	| previousInstVars |
	previousInstVars := originalClass instVarNames.
	previousInstVars = instVarNames ifFalse: [
		undoBlocks add: [originalClass instVarNames: previousInstVars].
		originalClass instVarNames: instVarNames.
		mustRecompile := true].!

changeSubclassType
	| previousType |
	previousType := originalClass subclassType.
	previousType = classType ifFalse: [
		undoBlocks add: [originalClass beOfType: previousType].	
		originalClass beOfType: classType].!

changeSuperclass
	| previousSuperclass |
	previousSuperclass := originalClass superclass.
	previousSuperclass == superclass ifFalse: [
		undoBlocks add: [originalClass 
			changeSuperclassTo: previousSuperclass].
		originalClass changeSuperclassTo: superclass.
		mustRecompile := true].!

checkClassVarConflicts
	classVarNames asSet size ~= classVarNames size ifTrue: [
		self
			error: 'Duplicate class variable names'
			for: classVarNamesLiteral].
	classVarNames
		select: [:each |
			PstClassLibrary current hasClassNamed: each]
		do: [:each |
			self
				warning: 'Class variable shadows a class of the same name'
				for: classVarNamesLiteral].!

checkInstVarConflicts
	instVarNames asSet size ~= instVarNames size ifTrue: [
		self
			error: 'Duplicate instance variable names'
			for: instVarNamesLiteral].
	superclass isNil ifTrue: [^self].
	instVarNames 
		select: [:each | superclass includesInstanceVariable: each]
		do: [:each |
			self
				error: 'Instance variable ', each printString, ' is defined in a superclass'
				for: instVarNamesLiteral].!

checkRedefinability
	"'Basic' (built in) classes cannot be redefined in any way."
	"But we make an exception to class Object, in order to add 'global' variables."
	originalClass name = 'Object' ifTrue: [
		"Only allow changing class vars--nothing else."
		(superclass isNil and: [className = 'Object'
				and: [instVarNames isEmpty
				and: [classType = 'subclass:']]])
			ifTrue: [^self]].
	originalClass isBasic ifTrue: [
		self
			error: originalClass name, ' cannot be modified'
			for: nil].!

checkVariableConflicts
	self checkInstVarConflicts.
	self checkClassVarConflicts.!

checkVariables: string for: node
	"Extract a list of variable names from string, answering the list.  Make sure that each variable is a valid identifier."
	| vars |
	vars := string subStrings.
	vars do: [:each |
		(PstParser isValidVariableName: each) ifFalse: [
			self
				error: each printString, ' is not a valid variable name'
				for: node]].
	^vars.!

classCreationSelector
	^superclass isNil
		ifTrue: [self rootClassCreationSelector]
		ifFalse: [self normalClassCreationSelector].!

classVarNamesString
	^self stringify: classVarNames.!

createNewClass
	| subclass receiver |
	receiver := superclass isNil
		ifTrue: [PstClass]
		ifFalse: [superclass].
	subclass := receiver 
		perform: self classCreationSelector
		with: className
		with: self instVarNamesString
		with: self classVarNamesString.!

define: definition
	originalClass := nil.
	self parseDefinition: definition.
	(className = 'Object' 
			or: [PstClassLibrary current hasClassNamed: className]) 
		ifTrue: [
			"Already exists -- just redefine it, don't create a new class."
			^self
				redefine: (PstClassLibrary current classNamed: className)
				as: definition].
	self checkVariableConflicts.
	self createNewClass.!

effectChanges
	"This is only for redefining existing classes, not creating new ones."
	self assert: [originalClass notNil].
	self
		changeSuperclass;
		changeClassName;
		changeSubclassType;
		changeInstVars;
		changeClassVars.
	renamed ifTrue: [
		self browseReferencesToOldClass].!

error: message for: node
	| start stop |
	node isNil
		ifTrue: [start := stop := nil]
		ifFalse: [
			start := node start.
			stop := node stop].
	self undoChanges.
	PstCompilerError new
		message: message;
		start: start;
		stop: stop;
		signal.!

extractClassTypeFrom: message
	classType := self class classTypeForSelector: message selector.
	classType isNil ifTrue: [
		self
			error: 'Expected message definition selector'
			for: message].
	superclass isNil ifFalse: [
		(superclass canHaveSubclassOfType: classType)
			ifFalse: [
				self
					error: 'Class type mismatch (normal/indexable/byte indexable)'
					for: message]].!

extractClassVarNamesFrom: literal
	(literal isLiteralNode and: [literal value qclass name = 'String']) 
		ifFalse: [
			self
				error: 'Expected class variable names'
				for: literal].
	classVarNames := self
		checkVariables: literal value convertToString
		for: literal.
	classVarNamesLiteral := literal.!

extractInformationFrom: node
	"Make sure node (a MethodNode) is in the correct form for a class definition message.  Signal errors/warnings as appropriate.  Extract relevant information from the node and store it in the instance variables."
	| scratch message classLibrary |
	scratch := node statements.
	scratch temporaries isEmpty ifFalse: [
		self
			error: 'Temporaries are not allowed here'
			for: scratch].
	scratch statements size = 1 ifFalse: [
		self
			error: 'Expected a single class definition statement'
			for: scratch].
	scratch := scratch statements first.
	scratch class == PstMessageNode ifFalse: [
		self
			error: 'Expected a class definition statement'
			for: scratch].
	message := scratch.
	self extractSuperclassFrom: message receiver.
	self extractClassTypeFrom: message.
	self extractSubclassNameFrom: (message arguments at: 1).
	self extractInstVarNamesFrom: (message arguments at: 2).
	self extractClassVarNamesFrom: (message arguments at: 3).!

extractInstVarNamesFrom: literal
	(literal isLiteralNode and: [literal value qclass name = 'String']) 
		ifFalse: [
			self
				error: 'Expected instance variable names'
				for: literal].
	instVarNames := self
		checkVariables: literal value convertToString
		for: literal.
	instVarNamesLiteral := literal.!

extractSubclassNameFrom: literal
	| classLibrary |
	classLibrary := PstSystem current classLibrary.
	(literal isLiteralNode
			and: [literal value class == PstSymbol])
		ifFalse: [
			self
				error: 'Expected name of subclass'
				for: literal].
	className := literal value string.
	(PstParser isValidIdentifier: className) ifFalse: [
		self
			error: 'Invalid class name'
			for: literal].
	(classLibrary hasClassNamed: className)
		ifTrue: [originalClass := classLibrary classNamed: className].
	"(originalClass isNil or: [originalClass name ~= className]) ifTrue: [
		(classLibrary hasClassNamed: className) ifTrue: [
			className = 'Object' ifFalse: [
				self
					error: 'Class already exists'
					for: literal]]]."!

extractSuperclassFrom: receiver
	| classLibrary superclassName |
	superclassName := nil.
	receiver class == PstVariableNode
		ifTrue: [superclassName := receiver name].
	(receiver class == PstLiteralNode
			and: [receiver value isSymbolObject])
		ifTrue: [superclassName := receiver value string].
	superclassName isNil ifTrue: [
		self
			error: 'Expected name of superclass'
			for: receiver].
	superclassName = 'nil' ifTrue: [
		"No superclass (new root)"
		^superclass := nil].
	classLibrary := PstSystem current classLibrary.
	(classLibrary hasClassNamed: superclassName) ifFalse: [
		self
			error: 'No such class'
			for: receiver].
	superclass := classLibrary classNamed: superclassName.
	(superclass inheritsFrom: originalClass) ifTrue: [
		self
			error: originalName, ' cannot inherit from itself'
			for: receiver].
	superclass canBeSubclassed ifFalse: [
		self
			error: superclassName, ' cannot be subclassed'
			for: receiver].!

handleRecompileFail
	(MessageBox confirm: 'Recompilation failed.
Undo changes to ', originalName, '?')
		ifTrue: [self undoChanges]
		ifFalse: [
			MessageBox notify: 'Changes kept.  You will need to manually 
recompile the methods which had errors.'].!

initialize
	super initialize.
	undoBlocks := OrderedCollection new.
	mustRecompile := false.
	renamed := false.!

instVarNamesString
	^self stringify: instVarNames.!

normalClassCreationSelector
	^#(subclass:instanceVariableNames:classVariableNames:
variableSubclass:instanceVariableNames:classVariableNames:
variableByteSubclass:instanceVariableNames:classVariableNames:)
		at: (#('subclass:' 'variableSubclass:' 'variableByteSubclass:')
			indexOf: classType).!

parseDefinition: definition
	| m |
	m := PstSystem current qcompilerClass parserClass
		parseExpression: definition.
	self extractInformationFrom: m.!

recompileHierarchy
	originalClass safelyRecompileHierarchy
		ifFalse: [self handleRecompileFail].!

redefine: class as: definition
	originalClass := class.
	originalName := class name.
	self parseDefinition: definition.
	self checkRedefinability.
	self effectChanges.
	self checkVariableConflicts.
	mustRecompile ifTrue: [self recompileHierarchy].!

rootClassCreationSelector
	^#(subclassOfNil:instanceVariableNames:classVariableNames:
variableSubclassOfNil:instanceVariableNames:classVariableNames:
variableByteSubclassOfNil:instanceVariableNames:classVariableNames:)
		at: (#('subclass:' 'variableSubclass:' 'variableByteSubclass:')
			indexOf: classType).!

stringify: list
	| stream |
	stream := String new writeStream.
	list
		do: [:each | stream nextPutAll: each]
		separatedBy: [stream space].
	^stream contents.!

undoChanges
	undoBlocks reverseDo: [:each | each value].
	undoBlocks := undoBlocks copyEmpty.
	mustRecompile := false.!

warning: message for: node
	| start stop |
	node isNil
		ifTrue: [start := stop := nil]
		ifFalse: [
			start := node start.
			stop := node stop].
	self undoChanges.
	PstCompilerWarning new
		message: message;
		start: start;
		stop: stop;
		signal.
! !
!PstClassDefiner categoriesFor: #browseReferencesToOldClass!public!utility! !
!PstClassDefiner categoriesFor: #changeClassName!class defining!public! !
!PstClassDefiner categoriesFor: #changeClassVars!class defining!public! !
!PstClassDefiner categoriesFor: #changeInstVars!class defining!public! !
!PstClassDefiner categoriesFor: #changeSubclassType!class defining!public! !
!PstClassDefiner categoriesFor: #changeSuperclass!class defining!public! !
!PstClassDefiner categoriesFor: #checkClassVarConflicts!public!utility! !
!PstClassDefiner categoriesFor: #checkInstVarConflicts!public!utility! !
!PstClassDefiner categoriesFor: #checkRedefinability!public!utility! !
!PstClassDefiner categoriesFor: #checkVariableConflicts!public!utility! !
!PstClassDefiner categoriesFor: #checkVariables:for:!parsing/extracting!public! !
!PstClassDefiner categoriesFor: #classCreationSelector!class defining!public! !
!PstClassDefiner categoriesFor: #classVarNamesString!public!utility! !
!PstClassDefiner categoriesFor: #createNewClass!class defining!public! !
!PstClassDefiner categoriesFor: #define:!public!public access! !
!PstClassDefiner categoriesFor: #effectChanges!class defining!public! !
!PstClassDefiner categoriesFor: #error:for:!error handling!public! !
!PstClassDefiner categoriesFor: #extractClassTypeFrom:!parsing/extracting!public! !
!PstClassDefiner categoriesFor: #extractClassVarNamesFrom:!parsing/extracting!public! !
!PstClassDefiner categoriesFor: #extractInformationFrom:!parsing/extracting!public! !
!PstClassDefiner categoriesFor: #extractInstVarNamesFrom:!parsing/extracting!public! !
!PstClassDefiner categoriesFor: #extractSubclassNameFrom:!parsing/extracting!public! !
!PstClassDefiner categoriesFor: #extractSuperclassFrom:!parsing/extracting!public! !
!PstClassDefiner categoriesFor: #handleRecompileFail!class defining!public! !
!PstClassDefiner categoriesFor: #initialize!initialization!public! !
!PstClassDefiner categoriesFor: #instVarNamesString!public!utility! !
!PstClassDefiner categoriesFor: #normalClassCreationSelector!class defining!public! !
!PstClassDefiner categoriesFor: #parseDefinition:!parsing/extracting!public! !
!PstClassDefiner categoriesFor: #recompileHierarchy!class defining!public! !
!PstClassDefiner categoriesFor: #redefine:as:!public!public access! !
!PstClassDefiner categoriesFor: #rootClassCreationSelector!class defining!public! !
!PstClassDefiner categoriesFor: #stringify:!public!utility! !
!PstClassDefiner categoriesFor: #undoChanges!class defining!public! !
!PstClassDefiner categoriesFor: #warning:for:!error handling!public! !

!PstClassDefiner class methodsFor!

classTypeForSelector: selector
	"Answer the class type string appropriate for the given class definition selector.  Class type strings are currently one of:
	'subclass:'
	'variableSubclass:'
	'variableByteSubclass:'
Answer nil if the given selector does not correspond to one of the known class definition selectors."
	| index |
	index := #(
		'subclass:instanceVariableNames:classVariableNames:'
		'variableSubclass:instanceVariableNames:classVariableNames:'
		'variableByteSubclass:instanceVariableNames:classVariableNames:')
		indexOf: selector.
	index = 0 ifTrue: [^nil].
	^#('subclass:' 'variableSubclass:' 'variableByteSubclass:')
		at: index.! !
!PstClassDefiner class categoriesFor: #classTypeForSelector:!public!utility! !



PstClassLibrary comment: ''!

PstClassLibrary guid: (GUID fromString: '{CCB2F532-6F32-4630-939A-7E4B94257298}')!

!PstClassLibrary categoriesForClass!No category! !
!PstClassLibrary methodsFor!

addClass: qclass
	indexByName
		at: qclass name
		put: qclass.
	qclass package: PstPackage default.
	self trigger: #addedClass: with: qclass.
	^qclass.!

addedMethod: method to: class
	self
		trigger: #addedMethod:to:
		with: method
		with: class.!

addRoot: rootClass
	| sorted |
	roots add: rootClass.
	roots := PstBehavior sortClassList: roots.
	^rootClass.!

allBehaviorsDo: block
	indexByName do: [:class |
		block value: class.
		block value: class qclass]!

allImplementedSelectors
	| selectors |
	selectors := Set new.
	self allBehaviorsDo: [:each |
		selectors addAll: each selectors].
	^selectors.!

allMethodsDo: block
	self allBehaviorsDo: [:behavior | behavior methodsDo: block].!

allSentSelectors
	| selectors |
	selectors := Set new.
	self allBehaviorsDo: [:behavior |
		behavior methodsDo: [:method |
			selectors addAll: method sentSelectors]].
	^selectors.!

basicClassesDo: block
	indexByName do: [:each |
		each isBasic ifTrue: [block value: each]].!

bootstrap
	^self subclassResponsibility.!

changedNameOf: class
from: oldName
to: newName
	indexByName removeKey: oldName.
	indexByName at: newName put: class.
	PstPackageLibrary current 
		classesChangedFor: class package.
	self trigger: #changedNameOf: with: class.!

changedSuperclassOf: class
	self trigger: #changedSuperclassOf: with: class.!

checkpoint
	"Sent when the entire system is saved/filed out."
	self trigger: #checkpoint.!

classCount
	^indexByName size.!

classes
	^indexByName values asOrderedCollection.!

classesDo: block
	indexByName do: block.!

classesMatching: pattern
	| actualPattern |
	pattern isEmpty ifTrue: [^#()].  "required"
	actualPattern := pattern last == $*
		ifTrue: [pattern]
		ifFalse: [pattern copyWith: $*].
	^indexByName values select: [:each | 
		actualPattern match: each name].!

classNamed: className
	^indexByName at: className.!

classNamed: className ifAbsent: exceptionBlock
	^indexByName at: className ifAbsent: exceptionBlock.!

classTree
	"Answer a TreeModel for the current class hierarchy."
	| tree |
	tree := TreeModel new.
	self roots do: [:each | each buildTree: tree].
	^tree.!

commitBasicClassesTo: package
	self classesDo: [:class | 
		class package isNil
			ifTrue: [class package: package]].!

hasClassNamed: className
	^indexByName includesKey: className.!

initialize
	super initialize.
	indexByName := Dictionary new.
	roots := OrderedCollection new.!

makeMetaclassFor: class
	^self subclassResponsibility.!

markBasicClasses
	"Mark all current classes as 'basic' (i.e., built-in and unchangeable)."
	indexByName do: [:each | each isBasic: true].!

methodCount
	| count |
	count := 0.
	self allBehaviorsDo: [:behavior |
		count := count + behavior methodCount].
	^count.!

methodsContainingString: string
	| methods |
	methods := Set new.
	self allBehaviorsDo: [:behavior |
		methods addAll: (behavior methodsContainingString: string)].
	^methods.!

methodsReferencingClassNamed: className
	| methods |
	methods := Set new.
	self allBehaviorsDo: [:behavior |
		methods addAll: 
			(behavior methodsReferencingClassNamed: className)].
	^methods.!

methodsReferringTo: value
	"Answer a collection of all methods referring to a literal value."
	| methods |
	methods := Set new.
	self allBehaviorsDo: [:behavior |
		methods addAll: (behavior methodsReferringTo: value)].
	^methods.!

methodsReferringToConstant: constant
	| methods |
	methods := Set new.
	self allBehaviorsDo: [:behavior |
		methods addAll: 
			(behavior methodsReferringToConstant: constant)].
	^methods.!

methodsReferringToSharedVariable: variableName
	| methods |
	methods := Set new.
	self allBehaviorsDo: [:behavior |
		methods addAll: 
			(behavior methodsReferringToSharedVariable: variableName)].
	^methods.!

methodsSending: selectorString
	| methods |
	methods := Set new.
	self allBehaviorsDo: [:behavior |
		methods addAll: (behavior methodsSending: selectorString)].
	^methods.!

methodsWithPrimitives
	| methods |
	methods := OrderedCollection new.
	self allMethodsDo: [:method |
		method primitive isNil
			ifFalse: [methods add: method]].
	^methods.!

methodsWithSelector: string
	| methods |
	methods := Set new.
	self allBehaviorsDo: [:behavior |
		methods addAll: (behavior methodsWithSelector: string)].
	^methods.!

mostFrequentlySentSelectors: predicateBlock
	"Answer a collection of up to 240 of the most frequently sent selectors in the system.  This can be used to optimize message sends from 3 bytes to 2 bytes during code generation."
	"Witness the true power of Smalltalk :)"
	| counts sorted |
	"Dictionary is used here rather than Bag because Bag is really kind of useless, even though it would be sort of appropriate here."
	counts := Dictionary new.
	self classesDo: [:each |
		each methodsDo: [:method |
			method instructions do: [:instruction |
				instruction isSend ifTrue: [
					(predicateBlock value: instruction selector) ifTrue: [
						counts
							at: instruction selector
							put: (counts at: instruction selector ifAbsent: [0]) + 1]]]]].
	"Now counts maps selector -> number of occurrences"
	"Sort them in decreasing order of frequency"
	sorted := SortedCollection sortBlock: 
		[:left :right | left value > right value].
	sorted addAll: counts associations.
	^(sorted
		copyFrom: 1
		to: (sorted size min: 240)) asOrderedCollection
			collect: [:each | each key].!

objectClass
	^self classNamed: 'Object'.!

reclassifiedMethod: method of: ownerClass
	self
		trigger: #reclassifiedMethod:of:
		with: method
		with: ownerClass.!

recompiledBehavior: behavior
	self
		trigger: #recompiledBehavior:
		with: behavior.!

removeClass: qclass ifFail: reasonBlock
	"Try to remove 'qclass' from the system.  If it's not possible, evaluate 'reasonBlock' with a string describing what went wrong."
	qclass subclasses isEmpty
		ifFalse: [^reasonBlock value: 'it has subclasses'].
	(self hasClassNamed: qclass name)
		ifFalse: [^reasonBlock value: 'it has already been removed'].
	qclass isBasic
		ifTrue: [^reasonBlock value: 'it is a permanent class'].
	qclass beRemoved.
	indexByName removeKey: qclass name.
	self trigger: #removedClass: with: qclass.
	!

removedMethod: method from: class
	self
		trigger: #removedMethod:from:
		with: method
		with: class.!

removeRoot: rootClass
	^roots remove: rootClass.!

roots
	^roots.!

selectorsImplementedButNotSent
	^self allImplementedSelectors - self allSentSelectors!

selectorsSentButNotImplemented
	^self allSentSelectors - self allImplementedSelectors.!

sortMethods: methodList
	| sorted |
	sorted := methodList asSortedCollection: [:left :right |
		left fullDisplayString <= right fullDisplayString].
	^sorted asOrderedCollection.!

system
	^PstSystem current.!

topologicallySortClasses: classes
	| sorted set |
	sorted := self topologicallySortedClasses.
	set := IdentitySet withAll: classes.
	^sorted select: [:each | set includes: each].!

topologicallySortedClasses
	"Answer all the classes in the system in an order where every class is followed by its subclasses."
	| stream |
	stream := Array new writeStream.
	roots do: [:each | each topologicalSortOn: stream].
	^stream contents.!

uncommittedClasses
	"Answer the classes that are in the 'uncommitted' package."
	^self classes select: [:each | each package isUncommitted].!

ungenerateAll
	self classesDo: [:each | each ungenerate].! !
!PstClassLibrary categoriesFor: #addClass:!class creation!public! !
!PstClassLibrary categoriesFor: #addedMethod:to:!event handling!public! !
!PstClassLibrary categoriesFor: #addRoot:!public!utility! !
!PstClassLibrary categoriesFor: #allBehaviorsDo:!enumerating!public! !
!PstClassLibrary categoriesFor: #allImplementedSelectors!public!utility! !
!PstClassLibrary categoriesFor: #allMethodsDo:!enumerating!public! !
!PstClassLibrary categoriesFor: #allSentSelectors!public!utility! !
!PstClassLibrary categoriesFor: #basicClassesDo:!enumerating!public! !
!PstClassLibrary categoriesFor: #bootstrap!*-subclass responsibility!bootstrapping!public! !
!PstClassLibrary categoriesFor: #changedNameOf:from:to:!event handling!public! !
!PstClassLibrary categoriesFor: #changedSuperclassOf:!event handling!public! !
!PstClassLibrary categoriesFor: #checkpoint!event handling!public! !
!PstClassLibrary categoriesFor: #classCount!accessing!public! !
!PstClassLibrary categoriesFor: #classes!accessing!public! !
!PstClassLibrary categoriesFor: #classesDo:!enumerating!public! !
!PstClassLibrary categoriesFor: #classesMatching:!public!searching! !
!PstClassLibrary categoriesFor: #classNamed:!accessing!public! !
!PstClassLibrary categoriesFor: #classNamed:ifAbsent:!accessing!public! !
!PstClassLibrary categoriesFor: #classTree!accessing!public! !
!PstClassLibrary categoriesFor: #commitBasicClassesTo:!public!utility! !
!PstClassLibrary categoriesFor: #hasClassNamed:!accessing!public! !
!PstClassLibrary categoriesFor: #initialize!initialization!public! !
!PstClassLibrary categoriesFor: #makeMetaclassFor:!*-subclass responsibility!public!utility! !
!PstClassLibrary categoriesFor: #markBasicClasses!bootstrapping!public! !
!PstClassLibrary categoriesFor: #methodCount!accessing!public! !
!PstClassLibrary categoriesFor: #methodsContainingString:!public!searching! !
!PstClassLibrary categoriesFor: #methodsReferencingClassNamed:!public!searching! !
!PstClassLibrary categoriesFor: #methodsReferringTo:!public!searching! !
!PstClassLibrary categoriesFor: #methodsReferringToConstant:!public!searching! !
!PstClassLibrary categoriesFor: #methodsReferringToSharedVariable:!public!searching! !
!PstClassLibrary categoriesFor: #methodsSending:!public!searching! !
!PstClassLibrary categoriesFor: #methodsWithPrimitives!public!searching! !
!PstClassLibrary categoriesFor: #methodsWithSelector:!public!searching! !
!PstClassLibrary categoriesFor: #mostFrequentlySentSelectors:!public!utility! !
!PstClassLibrary categoriesFor: #objectClass!accessing!public! !
!PstClassLibrary categoriesFor: #reclassifiedMethod:of:!event handling!public! !
!PstClassLibrary categoriesFor: #recompiledBehavior:!event handling!public! !
!PstClassLibrary categoriesFor: #removeClass:ifFail:!public!utility! !
!PstClassLibrary categoriesFor: #removedMethod:from:!event handling!public! !
!PstClassLibrary categoriesFor: #removeRoot:!public!utility! !
!PstClassLibrary categoriesFor: #roots!accessing!public! !
!PstClassLibrary categoriesFor: #selectorsImplementedButNotSent!public!utility! !
!PstClassLibrary categoriesFor: #selectorsSentButNotImplemented!public!utility! !
!PstClassLibrary categoriesFor: #sortMethods:!public!utility! !
!PstClassLibrary categoriesFor: #system!accessing!public! !
!PstClassLibrary categoriesFor: #topologicallySortClasses:!public!utility! !
!PstClassLibrary categoriesFor: #topologicallySortedClasses!accessing!public! !
!PstClassLibrary categoriesFor: #uncommittedClasses!public!utility! !
!PstClassLibrary categoriesFor: #ungenerateAll!public!utility! !

!PstClassLibrary class methodsFor!

current
	^PstSystem current classLibrary.! !
!PstClassLibrary class categoriesFor: #current!accessing!public! !



PstCodeGenerator comment: ''!

PstCodeGenerator guid: (GUID fromString: '{07742665-4094-447C-8009-74E0F36D2167}')!

!PstCodeGenerator categoriesForClass!No category! !
!PstCodeGenerator methodsFor!

debugging
	^PstSystem current
		booleanProperty: 'debug'
		ifAbsent: [true].!

generateCode
	^self subclassResponsibility.!

indexOfSelector: selector
	^(selectorTable includesKey: selector)
		ifTrue: [selectorTable at: selector]
		ifFalse: [
			selectorData 
				nextPutAll: selector asByteArray;
				nextPut: 0.
			selectorData position > 5000 ifTrue: [
				selectorDataSegments add: selectorData contents.
				selectorData := ByteArray new writeStream].
			selectorTable
				at: selector
				put: selectorTable size + 1.
			selectorTable size].!

indexOfSharedVar: variableName
forClass: ownerClass
	| specifier |
	specifier := ownerClass name, '.', variableName.
	(globalMap includesKey: specifier)
		ifTrue: [^globalMap at: specifier].
	^globalMap
		at: specifier
		put: globalMap size.!

initialize
	super initialize.
	selectorTable := Dictionary new.
	objectTable := Dictionary new.
	compiledClassTable := IdentityDictionary new.
	compiledObjectData := ByteArray new writeStream.
	classOffsets := OrderedCollection new.
	selectorData := ByteArray new writeStream.
	selectorDataSegments := OrderedCollection new.
	globalMap := Dictionary new.!

optimized: boolean
	^self subclassResponsibility.!

system
	^PstSystem current.! !
!PstCodeGenerator categoriesFor: #debugging!accessing!public! !
!PstCodeGenerator categoriesFor: #generateCode!*-subclass responsibility!generating!public! !
!PstCodeGenerator categoriesFor: #indexOfSelector:!accessing!public! !
!PstCodeGenerator categoriesFor: #indexOfSharedVar:forClass:!accessing!public! !
!PstCodeGenerator categoriesFor: #initialize!initialization!public! !
!PstCodeGenerator categoriesFor: #optimized:!*-subclass responsibility!initialization!public! !
!PstCodeGenerator categoriesFor: #system!accessing!public! !

!PstCodeGenerator class methodsFor!

generateCodeForSystem: system
optimized: optimized
on: stream
	| generator |
	generator := self on: stream.
	generator optimized: optimized.
	^generator generateCode.!

on: stream
	^self subclassResponsibility.!

specialSelectors
	^#('basicStart' 'not' '+' '-' '<=' '>=' '<' '>' 'doesNotUnderstand:' 'basicAt:'
'basicAt:put:' 'mustBeBoolean' 'contextAlreadyReturned' 'badTrapArgument:' 'badGeosArgument:' 'exit').! !
!PstCodeGenerator class categoriesFor: #generateCodeForSystem:optimized:on:!public!utility! !
!PstCodeGenerator class categoriesFor: #on:!*-subclass responsibility!instance creation!public! !
!PstCodeGenerator class categoriesFor: #specialSelectors!public!utility! !



PstCompiledClass comment: ''!

PstCompiledClass guid: (GUID fromString: '{48E2F7EF-C162-4C22-BB87-1E3DA99FB6AC}')!

!PstCompiledClass categoriesForClass!No category! !
!PstCompiledClass methodsFor!

addCode: byteArray forSelector: selectorIndex
	compiledMethods add: selectorIndex -> byteArray.!

compiledMethods

	^compiledMethods!

deferCleanBlock: blockClosure
forSelector: selector
generator: generator
	(deferredBlocks
		at: (generator indexOfSelector: selector)
		ifAbsentPut: [OrderedCollection new])
			add: blockClosure.!

initialize
	super initialize.
	compiledMethods := OrderedCollection new.
	deferredBlocks := IdentityDictionary new.!

resolveDeferredBlocksFor: selectorIndex at: offset
	| blocks |
	blocks := deferredBlocks at: selectorIndex ifAbsent: [nil].
	blocks isNil ifTrue: [^self].
	blocks do: [:each | each offset: each offset + offset].!

sortMethods
	"Create a collection of associations (selector ID -> compiled bytes), in ascending order of selector ID."
	sortedMethods := compiledMethods asSortedCollection:
		[:left :right | left key <= right key].!

writeBinaryOn: stream
for: generator
	self
		writeSelectorTableOn: stream
		for: generator.
	self writeMethodTableOn: stream.
	generator align: stream.!

writeMethodTableOn: stream
	"Write a ByteArray containing the compiled bytes of the method table."
	"Deferred blocks are also resolved here."
	sortedMethods do: [:association |
		stream nextPutAll: association value].!

writeSelectorTableOn: stream
for: generator
	"The selector table has one entry for each selector defined in the class.  Each entry consists of a 2-byte selector value followed by a 2-byte instruction offset."
	"The selectors are sorted in ascending order."
	self sortMethods.
	"Write the number of methods."
	PstSystem current storeWord: sortedMethods size on: stream.
	sortedMethods 
		inject: 0
		into: [:offset :each |
			self 
				resolveDeferredBlocksFor: each key
				at: offset.
			PstSystem current storeWord: each key on: stream.
			PstSystem current storeWord: offset on: stream.
			offset + each value size].! !
!PstCompiledClass categoriesFor: #addCode:forSelector:!public!utility! !
!PstCompiledClass categoriesFor: #compiledMethods!accessing!public! !
!PstCompiledClass categoriesFor: #deferCleanBlock:forSelector:generator:!public!utility! !
!PstCompiledClass categoriesFor: #initialize!initialization!public! !
!PstCompiledClass categoriesFor: #resolveDeferredBlocksFor:at:!public!utility! !
!PstCompiledClass categoriesFor: #sortMethods!public!utility! !
!PstCompiledClass categoriesFor: #writeBinaryOn:for:!public!utility! !
!PstCompiledClass categoriesFor: #writeMethodTableOn:!public!utility! !
!PstCompiledClass categoriesFor: #writeSelectorTableOn:for:!public!utility! !



PstCompiler comment: ''!

PstCompiler guid: (GUID fromString: '{937B80E0-86EE-4BE7-B657-583D6128ABE8}')!

!PstCompiler categoriesForClass!No category! !
!PstCompiler methodsFor!

addOne
	"default implementation"
	self
		pushInteger: 1;
		send: '+' argumentCount: 1.!

addPhantom: name
	"Add a phantom variable to this scope, possibly reusing one that has already been created and abandoned.  Answer a VariableReference that can be used to refer to the phantom.
	name can be either nil or an explicit name."
	phantoms addLast: name.
	phantomMax := phantoms size max: phantomMax.
	^PstVariableReference
		type: #argument 
		name: (self nameForPhantom: phantoms size)
		index: argumentsHere size + temporariesHere size + phantoms size - 1
		distance: 0.
	!

argumentCount
	^argumentsHere size.!

checkPostconditions
	self assert: [phantoms isEmpty].!

compilationClass
	^compilationClass.!

compilationClass: object
	compilationClass := object.!

compileConditionalBlock: block
	"If block is a BlockNode, inline it normally.  Otherwise, if it is true, false, or nil, compile it as [true], [false], or [nil], respectively."
	block == true ifTrue: [^self pushTrue].
	block == false ifTrue: [^self pushFalse].
	block == nil ifTrue: [^self pushNil].
	self inlineBlock: block.
!

compileMethod: methodNode 
	^self subclassResponsibility.!

compiling: node
	self sourcePosition:
		((node isNil or: [node start isNil or: [node stop isNil]])
			ifTrue: [nil]
			ifFalse: [node sourcePosition]).!

compilingReceiverlessMethod
	^false.!

emit: instruction
	instruction sourcePosition: sourcePosition.
	^instructions add: instruction.!

error: message for: node
	| start stop |
	node isNil
		ifTrue: [start := stop := nil]
		ifFalse: [
			start := node start.
			stop := node stop].
	PstCompilerError new
		message: message;
		start: start;
		stop: stop;
		signal.!

inlineBlock: blockNode
	^self
		inlineBlock: blockNode
		preserveLast: true.!

inlineBlock: blockNode preserveLast: preserveLast
	self saveStackDepthDuring: [
		blockNode statements 
			compileOn: self
			preserveLast: preserveLast].
	self notePush.!

instructions
	^instructions.!

isBlockCompiler
	^false.!

isMinimal
	^self subclassResponsibility.!

jump
	^self subclassResponsibility.!

jumpDestination
	^self subclassResponsibility.!

jumpIfFalse
	^self subclassResponsibility.!

localVariableCount
	^argumentsHere size + temporariesHere size + phantomMax!

methodSelector
	^methodSelector.!

nameForPhantom: index
	^(phantoms at: index) isNil
		ifTrue: ['phantom_', index printString]
		ifFalse: [(phantoms at: index), ' : phantom'].!

notePop
	^self.!

notePops: count
	count timesRepeat: [self notePop].!

notePush
	^self.!

optimizeAnd: message
	^self
		optimizeConditional: message
		arguments: 1
		trueBlock: message arguments first
		falseBlock: false
		isNilFirst: false.!

optimizeBodylessLoop: message
condition: condition
	"condition is true for #whileTrue, false for #whileFalse"
	| loopHead jumpToEnd |
	(message
		checkArgument: 0
		forBlockWithArguments: 0
		for: self) ifFalse: [^false].
	loopHead := self jumpDestination.
	self inlineBlock: message receiver.
	condition ifFalse: [self send: 'not' argumentCount: 0].
	jumpToEnd := self jumpIf: false.
	self jump destination: loopHead.
	jumpToEnd destination: self jumpDestination.
	self pushNil.
	^true.!

optimizeBodylessWhileFalse: message
	^self
		optimizeBodylessLoop: message
		condition: false.!

optimizeBodylessWhileTrue: message
	^self
		optimizeBodylessLoop: message
		condition: true.!

optimizeConditional: message
arguments: argumentCount
trueBlock: trueBlock
falseBlock: falseBlock
isNilFirst: isNilFirst
	| jump jumpToEnd |
	((1 to: argumentCount) allSatisfy: [:index |
		message
			checkArgument: 1
			forBlockWithArguments: 0
			for: self])
		ifFalse: [^false].
	message compileReceiverOn: self.
	isNilFirst ifTrue: [self send: 'isNil' argumentCount: 0].
	self notePop.  "flag is popped implicitly"
	jump := self jumpIf: false.
	self compileConditionalBlock: trueBlock.
	self notePop.  "pseudopop of first branch"
	jumpToEnd := self jump.
	jump destination: self jumpDestination.
	self compileConditionalBlock: falseBlock.
	jumpToEnd destination: self jumpDestination.
	"stack depth here should be the same as when we began"
	^true.!

optimizeIfFalse: message
	^self
		optimizeConditional: message
		arguments: 1
		trueBlock: nil
		falseBlock: message arguments first
		isNilFirst: false.!

optimizeIfFalseIfTrue: message
	^self
		optimizeConditional: message
		arguments: 2
		trueBlock: (message arguments at: 2)
		falseBlock: message arguments first
		isNilFirst: false.!

optimizeIfNil: message
	^self
		optimizeConditional: message
		arguments: 1
		trueBlock: message arguments first
		falseBlock: nil
		isNilFirst: true.!

optimizeIfNilIfNotNil: message
	^self
		optimizeConditional: message
		arguments: 2
		trueBlock: message arguments first
		falseBlock: (message arguments at: 2)
		isNilFirst: true.!

optimizeIfNotNil: message
	^self
		optimizeConditional: message
		arguments: 1
		trueBlock: nil
		falseBlock: message arguments first
		isNilFirst: true.!

optimizeIfNotNilIfNil: message
	^self
		optimizeConditional: message
		arguments: 2
		trueBlock: (message arguments at: 2)
		falseBlock: message arguments first
		isNilFirst: true.!

optimizeIfTrue: message
	^self
		optimizeConditional: message
		arguments: 1
		trueBlock: message arguments first
		falseBlock: nil
		isNilFirst: false.!

optimizeIfTrueIfFalse: message
	^self
		optimizeConditional: message
		arguments: 2
		trueBlock: message arguments first
		falseBlock: (message arguments at: 2)
		isNilFirst: false.!

optimizeMessage: messageNode
	^(self class optimizesMessage: messageNode selector)
		ifTrue: [self 
			perform: (self class
				optimizationSelectorFor: messageNode selector)
			with: messageNode]
		ifFalse: [false].!

optimizeOr: message
	^self
		optimizeConditional: message
		arguments: 1
		trueBlock: true
		falseBlock: message arguments first
		isNilFirst: false.!

optimizeRepeat: message
	| loopHead |
	(message
			checkArgument: 0
			forBlockWithArguments: 0
			for: self)
		ifFalse: [^false].
	loopHead := self jumpDestination.
	self
		inlineBlock: message receiver 
		preserveLast: false.
	self jump destination: loopHead.
	^true.!

optimizesMessage: selector
	^false.!

optimizesSelfCascades
	^self subclassResponsibility.!

optimizesSelfSends
	^self subclassResponsibility.!

optimizesSpecialReturns
	^self subclassResponsibility.!

optimizeTimesRepeat: message
	"iterations timesRepeat: [...]"
	| loopHead jumpToEnd |
	(message
		checkArgument: 1
		forBlockWithArguments: 0
		for: self) ifFalse: [^false].
	message compileReceiverOn: self.
	loopHead := self jumpDestination.
	self
		dup;
		pushInteger: 1;
		send: '>=' argumentCount: 1.
	jumpToEnd := self jumpIf: false.
	self
		inlineBlock: message arguments first
		preserveLast: false.
	self subtractOne.
	self jump destination: loopHead.
	jumpToEnd destination: self jumpDestination.
	"Return value is the index counter (useless)"
	^true.!

optimizeToByDo: message
	"start to: limit by: step do: [:each | ...]"
	"This is fairly complex because we need to take into account both positive and negative step values."
	| loopCounter step limit loopHead jumpToEnd testJump jumpToBody |
	(message
		checkArgument: 3
		forBlockWithArguments: 1
		for: self) ifFalse: [^false].
	"Compile and store limit value"
	message arguments first
		compileOn: self
		pop: false.
	limit := self addPhantom: nil.
	self storeVariable: limit.
	"Compile and store step value"
	(message arguments at: 2) 
		compileOn: self 
		pop: false.
	step := self addPhantom: nil.
	self dup; storeVariable: step.
	"Compile and store loop counter"
	message compileReceiverOn: self.
	loopCounter := self addPhantom:
		(message arguments at: 3) 
			arguments first.  "1st (and only) block argument"
	self storeVariable: loopCounter.
	"Determine sign of step value (leave true/false value on stack)."
	self pushInteger: 0.
	self send: '<' argumentCount: 1.
	loopHead := self jumpDestination.
	self pushVariable: loopCounter.
	self over.
	testJump := self jumpIf: false.  "jump if not negative"
	"Here, the step value is negative (loop counter is on stack)."
	self pushVariable: limit.
	self send: '>=' argumentCount: 1.
	jumpToBody := self jump.
	testJump destination: self jumpDestination.
	self pushVariable: limit.
	self send: '<=' argumentCount: 1.
	jumpToBody destination: self jumpDestination.
	jumpToEnd := self jumpIf: false.
	"Compile body."
	self
		inlineBlock: (message arguments at: 3)
		preserveLast: false.
	"Increment loop counter."
	self 
		pushVariable: loopCounter;
		pushVariable: step;
		send: '+' argumentCount: 1;
		storeVariable: loopCounter.
	"Loop again."
	self jump destination: loopHead.
	jumpToEnd destination: self jumpDestination.
	"On stack: true/false, which we can leave there as the (useless) return value."
	3 timesRepeat: [self releasePhantom].
	^true.!

optimizeToDo: message
	"start to: limit do: [:each | ...]"
	| loopCounter limit loopHead jumpToEnd |
	(message
		checkArgument: 2
		forBlockWithArguments: 1
		for: self) ifFalse: [^false].
	"Compile and store limit value"
	message arguments first
		compileOn: self 
		pop: false.
	limit := self addPhantom: nil.
	self storeVariable: limit.
	"Compile and store loop counter"
	message compileReceiverOn: self.
	loopCounter := self addPhantom:
		(message arguments at: 2) 
			arguments first.  "1st (and only) block argument"
	self storeVariable: loopCounter.
	loopHead := self jumpDestination.
	self 
		pushVariable: loopCounter;
		pushVariable: limit.
	self send: '<=' argumentCount: 1.
	jumpToEnd := self jumpIf: false.
	"Compile body."
	self
		inlineBlock: (message arguments at: 2)
		preserveLast: false.
	"Increment loop counter."
	self 
		pushVariable: loopCounter;
		addOne;
		storeVariable: loopCounter.
	"Loop again."
	self jump destination: loopHead.
	jumpToEnd destination: self jumpDestination.
	2 timesRepeat: [self releasePhantom].
	self pushNil.  "return value - sort of useless"
	^true.!

optimizeWhileFalse: message
	^self
		optimizeWhileLoop: message
		condition: false.!

optimizeWhileLoop: message
condition: condition
	"condition is true for  #whileTrue:, false for #whileFalse:"
	| loopHead jumpToEnd |
	((0 to: 1) allSatisfy: [:index |
		message
			checkArgument: index
			forBlockWithArguments: 0
			for: self])
		ifFalse: [^false].
	loopHead := self jumpDestination.
	self inlineBlock: message receiver.
	condition ifFalse: [self send: 'not' argumentCount: 0].
	jumpToEnd := self jumpIf: false.
	self 
		inlineBlock: message arguments first
		preserveLast: false.
	self jump destination: loopHead.
	jumpToEnd destination: self jumpDestination.
	self pushNil.
	^true.!

optimizeWhileTrue: message
	^self
		optimizeWhileLoop: message
		condition: true.!

prepareToCompile
	instructions := OrderedCollection new.
	phantomMax := 0.
	phantoms := OrderedCollection new.!

pushClass: reference
	^self subclassResponsibility.!

pushFalse
	^self subclassResponsibility.!

pushInstVar: reference
	^self subclassResponsibility.!

pushInteger: integer
	^self subclassResponsibility.!

pushLocal: reference
	^self subclassResponsibility.!

pushNil
	^self subclassResponsibility.!

pushSelf
	^self subclassResponsibility.!

pushSharedVariable: reference
	^self subclassResponsibility.!

pushThisContext
	^self subclassResponsibility.!

pushTrue
	^self subclassResponsibility.!

pushVariable: reference
	reference isLocal
		ifTrue: [^self pushLocal: reference].
	reference isShared
		ifTrue: [^self pushSharedVariable: reference].
	reference isInstVar
		ifTrue: [^self pushInstVar: reference].
	reference isClass
		ifTrue: [^self pushClass: reference index].
	self error: 'bad variable type?'.!

reallyResolveVariable: variableName
	"Resolve an argument, temporary, or instance variable; answer nil if unresolved."
	"Local variables get first precedence."
	| reference |
	reference := self resolveTemporaryVariableHere: variableName.
	reference isNil ifFalse: [^reference].
	reference := self resolveInstanceVariable: variableName.
	reference isNil ifFalse: [^reference].
	reference := self resolveSharedVariable: variableName.
	reference isNil ifFalse: [^reference].
	^self resolveClassReference: variableName.!

releasePhantom
	"Release (abandon) the most recently created phantom variable."
	phantoms removeLast.!

resolveClassReference: variableName
	^(compilationClass classLibrary
			hasClassNamed: variableName)
		ifTrue: [
			PstVariableReference
				type: #class
				name: variableName
				index: (compilationClass classLibrary classNamed: variableName)
				distance: 0]
		ifFalse: [nil].!

resolveInstanceVariable: variableName
	| index |
	index := compilationClass
		indexOfInstanceVariable: variableName.
	index = 0 ifTrue: [^nil].
	index := index - 1.
	^PstVariableReference
		type: #instance
		name: variableName
		index: index
		distance: 0.!

resolvePhantomVariable: variableName
	| name |
	phantoms size to: 1 by: -1 do: [:index |
		name := phantoms at: index.
		(name notNil and: [name = variableName]) ifTrue: [
			^PstVariableReference
				type: #temporary
				name: (self nameForPhantom: index)
				index: temporariesHere size + argumentsHere size + index - 1
				distance: 0]].
	^nil.!

resolveSharedVariable: variableName
	"Shared variables are currently always class variables.  Global variables can be simulated by adding class variables to Object."
	| class |
	class := compilationClass.
	class isMeta ifTrue: [class := class uniqueInstance].
	[class isNil] whileFalse: [
		(class definesClassVariable: variableName) ifTrue: [
			^PstVariableReference
				type: #shared
				name: variableName
				index: nil
				distance: class].
		class := class superclass].
	^nil.!

resolveTemporaryVariableHere: variableName
	"If the variable exists _in this scope_, answer the VariableReference.  Otherwise, answer nil."
	| index type ref |
	ref := self resolvePhantomVariable: variableName.
	ref isNil ifFalse: [^ref].
	type := nil.
	index := argumentsHere indexOf: variableName.
	index = 0 
		ifTrue: [
			index := temporariesHere indexOf: variableName.
			index > 0 ifTrue: [index := index + argumentsHere size].
			type := #temporary]
		ifFalse: [type := #argument].
	index = 0 ifTrue: [^nil].
	index := index - 1.
	^PstVariableReference
		type: type
		name: variableName
		index: index
		distance: 0.!

resolveVariable: name
	"Redefined by PstBlockCompiler to search the parent chain."
	^self reallyResolveVariable: name.!

return: type
	^self subclassResponsibility.!

saveStackDepthDuring: block
	"compiler classes which actually keep track of stack depth will need to reimplement this ..."
	block value.!

sourcePosition: intervalOrNil
	sourcePosition := intervalOrNil.!

storeInstVar: reference
	^self subclassResponsibility.!

storeLocal: reference
	^self subclassResponsibility.!

storeSharedVariable: reference
	^self subclassResponsibility.!

storeVariable: reference
	reference isLocal
		ifTrue: [^self storeLocal: reference].
	reference isShared
		ifTrue: [^self storeSharedVariable: reference].
	reference isInstVar
		ifTrue: [^self storeInstVar: reference].
	self error: 'bad variable type?'.!

subtractOne
	"default implementation"
	self
		pushInteger: 1;
		send: '-' argumentCount: 1.!

undefinedVariable: varName for: node
	self 
		error: 'Undefined variable: ', varName
		for: node.!

warning: message for: node
	| start stop |
	node isNil
		ifFalse: [start := stop := nil]
		ifTrue: [
			start := node start.
			stop := node stop].
	PstCompilerWarning new
		message: message;
		start: start;
		stop: stop;
		signal.! !
!PstCompiler categoriesFor: #addOne!instructions!public! !
!PstCompiler categoriesFor: #addPhantom:!public!variables! !
!PstCompiler categoriesFor: #argumentCount!accessing!public! !
!PstCompiler categoriesFor: #checkPostconditions!compiling!public! !
!PstCompiler categoriesFor: #compilationClass!accessing!public! !
!PstCompiler categoriesFor: #compilationClass:!accessing!public! !
!PstCompiler categoriesFor: #compileConditionalBlock:!compiling!public! !
!PstCompiler categoriesFor: #compileMethod:!*-subclass responsibility!compiling!public! !
!PstCompiler categoriesFor: #compiling:!accessing!public! !
!PstCompiler categoriesFor: #compilingReceiverlessMethod!predicates!public! !
!PstCompiler categoriesFor: #emit:!instructions!public! !
!PstCompiler categoriesFor: #error:for:!error handling!public! !
!PstCompiler categoriesFor: #inlineBlock:!compiling!public! !
!PstCompiler categoriesFor: #inlineBlock:preserveLast:!compiling!public! !
!PstCompiler categoriesFor: #instructions!accessing!public! !
!PstCompiler categoriesFor: #isBlockCompiler!predicates!public! !
!PstCompiler categoriesFor: #isMinimal!*-subclass responsibility!predicates!public! !
!PstCompiler categoriesFor: #jump!*-subclass responsibility!instructions!public! !
!PstCompiler categoriesFor: #jumpDestination!*-subclass responsibility!instructions!public! !
!PstCompiler categoriesFor: #jumpIfFalse!*-subclass responsibility!instructions!public! !
!PstCompiler categoriesFor: #localVariableCount!accessing!public! !
!PstCompiler categoriesFor: #methodSelector!accessing!public! !
!PstCompiler categoriesFor: #nameForPhantom:!public!variables! !
!PstCompiler categoriesFor: #notePop!public!stack management! !
!PstCompiler categoriesFor: #notePops:!public!stack management! !
!PstCompiler categoriesFor: #notePush!public!stack management! !
!PstCompiler categoriesFor: #optimizeAnd:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeBodylessLoop:condition:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeBodylessWhileFalse:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeBodylessWhileTrue:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeConditional:arguments:trueBlock:falseBlock:isNilFirst:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeIfFalse:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeIfFalseIfTrue:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeIfNil:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeIfNilIfNotNil:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeIfNotNil:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeIfNotNilIfNil:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeIfTrue:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeIfTrueIfFalse:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeMessage:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeOr:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeRepeat:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizesMessage:!predicates!public! !
!PstCompiler categoriesFor: #optimizesSelfCascades!*-subclass responsibility!predicates!public! !
!PstCompiler categoriesFor: #optimizesSelfSends!*-subclass responsibility!predicates!public! !
!PstCompiler categoriesFor: #optimizesSpecialReturns!*-subclass responsibility!predicates!public! !
!PstCompiler categoriesFor: #optimizeTimesRepeat:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeToByDo:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeToDo:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeWhileFalse:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeWhileLoop:condition:!optimized messages!public! !
!PstCompiler categoriesFor: #optimizeWhileTrue:!optimized messages!public! !
!PstCompiler categoriesFor: #prepareToCompile!initialization!public! !
!PstCompiler categoriesFor: #pushClass:!*-subclass responsibility!instructions!public! !
!PstCompiler categoriesFor: #pushFalse!*-subclass responsibility!instructions!public! !
!PstCompiler categoriesFor: #pushInstVar:!*-subclass responsibility!instructions!public! !
!PstCompiler categoriesFor: #pushInteger:!*-subclass responsibility!instructions!public! !
!PstCompiler categoriesFor: #pushLocal:!*-subclass responsibility!instructions!public! !
!PstCompiler categoriesFor: #pushNil!*-subclass responsibility!instructions!public! !
!PstCompiler categoriesFor: #pushSelf!*-subclass responsibility!instructions!public! !
!PstCompiler categoriesFor: #pushSharedVariable:!*-subclass responsibility!instructions!public! !
!PstCompiler categoriesFor: #pushThisContext!*-subclass responsibility!instructions!public! !
!PstCompiler categoriesFor: #pushTrue!*-subclass responsibility!instructions!public! !
!PstCompiler categoriesFor: #pushVariable:!compiling!public! !
!PstCompiler categoriesFor: #reallyResolveVariable:!public!variables! !
!PstCompiler categoriesFor: #releasePhantom!public!variables! !
!PstCompiler categoriesFor: #resolveClassReference:!public!variables! !
!PstCompiler categoriesFor: #resolveInstanceVariable:!public!variables! !
!PstCompiler categoriesFor: #resolvePhantomVariable:!public!variables! !
!PstCompiler categoriesFor: #resolveSharedVariable:!public!variables! !
!PstCompiler categoriesFor: #resolveTemporaryVariableHere:!public!variables! !
!PstCompiler categoriesFor: #resolveVariable:!public!variables! !
!PstCompiler categoriesFor: #return:!*-subclass responsibility!instructions!public! !
!PstCompiler categoriesFor: #saveStackDepthDuring:!public!stack management! !
!PstCompiler categoriesFor: #sourcePosition:!accessing!public! !
!PstCompiler categoriesFor: #storeInstVar:!*-subclass responsibility!instructions!public! !
!PstCompiler categoriesFor: #storeLocal:!*-subclass responsibility!instructions!public! !
!PstCompiler categoriesFor: #storeSharedVariable:!*-subclass responsibility!instructions!public! !
!PstCompiler categoriesFor: #storeVariable:!compiling!public! !
!PstCompiler categoriesFor: #subtractOne!instructions!public! !
!PstCompiler categoriesFor: #undefinedVariable:for:!error handling!public! !
!PstCompiler categoriesFor: #warning:for:!error handling!public! !

!PstCompiler class methodsFor!

compile: string in: qclass
	| methodNode compiler method |
	methodNode := self parserClass parseString: string.
	compiler := self new.
	compiler compilationClass: qclass.
	methodNode compileOn: compiler.
	method := PstMethod new.
	method
		instructions: compiler instructions;
		ownerClass: qclass;
		selector: methodNode selector;
		sourceCode: string;
		commentMap: methodNode commentMap;
		keywordMap: methodNode pattern keywordRanges;
		argumentMap: methodNode pattern argumentRanges.
	method renumberInstructions.
	methodNode primitive isNil ifFalse: [
		method primitive: methodNode primitive].
	^method.!

compile: string in: qclass notifying: manager
	| method |
	manager resetExpressionOffset.
	[method := self compile: string in: qclass]
		on: PstCompilerError
		do: [:exception |
			manager
				handleError: exception message
				from: exception start
				to: exception stop.
			^nil]
		on: PstCompilerWarning
		do: [:exception |
			manager
				handleWarning: exception message
				from: exception start
				to: exception stop.
			exception resume: self].
	^method.!

initialize
	"PstCompiler initialize."
	optimizationTable := Dictionary new.
	optimizationTable
		at: 'ifTrue:' put: #optimizeIfTrue:;
		at: 'ifFalse:' put: #optimizeIfFalse:;
		at: 'ifTrue:ifFalse:' put: #optimizeIfTrueIfFalse:;
		at: 'ifFalse:ifTrue:' put: #optimizeIfFalseIfTrue:;
		at: 'and:' put: #optimizeAnd:;
		at: 'or:' put: #optimizeOr:;
		at: 'repeat' put: #optimizeRepeat:;
		at: 'timesRepeat:' put: #optimizeTimesRepeat:;
		at: 'to:do:' put: #optimizeToDo:;
		at: 'to:by:do:' put: #optimizeToByDo:;
		at: 'whileTrue:' put: #optimizeWhileTrue:;
		at: 'whileFalse:' put: #optimizeWhileFalse:;
		at: 'whileTrue' put: #optimizeBodylessWhileTrue:;
		at: 'whileFalse' put: #optimizeBodylessWhileFalse:;
		at: 'ifNil:' put: #optimizeIfNil:;
		at: 'ifNotNil:' put: #optimizeIfNotNil:;
		at: 'ifNil:ifNotNil:' put: #optimizeIfNilIfNotNil:;
		at: 'ifNotNil:ifNil:' put: #optimizeIfNotNilIfNil:.!

optimizationSelectorFor: selector
	^optimizationTable at: selector.!

optimizesMessage: selector
	^optimizationTable includesKey: selector.!

parserClass
	^self subclassResponsibility.! !
!PstCompiler class categoriesFor: #compile:in:!public!utility! !
!PstCompiler class categoriesFor: #compile:in:notifying:!public!utility! !
!PstCompiler class categoriesFor: #initialize!initialization!public! !
!PstCompiler class categoriesFor: #optimizationSelectorFor:!optimization!public! !
!PstCompiler class categoriesFor: #optimizesMessage:!optimization!public! !
!PstCompiler class categoriesFor: #parserClass!*-subclass responsibility!accessing!public! !



PstConstant comment: ''!

PstConstant guid: (GUID fromString: '{0FECF4DF-5372-41B1-B014-A4AB1026A805}')!

!PstConstant categoriesForClass!No category! !
!PstConstant methodsFor!

category
	^category.!

category: object
	category := object.!

displayOn: stream
	stream
		nextPutAll: '##';
		nextPutAll: self name.!

library
	^PstConstantsLibrary current.!

name
	^name.!

name: object
	name := object.!

package
	^package.!

package: newPackage
	package == newPackage ifTrue: [^self].
	package isNil ifFalse: [package removeConstant: self].
	package := newPackage.
	package isNil ifFalse: [package addConstant: self].
	self library constantChanged: self.!

unstringify
	| object |
	object := PstSystem current parserClass
		parseSimpleLiteral: value.
	object isNil ifTrue: [^self error: 'Could not parse constant value.'].
	value := object.!

value
	^value.!

value: object
	value := object.
	self library constantChanged: self.! !
!PstConstant categoriesFor: #category!accessing!public! !
!PstConstant categoriesFor: #category:!accessing!public! !
!PstConstant categoriesFor: #displayOn:!printing!public! !
!PstConstant categoriesFor: #library!accessing!public! !
!PstConstant categoriesFor: #name!accessing!public! !
!PstConstant categoriesFor: #name:!accessing!public! !
!PstConstant categoriesFor: #package!accessing!public! !
!PstConstant categoriesFor: #package:!accessing!public! !
!PstConstant categoriesFor: #unstringify!*-unclassified!public! !
!PstConstant categoriesFor: #value!accessing!public! !
!PstConstant categoriesFor: #value:!accessing!public! !

!PstConstant class methodsFor!

isValidConstantName: string
	^PstParser isValidIdentifier: string.! !
!PstConstant class categoriesFor: #isValidConstantName:!predicates!public! !



PstConstantsLibrary comment: ''!

PstConstantsLibrary guid: (GUID fromString: '{594611DD-09CF-4188-91DC-CC056CD39803}')!

!PstConstantsLibrary categoriesForClass!No category! !
!PstConstantsLibrary methodsFor!

addCategoryNamed: name
	categories 
		at: name 
		put: self newCategoryCollection.
	self trigger: #organizationChanged.!

bootstrap
	| cat |
	cat := 'System Properties'.
	self addCategoryNamed: cat.
	self define: 'debug' as: PstBasicObject forTrue classified: cat.
	self define: 'optimization' as: PstBasicObject forFalse classified: cat.
	self define: 'dataStackSize' as: (PstInteger value: 300) classified: cat.
	self define: 'callStackSize' as: (PstInteger value: 100) classified: cat.
	self define: 'heapSize' as: (PstInteger value: 2000) classified: cat.
	self define: 'objectTableSize' as: (PstInteger value: 1000) classified: cat.
	self 
		define: 'applicationTitle' 
		as: (PstByteIndexableObject newString: 'Smalltalk App')
		classified: cat.
	self
		define: 'creatorID'
		as: (PstByteIndexableObject newString: 'PkST')
		classified: cat.
	self addCategoryNamed: 'Resource Databases'.!

categoryNamed: name
	^categories at: name.!

categoryNames
	^categories keys asSortedCollection.!

constantChanged: constant
	self trigger: #constantChanged: with: constant.!

constantNamed: name
	^constantsByName at: name.!

constantNamed: name ifAbsent: exceptionBlock
	^constantsByName 
		at: name
		ifAbsent: exceptionBlock.!

define: constantName as: value classified: categoryName
	"The constantName must not already exist and must be a valid identifier."
	| constant |
	constant := PstConstant new
		name: constantName;
		value: value;
		category: categoryName;
		package: PstPackage default.
	(self categoryNamed: categoryName) add: constant.
	constantsByName at: constantName put: constant.
	self trigger: #categoryChanged: with: categoryName.!

ensureCategoryExists: categoryName
	"Create the category if it doesn't exist yet."
	(self hasCategoryNamed: categoryName)
		ifFalse: [self addCategoryNamed: categoryName].!

fileOutConstants: constants
forCategory: categoryName
on: manager
	constants isEmpty ifTrue: [^self].
	manager
		bang;
		nextPutAll: 'Object constantsFor: ';
		nextPutAll: categoryName printString;
		bang; cr.
	constants do: [:each |
		manager
			cr;
			nextPutAll: each name;
			space;
			nextPutAll: each value displayString;
			bang; space].
	manager endChunk.!

fileOutOn: manager
	self categoryNames do: [:each |
		self 
			fileOutConstants: (self categoryNamed: each)
			forCategory: each
			on: manager].!

fileOutOn: manager inPackage: package
	| constants |
	self categoryNames do: [:each |
		constants := (self categoryNamed: each)
			select: [:constant | constant package == package].
		self 
			fileOutConstants: constants
			forCategory: each
			on: manager].!

findConstant: pattern
	constantsByName keysAndValuesDo: [:name :constant |
		(pattern match: name) ifTrue: [^constant]].
	^nil.!

geosLibraries
	| libraries constantName constant |
	libraries := OrderedCollection new.
	0 to: 127 do: [ :index |
	 constantName := 'geosLIB', index printString.
	 (self hasConstantNamed: constantName)
		ifTrue: [
		 constant := self constantNamed: constantName.
		 constant value qclass name = 'String' 
			ifTrue: [libraries add: ((String with: (Character value: index)), constant value convertToString)]
			ifFalse: [MessageBox notify: 
				'Constant ##', constantName, ' is not a string.']].
	].
	^libraries!

hasCategoryNamed: name
	^categories includesKey: name.!

hasConstantNamed: name
	^constantsByName includesKey: name.!

initialize
	super initialize.
	categories := Dictionary new.
	constantsByName := Dictionary new.!

newCategoryCollection
	^SortedCollection sortBlock:
		[:left :right | left name <= right name].!

nextGeosLibraryConstantName
	"Answer a constant name for a new geosLibrary constant.  Does not actually create the constant."
	| n name |
	n := 1.
	[name := 'geosLIB', n printString.
	 (self hasConstantNamed: name) ifFalse: [^name].
	 n := n + 1] repeat.!

nextResourceDBConstantName
	"Answer a constant name for a new resourceDB constant.  Does not actually create the constant."
	| n name |
	n := 1.
	[name := 'resourceDB', n printString.
	 (self hasConstantNamed: name) ifFalse: [^name].
	 n := n + 1] repeat.!

reclassify: constantName as: categoryName
	| constant |
	constant := self constantNamed: constantName.
	constant category = categoryName ifTrue: [^self].
	(self categoryNamed: constant category) 
		remove: constant.
	self trigger: #categoryChanged: with: constant category.
	constant category: categoryName.
	(self categoryNamed: categoryName) 
		add: constant.
	self trigger: #categoryChanged: with: categoryName.!

removeCategory: name
	"Note: categories must be empty before they can be removed."
	self assert: [(self categoryNamed: name) isEmpty].
	categories removeKey: name.
	self trigger: #organizationChanged.!

removeConstantNamed: name
	| constant |
	constant := self constantNamed: name.
	constant package removeConstant: constant.
	(self categoryNamed: constant category) remove: constant.
	constantsByName removeKey: name.
	self trigger: #categoryChanged: with: constant category.!

renameCategory: oldName to: newName
	| category |
	category := categories at: oldName.
	categories removeKey: oldName.
	categories at: newName put: category.
	category do: [:constant | constant category: newName].
	self trigger: #organizationChanged.!

renameConstantNamed: oldName to: newName
	| constant |
	constant := self constantNamed: oldName.
	constantsByName removeKey: oldName.
	constant name: newName.
	constantsByName at: newName put: constant.
	self trigger: #categoryChanged: with: constant category.!

resourceDatabases
	| databases index constantName constant |

	databases := OrderedCollection new.
	index := 1.
	[constantName := 'resourceDB', index printString.
	 (self hasConstantNamed: constantName)
		ifFalse: [^databases].
	 constant := self constantNamed: constantName.
	 constant value qclass name = 'String' 
		ifTrue: [databases add: (PstResourceDatabase
			fromFile: constant value convertToString)]
		ifFalse: [MessageBox notify: 
			'Constant ##', constantName, ' is not a string.'].
	 index := index + 1] repeat.! !
!PstConstantsLibrary categoriesFor: #addCategoryNamed:!categories!public! !
!PstConstantsLibrary categoriesFor: #bootstrap!initialization!public! !
!PstConstantsLibrary categoriesFor: #categoryNamed:!categories!public! !
!PstConstantsLibrary categoriesFor: #categoryNames!categories!public! !
!PstConstantsLibrary categoriesFor: #constantChanged:!constants!public! !
!PstConstantsLibrary categoriesFor: #constantNamed:!constants!public! !
!PstConstantsLibrary categoriesFor: #constantNamed:ifAbsent:!constants!public! !
!PstConstantsLibrary categoriesFor: #define:as:classified:!constants!public! !
!PstConstantsLibrary categoriesFor: #ensureCategoryExists:!categories!public! !
!PstConstantsLibrary categoriesFor: #fileOutConstants:forCategory:on:!fileout!public! !
!PstConstantsLibrary categoriesFor: #fileOutOn:!fileout!public! !
!PstConstantsLibrary categoriesFor: #fileOutOn:inPackage:!fileout!public! !
!PstConstantsLibrary categoriesFor: #findConstant:!constants!public! !
!PstConstantsLibrary categoriesFor: #geosLibraries!*-unclassified!public! !
!PstConstantsLibrary categoriesFor: #hasCategoryNamed:!categories!public! !
!PstConstantsLibrary categoriesFor: #hasConstantNamed:!constants!public! !
!PstConstantsLibrary categoriesFor: #initialize!initialization!public! !
!PstConstantsLibrary categoriesFor: #newCategoryCollection!*-unclassified!private! !
!PstConstantsLibrary categoriesFor: #nextGeosLibraryConstantName!*-unclassified!public! !
!PstConstantsLibrary categoriesFor: #nextResourceDBConstantName!public!utility! !
!PstConstantsLibrary categoriesFor: #reclassify:as:!constants!public! !
!PstConstantsLibrary categoriesFor: #removeCategory:!categories!public! !
!PstConstantsLibrary categoriesFor: #removeConstantNamed:!constants!public! !
!PstConstantsLibrary categoriesFor: #renameCategory:to:!categories!public! !
!PstConstantsLibrary categoriesFor: #renameConstantNamed:to:!constants!public! !
!PstConstantsLibrary categoriesFor: #resourceDatabases!public!utility! !

!PstConstantsLibrary class methodsFor!

current
	^PstSystem current constantsLibrary.! !
!PstConstantsLibrary class categoriesFor: #current!accessing!public! !



PstDeadCodeEliminator comment: ''!

PstDeadCodeEliminator guid: (GUID fromString: '{CC58DEF6-C7D5-4EA7-8B50-CE7373F34BD8}')!

!PstDeadCodeEliminator categoriesForClass!No category! !
!PstDeadCodeEliminator methodsFor!

initialize
	super initialize.
	keptBehaviors := IdentitySet new.
	keptSelectors := Set new.
	keptMethods := IdentitySet new.!

keepBehavior: behavior
	| class |
	class := behavior isMeta
		ifTrue: [behavior uniqueInstance]
		ifFalse: [behavior].
	(keptBehaviors includes: class) ifFalse: [
		changed := true.
		class withAllSuperclasses do: [:each |
			keptBehaviors add: each.
			keptBehaviors add: each qclass]].!

keepSelector: selector
	(keptSelectors includes: selector) ifFalse: [
		keptSelectors add: selector.
		changed := true].!

keptBehaviors
	^keptBehaviors.!

keptMethods
	^keptMethods.!

keptSelectors
	^keptSelectors.!

sweep
	changed := false.
	keptBehaviors copy do: [:behavior | self traceBehavior: behavior].
	^changed.!

traceBehavior: behavior
	behavior methodsDo: [:method |
		(keptSelectors includes: method selector)
			ifTrue: [self traceMethod: method]].!

traceFrom: initialMethod
	"Always keep 'basic' classes..."
	PstClassLibrary current
		basicClassesDo: [:each | self keepBehavior: each].
	"...and 'special' selectors sent by the  VM..."
	PstCodeGenerator specialSelectors
		do: [:each | self keepSelector: each].
	self traceMethod: initialMethod.
	[self sweep] whileTrue.!

traceMethod: method
	(keptMethods includes: method)
		ifTrue: [^self].
	keptMethods add: method.
	self keepBehavior: method ownerClass.
	method instructions do: [:instruction |
		instruction possiblySentSelectorsDo: 
			[:selector | self keepSelector: selector].
		instruction referencedClass isNil ifFalse: [
			self keepBehavior: instruction referencedClass]].! !
!PstDeadCodeEliminator categoriesFor: #initialize!initialization!public! !
!PstDeadCodeEliminator categoriesFor: #keepBehavior:!public!tracing! !
!PstDeadCodeEliminator categoriesFor: #keepSelector:!public!tracing! !
!PstDeadCodeEliminator categoriesFor: #keptBehaviors!accessing!public! !
!PstDeadCodeEliminator categoriesFor: #keptMethods!accessing!public! !
!PstDeadCodeEliminator categoriesFor: #keptSelectors!accessing!public! !
!PstDeadCodeEliminator categoriesFor: #sweep!public!tracing! !
!PstDeadCodeEliminator categoriesFor: #traceBehavior:!public!tracing! !
!PstDeadCodeEliminator categoriesFor: #traceFrom:!public!tracing! !
!PstDeadCodeEliminator categoriesFor: #traceMethod:!public!tracing! !

!PstDeadCodeEliminator class methodsFor!

trace
	"PstDeadCodeEliminator trace."
	| method |
	method := (PstClassLibrary current classNamed: 'Smalltalk') qclass
		lookupMethod: 'basicStart'.
	^method isNil
		ifTrue: [nil]
		ifFalse: [self trace: method].!

trace: method
	| tracer |
	tracer := self new.
	tracer traceFrom: method.
	^tracer.! !
!PstDeadCodeEliminator class categoriesFor: #trace!public!utility! !
!PstDeadCodeEliminator class categoriesFor: #trace:!public!utility! !



PstDocumentationGenerator comment: ''!

PstDocumentationGenerator guid: (GUID fromString: '{D35C8701-1002-49D7-A18E-A04F6B64E80B}')!

!PstDocumentationGenerator categoriesForClass!No category! !
!PstDocumentationGenerator methodsFor!

bold: string
	stream
		nextPutAll: '<b>';
		nextPutAll: string;
		nextPutAll: '</b>'.!

generateDocumentationFor: class
on: outputStream
	currentClass := class.
	stream := outputStream.
	self writeDocumentation.!

generateIndexOf: classes forPackage: package on: outputStream
	stream := outputStream.
	self writeIndexOfClasses: classes forPackage: package.!

htmlify: string
	| result |
	result := String new writeStream.
	!

italic: string
	stream
		nextPutAll: '<i>';
		nextPutAll: string;
		nextPutAll: '</i>'.!

writeClassComment
	| comment |
	comment := currentClass comment.
	comment isNil ifTrue: [^self].
	comment := comment trimBlanks.
	comment isEmpty ifTrue: [^self].
	self writeHTML: comment.
	stream nextPutAll: '<p>'; cr.!

writeClassDefinition
	self bold: currentClass name.
	currentClass superclass isNil
		ifTrue: [stream nextPutAll: ' has no superclass.']
		ifFalse: [
			stream nextPutAll: ' inherits from '.
			self writeClassLink: currentClass superclass].
	currentClass instVarNames isEmpty
		ifTrue: [
			stream nextPutAll: ' and defines no instance variables.']
		ifFalse: [
			stream nextPutAll: (currentClass instVarNames size == 1
				ifTrue: [' and defines the instance variable ']
				ifFalse: [' and defines instance variables ']).
			currentClass instVarNames
				do: [:each | self bold: each]
				separatedBy: [stream nextPutAll: ', '].
			stream nextPut: $.].
	stream nextPutAll: '  '.!

writeClassLink: class
	stream
		nextPutAll: '<a href="';
		nextPutAll: class name;
		nextPutAll: '.html">';
		nextPutAll: class name;
		nextPutAll: '</a>'.!

writeDocumentation
	self 
		writeHeader;
		writeClassDefinition;
		writeSubclasses;
		writeClassComment;
		writeMethods;
		writeFooter.!

writeFooter
	stream
		nextPutAll: '<hr>'; cr;
		nextPutAll: '<i>Pocket Smalltalk Documentation</i>'; cr; cr;
		nextPutAll: '</body>'; cr;
		nextPutAll: '</html>'; cr; cr.!

writeHeader
	stream
		nextPutAll: '<html>'; cr;
		nextPutAll: '<head>'; cr;
		nextPutAll: '<title>';
		nextPutAll: currentClass name;
		nextPutAll: ' documentation</title>'; cr;
		nextPutAll: '</head>'; cr; cr;
		nextPutAll: '<body>'; cr; cr;
		nextPutAll: '<h1 align=center>';
		nextPutAll: currentClass name;
		nextPutAll: '</h1>'; cr;
		nextPutAll: '<hr><br>'; cr; cr.!

writeHTML: string
	"(string lines select: [:each | each notEmpty])"
	string lines
		do: [:each | stream nextPutAll: each]
		separatedBy: [stream nextPutAll: '<br>'; cr; cr].
	stream cr.!

writeIndexHeader: package
	| comment |
	stream
		nextPutAll: '<html>'; cr;
		nextPutAll: '<head>'; cr;
		nextPutAll: '<title>'; cr;
		nextPutAll: 'Classes in package ''';
		nextPutAll: package simpleName;
		nextPut: $';
		nextPutAll: '</title>'; cr;
		nextPutAll: '</head>'; cr; cr;
		nextPutAll: '<body>'; cr; cr;
		nextPutAll: '<h1 align=center>';
		nextPutAll: 'Classes in package ''';
		nextPutAll: package simpleName;
		nextPut: $';
		nextPutAll: '</h1>'; cr;
		nextPutAll: '<hr><br>'; cr; cr.
	comment := package comment.
	comment isNil ifTrue: [^self].
	self writeHTML: comment.
	stream nextPutAll: '<br>'; cr.!

writeIndexOfClasses: classes forPackage: package
	self writeIndexHeader: package.
	stream nextPutAll: '<ul>'; cr.
	classes do: [:class |
		stream nextPutAll: '  <li> '.
		self writeClassLink: class.
		stream cr].
	stream nextPutAll: '</ul>'; cr; cr.
	self writeFooter.!

writeMethod: method
	| keywordMap argumentMap comment |
	keywordMap := method keywordMap.
	argumentMap := method argumentMap.
	stream nextPutAll: '  <li>'.
	keywordMap keysAndValuesDo: [:index :keyword |
		stream space.
		self bold: (method sourceCode 
			copyFrom: keyword first
			to: keyword last).
		index <= argumentMap size ifTrue: [
			stream space; nextPutAll: (method sourceCode
				copyFrom: (argumentMap at: index) first
				to: (argumentMap at: index) last)]].
	comment := method firstComment.
	comment isNil ifFalse: [
		stream 
			nextPutAll: '<br>'; cr;
			nextPutAll: '       <i>'.
		self writeHTML: comment.
		stream nextPutAll: '</i>'].
	stream cr.!

writeMethods
	((self writeMethodsForClass: currentClass)
			or: [self writeMethodsForClass: currentClass qclass])
		ifFalse: [
			stream
				nextPutAll: currentClass name;
				nextPutAll: ' defines no methods.<p>'; cr; cr].!

writeMethodsForClass: ownerClass
	"Answer whether any methods were written."
	| methods categories |
	"Only count the methods defined in the class's package, not extensions."
	methods := ownerClass methods select: [:each | each package isNil].
	methods isEmpty ifTrue: [^false].
	stream
		nextPutAll: '<h2>Methods defined in ';
		nextPutAll: ownerClass name;
		nextPutAll: ':</h2>'; cr; cr.
	categories := ownerClass sortedCategories
		select: [:each | ((ownerClass methodsInCategory: each)
				select: [:method | method package isNil]) notEmpty].
	categories do: [:category |
		stream nextPutAll: '<h3>'.
		category = 'uncategorized'
			ifTrue: [stream nextPutAll: 'Uncategorized methods']
			ifFalse: [
				stream
					nextPutAll: 'Methods for ';
					nextPutAll: category].
		stream
			nextPutAll: ':</h3>'; cr; cr;
			nextPutAll: '<ul>'; cr.
		(ownerClass class sortMethods: 
				(ownerClass methodsInCategory: category))
			do: [:method | self writeMethod: method].
		stream nextPutAll: '</ul>'; cr; cr].
	^true.!

writeSubclasses
	| plural |
	currentClass subclasses isEmpty
		ifTrue: [^stream nextPutAll: 'It has no subclasses.<p>'; cr].
	currentClass subclasses size > 6
		ifTrue: [^stream nextPutAll: 'It has many subclasses (not listed here).<p>'; cr].
	plural := currentClass subclasses size > 1.
	stream nextPutAll: (plural
		ifTrue: ['It has subclasses ']
		ifFalse: ['It has a subclass: ']).
	currentClass subclasses 
		do: [:subclass |
			(plural and: [subclass == currentClass subclasses last])
				ifTrue: [stream nextPutAll: 'and '].
			self writeClassLink: subclass]
		separatedBy: [currentClass subclasses size == 2 
			ifTrue: [stream space]
			ifFalse: [stream nextPutAll: ', ']].
	stream nextPutAll: '.<p>'; cr.! !
!PstDocumentationGenerator categoriesFor: #bold:!HTML output!public! !
!PstDocumentationGenerator categoriesFor: #generateDocumentationFor:on:!public!public access! !
!PstDocumentationGenerator categoriesFor: #generateIndexOf:forPackage:on:!public!public access! !
!PstDocumentationGenerator categoriesFor: #htmlify:!HTML output!public! !
!PstDocumentationGenerator categoriesFor: #italic:!HTML output!public! !
!PstDocumentationGenerator categoriesFor: #writeClassComment!public!writing! !
!PstDocumentationGenerator categoriesFor: #writeClassDefinition!public!writing! !
!PstDocumentationGenerator categoriesFor: #writeClassLink:!HTML output!public! !
!PstDocumentationGenerator categoriesFor: #writeDocumentation!public!writing! !
!PstDocumentationGenerator categoriesFor: #writeFooter!public!writing! !
!PstDocumentationGenerator categoriesFor: #writeHeader!public!writing! !
!PstDocumentationGenerator categoriesFor: #writeHTML:!HTML output!public! !
!PstDocumentationGenerator categoriesFor: #writeIndexHeader:!public!writing! !
!PstDocumentationGenerator categoriesFor: #writeIndexOfClasses:forPackage:!public!writing! !
!PstDocumentationGenerator categoriesFor: #writeMethod:!public!writing! !
!PstDocumentationGenerator categoriesFor: #writeMethods!public!writing! !
!PstDocumentationGenerator categoriesFor: #writeMethodsForClass:!public!writing! !
!PstDocumentationGenerator categoriesFor: #writeSubclasses!public!writing! !

!PstDocumentationGenerator class methodsFor!

defaultFilenameForPackage: package
	^package simpleName, '_index.html'.!

primitiveMap
	| methods table stream |
	methods := PstClassLibrary current methodsWithPrimitives.
	table := Dictionary new.
	methods do: [:each |
		(table includesKey: each primitive)
			ifFalse: [table at: each primitive put: OrderedCollection new].
		(table at: each primitive) add: each].
	stream := String new writeStream.
	table keys asSortedCollection do: [:primitive |
		stream
			print: primitive;
			tab.
		(table at: primitive)
			do: [:each | stream nextPutAll: each fullDisplayString]
			separatedBy: [stream nextPutAll: ', '].
		stream cr].
	^stream contents.!

writeDocumentationFor: class
toFileNamed: filename
	| stream |
	stream := FileStream write: filename.
	[self new
			generateDocumentationFor: class
			on: stream]
		ensure: [stream close].!

writeIndexOf: classes
forPackage: package
toFileNamed: filename
	| stream |
	stream := FileStream write: filename.
	[self new
			generateIndexOf: classes
			forPackage: package
			on: stream]
		ensure: [stream close].!

writePackageDocumentation: package
toDirectory: baseDirectory
indexFileNamed: indexFilename
	self
		writeIndexOf: package classes
		forPackage: package
		toFileNamed: baseDirectory, indexFilename, '.html'.
	package classes do: [:class |
		self
			writeDocumentationFor: class
			toFileNamed: baseDirectory, class name, '.html'].! !
!PstDocumentationGenerator class categoriesFor: #defaultFilenameForPackage:!public!utility! !
!PstDocumentationGenerator class categoriesFor: #primitiveMap!public!utility! !
!PstDocumentationGenerator class categoriesFor: #writeDocumentationFor:toFileNamed:!public!utility! !
!PstDocumentationGenerator class categoriesFor: #writeIndexOf:forPackage:toFileNamed:!public!utility! !
!PstDocumentationGenerator class categoriesFor: #writePackageDocumentation:toDirectory:indexFileNamed:!public!utility! !



PstFileOutManager comment: ''!

PstFileOutManager guid: (GUID fromString: '{61E2A48B-DFD4-417C-8AD1-7A69A4EDA0AE}')!

!PstFileOutManager categoriesForClass!No category! !
!PstFileOutManager methodsFor!

bang
	stream nextPut: $!!.!

cr
	stream cr.!

endChunk
	stream nextPut: $!!; cr; cr.!

extractCategoryFrom: tokens startingAt: start
	| buffer |
	buffer := String new writeStream.
	(tokens copyFrom: start to: tokens size)
		do: [:each | buffer nextPutAll: (each copyWithout: $')]
		separatedBy: [buffer space].
	methodCategory := buffer contents.!

fileIn
	| chunk |
	[(chunk := self nextChunk) notNil] whileTrue: [
		[self interpretChunk: chunk]
			on: PstCompilerError
			do: [:exception |
				(self handleException: exception isError: true)
					ifFalse: [^self]]
			on: PstCompilerWarning
			do: [:exception |
				(self handleException: exception isError: false)
					ifFalse: [^self]]].


	"| chunk dialog total |
	total := stream size.
	dialog := ProgressDialog new.
	dialog
		caption: 'Reading source code...';
		operation: [:progress |
			[(chunk := self nextChunk) notNil] whileTrue: [
				progress value: stream position / total.
				self interpretChunk: chunk]];
		showModal."!

fileInError: message
	| exception |
	"fake the exception..."
	exception := PstCompilerError new	message: message.
	self
		handleException: exception
		isError: true.!

filename: string
	filename := string.!

fileOutHeader
	self
		cr;
		bang;
		nextPutAll: '"Pocket Smalltalk fileout - ';
		nextPutAll: TimeStamp current displayString;
		nextPut: $";
		endChunk; 
		cr.!

handleException: exception isError: isError
	| messageStream |
	messageStream := String new writeStream.
	messageStream
		nextPutAll: (isError 
			ifTrue: ['Error'] ifFalse: ['Warning']).
	filename isNil ifFalse: [
		messageStream
			nextPutAll: ' in ';
			nextPutAll: filename].
	messageStream
		nextPutAll: ' near line ';
		print: lineNumber;
		nextPutAll: ': ';
		nextPutAll: exception message;
		cr;
		nextPutAll: 'Continue loading source code?'.
	^MessageBox confirm: messageStream contents.!

interpretChunk: chunk
	chunk isEmpty ifTrue: [^definingClass := nil].
	(self class isCommentChunk: chunk) ifTrue: [^self].
	expectingClassComment
		ifTrue: [^self interpretClassCommentChunk: chunk].
	^definingClass isNil
		ifTrue: [self interpretMetaChunk: chunk]
		ifFalse: [self perform: definitionSelector with: chunk].!

interpretClassChunk: chunk
	PstClassDefiner new define: chunk.
	!

interpretClassCommentChunk: chunk
	definingClass isNil
		ifTrue: [self fileInError: 'Comment definition for nonexistent class.']
		ifFalse: [definingClass comment: chunk].
	expectingClassComment := false.!

interpretConstantChunk: chunk
	"Format: 'constantName value'"
	| constantName valueString value library |
	constantName := chunk subStrings first.
	valueString := chunk copyFrom: constantName size + 1 to: chunk size.
	value := PstSmalltalkParser
		parseSimpleLiteral: valueString.
	value isNil ifTrue: [^self].
	library := PstConstantsLibrary current.
	(library hasCategoryNamed: methodCategory)
		ifFalse: [library addCategoryNamed: methodCategory].
	(library hasConstantNamed: constantName)
		ifTrue: [(library constantNamed: constantName) 
				value: value;
				package: PstPackage default]
		ifFalse: [library define: constantName as: value classified: methodCategory].!

interpretDefinerChunk: tokens
definitionSelector: selector
expectCategory: expectCategory
	| classLibrary hasClass |
	classLibrary := PstClassLibrary current.
	(classLibrary hasClassNamed: tokens first) ifFalse: [
		^self fileInError: 'No class named ', tokens first printString].
	definingClass := classLibrary classNamed: tokens first.
	hasClass := (tokens at: 2) = 'class'.
	hasClass ifTrue: [definingClass := definingClass qclass].
	definitionSelector := selector.
	expectCategory ifTrue: [
		self 
			extractCategoryFrom: tokens
			startingAt: (hasClass ifTrue: [4] ifFalse: [3])].!

interpretMetaChunk: chunk
	| tokens |
	tokens := chunk subStrings.
	tokens size = 2 ifTrue: [
		(tokens at: 2) = 'comment' ifTrue: [
			expectingClassComment := true.
			^self 
				interpretDefinerChunk: tokens
				definitionSelector: #interpretClassCommentChunk:
				expectCategory: false]].
	(tokens size >= 2 and: [
		(tokens at: 2) = 'methodsFor:'
			or: [(tokens at: 2) = 'class'
				and: [(tokens at: 3) = 'methodsFor:']]])
		ifTrue: [
			^self 
				interpretDefinerChunk: tokens
				definitionSelector: #interpretMethodChunk:
				expectCategory: true].
	(tokens size >= 3 and: [(tokens at: 2) = 'constantsFor:']) ifTrue: [
		^self
			interpretDefinerChunk: tokens
			definitionSelector: #interpretConstantChunk:
			expectCategory: true].
	(tokens size >= 3 and: [(tokens at: 2) = 'requirePackage:']) ifTrue: [
		^self requirePackage: ((tokens at: 3) copyWithout: $')].
	^self interpretClassChunk: chunk.!

interpretMethodChunk: chunk
	| method |
	definingClass isNil ifTrue: [
		^self fileInError: 'Method definition for nonexistent class.'].
	method := PstSystem current qcompilerClass
		compile: chunk
		in: definingClass.
	method isNil ifFalse: [
		definingClass 
			installMethod: method
			classified: methodCategory.
		method package: PstPackage default].!

lineNumber
	"This is only valid when filing in, not filing out."
	^lineNumber.!

nextChunk
	"Answer the next chunk-format string from the input stream."
	"Answer nil if there is nothing left."
	| chunk char |
	stream atEnd ifTrue: [^nil].
	chunk := String new writeStream.
	stream skipSeparators.
	[stream atEnd] whileFalse: [
		char := stream next.
		char == ##(Character cr) 
			ifTrue: [lineNumber := lineNumber + 1].
		char == $!! ifTrue: [
			"Is there another !! immediately after?"
			(stream peekFor: $!!) ifFalse: [
				"No, this is a chunk terminator."
				^chunk contents]].
		chunk nextPut: char].
	^chunk contents.!

nextPut: character
	stream nextPut: character.
	character == $!! ifTrue: [stream nextPut: character].!

nextPutAll: string
	string do: [:each | self nextPut: each].!

requirePackage: name
	"the currently loaded package requires the named package to be loaded"
	| path |
	path := File fullPathOf: name relativeTo: (File splitPathFrom: filename).
	(PstSystem current packageLibrary hasPackageNamed: path) ifFalse: [
		^self fileInError: 'The package "', filename, '" requires a package "', path, '" to be loaded first'].!

space
	stream space.!

stream: textStream
	stream := textStream.
	lineNumber := 1.
	expectingClassComment := false.! !
!PstFileOutManager categoriesFor: #bang!public!writing! !
!PstFileOutManager categoriesFor: #cr!public!writing! !
!PstFileOutManager categoriesFor: #endChunk!public!writing! !
!PstFileOutManager categoriesFor: #extractCategoryFrom:startingAt:!public!reading! !
!PstFileOutManager categoriesFor: #fileIn!public!reading! !
!PstFileOutManager categoriesFor: #fileInError:!public!utility! !
!PstFileOutManager categoriesFor: #filename:!initialization!public! !
!PstFileOutManager categoriesFor: #fileOutHeader!public!writing! !
!PstFileOutManager categoriesFor: #handleException:isError:!public!utility! !
!PstFileOutManager categoriesFor: #interpretChunk:!public!reading! !
!PstFileOutManager categoriesFor: #interpretClassChunk:!public!reading! !
!PstFileOutManager categoriesFor: #interpretClassCommentChunk:!public!reading! !
!PstFileOutManager categoriesFor: #interpretConstantChunk:!public!reading! !
!PstFileOutManager categoriesFor: #interpretDefinerChunk:definitionSelector:expectCategory:!public!reading! !
!PstFileOutManager categoriesFor: #interpretMetaChunk:!public!reading! !
!PstFileOutManager categoriesFor: #interpretMethodChunk:!public!reading! !
!PstFileOutManager categoriesFor: #lineNumber!accessing!public! !
!PstFileOutManager categoriesFor: #nextChunk!public!reading! !
!PstFileOutManager categoriesFor: #nextPut:!public!writing! !
!PstFileOutManager categoriesFor: #nextPutAll:!public!writing! !
!PstFileOutManager categoriesFor: #requirePackage:!public!reading! !
!PstFileOutManager categoriesFor: #space!public!writing! !
!PstFileOutManager categoriesFor: #stream:!initialization!public! !

!PstFileOutManager class methodsFor!

fileIn: filename
	| stream |
	stream := FileStream read: filename.
	[self fileInFrom: stream filename: filename]
		ensure: [stream close].!

fileInFrom: stream filename: filenameOrNil
	| filer |
	filer := self on: stream.
	filer filename: filenameOrNil.
	Cursor wait showWhile: [filer fileIn].!

fileOutPackage: package on: stream
	| manager |
	manager := self on: stream.
	manager fileOutHeader.
	package fileOutOn: manager.!

fileOutSystemOn: stream
	"File out non-basic classes."
	| classes manager |
	manager := self on: stream.
	manager fileOutHeader.
	"Constants need to come first."
	PstConstantsLibrary current fileOutOn: manager.
	classes := PstClassLibrary current
		topologicallySortedClasses.
	"Always file out Object in case there are global variables defined there."
	PstClassLibrary current objectClass
		fileOutDefinitionOn: manager.
	classes
		select: [:each | each isBasic not]
		do: [:each | each fileOutDefinitionOn: manager].
	classes do: [:each |
		each fileOutCommentOn: manager.
		each hasMethods
			ifTrue: [each fileOutMethodsOn: manager].
		(each qclass notNil and: [each qclass hasMethods])
			ifTrue: [each qclass fileOutMethodsOn: manager]].
!

isCommentChunk: chunk
	^chunk first == $".!

on: stream
	^self new stream: stream.! !
!PstFileOutManager class categoriesFor: #fileIn:!public!utility! !
!PstFileOutManager class categoriesFor: #fileInFrom:filename:!public!utility! !
!PstFileOutManager class categoriesFor: #fileOutPackage:on:!public!utility! !
!PstFileOutManager class categoriesFor: #fileOutSystemOn:!public!utility! !
!PstFileOutManager class categoriesFor: #isCommentChunk:!public!utility! !
!PstFileOutManager class categoriesFor: #on:!instance creation!public! !



PstGeosVMFile comment: ''!

PstGeosVMFile guid: (GUID fromString: '{4C99E910-0F88-481C-AEB1-54EB8A7F1BAB}')!

!PstGeosVMFile categoriesForClass!No category! !
!PstGeosVMFile methodsFor!

add: data withID: anID
	blocks add: (PstGeosVMFileBlock data: data withID: anID).!

application
	^ application.!

application: string
	application := string.!

defaultFilename
	^defaultFilename.
!

defaultFilename: string
	defaultFilename := string.
!

dirsize
	^32 + ((blocks size +1) * 12).
!

initialize
	super initialize.
	blocks := OrderedCollection new.
	name := self class defaultTitle.
	token := self class defaultToken.
	application := self class defaultApplication.!

name
	^name.!

name: string
	name := string.!

nexthdl
	^self dirsize.!

save
	self assert: [defaultFilename notNil].
	self writeToFileNamed: defaultFilename.
!

token
	^ token.!

token: string
	token := string.!

totalsize
	| result |
	result := self dirsize.
	blocks do: [:block |
		result := result + block size + 2.
	].
	^result.!

writeGeosHeaderOn: stream
	| qsc |
	"GEOS file header, version 2"
	qsc := PstSystem current.

	"GEOS 2 ID"
	qsc storeLongword: 16r53C145C7 on: stream.

	"name of file"
	self writeNameOn: stream.

	qsc
		"class" storeWord: 2 on: stream;
		"flags" storeWord: 0 on: stream;
		"version" storeLongword: 0 on: stream;
		"revision" storeLongword: 0 on: stream;
		"protocol" storeLongword: 0 on: stream.

	"token"
	stream nextPutAll: token asByteArray.

	qsc storeWord: 0 on: stream.
	"application"
	stream nextPutAll: application asByteArray.

	qsc storeWord: 0 on: stream.

	"info"
	stream next: 100 put: 0.
	"copyright"
	stream next: 32 put: 0.
	"date, time"
	qsc storeLongword: 0 on: stream.
	"password, unused"
	stream next: (8+44) put: 0.
	self assert: [ stream position = 16r100 ].!

writeHeaderOn: stream
	"GEOS file header, version 2"
	self writeGeosHeaderOn: stream.

	"VM File Header, version 2"
	self writeVMFileHeaderOn: stream.

	"junk?"
	stream next: 16 put: 0.
	self assert: [stream position = 16r118].

	"VM directory"
	self writeVMDirectoryOn: stream.!

writeNameOn: stream
	stream 
		nextPutAll: self name asByteArray;
		next: 36 - self name size put: 0.
!

writeOn: stream
	| headerStream bodyStream offset |
	headerStream := ByteArray new writeStream.
	self writeHeaderOn: headerStream.
	bodyStream := ByteArray new writeStream.
	blocks do: [:block |
		PstSystem current storeWord: block size on: bodyStream.
		bodyStream nextPutAll: block contents].
	stream
		nextPutAll: headerStream contents;
		nextPutAll: bodyStream contents.!

writeToFileNamed: filename
	| stream |
	stream := FileStream write: filename text: false.
	[self writeOn: stream]
		ensure: [stream close].
!

writeVMDirectoryOn: stream
	| qsc |

	"VM directory"
	(qsc := PstSystem current)
		"IDvmfdir"
		storeWord: 16r00FB on: stream;
		"hdl_1stfree"
		storeWord: 0 on: stream;
		"hdl_lastfree"
		storeWord: 0 on: stream;
		"hdl_1stunused"
		storeWord: self nexthdl on: stream;
		"dirsize"
		storeWord: self dirsize on: stream;
		"nblocks_free"
		storeWord: 0 on: stream;
		"nhdls_free"
		storeWord: 0 on: stream;
		"nblocks_used"
		storeWord: blocks size + 1 on: stream;
		"nblocks_loaded"
		storeWord: 0 on: stream;
		"x2"
		storeWord: 0 on: stream;
		"hdl_first"
		storeWord: 16r2C on: stream;
		"x2b"
		storeWord: 0 on: stream;
		"totalsize"
		storeLongword: self totalsize on: stream;
		"flags"
		storeWord: 0 on: stream;
		"hdl_dbmap"
		storeWord: 0 on: stream.
	self assert: [ stream position = 16r138 ].

	"handle table"
	"DIR block"
	qsc
		"handle"
		storeWord: 0 on: stream;
		"flags"
		storeWord: 16rFF on: stream;
		"ID"
		storeWord: 0 on: stream;
		"blocksize"
		storeWord: self dirsize on: stream;
		"blockptr"
		storeLongword: 16r18 on: stream.

	"data blocks"
	blocks inject: 16r18 + self dirsize into: [:pos :block |
		qsc
			"handle"
			storeWord: 0 on: stream;
			"flags"
			storeWord: 16rFF on: stream;
			"ID"
			storeWord: block id on: stream;
			"blocksize"
			storeWord: (block size + 2) on: stream;
			"blockptr"
			storeLongword: pos on: stream.
		pos + block size + 2.
	].
	self assert: [ stream position = (16r118 + self dirsize) ].!

writeVMFileHeaderOn: stream
	"VM File Header, version 2"
	PstSystem current
		"IDVM"
		storeWord: 16rADEB on: stream;
		"dirsize"
		storeWord: self dirsize on: stream;
		"dirptr"
		storeLongword: 16r18 on: stream.
	self assert: [ stream position = 16r108 ].! !
!PstGeosVMFile categoriesFor: #add:withID:!accessing!public! !
!PstGeosVMFile categoriesFor: #application!accessing!public! !
!PstGeosVMFile categoriesFor: #application:!accessing!public! !
!PstGeosVMFile categoriesFor: #defaultFilename!accessing!public! !
!PstGeosVMFile categoriesFor: #defaultFilename:!accessing!public! !
!PstGeosVMFile categoriesFor: #dirsize!accessing!public! !
!PstGeosVMFile categoriesFor: #initialize!initialization!public! !
!PstGeosVMFile categoriesFor: #name!accessing!public! !
!PstGeosVMFile categoriesFor: #name:!accessing!public! !
!PstGeosVMFile categoriesFor: #nexthdl!accessing!public! !
!PstGeosVMFile categoriesFor: #save!public!writing! !
!PstGeosVMFile categoriesFor: #token!accessing!public! !
!PstGeosVMFile categoriesFor: #token:!accessing!public! !
!PstGeosVMFile categoriesFor: #totalsize!accessing!public! !
!PstGeosVMFile categoriesFor: #writeGeosHeaderOn:!public!writing! !
!PstGeosVMFile categoriesFor: #writeHeaderOn:!public!writing! !
!PstGeosVMFile categoriesFor: #writeNameOn:!public!writing! !
!PstGeosVMFile categoriesFor: #writeOn:!public!writing! !
!PstGeosVMFile categoriesFor: #writeToFileNamed:!public!writing! !
!PstGeosVMFile categoriesFor: #writeVMDirectoryOn:!public!writing! !
!PstGeosVMFile categoriesFor: #writeVMFileHeaderOn:!public!writing! !

!PstGeosVMFile class methodsFor!

defaultApplication
	^'PKST'.!

defaultName
	^'pstvm.vm'.!

defaultTitle
	^'pstvm.vm'.!

defaultToken
	^'PKST'.! !
!PstGeosVMFile class categoriesFor: #defaultApplication!*-unclassified!public! !
!PstGeosVMFile class categoriesFor: #defaultName!*-unclassified!public! !
!PstGeosVMFile class categoriesFor: #defaultTitle!*-unclassified!public! !
!PstGeosVMFile class categoriesFor: #defaultToken!*-unclassified!public! !



PstGeosVMFileBlock comment: ''!

PstGeosVMFileBlock guid: (GUID fromString: '{C0A7D594-8646-4620-9974-1F56B4C83B9A}')!

!PstGeosVMFileBlock categoriesForClass!No category! !
!PstGeosVMFileBlock methodsFor!

contents
	^contents

!

data: data
	contents := data.
	^self!

data: data withID: myId
	contents := data.
	id := myId.
	^self!

id
	^id
!

id: myId
	id := myId.
	^self



!

size
	^contents size


! !
!PstGeosVMFileBlock categoriesFor: #contents!*-unclassified!public! !
!PstGeosVMFileBlock categoriesFor: #data:!*-unclassified!public! !
!PstGeosVMFileBlock categoriesFor: #data:withID:!*-unclassified!public! !
!PstGeosVMFileBlock categoriesFor: #id!*-unclassified!public! !
!PstGeosVMFileBlock categoriesFor: #id:!*-unclassified!public! !
!PstGeosVMFileBlock categoriesFor: #size!*-unclassified!public! !

!PstGeosVMFileBlock class methodsFor!

data: data withID: id
	| block |
	block := self new.
	^block data: data withID: id.! !
!PstGeosVMFileBlock class categoriesFor: #data:withID:!*-unclassified!public! !



PstGlobalVariables comment: ''!

PstGlobalVariables guid: (GUID fromString: '{470A93F6-FB9B-4FBF-B7ED-A4E51D33737D}')!

!PstGlobalVariables categoriesForClass!No category! !
!PstGlobalVariables methodsFor!

clearAllGlobals
	variables := Dictionary new.!

fetchGlobalForClass: ownerClass
variableName: variableName
	^variables
		at: (self
			specifierForOwnerClass: ownerClass
			variableName: variableName)
		ifAbsent: [PstBasicObject forNil].!

initialize
	super initialize.
	self clearAllGlobals.!

specifierForOwnerClass: ownerClass
variableName: variableName
	^ownerClass name, '.', variableName.!

storeGlobalForClass: ownerClass
variableName: variableName
with: value
	^variables
		at: (self
			specifierForOwnerClass: ownerClass
			variableName: variableName)
		put: value.! !
!PstGlobalVariables categoriesFor: #clearAllGlobals!accessing!public! !
!PstGlobalVariables categoriesFor: #fetchGlobalForClass:variableName:!accessing!public! !
!PstGlobalVariables categoriesFor: #initialize!initialization!public! !
!PstGlobalVariables categoriesFor: #specifierForOwnerClass:variableName:!public!utility! !
!PstGlobalVariables categoriesFor: #storeGlobalForClass:variableName:with:!accessing!public! !



PstInstruction comment: ''!

PstInstruction guid: (GUID fromString: '{BC79C5C8-E5D7-4EAE-B62E-CF75C2F6C1FC}')!

!PstInstruction categoriesForClass!No category! !
!PstInstruction methodsFor!

description
	^self subclassResponsibility.!

estimatedCompiledSize
	^self subclassResponsibility.!

generateCodeFor: generator
	^self subclassResponsibility.!

instructionCategory
	"Answer a category symbol for this instruction.  This is only used for collecting statistics.  Currently used symbols are:
	#jump (conditional and nonconditional)
	#stackEffect (dup, drop, over)
	#return (local and nonlocal)
	#push (push literal, self, global)
	#fullBlock
	#fetch (local or inst var access)
	#store (local or inst var set)
	#send (message send)
	#super
	#label (branch destination)
	#other (raw bytes, primitives, etc.)"
	^self subclassResponsibility.!

sequenceNumber
	^sequenceNumber.!

sequenceNumber: value
	sequenceNumber := value.!

sourcePosition
	^sourcePosition.!

sourcePosition: interval
	"Can also be nil if the source position cannot be localized."
	sourcePosition := interval.! !
!PstInstruction categoriesFor: #description!*-subclass responsibility!printing!public! !
!PstInstruction categoriesFor: #estimatedCompiledSize!*-subclass responsibility!accessing!public! !
!PstInstruction categoriesFor: #generateCodeFor:!*-subclass responsibility!code generation!public! !
!PstInstruction categoriesFor: #instructionCategory!*-subclass responsibility!accessing!public! !
!PstInstruction categoriesFor: #sequenceNumber!accessing!public! !
!PstInstruction categoriesFor: #sequenceNumber:!accessing!public! !
!PstInstruction categoriesFor: #sourcePosition!accessing!public! !
!PstInstruction categoriesFor: #sourcePosition:!accessing!public! !



PstInterpreter comment: ''!

PstInterpreter guid: (GUID fromString: '{8E0B98F9-51CF-4F61-B67D-AC147DBB07DC}')!

!PstInterpreter categoriesForClass!No category! !
!PstInterpreter methodsFor!

addOne
	| object |
	object := self stacktop.
	object isIntegerObject
		ifTrue: [
			dataStack
				at: dataStackPtr - 1
				put: (PstInteger value: object value + 1)]
		ifFalse: [
			self push: (PstInteger value: 1).
			self send: '+' argumentCount: 1].!

blockValue: argumentCount
	| locals |
	receiver argumentCount = argumentCount
		ifFalse: [^false].
	currentMethod := receiver home.
	instructions := currentMethod instructions.
	instructionPtr := receiver offset.
	locals := self nextInstruction byte - argumentCount.
	dataStackPtr := localVarBase + argumentCount.
	locals timesRepeat: [self push: PstBasicObject forNil].
	^true.!

branchTo: instructionIndex
	instructionPtr := instructionIndex.!

branchTo: instructionIndex if: condition
	| flag x |
	flag := self pop.
	flag == PstBasicObject forTrue
		ifTrue: [x := true]
		ifFalse: [
			flag == PstBasicObject forFalse
				ifTrue: [x := false]
				ifFalse: [^self error: 'Must be boolean']].
	x == condition
		ifTrue: [^instructionPtr := instructionIndex].!

callStack
	^callStack.!

cannotSimulatePrimitive
	^self runtimeError: 'Cannot simulate native platform primitives.'.!

createInitialContextFor: initialReceiver
andSelector: initialSelector
	receiver := initialReceiver.
	self
		lookupMethod: initialSelector
		in: receiver qclass
		argumentCount: 0.
	localVarBase := 0.
	instructionPtr := instructionPtr + 2.!

createInitialContextFor: initialReceiver
method: initialMethod
	receiver := initialReceiver.
	currentMethod := initialMethod.
	instructions := currentMethod instructions.
	instructionPtr := 1.
	dataStackPtr := 2.
	self invokeMethod: 0.!

curtailTo: callStackIndex
	[callStack size > callStackIndex]
		whileTrue: [self restoreCallStackFrame].
	self restoreCallStackFrame.!

dataStackAt: index
	^dataStack at: index.!

debugger: debug

	debugger := debug
!

directedSend: selector
argumentCount: argumentCount

	| locals searchClass |
	searchClass := self pop.
	dataStackPtr := dataStackPtr - (argumentCount + 1).
	self saveCallStackFrame.
	receiver := dataStack at: dataStackPtr.
	dataStackPtr := dataStackPtr + 1.
	(self
		lookupMethod: selector
		in: searchClass
		argumentCount: argumentCount)
			ifFalse: [self invokeMethod: 1].
	self invokeMethod: argumentCount
!

dropToFrame: frame
	"
	NOTE: I assume that I am only called from the debugger and that therefore theres is
		an extra frame on the callStack.  I will also put one on."

	self curtailTo: (callStack indexOf: frame).
	instructionPtr := 3.
	dataStackPtr := localVarBase + currentMethod argumentCount.
	currentMethod temporaryCount timesRepeat: [
		self push: PstBasicObject forNil].
	self saveCallStackFrame
!

dup
	self push: self stacktop.!

handleDoesNotUnderstand: selector
in: searchClass
argumentCount: argumentCount
	| message arguments temp |
	dataStackPtr := dataStackPtr + argumentCount.
	selector = 'doesNotUnderstand:'
		ifTrue: [^self runtimeError: 'No method for #doesNotUnderstand:'].
	arguments := system classLibrary arrayClass
		instantiateIndexed: argumentCount.
	"Slurp up the arguments from the stack.  This isn't how the real VM does it but that doesn't matter."
	temp := OrderedCollection new: argumentCount.
	argumentCount timesRepeat: [
		temp addFirst: self pop].
	temp keysAndValuesDo: [:index :argument |
		arguments indexedSlotAt: index put: argument].
	message := system classLibrary messageClass instantiate.
	message 
		namedSlotAt: 1 
		put: (PstSymbol string: selector).
	message
		namedSlotAt: 2
		put: arguments.
	self push: message.
	dataStackPtr := dataStackPtr - 1.  "point at argument"
	"Re-send #doesNotUnderstand:"
	^self
		lookupMethod: 'doesNotUnderstand:'
		in: searchClass
		argumentCount: 1.!

handleSynchronize
	synchronize isNil ifTrue: [^nil].
	synchronize == #waitForEvent
		ifTrue: [^PstSymbol string: 'synchronized'].
	synchronize == #finished ifTrue: [^returnedValue].
	synchronize == #debug ifTrue: [
		self saveCallStackFrame;
			openDebugger.
		synchronize := nil.
		^PstBasicObject forNil].
	synchronize == #exit ifTrue: [
		Transcript show: 'Clean exit...'; cr.
		^PstBasicObject forNil].
	^self error: 'bad synchronization token'.!

hasMoreInstructions
	^callStack size > 1 or: [instructionPtr <= instructions size].!

initialize
	super initialize.
	dataStack := Array new: 500.
	dataStackPtr := 2.  "not 1!!"
	callStack := OrderedCollection new.!

inlineCompare: selector
	| left right |
	right := self pop.
	left := self pop.
	self push: (PstBasicObject forBoolean:
		(left perform: selector with: right)).
	^true.!

inlineIntegerCompare: selector
	| left right |
	(self stacktop isIntegerObject
			and: [(self stackLevel: 2) isIntegerObject])
		ifFalse: [^false].
	right := self pop value.
	left := self pop value.
	self push: (PstBasicObject forBoolean:
		(left perform: selector with: right)).
	^true.!

instructionPtr
	^instructionPtr.!

interpret
	^self interpretWhile: [true].!

interpretNext
	self nextInstruction interpretFor: self.!

interpretWhile: block
	synchronize := nil.
"	[[synchronize isNil and: [block value]]
		whileTrue: [self interpretNext]
	] when: ExAll do: [:sig |
		self saveCallStackFrame;
			openDebugger.
		sig signal]."
	[synchronize isNil and: [block value]]
		whileTrue: [self interpretNext].
	^self handleSynchronize.!

invokeMethod: argumentCount
	"Set up the execution context in order to start running the current method."
	| temps |
	temps := self nextInstruction byte - argumentCount.
	instructionPtr := instructionPtr + 1.
	localVarBase := dataStackPtr.
	dataStackPtr := dataStackPtr + argumentCount.
	temps timesRepeat: [self push: PstBasicObject forNil].!

localReturn: value
	callStack isEmpty ifTrue: [
		returnedValue := value.
		^self synchronize: #finished].
	self restoreCallStackFrame.
	self push: value.!

lookupMethod: selector
in: searchClass
argumentCount: argumentCount
	| method |
	method := searchClass lookupMethod: selector.
	method isNil ifTrue: [
		self 
			handleDoesNotUnderstand: selector
			in: searchClass
			argumentCount: argumentCount.
		^false].
	currentMethod := method.
	instructions := currentMethod instructions.
	instructionPtr := 1.
	^true.!

makeFullBlock: argumentCount
	| block |
	block := PstFullBlockClosure new
		qclass: system classLibrary fullBlockClosureClass.
	block 
		argumentCount: argumentCount;
		home: currentMethod;
		offset: instructionPtr + 1;  "skip jump instruction"
		nextOuter: self thisContextIndex.
	closureSet isNil ifTrue: [closureSet := WeakIdentitySet new].
	closureSet add: block.
	^self push: block.!

makeFullBlock: argumentCount forClass: ownerClass
	"NOTE: ownerClass is disregarded in the simulator because it uses a
slightly different execution model."
	| block |
	block := PstFullBlockClosure new
		qclass: system classLibrary fullBlockClosureClass.
	block 
		argumentCount: argumentCount;
		home: currentMethod;
		offset: instructionPtr + 1;  "skip jump instruction"
		nextOuter: self thisContextIndex.
	closureSet isNil ifTrue: [closureSet := WeakIdentitySet new].
	closureSet add: block.
	^self push: block.!

nextInstruction
	| i |
	i := instructions at: instructionPtr.
	instructionPtr := instructionPtr + 1.
	^i.!

nonlocalReturn: value depth: depth
	| block homeIndex |
	block := receiver.
	depth timesRepeat: [
		homeIndex := block nextOuter.
		homeIndex == 0 ifTrue: [self error: 'block already returned'].
		block := (callStack at: homeIndex) receiver].
	self curtailTo: homeIndex.
	^self localReturn: value.!

openDebugger
"
	debugger isNil ifFalse: [
		debugger updateForErrorWhileOpen.
		^self]."
	(Smalltalk at: #PstDebugger) debugFor: self.!

outerContextIndex: distance
	| closure contextIndex |
	self assert: [distance > 0].
	closure := receiver.
	distance timesRepeat: [
		contextIndex := closure nextOuter.
		contextIndex == 0
			ifTrue: [^nil].  "context already returned"
		closure := (callStack at: contextIndex) receiver].
	^contextIndex.!

outerReceiver: distance
	| contextIndex |
	^distance == 0
		ifTrue: [receiver]
		ifFalse: [
			contextIndex := self outerContextIndex: distance.
			contextIndex isNil 
				ifTrue: [nil]
				ifFalse: [(callStack at: contextIndex) receiver]].!

over
	self push: (dataStack at: dataStackPtr - 2).!

peekInstruction
	^instructions at: instructionPtr.!

perform: argumentCount
	"Answers whether the selector was valid."
	| selector understood locals args |
	self saveCallStackFrame.
	selector := dataStack at: localVarBase.
	selector class == PstSymbol
		ifFalse: [^false].
	dataStackPtr := localVarBase + 1.  "point at 1st arg"
	understood := self
		lookupMethod: selector string
		in: receiver qclass
		argumentCount: argumentCount.
	locals := self nextInstruction byte.
	args := self nextInstruction byte.
	(args ~= argumentCount and: [understood])
		ifTrue: [
			"Wrong number of argument---primitive failure"
			self restoreCallStackFrame]
		ifFalse: [
			callStack removeLast.
			localVarBase := localVarBase + 1.  "skip selector"
			locals := locals - args.
			dataStackPtr := localVarBase + args.
			locals timesRepeat: [self push: PstBasicObject forNil]].
	^true.!

pop
	| object |
	dataStackPtr <= 2 ifTrue: [^self runtimeError: 'Data stack underflow'].
	object := dataStack at:
		(dataStackPtr := dataStackPtr - 1).
	dataStack at: dataStackPtr put: PstBasicObject forNil.
	^object.!

pop: n
	n timesRepeat: [self pop].!

primitive: index
	| result |
	primitiveFailCode := 0.
	result := primitiveSet performPrimitive: index.
	^result isNil 
		ifTrue: [
			"Primitive failed - execute fallback code."
			self]
		ifFalse: [
			"Primitive succeeded - return value."
			self localReturn: result].!

primitiveFailCode: code
	primitiveFailCode := code.!

primitiveSet: newPrimitiveSet
	primitiveSet := newPrimitiveSet.
	primitiveSet interpreter: self.!

push: value
	dataStackPtr >= dataStack size
		ifTrue: [^self runtimeError: 'Data stack overflow'].
	dataStack at: dataStackPtr put: value.
	dataStackPtr := dataStackPtr + 1.!

pushCleanBlock: argumentCount
	| block |
	block := PstBlockClosure new
		qclass: system classLibrary blockClosureClass.
	block 
		argumentCount: argumentCount;
		home: currentMethod;
		offset: instructionPtr + 1.  "skip jump instruction"
	^self push: block.!

pushLocal: index
	self push: (dataStack at: localVarBase + index).!

pushLocal: index outer: distance
	| contextIndex |
	contextIndex := self outerContextIndex: distance.
	contextIndex isNil ifTrue: [
		self push: PstBasicObject forNil.
		^self
			sendSelf: 'contextAlreadyReturned'
			argumentCount: 0].
	self push: (dataStack at: (callStack at: contextIndex)
			localVarBase + index).!

receiver
	^receiver.!

receiverOnTopSend: selector
argumentCount: argumentCount

	| temp |
	temp := dataStack at: dataStackPtr - 1.
	dataStackPtr - 2 to: dataStackPtr - (argumentCount + 1) by: -1 do: [:i |
		dataStack at: i + 1 put: (dataStack at: i)].
	dataStack at: dataStackPtr - (argumentCount + 1) put: temp.
	^self send: selector argumentCount: argumentCount
!

restoreCallStackFrame
	| frame |
	closureSet isNil ifFalse: [
		closureSet do: [:closure | closure markAsTerminated]].
	callStack isEmpty ifTrue: [^self runtimeError: 'Call stack underflow'].
	frame := callStack removeLast.
	receiver := frame receiver.
	currentMethod := frame method.
	localVarBase := frame localVarBase.
	dataStackPtr := frame dataStackPtr.
	instructionPtr := frame instructionPtr.
	instructions := currentMethod instructions.
	closureSet := frame closureSet.!

returnedValue: value
	returnedValue := value.!

rskim: n
	"Answer the n topmost stack items (nondestructively), prepended with the current receiver"
	| array |
	array := dataStack 
		copyFrom: dataStackPtr - n - 1
		to: dataStackPtr - 1.
	array at: 1 put: receiver.
	^array.!

runtimeError: message
	self returnedValue: PstBasicObject forNil.
	(MessageBox confirm: 'Error: ', message,
'.
Debug?')
		ifTrue: [self synchronize: #debug]
		ifFalse: [self synchronize: #finished].
	!

saveCallStackFrame
	| frame |
	callStack size > 300 ifTrue: [^self runtimeError: 'Call stack overflow'].
	frame := PstCallStackFrame new.
	frame
		interpreter: self
		receiver: receiver
		method: currentMethod
		localVarBase: localVarBase
		dataStackPtr: dataStackPtr
		instructionPtr: instructionPtr
		closureSet: closureSet.
	closureSet := nil.  "lazily initialized"
	^callStack addLast: frame.!

send: selector
argumentCount: argumentCount
	| locals |
	dataStackPtr := dataStackPtr - (argumentCount + 1).
	self saveCallStackFrame.
	receiver := dataStack at: dataStackPtr.
	dataStackPtr := dataStackPtr + 1.
	(self
		lookupMethod: selector
		in: receiver qclass
		argumentCount: argumentCount)
			ifTrue: [self invokeMethod: argumentCount]
			ifFalse: [self invokeMethod: 1].!

sendSelf: selector
argumentCount: argumentCount
	| locals |
	dataStackPtr := dataStackPtr - argumentCount.
	self saveCallStackFrame.
	(self
		lookupMethod: selector
		in: receiver qclass
		argumentCount: argumentCount)
			ifTrue: [self invokeMethod: argumentCount]
			ifFalse: [self invokeMethod: 1].!

sendSuper: selector
argumentCount: argumentCount
	| locals searchClass |
	searchClass := self pop.
	dataStackPtr := dataStackPtr - argumentCount.
	self saveCallStackFrame.
	(self
		lookupMethod: selector
		in: searchClass
		argumentCount: argumentCount)
			ifTrue: [self invokeMethod: argumentCount]
			ifFalse: [self invokeMethod: 1].
!

skim: n
	"Answer the n topmost stack items (nondestructively)."
	^dataStack 
		copyFrom: dataStackPtr - n
		to: dataStackPtr - 1.!

stackFrameAt: index
	^callStack at: index.!

stackLevel: level
	"level 1 is stack top, 2 is next, etc."
	^dataStack at: dataStackPtr - level.!

stacktop
	^dataStack at: dataStackPtr - 1.!

storeLocal: index
	dataStack 
		at: localVarBase + index
		put: self pop.!

storeLocal: index outer: distance
	| position contextIndex |
	contextIndex := self outerContextIndex: distance.
	contextIndex isNil ifTrue: [
		"Drop the value to be stored."
		self pop.
		^self
			sendSelf: 'contextAlreadyReturned'
			argumentCount: 0].
	position := (callStack at: contextIndex) localVarBase.
	dataStack 
		at: position + index
		put: self pop.!

subtractOne
	| object |
	object := self stacktop.
	object isIntegerObject
		ifTrue: [
			dataStack
				at: dataStackPtr - 1
				put: (PstInteger value: object value - 1)]
		ifFalse: [
			self push: (PstInteger value: 1).
			self send: '-' argumentCount: 1].!

synchronize: token
	"Signals the VM to stop at the next opportunity."
	synchronize := token.!

synchronizeToken
	"badly named"
	^synchronize.!

system
	^system.!

system: newSystem
	system := newSystem.!

thisContextIndex
	^callStack size + 1.!

wakeup
	"Wake up from a synchronization event -- for now, this always needs to be a #waitForEvent synch point."
	self assert: [synchronize == #waitForEvent].
	synchronize := nil.
	self interpret.! !
!PstInterpreter categoriesFor: #addOne!instructions!public! !
!PstInterpreter categoriesFor: #blockValue:!control flow!public! !
!PstInterpreter categoriesFor: #branchTo:!instructions!public! !
!PstInterpreter categoriesFor: #branchTo:if:!instructions!public! !
!PstInterpreter categoriesFor: #callStack!accessing!public! !
!PstInterpreter categoriesFor: #cannotSimulatePrimitive!error handling!public! !
!PstInterpreter categoriesFor: #createInitialContextFor:andSelector:!initialization!public! !
!PstInterpreter categoriesFor: #createInitialContextFor:method:!initialization!public! !
!PstInterpreter categoriesFor: #curtailTo:!public!stack operations! !
!PstInterpreter categoriesFor: #dataStackAt:!accessing!public! !
!PstInterpreter categoriesFor: #debugger:!error handling!public! !
!PstInterpreter categoriesFor: #directedSend:argumentCount:!control flow!public! !
!PstInterpreter categoriesFor: #dropToFrame:!public!stack operations! !
!PstInterpreter categoriesFor: #dup!public!stack operations! !
!PstInterpreter categoriesFor: #handleDoesNotUnderstand:in:argumentCount:!control flow!public! !
!PstInterpreter categoriesFor: #handleSynchronize!control flow!public! !
!PstInterpreter categoriesFor: #hasMoreInstructions!control flow!public! !
!PstInterpreter categoriesFor: #initialize!initialization!public! !
!PstInterpreter categoriesFor: #inlineCompare:!instructions!public! !
!PstInterpreter categoriesFor: #inlineIntegerCompare:!instructions!public! !
!PstInterpreter categoriesFor: #instructionPtr!accessing!public! !
!PstInterpreter categoriesFor: #interpret!control flow!public! !
!PstInterpreter categoriesFor: #interpretNext!control flow!public! !
!PstInterpreter categoriesFor: #interpretWhile:!control flow!public! !
!PstInterpreter categoriesFor: #invokeMethod:!control flow!public! !
!PstInterpreter categoriesFor: #localReturn:!control flow!public! !
!PstInterpreter categoriesFor: #lookupMethod:in:argumentCount:!control flow!public! !
!PstInterpreter categoriesFor: #makeFullBlock:!instructions!public! !
!PstInterpreter categoriesFor: #makeFullBlock:forClass:!instructions!public! !
!PstInterpreter categoriesFor: #nextInstruction!control flow!public! !
!PstInterpreter categoriesFor: #nonlocalReturn:depth:!control flow!public! !
!PstInterpreter categoriesFor: #openDebugger!error handling!public! !
!PstInterpreter categoriesFor: #outerContextIndex:!accessing!public! !
!PstInterpreter categoriesFor: #outerReceiver:!accessing!public! !
!PstInterpreter categoriesFor: #over!public!stack operations! !
!PstInterpreter categoriesFor: #peekInstruction!control flow!public! !
!PstInterpreter categoriesFor: #perform:!control flow!public! !
!PstInterpreter categoriesFor: #pop!public!stack operations! !
!PstInterpreter categoriesFor: #pop:!public!stack operations! !
!PstInterpreter categoriesFor: #primitive:!instructions!public! !
!PstInterpreter categoriesFor: #primitiveFailCode:!accessing!public! !
!PstInterpreter categoriesFor: #primitiveSet:!initialization!public! !
!PstInterpreter categoriesFor: #push:!public!stack operations! !
!PstInterpreter categoriesFor: #pushCleanBlock:!instructions!public! !
!PstInterpreter categoriesFor: #pushLocal:!instructions!public! !
!PstInterpreter categoriesFor: #pushLocal:outer:!instructions!public! !
!PstInterpreter categoriesFor: #receiver!accessing!public! !
!PstInterpreter categoriesFor: #receiverOnTopSend:argumentCount:!control flow!public! !
!PstInterpreter categoriesFor: #restoreCallStackFrame!public!stack operations! !
!PstInterpreter categoriesFor: #returnedValue:!accessing!public! !
!PstInterpreter categoriesFor: #rskim:!public!stack operations! !
!PstInterpreter categoriesFor: #runtimeError:!error handling!public! !
!PstInterpreter categoriesFor: #saveCallStackFrame!public!stack operations! !
!PstInterpreter categoriesFor: #send:argumentCount:!control flow!public! !
!PstInterpreter categoriesFor: #sendSelf:argumentCount:!control flow!public! !
!PstInterpreter categoriesFor: #sendSuper:argumentCount:!control flow!public! !
!PstInterpreter categoriesFor: #skim:!public!stack operations! !
!PstInterpreter categoriesFor: #stackFrameAt:!accessing!public! !
!PstInterpreter categoriesFor: #stackLevel:!public!stack operations! !
!PstInterpreter categoriesFor: #stacktop!public!stack operations! !
!PstInterpreter categoriesFor: #storeLocal:!instructions!public! !
!PstInterpreter categoriesFor: #storeLocal:outer:!instructions!public! !
!PstInterpreter categoriesFor: #subtractOne!instructions!public! !
!PstInterpreter categoriesFor: #synchronize:!accessing!public! !
!PstInterpreter categoriesFor: #synchronizeToken!accessing!public! !
!PstInterpreter categoriesFor: #system!accessing!public! !
!PstInterpreter categoriesFor: #system:!initialization!public! !
!PstInterpreter categoriesFor: #thisContextIndex!accessing!public! !
!PstInterpreter categoriesFor: #wakeup!control flow!public! !

!PstInterpreter class methodsFor!

createAsDefault
	^self
		forSystem: PstSystem current
		primitiveSet: PstPrimitiveSet new!

forSystem: system
primitiveSet: primitiveSet
	^self new
		system: system;
		primitiveSet: primitiveSet.!

performMethod: method for: initialReceiver
	| interpreter |
	interpreter := self createAsDefault.
	interpreter
		createInitialContextFor: initialReceiver
		method: method.
	^interpreter interpret.!

send: initialSelector to: initialReceiver
	| interpreter |
	interpreter := self createAsDefault.
	interpreter
		createInitialContextFor: initialReceiver
		andSelector: initialSelector.
	^interpreter interpret.!

start
	^self
		send: 'basicStart'
		to: (PstClassLibrary current classNamed: 'Smalltalk').! !
!PstInterpreter class categoriesFor: #createAsDefault!instance creation!public! !
!PstInterpreter class categoriesFor: #forSystem:primitiveSet:!instance creation!public! !
!PstInterpreter class categoriesFor: #performMethod:for:!evaluating!public! !
!PstInterpreter class categoriesFor: #send:to:!evaluating!public! !
!PstInterpreter class categoriesFor: #start!evaluating!public! !



PstLexer comment: ''!

PstLexer guid: (GUID fromString: '{73828E93-2157-4F1C-8AF7-125E6F61392C}')!

!PstLexer categoriesForClass!No category! !
!PstLexer methodsFor!

commentMap
	^commentMap.!

decode: character radix: radix
	| val char |
	char := character asLowercase.
	val := char isDigit 
		ifTrue: [char digitValue]
		ifFalse: [
			(char between: $a and: $z)
				ifTrue: [char asInteger - $a asInteger + 10]
				ifFalse: [nil]].
	^(val notNil and: [val between: 0 and: radix - 1])
		ifTrue: [val]
		ifFalse: [nil].!

floatFromString: string
	| stream neg ipart fpart result pos |
	stream := string readStream.
	ipart := Integer readFrom: stream radix: 10.
	(stream peekFor: $.)
		ifTrue: [
			pos := stream position.
			fpart := Integer readFrom: stream radix: 10.
			result := fpart asFloat.
			(stream position - pos) timesRepeat: [
				result := result / 10.0].
			result := result + ipart asFloat ]
		ifFalse: [
			result := ipart asFloat ].
	^result.!

getNextChar
	^pushback isEmpty
		ifTrue: [
			inputStream atEnd
				ifTrue: [nil]
				ifFalse: [inputStream next]]
		ifFalse: [pushback removeLast].!

initialize
	super initialize.
	pushback := OrderedCollection new.
	commentMap := OrderedCollection new.
	joiningKeywords := false.!

inputStream: stream
	inputStream := stream.
	self nextChar.!

joinKeywords: boolean
	joiningKeywords := boolean.!

lexerError: message
	| exception |
	exception := PstCompilerError new
		message: message.
	exception
		start: tokenStart;
		stop: tokenStop.
	exception signal.!

nextChar
	^here := self getNextChar.!

pushback: ch
	pushback addLast: ch.!

scanAssign
	self nextChar.
	here isNil ifTrue: [^self lexerError: 'Misplaced colon'].
	here == $= ifTrue: [
		self nextChar.
		value := nil.
		^#assign].
	here == $: ifTrue: [
		self nextChar.
		here == $= ifTrue: [
			self nextChar.
			value := nil.
			^#hardAssign].
		^self lexerError: ':: has no independent meaning here'].
	value := $:.
	^$:.!

scanBinop
	| buffer |
	buffer := WriteStream on: String new.
	[here notNil and: [BinopTable includesKey: here]] whileTrue: [
		buffer nextPut: here.
		self nextChar].
	value := buffer contents.
	^#binop.!

scanCharacter
	| charStart |
	charStart := tokenStart.
	self nextChar.
	here isNil ifTrue: [self lexerError: 'Expected character constant'].
	here == $\ ifFalse: [
		"Ordinary character ..."
		value := here.
		self nextChar.
		^#character].
	"Escaped character."
	self nextChar.
	here isNil ifTrue: [self lexerError: 'Expected escaped character'].
	token := here isDigit 
		ifTrue: [self scanNumber]
		ifFalse: [
			here isLetter
				ifTrue: [self scanIdentifier]
				ifFalse: [self lexerError: 'Expected character name']].
	tokenStart := charStart.
	token == #integer ifTrue: [
		(value between: 0 and: 255)
			ifFalse: [self lexerError: 'Character value out of range'].
		value := Character value: value.
		^#character].
	token == #identifier ifTrue: [
		value := PstCharacterLiteralNode
			characterForEscape: value.
		value isNil ifTrue: [self lexerError: 'Unknown character'].
		^#character].
	self lexerError: 'Expected name or number of escaped character'.!

scanComment
	self nextChar.
	[here notNil and: [here ~= $"]] 
		whileTrue: [self nextChar].
	here isNil ifTrue: [self lexerError: 'Unterminated comment'].
	self nextChar. "skip closing quote"
	^#comment.!

scanExtendedKeyword
	| stream |
	stream := String new writeStream.
	stream nextPutAll: value.
	[here notNil and: [here isLetter 
			or: [here isDigit or: [here = $_ or: [here = $:]]]]]
		whileTrue: [
			stream nextPut: here.
			self nextChar].
	value := stream contents.!

scanIdentifier
	| buffer gotColon |
	buffer := WriteStream on: String new.
	gotColon := false.
	[here notNil and: [gotColon not
			and: [here isLetter 
			or: [here isDigit or: [here == $_
			or: [here == $:]]]]]]
		whileTrue: [
			buffer nextPut: here.
			here == $: ifTrue: [gotColon := true].
			self nextChar].
	value := buffer contents.
	^value last == $:
		ifTrue: [
			joiningKeywords
				ifTrue: [self scanExtendedKeyword].
			#keyword]
		ifFalse: [#identifier].!

scanMinus
	self nextChar.
	^(here notNil and: [here isDigit]) 
		ifTrue: [
			self scanNumber.
			value := value negated.
			#integer]
		ifFalse: [
			self scanBinop.
			value := '-', value.
			#binop].!

scanNextToken
	[here notNil and: [here isSeparator]] whileTrue: [
		self nextChar isNil ifTrue: [^nil]].
	here isNil ifTrue: [^nil].
	tokenStart := inputStream position.
	here == $' ifTrue: [^self scanString].
	here == $" ifTrue: [^self scanComment].
	here == $: ifTrue: [^self scanAssign].
	here == $- ifTrue: [^self scanMinus].
	here == $$ ifTrue: [^self scanCharacter].
	(BinopTable includesKey: here)
		ifTrue: [^self scanBinop].
	here isLetter ifTrue: [^self scanIdentifier].
	here isDigit ifTrue: [^self scanNumber].
	here == $_ ifTrue: [^self scanIdentifier].
	value := here.
	self nextChar.
	^value.!

scanNumber
	| buffer dots string radix |
	buffer := WriteStream on: String new.
	[here notNil and: [here isDigit or: [here = $.]]] whileTrue: [
		buffer nextPut: here.
		self nextChar].
	string := buffer contents.
	string last == $. ifTrue: [
		self pushback: $..
		string := string copyFrom: 1 to: string size - 1].
	dots := string occurrencesOf: $..
	dots > 1 ifTrue: [self lexerError: 'Invalid floating-point constant'].
	^dots = 1
		ifTrue: [
			value := self floatFromString: string.
			#double]
		ifFalse: [
			value := Integer fromString: string.
			here == $r ifTrue: [
				radix := value.
				self nextChar.
				(self decode: here radix: value) isNil ifTrue: [
					self lexerError: 'Expected radix-', radix printString, ' constant'].
				self scanRadixInteger: radix].
			#integer].!

scanRadixInteger: radix
	| buffer integer |
	buffer := WriteStream on: String new.
	integer := 0.
	[here notNil and: [(self decode: here radix: radix) notNil]] whileTrue: [
		integer := (integer * radix) + (self decode: here radix: radix).
		self nextChar].
	value := integer.
	^#integer.!

scanString
	| buffer |
	buffer := WriteStream on: String new.
	self nextChar.
	[here notNil] whileTrue: [
		here == $' ifTrue: [
			self nextChar.
			here == $' ifFalse: [
				value := buffer contents 
					reject: [:each | each asInteger == 13].
				^#string]].
		buffer nextPut: here.
		self nextChar].
	self lexerError: 'Unterminated string'.!

scanToken
	[token := self scanNextToken.
		token == #comment] whileTrue: [
			commentMap add: 
				(tokenStart to: inputStream position - 1)].
	tokenStop := inputStream position - 1.
	^token.!

scanTokens
	"Answer an array of tokens."
	| buffer |
	buffer := WriteStream on: Array new.
	[self scanToken isNil] whileFalse: [
		buffer nextPut: token -> value].
	^buffer contents.!

tokenStart
	^tokenStart.!

tokenStop
	^tokenStop.!

value
	^value.! !
!PstLexer categoriesFor: #commentMap!accessing!public! !
!PstLexer categoriesFor: #decode:radix:!public!scanning! !
!PstLexer categoriesFor: #floatFromString:!public!scanning! !
!PstLexer categoriesFor: #getNextChar!public!scanning! !
!PstLexer categoriesFor: #initialize!initialization!public! !
!PstLexer categoriesFor: #inputStream:!initialization!public! !
!PstLexer categoriesFor: #joinKeywords:!accessing!public! !
!PstLexer categoriesFor: #lexerError:!error handling!public! !
!PstLexer categoriesFor: #nextChar!public!scanning! !
!PstLexer categoriesFor: #pushback:!public!scanning! !
!PstLexer categoriesFor: #scanAssign!public!scanning! !
!PstLexer categoriesFor: #scanBinop!public!scanning! !
!PstLexer categoriesFor: #scanCharacter!public!scanning! !
!PstLexer categoriesFor: #scanComment!public!scanning! !
!PstLexer categoriesFor: #scanExtendedKeyword!public!scanning! !
!PstLexer categoriesFor: #scanIdentifier!public!scanning! !
!PstLexer categoriesFor: #scanMinus!public!scanning! !
!PstLexer categoriesFor: #scanNextToken!public!scanning! !
!PstLexer categoriesFor: #scanNumber!public!scanning! !
!PstLexer categoriesFor: #scanRadixInteger:!public!scanning! !
!PstLexer categoriesFor: #scanString!public!scanning! !
!PstLexer categoriesFor: #scanToken!public!scanning! !
!PstLexer categoriesFor: #scanTokens!public!scanning! !
!PstLexer categoriesFor: #tokenStart!accessing!public! !
!PstLexer categoriesFor: #tokenStop!accessing!public! !
!PstLexer categoriesFor: #value!accessing!public! !

!PstLexer class methodsFor!

initialize
	"PstLexer initialize."
	BinopTable := Dictionary new.
	'<>=+-*/|&~\@%,' do: [:each |
		BinopTable at: each put: true].!

on: stream
	^self new inputStream: stream.!

scanTokens: string
	| lexer |
	lexer := self on: (ReadStream on: string).
	^lexer scanTokens.! !
!PstLexer class categoriesFor: #initialize!initialization!public! !
!PstLexer class categoriesFor: #on:!instance creation!public! !
!PstLexer class categoriesFor: #scanTokens:!public!utility! !



PstMethod comment: ''!

PstMethod guid: (GUID fromString: '{D2D11C3F-2ABF-4FB6-8E0B-2F786042735D}')!

!PstMethod categoriesForClass!No category! !
!PstMethod methodsFor!

actualMethod
	"For compatibility with PstQuasiMethod."
	^self.!

argumentCount

	^(self instructions at: 2) byte
!

argumentMap
	^argumentMap!

argumentMap: map
	argumentMap := map.!

category
	^self ownerClass categoryOfMethod: self.!

commentMap
	^commentMap.!

commentMap: object
	commentMap := object.!

compiledBytes
	"The code must have been generated (with #generateCodeFor:) first."
	| stream |
	stream := ByteArray new writeStream.
	self instructions do: [:each |
		stream nextPutAll: each code].
	^stream contents.!

containsString: string
	"Does the source code contain the given string?"
	^(self sourceCode
			indexOfSubCollection: string
			startingAt: 1) ~= 0.!

disassembleOn: stream
	| mapStream start |
	mapStream := Array new writeStream.
	stream nextPutAll: self fullDisplayString; cr.
	self renumberInstructions.
	instructions do: [:each |
		start := stream position + 1.
		stream
			nextPut: $[;
			print: each sequenceNumber;
			nextPut: $];
			tab;
			nextPutAll: each description.
		mapStream nextPut: (start to: stream position).
		stream cr].
	^mapStream contents.!

disassembly
	^self disassemblyWithMap key.!

disassemblyWithMap
	"Answers disassemblyString -> sourceMap"
	"sourceMap is #(range1 range2 ...)"
	| stream sourceMap |
	stream := WriteStream on: String new.
	sourceMap := self disassembleOn: stream.
	^stream contents -> sourceMap.!

displayOn: stream
	stream nextPutAll: self selector.!

fileOutOn: manager
	manager
		bang;
		nextPutAll: self ownerClass displayString;
		nextPutAll: ' methodsFor: ';
		nextPutAll: self category printString;
		bang; cr; cr;
		nextPutAll: self sourceCode;
		bang; space; endChunk; cr.!

firstComment
	"Answer a String with the first (header) comment in this method, or nil if there is no header comment."
	| firstSourcePosition instruction |
	commentMap isEmpty ifTrue: [^nil].
	instruction := self firstVisibleInstruction.
	(instruction notNil
		and: [commentMap first last > instruction sourcePosition first])
			ifTrue: [^nil].
	^(self sourceCode
		copyFrom: commentMap first first
		to: commentMap first last)
			copyWithout: $".!

firstInstructionIndex
	"The index of the first 'real' (non-header) instruction."
	^3.!

firstVisibleInstruction
	self firstInstructionIndex to: instructions size do: [:n |
		(instructions at: n) sourcePosition isNil
			ifFalse: [^instructions at: n]].
	^nil.!

fullDisplayString
	"Anwser the Class>>#selector form."
	^ownerClass displayString, '>>#', self selector.!

instructionAt: index
	^instructions at: index.!

instructionAtSourcePosition: position
	| list |
	list := self instructionsAtSourcePosition: position.
	^list isEmpty
		ifTrue: [nil]
		ifFalse: [list first].!

instructionCount
	^instructions size.!

instructions
	^instructions.!

instructions: collection
	instructions := collection.
	self renumberInstructions.!

instructionsAtSourcePosition: position
	"Note: position is a integer here, not an interval."
	^instructions select: [:each |
		each sourcePosition notNil and: [
			position
				between: each sourcePosition first
				and: each sourcePosition last]].!

isGenerated
	"Has machine code been generated? (not necessarily current!!)"
	^(instructions contains: [:each | 
		each hasGeneratedCode not]) not.!

isMethod
	^true.!

isQuasi
	^false.!

isSubclassResponsibility
	"Answer whether this method's first statement is 'self subclassResponsibility'.  These methods can be removed from the final version of an application to save space."
	| firstInstruction |
	firstInstruction := instructions at: self firstInstructionIndex.
	^firstInstruction isSend
		and: [firstInstruction sendsToSelf
		and: [firstInstruction sentSelector = 'subclassResponsibility']].!

isTrivialAccessor
	"Answer whether this method trivially sends or sets an instance variable.  These methods can be inlined if they can be statically resolved at code generation time."
	| first |
	first := instructions at: self firstInstructionIndex.
	(first isVariableInstruction
		and: [first isPush
		and: [first refersToInstanceVariable
		and: [(instructions at: self firstInstructionIndex + 1) isReturn]]])
			ifTrue: [^true].
	self halt.
	^false.!

keywordMap
	^keywordMap!

keywordMap: map
	keywordMap := map.!

localVariableCount
	^instructions first byte.!

ownerClass
	^ownerClass.!

ownerClass: qclass
	ownerClass := qclass.!

package
	^package.!

package: newPackage
	"Note: the package is only set if it is different from the owner class's package!!"
	package == newPackage ifTrue: [^self].
	package isNil ifFalse: [package removeMethod: self].
	package := newPackage == self ownerClass package
		ifTrue: [nil]
		ifFalse: [newPackage].
	package isNil ifFalse: [package addMethod: self].!

possiblySentSelectors
	| selectors |
	selectors := OrderedCollection new.
	instructions do: [:each |
		each possiblySentSelectorsDo: [:sel |
			selectors add: sel]].
	^selectors.!

primitive
	^primitive.!

primitive: object
	primitive := object.!

printOn: stream
	super printOn: stream.
	stream 
		nextPutAll: ' (';
		nextPutAll: self ownerClass name;
		nextPutAll: '>>';
		nextPutAll: self selector;
		nextPut: $).!

referencedClasses
	| classes |
	classes := OrderedCollection new.
	instructions do: [:each |
		each referencedClass isNil
			ifFalse: [classes add: each referencedClass]].
	^classes.!

referencesClassNamed: className
	^instructions anySatisfy: [:each |
		each referencesClassNamed: className].!

refersToConstant: constant
	^instructions anySatisfy: [:each | 
		each refersToConstant: constant].!

refersToInstanceVariable: instVarName
	^instructions contains: [:each |
		each refersToInstanceVariable: instVarName].!

refersToLiteral: value
	^instructions anySatisfy: [:each | 
		each refersToLiteral: value].!

refersToSharedVariable: sharedVarName
	^instructions contains: [:each |
		each refersToSharedVariable: sharedVarName].!

renumberInstructions
	instructions keysAndValuesDo: [:index :instruction |
		instruction sequenceNumber: index].!

richTextSource
	| converter |
	converter := RichText rtfConverter.
	converter font: PstSystem current defaultFont.
	converter text: self sourceCode.
	keywordMap isNil ifFalse: [
		keywordMap do: [:interval |
			converter
				selectionRange: interval;
				beBold]].
	commentMap isNil ifFalse: [
		commentMap do: [:interval |
			converter
				selectionRange: interval;
				beItalic]].
"	argumentMap isNil ifFalse: [
		argumentMap do: [:interval |
			converter
				selectionRange: interval;
				beItalic]]."
	^converter richText.!

selector
	^selector isNil
		ifTrue: ['{unbound}']
		ifFalse: [selector].!

selector: string
	selector := string.!

sends: selectorString
	"Answer whether this methods sends 'selectorString' anywhere."
	^instructions anySatisfy: [:each | each sends: selectorString].!

sentSelectors
	"Answer all the selectors (if any) sent by this method."
	"May contain duplicates."
	| selectors |
	"Not written using functional methods because this needs to be as fast as possible."
	selectors := OrderedCollection new.
	instructions do: [:each |
		each sentSelector isNil
			ifFalse: [selectors add: each sentSelector]].
	^selectors.!

sourceCode
	^sourceCode.!

sourceCode: string
	sourceCode := string.!

temporaryCount
	^self localVariableCount - self argumentCount.!

toggleBreakpointAt: instructionPtr

	instructions at: instructionPtr put: (instructions at: instructionPtr) toggleBreak!

ungenerate
	instructions do: [:each | each ungenerate].!

updatePackage
	package == self ownerClass package
		ifTrue: [self package: nil].! !
!PstMethod categoriesFor: #actualMethod!accessing!public! !
!PstMethod categoriesFor: #argumentCount!accessing!public! !
!PstMethod categoriesFor: #argumentMap!accessing!public! !
!PstMethod categoriesFor: #argumentMap:!initialization!public! !
!PstMethod categoriesFor: #category!accessing!public! !
!PstMethod categoriesFor: #commentMap!accessing!public! !
!PstMethod categoriesFor: #commentMap:!initialization!public! !
!PstMethod categoriesFor: #compiledBytes!accessing!public! !
!PstMethod categoriesFor: #containsString:!predicates!public! !
!PstMethod categoriesFor: #disassembleOn:!printing!public! !
!PstMethod categoriesFor: #disassembly!printing!public! !
!PstMethod categoriesFor: #disassemblyWithMap!printing!public! !
!PstMethod categoriesFor: #displayOn:!printing!public! !
!PstMethod categoriesFor: #fileOutOn:!printing!public! !
!PstMethod categoriesFor: #firstComment!accessing!public! !
!PstMethod categoriesFor: #firstInstructionIndex!accessing!public! !
!PstMethod categoriesFor: #firstVisibleInstruction!accessing!public! !
!PstMethod categoriesFor: #fullDisplayString!printing!public! !
!PstMethod categoriesFor: #instructionAt:!accessing!public! !
!PstMethod categoriesFor: #instructionAtSourcePosition:!public!utility! !
!PstMethod categoriesFor: #instructionCount!accessing!public! !
!PstMethod categoriesFor: #instructions!accessing!public! !
!PstMethod categoriesFor: #instructions:!initialization!public! !
!PstMethod categoriesFor: #instructionsAtSourcePosition:!public!utility! !
!PstMethod categoriesFor: #isGenerated!predicates!public! !
!PstMethod categoriesFor: #isMethod!predicates!public! !
!PstMethod categoriesFor: #isQuasi!predicates!public! !
!PstMethod categoriesFor: #isSubclassResponsibility!predicates!public! !
!PstMethod categoriesFor: #isTrivialAccessor!predicates!public! !
!PstMethod categoriesFor: #keywordMap!accessing!public! !
!PstMethod categoriesFor: #keywordMap:!initialization!public! !
!PstMethod categoriesFor: #localVariableCount!accessing!public! !
!PstMethod categoriesFor: #ownerClass!accessing!public! !
!PstMethod categoriesFor: #ownerClass:!initialization!public! !
!PstMethod categoriesFor: #package!accessing!public! !
!PstMethod categoriesFor: #package:!accessing!public! !
!PstMethod categoriesFor: #possiblySentSelectors!accessing!public! !
!PstMethod categoriesFor: #primitive!accessing!public! !
!PstMethod categoriesFor: #primitive:!accessing!public! !
!PstMethod categoriesFor: #printOn:!printing!public! !
!PstMethod categoriesFor: #referencedClasses!accessing!public! !
!PstMethod categoriesFor: #referencesClassNamed:!predicates!public! !
!PstMethod categoriesFor: #refersToConstant:!predicates!public! !
!PstMethod categoriesFor: #refersToInstanceVariable:!predicates!public! !
!PstMethod categoriesFor: #refersToLiteral:!predicates!public! !
!PstMethod categoriesFor: #refersToSharedVariable:!predicates!public! !
!PstMethod categoriesFor: #renumberInstructions!public!utility! !
!PstMethod categoriesFor: #richTextSource!printing!public! !
!PstMethod categoriesFor: #selector!accessing!public! !
!PstMethod categoriesFor: #selector:!initialization!public! !
!PstMethod categoriesFor: #sends:!predicates!public! !
!PstMethod categoriesFor: #sentSelectors!accessing!public! !
!PstMethod categoriesFor: #sourceCode!accessing!public! !
!PstMethod categoriesFor: #sourceCode:!initialization!public! !
!PstMethod categoriesFor: #temporaryCount!accessing!public! !
!PstMethod categoriesFor: #toggleBreakpointAt:!public!utility! !
!PstMethod categoriesFor: #ungenerate!public!utility! !
!PstMethod categoriesFor: #updatePackage!public!utility! !



PstObject comment: ''!

PstObject guid: (GUID fromString: '{65E4D1D5-8FF9-41AC-A848-49FD04144315}')!

!PstObject categoriesForClass!No category! !
!PstObject methodsFor!

displayOn: stream
	stream 
		nextPutAll: (self qclass name first isVowel
			ifTrue: ['an ']
			ifFalse: ['a ']);
		nextPutAll: self qclass name.!

embeddedSelectorsDo: block
	^self.!

equals: object
	"Shallow-equals comparison, mainly used for elimination of duplicate literals and 'find references to literal'."
	^self class == object class
		and: [self reallyEquals: object].!

hasNamedSlotAt: index
	^index between: 1 and: self namedSlotCount.!

identicalTo: anotherObject
	^self == anotherObject.!

instVarsDo: block
	"Evaluate block for each of the instance variables of the receiver."
	^self subclassResponsibility.!

namedSlotAt: index
	^self slotIndexOutOfBounds.!

namedSlotAt: index put: value
	^self slotIndexOutOfBounds.!

namedSlotCount
	^self qclass layout bitAnd: 4095.!

namedSlots
	^(1 to: self namedSlotCount)
		collect: [:n | self namedSlotAt: n].!

notIdenticalTo: anotherObject
	^(self identicalTo: anotherObject) not.!

printOn: stream
	super printOn: stream.
	stream
		nextPutAll: ' (';
		display: self;
		nextPut: $).!

qclass
	^qclass.!

qclass: newClass
	qclass := newClass.!

reallyEquals: object
	^self == object.!

referringMethods
	"Answer a collection of all methods that refer to this object as a literal."
	^PstClassLibrary current 
		methodsReferringTo: self.!

slotIndexOutOfBounds
	^self error: 'Slot index out of bounds.'.!

slotNames
	^self qclass allInstVarNames.! !
!PstObject categoriesFor: #displayOn:!printing!public! !
!PstObject categoriesFor: #embeddedSelectorsDo:!compiling!public! !
!PstObject categoriesFor: #equals:!comparing!public! !
!PstObject categoriesFor: #hasNamedSlotAt:!predicates!public! !
!PstObject categoriesFor: #identicalTo:!comparing!public! !
!PstObject categoriesFor: #instVarsDo:!*-subclass responsibility!compiling!public! !
!PstObject categoriesFor: #namedSlotAt:!public!slot accessing! !
!PstObject categoriesFor: #namedSlotAt:put:!public!slot accessing! !
!PstObject categoriesFor: #namedSlotCount!public!slot accessing! !
!PstObject categoriesFor: #namedSlots!public!slot accessing! !
!PstObject categoriesFor: #notIdenticalTo:!comparing!public! !
!PstObject categoriesFor: #printOn:!printing!public! !
!PstObject categoriesFor: #qclass!accessing!public! !
!PstObject categoriesFor: #qclass:!initialization!public! !
!PstObject categoriesFor: #reallyEquals:!comparing!public! !
!PstObject categoriesFor: #referringMethods!public!utility! !
!PstObject categoriesFor: #slotIndexOutOfBounds!error handling!public! !
!PstObject categoriesFor: #slotNames!public!slot accessing! !



PstOSAPI comment: ''!

PstOSAPI guid: (GUID fromString: '{5621E10E-0F8C-43D7-986C-C73896DA5121}')!

!PstOSAPI categoriesForClass!No category! !
!PstOSAPI class methodsFor!

addTrapSpec: spec
	self
		addTrap: (spec at: 1)
		index: (spec at: 4)
		argumentTypes: (spec at: 2)
		returnType: (spec at: 3).!

hasTrapNamed: trapName
	^TrapTable includesKey: trapName.!

integrateSpecs: specArray withTrapNumbers: table
	^specArray collect: [:array |
		array, (Array with: (table at: array first))].!

sortedTraps
	^self traps asSortedCollection: [:left :right |
		left name <= right name].!

trapNamed: trapName
	^TrapTable at: trapName.!

traps
	^TrapTable values.!

trapTable
	^TrapTable.! !
!PstOSAPI class categoriesFor: #addTrapSpec:!initialization!public! !
!PstOSAPI class categoriesFor: #hasTrapNamed:!accessing!public! !
!PstOSAPI class categoriesFor: #integrateSpecs:withTrapNumbers:!public!utility! !
!PstOSAPI class categoriesFor: #sortedTraps!accessing!public! !
!PstOSAPI class categoriesFor: #trapNamed:!accessing!public! !
!PstOSAPI class categoriesFor: #traps!accessing!public! !
!PstOSAPI class categoriesFor: #trapTable!accessing!public! !



PstOSTrap comment: ''!

PstOSTrap guid: (GUID fromString: '{43AE81C7-CB80-42A7-837C-58248FC2F2F5}')!

!PstOSTrap categoriesForClass!No category! !
!PstOSTrap methodsFor!

argumentCount
	^argumentTypes size.!

argumentWords
	^argumentTypes
		inject: 0
		into: [:words :type | words + (self wordsForType: type)].!

bytecodes
	"Answer the bytecodes, not including the initial opcode."
	| stream |
	stream := ByteArray new writeStream.
	stream
		nextPut: ((functionNumber bitShift: -8) bitAnd: 16rFF);
		nextPut: (functionNumber bitAnd: 16rFF);
		nextPut: self argumentCount.
	argumentTypes do: [:type |
		stream nextPut: (self specForType: type)].
	stream nextPut: (self specForType: returnType).
	^stream contents.!

displayOn: stream
	stream
		print: functionNumber;
		nextPutAll: ': '.
	self printPrototypeOn: stream.!

name
	^name.!

name: trapName
functionNumber: number
argumentTypes: argTypes
returnType: retType
	name := trapName.
	functionNumber := number.
	argumentTypes := argTypes.
	returnType := retType.!

printOn: stream
	super printOn: stream.
	stream
		nextPutAll: ' (';
		display: self;
		nextPut: $).!

printPrototypeOn: stream
	stream
		nextPutAll: returnType;
		space;
		nextPutAll: name;
		nextPut: $(.
	argumentTypes
		do: [:each | stream nextPutAll: each]
		separatedBy: [stream nextPutAll: ', '].
	stream nextPut: $).!

prototype
	| stream |
	stream := String new writeStream.
	self printPrototypeOn: stream.
	^stream contents.!

specForType: type
	type == #void ifTrue: [^0].
	type == #int16 ifTrue: [^1].
	type == #int32 ifTrue: [^2].
	type == #pointer ifTrue: [^3].
	type == #uint16 ifTrue: [^4].
	type == #double ifTrue: [^5].
	self error.!

trapNumber
	^functionNumber.!

wordsForType: type
	type == #void ifTrue: [^0].
	(type == #int16 or: [type == #uint16]) ifTrue: [^1].
	(type == #int32 or: [type == #pointer]) ifTrue: [^2].
	type == #double ifTrue: [^4].
	self error.! !
!PstOSTrap categoriesFor: #argumentCount!accessing!public! !
!PstOSTrap categoriesFor: #argumentWords!accessing!public! !
!PstOSTrap categoriesFor: #bytecodes!compiling!public! !
!PstOSTrap categoriesFor: #displayOn:!printing!public! !
!PstOSTrap categoriesFor: #name!accessing!public! !
!PstOSTrap categoriesFor: #name:functionNumber:argumentTypes:returnType:!initialization!public! !
!PstOSTrap categoriesFor: #printOn:!printing!public! !
!PstOSTrap categoriesFor: #printPrototypeOn:!printing!public! !
!PstOSTrap categoriesFor: #prototype!printing!public! !
!PstOSTrap categoriesFor: #specForType:!compiling!public! !
!PstOSTrap categoriesFor: #trapNumber!accessing!public! !
!PstOSTrap categoriesFor: #wordsForType:!public!utility! !



PstPackage comment: ''!

PstPackage guid: (GUID fromString: '{DFA01411-160B-4278-B7BF-42F13873FACE}')!

!PstPackage categoriesForClass!No category! !
!PstPackage methodsFor!

addClass: newClass
	classes add: newClass.
	self library classesChangedFor: self.!

addConstant: constant
	constants add: constant.
	self library constantsChangedFor: self.!

addMethod: method
	methods add: method.
	self library methodsChangedFor: self.!

baseFilename
	^File splitFilenameFrom: self name.!

classes
	^classes.!

comment
	| lib constantName constant |
	"If there is a constant named ##packageComment, where package is the package base name (e.g., ##coreComment), that is taken as the comment string."
	"Answer nil if there is no comment."
	lib := PstConstantsLibrary current.
	constantName := self simpleName, 'Comment'.
	(lib hasConstantNamed: constantName)
		ifFalse: [^nil].
	constant := lib constantNamed: constantName.
	constant package == self ifFalse: [^nil].
	^constant value qclass name = 'String'
		ifTrue: [constant value convertToString]
		ifFalse: [nil].!

constants
	^constants.!

displayOn: stream
	stream nextPutAll: (File splitFilenameFrom: self name).!

dontSave
	^dontSave.!

dontSave: boolean
	dontSave := boolean.!

filename
	^name.!

fileOutClassesOn: manager
	| sortedClasses |
	sortedClasses := PstClassLibrary current
		topologicallySortClasses: classes.
	sortedClasses
		select: [:each | each isBasic not or: [each name = 'Object']]
		do: [:each | each fileOutDefinitionOn: manager].
	sortedClasses do: [:each |
		each fileOutCommentOn: manager.
		each hasMethods
			ifTrue: [each fileOutMethodsOn: manager].
		(each qclass notNil and: [each qclass hasMethods])
			ifTrue: [each qclass fileOutMethodsOn: manager]].!

fileOutConstantsOn: manager
	PstConstantsLibrary current
		fileOutOn: manager
		inPackage: self.!

fileOutMethodsOn: manager
	methods do: [:each | each fileOutOn: manager].!

fileOutOn: manager
	self fileOutConstantsOn: manager.
	self fileOutClassesOn: manager.
	self fileOutMethodsOn: manager.!

initialize
	super initialize.
	classes := SortedCollection sortBlock: 
		[:left :right | left name <= right name].
	methods := OrderedCollection new.
	constants := OrderedCollection new.
	dontSave := false.!

isUncommitted
	^false.!

library
	^PstPackageLibrary current.!

methods
	^methods.!

name
	^name.!

name: filename
	name := filename.!

printOn: stream
	super printOn: stream.
	stream
		nextPutAll: ' (';
		display: self;
		nextPut: $).!

removeClass: class
	classes remove: class.
	self library classesChangedFor: self.!

removeConstant: constant
	constants remove: constant.
	self library constantsChangedFor: self.!

removeMethod: method
	methods remove: method.
	self library methodsChangedFor: self.!

save
	^self saveAs: self filename.!

saveAs: filename
	| stream |
	stream := FileStream
		write: filename
		text: true.
	Cursor wait showWhile: [
		[PstFileOutManager
			fileOutPackage: self
			on: stream]
				ensure: [stream close]].!

simpleName
	"Answer the name without a .st extension."
	| index str |
	str := self baseFilename.
	index := str indexOf: $..
	index == 0 ifTrue: [^str].
	^str copyFrom: 1 to: index - 1.! !
!PstPackage categoriesFor: #addClass:!actions!public! !
!PstPackage categoriesFor: #addConstant:!actions!public! !
!PstPackage categoriesFor: #addMethod:!actions!public! !
!PstPackage categoriesFor: #baseFilename!accessing!public! !
!PstPackage categoriesFor: #classes!accessing!public! !
!PstPackage categoriesFor: #comment!accessing!public! !
!PstPackage categoriesFor: #constants!accessing!public! !
!PstPackage categoriesFor: #displayOn:!printing!public! !
!PstPackage categoriesFor: #dontSave!accessing!public! !
!PstPackage categoriesFor: #dontSave:!accessing!public! !
!PstPackage categoriesFor: #filename!accessing!public! !
!PstPackage categoriesFor: #fileOutClassesOn:!fileout!public! !
!PstPackage categoriesFor: #fileOutConstantsOn:!fileout!public! !
!PstPackage categoriesFor: #fileOutMethodsOn:!fileout!public! !
!PstPackage categoriesFor: #fileOutOn:!fileout!public! !
!PstPackage categoriesFor: #initialize!initialization!public! !
!PstPackage categoriesFor: #isUncommitted!predicates!public! !
!PstPackage categoriesFor: #library!accessing!public! !
!PstPackage categoriesFor: #methods!accessing!public! !
!PstPackage categoriesFor: #name!accessing!public! !
!PstPackage categoriesFor: #name:!initialization!public! !
!PstPackage categoriesFor: #printOn:!printing!public! !
!PstPackage categoriesFor: #removeClass:!actions!public! !
!PstPackage categoriesFor: #removeConstant:!actions!public! !
!PstPackage categoriesFor: #removeMethod:!actions!public! !
!PstPackage categoriesFor: #save!fileout!public! !
!PstPackage categoriesFor: #saveAs:!fileout!public! !
!PstPackage categoriesFor: #simpleName!accessing!public! !

!PstPackage class methodsFor!

choose
	"PstPackage choose."
	| packages default |
	packages := PstPackageLibrary current packages
		reject: [:each | each isUncommitted].
	default := self default isUncommitted
		ifTrue: [nil]
		ifFalse: [self default].
	^default isNil
		ifTrue: [
			ListPrompter
				list: packages
				caption: 'Choose a Package']
		ifFalse: [
			ListPrompter
				on: default
			list: packages
			caption: 'Choose a Package'].!

default
	^PstPackageLibrary current defaultPackage.!

uncommitted
	^PstPackageLibrary current uncommittedPackage.! !
!PstPackage class categoriesFor: #choose!accessing!public! !
!PstPackage class categoriesFor: #default!accessing!public! !
!PstPackage class categoriesFor: #uncommitted!accessing!public! !



PstPackageLibrary comment: ''!

PstPackageLibrary guid: (GUID fromString: '{1C37E520-FD39-4CD1-9DEA-083664B81629}')!

!PstPackageLibrary categoriesForClass!No category! !
!PstPackageLibrary methodsFor!

addPackage: package
	packages add: package.
	"Assign kernel classes to the first package loaded."
	PstClassLibrary current commitBasicClassesTo: package.
	self trigger: #changed.!

classesChangedFor: package
	self
		trigger: #classesChangedFor:
		with: package.!

constantsChangedFor: package
	self
		trigger: #constantsChangedFor:
		with: package.!

createPackageNamed: filename
	| package |
	package := PstPackage new name: filename.
	self addPackage: package.
	self defaultPackage: package.!

defaultPackage
	^defaultPackage.!

defaultPackage: package
	defaultPackage := package.
	self trigger: #defaultPackageChanged.!

deferUpdatesDuring: block
	| oldEvents |
	oldEvents := events.
	events := nil.
	block ensure: [events := oldEvents].
	self trigger: #changed.!

fileIn: filename
	PstFileOutManager fileIn: filename.!

hasPackageNamed: name
	"^packages anySatisfy: [:each | each name asLowercase = name asLowercase]."

	^packages anySatisfy: [:each| (each name notNil) and: [each name asLowercase = name asLowercase]].!

initialize
	super initialize.
	defaultPackage := uncommittedPackage := 
		PstUncommittedPackage new.
	packages := OrderedCollection with: uncommittedPackage.!

installPackageNamed: filename
	| package oldDefault |
	package := (self hasPackageNamed: filename)
		ifTrue: [^self packageNamed: filename]
		ifFalse: [PstPackage new name: filename].
	oldDefault := defaultPackage.
	self addPackage: package.
	self defaultPackage: package.
	"ack..."
	self deferUpdatesDuring: [
		PstChangeLog current noLoggingDuring: [
			[self fileIn: filename]
				ensure: [self defaultPackage: oldDefault]]].
	^package.!

methodsChangedFor: package
	self
		trigger: #methodsChangedFor:
		with: package.!

movePackageToFront: package
	packages remove: package.
	packages add: package afterIndex: 1.
	self trigger: #changed.!

packageNamed: name
	^packages detect: [:each | (each name notNil) and: [each name asLowercase = name asLowercase]].
!

packages
	^packages.!

removePackage: package
	packages remove: package.
	self trigger: #changed.!

showFullPackageName
	!

uncommittedPackage
	^uncommittedPackage.! !
!PstPackageLibrary categoriesFor: #addPackage:!accessing!public! !
!PstPackageLibrary categoriesFor: #classesChangedFor:!public!updating! !
!PstPackageLibrary categoriesFor: #constantsChangedFor:!public!updating! !
!PstPackageLibrary categoriesFor: #createPackageNamed:!actions!public! !
!PstPackageLibrary categoriesFor: #defaultPackage!accessing!public! !
!PstPackageLibrary categoriesFor: #defaultPackage:!accessing!public! !
!PstPackageLibrary categoriesFor: #deferUpdatesDuring:!public!updating! !
!PstPackageLibrary categoriesFor: #fileIn:!actions!public! !
!PstPackageLibrary categoriesFor: #hasPackageNamed:!accessing!public! !
!PstPackageLibrary categoriesFor: #initialize!initialization!public! !
!PstPackageLibrary categoriesFor: #installPackageNamed:!actions!public! !
!PstPackageLibrary categoriesFor: #methodsChangedFor:!public!updating! !
!PstPackageLibrary categoriesFor: #movePackageToFront:!actions!public! !
!PstPackageLibrary categoriesFor: #packageNamed:!accessing!public! !
!PstPackageLibrary categoriesFor: #packages!accessing!public! !
!PstPackageLibrary categoriesFor: #removePackage:!accessing!public! !
!PstPackageLibrary categoriesFor: #showFullPackageName!actions!public! !
!PstPackageLibrary categoriesFor: #uncommittedPackage!accessing!public! !

!PstPackageLibrary class methodsFor!

current
	^PstSystem current packageLibrary.! !
!PstPackageLibrary class categoriesFor: #current!accessing!public! !



PstParseNode comment: ''!

PstParseNode guid: (GUID fromString: '{CE0D2296-E9AA-4581-8354-C01A47C0402A}')!

!PstParseNode categoriesForClass!No category! !
!PstParseNode methodsFor!

canCascade
	^false.!

compileOn: compiler pop: pop
	^self subclassResponsibility.!

isBlockNode
	^false.!

isLiteralNode
	^false.!

isReturnNode
	^false.!

isVariableNode
	^false.!

nodeName
	self subclassResponsibility.!

simpleLiteralValue
	^nil.!

sourcePosition
	^start to: stop.!

start
	^start.!

start: object
	start := object.!

start: newStart stop: newStop
	self start: newStart.
	self stop: newStop.!

stop
	^stop.!

stop: object
	stop := object.! !
!PstParseNode categoriesFor: #canCascade!predicates!public! !
!PstParseNode categoriesFor: #compileOn:pop:!*-subclass responsibility!compiling!public! !
!PstParseNode categoriesFor: #isBlockNode!predicates!public! !
!PstParseNode categoriesFor: #isLiteralNode!predicates!public! !
!PstParseNode categoriesFor: #isReturnNode!predicates!public! !
!PstParseNode categoriesFor: #isVariableNode!predicates!public! !
!PstParseNode categoriesFor: #nodeName!*-subclass responsibility!printing!public! !
!PstParseNode categoriesFor: #simpleLiteralValue!accessing!public! !
!PstParseNode categoriesFor: #sourcePosition!accessing!public! !
!PstParseNode categoriesFor: #start!accessing!public! !
!PstParseNode categoriesFor: #start:!accessing!public! !
!PstParseNode categoriesFor: #start:stop:!accessing!public! !
!PstParseNode categoriesFor: #stop!accessing!public! !
!PstParseNode categoriesFor: #stop:!accessing!public! !



PstParser comment: ''!

PstParser guid: (GUID fromString: '{A0E92F32-C69A-499C-96BA-0380E361B506}')!

!PstParser categoriesForClass!No category! !
!PstParser methodsFor!

arrayObjectFor: arrayContents
	^self subclassResponsibility.!

byteArrayObjectFor: arrayContents
	^self subclassResponsibility.!

doubleObjectFor: double
	^self subclassResponsibility.!

error: message at: position
	PstCompilerError new
		message: message;
		start: position;
		stop: position;
		signal.!

error: message for: parseNode
	PstCompilerError new
		message: message;
		start: parseNode start;
		stop: parseNode stop;
		signal.!

getArrayFromToken
	^Array
		with: token
		with: value
		with: tokenStart
		with: tokenStop.!

getTokenFromArray: array
	token := array at: 1.
	value := array at: 2.
	tokenStart := array at: 3.
	tokenStop := array at: 4.!

initialize
	super initialize.
	pushback := OrderedCollection new.!

integerObjectFor: integer
	^self subclassResponsibility.!

lexer: newLexer
	lexer := newLexer.
	self scanToken.!

node
	^node.!

parseArray: literalNode
	| contents |
	contents := OrderedCollection new.
	self scanToken.  "skip opening ("
	[token == $)] whileFalse: [
		token isNil ifTrue: [
			self
				error: 'Unterminated array literal'
				at: tokenStart].
		contents add: self parseArrayElement].
	literalNode stop: tokenStop.
	"Skip closing )"
	self scanToken.
	literalNode value: (self arrayObjectFor: contents).
	^node := literalNode.!

parseArrayElement
	"This returns the actual value, not a LiteralNode."
	| literalNode |
	self parseLiteral ifTrue: [
		node value class == PstConstant ifTrue: [
			^self 
				error: 'Constants cannot be embedded in literal arrays (sorry).'
				for: node].
		^node value].
	token == #identifier ifTrue: [
		value = 'nil' ifTrue: [self scanToken. ^PstBasicObject forNil].
		value = 'true' ifTrue: [self scanToken. ^PstBasicObject forTrue].
		value = 'false' ifTrue: [self scanToken. ^PstBasicObject forFalse]].
	literalNode := PstLiteralNode new start: tokenStart.
	token == $( ifTrue: [self parseArray: literalNode.  ^node value].
	token == $[ ifTrue: [self parseByteArray: literalNode.  ^node value].
	(#(identifier keyword binop) includes: token)
		ifTrue: [self parseSymbol: literalNode.  ^node value].
	self
		error: 'Expected literal array element'
		at: tokenStart.
	!

parseBinaryMessage
	| receiver selector argument |
	"Parse receiver"
	self parseUnaryMessage.
	token == #binop ifFalse: [^self].
	[token == #binop] whileTrue: [
		receiver := node.
		selector := value.
		self scanToken.
		self parseUnaryMessage.
		argument := node.
		node := PstMessageNode new.
		node receiver: receiver.
		node keywords: (Array with: selector).
		node arguments: (Array with: argument).
		node start: receiver start.
		node stop: argument stop].!

parseBinaryMessage: needsReceiver
	| receiver selector argument |
	self parseUnaryMessage: needsReceiver.
	token == #binop ifFalse: [^self].
	[token == #binop] whileTrue: [
		receiver := node.
		selector := value.
		self scanToken.
		self parseUnaryMessage.
		argument := node.
		node := PstMessageNode new.
		node receiver: receiver.
		node keywords: (Array with: selector).
		node arguments: (Array with: argument).
		receiver isNil
			ifTrue: [node start: tokenStart]
			ifFalse: [receiver start].
		node stop: argument stop].!

parseBlock
	| arguments block pos |
	block := PstBlockNode new.
	block start: tokenStart.
	self scanToken.  "skip opening ["
	arguments := OrderedCollection new.
	[token == $:] whileTrue: [
		self scanToken.
		token == #identifier ifFalse: [
			self
				error: 'Expected block argument name'
				at: tokenStart].
		arguments add: value.
		self scanToken].
	arguments isEmpty ifFalse: [
		(token == #binop and: [value = '|']) ifFalse: [
			self
				error: 'Expected vertical bar'
				at: tokenStart].
		self scanToken].
	block arguments: arguments.
	pos := tokenStart.
	self parseTemporaries isEmpty ifFalse: [
		self
			error: 'Blocks cannot have temporaries'
			at: pos].
	self parseStatements: $].
	block statements: node.
	token == $] ifFalse: [
		self
			error: 'Expected closing ]'
			at: tokenStart].
	block stop: tokenStop.
	self scanToken.
	^node := block.!

parseByteArray: literalNode
	| contents |
	contents := OrderedCollection new.
	self scanToken.  "skip ["
	[token == $]] whileFalse: [
		token == #integer ifFalse: [
			self
				error: 'Only integers may appear in byte arrays'
				at: tokenStart].
		(value between: 0 and: 255) ifFalse: [
			self
				error: 'Only integers between 0 and 255 may appear in byte arrays'
				at: tokenStart].
		contents add: value.
		self scanToken].
	literalNode stop: tokenStop.
	self scanToken.
	literalNode value: (self byteArrayObjectFor: contents).
	^node := literalNode.!

parseCascade
	| cascade |
	node canCascade ifFalse: [
		self
			error: 'Cannot cascade here'
			for: node].
	cascade := PstCascadeNode new.
	cascade receiver: node receiver.
	node receiver: nil.
	cascade addMessage: node.
	[token == $;] whileTrue: [
		self scanToken.
		self parseKeywordMessage: false.
		cascade addMessage: node].
	node := cascade.!

parseConstant: literalNode
	self scanToken.  "skip #"
	token == #identifier ifFalse: [
		^self error: 'Illegal constant name' at: tokenStart].
	(PstConstantsLibrary current hasConstantNamed: value)
		ifFalse: [
			^self
				error: 'No such constant ##', value
				at: tokenStart].
	literalNode value: (PstConstantsLibrary current 
			constantNamed: value).
	self scanToken.
	^node := literalNode.!

parseEscape: literalNode
	self scanToken.  "skip {"
	token == #identifier ifFalse: [
		^self error: 'Malformed escape reference' at: tokenStart].
	"value = 'tile' ifTrue: [^self parseTileEscape: literalNode]."
	^self
		error: 'Undefined escape type'
		at: tokenStart.!

parseExpression
	| scratch hold identifier start stop |
	start := tokenStart.
	stop := tokenStop.
	token == #identifier ifTrue: [
		identifier := value.
		hold := self getArrayFromToken.
		self scanToken.
		(token == #assign or: [token == #hardAssign]) ifTrue: [
			node := PstVariableNode new name: identifier.
			node start: start stop: stop.
			scratch := PstAssignmentNode new.
			scratch hard: token == #hardAssign.
			scratch start: node start.
			scratch variable: node.
			self scanToken.
			self parseExpression.
			scratch value: node.
			scratch stop: node stop.
			node := scratch.
			^self].
		self pushback.
		self getTokenFromArray: hold].
	self parseKeywordMessage: true.
	token == $; ifTrue: [self parseCascade].!

parseHash
	"Either a symbol, a constant, or a literal array."
	| literalNode |
	literalNode := PstLiteralNode new.
	literalNode start: tokenStart.
	lexer joinKeywords: true.  "allow #foo:bar:baz:"
	self scanToken.
	lexer joinKeywords: false.
	(#(identifier binop keyword string) identityIncludes: token)
		ifTrue: [^self parseSymbol: literalNode].
	token == $( ifTrue: [^self parseArray: literalNode].
	token == $[ ifTrue: [^self parseByteArray: literalNode].
	token == ${ ifTrue: [^self parseEscape: literalNode].
	token == $# ifTrue: [^self parseConstant: literalNode].
	^self
		error: 'Expected symbol or array'
		at: tokenStart.!

parseKeywordMessage
	| receiver keywords arguments |
	"Parse receiver"
	self parseBinaryMessage.
	token == #keyword
		ifFalse: [^self].
	receiver := node.
	keywords := OrderedCollection new.
	arguments := OrderedCollection new.
	[token == #keyword] whileTrue: [
		keywords add: value.
		self scanToken.
		self parseBinaryMessage.
		arguments add: node].
	node := PstMessageNode new.
	node
		receiver: receiver;
		keywords: keywords;
		arguments: arguments.
	node
		start: receiver start;
		stop: arguments last stop.!

parseKeywordMessage: needsReceiver
	| receiver keywords arguments |
	self parseBinaryMessage: needsReceiver.
	token == #keyword
		ifFalse: [^self].
	receiver := node.
	keywords := OrderedCollection new.
	arguments := OrderedCollection new.
	[token == #keyword] whileTrue: [
		keywords add: value.
		self scanToken.
		self parseBinaryMessage.
		arguments add: node].
	node := PstMessageNode new.
	node
		receiver: receiver;
		keywords: keywords;
		arguments: arguments.
	receiver isNil
		ifTrue: [node start: nil]
		ifFalse: [node start: receiver start].
	node stop: arguments last stop.!

parseLiteral
	"If we found a literal, set node and answer true, otherwise answer false."
	token == #string ifTrue: [
		node := PstLiteralNode new
			value: (self stringObjectFor: value).
		node start: tokenStart stop: tokenStop.
		self scanToken.
		^true].
	token == #character ifTrue: [
		node := PstCharacterLiteralNode new
			value: value.
		node start: tokenStart stop: tokenStop.
		self scanToken.
		^true].
	token == #integer ifTrue: [
		node := PstLiteralNode new 
			value: (self integerObjectFor: value).
		node start: tokenStart stop: tokenStop.
		self scanToken.
		^true].
	token == #double ifTrue: [
		node := PstLiteralNode new
			value: (self doubleObjectFor: value).
		node start: tokenStart stop: tokenStop.
		self scanToken.
		^true].
	token == $# ifTrue: [
		self parseHash.
		^true].
	token == $[ ifTrue: [
		self parseBlock.
		^true].
	^false.!

parseMessagePattern
	"What, me refactor?"
	| keywords arguments start stop keywordRanges argumentRanges |
	keywords := OrderedCollection new.
	arguments := OrderedCollection new.
	keywordRanges := OrderedCollection new.
	argumentRanges := OrderedCollection new.
	start := tokenStart.
	stop := tokenStop.
	token == #identifier 
		ifTrue: [
			keywords add: value.
			keywordRanges add: (tokenStart to: tokenStop).
			self scanToken]
		ifFalse: [
			token == #keyword
				ifTrue: [
					[token == #keyword] whileTrue: [
						keywords add: value.
						keywordRanges add: (tokenStart to: tokenStop).
						self scanToken.
						token == #identifier ifFalse: [
							self
								error: 'Expected argument name'
								at: tokenStart].
						arguments add: value.
						argumentRanges add: (tokenStart to: tokenStop).
						stop := tokenStop.
						self scanToken]]
				ifFalse: [
					token == #binop
						ifTrue: [
							keywords add: value.
							keywordRanges add: (tokenStart to: tokenStop).
							self scanToken.
							token == #identifier ifFalse: [
								self
									error: 'Expected argument name'
									at: tokenStart].
							arguments add: value.
							argumentRanges add: (tokenStart to: tokenStop).
							stop := tokenStop.
							self scanToken]
						ifFalse: [
							self
								error: 'Expected message pattern'
								at: tokenStart]]].
	node := PstMessagePattern new.
	node 
		keywords: keywords;
		arguments: arguments;
		start: start stop: stop;
		keywordRanges: keywordRanges;
		argumentRanges: argumentRanges.!

parseMethod
	| method |
	method := PstMethodNode new.
	self parseMessagePattern.
	method start: node start.
	method pattern: node.
	method primitive: self parsePrimitive.
	self parseStatements: nil.
	method statements: node.
	method stop: node stop.
	method commentMap: lexer commentMap.
	node := method.!

parseParenthesizedExpression
	| start |
	start := tokenStart.
	self scanToken.
	self parseExpression.
	token == $) ifFalse: [
		self 
			error: 'Expected right parenthesis'
			at: tokenStart].
	node start: start stop: tokenStop.
	self scanToken.!

parsePatternlessMethod
	| method |
	method := PstMethodNode new.
	self parseStatements: nil.
	method statements: node.
	node := method.!

parsePrimary
	token == #identifier 
		ifTrue: [^self parseVariable].
	token == $( 
		ifTrue: [^self parseParenthesizedExpression].
	self parseLiteral 
		ifTrue: [^self].
	self
		error: 'Expected expression'
		at: tokenStart.!

parsePrimitive
	^self subclassResponsibility.!

parseReturn
	| return |
	return := PstReturnNode new.
	return start: tokenStart.
	self scanToken.
	self parseExpression.
	return value: node.
	return stop: node stop.
	node := return.!

parseStatement: terminator
	token == $^
		ifTrue: [self parseReturn]
		ifFalse: [self parseExpression].
	token == $. 
		ifTrue: [self scanToken]
		ifFalse: [
			"If this is the last token, omitting the dot is all right."
			token == terminator ifFalse: [
				self error: 'Expected dot' at: tokenStart]].!

parseStatements: terminator
	"terminator is the token type that tells when to stop scanning."
	| statements lastWasReturn |
	lastWasReturn := false.
	statements := PstStatementsNode new.
	statements start: tokenStart stop: tokenStop.
	statements temporaries: self parseTemporaries.
	[token == terminator] whileFalse: [
		self parseStatement: terminator.
		lastWasReturn ifTrue: [
			self
				warning: 'Code has no effect'
				for: node].
		statements addStatement: node.
		statements stop: node stop.
		lastWasReturn := node isReturnNode].
	node := statements.!

parseSymbol: literalNode
	literalNode value: (self symbolObjectFor: value).
	literalNode stop: tokenStop.
	node := literalNode.
	self scanToken.!

parseTemporaries
	| buffer |
	buffer := WriteStream on: Array new.
	(token == #binop and: [value = '|']) ifTrue: [
		self scanToken.
		[token == #binop and: [value = '|']] whileFalse: [
			token == #identifier ifFalse: [
				self
					error: 'Expected name of temporary'
					at: tokenStart].
			buffer nextPut: value.
			self scanToken].
		self scanToken].
	^buffer contents.!

parseUnaryMessage
	| message |
	self parsePrimary.
	[token == #identifier] whileTrue: [
		message := PstMessageNode new.
		message receiver: node.
		message keywords: (Array with: value).
		message arguments: #().
		message start: node start stop: tokenStop.
		node := message.
		self scanToken].!

parseUnaryMessage: needsReceiver
	| message |
	needsReceiver 
		ifTrue: [self parsePrimary]
		ifFalse: [node := nil].
	[token == #identifier] whileTrue: [
		message := PstMessageNode new.
		message receiver: node.
		message keywords: (Array with: value).
		message arguments: #().
		needsReceiver 
			ifTrue: [message start: node start]
			ifFalse: [message start: tokenStart].
		message stop: tokenStop.
		node := message.
		self scanToken].!

parseVariable
	node := PstVariableNode new name: value.
	node start: tokenStart stop: tokenStop.
	self scanToken.!

pushback
	pushback addLast: self getArrayFromToken.!

scanToken
	| assoc |
	pushback isEmpty 
		ifTrue: [
			token := lexer scanToken.
			value := lexer value.
			tokenStart := lexer tokenStart.
			tokenStop := lexer tokenStop]
		ifFalse: [
			self getTokenFromArray: pushback removeLast].	!

stringObjectFor: string
	^self subclassResponsibility.!

symbolObjectFor: string
	^self subclassResponsibility.!

warning: message at: position
	| exception |
	exception := PstCompilerWarning new
		message: message.
	exception
		start: position;
		stop: position.
	exception signal.!

warning: message for: parseNode
	PstCompilerWarning new
		message: message;
		start: parseNode start;
		stop: parseNode stop;
		signal.! !
!PstParser categoriesFor: #arrayObjectFor:!*-subclass responsibility!object creation!public! !
!PstParser categoriesFor: #byteArrayObjectFor:!*-subclass responsibility!object creation!public! !
!PstParser categoriesFor: #doubleObjectFor:!*-subclass responsibility!object creation!public! !
!PstParser categoriesFor: #error:at:!error handling!public! !
!PstParser categoriesFor: #error:for:!error handling!public! !
!PstParser categoriesFor: #getArrayFromToken!public!utility! !
!PstParser categoriesFor: #getTokenFromArray:!public!utility! !
!PstParser categoriesFor: #initialize!initialization!public! !
!PstParser categoriesFor: #integerObjectFor:!*-subclass responsibility!object creation!public! !
!PstParser categoriesFor: #lexer:!initialization!public! !
!PstParser categoriesFor: #node!accessing!public! !
!PstParser categoriesFor: #parseArray:!parsing!public! !
!PstParser categoriesFor: #parseArrayElement!parsing!public! !
!PstParser categoriesFor: #parseBinaryMessage!parsing!public! !
!PstParser categoriesFor: #parseBinaryMessage:!parsing!public! !
!PstParser categoriesFor: #parseBlock!parsing!public! !
!PstParser categoriesFor: #parseByteArray:!parsing!public! !
!PstParser categoriesFor: #parseCascade!parsing!public! !
!PstParser categoriesFor: #parseConstant:!parsing!public! !
!PstParser categoriesFor: #parseEscape:!parsing!public! !
!PstParser categoriesFor: #parseExpression!parsing!public! !
!PstParser categoriesFor: #parseHash!parsing!public! !
!PstParser categoriesFor: #parseKeywordMessage!parsing!public! !
!PstParser categoriesFor: #parseKeywordMessage:!parsing!public! !
!PstParser categoriesFor: #parseLiteral!parsing!public! !
!PstParser categoriesFor: #parseMessagePattern!parsing!public! !
!PstParser categoriesFor: #parseMethod!parsing!public! !
!PstParser categoriesFor: #parseParenthesizedExpression!parsing!public! !
!PstParser categoriesFor: #parsePatternlessMethod!parsing!public! !
!PstParser categoriesFor: #parsePrimary!parsing!public! !
!PstParser categoriesFor: #parsePrimitive!*-subclass responsibility!parsing!public! !
!PstParser categoriesFor: #parseReturn!parsing!public! !
!PstParser categoriesFor: #parseStatement:!parsing!public! !
!PstParser categoriesFor: #parseStatements:!parsing!public! !
!PstParser categoriesFor: #parseSymbol:!parsing!public! !
!PstParser categoriesFor: #parseTemporaries!parsing!public! !
!PstParser categoriesFor: #parseUnaryMessage!parsing!public! !
!PstParser categoriesFor: #parseUnaryMessage:!parsing!public! !
!PstParser categoriesFor: #parseVariable!parsing!public! !
!PstParser categoriesFor: #pushback!public!utility! !
!PstParser categoriesFor: #scanToken!public!utility! !
!PstParser categoriesFor: #stringObjectFor:!*-subclass responsibility!object creation!public! !
!PstParser categoriesFor: #symbolObjectFor:!*-subclass responsibility!object creation!public! !
!PstParser categoriesFor: #warning:at:!error handling!public! !
!PstParser categoriesFor: #warning:for:!error handling!public! !

!PstParser class methodsFor!

isPseudoVariableName: variableName
	^#('self' 'super' 'nil' 'true' 'false' 'thisContext')
		includes: variableName.!

isValidIdentifier: string
	string isEmpty ifTrue: [^false].
	^(string allSatisfy: [:each |
			each isLetter or: [each isDigit or: [each = $_]]])
		and: [string first isDigit not].!

isValidVariableName: string
	^(self isValidIdentifier: string)
		and: [(self isPseudoVariableName: string) not].!

onLexer: lexer
	^self new lexer: lexer.!

onString: string
	| lexer |
	lexer := PstLexer on: (ReadStream on: string).
	^self onLexer: lexer.!

parseExpression: string
	| parser |
	parser := self onString: string.
	parser parsePatternlessMethod.
	^parser node.!

parseSimpleLiteral: string
	"Parse a simple value; if successful, answer the value.  Otherwise, answer nil."
	| node |
	[node := self parseExpression: string]
		on: PstCompilerError
		do: [:exception | ^nil]
		on: PstCompilerWarning
		do: [:exception | ^nil].
	^node simpleLiteralValue.!

parseString: string
	| parser |
	parser := self onString: string.
	parser parseMethod.
	^parser node.! !
!PstParser class categoriesFor: #isPseudoVariableName:!public!utility! !
!PstParser class categoriesFor: #isValidIdentifier:!public!utility! !
!PstParser class categoriesFor: #isValidVariableName:!public!utility! !
!PstParser class categoriesFor: #onLexer:!instance creation!public! !
!PstParser class categoriesFor: #onString:!instance creation!public! !
!PstParser class categoriesFor: #parseExpression:!public!utility! !
!PstParser class categoriesFor: #parseSimpleLiteral:!public!utility! !
!PstParser class categoriesFor: #parseString:!public!utility! !



PstPrimitiveSet comment: ''!

PstPrimitiveSet guid: (GUID fromString: '{657B413C-E00B-4152-8587-9BA0C5CBB667}')!

!PstPrimitiveSet categoriesForClass!No category! !
!PstPrimitiveSet methodsFor!

asCharacter: integer
	"SmallInteger>>#asCharacter"
	"Fails with:
1 - integer not in the range 0..255"
	(integer value between: 0 and: 255)
		ifFalse: [^self fail: 1].
	^PstCharacter value: integer value.!

augmentPrimitiveMap
	| newMap |
	newMap := IdentityDictionary new.
	primitiveMap keysAndValuesDo: [:index :selector |
		newMap
			at: index
			put: selector -> (selector argumentCount - 1)].
	primitiveMap := newMap.!

basicHash: receiver
	"This is tricky -- since the identity hashes of objects are changed when creating the finished image file, identity dictionaries and so forth will need to be rehashed at that time.  During development time, just use the host Smalltalk identity hash for the object (restricted to the runtime range)."
	^PstInteger value: receiver 
		simulatedIdentityHash \\ 16r4000.!

basicNew: behavior
	"Create a new instance of the receiver, which must be an ordinary class (not indexable or pointerless)."
	"Fails with:
1 - receiver is indexable or pointerless
2 - not enough memory"
	behavior isIndexable
		ifTrue: [^self fail: 1].
	^behavior instantiate.!

basicNew: behavior indexed: indexedSize
	"Create a new instance of the receiver, which must be an indexable class."
	"Fails with:
1 - receiver is not indexable
2 - not enough memory
3 - size argument is invalid"
	behavior isIndexable ifFalse: [^self fail: 1].
	indexedSize isIntegerObject ifFalse: [^self fail: 3].
	(indexedSize value between: 0 and: 4095)
		ifFalse: [^self fail: 3].
	^behavior instantiateIndexed: indexedSize value.!

basicSize: receiver
	^PstInteger value: receiver indexedSlotCount.!

become: first with: second
	(first canBecome and: [second canBecome])
		ifFalse: [self error: 'cannot swap identities of these objects'].
	first become: second.
	^second.!

bindBasicPrimitives
	primitiveMap
		at: 0 put: #unused:;
		at: 1 put: #for:basicError:;
		at: 2 put: #cleanExit:;
		at: 3 put: #runningOnDevice:;
		at: 4 put: #basicSize:;
		at: 5 put: #for:basicAt:;
		at: 6 put: #for:basicAt:put:;
		at: 7 put: #blockValue:;
		at: 8 put: #for:blockValue:;
		at: 9 put: #for:blockValue:with:;
		at: 10 put: #basicNew:;
		at: 11 put: #basicNew:indexed:;
		at: 12 put: #collectGarbage:;
		at: 13 put: #for:perform:;
		at: 14 put: #for:perform:with:;
		at: 15 put: #for:perform:with:with:;
		at: 16 put: #for:perform:with:with:with:;
		at: 17 put: #for:perform:withArguments:;
		at: 18 put: #shallowCopy:;
		at: 19 put: #basicHash:;
		at: 20 put: #become:with:;
		at: 21 put: #class:;
		at: 22 put: #is:kindOf:;
		at: 23 put: #instVar:at:;
		at: 24 put: #instVar:at:put:;
		at: 25 put: #characterValue:;
		at: 26 put: #asCharacter:;
		at: 27 put: #byteConcatenate:with:;
		at: 28 put: #freeMemory:;
		at: 29 put: #freePalmOSMemory:;
		at: 30 put: #unused:;
		at: 31 put: #unused:;
		at: 32 put: #for:textOfSymbol:;
		at: 33 put: #for:nameOfClass:;
		at: 34 put: #unused:;
		at: 35 put: #byteArrayCompare:with:;
		at: 41 put: #testCharacter:bit:;
		at: 50 put: #stringHash:.!

bindCollectionPrimitives
	primitiveMap
		at: 60 put: #expandCollection:by:;
		at: 61 put: #expandCollection:by:;
		at: 62 put: #stringWriteStream:nextPut:;
		at: 63 put: #stringWriteStream:nextPutAll:;
		at: 64 put: #copy:from:to:;
		at: 65 put: #copy:from:to:.!

bindDebuggingPrimitives
	primitiveMap
		at: 36 put: #for:slotsForContext:;
		at: 37 put: #for:receiverForContext:;
		at: 38 put: #for:selectorForContext:;
		at: 39 put: #for:classForContext:;
		at: 40 put: #for:stackSlotAt:forContext:.!

bindNumberPrimitives
	primitiveMap
		at: 70 put: #integerAdd:with:;
		at: 71 put: #integerSubtract:with:;
		at: 72 put: #integerMultiply:with:;
		at: 73 put: #integerBitAnd:with:;
		at: 74 put: #integerBitOr:with:;
		at: 75 put: #integerBitXor:with:;
		at: 76 put: #integerDivide:with:;
		at: 77 put: #integerQuo:with:;
		at: 78 put: #integerGCD:with:;
		at: 79 put: #integerLess:than:;
		at: 80 put: #integerLessOrEqual:than:;
		at: 81 put: #integerGreater:than:;
		at: 82 put: #integerGreaterOrEqual:than:;
		at: 83 put: #integerEqual:to:;
		at: 84 put: #integerNotEqual:to:;
		at: 85 put: #integerRem:with:;
		at: 86 put: #integerBackslashMod:with:;
		at: 87 put: #integerBitShift:with:;
		at: 88 put: #integerPrintString:;

		at: 90 put: #doublePrintString:;
		at: 91 put: #doubleAsInteger:;
		at: 92 put: #integerAsDouble:;
		at: 93 put: #doubleAdd:with:;
		at: 94 put: #doubleSubtract:with:;
		at: 95 put: #doubleMultiply:with:;
		at: 96 put: #doubleDivide:with:;
		at: 97 put: #doubleLess:than:;
		at: 98 put: #doubleEqual:to:;
		at: 100 put: #doubleUnary:functionNumber:;
		at: 101 put: #doubleRemaineder:.!

bindTranscriptPrimitives
	primitiveMap
		at: 1000 put: #transcript:nextPutAll:!

blockValue: receiver
	^(interpreter blockValue: 0)
		ifTrue: [nil]
		ifFalse: [self fail: 1].!

byteArrayCompare: receiver with: argument
	"Compare two byte indexable objects for equality."
	"Fails with:
1 - argument is not the same class as the receiver"
	receiver qclass == argument qclass
		ifFalse: [^self fail: 1].
	^PstBasicObject forBoolean: 
		(receiver equals: argument).!

byteConcatenate: receiver with: argument
	"ByteArray>>#,"
	"Fails with:
1 - receiver class ~= argument class"
	| result receiverSize argumentSize |
	receiver qclass == argument qclass
		ifFalse: [^self fail: 1].
	receiverSize := receiver indexedSlotCount.
	argumentSize := argument indexedSlotCount.
	result := receiver qclass
		instantiateIndexed: receiverSize + argumentSize.
	1 to: receiverSize do: [:n |
		result
			byteIndexedSlotAt: n
			put: (receiver byteIndexedSlotAt: n)].
	1 to: argumentSize do: [:n |
		result
			byteIndexedSlotAt: receiverSize + n
			put: (argument byteIndexedSlotAt: n)].
	^result.!

characterValue: character
	^PstInteger value: character value asInteger.!

class: receiver
	^receiver qclass.!

cleanExit: receiver
	interpreter synchronize: #exit.
	^receiver.!

collectGarbage: receiver
	"No-op in the simulator."
	^receiver.!

copy: receiver from: startIndex to: stopIndex
	"Fails with:
1 - either argument is not an integer
2 - arguments out of bounds
3 - result collection is empty"
	| start stop arraySize sublength subarray |
	arraySize := receiver indexedSlotCount.
	(startIndex isIntegerObject
			or: [stopIndex isIntegerObject])
		ifFalse: [^self fail: 1].
	start := startIndex value.
	stop := stopIndex value.
	((start between: 1 and: arraySize)
			and: [stop between: 1 and: arraySize])
		ifFalse: [^self fail: 2].
	start > stop ifTrue: [^self fail: 3].
	sublength := stop - start + 1.
	subarray := receiver qclass instantiateIndexed: sublength.
	1 to: sublength do: [:n |
		subarray
			indexedSlotAt: n
			put: (receiver indexedSlotAt: start + n - 1)].
	^subarray.!

createPrimitiveMap
	primitiveMap := IdentityDictionary new.
	self 
		bindBasicPrimitives;
		bindNumberPrimitives;
		bindCollectionPrimitives;
		bindDebuggingPrimitives;
		bindTranscriptPrimitives!

doubleAdd: receiver with: argument
	^self
		doubleOp: #+
		with: receiver
		with: argument.!

doubleAsInteger: receiver
	^PstInteger value: receiver value asInteger.!

doubleDivide: receiver with: argument
	^self
		doubleOp: #/
		with: receiver
		with: argument.!

doubleEqual: receiver to: argument
	argument isDoubleObject ifFalse: [^self fail: 1].
	^PstBasicObject forBoolean: receiver value = argument value.!

doubleLess: receiver than: argument
	argument isDoubleObject ifFalse: [^self fail: 1].
	^PstBasicObject forBoolean: receiver value < argument value.!

doubleMultiply: receiver with: argument
	^self
		doubleOp: #*
		with: receiver
		with: argument.!

doubleOp: selector with: left with: right
	right isDoubleObject ifFalse: [^self fail: 1].
	^PstDouble value: (left value perform: selector with: right value).!

doublePrintString: receiver
	^PstByteIndexableObject newString: receiver value printString.!

doubleSubtract: receiver with: argument
	^self
		doubleOp: #-
		with: receiver
		with: argument.!

doubleUnary: receiver functionNumber: function
	| double index table selector |
	double := receiver value.
	function isIntegerObject ifTrue: [^self fail: 1].
	index := function value.
	table := #(arcCos arcSin arcTan cos sin tan nil nil nil nil nil nil exp ln log nil nil nil nil sqrt nil ceiling abs floor nil nil rounded truncated).
	(index between: 1 and: table size)
		ifFalse: [^self fail: 2].
	selector := table at: index + 1.
	selector isNil ifTrue: [^interpreter cannotSimulatePrimitive].
	^receiver value perform: selector.!

expandCollection: receiver by: amount
	| extraSlots |
	"Fails with:
1 - invalid amount argument"
	amount isIntegerObject
		ifFalse: [^self fail: 1].
	extraSlots := amount value.
	extraSlots < 0 ifTrue: [^self fail: 1].
	^receiver copyExpandedBy: extraSlots.!

fail: failCode
	interpreter primitiveFailCode: failCode.
	^nil.  "nil signals primitive failure"!

for: receiver basicAt: index
	| integer |
	index isIntegerObject
		ifFalse: [self fail: 1].
	integer := index value.
	integer < 1 ifTrue: [^self fail: 1].
	integer > receiver indexedSlotCount
		ifTrue: [^self fail: 1].
	^receiver indexedSlotAt: integer.!

for: receiver basicAt: index put: value
	| integer |
	index isIntegerObject
		ifFalse: [self fail: 1].
	integer := index value.
	integer < 1 ifTrue: [self fail: 1].
	receiver indexedSlotAt: integer put: value.
	^value.!

for: receiver basicError: message
	interpreter runtimeError: (message qclass name = 'String'
		ifTrue: [message convertToString]
		ifFalse: ['(non-string error message)']).
	^receiver.!

for: receiver blockValue: arg1
	^(interpreter blockValue: 1)
		ifTrue: [nil]
		ifFalse: [self fail: 1].!

for: receiver blockValue: arg1 with: arg2
	^(interpreter blockValue: 2)
		ifTrue: [nil]
		ifFalse: [self fail: 1].!

for: receiver classForContext: contextIndex
	contextIndex isIntegerObject ifFalse: [^self fail: 1].
	^(interpreter stackFrameAt: contextIndex value)
		method ownerClass.!

for: receiver nameOfClass: class
	"Fails with:
1 - name of the class is not available, or not a valid class object."
	class class == PstClass
		ifFalse: [^self fail: 1].
	^PstByteIndexableObject newString: class name.!

for: receiver perform: selector
	interpreter perform: 0.
	^nil.!

for: receiver perform: selector with: arg1
	interpreter perform: 1.
	^nil.!

for: receiver perform: selector with: arg1 with: arg2
	interpreter perform: 2.
	^nil.!

for: receiver perform: selector with: arg1 with: arg2 with: arg3
	interpreter perform: 3.
	^nil.!

for: receiver perform: selector withArguments: array
	| size |
	size := array indexedSlots size.
	interpreter pop. "drop the array"
	array indexedSlots do: [ :elt | interpreter push: elt ].
	interpreter perform: size.
	^nil!

for: receiver receiverForContext: contextIndex
	contextIndex isIntegerObject ifFalse: [^self fail: 1].
	^(interpreter stackFrameAt: contextIndex value) receiver.!

for: receiver selectorForContext: contextIndex
	contextIndex isIntegerObject ifFalse: [^self fail: 1].
	^PstSymbol string:
		(interpreter stackFrameAt: contextIndex value) 
			method selector.!

for: receiver slotsForContext: contextIndex
	| frame |
	contextIndex isIntegerObject ifFalse: [^self fail: 1].
	frame := interpreter stackFrameAt: contextIndex value.
	^PstInteger value: frame dataStackPtr - frame callStackPtr.!

for: receiver stackSlotAt: slot forContext: contextIndex
	(contextIndex isIntegerObject 
			and: [slot isIntegerObject])
		ifFalse: [^self fail: 1].
	^interpreter dataStackAt:
		(interpreter stackFrameAt: contextIndex value)
			localVarBase + slot value!

for: receiver textOfSymbol: symbol
	"Context class>>#textOfSymbol:"
	"Fails with:
1 - symbol text not available (or argument is not a symbol object)."
	symbol class == PstSymbol
		ifFalse: [^self fail: 1].
	^PstByteIndexableObject newString: symbol string.!

freeMemory: receiver
	"Fake it..."
	^PstInteger value: 10000.!

freePalmOSMemory: receiver
	"Fake it..."
	^PstInteger value: 10000.!

initialize
	super initialize.
	self createPrimitiveMap.
	self augmentPrimitiveMap.!

instVar: receiver at: index
	"Fails with:
1 - index is not an integer
2 - index is out of range"
	index isIntegerObject ifFalse: [^self fail: 1].
	^(receiver hasNamedSlotAt: index value)
		ifTrue: [receiver namedSlotAt: index value]
		ifFalse: [self fail: 2].!

instVar: receiver at: index put: newValue
	"Fails with:
1 - index is not an integer
2 - index is out of range"
	index isIntegerObject ifFalse: [^self fail: 1].
	^(receiver hasNamedSlotAt: index value)
		ifTrue: [receiver namedSlotAt: index value put: newValue]
		ifFalse: [self fail: 2].!

integerAdd: receiver with: argument
	^self integerOp: #+ left: receiver right: argument.!

integerAsDouble: receiver
	^PstDouble value: receiver value asFloat.!

integerBackslashMod: receiver with: argument
	^self 
		integerOp: #\\
		left: receiver 
		right: argument.!

integerBitAnd: receiver with: argument
	^self integerOp: #bitAnd: left: receiver right: argument.!

integerBitOr: receiver with: argument
	^self integerOp: #bitOr: left: receiver right: argument.!

integerBitShift: receiver with: argument
	^self 
		integerOp: #bitShift:
		left: receiver 
		right: argument.!

integerBitXor: receiver with: argument
	^self integerOp: #bitXor: left: receiver right: argument.!

integerCompare: selector
left: left
right: right
	right isIntegerObject ifFalse: [^self fail: 1].
	^PstBasicObject forBoolean:
		(left value 
			perform: selector
			with: right value).!

integerDivide: receiver with: argument
	^self integerOp: #// left: receiver right: argument.!

integerEqual: receiver to: argument
	^self 
		integerCompare: #=
		left: receiver 
		right: argument.!

integerGCD: receiver with: argument
	^self integerOp: #gcd: left: receiver right: argument.!

integerGreater: receiver than: argument
	^self 
		integerCompare: #>
		left: receiver 
		right: argument.!

integerGreaterOrEqual: receiver than: argument
	^self 
		integerCompare: #>=
		left: receiver 
		right: argument.!

integerLess: receiver than: argument
	^self 
		integerCompare: #<
		left: receiver 
		right: argument.!

integerLessOrEqual: receiver than: argument
	^self 
		integerCompare: #<=
		left: receiver 
		right: argument.!

integerMultiply: receiver with: argument
	^self integerOp: #* left: receiver right: argument.!

integerNotEqual: receiver to: argument
	^self 
		integerCompare: #~=
		left: receiver 
		right: argument.!

integerOp: selector
left: left
right: right
	| result |
	right isIntegerObject ifFalse: [^self fail: 1].
	result := left value
			perform: selector
			with: right value.
	^PstInteger value:
		((result max: -16r80000000)
			min: 16r7FFFFFFF).!

integerPrintString: receiver
	"It's legal to print symbols at runtime (you get an integer), so try to at least simulate that behavior here."
	^PstByteIndexableObject newString:
		(receiver class == PstSymbol
			ifTrue: ['#<', receiver string, '>']
			ifFalse: [receiver value printString]).!

integerQuo: receiver with: argument
	^self integerOp: #quo: left: receiver right: argument.!

integerRem: receiver with: argument
	^self 
		integerOp: #rem:
		left: receiver 
		right: argument.!

integerSubtract: receiver with: argument
	^self integerOp: #- left: receiver right: argument.!

interpreter: newInterpreter
	interpreter := newInterpreter.!

is: receiver kindOf: class
	^PstBasicObject forBoolean: 
		(receiver qclass inheritsFrom: class).!

performPrimitive: index
	| selector arguments association |
	association := primitiveMap at: index ifAbsent: [nil].
	association isNil ifTrue: [
		"Unimplemented or unbound primitive..."
		^interpreter runtimeError: 'Unimplemented primitive ', index printString].
	selector := association key.
	arguments := association value.
	^self
		perform: selector
		withArguments: (interpreter rskim: arguments).!

runningOnDevice: receiver
	^PstBasicObject forFalse.!

shallowCopy: receiver
	^receiver copy.!

stringHash: receiver
	"Use the underlying string hash"
	^PstInteger value: receiver convertToString
		hash \\ 16r4000.
!

stringWriteStream: receiver nextPut: character
	"Fails with:
1 - argument is not a character"
	| position limit expandAmount string |
	character isCharacterObject ifFalse: [^self fail: 1].
	string := receiver namedSlotAt: 1.
	position := (receiver namedSlotAt: 2) value.
	limit := (receiver namedSlotAt: 3) value.
	position >= limit ifTrue: [
		"Expand the string (buffer)."
		expandAmount := string indexedSlotCount // 2 max: 10.
		string := string copyExpandedBy: expandAmount.
		receiver namedSlotAt: 1 put: string.
		limit := string indexedSlotCount.
		receiver namedSlotAt: 3 put: (PstInteger value: limit)].
	string 
		byteIndexedSlotAt: position + 1 
		put: character value asInteger.
	receiver 
		namedSlotAt: 2
		put: (PstInteger value: position + 1).
	^character.!

stringWriteStream: receiver nextPutAll: string
	"Fails with:
1 - argument is not a string"
	| position limit expandAmount stringLength buffer |
	string qclass name = 'String' ifFalse: [^self fail: 1].
	buffer := receiver namedSlotAt: 1.
	position := (receiver namedSlotAt: 2) value.
	limit := (receiver namedSlotAt: 3) value.
	stringLength := string indexedSlotCount.
	position + stringLength > limit ifTrue: [
		"Expand the buffer (buffer)."
		expandAmount := (buffer indexedSlotCount // 2 
				max: 10) max: stringLength.
		buffer := buffer copyExpandedBy: expandAmount.
		receiver namedSlotAt: 1 put: buffer.
		limit := buffer indexedSlotCount.
		receiver namedSlotAt: 3 put: (PstInteger value: limit)].
	1 to: stringLength do: [:n |
		buffer
			byteIndexedSlotAt: position + n
			put: (string byteIndexedSlotAt: n)].
	receiver 
		namedSlotAt: 2
		put: (PstInteger value: position + stringLength).
	^string.!

testCharacter: receiver bit: bit
	bit isIntegerObject ifFalse: [^self fail: 1].
	^PstBasicObject forBoolean:
		(receiver attributes bitAnd: bit value) ~= 0.!

transcript: transcript nextPutAll: string

	Transcript show: string convertToString! !
!PstPrimitiveSet categoriesFor: #asCharacter:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #augmentPrimitiveMap!initialization!public! !
!PstPrimitiveSet categoriesFor: #basicHash:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #basicNew:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #basicNew:indexed:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #basicSize:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #become:with:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #bindBasicPrimitives!initialization!public! !
!PstPrimitiveSet categoriesFor: #bindCollectionPrimitives!initialization!public! !
!PstPrimitiveSet categoriesFor: #bindDebuggingPrimitives!initialization!public! !
!PstPrimitiveSet categoriesFor: #bindNumberPrimitives!initialization!public! !
!PstPrimitiveSet categoriesFor: #bindTranscriptPrimitives!initialization!public! !
!PstPrimitiveSet categoriesFor: #blockValue:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #byteArrayCompare:with:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #byteConcatenate:with:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #characterValue:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #class:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #cleanExit:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #collectGarbage:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #copy:from:to:!collection primitives!public! !
!PstPrimitiveSet categoriesFor: #createPrimitiveMap!initialization!public! !
!PstPrimitiveSet categoriesFor: #doubleAdd:with:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #doubleAsInteger:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #doubleDivide:with:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #doubleEqual:to:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #doubleLess:than:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #doubleMultiply:with:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #doubleOp:with:with:!helper methods!public! !
!PstPrimitiveSet categoriesFor: #doublePrintString:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #doubleSubtract:with:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #doubleUnary:functionNumber:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #expandCollection:by:!collection primitives!public! !
!PstPrimitiveSet categoriesFor: #fail:!execution!public! !
!PstPrimitiveSet categoriesFor: #for:basicAt:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #for:basicAt:put:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #for:basicError:!debugging primitives!public! !
!PstPrimitiveSet categoriesFor: #for:blockValue:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #for:blockValue:with:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #for:classForContext:!debugging primitives!public! !
!PstPrimitiveSet categoriesFor: #for:nameOfClass:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #for:perform:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #for:perform:with:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #for:perform:with:with:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #for:perform:with:with:with:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #for:perform:withArguments:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #for:receiverForContext:!debugging primitives!public! !
!PstPrimitiveSet categoriesFor: #for:selectorForContext:!debugging primitives!public! !
!PstPrimitiveSet categoriesFor: #for:slotsForContext:!debugging primitives!public! !
!PstPrimitiveSet categoriesFor: #for:stackSlotAt:forContext:!debugging primitives!public! !
!PstPrimitiveSet categoriesFor: #for:textOfSymbol:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #freeMemory:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #freePalmOSMemory:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #initialize!initialization!public! !
!PstPrimitiveSet categoriesFor: #instVar:at:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #instVar:at:put:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #integerAdd:with:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #integerAsDouble:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #integerBackslashMod:with:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #integerBitAnd:with:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #integerBitOr:with:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #integerBitShift:with:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #integerBitXor:with:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #integerCompare:left:right:!helper methods!public! !
!PstPrimitiveSet categoriesFor: #integerDivide:with:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #integerEqual:to:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #integerGCD:with:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #integerGreater:than:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #integerGreaterOrEqual:than:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #integerLess:than:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #integerLessOrEqual:than:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #integerMultiply:with:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #integerNotEqual:to:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #integerOp:left:right:!helper methods!public! !
!PstPrimitiveSet categoriesFor: #integerPrintString:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #integerQuo:with:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #integerRem:with:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #integerSubtract:with:!number primitives!public! !
!PstPrimitiveSet categoriesFor: #interpreter:!initialization!public! !
!PstPrimitiveSet categoriesFor: #is:kindOf:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #performPrimitive:!execution!public! !
!PstPrimitiveSet categoriesFor: #runningOnDevice:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #shallowCopy:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #stringHash:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #stringWriteStream:nextPut:!collection primitives!public! !
!PstPrimitiveSet categoriesFor: #stringWriteStream:nextPutAll:!collection primitives!public! !
!PstPrimitiveSet categoriesFor: #testCharacter:bit:!basic primitives!public! !
!PstPrimitiveSet categoriesFor: #transcript:nextPutAll:!public!transcript! !



PstQuasiMethod comment: ''!

PstQuasiMethod guid: (GUID fromString: '{966462FE-8E4C-4B5D-A437-36953A80DF52}')!

!PstQuasiMethod categoriesForClass!No category! !
!PstQuasiMethod methodsFor!

actualMethod
	^actualMethod.!

actualMethod: object
	actualMethod := object.!

displayOn: stream
	stream nextPutAll: actualMethod selector.!

displayString
	^actualMethod selector.!

isMethod
	^false.!

isQuasi
	^true.!

selector

	^self actualMethod selector!

sourceCode
	^actualMethod sourceCode.! !
!PstQuasiMethod categoriesFor: #actualMethod!accessing!public! !
!PstQuasiMethod categoriesFor: #actualMethod:!accessing!public! !
!PstQuasiMethod categoriesFor: #displayOn:!printing!public! !
!PstQuasiMethod categoriesFor: #displayString!printing!public! !
!PstQuasiMethod categoriesFor: #isMethod!predicates!public! !
!PstQuasiMethod categoriesFor: #isQuasi!predicates!public! !
!PstQuasiMethod categoriesFor: #selector!accessing!public! !
!PstQuasiMethod categoriesFor: #sourceCode!accessing!public! !

!PstQuasiMethod class methodsFor!

for: method
	^self new actualMethod: method.! !
!PstQuasiMethod class categoriesFor: #for:!instance creation!public! !



PstResource comment: ''!

PstResource guid: (GUID fromString: '{0A5A5FA6-278D-478B-9F54-28D4F7F42391}')!

!PstResource categoriesForClass!No category! !
!PstResource methodsFor!

contents
	^contents.!

contents: object
	contents := object.!

displayOn: stream
	stream
		print: self name asString;
		nextPutAll: ', id ';
		print: self id;
		nextPutAll: ', size ';
		print: contents size.!

hexDump
	^PstResourceDatabase hexifyBytes: self contents.!

id
	^id.!

id: object
	id := object.!

name
	^name.!

name: object
	name := object asByteArray.!

offset
	^offset.!

offset: object
	offset := object.!

printOn: stream
	super printOn: stream.
	stream
		nextPutAll: ' (';
		print: self name asString;
		nextPutAll: ', id ';
		print: self id;
		nextPutAll: ', size ';
		print: contents size;
		nextPut: $).! !
!PstResource categoriesFor: #contents!accessing!public! !
!PstResource categoriesFor: #contents:!accessing!public! !
!PstResource categoriesFor: #displayOn:!printing!public! !
!PstResource categoriesFor: #hexDump!printing!public! !
!PstResource categoriesFor: #id!accessing!public! !
!PstResource categoriesFor: #id:!accessing!public! !
!PstResource categoriesFor: #name!accessing!public! !
!PstResource categoriesFor: #name:!accessing!public! !
!PstResource categoriesFor: #offset!accessing!public! !
!PstResource categoriesFor: #offset:!accessing!public! !
!PstResource categoriesFor: #printOn:!printing!public! !

!PstResource class methodsFor!

decodeResourceID: string
	"string is a hex string like '0d7a'."
	^string
		inject: 0
		into: [:value :char |
			(value * 16) + ('0123456789abcdef' 
				indexOf: char asLowercase) - 1].!

fromFile: filename
	"Answers nil if the name/ID of the resource could not be determined from the filename."
	| stem resourceName resourceID |

	stem := File splitStemFrom: filename.
	stem size = 8 ifFalse: [^nil].
	((stem copyFrom: 5 to: 8) asUppercase
			allSatisfy: [:character | character isHexDigit])
		ifFalse: [^nil].
	resourceName := stem copyFrom: 1 to: 4.
	resourceID := self 
		decodeResourceID: (stem copyFrom: 5 to: 8).
	^self
		fromFile: filename
		name: resourceName
		id: resourceID.!

fromFile: filename
name: nameString
id: id
	| stream bytes |
	stream := FileStream read: filename text: false.
	bytes := stream contents.
	stream close.
	^self new
		name: nameString;
		id: id;
		contents: bytes.!

name: nameString
id: id
contents: contents
	^self new
		name: nameString;
		id: id;
		contents: contents.! !
!PstResource class categoriesFor: #decodeResourceID:!public!utility! !
!PstResource class categoriesFor: #fromFile:!instance creation!public! !
!PstResource class categoriesFor: #fromFile:name:id:!instance creation!public! !
!PstResource class categoriesFor: #name:id:contents:!instance creation!public! !



PstResourceDatabase comment: ''!

PstResourceDatabase guid: (GUID fromString: '{D47A09BC-7A09-493C-8599-37E51F363C4F}')!

!PstResourceDatabase categoriesForClass!No category! !
!PstResourceDatabase methodsFor!

addResource: resource
	^resources add: resource.!

creatorID
	^creatorID.!

creatorID: object
	creatorID := object.!

databaseType
	^databaseType.!

databaseType: object
	databaseType := object.!

defaultFilename
	^defaultFilename.!

defaultFilename: string
	defaultFilename := string.!

displayOn: stream
	defaultFilename isNil
		ifTrue: [
			stream
				print: title;
				nextPutAll: ': ID ';
				nextPutAll: creatorID]
		ifFalse: [stream nextPutAll: defaultFilename].
	stream 
		nextPutAll: ', ';
		print: resources size;
		nextPutAll: ' resource'.
	resources size = 1
		ifFalse: [stream nextPut: $s].!

initialize
	super initialize.
	resources := OrderedCollection new.
	creatorID := self class defaultCreatorID.
	databaseType := self class defaultDatabaseType.
	title := self class defaultTitle.!

nextLongwordFrom: stream
	| value |
	value := (self nextWordFrom: stream) bitShift: 16.
	^value bitOr: (self nextWordFrom: stream).!

nextWordFrom: stream
	| value |
	value := stream next bitShift: 8.
	^value + stream next.!

readBodyFrom: stream
	| resource offset |
	resources := OrderedCollection new.
	(self readWordFrom: stream) timesRepeat: [
		resource := PstResource new.
		resource 
			name: (stream next: 4) asString;
			id: (self readWordFrom: stream).
		offset := self readLongwordFrom: stream].!

readFrom: stream
	"Some Smalltalks have buggy FileStream>>#size, so...."
	| blah |
	blah := stream contents readStream.
	self readHeaderFrom: blah.
	self readResourceHeadersFrom: blah.
	self readResourceContentsFrom: blah.!

readHeaderFrom: stream
	title := ((stream next: 32) readStream upTo: 0) asString.
	"skipping:
		flags - 2 bytes
		version - 2 bytes
		creationTime - 4 bytes
		modificationTime - 4 bytes
		backupTime - 4 bytes
		modificationNumber - 4 bytes
		applicationInfo - 4 bytes
		sortInfo - 4 bytes"
	stream skip: 28.
	databaseType := (stream next: 4) asString.
	creatorID := (stream next: 4) asString.
	"skip:
		uniqueIdSeed - 4 bytes
		nextRecordList - 4 bytes"
	stream skip: 8.!

readResourceContentsFrom: stream
	| sorted each end |
	sorted := self resources asSortedCollection: 
		[:a :b | a offset <= b offset].
	1 to: sorted size do: [:i |
		each := sorted at: i.
		end := i = sorted size
			ifTrue: [stream size]
			ifFalse: [(sorted at: i + 1) offset].
		each contents: (stream collection copyFrom: each offset + 1 to: end) asByteArray]
	"| sorted each end |
	sorted := self resources asSortedCollection: 
		[:a :b | a offset <= b offset].
	1 to: sorted size do: [:i |
		each := sorted at: i.
		end := i == sorted size
			ifTrue: [stream size]
			ifFalse: [(sorted at: i + 1) offset].
		each contents: (stream next: end - each offset)]."!

readResourceHeadersFrom: stream
	| resource resourceName resourceID resourceCount |
	resources := OrderedCollection new.
	resourceCount := self nextWordFrom: stream.
	resourceCount timesRepeat: [
		resource := PstResource new.
		resourceName := (stream next: 4) asString.
		resourceID := self nextWordFrom: stream.
		resource 
			name: resourceName;
			id: resourceID;
			offset: (self nextLongwordFrom: stream).
		resources add: resource].!

reread
	| stream |
	self assert: [defaultFilename notNil].
	stream := FileStream read: defaultFilename text: false.
	resources := OrderedCollection new.
	[self readFrom: stream] ensure: [stream close].!

resources
	^resources.!

save
	self assert: [defaultFilename notNil].
	self writeToFileNamed: defaultFilename.!

title
	^title.!

title: object
	title := object.!

totalHeaderSize
	^78 + (resources size * 10).!

writeCurrentTimestampOn: stream
	| seconds adjustment |
	"adjustment := (Date newDay: 1 month: 'January' year: 1904) asSeconds."
	adjustment := 94608000.
	seconds := TimeStamp current asSeconds - adjustment.
	PstSystem current
		storeLongword: seconds
		on: stream.			!

writeDatabaseNameOn: stream
	stream 
		nextPutAll: self title asByteArray;
		next: 32 - self title size put: 0.!

writeDotROnFileNamed: filename
	"	filename	<String>
	"
	| stream |
	stream := FileStream write: filename text: true.
	resources do: [:resource |
		"(#('code' 'data') includes: resource name asString) ifFalse: ["
		resource offset isNil ifTrue: [
				"The resource was read in from an existing .prc file, only out the ones that
					are newly added by me."
			self
				writeResource: resource
				dotROn: stream]].
	stream close.!

writeHeaderOn: stream
	| qsc |
	qsc := PstSystem current.

	self writeDatabaseNameOn: stream.
	"Flags field."
	qsc storeWord: 1 on: stream.
	"Version field."
	qsc storeWord: 1 on: stream.
	"Creation time"
	self writeCurrentTimestampOn: stream.
	"Modification time"
	self writeCurrentTimestampOn: stream.
	"Backup time, modification number, application info and sort info."
	4 timesRepeat: [qsc storeLongword: 0 on: stream].
	"Database type."
	stream nextPutAll: databaseType asByteArray.
	"Creator ID ('PkST')."
	stream nextPutAll: creatorID asByteArray.
	"Unique ID seed"
	qsc storeLongword: 17 on: stream.
	"Next record list"
	qsc storeLongword: 0 on: stream.
	"Number of records"
	qsc storeWord: resources size on: stream.!

writeOn: stream
	| headerStream bodyStream offset |
	headerStream := ByteArray new writeStream.
	self writeHeaderOn: headerStream.
	bodyStream := ByteArray new writeStream.
	resources do: [:resource |
		"The '+ 2' here is --apparently-- part of the PRC file structure, though I can't find any reason for it!!"
		self
			writeResourceHeaderFor: resource
			offset: self totalHeaderSize + bodyStream position + 2
			on: headerStream.
		self
			writeResource: resource
			on: bodyStream].
	stream
		nextPutAll: headerStream contents;
		nextPutAll: #[0 0];  "Not sure why this is needed!!"
		nextPutAll: bodyStream contents.
	self assert: [headerStream position = self totalHeaderSize].!

writeResource: resource
dotROn: stream

	| read bytes |
	stream nextPutAll: 'data ';
		nextPutAll: resource name asString printString;
		nextPutAll: ' ('.
	resource id printOn: stream.
	stream nextPutAll: ') {'.
	read := ReadStream on: resource contents.
	bytes := ByteArray new: 1.
	[read atEnd] whileFalse: [
		stream cr; tab; nextPutAll: '$"'.
		16 timesRepeat: [read atEnd ifFalse: [
			stream nextPutAll: (self class hexifyBytes: (bytes at: 1 put: read next; yourself));
				space]].
		stream nextPutAll: '"'].
	stream cr; nextPutAll: '};';
		cr; cr!

writeResource: resource
on: stream
	stream nextPutAll: resource contents.!

writeResourceHeaderFor: resource
offset: offset
on: headerStream
	self assert: [resource name size = 4].
	headerStream nextPutAll: resource name.
	PstSystem current storeWord: resource id on: headerStream.
	PstSystem current storeLongword: offset on: headerStream.!

writeToFileNamed: filename
	| stream |
	stream := FileStream write: filename text: false.
	[self writeOn: stream]
		ensure: [stream close].! !
!PstResourceDatabase categoriesFor: #addResource:!accessing!public! !
!PstResourceDatabase categoriesFor: #creatorID!accessing!public! !
!PstResourceDatabase categoriesFor: #creatorID:!accessing!public! !
!PstResourceDatabase categoriesFor: #databaseType!accessing!public! !
!PstResourceDatabase categoriesFor: #databaseType:!accessing!public! !
!PstResourceDatabase categoriesFor: #defaultFilename!accessing!public! !
!PstResourceDatabase categoriesFor: #defaultFilename:!accessing!public! !
!PstResourceDatabase categoriesFor: #displayOn:!printing!public! !
!PstResourceDatabase categoriesFor: #initialize!initialization!public! !
!PstResourceDatabase categoriesFor: #nextLongwordFrom:!public!reading! !
!PstResourceDatabase categoriesFor: #nextWordFrom:!public!reading! !
!PstResourceDatabase categoriesFor: #readBodyFrom:!public!reading! !
!PstResourceDatabase categoriesFor: #readFrom:!public!reading! !
!PstResourceDatabase categoriesFor: #readHeaderFrom:!public!reading! !
!PstResourceDatabase categoriesFor: #readResourceContentsFrom:!public!reading! !
!PstResourceDatabase categoriesFor: #readResourceHeadersFrom:!public!reading! !
!PstResourceDatabase categoriesFor: #reread!public!reading! !
!PstResourceDatabase categoriesFor: #resources!accessing!public! !
!PstResourceDatabase categoriesFor: #save!public!writing! !
!PstResourceDatabase categoriesFor: #title!accessing!public! !
!PstResourceDatabase categoriesFor: #title:!accessing!public! !
!PstResourceDatabase categoriesFor: #totalHeaderSize!accessing!public! !
!PstResourceDatabase categoriesFor: #writeCurrentTimestampOn:!public!writing! !
!PstResourceDatabase categoriesFor: #writeDatabaseNameOn:!public!writing! !
!PstResourceDatabase categoriesFor: #writeDotROnFileNamed:!public!writing! !
!PstResourceDatabase categoriesFor: #writeHeaderOn:!public!writing! !
!PstResourceDatabase categoriesFor: #writeOn:!public!writing! !
!PstResourceDatabase categoriesFor: #writeResource:dotROn:!public!writing! !
!PstResourceDatabase categoriesFor: #writeResource:on:!public!writing! !
!PstResourceDatabase categoriesFor: #writeResourceHeaderFor:offset:on:!public!writing! !
!PstResourceDatabase categoriesFor: #writeToFileNamed:!public!writing! !

!PstResourceDatabase class methodsFor!

defaultCreatorID
	^'PkST'.!

defaultDatabaseType
	^'appl'.!

defaultTitle
	^'PocketST'.!

fromFile: filename
	| file database |

	(File splitExtensionFrom: filename) = 'bin'
		ifTrue: [^self fromResourceFiles: filename].
	file := FileStream read: filename text: false.
	[database := self new readFrom: file]
		ensure: [file close].
	database defaultFilename: filename.
	^database.!

fromResourceFiles: filename
	"filename has extension .bin - read in any matching filenames and create a resource database for them."
	| filenames resources base |

	base := File splitPathFrom: filename.
	filenames := (File find: filename) collect: [:s | base, s fileName].
	resources := (filenames 
		collect: [:resourceFile | PstResource fromFile: resourceFile])
			reject: [:each | each isNil].
	^self fromResources: resources.!

fromResources: resources
	| database |
	database := self new.
	resources do: [:each | database addResource: each].
	^database.	!

fromUser
	| filename dialog |
	dialog := FileOpenDialog new.
	dialog
		fileTypes: #(('Resource Databases (*.prc)' '*.prc')
			('All Files (*.*)' '*.*'));
		caption: 'Select a .PRC file'.
	filename := dialog showModal.
	filename isNil ifTrue: [^nil].
	(File exists: filename) ifFalse: [
		MessageBox notify: 'That file does not exist.'.
		^nil].
	^self fromFile: filename.!

hexifyByte: byte
	^self hexifyBytes: (ByteArray with: byte).!

hexifyBytes: bytes
	| stream hexits |
	hexits := '0123456789ABCDEF'.
	stream := String new writeStream.
	bytes do: [:each |
		stream
			nextPut: (hexits at: (each bitShift: -4) + 1);
			nextPut: (hexits at: (each bitAnd: 15) + 1)].
	^stream contents.! !
!PstResourceDatabase class categoriesFor: #defaultCreatorID!defaults!public! !
!PstResourceDatabase class categoriesFor: #defaultDatabaseType!defaults!public! !
!PstResourceDatabase class categoriesFor: #defaultTitle!defaults!public! !
!PstResourceDatabase class categoriesFor: #fromFile:!instance creation!public! !
!PstResourceDatabase class categoriesFor: #fromResourceFiles:!instance creation!public! !
!PstResourceDatabase class categoriesFor: #fromResources:!instance creation!public! !
!PstResourceDatabase class categoriesFor: #fromUser!instance creation!public! !
!PstResourceDatabase class categoriesFor: #hexifyByte:!public!utility! !
!PstResourceDatabase class categoriesFor: #hexifyBytes:!public!utility! !



PstStatistics comment: ''!

PstStatistics guid: (GUID fromString: '{9710E705-47F6-42AD-A27F-E42498388919}')!

!PstStatistics categoriesForClass!No category! !
!PstStatistics methodsFor!

classCount
	"Total number of classes (doesn't count metaclasses)."
	^self system classLibrary classCount.!

estimatedBytecodeSize
	| count |
	count := 0.
	self system classLibrary allBehaviorsDo: [:behavior |
		behavior methodsDo: [:method |
			method instructions do: [:each |
				count := count + each estimatedCompiledSize]]].
	^count.!

instructionStatistics
	| bag stream total sorted |
	bag := self instructionTypes.
	stream := String new writeStream.
	total := bag size.
	stream
		print: total;
		nextPutAll: ' instructions altogether.';
		cr; cr;
		nextPutAll: 'Count	%	Type';
		cr.
	sorted := SortedCollection
		sortBlock: [:left :right | left value >= right value]
		withAll: bag asAssociations.
	sorted do: [:association |
		stream
			print: association value;
			tab;
			nextPutAll: ((association value / total) 
					* 100.0 printString: 2);
			tab;
			nextPutAll: association key;
			cr].
	^stream contents.!

instructionTypes
	| bag |
	bag := Bag new.  "IdentityBag?"
	self system classLibrary allBehaviorsDo: [:behavior |
		behavior methodsDo: [:method |
			method instructions do: [:each |
				bag add: each instructionCategory]]].
	^bag.!

methodCount
	"Total number of methods in the system."
	^self system methodCount.!

methodStatistics
	| stream classCount methodCount |
	stream := String new writeStream.
	classCount := self system classLibrary classCount.
	methodCount := self system classLibrary methodCount.
	stream
		print: classCount;
		nextPutAll: ' classes.'; cr;
		print: methodCount;
		nextPutAll: ' methods.'; cr;
		nextPutAll: ((methodCount / classCount) asFloat
						printString: 2);
		nextPutAll: ' methods per class on average.'; cr;
		nextPutAll: 'Estimated compiled bytecode count: ';
		print: self estimatedBytecodeSize;
		nextPut: $.; cr.
	^stream contents.!

system
	^PstSystem current.! !
!PstStatistics categoriesFor: #classCount!public!statistics! !
!PstStatistics categoriesFor: #estimatedBytecodeSize!public!statistics! !
!PstStatistics categoriesFor: #instructionStatistics!formatting!public! !
!PstStatistics categoriesFor: #instructionTypes!public!statistics! !
!PstStatistics categoriesFor: #methodCount!public!statistics! !
!PstStatistics categoriesFor: #methodStatistics!formatting!public! !
!PstStatistics categoriesFor: #system!accessing!public! !

!PstStatistics class methodsFor!

display: statisticsSelector caption: captionString
	| presenter |
	presenter := RichTextPresenter
		showOn: (self new perform: statisticsSelector).
	presenter view topShell caption: captionString.
	^presenter view topShell.! !
!PstStatistics class categoriesFor: #display:caption:!public!utility! !



PstSystem comment: ''!

PstSystem guid: (GUID fromString: '{2E753693-78D1-485A-9887-874685E39CFA}')!

!PstSystem categoriesForClass!No category! !
!PstSystem methodsFor!

booleanProperty: property ifAbsent: block
	| constant |
	(constantsLibrary hasConstantNamed: property)
		ifFalse: [^block value].
	constant := constantsLibrary constantNamed: property.
	constant value == PstBasicObject forTrue ifTrue: [^true].
	constant value == PstBasicObject forFalse ifTrue: [^false].
	^block value.!

chooseFont
	defaultFont := Font choose.!

classBrowserClass
	^self subclassResponsibility.!

classLibrary
	^classLibrary.!

classLibraryClass
	^self subclassResponsibility.!

codeGeneratorClass
	^self subclassResponsibility.!

constantsLibrary
	^constantsLibrary.!

constantsLibrary: newLibrary
	constantsLibrary := newLibrary.!

defaultFont
	^defaultFont.!

globals
	"For the bytecode interpreter only..."
	^globals.!

initialize
	| locator fileSpec pb |
	super initialize.
	self reset.
!

integerProperty: property ifAbsent: block
	| constant |
	(constantsLibrary hasConstantNamed: property)
		ifFalse: [^block value].
	constant := constantsLibrary constantNamed: property.
	^constant value isIntegerObject
		ifTrue: [constant value value]
		ifFalse: [block value].!

lastArgumentFor: symbolString put: string
	| symbol text |

	symbol := (symbolString copyFrom: 2 to: symbolString size) asSymbol.
	text := string copyFrom: 2 to: string size - 1.
	PstSystem lastArgumentFor: symbol put: text.!

loadOldProject: filename
	| stream filer data dataStream package dontSave |
	projectFilename := filename.
	stream := FileStream read: filename text: false.
	filer := STBInFiler on: stream.
	data := filer next.
	stream close.
	PstSystem resetAs: PstSystem current class.
	dataStream := data readStream.
	[dataStream atEnd] whileFalse: [
		package := PstPackageLibrary current
			installPackageNamed: dataStream next.
		dontSave := dataStream next.
		package isNil ifFalse: [package dontSave: dontSave]].
	PstSystem current projectFilename: filename.!

loadProject: filename
	| stream manager |
	projectFilename := filename.
	stream := FileStream read: filename text: true.
	manager := PstFileOutManager on: stream.
	PstSystem resetAs: self class.
	[self loadProjectFrom: manager] ensure: [stream close].
	"the next statement cannot be written as projectFilename := ... due to the resetAs: in loadProjectFrom:"
	PstSystem current projectFilename: filename.
!

loadProjectFrom: manager
	| projectDir chunk tokens op |

	projectDir := File splitPathFrom: self projectFilename.

	[(chunk := manager nextChunk) notNil] whileTrue: [
		(chunk isEmpty or: [chunk first == $"]) ifFalse: [
			tokens := chunk subStrings.
			op := tokens at: 2.
			op = 'addPackage:' ifTrue: [
				self loadProjectPackage: (tokens at: 3) relativeTo: projectDir dontSave: (tokens at: 5) = 'true'].
			op = 'defaultPackage:' ifTrue: [
				self setDefaultPackage: (tokens at: 3) relativeTo: projectDir].
			op = 'lastArgumentFor:' ifTrue: [
				self lastArgumentFor: (tokens at: 3) put: (tokens at: 5)].
			op = 'resetAs:' ifTrue: [
				PstSystem resetAs: (Smalltalk at: (tokens at: 3))].
		]
	].

"
	| stream filer data dataStream package dontSave |
	projectFilename := filename.
	stream := FileStream read: filename text: false.
	filer := STBInFiler on: stream.
	data := filer next.
	stream close.
	PstSystem resetAs: PstSystem current class.
	dataStream := data readStream.
	[dataStream atEnd] whileFalse: [
		package := PstPackageLibrary current
			installPackageNamed: dataStream next.
		dontSave := dataStream next.
		package isNil ifFalse: [package dontSave: dontSave]].
	projectFilename := filename.
"!

loadProjectPackage: packageName relativeTo: projectDir dontSave: dontSave
	| packagePath package |

	packagePath := File fullPathOf: (packageName copyFrom: 2 to: (packageName size - 1)) relativeTo: projectDir.
	package := PstPackageLibrary current
			installPackageNamed: packagePath.
	package isNil ifFalse: [package dontSave: dontSave]!

packageLibrary
	^packageLibrary.!

projectFilename
	^projectFilename.!

projectFilename: filename
	projectFilename := filename.!

properties
	^properties.!

properties: object
	properties := object.!

propertyAt: property
	^properties at: property.!

propertyAt: property put: value
	^properties at: property put: value.!

qcompilerClass
	^self subclassResponsibility.!

reset
	classLibrary := self classLibraryClass new.
	packageLibrary := PstPackageLibrary new.
	properties := IdentityDictionary new.
	self propertyAt: #title put: 'Unnamed'.
	self propertyAt: #byline put: 'Anonymous'.
	self propertyAt: #debug put: true.
	globals := PstGlobalVariables new.
	self trapClass initialize.
	self apiClass initialize.
	classLibrary bootstrap.
	PstChangeLog reset.
	constantsLibrary := PstConstantsLibrary new.
	constantsLibrary bootstrap.	

	"PstFont createFontBitmap."!

saveOldProjectOn: stream
	| data filer |
	data := OrderedCollection new.
	(packageLibrary packages reject: [:each | each isUncommitted]) 
		do: [:each |
			data
				add: each filename;
				add: each dontSave].
	filer := STBOutFiler on: stream.
	filer nextPut: data.
!

saveProjectAs: filename
	| stream |
	projectFilename := filename.
	((File splitExtensionFrom: filename) = 'pst')
		ifTrue: [
			stream := FileStream write: filename text: true.
			[self saveProjectOn: stream]
				ensure: [stream close]]
		ifFalse:  [
			stream := FileStream write: filename text: false.
			[self saveOldProjectOn: stream]
				ensure: [stream close]].
	(PstPackageLibrary current packages 
		reject: [:each | each dontSave])
			do: [:each | each save].!

saveProjectOn: stream
	| manager projectDir |

	projectDir := File splitPathFrom: self projectFilename.
	manager := PstFileOutManager on: stream.

	manager fileOutHeader.

	manager
		nextPutAll: 'PstSystem resetAs: ', PstSystem current class name;
		endChunk.

	(packageLibrary packages reject: [:each | each isUncommitted])
		do: [:each |
			manager
				nextPutAll: 'PstSystem addPackage: ''', (File relativePathOf: each filename to: projectDir), ''' dontSave: ', each dontSave printString;
				endChunk
		].

	packageLibrary defaultPackage isUncommitted ifFalse: [
		manager
			nextPutAll: 'PstSystem defaultPackage: ''', (File relativePathOf: packageLibrary defaultPackage filename to: projectDir);
			nextPut: $';
			endChunk
	].

	defaultFont isNil ifFalse: [
		manager
			nextPutAll: 'PstSystem defaultFont: ''', defaultFont name, ''' pointSize: ', defaultFont pointSize printString;
			endChunk
	]. 

	LastArguments keysAndValuesDo: [:key :value|
		manager
			nextPutAll: 'PstSystem lastArgumentFor: ', key printString, ' put: ', value printString;
			endChunk
	].
		
"
	| data filer |
	data := OrderedCollection new.
	(packageLibrary packages reject: [:each | each isUncommitted]) 
		do: [:each |
			data
				add: each filename;
				add: each dontSave].
	filer := STBOutFiler on: stream.
	filer nextPut: data.
"!

setDefaultFont: fontName size: size
	| font |

	font := fontName copyFrom: 2 to: (fontName size - 1).
	defaultFont := Font name: font size: size.!

setDefaultPackage: packageName relativeTo: projectDir
	| packagePath package |

	packagePath := File fullPathOf: (packageName copyFrom: 2 to: (packageName size - 1)) relativeTo: projectDir.
	(PstPackageLibrary current hasPackageNamed: packagePath) ifTrue: [
		package := PstPackageLibrary current packageNamed: packagePath.
		PstPackageLibrary current defaultPackage: package.
	].!

trapClass
	^self subclassResponsibility
! !
!PstSystem categoriesFor: #booleanProperty:ifAbsent:!properties!public! !
!PstSystem categoriesFor: #chooseFont!public!user interface! !
!PstSystem categoriesFor: #classBrowserClass!*-subclass responsibility!parameters!public! !
!PstSystem categoriesFor: #classLibrary!accessing!public! !
!PstSystem categoriesFor: #classLibraryClass!*-subclass responsibility!parameters!public! !
!PstSystem categoriesFor: #codeGeneratorClass!*-subclass responsibility!parameters!public! !
!PstSystem categoriesFor: #constantsLibrary!accessing!public! !
!PstSystem categoriesFor: #constantsLibrary:!accessing!public! !
!PstSystem categoriesFor: #defaultFont!public!user interface! !
!PstSystem categoriesFor: #globals!accessing!public! !
!PstSystem categoriesFor: #initialize!initialization!public! !
!PstSystem categoriesFor: #integerProperty:ifAbsent:!properties!public! !
!PstSystem categoriesFor: #lastArgumentFor:put:!project management!public! !
!PstSystem categoriesFor: #loadOldProject:!project management!public! !
!PstSystem categoriesFor: #loadProject:!project management!public! !
!PstSystem categoriesFor: #loadProjectFrom:!project management!public! !
!PstSystem categoriesFor: #loadProjectPackage:relativeTo:dontSave:!project management!public! !
!PstSystem categoriesFor: #packageLibrary!accessing!public! !
!PstSystem categoriesFor: #projectFilename!project management!public! !
!PstSystem categoriesFor: #projectFilename:!project management!public! !
!PstSystem categoriesFor: #properties!accessing!public! !
!PstSystem categoriesFor: #properties:!accessing!public! !
!PstSystem categoriesFor: #propertyAt:!accessing!public! !
!PstSystem categoriesFor: #propertyAt:put:!accessing!public! !
!PstSystem categoriesFor: #qcompilerClass!*-subclass responsibility!parameters!public! !
!PstSystem categoriesFor: #reset!initialization!public! !
!PstSystem categoriesFor: #saveOldProjectOn:!project management!public! !
!PstSystem categoriesFor: #saveProjectAs:!project management!public! !
!PstSystem categoriesFor: #saveProjectOn:!project management!public! !
!PstSystem categoriesFor: #setDefaultFont:size:!project management!public! !
!PstSystem categoriesFor: #setDefaultPackage:relativeTo:!project management!public! !
!PstSystem categoriesFor: #trapClass!*-subclass responsibility!accessing!public! !

!PstSystem class methodsFor!

classLibraryClass
	^self subclassResponsibility.!

closeAllWindows
	"Close everything except the launcher."
	(Smalltalk at: #PstShell) allSubinstances do: [:each |
		each class name == #PstLauncher
			ifFalse: [each exit]].!

current
	^CurrentSystem.!

current: newSystem
	CurrentSystem := newSystem.!

defaultDynamicSize
	"Answer the number of words to allocate as a dynamic pool."
	^500.!

lastArgumentFor: topic
	^LastArguments
		at: topic
		ifAbsent: [String new].!

lastArgumentFor: topic put: string
	LastArguments at: topic put: string.!

resetAs: systemClass
	self closeAllWindows.
	CurrentSystem := systemClass basicNew.
	CurrentSystem initialize.
	LastArguments := Dictionary new.!

type
	"Answer a token to identify the kind of system class this is."
	^self subclassResponsibility.! !
!PstSystem class categoriesFor: #classLibraryClass!*-subclass responsibility!accessing!public! !
!PstSystem class categoriesFor: #closeAllWindows!public!utility! !
!PstSystem class categoriesFor: #current!accessing!public! !
!PstSystem class categoriesFor: #current:!accessing!public! !
!PstSystem class categoriesFor: #defaultDynamicSize!defaults!public! !
!PstSystem class categoriesFor: #lastArgumentFor:!last arguments!public! !
!PstSystem class categoriesFor: #lastArgumentFor:put:!last arguments!public! !
!PstSystem class categoriesFor: #resetAs:!public!utility! !
!PstSystem class categoriesFor: #type!*-subclass responsibility!accessing!public! !



PstSystemProperties comment: ''!

PstSystemProperties guid: (GUID fromString: '{A7CC05BD-3E88-42F5-BDCD-D8B0DB507C5C}')!

!PstSystemProperties categoriesForClass!No category! !
!PstSystemProperties methodsFor!

asResource
	| stream system |
	system := PstSystem current.
	stream := ByteArray new writeStream.
	system
		storeWord: globalCount on: stream;
		storeWord: self objectTableSize on: stream;
		storeWord: self heapSize on: stream;
		storeWord: self dataStackSize on: stream;
		storeWord: self callStackSize on: stream.
	^PstResource
		name: 'SysP'
		id: 1
		contents: stream contents.!

callStackSize
	^self
		constrain: (PstSystem current
			integerProperty: 'callStackSize'
			ifAbsent: [100])
		min: 20
		max: 3000.!

constrain: value min: min max: max
	^(value max: min) min: max.!

dataStackSize
	^self
		constrain: (PstSystem current
			integerProperty: 'dataStackSize'
			ifAbsent: [300])
		min: 20
		max: 10000.!

globalCount
	^globalCount.!

globalCount: object
	globalCount := object.!

heapSize
	^self
		constrain: (PstSystem current
			integerProperty: 'heapSize'
			ifAbsent: [5000])
		min: 100
		max: 32000.!

objectTableSize
	^self
		constrain: (PstSystem current
			integerProperty: 'objectTableSize'
			ifAbsent: [1000])
		min: 100
		max: 16380.! !
!PstSystemProperties categoriesFor: #asResource!converting!public! !
!PstSystemProperties categoriesFor: #callStackSize!accessing!public! !
!PstSystemProperties categoriesFor: #constrain:min:max:!converting!public! !
!PstSystemProperties categoriesFor: #dataStackSize!accessing!public! !
!PstSystemProperties categoriesFor: #globalCount!accessing!public! !
!PstSystemProperties categoriesFor: #globalCount:!accessing!public! !
!PstSystemProperties categoriesFor: #heapSize!accessing!public! !
!PstSystemProperties categoriesFor: #objectTableSize!accessing!public! !



PstVariableReference comment: ''!

PstVariableReference guid: (GUID fromString: '{57C326AD-5E41-44A0-9269-205E54F25E44}')!

!PstVariableReference categoriesForClass!No category! !
!PstVariableReference methodsFor!

distance
	^distance.!

distance: object
	distance := object.!

index
	"Answer the value of the receiver's instance variable index.
	This method was automatically generated, but may be modified."

	^index!

index: anObject
	"Set the value of the receiver's instance variable index to anObject.
	This method was automatically generated, but may be modified."

	index := anObject!

isArgument
	^type == #argument.!

isAssignable
	^#(temporary shared instance) includes: type.!

isClass
	"Reference to a class, not a class variable."
	^type == #class.!

isInstVar
	^type == #instance.!

isLocal
	^type == #argument or: [type == #temporary].!

isShared
	^type == #shared.!

isTemporary
	^type == #temporary.!

name
	"Answer the value of the receiver's instance variable name.
	This method was automatically generated, but may be modified."

	^name!

name: anObject
	"Set the value of the receiver's instance variable name to anObject.
	This method was automatically generated, but may be modified."

	name := anObject!

type
	"Answer the value of the receiver's instance variable type.
	This method was automatically generated, but may be modified."

	^type!

type: anObject
	"Set the value of the receiver's instance variable type to anObject.
	This method was automatically generated, but may be modified."

	type := anObject! !
!PstVariableReference categoriesFor: #distance!accessing!public! !
!PstVariableReference categoriesFor: #distance:!accessing!public! !
!PstVariableReference categoriesFor: #index!accessing!public! !
!PstVariableReference categoriesFor: #index:!accessing!public! !
!PstVariableReference categoriesFor: #isArgument!predicates!public! !
!PstVariableReference categoriesFor: #isAssignable!predicates!public! !
!PstVariableReference categoriesFor: #isClass!predicates!public! !
!PstVariableReference categoriesFor: #isInstVar!predicates!public! !
!PstVariableReference categoriesFor: #isLocal!predicates!public! !
!PstVariableReference categoriesFor: #isShared!predicates!public! !
!PstVariableReference categoriesFor: #isTemporary!predicates!public! !
!PstVariableReference categoriesFor: #name!accessing!public! !
!PstVariableReference categoriesFor: #name:!accessing!public! !
!PstVariableReference categoriesFor: #type!accessing!public! !
!PstVariableReference categoriesFor: #type:!accessing!public! !

!PstVariableReference class methodsFor!

type: typeSymbol
name: variableName 
index: variableIndex
distance: scopeDistance
	^self new
		type: typeSymbol;
		name: variableName;
		index: variableIndex;
		distance: scopeDistance.! !
!PstVariableReference class categoriesFor: #type:name:index:distance:!instance creation!public! !



PstSmalltalkClassLibrary comment: ''!

PstSmalltalkClassLibrary guid: (GUID fromString: '{B5C59099-4ADD-48AA-B362-1BC9E4FEED8E}')!

!PstSmalltalkClassLibrary categoriesForClass!No category! !
!PstSmalltalkClassLibrary methodsFor!

allBehaviorsDo: block
	indexByName do: [:class |
		block value: class.
		block value: class qclass].!

arrayClass
	^arrayClass.!

blockClosureClass
	^blockClosureClass.!

bootstrap
	| defaultPackage |
	defaultPackage := PstPackage default.
	PstPackageLibrary current defaultPackage: nil.  "dodgy"
	self 
		bootstrapMetaclasses;
		bootstrapObject;
		bootstrapBehaviors;
		bootstrapBasicClasses;
		bootstrapCollections;
		markBasicClasses;
		cacheVMClasses;
		restrictUninstantiableClasses.
	PstCharacter createCharacters.
	PstCharacter buildAttributeTable.
	PstBasicObject createTrueFalseNil.
	PstPackageLibrary current defaultPackage: defaultPackage.!

bootstrapBasicClasses
	self objectClass
		subclass: 'UndefinedObject'
		instanceVariableNames: ''
		classVariableNames: ''.
	self objectClass
		variableByteSubclass: 'CPointer'
		instanceVariableNames: ''
		classVariableNames: ''.
	self objectClass
		subclass: 'Boolean'
		instanceVariableNames: ''
		classVariableNames: ''.
	(self classNamed: 'Boolean') subclass: 'True'
		instanceVariableNames: ''
		classVariableNames: ''.
	(self classNamed: 'Boolean') subclass: 'False'
		instanceVariableNames: ''
		classVariableNames: ''.
	self objectClass
		subclass: 'BlockClosure'
		instanceVariableNames: 'ownerClass offset argumentCount'
		classVariableNames: ''.
	(self classNamed: 'BlockClosure')
		subclass: 'FullBlockClosure'
		instanceVariableNames: 'nextOuter nextLink'
		classVariableNames: ''.
	self objectClass
		subclass: 'Number'
		instanceVariableNames: ''
		classVariableNames: ''.
	(self classNamed: 'Number')
		subclass: 'Integer'
		instanceVariableNames: ''
		classVariableNames: ''.
	(self classNamed: 'Number')
		variableByteSubclass: 'Double'
		instanceVariableNames: ''
		classVariableNames: ''.
	(self classNamed: 'Integer')
		subclass: 'SmallInteger'
		instanceVariableNames: ''
		classVariableNames: ''.
	(self classNamed: 'Integer')
		variableByteSubclass: 'LongInteger'
		instanceVariableNames: ''
		classVariableNames: ''.
	self objectClass
		subclass: 'Message'
		instanceVariableNames: 'selector arguments'
		classVariableNames: ''.
	self objectClass
		subclass: 'Smalltalk'
		instanceVariableNames: ''
		classVariableNames: ''.
	self objectClass
		subclass: 'Character'
		instanceVariableNames: ''
		classVariableNames: ''.!

bootstrapBehaviors
	self objectClass
		subclass: 'Behavior'
		instanceVariableNames: 'superclass layout'
		classVariableNames: ''.
	(self classNamed: 'Behavior')
		subclass: 'Class'
		instanceVariableNames: ''
		classVariableNames: ''.
	self objectClass qclass superclass: (self classNamed: 'Class').
	(self classNamed: 'Metaclass')
		superclass: (self classNamed: 'Behavior').
	(self classNamed: 'Metaclass') qclass
		superclass: (self classNamed: 'Behavior') qclass.
	(self classNamed: 'Behavior')
		addSubclass: (self classNamed: 'Metaclass').!

bootstrapCollections
	self objectClass
		subclass: 'Collection'
		instanceVariableNames: ''
		classVariableNames: ''.
	(self classNamed: 'Collection')
		subclass: 'KeyedCollection'
		instanceVariableNames: ''
		classVariableNames: ''.
	(self classNamed: 'KeyedCollection')
		subclass: 'ArrayedCollection'
		instanceVariableNames: ''
		classVariableNames: ''.
	(self classNamed: 'ArrayedCollection')
		variableSubclass: 'Array'
		instanceVariableNames: ''
		classVariableNames: ''.
	(self classNamed: 'ArrayedCollection')
		variableByteSubclass: 'ByteArray'
		instanceVariableNames: ''
		classVariableNames: ''.
	(self classNamed: 'ArrayedCollection')
		variableByteSubclass: 'String'
		instanceVariableNames: ''
		classVariableNames: ''.
	(self classNamed: 'ArrayedCollection')
		variableSubclass: 'List'
		instanceVariableNames: 'first last'
		classVariableNames: ''.!

bootstrapMetaclasses
	| metaclass metaclassClass |
	metaclass := PstClass new.
	metaclass name: 'Metaclass'.
	metaclass instVarNames: #('uniqueInstance').
	metaclass layout: (PstBehavior
		layoutForNormalObject: 3
		indexable: false).
	self addClass: metaclass.
	metaclassClass := self makeMetaclassFor: metaclass.!

bootstrapObject
	| object |
	object := PstClass new.
	object 
		name: 'Object';
		instVarNames: #();
		layout: (PstBehavior
			layoutForNormalObject: 0
			indexable: false).
	self addClass: object.
	self makeMetaclassFor: object.
	self addRoot: object.!

cacheVMClasses
	"Cache some classes that need to be referred to quickly by the VM simulator."
	messageClass := self classNamed: 'Message'.
	arrayClass := self classNamed: 'Array'.
	blockClosureClass := self classNamed: 'BlockClosure'.
	fullBlockClosureClass := self classNamed: 'FullBlockClosure'.
	smallIntegerClass := self classNamed: 'SmallInteger'.!

checkIfCanGenerateCode: actionBlock
	"Are the bare minimum pieces in place to be able to generate code?"
	"For every reason why code could not be generated, evaluate actionBlock with a string message."
	((self classNamed: 'Smalltalk') qclass
		lookupMethod: 'basicStart') isNil
			ifTrue: [actionBlock value: 'there is no Smalltalk class>>#basicStart method.'].
	"Ensure #doesNotUnderstand: is implemented in all root classes."
	roots do: [:root |
		(root lookupMethod: 'doesNotUnderstand:') isNil
			ifTrue: [actionBlock value: '#doesNotUnderstand: is not implemented in ', root name, '.']].!

fullBlockClosureClass
	^fullBlockClosureClass.!

makeMetaclassFor: class
	"Make a metaclass for the newly created class."
	| metaclass |
	metaclass := PstMetaclass new
		qclass: (self classNamed: 'Metaclass').
	metaclass layout: (PstBehavior
		layoutForNormalObject: 2
		indexable: false).
	metaclass createFor: class.
	^metaclass.!

messageClass
	^messageClass.!

restrictUninstantiableClasses
	"Some classes will mess things up if they are instantiated directly, so mark those classes as such."
	#('SmallInteger' 'BlockClosure' 'FullBlockClosure' 'Smalltalk' 'Boolean' 'True' 
'False' 'Character' 'Behavior' 'Class' 'Metaclass' 'CPointer')
		do: [:name | (self classNamed: name) isInstantiable: false].!

smallIntegerClass
	^smallIntegerClass.! !
!PstSmalltalkClassLibrary categoriesFor: #allBehaviorsDo:!public!utility! !
!PstSmalltalkClassLibrary categoriesFor: #arrayClass!common classes!public! !
!PstSmalltalkClassLibrary categoriesFor: #blockClosureClass!common classes!public! !
!PstSmalltalkClassLibrary categoriesFor: #bootstrap!bootstrapping!public! !
!PstSmalltalkClassLibrary categoriesFor: #bootstrapBasicClasses!bootstrapping!public! !
!PstSmalltalkClassLibrary categoriesFor: #bootstrapBehaviors!bootstrapping!public! !
!PstSmalltalkClassLibrary categoriesFor: #bootstrapCollections!bootstrapping!public! !
!PstSmalltalkClassLibrary categoriesFor: #bootstrapMetaclasses!bootstrapping!public! !
!PstSmalltalkClassLibrary categoriesFor: #bootstrapObject!bootstrapping!public! !
!PstSmalltalkClassLibrary categoriesFor: #cacheVMClasses!bootstrapping!public! !
!PstSmalltalkClassLibrary categoriesFor: #checkIfCanGenerateCode:!public!utility! !
!PstSmalltalkClassLibrary categoriesFor: #fullBlockClosureClass!common classes!public! !
!PstSmalltalkClassLibrary categoriesFor: #makeMetaclassFor:!class creation!public! !
!PstSmalltalkClassLibrary categoriesFor: #messageClass!common classes!public! !
!PstSmalltalkClassLibrary categoriesFor: #restrictUninstantiableClasses!bootstrapping!public! !
!PstSmalltalkClassLibrary categoriesFor: #smallIntegerClass!common classes!public! !



PstSmalltalkCodeGenerator comment: ''!

PstSmalltalkCodeGenerator guid: (GUID fromString: '{1617EC47-07B6-450D-B9D6-E87E20811331}')!

!PstSmalltalkCodeGenerator categoriesForClass!No category! !
!PstSmalltalkCodeGenerator methodsFor!

absoluteMaxCodeSegmentSize
	"	^	<Integer>
	Return the maximum size that a segment can be. Inclusive."

	^32767 "32K, or 32 * 1024 - 1"!

absoluteMaxDataSegmentSize
	"	^	<Integer>
	Return the maximum size that a segment can be. Inclusive."

	^65535 "64K, or 64 * 1024 - 1"!

align: stream
	"Make sure stream contains an even number of bytes."
	stream position odd ifTrue: [stream nextPut: 0].
	"stream next: stream position \\ 2 put: 0."!

beginObject: object
ofSize: objectSize
class: objectClass
	| value |
	"length of object, including header:"
	value := objectSize + 3 + (objectClass hasPointers
			ifTrue: [1 bitShift: 14]
			ifFalse: [0]) + (1 bitShift: 15).
	self storeWord: value.
	self compileObjectReference: objectClass.
	"3rd word in header is a reference to the object itself:"
	self compileObjectReference: object.!

classTableSegmentSize
	^5000.  "arbitrary, but keep fairly small to reduce fragmentation on pilot"!

compileClass: index on: stream
	^(compiledClassTable at: index ifAbsent: [^nil])
			writeBinaryOn: stream
			for: self.
	!

compileClasses
	| stream position |
	stream := ByteArray new writeStream.
	3 to: lastClassIndex do: [:index |
		position := stream position.
		self compileClass: index on: stream.
		stream position > self absoluteMaxDataSegmentSize ifTrue: [
			stream position: position.
			stream := self endClassSegment: stream.
			position := stream position.
			self compileClass: index on: stream.
			stream position > self absoluteMaxDataSegmentSize ifTrue: [
				"self error: (self objectAtIndex: index) printString, ' will not fit into a class data segment'"]].
		classOffsets add: stream position - position.
		stream position > self classTableSegmentSize ifTrue: [
			stream := self endClassSegment: stream]].
	self endClassSegment: stream.!

compileObjectBytes: byteArray
	"Compile the body of a byte indexed object."
	"First store 1 or 2 depending on whether the total number of bytes is odd or even."
	compiledObjectData nextPut:
		(byteArray size odd ifTrue: [1] ifFalse: [2]).
	compiledObjectData nextPutAll: byteArray.
	"Add a 'pad' byte if needed to make it a multiple of 2 bytes"
	byteArray size even ifTrue: [compiledObjectData nextPut: 0].!

compileObjectReference: object
	"Compile a reference to 'object' in compiled object space.  If the referenced object is not already assigned an object table slot, it is assigned one now."
	| index |
	object isNil ifTrue: [^self storeObjref: 0].
	(object isIntegerObject and: [object isSmallIntegerObject]) ifTrue: [
		^self storeInteger: object value].
	object isSymbolObject ifTrue: [
		^self storeInteger: (self indexOfSelector: object string)].
	index := self indexOfObject: object.
	index >= 16r7FF0 ifTrue: [
		self generationError: 'Too many objects'].
	self storeObjref: index.!

compileObjects
	objectList do: [:each | each compileFor: self].
	"Compile a special object for the single Character instance."
	PstBasicObject forCharacter compileFor: self.
	self endObjectSegment.!

deferCleanBlock: blockClosure
forSelector: selector
	"Defer resolution of the instance variables of a block closure until the time where method code is actually emitted."
	"Note that the block closure should currently have the _method_ relative offset, plus the home class.  Upon resolution, it will have the _class_ relative offset."
	compiledClass 
		deferCleanBlock: blockClosure
		forSelector: selector
		generator: self.!

endClassSegment: stream
	classSegments add: stream contents.
	^ByteArray new writeStream.!

endObject
	compiledObjectData position > 
			self objectTableSegmentSize 
		ifTrue: [self endObjectSegment].!

endObjectSegment
	objectSegments add: compiledObjectData contents.
	compiledObjectData := ByteArray new writeStream.!

generateBasicObjects
	"Reserve object slots for special objects: nil, true, and false (in that order)."
	self 
		indexOfObject: PstBasicObject forNil;
		indexOfObject: PstBasicObject forTrue;
		indexOfObject: PstBasicObject forFalse.!

generateCode
	"This is the top-level method."
	self registerSpecialSelectors.
	optimized ifTrue: [self performOptimizations].
	self generateBasicObjects.
	self registerVMClasses.
	self registerAllClasses.
	self generateCodeForClasses.
	self compileClasses.
	self compileObjects.
	self writeImageFile.!

generateCodeForClass: class
	"This creates a PstCompiledClass object and associates it with the class in compiledClassTable."
	compiledClass := PstCompiledClass new.
	class methodsDo: [:each |
		(keepMethodBlock value: each) ifTrue: [
			compiledClass
				addCode: (self generateCodeForMethod: each)
				forSelector: (self indexOfSelector: each selector)]].
	^compiledClassTable
		at: (self indexOfObject: class)
		put: compiledClass.!

generateCodeForClasses
	self system classLibrary classesDo: [:each |
		(keepBehaviorBlock value: each) ifTrue: [
			self generateCodeForClass: each.
			self generateCodeForClass: each qclass]].!

generateCodeForMethod: method
	| code |
	"(re)-generate the compiled instructions."
	method ungenerate.
	"Make two passes over the instructions to let forward-branch instructions compute the correct offsets."
	2 timesRepeat: [
		method instructions
			inject: 0
			into: [:startIndex :each |
				each hasGeneratedCode ifFalse: [
					each startIndex: startIndex.
					each generateCodeFor: self].
				startIndex + each codeSize]].
	code := method compiledBytes.
	method ungenerate.
	^code.!

indexOfObject: object
	| index |
	^(objectTable includesKey: object)
		ifTrue: [objectTable at: object]
		ifFalse: [
			objectList add: object.
			objectTable
				at: object
				put: objectSlotCounter.
			objectSlotCounter := objectSlotCounter + 1.
			index := objectSlotCounter - 1.
			"Add any objects referenced by this new object."
			object instVarsDo: [:each |
				(each isImmediate or: [each isSymbolObject])
					ifFalse: [self indexOfObject: each]].
			index].!

initialize
	super initialize.
	optimized := false.
	objectList := OrderedCollection new.
	objectSlotCounter := 0.
	objectSegments := OrderedCollection new.
	classSegments := OrderedCollection new.
	classNameData := ByteArray new writeStream.
	keepMethodBlock := [:method | true].
	keepBehaviorBlock := [:behavior | true].
	keepSelectorBlock := [:selector | true].!

objectAtIndex: index
	^objectList at: index - 2.!

objectTableSegmentSize
	"Answer the (approximate) number of bytes that should be put into a single static object segment."
	^10000.!

optimized: boolean
	optimized := boolean.!

performOptimizations
	| tracer keptMethods keptBehaviors keptSelectors |
	tracer := PstDeadCodeEliminator trace.
	keptMethods := tracer keptMethods.
	keptBehaviors := tracer keptBehaviors.
	keptSelectors := tracer keptSelectors.
	keepMethodBlock := [:method | keptMethods includes: method].
	keepBehaviorBlock := [:behavior | keptBehaviors includes: behavior].
	keepSelectorBlock := [:selector | keptSelectors includes: selector].
	self registerCommonSelectors.!

properties
	| properties |
	properties := PstSystemProperties new.
	properties globalCount: globalMap size.
	^properties.!

registerAllClasses
	"Register all the classes and their metaclasses, so that they get the low object numbers."
	self system classLibrary classesDo: [:each |
		(keepBehaviorBlock value: each) ifTrue: [
			self registerClass: each.
			self registerClass: each qclass]].
	lastClassIndex := objectSlotCounter - 1.!

registerClass: class
	| index |
	index := self indexOfObject: class.
	class isMeta ifFalse: [
		PstSystem current storeWord: index on: classNameData.
		classNameData
			nextPutAll: class displayString asByteArray;
			nextPut: 0].!

registerCommonSelectors
	(self system classLibrary 
			mostFrequentlySentSelectors: keepSelectorBlock)
		do: [:each | self indexOfSelector: each].!

registerSpecialSelectors
	self class specialSelectors
		do: [:each | self indexOfSelector: each].!

registerVMClasses
	"Register classes needed by the VM -- these must have fixed object table slots."
	"The first class in this list gets object slot #3."
	"Only classes go here, not their metaclasses."
	#('SmallInteger' 'BlockClosure' 'FullBlockClosure' 'Message' 
'Array' 'ByteArray' 'String' 'IdentityDictionary' 'Smalltalk' 'Character' 
'LongInteger' 'Double' 'CPointer')
		do: [:className |
			self registerClass: 
				(self system classLibrary classNamed: className)].!

segmentCount
	^classSegments size + objectSegments size + 
		(self debugging ifTrue: [3] ifFalse: [1]).!

storeInteger: integer
	self
		storeInteger: integer
		on: compiledObjectData.!

storeInteger: integer on: stream
	"Store a small integer (-16384 .. 16383)"
	| value |
	self assert: [integer between: -16384 and: 16383].
	value := integer negative
		ifTrue: [16r8000 + integer]
		ifFalse: [integer].
	PstSystem current
		storeWord: ((value bitShift: 1) bitOr: 1)
		on: stream.!

storeObjref: objref
	"Store an object reference in the compiled code area."
	self storeWord: (objref bitShift: 1).!

storeWord: value
	PstSystem current storeWord: value on: compiledObjectData.!

writeClassNameData
	self subclassResponsibility.!

writeClassOffsets
	self subclassResponsibility.!

writeClassSegments
	self subclassResponsibility.!

writeDebugData
	self writeSelectorData.
	self writeClassNameData.!

writeHeader
	self subclassResponsibility.!

writeImageFile
	self zorchEmptySegments.
	self writeHeader.
	self writeObjectSegments.
	self writeClassSegments.
	self writeClassOffsets.
	self writeProperties.
	self debugging ifTrue: [self writeDebugData].!

writeObjectSegments
	self subclassResponsibility.!

writeProperties
	self subclassResponsibility.!

writeSelectorData
	self subclassResponsibility.!

zorchEmptySegments
	classSegments := classSegments reject: [:each | each isEmpty].
	objectSegments := objectSegments reject: [:each | each isEmpty].
	selectorDataSegments := selectorDataSegments reject: [:each | each isEmpty].! !
!PstSmalltalkCodeGenerator categoriesFor: #absoluteMaxCodeSegmentSize!accessing!public! !
!PstSmalltalkCodeGenerator categoriesFor: #absoluteMaxDataSegmentSize!accessing!public! !
!PstSmalltalkCodeGenerator categoriesFor: #align:!public!utility! !
!PstSmalltalkCodeGenerator categoriesFor: #beginObject:ofSize:class:!object compiling!public! !
!PstSmalltalkCodeGenerator categoriesFor: #classTableSegmentSize!class compiling!public! !
!PstSmalltalkCodeGenerator categoriesFor: #compileClass:on:!class compiling!public! !
!PstSmalltalkCodeGenerator categoriesFor: #compileClasses!class compiling!public! !
!PstSmalltalkCodeGenerator categoriesFor: #compileObjectBytes:!object compiling!public! !
!PstSmalltalkCodeGenerator categoriesFor: #compileObjectReference:!object compiling!public! !
!PstSmalltalkCodeGenerator categoriesFor: #compileObjects!object compiling!public! !
!PstSmalltalkCodeGenerator categoriesFor: #deferCleanBlock:forSelector:!public!utility! !
!PstSmalltalkCodeGenerator categoriesFor: #endClassSegment:!class compiling!public! !
!PstSmalltalkCodeGenerator categoriesFor: #endObject!object compiling!public! !
!PstSmalltalkCodeGenerator categoriesFor: #endObjectSegment!object compiling!public! !
!PstSmalltalkCodeGenerator categoriesFor: #generateBasicObjects!code generation!public! !
!PstSmalltalkCodeGenerator categoriesFor: #generateCode!code generation!public! !
!PstSmalltalkCodeGenerator categoriesFor: #generateCodeForClass:!code generation!public! !
!PstSmalltalkCodeGenerator categoriesFor: #generateCodeForClasses!code generation!public! !
!PstSmalltalkCodeGenerator categoriesFor: #generateCodeForMethod:!code generation!public! !
!PstSmalltalkCodeGenerator categoriesFor: #indexOfObject:!accessing!public! !
!PstSmalltalkCodeGenerator categoriesFor: #initialize!initialization!public! !
!PstSmalltalkCodeGenerator categoriesFor: #objectAtIndex:!accessing!public! !
!PstSmalltalkCodeGenerator categoriesFor: #objectTableSegmentSize!object compiling!public! !
!PstSmalltalkCodeGenerator categoriesFor: #optimized:!initialization!public! !
!PstSmalltalkCodeGenerator categoriesFor: #performOptimizations!code generation!public! !
!PstSmalltalkCodeGenerator categoriesFor: #properties!public!utility! !
!PstSmalltalkCodeGenerator categoriesFor: #registerAllClasses!code generation!public! !
!PstSmalltalkCodeGenerator categoriesFor: #registerClass:!code generation!public! !
!PstSmalltalkCodeGenerator categoriesFor: #registerCommonSelectors!initialization!public! !
!PstSmalltalkCodeGenerator categoriesFor: #registerSpecialSelectors!initialization!public! !
!PstSmalltalkCodeGenerator categoriesFor: #registerVMClasses!code generation!public! !
!PstSmalltalkCodeGenerator categoriesFor: #segmentCount!accessing!public! !
!PstSmalltalkCodeGenerator categoriesFor: #storeInteger:!object compiling!public! !
!PstSmalltalkCodeGenerator categoriesFor: #storeInteger:on:!object compiling!public! !
!PstSmalltalkCodeGenerator categoriesFor: #storeObjref:!object compiling!public! !
!PstSmalltalkCodeGenerator categoriesFor: #storeWord:!object compiling!public! !
!PstSmalltalkCodeGenerator categoriesFor: #writeClassNameData!*-subclass responsibility!platform specific!public! !
!PstSmalltalkCodeGenerator categoriesFor: #writeClassOffsets!*-subclass responsibility!platform specific!public! !
!PstSmalltalkCodeGenerator categoriesFor: #writeClassSegments!*-subclass responsibility!platform specific!public! !
!PstSmalltalkCodeGenerator categoriesFor: #writeDebugData!platform specific!public! !
!PstSmalltalkCodeGenerator categoriesFor: #writeHeader!*-subclass responsibility!platform specific!public! !
!PstSmalltalkCodeGenerator categoriesFor: #writeImageFile!platform specific!public! !
!PstSmalltalkCodeGenerator categoriesFor: #writeObjectSegments!*-subclass responsibility!platform specific!public! !
!PstSmalltalkCodeGenerator categoriesFor: #writeProperties!*-subclass responsibility!platform specific!public! !
!PstSmalltalkCodeGenerator categoriesFor: #writeSelectorData!*-subclass responsibility!platform specific!public! !
!PstSmalltalkCodeGenerator categoriesFor: #zorchEmptySegments!public!utility! !



PstGenericCodeGenerator comment: ''!

PstGenericCodeGenerator guid: (GUID fromString: '{BA9AB22A-1726-4A22-AAC6-0FBAD14140C3}')!

!PstGenericCodeGenerator categoriesForClass!No category! !
!PstGenericCodeGenerator methodsFor!

outputStream: stream
	outputStream := stream.!

writeClassNameData
	self
		writeSegment: classNameData contents
		ofType: 5
		on: outputStream.!

writeClassOffsets
	outputStream nextPut: 3.  "offset table"
	PstSystem current
		storeWord: classOffsets size
		on: outputStream.
	classOffsets do: [:each |
		self
			storeWord: each
			on: outputStream].!

writeClassSegments
	classSegments do: [:each |
		self
			writeSegment: each
			ofType: 2
			on: outputStream].!

writeHeader
	"Write the total number of segments."
	PstSystem current
		storeWord: self segmentCount
		on: outputStream.!

writeObjectSegments
	objectSegments do: [:each |
		self
			writeSegment: each
			ofType: 1
			on: outputStream].!

writeProperties
	self
		writeSegment: self properties asResource contents
		ofType: 6
		on: outputStream.!

writeSegment: segment
ofType: type
on: stream
	stream nextPut: type.
	segment size > 16rFF00 ifTrue: [
		self generationError: 'Code segment too large'].
	PstSystem current
		storeWord: segment size
		on: stream.
	stream nextPutAll: segment.!

writeSelectorData
	self
		writeSegment: selectorData contents
		ofType: 4
		on: outputStream.! !
!PstGenericCodeGenerator categoriesFor: #outputStream:!initialization!public! !
!PstGenericCodeGenerator categoriesFor: #writeClassNameData!platform specific!public! !
!PstGenericCodeGenerator categoriesFor: #writeClassOffsets!platform specific!public! !
!PstGenericCodeGenerator categoriesFor: #writeClassSegments!platform specific!public! !
!PstGenericCodeGenerator categoriesFor: #writeHeader!platform specific!public! !
!PstGenericCodeGenerator categoriesFor: #writeObjectSegments!platform specific!public! !
!PstGenericCodeGenerator categoriesFor: #writeProperties!*-unclassified!public! !
!PstGenericCodeGenerator categoriesFor: #writeSegment:ofType:on:!platform specific!public! !
!PstGenericCodeGenerator categoriesFor: #writeSelectorData!platform specific!public! !

!PstGenericCodeGenerator class methodsFor!

on: stream
	^self new outputStream: stream.! !
!PstGenericCodeGenerator class categoriesFor: #on:!instance creation!public! !



PstGeosCodeGenerator comment: ''!

PstGeosCodeGenerator guid: (GUID fromString: '{DFA7BCDB-CD22-4764-9723-E9141AB89796}')!

!PstGeosCodeGenerator categoriesForClass!No category! !
!PstGeosCodeGenerator methodsFor!

addLibraries
         | libname |
	PstConstantsLibrary current geosLibraries do: [:lib |
                 libname := WriteStream on: String new.
                 libname nextPutAll: lib.
                 libname nextPut: Character null.
		geosVM add: libname contents asByteArray withID: 7].!

fileStream: stream
	fileStream := stream.
!

writeClassNameData
	geosVM add: classNameData contents withID: 5.!

writeClassOffsets
	| stream |
	stream := ByteArray new writeStream.
	classOffsets do: [:each |
		PstSystem current storeWord: each on: stream].
	geosVM add: stream contents withID: 3.!

writeClassSegments
	classSegments keysAndValuesDo: [:index :each |
		geosVM add: each withID: 2].!

writeHeader
	"don't really need to do anything."
!

writeImageFile
	geosVM := PstGeosVMFile new initialize.
"	geosVM
		creatorID: self databaseCreatorID;
		title: self databaseTitle.
"
        self addLibraries.
	super writeImageFile.
	geosVM writeOn: fileStream.!

writeObjectSegments
	objectSegments keysAndValuesDo: [:index :each |
		geosVM add: each withID: 1].!

writeProperties
	geosVM add: self properties asResource contents withID: 6.!

writeSelectorData
	| data |
	selectorDataSegments add: selectorData contents.
	selectorDataSegments keysAndValuesDo: [:index :each |
		geosVM add: each withID: 4].! !
!PstGeosCodeGenerator categoriesFor: #addLibraries!*-unclassified!public! !
!PstGeosCodeGenerator categoriesFor: #fileStream:!initialization!public! !
!PstGeosCodeGenerator categoriesFor: #writeClassNameData!platform specific!public! !
!PstGeosCodeGenerator categoriesFor: #writeClassOffsets!platform specific!public! !
!PstGeosCodeGenerator categoriesFor: #writeClassSegments!platform specific!public! !
!PstGeosCodeGenerator categoriesFor: #writeHeader!platform specific!public! !
!PstGeosCodeGenerator categoriesFor: #writeImageFile!platform specific!public! !
!PstGeosCodeGenerator categoriesFor: #writeObjectSegments!platform specific!public! !
!PstGeosCodeGenerator categoriesFor: #writeProperties!platform specific!public! !
!PstGeosCodeGenerator categoriesFor: #writeSelectorData!platform specific!public! !

!PstGeosCodeGenerator class methodsFor!

on: stream
	^self new fileStream: stream.
! !
!PstGeosCodeGenerator class categoriesFor: #on:!instance creation!public! !



PstPilotCodeGenerator comment: ''!

PstPilotCodeGenerator guid: (GUID fromString: '{5298E350-C77F-463C-8951-813246D53143}')!

!PstPilotCodeGenerator categoriesForClass!No category! !
!PstPilotCodeGenerator methodsFor!

addResourcesTo: resourceDatabase
	PstConstantsLibrary current resourceDatabases do: [:db |
		db resources do: [:resource |
			resourceDatabase addResource: resource]].!

databaseCreatorID
	| constant |
	(PstConstantsLibrary current hasConstantNamed: 'creatorID') ifTrue: [
		constant := PstConstantsLibrary current constantNamed: 'creatorID'.
		(constant value qclass name = 'String'
				and: [constant value indexedSlotCount = 4])
			ifTrue: [^constant value convertToString]].
	^'PkST'.!

databaseTitle
	| constant |
	(PstConstantsLibrary current hasConstantNamed: 'applicationTitle') ifTrue: [
		constant := PstConstantsLibrary current constantNamed: 'applicationTitle'.
		constant value qclass name = 'String'
			ifTrue: [^constant value convertToString]].
	^'PocketST App'.!

fileStream: stream
	fileStream := stream.!

writeClassNameData
	database addResource:
		(PstResource
			name: 'ClsN'
			id: 1
			contents: classNameData contents).!

writeClassOffsets
	| stream |
	stream := ByteArray new writeStream.
	classOffsets do: [:each |
		PstSystem current storeWord: each on: stream].
	database addResource:
		(PstResource
			name: 'ClsO'
			id: 1
			contents: stream contents).!

writeClassSegments
	classSegments keysAndValuesDo: [:index :each |
		database addResource:
			(PstResource
				name: 'ClsD'
				id: index
				contents: each)].!

writeHeader
	"don't really need to do anything."!

writeImageFile
	database := PstResourceDatabase new.
	database
		creatorID: self databaseCreatorID;
		title: self databaseTitle.

	self addResourcesTo: database.
	super writeImageFile.
	database writeOn: fileStream.!

writeObjectSegments
	objectSegments keysAndValuesDo: [:index :each |
		database addResource:
			(PstResource
				name: 'ObjD'
				id: index
				contents: each)].!

writeProperties
	database addResource: self properties asResource.!

writeSelectorData
	| data |
	selectorDataSegments add: selectorData contents.
	selectorDataSegments keysAndValuesDo: [:index :each |
		database addResource:
			(PstResource
				name: 'SelD'
				id: index
				contents: each)].! !
!PstPilotCodeGenerator categoriesFor: #addResourcesTo:!platform specific!public! !
!PstPilotCodeGenerator categoriesFor: #databaseCreatorID!parameters!public! !
!PstPilotCodeGenerator categoriesFor: #databaseTitle!parameters!public! !
!PstPilotCodeGenerator categoriesFor: #fileStream:!initialization!public! !
!PstPilotCodeGenerator categoriesFor: #writeClassNameData!platform specific!public! !
!PstPilotCodeGenerator categoriesFor: #writeClassOffsets!platform specific!public! !
!PstPilotCodeGenerator categoriesFor: #writeClassSegments!platform specific!public! !
!PstPilotCodeGenerator categoriesFor: #writeHeader!platform specific!public! !
!PstPilotCodeGenerator categoriesFor: #writeImageFile!platform specific!public! !
!PstPilotCodeGenerator categoriesFor: #writeObjectSegments!platform specific!public! !
!PstPilotCodeGenerator categoriesFor: #writeProperties!platform specific!public! !
!PstPilotCodeGenerator categoriesFor: #writeSelectorData!platform specific!public! !

!PstPilotCodeGenerator class methodsFor!

on: stream
	^self new fileStream: stream.! !
!PstPilotCodeGenerator class categoriesFor: #on:!instance creation!public! !



PstSmalltalkCompiler comment: ''!

PstSmalltalkCompiler guid: (GUID fromString: '{B2524C20-ADD8-418A-8B79-CFE98DF8F532}')!

!PstSmalltalkCompiler categoriesForClass!No category! !
!PstSmalltalkCompiler methodsFor!

addOne
	self misc: #addOne.!

beFullBlock
	"For polymorphic compatibility with BlockCompiler."
	^self.!

compileGeosMessage: messageNode pop: pop
	| messageName |
	messageName := messageNode keywords first copyWithout: $:.
"
	(PstGeosAPI hasMessageNamed: messageName) ifFalse: [
		^self
			error: 'No such geosMessage'
			for: messageNode].
	(messageNode arguments size =
			(PstGeosAPI messageNamed: messageName) argumentCount)
		ifFalse: [
			^self
				error: 'Wrong number of arguments to geosMessage'
				for: messageNode].
"
	messageNode compileArgumentsOn: self.
	self geosMessage: messageName ignoreReturn: pop arguments: messageNode arguments size.!

compileMethod: methodNode 
	argumentsHere := methodNode arguments.
	temporariesHere := methodNode temporaries.
	methodSelector := methodNode selector.
	self prepareToCompile.
	methodNode primitive isNil
		ifFalse: [self primitive: methodNode primitive].
	methodNode statements 
		compileOn: self
		preserveLast: false.
	"Add bytes indicating the number of local variables and the number of arguments for the method."
	instructions 
		addFirst: (PstRawInstruction new 
			byte: self argumentCount;
			comment: 'arguments: ');
		addFirst: (PstRawInstruction new 
			byte: self localVariableCount;
			comment: 'locals: ').
	self checkPostconditions.!

compileSysTrap: messageNode pop: pop
	| trapName |
	trapName := messageNode keywords first copyWithout: $:.
	(PstPalmOSAPI hasTrapNamed: trapName) ifFalse: [
		^self
			error: 'No such systrap'
			for: messageNode].
	(messageNode arguments size =
			(PstPalmOSAPI trapNamed: trapName) argumentCount)
		ifFalse: [
			^self
				error: 'Wrong number of arguments to systrap'
				for: messageNode].
	messageNode compileArgumentsOn: self.
	self systrap: trapName ignoreReturn: pop.!

dup
	self misc: #dup.!

geosMessage: messageName ignoreReturn: ignoreReturn arguments: arguments
	^self emit: (PstGeosMessageInstruction new
		trapName: messageName;
		ignoreReturn: ignoreReturn;
		arguments: arguments).!

integrateBlockFrom: blockCompiler
	| jump |
	blockCompiler isFullBlock
		ifTrue: [
			self pushClass: compilationClass.
			self makeFullBlock: blockCompiler argumentCount]
		ifFalse: [self pushCleanBlock: blockCompiler argumentCount].
	jump := self jump.
	instructions addAll: blockCompiler instructions.
	jump destination: self jumpDestination.!

isMinimal
	^false.!

jump
	^self emit: PstBranchInstruction new.!

jumpDestination
	^self emit: PstBranchDestinationInstruction new.!

jumpIf: condition
	^self emit: (PstConditionalBranchInstruction new
		condition: condition).!

makeFullBlock: argumentCount
	^self emit: (PstMakeFullBlockInstruction new
		argumentCount: argumentCount).!

misc: type
	"Emit a miscellaneous instruction."
	^self emit: (PstMiscInstruction new type: type).!

newBlockCompilerFor: blockNode
	^PstSmalltalkBlockCompiler new 
		compilationClass: self compilationClass;
		parent: self.!

optimizesSelfCascades
	^true.!

optimizesSelfSends
	^true.!

optimizesSpecialReturns
	^true.!

over
	self misc: #over.!

pop
	self misc: #pop.!

primitive: index
	^self emit: (PstPrimitiveInstruction new
		primitiveIndex: index).!

pushCharacter: character
	^self emit: (PstPushCharacterInstruction new
			value: (PstCharacter fromCharacter: character)).!

pushClass: qclass
	| instruction |
	instruction := PstPushClassInstruction new.
	qclass isMeta
		ifTrue: [instruction value: qclass uniqueInstance name]
		ifFalse: [instruction value: qclass name].
	instruction value isNil ifTrue: [self halt].
	instruction isMeta: qclass isMeta.
	^self emit: instruction.	!

pushCleanBlock: argumentCount
	self emit: (PstPushCleanBlockInstruction new
			value: self methodSelector;
			homeClass: self compilationClass;
			argumentCount: argumentCount).!

pushFalse
	^self misc: #pushFalse.!

pushInstVar: reference
	self emit: 
		(PstPushInstVarInstruction
			fromReference: reference).!

pushInteger: integer
	self pushLiteral: (PstInteger value: integer).!

pushLiteral: value
	| instruction |
	"Can't really avoid a direct class compare here..."
	instruction := (value class == PstConstant
		ifTrue: [PstPushConstantInstruction]
		ifFalse: [PstPushLiteralInstruction]) new.
	instruction value: value.
	self emit: instruction.!

pushLocal: reference
	self emit: 
		(PstPushLocalInstruction
			fromReference: reference).!

pushNil
	^self misc: #pushNil.!

pushSelf
	self emit: (PstPushSelfInstruction new
			distance: self scopeDepth).!

pushSharedVariable: reference
	^self emit: (PstPushSharedVarInstruction new
		ownerClass: reference distance;
		variableName: reference name).!

pushThisContext
	^self misc: #thisContext.!

pushTrue
	^self misc: #pushTrue.!

return: type
	^self emit: (PstReturnInstruction new 
		specialValue: type).!

scopeDepth
	^0.!

send: selector argumentCount: count
	^self emit:
		(PstSendInstruction new
			selector: selector;
			argumentCount: count).!

sendSelf: selector argumentCount: count
	^self emit:
		(PstSendSelfInstruction new
			selector: selector;
			argumentCount: count).!

sendSuper: selector argumentCount: count
	"push superclass is not needed with the new VM"
	self pushClass: compilationClass superclass.
	^self emit:
		(PstSendSuperInstruction new
			selector: selector;
			argumentCount: count).!

storeInstVar: reference
	self emit: 
		(PstStoreInstVarInstruction
			fromReference: reference).!

storeLocal: reference
	self emit: 
		(PstStoreLocalInstruction
			fromReference: reference).!

storeSharedVariable: reference
	^self emit: (PstStoreSharedVarInstruction new
		ownerClass: reference distance;
		variableName: reference name).!

subtractOne
	self misc: #subtractOne.!

systrap: trapName ignoreReturn: ignoreReturn
	^self emit: (PstSysTrapInstruction new
		trapName: trapName;
		ignoreReturn: ignoreReturn).! !
!PstSmalltalkCompiler categoriesFor: #addOne!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #beFullBlock!public!utility! !
!PstSmalltalkCompiler categoriesFor: #compileGeosMessage:pop:!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #compileMethod:!compiling!public! !
!PstSmalltalkCompiler categoriesFor: #compileSysTrap:pop:!compiling!public! !
!PstSmalltalkCompiler categoriesFor: #dup!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #geosMessage:ignoreReturn:arguments:!*-unclassified!public! !
!PstSmalltalkCompiler categoriesFor: #integrateBlockFrom:!blocks!public! !
!PstSmalltalkCompiler categoriesFor: #isMinimal!predicates!public! !
!PstSmalltalkCompiler categoriesFor: #jump!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #jumpDestination!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #jumpIf:!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #makeFullBlock:!blocks!public! !
!PstSmalltalkCompiler categoriesFor: #misc:!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #newBlockCompilerFor:!blocks!public! !
!PstSmalltalkCompiler categoriesFor: #optimizesSelfCascades!predicates!public! !
!PstSmalltalkCompiler categoriesFor: #optimizesSelfSends!predicates!public! !
!PstSmalltalkCompiler categoriesFor: #optimizesSpecialReturns!predicates!public! !
!PstSmalltalkCompiler categoriesFor: #over!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #pop!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #primitive:!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #pushCharacter:!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #pushClass:!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #pushCleanBlock:!blocks!public! !
!PstSmalltalkCompiler categoriesFor: #pushFalse!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #pushInstVar:!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #pushInteger:!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #pushLiteral:!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #pushLocal:!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #pushNil!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #pushSelf!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #pushSharedVariable:!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #pushThisContext!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #pushTrue!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #return:!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #scopeDepth!accessing!public! !
!PstSmalltalkCompiler categoriesFor: #send:argumentCount:!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #sendSelf:argumentCount:!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #sendSuper:argumentCount:!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #storeInstVar:!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #storeLocal:!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #storeSharedVariable:!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #subtractOne!instructions!public! !
!PstSmalltalkCompiler categoriesFor: #systrap:ignoreReturn:!instructions!public! !

!PstSmalltalkCompiler class methodsFor!

defaultReceiver
	^PstBasicObject forNil.!

evaluate: string
	^self
		evaluate: string
		for: self defaultReceiver.!

evaluate: string for: receiver
	| methodNode compiler method |
	methodNode := self parserClass parseExpression: string.
	compiler := self new.
	compiler compilationClass: receiver qclass.
	methodNode compileOn: compiler.
	method := PstMethod new.
	method
		instructions: compiler instructions;
		ownerClass: receiver qclass;
		selector: methodNode selector;
		sourceCode: string;
		commentMap: methodNode commentMap.
	method renumberInstructions.
	methodNode primitive isNil ifFalse: [
		method primitive: methodNode primitive].
	^self interpreterClass performMethod: method for: receiver.!

evaluate: string for: receiver notifying: manager
	| result |
	[result := self evaluate: string for: receiver]
		on: PstCompilerError
		do: [:exception |
			manager
				handleError: exception message
				from: exception start
				to: exception stop.
			^nil]
		on: PstCompilerWarning
		do: [:exception |
			manager
				handleWarning: exception message
				from: exception start
				to: exception stop.
			exception resume: self].
	^result.!

interpreterClass
	^PstInterpreter.!

parserClass
	^PstSmalltalkParser.! !
!PstSmalltalkCompiler class categoriesFor: #defaultReceiver!accessing!public! !
!PstSmalltalkCompiler class categoriesFor: #evaluate:!public!utility! !
!PstSmalltalkCompiler class categoriesFor: #evaluate:for:!public!utility! !
!PstSmalltalkCompiler class categoriesFor: #evaluate:for:notifying:!public!utility! !
!PstSmalltalkCompiler class categoriesFor: #interpreterClass!accessing!public! !
!PstSmalltalkCompiler class categoriesFor: #parserClass!accessing!public! !



PstSmalltalkBlockCompiler comment: ''!

PstSmalltalkBlockCompiler guid: (GUID fromString: '{A221F310-13B9-412F-9C70-BF01701B31FE}')!

!PstSmalltalkBlockCompiler categoriesForClass!No category! !
!PstSmalltalkBlockCompiler methodsFor!

beFullBlock
	isFullBlock := true.
	"Propagate block status to enclosing scopes"
	parent beFullBlock.!

compileBlock: blockNode 
withReturn: withReturn
preserveLast: preserveLast
	argumentsHere := blockNode arguments.
	temporariesHere := blockNode temporaries.
	self prepareToCompile.
	blockNode statements 
		compileOn: self
		preserveLast: preserveLast.
	withReturn
		ifTrue: [blockNode compileLocalReturnOn: self].
	"Prepend the number of local variables"
	instructions addFirst: 
		(PstRawInstruction new byte: self localVariableCount).
	self checkPostconditions.!

isBlockCompiler
	^true.!

isFullBlock
	^isFullBlock.!

methodSelector
	^parent methodSelector.!

nonlocalReturn
	self beFullBlock.
	^self emit: (PstNonlocalReturnInstruction new
			distance: self scopeDepth).!

parent: parentCompiler
	parent := parentCompiler.!

prepareToCompile
	super prepareToCompile.
	isFullBlock := false.!

pushInstVar: reference
	reference distance > 0
		ifTrue: [self beFullBlock].
	^super pushInstVar: reference.!

pushLocal: reference
	reference distance > 0
		ifTrue: [self beFullBlock].
	^super pushLocal: reference.!

pushSelf
	super pushSelf.
	self beFullBlock.!

resolveVariable: name
	| reference |
	reference := self resolveTemporaryVariableHere: name.
	reference isNil ifFalse: [^reference].
	reference := parent resolveVariable: name.
	reference isNil ifTrue: [^nil].
	(#(class shared) includes: reference type) ifFalse: [
		reference distance: reference distance + 1].
	^reference.!

scopeDepth
	^parent scopeDepth + 1.!

sendSelf: selector argumentCount: count
	self shouldNotImplement.!

sendSuper: selector argumentCount: count
	self shouldNotImplement.!

storeInstVar: reference
	self assert: [reference distance > 0].
	self beFullBlock.
	^super storeInstVar: reference.!

storeLocal: reference
	reference distance > 0
		ifTrue: [self beFullBlock].
	^super storeLocal: reference.! !
!PstSmalltalkBlockCompiler categoriesFor: #beFullBlock!public!utility! !
!PstSmalltalkBlockCompiler categoriesFor: #compileBlock:withReturn:preserveLast:!compiling!public! !
!PstSmalltalkBlockCompiler categoriesFor: #isBlockCompiler!predicates!public! !
!PstSmalltalkBlockCompiler categoriesFor: #isFullBlock!predicates!public! !
!PstSmalltalkBlockCompiler categoriesFor: #methodSelector!accessing!public! !
!PstSmalltalkBlockCompiler categoriesFor: #nonlocalReturn!instructions!public! !
!PstSmalltalkBlockCompiler categoriesFor: #parent:!initialization!public! !
!PstSmalltalkBlockCompiler categoriesFor: #prepareToCompile!initialization!public! !
!PstSmalltalkBlockCompiler categoriesFor: #pushInstVar:!compiling!public! !
!PstSmalltalkBlockCompiler categoriesFor: #pushLocal:!compiling!public! !
!PstSmalltalkBlockCompiler categoriesFor: #pushSelf!compiling!public! !
!PstSmalltalkBlockCompiler categoriesFor: #resolveVariable:!public!utility! !
!PstSmalltalkBlockCompiler categoriesFor: #scopeDepth!accessing!public! !
!PstSmalltalkBlockCompiler categoriesFor: #sendSelf:argumentCount:!*-should not implement!instructions!public! !
!PstSmalltalkBlockCompiler categoriesFor: #sendSuper:argumentCount:!*-should not implement!instructions!public! !
!PstSmalltalkBlockCompiler categoriesFor: #storeInstVar:!compiling!public! !
!PstSmalltalkBlockCompiler categoriesFor: #storeLocal:!compiling!public! !



PstSmalltalkInstruction comment: ''!

PstSmalltalkInstruction guid: (GUID fromString: '{BF0DA33A-9F18-4AA4-8C25-C9BDF1BEB72D}')!

!PstSmalltalkInstruction categoriesForClass!No category! !
!PstSmalltalkInstruction methodsFor!

code
	^code.!

codeSize
	^self code size.!

destination

	^nil
!

hasGeneratedCode
	^startIndex notNil and: [self code notNil].!

hasVisibleEffect
	"For the debugger."
	^true.!

interpretFor: interpreter
	^self subclassResponsibility.!

isDestination
	^false.
!

isReturn
	^false.!

isSend
	^false.!

isVariableInstruction
	^false.!

possiblySentSelectorsDo: block
	^self.!

referencedClass
	^nil.!

referencesClassNamed: className
	^false.!

refersToConstant: constant
	^false.!

refersToInstanceVariable: instVarName
	^false.!

refersToLiteral: value
	^false.!

refersToSharedVariable: name
	^false.!

sends: selectorString
	^false.!

sendsToSelf
	^false.!

sentSelector
	^nil.!

startIndex
	^startIndex.!

startIndex: newStartIndex
	startIndex := newStartIndex.!

toggleBreak

	^PstBreakpointInstruction new instruction: self
!

ungenerate
	code := nil.
	startIndex := nil.! !
!PstSmalltalkInstruction categoriesFor: #code!accessing!public! !
!PstSmalltalkInstruction categoriesFor: #codeSize!code generation!public! !
!PstSmalltalkInstruction categoriesFor: #destination!accessing!public! !
!PstSmalltalkInstruction categoriesFor: #hasGeneratedCode!predicates!public! !
!PstSmalltalkInstruction categoriesFor: #hasVisibleEffect!predicates!public! !
!PstSmalltalkInstruction categoriesFor: #interpretFor:!*-subclass responsibility!interpreting!public! !
!PstSmalltalkInstruction categoriesFor: #isDestination!predicates!public! !
!PstSmalltalkInstruction categoriesFor: #isReturn!predicates!public! !
!PstSmalltalkInstruction categoriesFor: #isSend!predicates!public! !
!PstSmalltalkInstruction categoriesFor: #isVariableInstruction!predicates!public! !
!PstSmalltalkInstruction categoriesFor: #possiblySentSelectorsDo:!accessing!public! !
!PstSmalltalkInstruction categoriesFor: #referencedClass!accessing!public! !
!PstSmalltalkInstruction categoriesFor: #referencesClassNamed:!predicates!public! !
!PstSmalltalkInstruction categoriesFor: #refersToConstant:!predicates!public! !
!PstSmalltalkInstruction categoriesFor: #refersToInstanceVariable:!predicates!public! !
!PstSmalltalkInstruction categoriesFor: #refersToLiteral:!predicates!public! !
!PstSmalltalkInstruction categoriesFor: #refersToSharedVariable:!predicates!public! !
!PstSmalltalkInstruction categoriesFor: #sends:!predicates!public! !
!PstSmalltalkInstruction categoriesFor: #sendsToSelf!predicates!public! !
!PstSmalltalkInstruction categoriesFor: #sentSelector!accessing!public! !
!PstSmalltalkInstruction categoriesFor: #startIndex!accessing!public! !
!PstSmalltalkInstruction categoriesFor: #startIndex:!accessing!public! !
!PstSmalltalkInstruction categoriesFor: #toggleBreak!converting!public! !
!PstSmalltalkInstruction categoriesFor: #ungenerate!code generation!public! !



PstBranchDestinationInstruction comment: ''!

PstBranchDestinationInstruction guid: (GUID fromString: '{0B2EC8A5-9A58-46BD-8D8A-6BD998DDBC73}')!

!PstBranchDestinationInstruction categoriesForClass!No category! !
!PstBranchDestinationInstruction methodsFor!

description
	^'(branch destination)'.!

estimatedCompiledSize
	^0.!

generateCodeFor: generator
	code := #[].!

hasVisibleEffect
	^false.!

instructionCategory
	^#label.!

interpretFor: interpreter
	"Do nothing."!

isDestination
	^true.
! !
!PstBranchDestinationInstruction categoriesFor: #description!printing!public! !
!PstBranchDestinationInstruction categoriesFor: #estimatedCompiledSize!accessing!public! !
!PstBranchDestinationInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstBranchDestinationInstruction categoriesFor: #hasVisibleEffect!predicates!public! !
!PstBranchDestinationInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstBranchDestinationInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstBranchDestinationInstruction categoriesFor: #isDestination!predicates!public! !



PstBranchInstruction comment: ''!

PstBranchInstruction guid: (GUID fromString: '{D4DC3DA3-6123-442B-936F-9F816A07008E}')!

!PstBranchInstruction categoriesForClass!No category! !
!PstBranchInstruction methodsFor!

branchBackwardBy: distance
	self
		generateBranchInstruction: 16r44
		distance: distance negated.!

branchForwardBy: distance
	self
		generateBranchInstruction: 16r40
		distance: distance.!

branchFrom: source to: dest
	| delta |
	delta := dest - source - 2.
	delta abs > self class branchLimit ifTrue: [self error: 'Branch too long.'].
	delta < 0
		ifTrue: [self branchBackwardBy: delta]
		ifFalse: [self branchForwardBy: delta].!

codeSize
	^2.!

description
	^'branch to [', destination sequenceNumber printString, ']'.!

destination
	^destination.!

destination: instruction
	destination := instruction.!

estimatedCompiledSize
	^2.!

generateBranchInstruction: instructionBase
distance: distance
	self assert: [distance between: 0 and: 1023].
	code := ByteArray
		with: instructionBase + (distance bitShift: -8)
		with: (distance bitAnd: 16rFF).!

generateBranchTo: dest for: builder
	self 
		branchFrom: self startIndex 
		to: dest startIndex.!

generateCodeFor: builder
	"If the branch destination instruction has not been generated yet (i.e., this is a forward-branch), then wait until the second pass to generate the code."
	destination hasGeneratedCode
		ifTrue: [self generateBranchTo: destination for: builder]
		ifFalse: [
			"Nasty hack, but this is tricky to get right otherwise."
			startIndex := nil].!

instructionCategory
	^#jump.!

interpretFor: interpreter
	interpreter branchTo: destination sequenceNumber.! !
!PstBranchInstruction categoriesFor: #branchBackwardBy:!code generation!public! !
!PstBranchInstruction categoriesFor: #branchForwardBy:!code generation!public! !
!PstBranchInstruction categoriesFor: #branchFrom:to:!code generation!public! !
!PstBranchInstruction categoriesFor: #codeSize!code generation!public! !
!PstBranchInstruction categoriesFor: #description!printing!public! !
!PstBranchInstruction categoriesFor: #destination!accessing!public! !
!PstBranchInstruction categoriesFor: #destination:!accessing!public! !
!PstBranchInstruction categoriesFor: #estimatedCompiledSize!accessing!public! !
!PstBranchInstruction categoriesFor: #generateBranchInstruction:distance:!code generation!public! !
!PstBranchInstruction categoriesFor: #generateBranchTo:for:!code generation!public! !
!PstBranchInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstBranchInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstBranchInstruction categoriesFor: #interpretFor:!interpreting!public! !

!PstBranchInstruction class methodsFor!

branchLimit
	"Maximum number of bytecodes that can be jumped over."
	^1020.! !
!PstBranchInstruction class categoriesFor: #branchLimit!accessing!public! !



PstBreakpointInstruction comment: ''!

PstBreakpointInstruction guid: (GUID fromString: '{41C7C49B-125B-41FD-98DE-7ABF0FC6CBC5}')!

!PstBreakpointInstruction categoriesForClass!No category! !
!PstBreakpointInstruction methodsFor!

code
	^instruction code.!

description
	^'<< ', instruction description, ' >>'.!

instruction

	^instruction.!

instruction: value

	instruction := value.!

interpretFor: interpreter
	instruction interpretFor: interpreter.
	interpreter synchronize: #debug.!

toggleBreak

	^instruction!

ungenerate
	code := nil.
	startIndex := nil.! !
!PstBreakpointInstruction categoriesFor: #code!accessing!public! !
!PstBreakpointInstruction categoriesFor: #description!printing!public! !
!PstBreakpointInstruction categoriesFor: #instruction!accessing!public! !
!PstBreakpointInstruction categoriesFor: #instruction:!accessing!public! !
!PstBreakpointInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstBreakpointInstruction categoriesFor: #toggleBreak!converting!public! !
!PstBreakpointInstruction categoriesFor: #ungenerate!code generation!public! !



PstMakeFullBlockInstruction comment: ''!

PstMakeFullBlockInstruction guid: (GUID fromString: '{0C19D424-EDD9-417D-AFEF-BB5D1B8756E2}')!

!PstMakeFullBlockInstruction categoriesForClass!No category! !
!PstMakeFullBlockInstruction methodsFor!

argumentCount
	^argumentCount.!

argumentCount: object
	argumentCount := object.!

description
	^'make full block, ', self argumentCount printString, ' arg(s)'.!

estimatedCompiledSize
	^1.!

generateCodeFor: generator
	code := ByteArray with: 16rB9 with: self argumentCount.!

instructionCategory
	^#fullBlock.!

interpretFor: interpreter
	interpreter 
		makeFullBlock: argumentCount
		forClass: interpreter pop.! !
!PstMakeFullBlockInstruction categoriesFor: #argumentCount!accessing!public! !
!PstMakeFullBlockInstruction categoriesFor: #argumentCount:!accessing!public! !
!PstMakeFullBlockInstruction categoriesFor: #description!printing!public! !
!PstMakeFullBlockInstruction categoriesFor: #estimatedCompiledSize!accessing!public! !
!PstMakeFullBlockInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstMakeFullBlockInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstMakeFullBlockInstruction categoriesFor: #interpretFor:!interpreting!public! !



PstMiscInstruction comment: ''!

PstMiscInstruction guid: (GUID fromString: '{A14F2B2D-DD21-4E46-9288-C242DDA5FD7D}')!

!PstMiscInstruction categoriesForClass!No category! !
!PstMiscInstruction methodsFor!

bytecode
	type == #pop ifTrue: [^16rE0].
	type == #dup ifTrue: [^16rE1].
	type == #over ifTrue: [^16rE2].
	type == #pushSelf ifTrue: [^16rEB].
	type == #pushTrue ifTrue: [^16rE9].
	type == #pushFalse ifTrue: [^16rE8].
	type == #pushNil ifTrue: [^16rEA].
	type == #addOne ifTrue: [^16rF7].
	type == #subtractOne ifTrue: [^16rF8].
	type == #thisContext ifTrue: [^16rF9].
	self error: 'bad misc instruction'.!

description
	type == #pop ifTrue: [^'pop stack top'].
	type == #dup ifTrue: [^'duplicate stack top'].
	type == #over ifTrue: [^'duplicate stack level 2'].
	type == #pushSelf ifTrue: [^'push self'].
	type == #pushTrue ifTrue: [^'push true'].
	type == #pushFalse ifTrue: [^'push false'].
	type == #pushNil ifTrue: [^'push nil'].
	type == #addOne ifTrue: [^'add one'].
	type == #subtractOne ifTrue: [^'subtract one'].
	type == #pushNil ifTrue: [^'push nil'].
	type == #pushTrue ifTrue: [^'push true'].
	type == #pushFalse ifTrue: [^'push false'].
	type == #thisContext ifTrue: [^'push thisContext'].
	self error: 'bad misc instruction type'.!

estimatedCompiledSize
	^1.!

generateCodeFor: generator
	code := ByteArray with: self bytecode.!

hasVisibleEffect
	^#(pushSelf pushTrue pushFalse pushNil addOne subtractOne thisContext)
		includes: type.!

instructionCategory
	(#(pop dup over) identityIncludes: type)
		ifTrue: [^#stackEffect].
	(#(pushSelf pushNil pushTrue pushFalse) identityIncludes: type)
		ifTrue: [^#push].
	^#other.!

interpretFor: interpreter
	type == #pop ifTrue: [^interpreter pop].
	type == #dup ifTrue: [^interpreter dup].
	type == #over ifTrue: [^interpreter over].
	type == #pushSelf ifTrue: [^interpreter push: interpreter receiver].
	type == #pushTrue ifTrue: [^interpreter push: PstBasicObject forTrue].
	type == #pushFalse ifTrue: [^interpreter push: PstBasicObject forFalse].
	type == #pushNil ifTrue: [^interpreter push: PstBasicObject forNil].
	type == #addOne ifTrue: [^interpreter addOne].
	type == #subtractOne ifTrue: [^interpreter subtractOne].
	type == #thisContext ifTrue: [^
		interpreter push: (PstInteger value: interpreter thisContextIndex)].
	self error: 'bad misc instruction'.!

type
	^type.!

type: newType
	type := newType.! !
!PstMiscInstruction categoriesFor: #bytecode!code generation!public! !
!PstMiscInstruction categoriesFor: #description!printing!public! !
!PstMiscInstruction categoriesFor: #estimatedCompiledSize!accessing!public! !
!PstMiscInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstMiscInstruction categoriesFor: #hasVisibleEffect!predicates!public! !
!PstMiscInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstMiscInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstMiscInstruction categoriesFor: #type!accessing!public! !
!PstMiscInstruction categoriesFor: #type:!accessing!public! !



PstNonlocalReturnInstruction comment: ''!

PstNonlocalReturnInstruction guid: (GUID fromString: '{45D10916-7F33-4BC9-B42A-F490E8913CEA}')!

!PstNonlocalReturnInstruction categoriesForClass!No category! !
!PstNonlocalReturnInstruction methodsFor!

description
	^'nonlocal return (depth ', self distance printString, ')'.!

distance
	^distance.!

distance: object
	distance := object.!

estimatedCompiledSize
	^1.!

generateCodeFor: generator
	code := distance = 1
		ifTrue: [#[16rB8]]
		ifFalse: [ByteArray with: 16rBD with: distance].!

instructionCategory
	^#return.!

interpretFor: interpreter
	interpreter
		nonlocalReturn: interpreter pop
		depth: distance.!

isReturn
	^true.! !
!PstNonlocalReturnInstruction categoriesFor: #description!printing!public! !
!PstNonlocalReturnInstruction categoriesFor: #distance!accessing!public! !
!PstNonlocalReturnInstruction categoriesFor: #distance:!accessing!public! !
!PstNonlocalReturnInstruction categoriesFor: #estimatedCompiledSize!accessing!public! !
!PstNonlocalReturnInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstNonlocalReturnInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstNonlocalReturnInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstNonlocalReturnInstruction categoriesFor: #isReturn!predicates!public! !



PstPrimitiveInstruction comment: ''!

PstPrimitiveInstruction guid: (GUID fromString: '{651472D0-DE07-4462-A242-84C4DAF27F31}')!

!PstPrimitiveInstruction categoriesForClass!No category! !
!PstPrimitiveInstruction methodsFor!

description
	^'primitive ', self primitiveIndex printString.!

estimatedCompiledSize
	^2.!

generateCodeFor: generator
	self assert: [self primitiveIndex between: 0 and: 255].
	code := ByteArray
		with: 16rFE
		with: self primitiveIndex.!

instructionCategory
	^#primitive.!

interpretFor: interpreter
	^interpreter primitive: primitiveIndex.!

primitiveIndex
	^primitiveIndex.!

primitiveIndex: object
	primitiveIndex := object.! !
!PstPrimitiveInstruction categoriesFor: #description!printing!public! !
!PstPrimitiveInstruction categoriesFor: #estimatedCompiledSize!accessing!public! !
!PstPrimitiveInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstPrimitiveInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstPrimitiveInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstPrimitiveInstruction categoriesFor: #primitiveIndex!accessing!public! !
!PstPrimitiveInstruction categoriesFor: #primitiveIndex:!accessing!public! !



PstPushAnyInstVarInstruction comment: ''!

PstPushAnyInstVarInstruction guid: (GUID fromString: '{6A07C588-DF3C-436C-AC17-D9B2AEDEB4EB}')!

!PstPushAnyInstVarInstruction categoriesForClass!No category! !
!PstPushAnyInstVarInstruction methodsFor!

description
	^'inline send #instVarAt: ', index printString.!

estimatedCompiledSize
	^2.!

generateCodeFor: generator
	code := ByteArray with: 16r60 with: index.!

index
	^index.!

index: newIndex
	index := newIndex.!

instructionCategory
	^#fetch.!

interpretFor: interpreter
	| object |
	object := interpreter pop.
	interpreter push: (object namedSlotAt: index + 1).! !
!PstPushAnyInstVarInstruction categoriesFor: #description!printing!public! !
!PstPushAnyInstVarInstruction categoriesFor: #estimatedCompiledSize!accessing!public! !
!PstPushAnyInstVarInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstPushAnyInstVarInstruction categoriesFor: #index!accessing!public! !
!PstPushAnyInstVarInstruction categoriesFor: #index:!accessing!public! !
!PstPushAnyInstVarInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstPushAnyInstVarInstruction categoriesFor: #interpretFor:!interpreting!public! !



PstPushLiteralInstruction comment: ''!

PstPushLiteralInstruction guid: (GUID fromString: '{E8197CD0-9646-473D-BDF5-48A0ADDD6BED}')!

!PstPushLiteralInstruction categoriesForClass!No category! !
!PstPushLiteralInstruction methodsFor!

description
	^'push literal: ', value displayString.!

estimatedCompiledSize
	^3.!

generateCodeFor: generator
	| index |
	(value isIntegerObject and: [self generateSmallInteger: value value])
		ifTrue: [^self].
	value isSymbolObject ifTrue: [
		^self generateSmallInteger:
			(generator indexOfSelector: value string)].
	self
		generatePushObjectIndex: (generator indexOfObject: value)
		for: generator.!

generatePushObjectIndex: index
for: generator
	(index between: 0 and: 255) ifTrue: [
		"Short push"
		^code := ByteArray
			with: 16rB0
			with: index].
	(index between: 256 and: 16rFFFF) ifTrue: [
		"Long push"
		^code := ByteArray
			with: 16rB1
			with: ((index bitShift: -8) bitAnd: 16rFF)
			with: (index bitAnd: 16rFF)].
	generator generationError: 'Too many literal objects'.!

generateSmallInteger: integer
	"4 cases: positive and negative, and one or two bytes in size."
	(integer between: 0 and: 255) ifTrue: [
		code := ByteArray
			with: 16rED
			with: integer.
		^true].
	(integer between: 256 and: 16rFFFF) ifTrue: [
		code := ByteArray
			with: 16rEF
			with: ((integer bitShift: -8) bitAnd: 16rFF)
			with: (integer bitAnd: 16rFF).
		^true].
	(integer between: -255 and: -1) ifTrue: [
		code := ByteArray
			with: 16rEC
			with: integer negated.
		^true].
	(integer between: -16rFFFF and: -256) ifTrue: [
		code := ByteArray
			with: 16rEE
			with: ((integer negated bitShift: -8) bitAnd: 16rFF)
			with: (integer negated bitAnd: 16rFF).
		^true].
	^false.!

instructionCategory
	^#push.!

interpretFor: interpreter
	interpreter push: value.!

possiblySentSelectorsDo: block
	value embeddedSelectorsDo: block.!

refersToLiteral: anotherValue
	^value equals: anotherValue.!

value
	^value.!

value: newValue
	value := newValue.! !
!PstPushLiteralInstruction categoriesFor: #description!printing!public! !
!PstPushLiteralInstruction categoriesFor: #estimatedCompiledSize!accessing!public! !
!PstPushLiteralInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstPushLiteralInstruction categoriesFor: #generatePushObjectIndex:for:!code generation!public! !
!PstPushLiteralInstruction categoriesFor: #generateSmallInteger:!code generation!public! !
!PstPushLiteralInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstPushLiteralInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstPushLiteralInstruction categoriesFor: #possiblySentSelectorsDo:!accessing!public! !
!PstPushLiteralInstruction categoriesFor: #refersToLiteral:!predicates!public! !
!PstPushLiteralInstruction categoriesFor: #value!accessing!public! !
!PstPushLiteralInstruction categoriesFor: #value:!accessing!public! !



PstPushSelfInstruction comment: ''!

PstPushSelfInstruction guid: (GUID fromString: '{1ECF6FB7-7807-4670-BB9E-87DFCACD0CD6}')!

!PstPushSelfInstruction categoriesForClass!No category! !
!PstPushSelfInstruction methodsFor!

description
	^'push self', (distance = 0
			ifTrue: ['']
			ifFalse: [' (distance ', distance printString, ')']).!

distance
	^distance.!

distance: object
	distance := object.!

estimatedCompiledSize
	^1.!

generateCodeFor: generator
	distance = 0 ifTrue: [^code := #[16rEB]].
	distance = 1 ifTrue: [^code := #[16rBE]].
	code := ByteArray with: 16rBF with: distance.!

instructionCategory
	^#push.!

interpretFor: interpreter
	| receiver |
	receiver := interpreter outerReceiver: distance.
	receiver isNil ifTrue: [
		interpreter push: PstBasicObject forNil.
		^interpreter send: 'contextAlreadyReturned' argumentCount: 0].
	interpreter push: receiver.! !
!PstPushSelfInstruction categoriesFor: #description!printing!public! !
!PstPushSelfInstruction categoriesFor: #distance!accessing!public! !
!PstPushSelfInstruction categoriesFor: #distance:!accessing!public! !
!PstPushSelfInstruction categoriesFor: #estimatedCompiledSize!accessing!public! !
!PstPushSelfInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstPushSelfInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstPushSelfInstruction categoriesFor: #interpretFor:!interpreting!public! !



PstRawInstruction comment: ''!

PstRawInstruction guid: (GUID fromString: '{1023B2B7-42FF-4D02-8EF5-7AF19A795F82}')!

!PstRawInstruction categoriesForClass!No category! !
!PstRawInstruction methodsFor!

byte
	^byte.!

byte: object
	byte := object.!

comment: string
	comment := string.!

description
	^(comment isNil
		ifTrue: ['raw byte: ']
		ifFalse: [comment]), byte printString.!

estimatedCompiledSize
	^1.!

generateCodeFor: generator
	code := ByteArray with: byte.!

hasVisibleEffect
	^false.!

instructionCategory
	^#raw.!

interpretFor: interpreter
	self error: 'Cannot interpret raw instructions directly.'.! !
!PstRawInstruction categoriesFor: #byte!accessing!public! !
!PstRawInstruction categoriesFor: #byte:!accessing!public! !
!PstRawInstruction categoriesFor: #comment:!accessing!public! !
!PstRawInstruction categoriesFor: #description!printing!public! !
!PstRawInstruction categoriesFor: #estimatedCompiledSize!accessing!public! !
!PstRawInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstRawInstruction categoriesFor: #hasVisibleEffect!predicates!public! !
!PstRawInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstRawInstruction categoriesFor: #interpretFor:!interpreting!public! !



PstReturnInstruction comment: ''!

PstReturnInstruction guid: (GUID fromString: '{4DF46D2C-ED06-4CA8-B850-3E62BB8B7209}')!

!PstReturnInstruction categoriesForClass!No category! !
!PstReturnInstruction methodsFor!

bytecode
	specialValue == #nil ifTrue: [^16rE6].
	specialValue == #true ifTrue: [^16rE4].
	specialValue == #false ifTrue: [^16rE5].
	specialValue == #self ifTrue: [^16rE7].
	specialValue == nil ifTrue: [^16rE3].
	self error: 'bad return type'.!

description
	| r |
	r := nil.
	specialValue == #self ifTrue: [r := 'self'].
	specialValue == #nil ifTrue: [r := 'nil'].
	specialValue == #true ifTrue: [r := 'true'].
	specialValue == #false ifTrue: [r := 'false'].
	(r isNil and: [specialValue notNil])
		ifTrue: [r := specialValue printString].
	^r isNil
		ifTrue: ['return']
		ifFalse: ['return ', r].!

estimatedCompiledSize
	^1.!

generateCodeFor: generator
	code := ByteArray with: self bytecode.!

instructionCategory
	^#return.!

interpretFor: interpreter
	specialValue == #self 
		ifTrue: [^interpreter localReturn: interpreter receiver].
	specialValue == #true
		ifTrue: [^interpreter localReturn: PstBasicObject forTrue].
	specialValue == #false
		ifTrue: [^interpreter localReturn: PstBasicObject forFalse].
	specialValue == #nil
		ifTrue: [^interpreter localReturn: PstBasicObject forNil].
	^interpreter localReturn: interpreter pop.!

isReturn
	^true.!

specialValue: val
	specialValue := val.! !
!PstReturnInstruction categoriesFor: #bytecode!code generation!public! !
!PstReturnInstruction categoriesFor: #description!printing!public! !
!PstReturnInstruction categoriesFor: #estimatedCompiledSize!accessing!public! !
!PstReturnInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstReturnInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstReturnInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstReturnInstruction categoriesFor: #isReturn!predicates!public! !
!PstReturnInstruction categoriesFor: #specialValue:!accessing!public! !



PstSendInstruction comment: ''!

PstSendInstruction guid: (GUID fromString: '{00CAAD0D-F24C-419D-A176-141462DDB3F3}')!

!PstSendInstruction categoriesForClass!No category! !
!PstSendInstruction methodsFor!

argumentCount
	^argumentCount.!

argumentCount: number
	argumentCount := number.!

canAbbreviate: selectorIndex
	^selectorIndex <= 255.!

description
	^'send ', selector, self receiverName.!

estimatedCompiledSize
	^self inlineIndex isNil
		ifTrue: [3]
		ifFalse: [1].!

generateCodeFor: generator
	| index |
	index := self inlineIndex.
	index isNil ifFalse: [
		^code := ByteArray with: 16rC0 + index].
	index := generator indexOfSelector: self selector.
	self argumentCount > 15 ifTrue: [
		generator generationError: 'Too many arguments in message send'].
	(self canAbbreviate: index) ifTrue: [
		^code := ByteArray
			with: self shortByte + self argumentCount
			with: index].
	index > 16rFFFF ifTrue: [
		generator generationError: 'Too many selectors'].
	code := ByteArray
		with: self longByte + self argumentCount
		with: ((index bitShift: -8) bitAnd: 16rFF)
		with: (index bitAnd: 16rFF).!

inlineIndex
	^InlineSelectors
		at: self selector
		ifAbsent: [nil].!

inlineInterpretFor: interpreter
	| index |
	index := self inlineIndex.
	index == 0 ifTrue: [^interpreter inlineIntegerCompare: #<=].
	index == 1 ifTrue: [^interpreter inlineIntegerCompare: #>=].
	index == 2 ifTrue: [^interpreter inlineIntegerCompare: #<].
	index == 3 ifTrue: [^interpreter inlineIntegerCompare: #>].
	index == 4 ifTrue: [^interpreter inlineCompare: #identicalTo:].
	index == 5 ifTrue: [^interpreter inlineCompare: #notIdenticalTo:].
	^false.!

instructionCategory
	^#send.!

interpretFor: interpreter
	((self class canInline: selector) 
			and: [self inlineInterpretFor: interpreter])
		ifFalse: [
			interpreter 
				send: selector
				argumentCount: argumentCount].!

isSend
	^true.!

longByte
	^16r80.!

possiblySentSelectorsDo: block
	block value: selector.!

receiverName
	^''.!

selector
	^selector.!

selector: string
	selector := string.!

sends: selectorString
	^selector = selectorString.!

sentSelector
	^selector.!

shortByte
	^16rD0.! !
!PstSendInstruction categoriesFor: #argumentCount!accessing!public! !
!PstSendInstruction categoriesFor: #argumentCount:!accessing!public! !
!PstSendInstruction categoriesFor: #canAbbreviate:!code generation!public! !
!PstSendInstruction categoriesFor: #description!printing!public! !
!PstSendInstruction categoriesFor: #estimatedCompiledSize!accessing!public! !
!PstSendInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstSendInstruction categoriesFor: #inlineIndex!code generation!public! !
!PstSendInstruction categoriesFor: #inlineInterpretFor:!interpreting!public! !
!PstSendInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstSendInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstSendInstruction categoriesFor: #isSend!predicates!public! !
!PstSendInstruction categoriesFor: #longByte!code generation!public! !
!PstSendInstruction categoriesFor: #possiblySentSelectorsDo:!accessing!public! !
!PstSendInstruction categoriesFor: #receiverName!printing!public! !
!PstSendInstruction categoriesFor: #selector!accessing!public! !
!PstSendInstruction categoriesFor: #selector:!accessing!public! !
!PstSendInstruction categoriesFor: #sends:!predicates!public! !
!PstSendInstruction categoriesFor: #sentSelector!accessing!public! !
!PstSendInstruction categoriesFor: #shortByte!code generation!public! !

!PstSendInstruction class methodsFor!

canInline: selector
	^InlineSelectors includesKey: selector.!

initialize
	"PstSendInstruction initialize"
	InlineSelectors := Dictionary new.
	#('<=' '>=' '<' '>' '==' '~~' 'not' '+' '-' 'basicAt:' 'basicAt:put:' 'isNil' 'notNil') 
		keysAndValuesDo: [:index :selector |
			InlineSelectors at: selector put: index - 1].! !
!PstSendInstruction class categoriesFor: #canInline:!public!utility! !
!PstSendInstruction class categoriesFor: #initialize!initialization!public! !



PstSharedVarInstruction comment: ''!

PstSharedVarInstruction guid: (GUID fromString: '{9362B3B6-DAF5-4073-B842-30C803CA9CB3}')!

!PstSharedVarInstruction categoriesForClass!No category! !
!PstSharedVarInstruction methodsFor!

description
	^self typeString, ' shared var ',
		ownerClass displayString, '.' , variableName.!

estimatedCompiledSize
	^2.!

generateCodeFor: generator
	| index |
	index := generator
		indexOfSharedVar: self variableName
		forClass: ownerClass.
	(index between: 0 and: 255) ifTrue: [
		"Short push"
		^code := ByteArray
			with: self shortBytecode
			with: index].
	(index between: 256 and: 16rFFFF) ifTrue: [
		"Long push"
		^code := ByteArray
			with: self longBytecode
			with: ((index bitShift: -8) bitAnd: 16rFF)
			with: (index bitAnd: 16rFF)].
	generator generationError: 'Too many shared variables'.!

longBytecode
	^self subclassResponsibility.!

ownerClass
	^ownerClass.!

ownerClass: object
	ownerClass := object.!

refersToSharedVariable: name
	^name = variableName.!

shortBytecode
	^self subclassResponsibility.!

typeString
	self subclassResponsibility.!

variableName
	^variableName.!

variableName: object
	variableName := object.! !
!PstSharedVarInstruction categoriesFor: #description!printing!public! !
!PstSharedVarInstruction categoriesFor: #estimatedCompiledSize!accessing!public! !
!PstSharedVarInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstSharedVarInstruction categoriesFor: #longBytecode!*-subclass responsibility!code generation!public! !
!PstSharedVarInstruction categoriesFor: #ownerClass!accessing!public! !
!PstSharedVarInstruction categoriesFor: #ownerClass:!accessing!public! !
!PstSharedVarInstruction categoriesFor: #refersToSharedVariable:!predicates!public! !
!PstSharedVarInstruction categoriesFor: #shortBytecode!*-subclass responsibility!code generation!public! !
!PstSharedVarInstruction categoriesFor: #typeString!*-subclass responsibility!printing!public! !
!PstSharedVarInstruction categoriesFor: #variableName!accessing!public! !
!PstSharedVarInstruction categoriesFor: #variableName:!accessing!public! !



PstSysTrapInstruction comment: ''!

PstSysTrapInstruction guid: (GUID fromString: '{1AD4D114-B3F2-4F36-A1B0-CEF378180323}')!

!PstSysTrapInstruction categoriesForClass!No category! !
!PstSysTrapInstruction methodsFor!

description
	| qualifier |
	qualifier := ignoreReturn
		ifTrue: [', ignore return value']
		ifFalse: [''].
	^'systrap ', self trap displayString, qualifier.!

estimatedCompiledSize
	^5.  "FIXME"!

generateCodeFor: generator
	code := ignoreReturn
		ifTrue: [#[16r67]] ifFalse: [#[16r62]].
	code := code, self trap bytecodes.!

ignoreReturn: boolean
	ignoreReturn := boolean.!

instructionCategory
	^#systrap.!

interpretFor: interpreter
	interpreter pop: self trap argumentCount.
	interpreter push: PstBasicObject forNil.
	interpreter runtimeError: 'Cannot simulate SysTraps in the emulator'.!

trap
	^PstSystem current apiClass trapNamed: trapName.!

trapName: string
	trapName := string.! !
!PstSysTrapInstruction categoriesFor: #description!printing!public! !
!PstSysTrapInstruction categoriesFor: #estimatedCompiledSize!accessing!public! !
!PstSysTrapInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstSysTrapInstruction categoriesFor: #ignoreReturn:!accessing!public! !
!PstSysTrapInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstSysTrapInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstSysTrapInstruction categoriesFor: #trap!accessing!public! !
!PstSysTrapInstruction categoriesFor: #trapName:!accessing!public! !



PstVariableInstruction comment: ''!

PstVariableInstruction guid: (GUID fromString: '{E703558C-551B-4D3C-9FFC-48B2A7767A3F}')!

!PstVariableInstruction categoriesForClass!No category! !
!PstVariableInstruction methodsFor!

description
	| base outer |
	base := variableName isNil
		ifTrue: [self opDescription, ' index ', index printString]
		ifFalse: [self opDescription, ' index ', index printString, ' (', variableName, ')'].
	outer := distance = 0
		ifTrue: ['']
		ifFalse: [', outer ', distance printString].
	^base, outer.!

distance: scopeDistance
	"0 for this scope, >0 for outer scopes."
	distance := scopeDistance.!

estimatedCompiledSize
	^1.!

generateCodeFor: generator
	self subclassResponsibility.!

generateInnerAccess: slot
shortBytecode: shortBytecode
longBytecode: longBytecode
	self assert: [slot between: 0 and: 255].
	code := slot <= 15
		ifTrue: [ByteArray with: shortBytecode + slot]
		ifFalse: [
			 ByteArray
				with: longBytecode
				with: slot].
!

generateOuterAccessFor: generator
	self subclassResponsibility.!

index: newIndex
	index := newIndex.!

isPush
	^self subclassResponsibility.!

isStore
	^self isPush not.!

isVariableInstruction
	^true.!

opDescription
	self subclassResponsibility.!

refersToInstanceVariable
	^self subclassResponsibility.!

variableName: string
	variableName := string.! !
!PstVariableInstruction categoriesFor: #description!printing!public! !
!PstVariableInstruction categoriesFor: #distance:!accessing!public! !
!PstVariableInstruction categoriesFor: #estimatedCompiledSize!accessing!public! !
!PstVariableInstruction categoriesFor: #generateCodeFor:!*-subclass responsibility!code generation!public! !
!PstVariableInstruction categoriesFor: #generateInnerAccess:shortBytecode:longBytecode:!code generation!public! !
!PstVariableInstruction categoriesFor: #generateOuterAccessFor:!*-subclass responsibility!code generation!public! !
!PstVariableInstruction categoriesFor: #index:!accessing!public! !
!PstVariableInstruction categoriesFor: #isPush!*-subclass responsibility!predicates!public! !
!PstVariableInstruction categoriesFor: #isStore!predicates!public! !
!PstVariableInstruction categoriesFor: #isVariableInstruction!predicates!public! !
!PstVariableInstruction categoriesFor: #opDescription!*-subclass responsibility!printing!public! !
!PstVariableInstruction categoriesFor: #refersToInstanceVariable!*-subclass responsibility!predicates!public! !
!PstVariableInstruction categoriesFor: #variableName:!accessing!public! !

!PstVariableInstruction class methodsFor!

fromReference: reference
	^self
		index: reference index
		name: reference name
		distance: reference distance.!

index: index name: variableName distance: distance
	^self new
		index: index;
		variableName: variableName;
		distance: distance.! !
!PstVariableInstruction class categoriesFor: #fromReference:!instance creation!public! !
!PstVariableInstruction class categoriesFor: #index:name:distance:!instance creation!public! !



PstConditionalBranchInstruction comment: ''!

PstConditionalBranchInstruction guid: (GUID fromString: '{9D5F90F2-210D-4BC8-A707-9322E8DB955A}')!

!PstConditionalBranchInstruction categoriesForClass!No category! !
!PstConditionalBranchInstruction methodsFor!

branchBackwardBy: distance
	self
		generateBranchInstruction:
			(condition ifTrue: [16r54] ifFalse: [16r5C])
		distance: distance negated.!

branchForwardBy: distance
	self
		generateBranchInstruction:
			(condition ifTrue: [16r50] ifFalse: [16r58])
		distance: distance.!

condition
	^condition.!

condition: boolean
	condition := boolean.!

description
	^'branch if ', condition printString, ' to [', 
		destination sequenceNumber printString, ']'.!

interpretFor: interpreter
	interpreter
		branchTo: destination sequenceNumber
		if: condition.! !
!PstConditionalBranchInstruction categoriesFor: #branchBackwardBy:!code generation!public! !
!PstConditionalBranchInstruction categoriesFor: #branchForwardBy:!code generation!public! !
!PstConditionalBranchInstruction categoriesFor: #condition!accessing!public! !
!PstConditionalBranchInstruction categoriesFor: #condition:!accessing!public! !
!PstConditionalBranchInstruction categoriesFor: #description!printing!public! !
!PstConditionalBranchInstruction categoriesFor: #interpretFor:!interpreting!public! !



PstStoreAnyInstVarInstruction comment: ''!

PstStoreAnyInstVarInstruction guid: (GUID fromString: '{F0A82F3B-22E5-4888-9180-5CDB6223D5B1}')!

!PstStoreAnyInstVarInstruction categoriesForClass!No category! !
!PstStoreAnyInstVarInstruction methodsFor!

description
	^'inline send #instVarAt:put: ', index printString.!

generateCodeFor: generator
	code := ByteArray with: 16r61 with: index.!

instructionCategory
	^#store.!

interpretFor: interpreter

	| value object |
	value := interpreter pop.
	object := interpreter pop.
	object namedSlotAt: index + 1 put: value! !
!PstStoreAnyInstVarInstruction categoriesFor: #description!printing!public! !
!PstStoreAnyInstVarInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstStoreAnyInstVarInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstStoreAnyInstVarInstruction categoriesFor: #interpretFor:!interpreting!public! !



PstPushCharacterInstruction comment: ''!

PstPushCharacterInstruction guid: (GUID fromString: '{004FC54A-87F9-423F-BEA0-09BC6E534C0F}')!

!PstPushCharacterInstruction categoriesForClass!No category! !
!PstPushCharacterInstruction methodsFor!

description
	^'push character $',
		(PstCharacterLiteralNode literalStringFor: value value).!

estimatedCompiledSize
	^2.!

generateCodeFor: generator
	code := ByteArray 
		with: 16rF6 
		with: value value asInteger.!

possiblySentSelectorsDo: block
	^self.! !
!PstPushCharacterInstruction categoriesFor: #description!printing!public! !
!PstPushCharacterInstruction categoriesFor: #estimatedCompiledSize!accessing!public! !
!PstPushCharacterInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstPushCharacterInstruction categoriesFor: #possiblySentSelectorsDo:!accessing!public! !



PstPushClassInstruction comment: ''!

PstPushClassInstruction guid: (GUID fromString: '{42F31C7B-B5EF-4EEA-BFFD-92B967161561}')!

!PstPushClassInstruction categoriesForClass!No category! !
!PstPushClassInstruction methodsFor!

description
	^'push class: ', value,
		(isMeta ifTrue: [' class'] ifFalse: ['']).!

generateCodeFor: generator
	| index class |
	(generator system classLibrary hasClassNamed: value)
		ifFalse: [generator generationError: 'No class named ', value].
	class := generator system classLibrary classNamed: value.
	isMeta ifTrue: [class := class qclass].
	index := generator indexOfObject: class.
	self
		generatePushObjectIndex: index
		for: generator.!

interpretFor: interpreter

	| class |
	class := interpreter system classLibrary classNamed: value.
	isMeta ifTrue: [
		class := class qclass].
	interpreter push: class!

isMeta
	^isMeta.!

isMeta: object
	isMeta := object.!

possiblySentSelectorsDo: block
	^self.!

referencedClass
	^(PstClassLibrary current hasClassNamed: value)
		ifTrue: [PstClassLibrary current classNamed: value]
		ifFalse: [nil].!

referencesClassNamed: className
	^className = value.!

refersToLiteral: anotherValue
	^anotherValue isBehaviorObject
		and: [anotherValue isMeta == isMeta
		and: [(isMeta 
			ifTrue: [anotherValue uniqueInstance]
			ifFalse: [anotherValue]) name = value]].! !
!PstPushClassInstruction categoriesFor: #description!printing!public! !
!PstPushClassInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstPushClassInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstPushClassInstruction categoriesFor: #isMeta!accessing!public! !
!PstPushClassInstruction categoriesFor: #isMeta:!accessing!public! !
!PstPushClassInstruction categoriesFor: #possiblySentSelectorsDo:!accessing!public! !
!PstPushClassInstruction categoriesFor: #referencedClass!accessing!public! !
!PstPushClassInstruction categoriesFor: #referencesClassNamed:!predicates!public! !
!PstPushClassInstruction categoriesFor: #refersToLiteral:!predicates!public! !



PstPushCleanBlockInstruction comment: ''!

PstPushCleanBlockInstruction guid: (GUID fromString: '{212E3874-C376-4A84-B5B7-8A90565A86EA}')!

!PstPushCleanBlockInstruction categoriesForClass!No category! !
!PstPushCleanBlockInstruction methodsFor!

argumentCount
	^argumentCount.!

argumentCount: object
	argumentCount := object.!

description
	^'push clean block'.!

generateCodeFor: generator
	| block |
	block := PstBlockClosure newCleanClosure.
	block home: homeClass.
	block argumentCount: argumentCount.
	generator
		deferCleanBlock: block
		forSelector: value.
	self
		generatePushObjectIndex: (generator indexOfObject: block)
		for: generator.
	block offset: startIndex + 2 + code size.!

homeClass
	^homeClass.!

homeClass: object
	homeClass := object.!

interpretFor: interpreter
	interpreter pushCleanBlock: argumentCount.!

possiblySentSelectorsDo: block
	^self.!

refersToLiteral: anotherValue
	^false.! !
!PstPushCleanBlockInstruction categoriesFor: #argumentCount!accessing!public! !
!PstPushCleanBlockInstruction categoriesFor: #argumentCount:!accessing!public! !
!PstPushCleanBlockInstruction categoriesFor: #description!printing!public! !
!PstPushCleanBlockInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstPushCleanBlockInstruction categoriesFor: #homeClass!accessing!public! !
!PstPushCleanBlockInstruction categoriesFor: #homeClass:!accessing!public! !
!PstPushCleanBlockInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstPushCleanBlockInstruction categoriesFor: #possiblySentSelectorsDo:!accessing!public! !
!PstPushCleanBlockInstruction categoriesFor: #refersToLiteral:!predicates!public! !



PstPushConstantInstruction comment: ''!

PstPushConstantInstruction guid: (GUID fromString: '{407230D6-AEA5-4728-9E16-DA0DBDAC7B48}')!

!PstPushConstantInstruction categoriesForClass!No category! !
!PstPushConstantInstruction methodsFor!

description
	^'push constant: ', value displayString.!

generateCodeFor: generator
	"hack :)"
	| temp |
	temp := value.
	value := value value.
	super generateCodeFor: generator.
	value := temp.!

interpretFor: interpreter
	interpreter push: value value.!

possiblySentSelectorsDo: block
	value value embeddedSelectorsDo: block.!

refersToConstant: constant
	^constant == value.!

refersToLiteral: anotherValue
	^value value equals: anotherValue.! !
!PstPushConstantInstruction categoriesFor: #description!printing!public! !
!PstPushConstantInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstPushConstantInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstPushConstantInstruction categoriesFor: #possiblySentSelectorsDo:!accessing!public! !
!PstPushConstantInstruction categoriesFor: #refersToConstant:!predicates!public! !
!PstPushConstantInstruction categoriesFor: #refersToLiteral:!predicates!public! !



PstDirectedSendInstruction comment: ''!

PstDirectedSendInstruction guid: (GUID fromString: '{7C7BD6F6-CA11-4534-A258-0CFEC358EE18}')!

!PstDirectedSendInstruction categoriesForClass!No category! !
!PstDirectedSendInstruction methodsFor!

canAbbreviate: selectorIndex

	^false.!

description

	^'directed send ', selector, ' to ', self receiverName.!

estimatedCompiledSize

	^3.!

generateCodeFor: generator

	| index |
	index := generator indexOfSelector: self selector.
	code := ByteArray
		with: self longByte
		with: argumentCount
		with: ((index bitShift: -8) bitAnd: 16rFF)
		with: (index bitAnd: 16rFF).!

inlineIndex

	^nil.!

interpretFor: interpreter

	interpreter
		directedSend: selector
		argumentCount: argumentCount!

longByte

	^16r66.!

shortByte

	self shouldNotImplement.! !
!PstDirectedSendInstruction categoriesFor: #canAbbreviate:!code generation!public! !
!PstDirectedSendInstruction categoriesFor: #description!printing!public! !
!PstDirectedSendInstruction categoriesFor: #estimatedCompiledSize!accessing!public! !
!PstDirectedSendInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstDirectedSendInstruction categoriesFor: #inlineIndex!code generation!public! !
!PstDirectedSendInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstDirectedSendInstruction categoriesFor: #longByte!code generation!public! !
!PstDirectedSendInstruction categoriesFor: #shortByte!*-should not implement!code generation!public! !



PstSendSelfInstruction comment: ''!

PstSendSelfInstruction guid: (GUID fromString: '{010DB8CD-0567-47D4-AAE9-CE9CD19BE837}')!

!PstSendSelfInstruction categoriesForClass!No category! !
!PstSendSelfInstruction methodsFor!

estimatedCompiledSize
	^3.!

inlineIndex
	^nil.!

instructionCategory
	^#sendSelf.!

interpretFor: interpreter
	interpreter
		sendSelf: selector
		argumentCount: argumentCount.!

longByte
	^16r70.!

receiverName
	^' to self'.!

sendsToSelf
	^true.!

shortByte
	^16rA0.! !
!PstSendSelfInstruction categoriesFor: #estimatedCompiledSize!accessing!public! !
!PstSendSelfInstruction categoriesFor: #inlineIndex!code generation!public! !
!PstSendSelfInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstSendSelfInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstSendSelfInstruction categoriesFor: #longByte!code generation!public! !
!PstSendSelfInstruction categoriesFor: #receiverName!printing!public! !
!PstSendSelfInstruction categoriesFor: #sendsToSelf!predicates!public! !
!PstSendSelfInstruction categoriesFor: #shortByte!code generation!public! !



PstSendSuperInstruction comment: ''!

PstSendSuperInstruction guid: (GUID fromString: '{033BDB15-97C6-408F-B27F-FE5AF7595F3C}')!

!PstSendSuperInstruction categoriesForClass!No category! !
!PstSendSuperInstruction methodsFor!

canAbbreviate: selectorIndex
	^false.!

estimatedCompiledSize
	^3.!

inlineIndex
	^nil.
!

instructionCategory
	^#sendSuper.!

interpretFor: interpreter
	interpreter
		sendSuper: selector
		argumentCount: argumentCount.!

longByte
	^16r90.!

receiverName
	^' to super'.!

sendsToSelf
	^true.!

shortByte
	self shouldNotImplement.! !
!PstSendSuperInstruction categoriesFor: #canAbbreviate:!code generation!public! !
!PstSendSuperInstruction categoriesFor: #estimatedCompiledSize!accessing!public! !
!PstSendSuperInstruction categoriesFor: #inlineIndex!code generation!public! !
!PstSendSuperInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstSendSuperInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstSendSuperInstruction categoriesFor: #longByte!code generation!public! !
!PstSendSuperInstruction categoriesFor: #receiverName!printing!public! !
!PstSendSuperInstruction categoriesFor: #sendsToSelf!predicates!public! !
!PstSendSuperInstruction categoriesFor: #shortByte!*-should not implement!code generation!public! !



PstSendWithReceiverOnTopInstruction comment: ''!

PstSendWithReceiverOnTopInstruction guid: (GUID fromString: '{69CD1615-CAA2-47B5-999E-67BF5F5C08DB}')!

!PstSendWithReceiverOnTopInstruction categoriesForClass!No category! !
!PstSendWithReceiverOnTopInstruction methodsFor!

description

	^'send ', selector, ' to ', self receiverName, ' (receiver on top)'!

generateCodeFor: generator

	| index |
	index := generator indexOfSelector: self selector.
	code := (ByteArray new: 4)
		at: 1 put: 16r65;
		at: 2 put: self argumentCount;
		at: 3 put: ((index bitShift: -8) bitAnd: 16rFF);
		at: 4 put: (index bitAnd: 16rFF);
		yourself!

inlineIndex

	^nil!

interpretFor: interpreter

	(self class canInline: selector) ifTrue: [
		self error: 'Not supported yet, should it be ?'].
	interpreter 
		receiverOnTopSend: selector
		argumentCount: argumentCount.
! !
!PstSendWithReceiverOnTopInstruction categoriesFor: #description!printing!public! !
!PstSendWithReceiverOnTopInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstSendWithReceiverOnTopInstruction categoriesFor: #inlineIndex!code generation!public! !
!PstSendWithReceiverOnTopInstruction categoriesFor: #interpretFor:!interpreting!public! !



PstPushSharedVarInstruction comment: ''!

PstPushSharedVarInstruction guid: (GUID fromString: '{F2425EC2-F8B7-4239-9D30-5D80D1CD3B33}')!

!PstPushSharedVarInstruction categoriesForClass!No category! !
!PstPushSharedVarInstruction methodsFor!

instructionCategory
	^#fetch.!

interpretFor: interpreter
	interpreter push:
		(interpreter system globals
			fetchGlobalForClass: ownerClass
			variableName: variableName).!

longBytecode
	^16r63.!

shortBytecode
	^16rF4.!

typeString
	^'push'.! !
!PstPushSharedVarInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstPushSharedVarInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstPushSharedVarInstruction categoriesFor: #longBytecode!code generation!public! !
!PstPushSharedVarInstruction categoriesFor: #shortBytecode!code generation!public! !
!PstPushSharedVarInstruction categoriesFor: #typeString!printing!public! !



PstStoreSharedVarInstruction comment: ''!

PstStoreSharedVarInstruction guid: (GUID fromString: '{3C8F87E6-E806-46BC-8236-737DD80A281E}')!

!PstStoreSharedVarInstruction categoriesForClass!No category! !
!PstStoreSharedVarInstruction methodsFor!

instructionCategory
	^#store.!

interpretFor: interpreter
	interpreter system globals
		storeGlobalForClass: ownerClass
		variableName: variableName
		with: interpreter pop.!

longBytecode
	^16r64.!

shortBytecode
	^16rF5.!

typeString
	^'store'.! !
!PstStoreSharedVarInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstStoreSharedVarInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstStoreSharedVarInstruction categoriesFor: #longBytecode!code generation!public! !
!PstStoreSharedVarInstruction categoriesFor: #shortBytecode!code generation!public! !
!PstStoreSharedVarInstruction categoriesFor: #typeString!printing!public! !



PstGeosMessageInstruction comment: ''!

PstGeosMessageInstruction guid: (GUID fromString: '{ED379CE7-C812-492B-89A2-B50BFADA9E45}')!

!PstGeosMessageInstruction categoriesForClass!No category! !
!PstGeosMessageInstruction methodsFor!

arguments
	^ arguments!

arguments: nargs
	arguments := nargs!

description
	| qualifier |
	qualifier := ignoreReturn
		ifTrue: [', ignore return value']
		ifFalse: [''].
	^'GEOS ', trapName displayString, ', ', arguments displayString, ' arguments', qualifier.!

generateCodeFor: generator
	trapName = 'call'
		ifTrue: [
			code := ignoreReturn
				ifTrue: [#[16rFD]] ifFalse: [#[16rFC]]
		]
		ifFalse: [
			code := ignoreReturn
				ifTrue: [#[16rFB]] ifFalse: [#[16rFA]]
		].
	code := code, (ByteArray with: arguments).
	"code := code, self trap bytecodes."!

trap
	^PstGeosAPI messageNamed: trapName.
! !
!PstGeosMessageInstruction categoriesFor: #arguments!*-unclassified!public! !
!PstGeosMessageInstruction categoriesFor: #arguments:!*-unclassified!public! !
!PstGeosMessageInstruction categoriesFor: #description!*-unclassified!public! !
!PstGeosMessageInstruction categoriesFor: #generateCodeFor:!*-unclassified!public! !
!PstGeosMessageInstruction categoriesFor: #trap!*-unclassified!public! !



PstPushInstVarInstruction comment: ''!

PstPushInstVarInstruction guid: (GUID fromString: '{2285A620-34B5-47EE-B1DA-359B3E2674A2}')!

!PstPushInstVarInstruction categoriesForClass!No category! !
!PstPushInstVarInstruction methodsFor!

generateCodeFor: generator
	distance = 0
		ifTrue: [
			self
				generateInnerAccess: index
				shortBytecode: 16r00
				longBytecode: 16rF0]
		ifFalse: [
			self generateOuterAccessFor: generator].!

generateOuterAccessFor: generator
	code := distance = 1
		ifTrue: [ByteArray with: 16rB2 with: index]
		ifFalse: [ByteArray with: 16rBB with: index with: distance].!

instructionCategory
	^#fetch.!

interpretFor: interpreter
	| receiver |
	receiver := interpreter outerReceiver: distance.
	receiver isNil
		ifTrue: [
			interpreter push: PstBasicObject forNil.
			^interpreter 
				sendSelf: 'contextAlreadyReturned'
				argumentCount: 0].
	interpreter push: (receiver namedSlotAt: index + 1).!

isPush
	^true.!

opDescription
	^'push instance variable'.!

refersToInstanceVariable
	^true.!

refersToInstanceVariable: instVarName
	^variableName = instVarName.! !
!PstPushInstVarInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstPushInstVarInstruction categoriesFor: #generateOuterAccessFor:!code generation!public! !
!PstPushInstVarInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstPushInstVarInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstPushInstVarInstruction categoriesFor: #isPush!predicates!public! !
!PstPushInstVarInstruction categoriesFor: #opDescription!printing!public! !
!PstPushInstVarInstruction categoriesFor: #refersToInstanceVariable!predicates!public! !
!PstPushInstVarInstruction categoriesFor: #refersToInstanceVariable:!predicates!public! !



PstPushLocalInstruction comment: ''!

PstPushLocalInstruction guid: (GUID fromString: '{D536F6A8-D452-4D84-A4AC-78C4264931EE}')!

!PstPushLocalInstruction categoriesForClass!No category! !
!PstPushLocalInstruction methodsFor!

generateCodeFor: generator
	distance = 0
		ifTrue: [
			self
				generateInnerAccess: index
				shortBytecode: 16r20
				longBytecode: 16rF2]
		ifFalse: [
			self generateOuterAccessFor: generator].!

generateOuterAccessFor: generator
	distance > 255 ifTrue: [
		generator generationError: 'Too many nested blocks'].
	distance = 1
		ifTrue: [
			"Next outer scope"
			code := ByteArray
				with: 16rB4
				with: index]
		ifFalse: [
			code := ByteArray
				with: 16rB6
				with: index
				with: distance].!

instructionCategory
	^#fetch.!

interpretFor: interpreter
	distance == 0
		ifTrue: [interpreter pushLocal: index]
		ifFalse: [interpreter pushLocal: index outer: distance].!

isPush
	^true.!

opDescription
	^'push local variable'.!

refersToInstanceVariable
	^false.! !
!PstPushLocalInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstPushLocalInstruction categoriesFor: #generateOuterAccessFor:!code generation!public! !
!PstPushLocalInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstPushLocalInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstPushLocalInstruction categoriesFor: #isPush!predicates!public! !
!PstPushLocalInstruction categoriesFor: #opDescription!printing!public! !
!PstPushLocalInstruction categoriesFor: #refersToInstanceVariable!predicates!public! !



PstStoreInstVarInstruction comment: ''!

PstStoreInstVarInstruction guid: (GUID fromString: '{23449EED-1B39-49A3-A5FD-CAD71902A8DF}')!

!PstStoreInstVarInstruction categoriesForClass!No category! !
!PstStoreInstVarInstruction methodsFor!

generateCodeFor: generator
	distance = 0
		ifTrue: [
			self
				generateInnerAccess: index
				shortBytecode: 16r10
				longBytecode: 16rF1]
		ifFalse: [
			self generateOuterAccessFor: generator].!

generateOuterAccessFor: generator
	code := distance = 1
		ifTrue: [ByteArray with: 16rB3 with: index]
		ifFalse: [ByteArray with: 16rBC with: index with: distance].!

instructionCategory
	^#store.!

interpretFor: interpreter
	| receiver |
	receiver := interpreter outerReceiver: distance.
	receiver isNil ifTrue: [
		^interpreter 
			pop;
			send: 'contextAlreadyReturned' argumentCount: 0].
	receiver
		namedSlotAt: index + 1
		put: interpreter pop.!

isPush
	^false.!

opDescription
	^'store instance variable'.!

refersToInstanceVariable
	^true.!

refersToInstanceVariable: instVarName
	^variableName = instVarName.! !
!PstStoreInstVarInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstStoreInstVarInstruction categoriesFor: #generateOuterAccessFor:!code generation!public! !
!PstStoreInstVarInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstStoreInstVarInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstStoreInstVarInstruction categoriesFor: #isPush!predicates!public! !
!PstStoreInstVarInstruction categoriesFor: #opDescription!printing!public! !
!PstStoreInstVarInstruction categoriesFor: #refersToInstanceVariable!predicates!public! !
!PstStoreInstVarInstruction categoriesFor: #refersToInstanceVariable:!predicates!public! !



PstStoreLocalInstruction comment: ''!

PstStoreLocalInstruction guid: (GUID fromString: '{4D41794A-03F8-46C2-AC88-34734161D784}')!

!PstStoreLocalInstruction categoriesForClass!No category! !
!PstStoreLocalInstruction methodsFor!

generateCodeFor: generator
	distance = 0
		ifTrue: [
			self
				generateInnerAccess: index
				shortBytecode: 16r30
				longBytecode: 16rF3]
		ifFalse: [
			self generateOuterAccessFor: generator].!

generateOuterAccessFor: generator
	distance > 255 ifTrue: [
		generator generationError: 'Too many nested blocks'].
	distance = 1
		ifTrue: [
			"Next outer scope"
			code := ByteArray
				with: 16rB5
				with: index]
		ifFalse: [
			code := ByteArray
				with: 16rB7
				with: index
				with: distance].!

instructionCategory
	^#store.!

interpretFor: interpreter
	distance == 0
		ifTrue: [interpreter storeLocal: index]
		ifFalse: [interpreter storeLocal: index outer: distance].!

isPush
	^false.!

opDescription
	^'store local variable'.!

refersToInstanceVariable
	^false.! !
!PstStoreLocalInstruction categoriesFor: #generateCodeFor:!code generation!public! !
!PstStoreLocalInstruction categoriesFor: #generateOuterAccessFor:!code generation!public! !
!PstStoreLocalInstruction categoriesFor: #instructionCategory!accessing!public! !
!PstStoreLocalInstruction categoriesFor: #interpretFor:!interpreting!public! !
!PstStoreLocalInstruction categoriesFor: #isPush!predicates!public! !
!PstStoreLocalInstruction categoriesFor: #opDescription!printing!public! !
!PstStoreLocalInstruction categoriesFor: #refersToInstanceVariable!predicates!public! !



PstSmalltalkObject comment: ''!

PstSmalltalkObject guid: (GUID fromString: '{CE2A66BC-2AC4-42AB-950C-5B6FF2CD06A3}')!

!PstSmalltalkObject categoriesForClass!No category! !
!PstSmalltalkObject methodsFor!

basicHash
	^super hash!

canBecome
	"Answer whether the receiver can be affected by the 'become:' primitive."
	^true.!

compileBodyFor: generator
	^self subclassResponsibility.!

compileFor: codeGenerator
	codeGenerator
		beginObject: self
		ofSize: self sizeInWords
		class: self qclass.
	self compileBodyFor: codeGenerator.
	codeGenerator endObject.!

hasIndexedSlotAt: index
	^index between: 1 and: self indexedSlotCount.!

indexedSlotAt: index
	^self error: 'not indexed'.!

indexedSlotAt: index put: value
	^self error: 'not indexed'.!

indexedSlotCount
	^0.!

indexedSlots
	^(1 to: self indexedSlotCount)
		collect: [:n | self indexedSlotAt: n].!

isBehaviorObject
	^false.!

isBlockClosure
	^false.!

isCharacterObject
	^false.!

isDoubleObject
	^false.!

isImmediate
	^false.!

isIntegerObject
	^false.!

isSymbolObject
	^false.!

isTile
	^false.!

simulatedIdentityHash
	^self basicHash.!

sizeInWords
	^self namedSlotCount.! !
!PstSmalltalkObject categoriesFor: #basicHash!*-unclassified!public! !
!PstSmalltalkObject categoriesFor: #canBecome!predicates!public! !
!PstSmalltalkObject categoriesFor: #compileBodyFor:!*-subclass responsibility!compiling!public! !
!PstSmalltalkObject categoriesFor: #compileFor:!compiling!public! !
!PstSmalltalkObject categoriesFor: #hasIndexedSlotAt:!predicates!public! !
!PstSmalltalkObject categoriesFor: #indexedSlotAt:!public!slot accessing! !
!PstSmalltalkObject categoriesFor: #indexedSlotAt:put:!public!slot accessing! !
!PstSmalltalkObject categoriesFor: #indexedSlotCount!public!slot accessing! !
!PstSmalltalkObject categoriesFor: #indexedSlots!public!slot accessing! !
!PstSmalltalkObject categoriesFor: #isBehaviorObject!predicates!public! !
!PstSmalltalkObject categoriesFor: #isBlockClosure!predicates!public! !
!PstSmalltalkObject categoriesFor: #isCharacterObject!predicates!public! !
!PstSmalltalkObject categoriesFor: #isDoubleObject!predicates!public! !
!PstSmalltalkObject categoriesFor: #isImmediate!predicates!public! !
!PstSmalltalkObject categoriesFor: #isIntegerObject!predicates!public! !
!PstSmalltalkObject categoriesFor: #isSymbolObject!predicates!public! !
!PstSmalltalkObject categoriesFor: #isTile!predicates!public! !
!PstSmalltalkObject categoriesFor: #simulatedIdentityHash!comparing!public! !
!PstSmalltalkObject categoriesFor: #sizeInWords!accessing!public! !



PstBasicObject comment: ''!

PstBasicObject guid: (GUID fromString: '{3DF249C0-0360-49B2-B82E-5F65248C9223}')!

!PstBasicObject categoriesForClass!No category! !
!PstBasicObject methodsFor!

canBecome
	^false.!

compileBodyFor: generator
	^self.!

copy
	^self.!

displayOn: stream
	self == TrueObject ifTrue: [^stream nextPutAll: 'true'].
	self == FalseObject ifTrue: [^stream nextPutAll: 'false'].
	self == NilObject ifTrue: [^stream nextPutAll: 'nil'].
	self error: 'hrm'.!

instVarsDo: block
	^self.!

namedSlotCount
	^0.  "redundant"! !
!PstBasicObject categoriesFor: #canBecome!predicates!public! !
!PstBasicObject categoriesFor: #compileBodyFor:!compiling!public! !
!PstBasicObject categoriesFor: #copy!copying!public! !
!PstBasicObject categoriesFor: #displayOn:!printing!public! !
!PstBasicObject categoriesFor: #instVarsDo:!compiling!public! !
!PstBasicObject categoriesFor: #namedSlotCount!public!slot accessing! !

!PstBasicObject class methodsFor!

createTrueFalseNil
	TrueObject := self forClass: 'True'.
	FalseObject := self forClass: 'False'.
	NilObject := self forClass: 'UndefinedObject'.!

forBoolean: boolean
	"Convert from host Smalltalk boolean."
	^boolean
		ifTrue: [self forTrue]
		ifFalse: [self forFalse].!

forCharacter
	^self forClass: 'Character'.!

forClass: className
	^self new qclass: 
		(PstSystem current classLibrary 
			classNamed: className).!

forFalse
	^FalseObject.!

forNil
	^NilObject.!

forTrue
	^TrueObject.! !
!PstBasicObject class categoriesFor: #createTrueFalseNil!bootstrapping!public! !
!PstBasicObject class categoriesFor: #forBoolean:!instance creation!public! !
!PstBasicObject class categoriesFor: #forCharacter!instance creation!public! !
!PstBasicObject class categoriesFor: #forClass:!instance creation!public! !
!PstBasicObject class categoriesFor: #forFalse!instance creation!public! !
!PstBasicObject class categoriesFor: #forNil!instance creation!public! !
!PstBasicObject class categoriesFor: #forTrue!instance creation!public! !



PstBehavior comment: ''!

PstBehavior guid: (GUID fromString: '{21C0C730-78AC-4533-87E3-8C58F2878CEE}')!

!PstBehavior categoriesForClass!No category! !
!PstBehavior methodsFor!

addCategory: category
	(categories includesKey: category)
		ifTrue: [^self].
	categories
		at: category
		put: OrderedCollection new.

"(SortedCollection sortBlock:
				[:left :right | left selector <= right selector])."!

allSuperclasses
	"Answer all the superclasses in the order: #(Object superclass1 superclass2...)"
	^superclass isNil
		ifTrue: [OrderedCollection new]
		ifFalse: [superclass allSuperclasses add: superclass; yourself].!

beOfType: subclassType
	| pointers indexable slots |
	pointers := subclassType = 'subclass:' 
		or: [subclassType = 'variableSubclass:'].
	indexable := subclassType = 'variableSubclass:'
		or: [subclassType = 'variableByteSubclass:'].
	slots := self instanceVariableCount.
	layout := pointers
		ifTrue: [
			self class 
				layoutForNormalObject: slots
				indexable: indexable]
		ifFalse: [self class layoutForPointerlessObject].!

beRemoved
	^self.!

canBecome
	^false.!

canHaveSubclassOfType: subclassType
	| myType |
	myType := self subclassType.
	myType = 'subclass:' ifTrue: [
		^subclassType = 'variableByteSubclass:'
			ifTrue: [self instanceVariableCount = 0]
			ifFalse: [true]].
	myType = 'variableSubclass:' ifTrue: [
		subclassType = 'subclass:' ifTrue: [^false].
		subclassType = 'variableSubclass:' ifTrue: [^true].
		subclassType = 'variableByteSubclass:'
			ifTrue: [^self instanceVariableCount = 0]].
	myType = 'variableByteSubclass:' ifTrue: [
		^subclassType = 'variableByteSubclass:'].
	self error: 'bad subclass type?'.!

categories
	^categories keys.!

categoryOfMethod: method
	categories keysAndValuesDo: [:category :methods |
		(methods includes: method) 
			ifTrue: [^category]].
	^self error: 'method not in any category'.!

classify: method as: category
	self quietlyClassify: method as: category.
	self classLibrary
		reclassifiedMethod: method
		of: self.!

classLibrary
	^PstClassLibrary current.!

compileBodyFor: generator
	generator
		compileObjectReference: superclass;
		storeInteger: layout.!

fileOutMethodsOn: manager
	categories keysAndValuesDo: [:category :methods |
		manager
			bang;
			nextPutAll: self displayString;
			nextPutAll: ' methodsFor: ';
			nextPutAll: category printString;
			bang; cr; cr.
		(methods select: [:each | each package isNil])
			do: [:each | manager nextPutAll: each sourceCode]
			separatedBy: [manager endChunk].
		manager bang; space; endChunk; cr].!

handleCompilerError: message
warning: isWarning
selector: selector
	"Handle non-interactive compiler errors."
	| stream |
	stream := String new writeStream.
	stream
		display: self;
		nextPutAll: '>>#';
		nextPutAll: selector.
	stream nextPutAll:
		(isWarning ifTrue: [' warning:'] ifFalse: [' error:']).
	stream
		cr;
		nextPutAll: message.
	MessageBox notify: stream contents.!

hasMetaclass
	^self qclass notNil.!

hasMethods
	^methodTable notEmpty.!

hasPointers
	^(self layout bitAnd: 8192) = 0.!

includesSelector: selector
	^methodTable includesKey: selector.!

indexOfInstanceVariable: instVarName
	self subclassResponsibility.!

inheritsFrom: behavior
	| ptr |
	ptr := self.
	[ptr notNil] whileTrue: [
		ptr == behavior
			ifTrue: [^true].
		ptr := ptr superclass].
	^false.!

initialize
	super initialize.
	methodTable := Dictionary new.
	categories := Dictionary new.!

installMethod: method classified: category
	| oldMethod |
	(methodTable includesKey: method selector) ifTrue: [
		oldMethod := methodTable at: method selector.
		method package: oldMethod package.
		oldMethod package: nil.
		self uncategorizeMethod: oldMethod].
	methodTable 
		at: method selector 
		put: method.
	self quietlyClassify: method as: category.
	PstClassLibrary current
		addedMethod: method
		to: self.!

instanceVariableCount
	^self layout bitAnd: 4095.!

instantiate
	| instance |
	self isIndexable 
		ifTrue: [^self error: 'use #instantiateIndexed: to create indexable objects'].
	self isInstantiable 
		ifFalse: [^self error: 'Cannot create new instances of ', self name, ' at runtime.'].
	instance := PstNormalObject new.
	instance qclass: self.
	instance postInitialize.
	^instance.!

instantiateIndexed: size
	| instance |
	self isIndexable 
		ifFalse: [^self error: 'use #instantiate to create non-indexable objects'].
	self isInstantiable 
		ifFalse: [^self error: 'Cannot create new instances of ', self name, ' at runtime.'].
	(size between: 0 and: 4095)
		ifFalse: [^self error: 'Illegal indexed object size.'].
	instance := self hasPointers
		ifTrue: [PstIndexableObject new]
		ifFalse: [PstByteIndexableObject new].
	instance qclass: self.
	instance postInitialize.
	instance initializeIndexedSlots: size.
	^instance.!

instVarsDo: block
	"Don't visit superclass ... it's not necessary, and it messes up image generation."
	^self.!

isBehaviorObject
	^true.!

isIndexable
	^(self layout bitAnd: 4096) ~= 0.!

isInstantiable
	^self subclassResponsibility.!

isMeta
	self subclassResponsibility.!

layout
	^layout.!

layout: newLayout
	layout := newLayout.!

lookupMethod: selector
	"Ordinary Smalltalk method lookup.
Answers a PstMethod object if successful, or else nil."
	^methodTable
		at: selector
		ifAbsent: [
			superclass isNil
				ifTrue: [nil]
				ifFalse: [superclass lookupMethod: selector]].!

matchSelector: prefix
	| selector |
	^(selector := self matchSelectorHere: prefix) isNil
		ifTrue: [
			superclass isNil
				ifTrue: [nil]
				ifFalse: [superclass matchSelector: prefix]]
		ifFalse: [selector].!

matchSelectorHere: prefix
	"If this class implements a selector starting with the given prefix, answer the first keyword of that selector.  Otherwise, answer nil."
	| pattern index |
	pattern := prefix, '*'.
	methodTable keysDo: [:selector |
		(pattern match: selector) ifTrue: [
			index := selector indexOf: $:.
			^index == 0
				ifTrue: [selector]
				ifFalse: [selector copyFrom: 1 to: index]]].
	^nil.!

methodAt: selector
	^methodTable at: selector.!

methodCount
	^methodTable size.!

methods
	^methodTable values.!

methodsContainingString: string
	^methodTable select: [:each |
		each containsString: string].!

methodsDo: block
	methodTable do: block.!

methodsInCategory: category
	^(categories includesKey: category)
		ifTrue: [categories at: category]
		ifFalse: [#()].!

methodsReferencingClassNamed: className
	^methodTable select: [:each |
		each referencesClassNamed: className].!

methodsReferringTo: value
	^methodTable select: [:each |
		each refersToLiteral: value].
	!

methodsReferringToConstant: constant
	^methodTable select: [:each |
		each refersToConstant: constant].
	!

methodsReferringToInstanceVariable: instVarName
	^methodTable select: [:each |
		each refersToInstanceVariable: instVarName].
	!

methodsReferringToSharedVariable: variableName
	^methodTable select: [:each |
		each refersToSharedVariable: variableName].!

methodsSending: selector
	^methodTable select: [:each | each sends: selector].!

methodsWithSelector: selector
	^methodTable select: [:each |
		each selector = selector].!

methodTable
	^methodTable.!

methodTree
	| tree all |
	tree := TreeModel new.
	all := '(all)'.
	tree add: all asChildOf: nil.
	self sortedMethods do: [:method |
		tree 
			add: (PstQuasiMethod for: method)
			asChildOf: all].
	self sortedCategories do: [:category |
		tree add: category asChildOf: nil.
		(self class sortMethods: (categories at: category)) 
			do: [:each | tree add: each asChildOf: category]].
	^tree.!

name
	^self subclassResponsibility.!

namedSlotAt: index
	index = 1 ifTrue: [^superclass].
	index = 2 ifTrue: [^PstInteger value: layout].
	^self error: 'slot index out of bounds'.!

namedSlotAt: index put: value
	^self error: 'should not modify this object directly'.!

namedSlotCount
	^2.!

package
	^self subclassResponsibility.!

preferredCategoryOf: selector
	"The first superclass (if any) that has categorized the method determines the preferred category."
	"Answers nil if no superclasses categorize the method."
	| probe |
	probe := self superclass.
	[probe isNil] whileFalse: [
		(probe includesSelector: selector)
			ifTrue: [^probe categoryOfMethod: 
				(probe methodAt: selector)].
		probe := probe superclass].
	^nil.!

purgeEmptyCategories
	| empties |
	empties := categories keys select: [:each |
		(categories at: each) isEmpty].
	empties do: [:each | categories removeKey: each].!

quietlyClassify: method as: category
	"Assumes that method is not already categorized."
	(categories includesKey: category)
		ifFalse: [self addCategory: category].
	(categories at: category) add: method.
	self purgeEmptyCategories.!

reclassify: method as: category
	(self categoryOfMethod: method) = category
		ifTrue: [^self].
	self uncategorizeMethod: method.
	self classify: method as: category.!

recompileMethod: method reinstall: reinstall
	"Answer whether the compilation suceeded."
	| newMethod |
	[newMethod := PstSystem current qcompilerClass
			compile: method sourceCode
			in: self]
		on: PstCompilerError
		do: [:exception | 
			self 
				handleCompilerError: exception message
				warning: false
				selector: method selector.
			^false]
		on: PstCompilerWarning
		do: [:exception |
			self 
				handleCompilerError: exception message
				warning: true
				selector: method selector.
			exception resume].
	reinstall ifTrue: [
		"Just add it directly, since this is only used when recompiling a method in situ, and there is no need to update the browsers."
		methodTable
			at: newMethod selector
			put: newMethod.
		"Do, however, update the category table..."
		self
			updateMethod: method 
			to: newMethod].
	^true.!

removeAllCategories
	"Remove all categories and methods."
	self methodsDo: [:each | 
		self removeSelector: each selector].!

removeCategory: category
	"Remove all methods in the category."
	(self methodsInCategory: category)
		do: [:each | self removeSelector: each selector].!

removeSelector: selector
	| method |
	method := methodTable at: selector.
	self uncategorizeMethod: method.
	self purgeEmptyCategories.
	methodTable removeKey: selector.
	self classLibrary
		removedMethod: method
		from: self.!

removeSubclass: subclass
	^self.!

renameCategory: category to: newName
	| methods |
	methods := categories at: category.
	categories removeKey: category.
	self addCategory: newName.
	(self methodsInCategory: newName)
		addAll: methods.
	self classLibrary reclassifiedMethod: nil of: self.
	!

repackageMethods
	self methodsDo: [:each | each updatePackage].!

selectors
	^self methods collect: [:each | each selector].!

sizeInWords
	^2.!

sortedCategories
	^categories keys asSortedCollection.!

sortedMethods
	^self class sortMethods: self methods.!

subclassType
	"Answers one of the following strings, depending on the kind of class this is:
subclass:				normal subclass
variableSubclass:		indexable, with pointers
variableByteSubclass:	indexable, no pointers"
	^self hasPointers
		ifTrue: [
			self isIndexable
				ifTrue: ['variableSubclass:']
				ifFalse: ['subclass:']]
		ifFalse: ['variableByteSubclass:'].!

superclass
	^superclass.!

superclass: newSuperclass
	superclass := newSuperclass.!

uncategorizeMethod: method
	"Slow---scan each category for the method."
	categories do: [:each |
		each remove: method ifAbsent: []].!

updateMethod: oldMethod to: newMethod
	newMethod package: oldMethod package.
	oldMethod package: nil.
	categories keysAndValuesDo: [:category :methods |
		1 to: methods size do: [:n |
			(methods at: n) == oldMethod
				ifTrue: [^methods at: n put: newMethod]]].
	self error.!

withAllSuperclasses
	^self allSuperclasses
		add: self;
		yourself.! !
!PstBehavior categoriesFor: #addCategory:!categories!public! !
!PstBehavior categoriesFor: #allSuperclasses!accessing!public! !
!PstBehavior categoriesFor: #beOfType:!public!utility! !
!PstBehavior categoriesFor: #beRemoved!public!utility! !
!PstBehavior categoriesFor: #canBecome!predicates!public! !
!PstBehavior categoriesFor: #canHaveSubclassOfType:!predicates!public! !
!PstBehavior categoriesFor: #categories!categories!public! !
!PstBehavior categoriesFor: #categoryOfMethod:!categories!public! !
!PstBehavior categoriesFor: #classify:as:!categories!public! !
!PstBehavior categoriesFor: #classLibrary!accessing!public! !
!PstBehavior categoriesFor: #compileBodyFor:!compiling!public! !
!PstBehavior categoriesFor: #fileOutMethodsOn:!fileout!public! !
!PstBehavior categoriesFor: #handleCompilerError:warning:selector:!public!recompiling! !
!PstBehavior categoriesFor: #hasMetaclass!predicates!public! !
!PstBehavior categoriesFor: #hasMethods!predicates!public! !
!PstBehavior categoriesFor: #hasPointers!layout!public! !
!PstBehavior categoriesFor: #includesSelector:!methods!public! !
!PstBehavior categoriesFor: #indexOfInstanceVariable:!*-subclass responsibility!accessing!public! !
!PstBehavior categoriesFor: #inheritsFrom:!public!subclasses! !
!PstBehavior categoriesFor: #initialize!initialization!public! !
!PstBehavior categoriesFor: #installMethod:classified:!methods!public! !
!PstBehavior categoriesFor: #instanceVariableCount!layout!public! !
!PstBehavior categoriesFor: #instantiate!instance creation!public! !
!PstBehavior categoriesFor: #instantiateIndexed:!instance creation!public! !
!PstBehavior categoriesFor: #instVarsDo:!compiling!public! !
!PstBehavior categoriesFor: #isBehaviorObject!predicates!public! !
!PstBehavior categoriesFor: #isIndexable!layout!public! !
!PstBehavior categoriesFor: #isInstantiable!*-subclass responsibility!predicates!public! !
!PstBehavior categoriesFor: #isMeta!*-subclass responsibility!predicates!public! !
!PstBehavior categoriesFor: #layout!accessing!public! !
!PstBehavior categoriesFor: #layout:!accessing!public! !
!PstBehavior categoriesFor: #lookupMethod:!methods!public! !
!PstBehavior categoriesFor: #matchSelector:!public!utility! !
!PstBehavior categoriesFor: #matchSelectorHere:!public!utility! !
!PstBehavior categoriesFor: #methodAt:!methods!public! !
!PstBehavior categoriesFor: #methodCount!accessing!public! !
!PstBehavior categoriesFor: #methods!methods!public! !
!PstBehavior categoriesFor: #methodsContainingString:!methods!public! !
!PstBehavior categoriesFor: #methodsDo:!methods!public! !
!PstBehavior categoriesFor: #methodsInCategory:!categories!public! !
!PstBehavior categoriesFor: #methodsReferencingClassNamed:!methods!public! !
!PstBehavior categoriesFor: #methodsReferringTo:!methods!public! !
!PstBehavior categoriesFor: #methodsReferringToConstant:!methods!public! !
!PstBehavior categoriesFor: #methodsReferringToInstanceVariable:!methods!public! !
!PstBehavior categoriesFor: #methodsReferringToSharedVariable:!methods!public! !
!PstBehavior categoriesFor: #methodsSending:!methods!public! !
!PstBehavior categoriesFor: #methodsWithSelector:!methods!public! !
!PstBehavior categoriesFor: #methodTable!accessing!public! !
!PstBehavior categoriesFor: #methodTree!categories!public! !
!PstBehavior categoriesFor: #name!*-subclass responsibility!accessing!public! !
!PstBehavior categoriesFor: #namedSlotAt:!public!slot accessing! !
!PstBehavior categoriesFor: #namedSlotAt:put:!public!slot accessing! !
!PstBehavior categoriesFor: #namedSlotCount!public!slot accessing! !
!PstBehavior categoriesFor: #package!*-subclass responsibility!accessing!public! !
!PstBehavior categoriesFor: #preferredCategoryOf:!categories!public! !
!PstBehavior categoriesFor: #purgeEmptyCategories!categories!public! !
!PstBehavior categoriesFor: #quietlyClassify:as:!categories!public! !
!PstBehavior categoriesFor: #reclassify:as:!categories!public! !
!PstBehavior categoriesFor: #recompileMethod:reinstall:!compiling!public! !
!PstBehavior categoriesFor: #removeAllCategories!categories!public! !
!PstBehavior categoriesFor: #removeCategory:!categories!public! !
!PstBehavior categoriesFor: #removeSelector:!methods!public! !
!PstBehavior categoriesFor: #removeSubclass:!public!subclasses! !
!PstBehavior categoriesFor: #renameCategory:to:!categories!public! !
!PstBehavior categoriesFor: #repackageMethods!methods!public! !
!PstBehavior categoriesFor: #selectors!methods!public! !
!PstBehavior categoriesFor: #sizeInWords!accessing!public! !
!PstBehavior categoriesFor: #sortedCategories!categories!public! !
!PstBehavior categoriesFor: #sortedMethods!methods!public! !
!PstBehavior categoriesFor: #subclassType!accessing!public! !
!PstBehavior categoriesFor: #superclass!accessing!public! !
!PstBehavior categoriesFor: #superclass:!accessing!public! !
!PstBehavior categoriesFor: #uncategorizeMethod:!categories!public! !
!PstBehavior categoriesFor: #updateMethod:to:!categories!public! !
!PstBehavior categoriesFor: #withAllSuperclasses!accessing!public! !

!PstBehavior class methodsFor!

layoutForNormalObject: instanceVariableCount
indexable: indexable
	^indexable
		ifTrue: [instanceVariableCount bitOr: 4096]
		ifFalse: [instanceVariableCount].!

layoutForPointerlessObject
	^8192 bitOr: 4096.!

sortClassList: classes
	| sorted |
	sorted := SortedCollection sortBlock: 
		[:left :right | left name <= right name].
	sorted addAll: classes.
	^sorted asOrderedCollection.
!

sortMethods: methods
	^methods asSortedCollection:
		[:left :right | left selector <= right selector].
! !
!PstBehavior class categoriesFor: #layoutForNormalObject:indexable:!layout values!public! !
!PstBehavior class categoriesFor: #layoutForPointerlessObject!layout values!public! !
!PstBehavior class categoriesFor: #sortClassList:!public!utility! !
!PstBehavior class categoriesFor: #sortMethods:!public!utility! !



PstBlockClosure comment: ''!

PstBlockClosure guid: (GUID fromString: '{ABCB5F8C-3690-4C3F-B016-35B3297E67D8}')!

!PstBlockClosure categoriesForClass!No category! !
!PstBlockClosure methodsFor!

argumentCount
	^argumentCount.!

argumentCount: object
	argumentCount := object.!

compileBodyFor: generator
	generator 
		compileObjectReference: home;
		storeInteger: offset;
		storeInteger: argumentCount.!

home
	^home.!

home: object
	home := object.!

instVarsDo: block
	^self.!

isBlockClosure
	^true.!

isFullBlockClosure
	^false.!

offset
	^offset.!

offset: object
	offset := object.!

sizeInWords
	^3.!

slotNames
	^#().! !
!PstBlockClosure categoriesFor: #argumentCount!accessing!public! !
!PstBlockClosure categoriesFor: #argumentCount:!accessing!public! !
!PstBlockClosure categoriesFor: #compileBodyFor:!compiling!public! !
!PstBlockClosure categoriesFor: #home!accessing!public! !
!PstBlockClosure categoriesFor: #home:!accessing!public! !
!PstBlockClosure categoriesFor: #instVarsDo:!compiling!public! !
!PstBlockClosure categoriesFor: #isBlockClosure!predicates!public! !
!PstBlockClosure categoriesFor: #isFullBlockClosure!predicates!public! !
!PstBlockClosure categoriesFor: #offset!accessing!public! !
!PstBlockClosure categoriesFor: #offset:!accessing!public! !
!PstBlockClosure categoriesFor: #sizeInWords!accessing!public! !
!PstBlockClosure categoriesFor: #slotNames!accessing!public! !

!PstBlockClosure class methodsFor!

newCleanClosure
	^self new qclass: 
		(PstSystem current classLibrary 
			classNamed: 'BlockClosure').! !
!PstBlockClosure class categoriesFor: #newCleanClosure!instance creation!public! !



PstDouble comment: ''!

PstDouble guid: (GUID fromString: '{910B7865-C250-40C4-9F7E-3CC290A3115F}')!

!PstDouble categoriesForClass!No category! !
!PstDouble methodsFor!

asBytes
	"compile in OS byte order..."
	| bytes |
	bytes := ByteArray new: value basicSize.
	PstSystem current doubleByteOrder keysAndValuesDo: [:r :n |
		bytes at: r put: (value basicAt: n)].
	^bytes.!

compileBodyFor: generator
	generator compileObjectBytes: self asBytes.!

displayOn: stream
	stream print: self value.!

identicalTo: anotherObject
	^value = anotherObject value.!

indexedSlotAt: index
	^PstInteger value: (value basicAt: index).!

indexedSlotAt: index put: byte
	self error: 'Doubles are read-only'.!

indexedSlotCount
	^8.!

instVarsDo: block
	^self.!

isDoubleObject
	^true.!

reallyEquals: object
	^value = object value.!

sizeInWords
	^5.  "not 4..."!

value
	^value.!

value: doubleValue
	value := doubleValue.! !
!PstDouble categoriesFor: #asBytes!accessing!public! !
!PstDouble categoriesFor: #compileBodyFor:!compiling!public! !
!PstDouble categoriesFor: #displayOn:!printing!public! !
!PstDouble categoriesFor: #identicalTo:!comparing!public! !
!PstDouble categoriesFor: #indexedSlotAt:!accessing!public! !
!PstDouble categoriesFor: #indexedSlotAt:put:!accessing!public! !
!PstDouble categoriesFor: #indexedSlotCount!accessing!public! !
!PstDouble categoriesFor: #instVarsDo:!compiling!public! !
!PstDouble categoriesFor: #isDoubleObject!predicates!public! !
!PstDouble categoriesFor: #reallyEquals:!comparing!public! !
!PstDouble categoriesFor: #sizeInWords!accessing!public! !
!PstDouble categoriesFor: #value!accessing!public! !
!PstDouble categoriesFor: #value:!accessing!public! !

!PstDouble class methodsFor!

value: doubleValue
	^self new
		qclass: (PstClassLibrary current classNamed: 'Double');
		value: doubleValue.! !
!PstDouble class categoriesFor: #value:!instance creation!public! !



PstInteger comment: ''!

PstInteger guid: (GUID fromString: '{C193FF28-FF7F-43B1-97FB-3006AFB4E365}')!

!PstInteger categoriesForClass!No category! !
!PstInteger methodsFor!

canBecome
	^false.!

compileBodyFor: generator
	self shouldNotImplement.!

copy
	^self.!

displayOn: stream
	stream print: self value.!

identicalTo: anotherObject
	"Simulate microcode VM behavior."
	^(super identicalTo: anotherObject)
		or: [anotherObject isIntegerObject
		and: [(value between: -16384 and: 16383)
		and: [value = anotherObject value]]].!

instVarsDo: block
	^self shouldNotImplement.!

isImmediate
	^true.!

isIntegerObject
	^true.!

isSmallIntegerObject
	^true.!

namedSlotCount
	^0.!

reallyEquals: object
	^value = object value.!

simulatedIdentityHash
	^value basicHash.!

sizeInWords
	^self shouldNotImplement.!

value
	^value.!

value: newValue
	value := newValue.! !
!PstInteger categoriesFor: #canBecome!predicates!public! !
!PstInteger categoriesFor: #compileBodyFor:!*-should not implement!compiling!public! !
!PstInteger categoriesFor: #copy!copying!public! !
!PstInteger categoriesFor: #displayOn:!printing!public! !
!PstInteger categoriesFor: #identicalTo:!comparing!public! !
!PstInteger categoriesFor: #instVarsDo:!*-should not implement!compiling!public! !
!PstInteger categoriesFor: #isImmediate!predicates!public! !
!PstInteger categoriesFor: #isIntegerObject!predicates!public! !
!PstInteger categoriesFor: #isSmallIntegerObject!predicates!public! !
!PstInteger categoriesFor: #namedSlotCount!accessing!public! !
!PstInteger categoriesFor: #reallyEquals:!comparing!public! !
!PstInteger categoriesFor: #simulatedIdentityHash!comparing!public! !
!PstInteger categoriesFor: #sizeInWords!*-should not implement!accessing!public! !
!PstInteger categoriesFor: #value!accessing!public! !
!PstInteger categoriesFor: #value:!accessing!public! !

!PstInteger class methodsFor!

value: integer
	^(integer between: -16384 and: 16383)
		ifTrue: [
			self new 
				qclass: PstClassLibrary current smallIntegerClass;
				value: integer]
		ifFalse: [PstLongInteger value: integer].! !
!PstInteger class categoriesFor: #value:!instance creation!public! !



PstNormalObject comment: ''!

PstNormalObject guid: (GUID fromString: '{2B55EF06-E3AC-4439-B686-890B81325343}')!

!PstNormalObject categoriesForClass!No category! !
!PstNormalObject methodsFor!

compileBodyFor: generator
	namedSlots do: [:each |
		generator compileObjectReference: each].!

embeddedSelectorsDo: block
	1 to: self namedSlotCount do: [:n |
		(self namedSlotAt: n) embeddedSelectorsDo: block].!

instVarsDo: block
	namedSlots do: block.!

namedSlotAt: index
	^namedSlots at: index.!

namedSlotAt: index put: value
	^namedSlots at: index put: value.!

namedSlots
	^namedSlots.!

postCopy
	super postCopy.
	namedSlots := namedSlots copy.!

postInitialize
	"Create instance variable slots."
	namedSlots := Array new: self namedSlotCount.
	namedSlots atAllPut: PstBasicObject forNil.!

reallyEquals: object
	^namedSlots = object namedSlots.!

sizeInWords
	^self namedSlotCount.! !
!PstNormalObject categoriesFor: #compileBodyFor:!compiling!public! !
!PstNormalObject categoriesFor: #embeddedSelectorsDo:!compiling!public! !
!PstNormalObject categoriesFor: #instVarsDo:!compiling!public! !
!PstNormalObject categoriesFor: #namedSlotAt:!public!slot accessing! !
!PstNormalObject categoriesFor: #namedSlotAt:put:!public!slot accessing! !
!PstNormalObject categoriesFor: #namedSlots!accessing!public! !
!PstNormalObject categoriesFor: #postCopy!copying!public! !
!PstNormalObject categoriesFor: #postInitialize!initialization!public! !
!PstNormalObject categoriesFor: #reallyEquals:!comparing!public! !
!PstNormalObject categoriesFor: #sizeInWords!accessing!public! !



PstSymbol comment: ''!

PstSymbol guid: (GUID fromString: '{D3608702-351F-4D93-91D4-F7822804D07A}')!

!PstSymbol categoriesForClass!No category! !
!PstSymbol methodsFor!

canBecome
	^false.!

containsSpecialCharacters
	^(PstParser isValidIdentifier: string) not.!

copy
	^self.!

displayOn: stream
	stream nextPut: $#.
	self containsSpecialCharacters
		ifTrue: [stream print: string]
		ifFalse: [stream nextPutAll: string].!

embeddedSelectorsDo: block
	block value: self string.!

identicalTo: anotherObject
	^anotherObject class == self class
		and: [anotherObject string = string].!

instVarsDo: block
	^self shouldNotImplement.!

isSymbolObject
	^true.!

simulatedIdentityHash
	^string hash.!

string
	^string.!

string: newString
	string := newString.! !
!PstSymbol categoriesFor: #canBecome!predicates!public! !
!PstSymbol categoriesFor: #containsSpecialCharacters!predicates!public! !
!PstSymbol categoriesFor: #copy!copying!public! !
!PstSymbol categoriesFor: #displayOn:!printing!public! !
!PstSymbol categoriesFor: #embeddedSelectorsDo:!compiling!public! !
!PstSymbol categoriesFor: #identicalTo:!predicates!public! !
!PstSymbol categoriesFor: #instVarsDo:!*-should not implement!compiling!public! !
!PstSymbol categoriesFor: #isSymbolObject!predicates!public! !
!PstSymbol categoriesFor: #simulatedIdentityHash!comparing!public! !
!PstSymbol categoriesFor: #string!accessing!public! !
!PstSymbol categoriesFor: #string:!initialization!public! !

!PstSymbol class methodsFor!

string: string
	^self new
		qclass: PstClassLibrary current smallIntegerClass;
		string: string.! !
!PstSymbol class categoriesFor: #string:!instance creation!public! !



PstCharacter comment: ''!

PstCharacter guid: (GUID fromString: '{B77032BC-C481-40C5-8424-F89E658857CC}')!

!PstCharacter categoriesForClass!No category! !
!PstCharacter methodsFor!

attributes
	^Attributes at: value asInteger + 1.!

displayOn: stream
	stream
		nextPut: $$;
		nextPut: self value.!

isCharacterObject
	^true.!

value
	^value.!

value: character
	value := character.! !
!PstCharacter categoriesFor: #attributes!accessing!public! !
!PstCharacter categoriesFor: #displayOn:!printing!public! !
!PstCharacter categoriesFor: #isCharacterObject!predicates!public! !
!PstCharacter categoriesFor: #value!accessing!public! !
!PstCharacter categoriesFor: #value:!accessing!public! !

!PstCharacter class methodsFor!

buildAttributeTable
	Attributes := (0 to: 255) collect: [:n |
		self generateAttributesFor: n asCharacter].!

createCharacters
	"PstCharacterObject createCharacters."
	AllCharacters := (0 to: 255)
		collect: [:n | self new
				qclass: (PstClassLibrary current classNamed: 'Character');
				value: (Character value: n)].!

fromCharacter: character
	^self value: character asInteger.!

generateAttributesFor: c
	| n |
	n := 0.
	c isControl ifTrue: [n := n bitOr: 16rC0].
	c isLowercase ifTrue: [n := n bitOr: 16r10].
	c isUppercase ifTrue: [n := n bitOr: 16r2].
	c isHexDigit ifTrue: [n := n bitOr: 16r1].
	c isPunctuation ifTrue: [n := n bitOr: 16r8].
	c isDigit ifTrue: [n := n bitOr: 16r20].
	c isSeparator ifTrue: [n := n bitOr: 16r44].
	^n.!

value: asciiValue
	^AllCharacters at: asciiValue + 1.! !
!PstCharacter class categoriesFor: #buildAttributeTable!initialization!public! !
!PstCharacter class categoriesFor: #createCharacters!characters!public! !
!PstCharacter class categoriesFor: #fromCharacter:!characters!public! !
!PstCharacter class categoriesFor: #generateAttributesFor:!initialization!public! !
!PstCharacter class categoriesFor: #value:!characters!public! !



PstClass comment: ''!

PstClass guid: (GUID fromString: '{80E927AC-BF2A-4C3B-9CF1-7A3C48A235CA}')!

!PstClass categoriesForClass!No category! !
!PstClass methodsFor!

addSubclass: subclass
	subclasses add: subclass.
	subclasses := self class sortClassList: subclasses.!

allInstVarNames
	| stream |
	stream := Array new writeStream.
	self allInstVarNamesInto: stream.
	^stream contents.!

allInstVarNamesInto: stream
	self superclass isNil ifFalse: [
		self superclass allInstVarNamesInto: stream].
	stream nextPutAll: instVarNames.!

beRemoved
	superclass isNil ifFalse: [
		superclass removeSubclass: self].
	self package isNil ifFalse: [
		self package removeClass: self.
		package := nil].!

buildTree: treeModel
	self buildTree: treeModel from: nil.!

buildTree: treeModel from: parent
	treeModel add: self asChildOf: parent.
	self subclasses do: [:each |
		each buildTree: treeModel from: self].!

canBeSubclassed
	^self name ~= 'SmallInteger'
		and: [self name ~= 'Character'].!

changeNameTo: newName
	| oldName |
	oldName := name.
	name := newName.
	self classLibrary
		changedNameOf: self
		from: oldName
		to: newName.!

changeSuperclassTo: newSuperclass
	superclass isNil
		ifTrue: [self classLibrary removeRoot: self]
		ifFalse: [superclass removeSubclass: self].
	superclass := newSuperclass.
	superclass isNil
		ifTrue: [self classLibrary addRoot: self]
		ifFalse: [superclass addSubclass: self].
	"Change the superclass of the metaclass..."
	superclass isNil
		ifTrue: [
			self qclass superclass: 
				(self classLibrary classNamed: 'Class')]
		ifFalse: [self qclass superclass: superclass qclass].
	self classLibrary changedSuperclassOf: self.!

classVariables
	^classVariables.!

classVariables: set
	classVariables := set asSet.!

classVarNamesString
	| stream |
	stream := WriteStream on: String new.
	classVariables
		do: [:each | stream nextPutAll: each]
		separatedBy: [stream space].
	^stream contents.!

comment
	^comment.!

comment: string
	comment := string isEmpty
		ifTrue: [nil]
		ifFalse: [string].!

definesClassVariable: variableName
	"Check if the class variable is defined in this class (not in any superclasses)."
	^classVariables includes: variableName.!

definesInstanceVariable: variableName
	^instVarNames includes: variableName.!

defineSubclass: subclassName
instanceVariables: instvars
classVariables: classvars
fixed: fixed
pointerless: pointerless
	| subclass classLibrary subclassLayout |
	classLibrary := PstClassLibrary current.
	subclass := PstClass new.
	subclass name: subclassName.
	subclassLayout := pointerless
		ifTrue: [self class layoutForPointerlessObject]
		ifFalse: [
			self class
				layoutForNormalObject: instvars size + self instanceVariableCount
				indexable: fixed not].
	subclass 
		layout: subclassLayout;
		superclass: self;
		instVarNames: instvars;
		classVariables: classvars.
	classLibrary makeMetaclassFor: subclass.
	self addSubclass: subclass.
	classLibrary addClass: subclass.!

definition
	| stream |
	stream := WriteStream on: String new.
	self printDefinitionOn: stream.
	^stream contents.!

definitionForNewSubclass: subclassName
	| stream |
	stream := WriteStream on: String new.
	stream
		display: self;
		space;
		nextPutAll: self subclassType;
		nextPutAll: ' #';
		nextPutAll: subclassName;
		cr; tab;
		nextPutAll: 'instanceVariableNames: ''''';
		cr; tab;
		nextPutAll: 'classVariableNames: '''''.
	^stream contents.!

displayOn: stream
	stream nextPutAll: self name.!

fileOutCommentOn: manager
	comment isNil ifTrue: [^self].
	manager
		bang;
		nextPutAll: self displayString;
		nextPutAll: ' comment';
		bang; cr;
		nextPutAll: comment;
		bang; space; endChunk; cr.!

fileOutDefinitionOn: manager
	manager 
		nextPutAll: self definition;
		endChunk.!

hasSubclasses

	^self subclasses notEmpty!

includesClassVariable: variableName
	"Answer whether this class or a superclass has the class variable."
	(self definesClassVariable: variableName)
		ifTrue: [^true].
	^superclass isNil
		ifTrue: [false]
		ifFalse: [superclass includesClassVariable: variableName].!

includesInstanceVariable: variableName
	^(self definesInstanceVariable: variableName)
		or: [superclass notNil 
			and: [superclass includesInstanceVariable: variableName]].!

indexOfInstanceVariable: instVarName
	| index |
	index := self superclass isNil
		ifTrue: [0]
		ifFalse: [self superclass indexOfInstanceVariable: instVarName].
	index = 0 ifFalse: [^index].
	index := instVarNames indexOf: instVarName.
	index = 0 ifTrue: [^0].
	^self superclass isNil
		ifTrue: [index]
		ifFalse: [index + self superclass instanceVariableCount].!

initialize
	super initialize.
	isBasic := false.
	isInstantiable := true.
	classVariables := Set new.
	subclasses := OrderedCollection new.!

instVarNames
	^instVarNames.!

instVarNames: array
	instVarNames := array.!

instVarNamesString
	| stream |
	stream := WriteStream on: String new.
	instVarNames
		do: [:each | stream nextPutAll: each]
		separatedBy: [stream space].
	^stream contents.!

isBasic
	^isBasic.!

isBasic: boolean
	"Whether the class is a basic part of the system, and cannot be removed, renamed, etc."
	isBasic := boolean.!

isInstantiable
	^isInstantiable.!

isInstantiable: boolean
	isInstantiable := boolean.!

isMeta
	^false.!

name
	^name.!

name: string
	name := string.!

package
	^package.!

package: newPackage
	package == newPackage ifTrue: [^self].
	package isNil ifFalse: [package removeClass: self].
	package := newPackage.
	package isNil ifFalse: [package addClass: self].
	self repackageMethods.
	"Metaclass may be nil during bootstrapping."
	self qclass isNil ifFalse: [self qclass repackageMethods].!

printDefinitionOn: stream
	self superclass isNil
		ifTrue: [stream nextPutAll: 'nil']
		ifFalse: [
			(PstParser isValidIdentifier: self superclass name)
				ifTrue: [stream display: self superclass]
				ifFalse: [stream display: (PstSymbol string: self superclass name)]].
	stream
		space;
		nextPutAll: self subclassType;
 		nextPutAll: ' #';
		nextPutAll: self name;
		cr; tab;
		nextPutAll: 'instanceVariableNames: ';
		print: self instVarNamesString;
		cr; tab;
		nextPutAll: 'classVariableNames: ';
		print: self classVarNamesString.!

recalculateLayout
	"Recalculate the layout value when something changes, e.g., the number of instance variables."
	layout := self hasPointers
		ifTrue: [
			self class
				layoutForNormalObject: self allInstVarNames size
				indexable: self isIndexable]
		ifFalse: [self class layoutForPointerlessObject].
	"self subclasses do: [:each | each recalculateLayout]."!

recompile: reinstall
	"Recompile all methods in this class and its metaclass (but not in any subclasses).
If reinstall is true, install the compiled methods, overwriting what is already there."
	"Answer true if recompilation was successful, false if not."
	| success |
	self recalculateLayout.
	success := self methods allSatisfy: [:each |
		self 
			recompileMethod: each
			reinstall: reinstall].
	self hasMetaclass ifTrue: [
		success := success and: [
			self qclass methods allSatisfy: [:each |
				self qclass
					recompileMethod: each
					reinstall: reinstall]]].
	reinstall ifTrue: [
		self classLibrary recompiledBehavior: self.
		self hasMetaclass
			ifTrue: [self classLibrary recompiledBehavior: self qclass]].
	^success.!

recompileHierarchy: reinstall
	(self recompile: reinstall)
		ifFalse: [^false].
	^self subclasses allSatisfy: [:each | 
		each recompileHierarchy: reinstall].!

removeSubclass: subclass
	^subclasses remove: subclass.!

safelyRecompile
	^(self recompile: false) and: [self recompile: true].!

safelyRecompileHierarchy
	^(self recompileHierarchy: false) 
		and: [self recompileHierarchy: true].!

slotNames
	^#('superclass' 'layout').!

subclass: subclassName
instanceVariableNames: instanceVariableNames
classVariableNames: classVariableNames
	self
		defineSubclass: subclassName
		instanceVariables: instanceVariableNames subStrings
		classVariables: classVariableNames subStrings
		fixed: true
		pointerless: false.!

subclasses
	^subclasses.!

topologicalSortOn: stream
	stream nextPut: self.
	subclasses do: [:each | each topologicalSortOn: stream].!

variableByteSubclass: subclassName
instanceVariableNames: instanceVariableNames
classVariableNames: classVariableNames
	self
		defineSubclass: subclassName
		instanceVariables: instanceVariableNames subStrings
		classVariables: classVariableNames subStrings
		fixed: false
		pointerless: true.!

variableSubclass: subclassName
instanceVariableNames: instanceVariableNames
classVariableNames: classVariableNames
	self
		defineSubclass: subclassName
		instanceVariables: instanceVariableNames subStrings
		classVariables: classVariableNames subStrings
		fixed: false
		pointerless: false.!

visibleClassVariableNames
	| vars |
	vars := OrderedCollection new.
	self withAllSuperclasses do: [:each |
		vars addAll: each classVariables].
	^vars.! !
!PstClass categoriesFor: #addSubclass:!public!subclasses! !
!PstClass categoriesFor: #allInstVarNames!accessing!public! !
!PstClass categoriesFor: #allInstVarNamesInto:!accessing!public! !
!PstClass categoriesFor: #beRemoved!public!utility! !
!PstClass categoriesFor: #buildTree:!public!subclasses! !
!PstClass categoriesFor: #buildTree:from:!public!subclasses! !
!PstClass categoriesFor: #canBeSubclassed!predicates!public! !
!PstClass categoriesFor: #changeNameTo:!public!utility! !
!PstClass categoriesFor: #changeSuperclassTo:!public!subclasses! !
!PstClass categoriesFor: #classVariables!accessing!public! !
!PstClass categoriesFor: #classVariables:!accessing!public! !
!PstClass categoriesFor: #classVarNamesString!accessing!public! !
!PstClass categoriesFor: #comment!accessing!public! !
!PstClass categoriesFor: #comment:!accessing!public! !
!PstClass categoriesFor: #definesClassVariable:!predicates!public! !
!PstClass categoriesFor: #definesInstanceVariable:!predicates!public! !
!PstClass categoriesFor: #defineSubclass:instanceVariables:classVariables:fixed:pointerless:!public!subclass creation! !
!PstClass categoriesFor: #definition!printing!public! !
!PstClass categoriesFor: #definitionForNewSubclass:!public!subclass creation! !
!PstClass categoriesFor: #displayOn:!printing!public! !
!PstClass categoriesFor: #fileOutCommentOn:!fileout!public! !
!PstClass categoriesFor: #fileOutDefinitionOn:!fileout!public! !
!PstClass categoriesFor: #hasSubclasses!predicates!public! !
!PstClass categoriesFor: #includesClassVariable:!predicates!public! !
!PstClass categoriesFor: #includesInstanceVariable:!predicates!public! !
!PstClass categoriesFor: #indexOfInstanceVariable:!accessing!public! !
!PstClass categoriesFor: #initialize!initialization!public! !
!PstClass categoriesFor: #instVarNames!accessing!public! !
!PstClass categoriesFor: #instVarNames:!accessing!public! !
!PstClass categoriesFor: #instVarNamesString!accessing!public! !
!PstClass categoriesFor: #isBasic!accessing!public! !
!PstClass categoriesFor: #isBasic:!accessing!public! !
!PstClass categoriesFor: #isInstantiable!predicates!public! !
!PstClass categoriesFor: #isInstantiable:!initialization!public! !
!PstClass categoriesFor: #isMeta!predicates!public! !
!PstClass categoriesFor: #name!accessing!public! !
!PstClass categoriesFor: #name:!accessing!public! !
!PstClass categoriesFor: #package!accessing!public! !
!PstClass categoriesFor: #package:!accessing!public! !
!PstClass categoriesFor: #printDefinitionOn:!printing!public! !
!PstClass categoriesFor: #recalculateLayout!public!subclass creation! !
!PstClass categoriesFor: #recompile:!public!recompiling! !
!PstClass categoriesFor: #recompileHierarchy:!public!recompiling! !
!PstClass categoriesFor: #removeSubclass:!public!subclasses! !
!PstClass categoriesFor: #safelyRecompile!public!recompiling! !
!PstClass categoriesFor: #safelyRecompileHierarchy!public!recompiling! !
!PstClass categoriesFor: #slotNames!public!slot accessing! !
!PstClass categoriesFor: #subclass:instanceVariableNames:classVariableNames:!public!subclass creation! !
!PstClass categoriesFor: #subclasses!public!subclasses! !
!PstClass categoriesFor: #topologicalSortOn:!fileout!public! !
!PstClass categoriesFor: #variableByteSubclass:instanceVariableNames:classVariableNames:!public!subclass creation! !
!PstClass categoriesFor: #variableSubclass:instanceVariableNames:classVariableNames:!public!subclass creation! !
!PstClass categoriesFor: #visibleClassVariableNames!accessing!public! !

!PstClass class methodsFor!

defineRootClass: subclassName
instanceVariables: instvars
classVariables: classvars
fixed: fixed
pointerless: pointerless
	| subclass classLibrary subclassLayout |
	classLibrary := PstSystem current classLibrary.
	subclass := self new.
	subclass name: subclassName.
	subclassLayout := pointerless
		ifTrue: [self layoutForPointerlessObject]
		ifFalse: [
			self
				layoutForNormalObject: instvars size + self instanceVariableCount
				indexable: fixed not].
	subclass 
		layout: subclassLayout;
		superclass: nil;
		instVarNames: instvars.
	classLibrary 
		makeMetaclassFor: subclass;
		addClass: subclass;
		addRoot: subclass.!

subclassOfNil: subclassName
instanceVariableNames: instanceVariableNames
classVariableNames: classVariableNames
	self
		defineRootClass: subclassName
		instanceVariables: instanceVariableNames subStrings
		classVariables: classVariableNames subStrings
		fixed: true
		pointerless: false.!

variableByteSubclassOfNil: subclassName
instanceVariableNames: instanceVariableNames
classVariableNames: classVariableNames
	self
		defineRootClass: subclassName
		instanceVariables: instanceVariableNames subStrings
		classVariables: classVariableNames subStrings
		fixed: false
		pointerless: true.!

variableSubclassOfNil: subclassName
instanceVariableNames: instanceVariableNames
classVariableNames: classVariableNames
	self
		defineRootClass: subclassName
		instanceVariables: instanceVariableNames subStrings
		classVariables: classVariableNames subStrings
		fixed: false
		pointerless: false.! !
!PstClass class categoriesFor: #defineRootClass:instanceVariables:classVariables:fixed:pointerless:!public!root classes! !
!PstClass class categoriesFor: #subclassOfNil:instanceVariableNames:classVariableNames:!public!root classes! !
!PstClass class categoriesFor: #variableByteSubclassOfNil:instanceVariableNames:classVariableNames:!public!root classes! !
!PstClass class categoriesFor: #variableSubclassOfNil:instanceVariableNames:classVariableNames:!public!root classes! !



PstMetaclass comment: ''!

PstMetaclass guid: (GUID fromString: '{B4A10E6C-7027-4606-A35E-B2CD85B0BBF1}')!

!PstMetaclass categoriesForClass!No category! !
!PstMetaclass methodsFor!

allInstVarNames
	^#().!

compileBodyFor: generator
	super compileBodyFor: generator.
	generator compileObjectReference: uniqueInstance.!

createFor: classObject
	self uniqueInstance: classObject.
	classObject qclass: self.
	classObject superclass isNil 
		ifTrue: [
			self superclass: 
				((PstSystem current classLibrary hasClassNamed: 'Class')
					ifTrue: [PstSystem current classLibrary classNamed: 'Class']
					ifFalse: [nil])]
		ifFalse: [self superclass: classObject superclass qclass].!

definesClassVariable: variableName
	^self uniqueInstance definesClassVariable: variableName.!

displayOn: stream
	self uniqueInstance displayOn: stream.
	stream nextPutAll: ' class'.!

includesClassVariable: variableName
	^self uniqueInstance includesClassVariable: variableName.!

indexOfInstanceVariable: instVarName
	^0.!

instVarsDo: block
	"This probably isn't really necessary."
	super instVarsDo: block.
	block value: uniqueInstance.!

isInstantiable
	^false.!

isMeta
	^true.!

name
	^self uniqueInstance name, ' class'.!

namedSlotAt: index
	index = 3 ifTrue: [^uniqueInstance].
	^super namedSlotAt: index.!

namedSlotCount
	^3.!

package
	^self uniqueInstance package.!

sizeInWords
	^3.!

uniqueInstance
	^uniqueInstance.!

uniqueInstance: instance
	uniqueInstance := instance.! !
!PstMetaclass categoriesFor: #allInstVarNames!accessing!public! !
!PstMetaclass categoriesFor: #compileBodyFor:!compiling!public! !
!PstMetaclass categoriesFor: #createFor:!initialization!public! !
!PstMetaclass categoriesFor: #definesClassVariable:!predicates!public! !
!PstMetaclass categoriesFor: #displayOn:!printing!public! !
!PstMetaclass categoriesFor: #includesClassVariable:!predicates!public! !
!PstMetaclass categoriesFor: #indexOfInstanceVariable:!accessing!public! !
!PstMetaclass categoriesFor: #instVarsDo:!compiling!public! !
!PstMetaclass categoriesFor: #isInstantiable!predicates!public! !
!PstMetaclass categoriesFor: #isMeta!predicates!public! !
!PstMetaclass categoriesFor: #name!accessing!public! !
!PstMetaclass categoriesFor: #namedSlotAt:!public!slot accessing! !
!PstMetaclass categoriesFor: #namedSlotCount!public!slot accessing! !
!PstMetaclass categoriesFor: #package!accessing!public! !
!PstMetaclass categoriesFor: #sizeInWords!accessing!public! !
!PstMetaclass categoriesFor: #uniqueInstance!accessing!public! !
!PstMetaclass categoriesFor: #uniqueInstance:!accessing!public! !



PstFullBlockClosure comment: ''!

PstFullBlockClosure guid: (GUID fromString: '{907F56AF-4317-4920-A76D-0ACD31C6DFCA}')!

!PstFullBlockClosure categoriesForClass!No category! !
!PstFullBlockClosure methodsFor!

isFullBlockClosure
	^true.!

markAsTerminated
	nextOuter := 0.!

nextOuter
	^nextOuter.!

nextOuter: index
	nextOuter := index.!

terminated
	^nextOuter = 0.! !
!PstFullBlockClosure categoriesFor: #isFullBlockClosure!predicates!public! !
!PstFullBlockClosure categoriesFor: #markAsTerminated!accessing!public! !
!PstFullBlockClosure categoriesFor: #nextOuter!accessing!public! !
!PstFullBlockClosure categoriesFor: #nextOuter:!accessing!public! !
!PstFullBlockClosure categoriesFor: #terminated!accessing!public! !



PstLongInteger comment: ''!

PstLongInteger guid: (GUID fromString: '{2AC5AEE1-0D03-4899-9322-E387F2155B9F}')!

!PstLongInteger categoriesForClass!No category! !
!PstLongInteger methodsFor!

asBytes
	| stream |
	stream := ByteArray new writeStream.
	PstSystem current storeLongword: value on: stream.
	^stream contents.!

compileBodyFor: generator
	generator compileObjectBytes: self asBytes.!

copy
	self halt.!

instVarsDo: block
	^self.!

isImmediate
	^false.!

isSmallIntegerObject
	^false.!

sizeInWords
	^3.! !
!PstLongInteger categoriesFor: #asBytes!compiling!public! !
!PstLongInteger categoriesFor: #compileBodyFor:!compiling!public! !
!PstLongInteger categoriesFor: #copy!copying!public! !
!PstLongInteger categoriesFor: #instVarsDo:!compiling!public! !
!PstLongInteger categoriesFor: #isImmediate!predicates!public! !
!PstLongInteger categoriesFor: #isSmallIntegerObject!predicates!public! !
!PstLongInteger categoriesFor: #sizeInWords!accessing!public! !

!PstLongInteger class methodsFor!

value: integer
	^self new 
		qclass: (PstClassLibrary current classNamed: 'LongInteger');
		value: integer.
	! !
!PstLongInteger class categoriesFor: #value:!instance creation!public! !



PstIndexableObject comment: ''!

PstIndexableObject guid: (GUID fromString: '{D6B3DFC7-0A8C-4F3E-96B6-0D1524E64AD9}')!

!PstIndexableObject categoriesForClass!No category! !
!PstIndexableObject methodsFor!

compileBodyFor: generator
	super compileBodyFor: generator.
	indexedSlots do: [:each |
		generator compileObjectReference: each].!

copyExpandedBy: amount
	^self copy expandBy: amount.!

displayOn: stream
	self qclass name = 'Array' 
		ifFalse: [^super displayOn: stream].
	stream nextPutAll: '#('.
	indexedSlots
		do: [:each | stream display: each]
		separatedBy: [stream space].
	stream nextPut: $).!

embeddedSelectorsDo: block
	super embeddedSelectorsDo: block.
	1 to: self indexedSlotCount do: [:n |
		(self indexedSlotAt: n) embeddedSelectorsDo: block].!

expandBy: amount
	"Expand the number of indexed variables in-place."
	indexedSlots := indexedSlots copy 
		resize: indexedSlots size + amount.!

indexedSlotAt: index
	^indexedSlots at: index.!

indexedSlotAt: index put: value
	^indexedSlots at: index put: value.!

indexedSlotCount
	^indexedSlots size.!

indexedSlots
	^indexedSlots.!

initializeIndexedSlots: count
	indexedSlots := Array new: count.
	indexedSlots atAllPut: PstBasicObject forNil.!

instVarsDo: block
	super instVarsDo: block.
	indexedSlots do: block.!

postCopy
	super postCopy.
	indexedSlots := indexedSlots copy.!

reallyEquals: object
	^(super reallyEquals: object) 
		and: [indexedSlots = object indexedSlots].!

sizeInWords
	^super sizeInWords + self indexedSlotCount.! !
!PstIndexableObject categoriesFor: #compileBodyFor:!compiling!public! !
!PstIndexableObject categoriesFor: #copyExpandedBy:!copying!public! !
!PstIndexableObject categoriesFor: #displayOn:!printing!public! !
!PstIndexableObject categoriesFor: #embeddedSelectorsDo:!compiling!public! !
!PstIndexableObject categoriesFor: #expandBy:!copying!public! !
!PstIndexableObject categoriesFor: #indexedSlotAt:!public!slot accessing! !
!PstIndexableObject categoriesFor: #indexedSlotAt:put:!public!slot accessing! !
!PstIndexableObject categoriesFor: #indexedSlotCount!public!slot accessing! !
!PstIndexableObject categoriesFor: #indexedSlots!public!slot accessing! !
!PstIndexableObject categoriesFor: #initializeIndexedSlots:!initialization!public! !
!PstIndexableObject categoriesFor: #instVarsDo:!compiling!public! !
!PstIndexableObject categoriesFor: #postCopy!copying!public! !
!PstIndexableObject categoriesFor: #reallyEquals:!comparing!public! !
!PstIndexableObject categoriesFor: #sizeInWords!accessing!public! !



PstByteIndexableObject comment: ''!

PstByteIndexableObject guid: (GUID fromString: '{1FD10B44-B715-4C62-9A08-516E4FE012C2}')!

!PstByteIndexableObject categoriesForClass!No category! !
!PstByteIndexableObject methodsFor!

byteIndexedSlotAt: index
	"Uses direct Smalltalk integers."
	^indexedSlots at: index.!

byteIndexedSlotAt: index put: integer
	"Uses direct Smalltalk integers."
	^indexedSlots at: index put: integer.!

compileBodyFor: generator
	generator compileObjectBytes: indexedSlots.!

convertToString
	^indexedSlots asString.!

displayOn: stream

	self qclass name = 'String' ifTrue: [
		stream print: self convertToString.
		^self].
	self qclass name = 'ByteArray' ifFalse: [
		^super displayOn: stream].
	stream nextPutAll: '#['.
	indexedSlots
		do: [:each | stream print: each]
		separatedBy: [stream space].
	stream nextPut: $].!

embeddedSelectorsDo: block
	^self.!

indexedSlotAt: index
	^PstInteger value: (indexedSlots at: index).!

indexedSlotAt: index put: value
	indexedSlots at: index put: value value.!

initializeIndexedSlots: count
	indexedSlots := ByteArray new: count.
!

instVarsDo: block
	^self.!

sizeInWords
	^namedSlots size + (indexedSlots size // 2 + 1).! !
!PstByteIndexableObject categoriesFor: #byteIndexedSlotAt:!public!slot accessing! !
!PstByteIndexableObject categoriesFor: #byteIndexedSlotAt:put:!public!slot accessing! !
!PstByteIndexableObject categoriesFor: #compileBodyFor:!compiling!public! !
!PstByteIndexableObject categoriesFor: #convertToString!converting!public! !
!PstByteIndexableObject categoriesFor: #displayOn:!printing!public! !
!PstByteIndexableObject categoriesFor: #embeddedSelectorsDo:!compiling!public! !
!PstByteIndexableObject categoriesFor: #indexedSlotAt:!public!slot accessing! !
!PstByteIndexableObject categoriesFor: #indexedSlotAt:put:!public!slot accessing! !
!PstByteIndexableObject categoriesFor: #initializeIndexedSlots:!initialization!public! !
!PstByteIndexableObject categoriesFor: #instVarsDo:!compiling!public! !
!PstByteIndexableObject categoriesFor: #sizeInWords!accessing!public! !

!PstByteIndexableObject class methodsFor!

newString: string
	"Make a new String instance from a Smalltalk string."
	"Kind of a kluge."
	| object	|
	object := (PstClassLibrary current classNamed: 'String')
			instantiateIndexed: string size.
	string keysAndValuesDo: [:index :character |
		object 
			byteIndexedSlotAt: index
			put: character asInteger].
	^object.! !
!PstByteIndexableObject class categoriesFor: #newString:!instance creation!public! !



PstGeosAPI comment: ''!

PstGeosAPI guid: (GUID fromString: '{7A91881B-38B3-4FEA-8F13-63D1AF820E0D}')!

!PstGeosAPI categoriesForClass!No category! !
!PstGeosAPI class methodsFor!

addTrap: trapName
index: index
argumentTypes: argumentTypes
returnType: returnType
	| trap |
	trap := PstGeosLibCall new.
	trap
		name: trapName
		functionNumber: index
		argumentTypes: argumentTypes
		returnType: returnType.
	TrapTable at: trapName put: trap.
!

buildTraps
	!

initialize
	"PstGeosAPI initialize."
	TrapTable := Dictionary new.
	self buildTraps.
! !
!PstGeosAPI class categoriesFor: #addTrap:index:argumentTypes:returnType:!*-unclassified!public! !
!PstGeosAPI class categoriesFor: #buildTraps!*-unclassified!public! !
!PstGeosAPI class categoriesFor: #initialize!*-unclassified!public! !



PstPalmOSAPI comment: ''!

PstPalmOSAPI guid: (GUID fromString: '{ED4B4A4A-4D51-4DD2-8F66-AB26FC873EED}')!

!PstPalmOSAPI categoriesForClass!No category! !
!PstPalmOSAPI class methodsFor!

addTrap: trapName
index: index
argumentTypes: argumentTypes
returnType: returnType
	| trap |
	trap := PstPalmOSTrap new.
	trap
		name: trapName
		functionNumber: index
		argumentTypes: argumentTypes
		returnType: returnType.
	TrapTable at: trapName put: trap.
!

buildTraps
	#(trapSpecs serialTrapSpecs) do: [:selector |
		(self perform: selector) do: 
			[:each | self addTrapSpec: each]].
!

initialize
	"PstPalmOSAPI initialize."
	TrapTable := Dictionary new.
	self buildTraps.
!

parseArgSpec: string
	(string indexOfSubCollection: 'Handle.') ~= 0
		ifTrue: [^#pointer].
	(string indexOfSubCollection: 'VoidHand.') ~= 0
		ifTrue: [^#pointer].
	(string indexOfSubCollection: 'P.') ~= 0
		ifTrue: [^#pointer].
	(string indexOfSubCollection: 'H.') ~= 0
		ifTrue: [^#pointer].
	string = 'h.' ifTrue: [^#pointer].
	string = 'DmOpenRef.' ifTrue: [^#pointer].
	string first == $& ifTrue: [^#pointer].
	string last == $. ifTrue: [^#int32].
	string = ')' ifTrue: [^#void].
	^#int16.
!

parseForthSpec: string
	"Answers an array: #(trapname (arg_array) return_type)"
	| tokens trapname args dashIndex return |
	tokens := string subStrings: Character space.
	tokens := tokens reject: [:each | each isEmpty].
	trapname := tokens first.
	dashIndex := tokens indexOf: '--'.
	args := ( tokens copyFrom: 3 to: dashIndex - 1 ) reverse.
	return := tokens at: dashIndex + 1.
	^Array
		with: trapname
		with: (args collect: [:each | self parseArgSpec: each])
		with: (self parseArgSpec: return).
!

serialTrapSpecs
	^#(
('SerOpen' #(int16 int16 int32) #int16 43009)
('SerClose' #(int16) #int16 43010)
('SerSleep' #(int16) #int16 43011)
('SerWake' #(int16) #int16 43012)
('SerGetSettings' #(int16 pointer) #int16 43013)
('SerSetSettings' #(int16 pointer) #int16 43014)
('SerGetStatus' #(int16 pointer pointer) #int16 43015)
('SerClearError' #(int16) #int16 43016)
('SerSend10' #(int16 pointer int32) #int16 43017)
('SerSendWait' #(int16 int32) #int16 43018)
('SerSendCheck' #(int16 pointer) #int16 43019)
('SerSendFlush' #(int16) #int16 43020)).
!

translateForthFile: filename
	| stream answer |
	stream := FileStream read: filename text: true.
	[answer := self translateForthSpec: stream contents]
		ensure: [stream close].
	^answer.
!

translateForthSpec: string
	| array |
	array := (string subStrings: Character cr)
		collect: [:each | each trimBlanks].
	array := array reject: [:each | each isEmpty].
	^array collect: [:each | self parseForthSpec: each].
!

translateSysTrapHeader: filename
	| stream string tokens table n |
	stream := FileStream read: filename text: true.
	string := stream contents.
	stream close.
	tokens := string subStrings collect: [:each | each copyWithout: $,].
	tokens := tokens collect: [:each | each copyFrom: 8 to: each size].
	n := 16rA000.
	table := Dictionary new.
	tokens do: [:each |
		table at: each put: n.
		n := n + 1].
	^table.
!

trapSpecs
	"automatically generated"
	^
#(#('AbtShowAbout' #(#int32) #void 41647) #('AlmAlarmCallback' #() #void 41527) #('AlmCancelAll' #() #void 41526) #('AlmDisplayAlarm' #(#int16) #void 41530) #('AlmEnableNotification' #(#int16) #void 41531) #('AlmGetAlarm' #(#int16 #int32 #pointer) #int32 41529) #('AlmInit' #() #int16 41525) #('AlmSetAlarm' #(#int16 #int32 #int32 #int32 #int16) #int16 41528) #('CategoryCreateList' #(#int32 #pointer #int16 #int16 #int16 #int16 #int32 #int16) #void 41667) #('CategoryCreateListV10' #(#int32 #pointer #int16 #int16) #void 41217) #('CategoryEdit' #(#int32 #pointer #int32 #int16) #int16 41762) #('CategoryEditV10' #(#int32 #pointer) #int16 41221) #('CategoryEditV20' #(#int32 #pointer #int32) #int16 41669) #('CategoryFind' #(#int32 #pointer) #int16 41219) #('CategoryFreeList' #(#int32 #pointer #int16 #int32) #void 41668) #('CategoryFreeListV10' #(#int32 #pointer) #void 41218) #('CategoryGetName' #(#int32 #int16 #pointer) #void 41220) #('CategoryGetNext' #(#int32 #int16) #int16 41223) #('CategoryInitialize' #(#pointer #int16) #void 41724) #('CategorySelect' #(#int32 #pointer #int16 #int16 #int16 #pointer #pointer #int16 #int32) #int16 41670) #('CategorySelectV10' #(#int32 #pointer #int16 #int16 #int16 #pointer #pointer) #int16 41222) #('CategorySetName' #(#int32 #int16 #pointer) #void 41729) #('CategorySetTriggerLabel' #(#pointer #pointer) #void 41224) #('CategoryTruncateName' #(#pointer #int16) #void 41225) #('ClipboardAddItem' #(#int16 #pointer #int16) #void 41226) #('ClipboardGetItem' #(#int16 #pointer) #pointer 41228) #('ConGetS' #(#pointer #int32) #int16 41182) #('ConPutS' #(#pointer) #int16 41181) #('Crc16CalcBlock' #(#pointer #int16 #int16) #int16 41561) #('CtlDrawControl' #(#pointer) #void 41229) #('CtlEnabled' #(#pointer) #int16 41241) #('CtlEraseControl' #(#pointer) #void 41230) #('CtlGetLabel' #(#pointer) #pointer 41235) #('CtlGetValue' #(#pointer) #int16 41233) #('CtlHandleEvent' #(#pointer #pointer) #int16 41237) #('CtlHideControl' #(#pointer) #void 41231) #('CtlHitControl' #(#pointer) #void 41238) #('CtlNewControl' #(#pointer #int16 #int16 #pointer #int16 #int16 #int16 #int16 #int16 #int16 #int16) #pointer 41772) #('CtlSetEnabled' #(#pointer #int16) #void 41239) #('CtlSetLabel' #(#pointer #pointer) #void 41236) #('CtlSetUsable' #(#pointer #int16) #void 41240) #('CtlSetValue' #(#pointer #int16) #void 41234) #('CtlShowControl' #(#pointer) #void 41232) #('CtlValidatePointer' #(#pointer) #int16 41768) #('DateAdjust' #(#pointer #int32) #void 41572) #('DateDaysToDate' #(#int32 #pointer) #void 41570) #('DateSecondsToDate' #(#int32 #pointer) #void 41573) #('DateToAscii' #(#int16 #int16 #int16 #int16 #pointer) #void 41574) #('DateToDOWDMFormat' #(#int16 #int16 #int16 #int16 #pointer) #void 41575) #('DateToDays' #(#int16) #int32 41571) #('DayDrawDaySelector' #(#pointer) #void 41564) #('DayDrawDays' #(#pointer) #void 41566) #('DayHandleEvent' #(#pointer #pointer) #int16 41565) #('DayOfMonth' #(#int16 #int16 #int16) #int16 41569) #('DayOfWeek' #(#int16 #int16 #int16) #int16 41567) #('DaysInMonth' #(#int16 #int16) #int16 41568) #('DbgCommSettings' #(#pointer #pointer) #int16 41091) #('DbgControl' #(#int16) #int16 41793) #('DbgGetMessage' #(#pointer #int32) #pointer 41090) #('DbgSrcMessage' #(#pointer) #void 41088) #('DlkControl' #(#int16 #pointer #pointer) #int16 41639) #('DlkDispatchRequest' #(#pointer) #int16 41693) #('DlkGetSyncInfo' #(#pointer #pointer #pointer #pointer #pointer #pointer) #int16 41641) #('DlkSetLogEntry' #(#pointer #int16 #int16) #void 41642) #('DlkStartServer' #(#pointer) #int16 41640) #('DmArchiveRecord' #(#pointer #int16) #int16 41048) #('DmAttachRecord' #(#pointer #pointer #pointer #pointer) #int16 41042) #('DmAttachResource' #(#pointer #pointer #int32 #int16) #int16 41066) #('DmCloseDatabase' #(#pointer) #int16 41034) #('DmCreateDatabase' #(#int16 #pointer #int32 #int32 #int16) #int16 41025) #('DmCreateDatabaseFromImage' #(#pointer) #int16 41087) #('DmDatabaseInfo' #(#int16 #int32 #pointer #pointer #pointer #pointer #pointer #pointer #pointer #pointer #pointer #pointer #pointer) #int16 41030) #('DmDatabaseProtect' #(#int16 #int32 #int16) #int16 41707) #('DmDatabaseSize' #(#int16 #int32 #pointer #pointer #pointer) #int16 41032) #('DmDeleteCategory' #(#int32 #int16) #int16 41671) #('DmDeleteDatabase' #(#int16 #int32) #int16 41026) #('DmDeleteRecord' #(#pointer #int16) #int16 41047) #('DmDetachRecord' #(#pointer #int16 #pointer) #int16 41043) #('DmDetachResource' #(#pointer #int16 #pointer) #int16 41067) #('DmFindDatabase' #(#int16 #pointer) #int32 41029) #('DmFindRecordByID' #(#pointer #int32 #pointer) #int16 41083) #('DmFindResource' #(#pointer #int32 #int16 #pointer) #int16 41061) #('DmFindResourceType' #(#pointer #int32 #int16) #int16 41060) #('DmFindSortPosition' #(#pointer #pointer #pointer #pointer #int16) #int16 41714) #('DmFindSortPositionV10' #(#pointer #pointer #pointer #int16) #int16 41085) #('DmGet1Resource' #(#int32 #int16) #pointer 41056) #('DmGetAppInfoID' #(#pointer) #int32 41084) #('DmGetDatabase' #(#int16 #int16) #int32 41028) #('DmGetLastErr' #() #int16 41038) #('DmGetNextDatabaseByTypeCreator' #(#int16 #pointer #int32 #int32 #int16 #pointer #pointer) #int16 41080) #('DmGetRecord' #(#pointer #int16) #pointer 41052) #('DmGetResource' #(#int32 #int16) #pointer 41055) #('DmGetResourceIndex' #(#pointer #int16) #pointer 41070) #('DmInit' #() #int16 41024) #('DmInsertionSort' #(#int32 #pointer #int16) #int16 41652) #('DmMoveCategory' #(#pointer #int16 #int16 #int16) #int16 41076) #('DmMoveOpenDBContext' #(#pointer #pointer) #int16 41082) #('DmMoveRecord' #(#pointer #int16 #int16) #int16 41044) #('DmNewHandle' #(#pointer #int32) #pointer 41049) #('DmNewRecord' #(#pointer #pointer #int32) #pointer 41045) #('DmNewResource' #(#pointer #int32 #int16 #int32) #pointer 41068) #('DmNextOpenDatabase' #(#pointer) #pointer 41035) #('DmNextOpenResDatabase' #(#pointer) #pointer 41059) #('DmNumDatabases' #(#int16) #int16 41027) #('DmNumRecords' #(#pointer) #int16 41039) #('DmNumRecordsInCategory' #(#pointer #int16) #int16 41073) #('DmNumResources' #(#pointer) #int16 41063) #('DmOpenDatabase' #(#int16 #int32 #int16) #pointer 41033) #('DmOpenDatabaseByTypeCreator' #(#int32 #int32 #int16) #pointer 41077) #('DmOpenDatabaseInfo' #(#pointer #pointer #pointer #pointer #pointer #pointer) #int16 41036) #('DmPositionInCategory' #(#pointer #int16 #int16) #int16 41074) #('DmQueryNextInCategory' #(#pointer #pointer #int16) #pointer 41072) #('DmQueryRecord' #(#pointer #int16) #pointer 41051) #('DmQuickSort' #(#pointer #pointer #int16) #int16 41071) #('DmRecordInfo' #(#pointer #int16 #pointer #pointer #pointer) #int16 41040) #('DmReleaseRecord' #(#pointer #int16 #int16) #int16 41054) #('DmReleaseResource' #(#pointer) #int16 41057) #('DmRemoveRecord' #(#pointer #int16) #int16 41046) #('DmRemoveResource' #(#pointer #int16) #int16 41069) #('DmRemoveSecretRecords' #(#pointer) #int16 41050) #('DmResetRecordStates' #(#pointer) #int16 41037) #('DmResizeRecord' #(#pointer #int16 #int32) #pointer 41053) #('DmResizeResource' #(#pointer #int32) #pointer 41058) #('DmResourceInfo' #(#pointer #int16 #pointer #pointer #pointer) #int16 41064) #('DmSearchRecord' #(#pointer #pointer) #int16 41650) #('DmSearchResource' #(#int32 #int16 #pointer #pointer) #int16 41062) #('DmSeekRecordInCategory' #(#pointer #pointer #int16 #int16 #int16) #int16 41075) #('DmSet' #(#pointer #int32 #int32 #int16) #int16 41086) #('DmSetDatabaseInfo' #(#int16 #int32 #pointer #pointer #pointer #pointer #pointer #pointer #pointer #pointer #pointer #pointer #pointer) #int16 41031) #('DmSetRecordInfo' #(#pointer #int16 #pointer #pointer) #int16 41041) #('DmSetResourceInfo' #(#pointer #int16 #pointer #pointer) #int16 41065) #('DmStrCopy' #(#pointer #int32 #pointer) #int16 41079) #('DmWrite' #(#pointer #int32 #pointer #int32) #int16 41078) #('DmWriteCheck' #(#pointer #int32 #int32) #int16 41081) #('EncDES' #(#pointer #pointer #pointer #int16) #int16 41726) #('EncDigestMD4' #(#pointer #int16 #int16) #int16 41725) #('EncDigestMD5' #(#pointer #int16 #int16) #int16 41713) #('ErrDisplayFileLineMsg' #(#pointer #int16 #pointer) #void 41092) #('ErrExceptionList' #() #pointer 41096) #('ErrThrow' #(#int32) #void 41095) #('EvtAddEventToQueue' #(#pointer) #void 41243) #('EvtAddUniqueEventToQueue' #(#pointer #int32 #int16) #void 41718) #('EvtCopyEvent' #(#pointer #pointer) #void 41244) #('EvtDequeueKeyEvent' #(#pointer #int16) #int16 41262) #('EvtDequeuePenPoint' #(#pointer) #int16 41256) #('EvtDequeuePenStrokeInfo' #(#pointer #pointer) #int16 41255) #('EvtEnableGraffiti' #(#int16) #void 41266) #('EvtEnqueueKey' #(#int16 #int16 #int16) #int16 41261) #('EvtEnqueuePenPoint' #(#pointer) #int16 41254) #('EvtEventAvail' #() #int16 41676) #('EvtFlushKeyQueue' #() #int16 41260) #('EvtFlushNextPenStroke' #() #int16 41257) #('EvtFlushPenQueue' #() #int16 41253) #('EvtGetEvent' #(#pointer #int32) #void 41245) #('EvtGetPen' #(#pointer #pointer #pointer) #void 41246) #('EvtGetPenBtnList' #(#pointer) #pointer 41250) #('EvtGetSysEvent' #(#pointer #int32) #void 41248) #('EvtInitialize' #() #void 41242) #('EvtKeyQueueEmpty' #() #int16 41265) #('EvtKeyQueueSize' #() #int32 41259) #('EvtPenQueueSize' #() #int32 41252) #('EvtProcessSoftKeyStroke' #(#pointer #pointer) #int16 41249) #('EvtResetAutoOffTimer' #() #int16 41264) #('EvtSetKeyQueuePtr' #(#pointer #int32) #int16 41258) #('EvtSetPenQueuePtr' #(#pointer #int32) #int16 41251) #('EvtSysEventAvail' #(#int16) #int16 41677) #('EvtSysInit' #() #int16 41247) #('EvtWakeup' #() #int16 41263) #('ExgAccept' #(#pointer) #int16 41739) #('ExgConnect' #(#pointer) #int16 41736) #('ExgDBRead' #(#pointer #pointer #pointer #pointer #int16 #pointer #int16) #int16 41794) #('ExgDBWrite' #(#pointer #pointer #pointer #int32 #int16) #int16 41795) #('ExgDisconnect' #(#pointer #int16) #int16 41740) #('ExgGet' #(#pointer) #int16 41738) #('ExgInit' #() #int16 41735) #('ExgNotifyReceive' #(#pointer) #int16 41744) #('ExgPut' #(#pointer) #int16 41737) #('ExgReceive' #(#pointer #pointer #int32 #pointer) #int32 41742) #('ExgRegisterData' #(#int32 #int16 #pointer) #int16 41743) #('ExgSend' #(#pointer #pointer #int32 #pointer) #int32 41741) #('FileClose' #(#int32) #int16 41779) #('FileControl' #(#int16 #int32 #pointer #pointer) #int16 41786) #('FileDelete' #(#int16 #pointer) #int16 41780) #('FileOpen' #(#int16 #pointer #int32 #int32 #int32 #pointer) #int32 41778) #('FileReadLow' #(#int32 #pointer #int32 #int16 #int32 #int32 #pointer) #int32 41781) #('FileSeek' #(#int32 #int32 #int16) #int16 41783) #('FileTell' #(#int32 #pointer #pointer) #int32 41784) #('FileTruncate' #(#int32 #int32) #int16 41785) #('FileWrite' #(#int32 #pointer #int32 #int32 #pointer) #int32 41782) #('Find' #(#pointer) #void 41577) #('FindDrawHeader' #(#pointer #pointer) #int16 41581) #('FindGetLineBounds' #(#pointer #pointer) #void 41580) #('FindSaveMatch' #(#pointer #int16 #int16 #int16 #int32 #int16 #int32) #int16 41579) #('FindStrInStr' #(#pointer #pointer #pointer) #int16 41578) #('FldCalcFieldHeight' #(#pointer #int16) #int16 41298) #('FldCompactText' #(#pointer) #void 41300) #('FldCopy' #(#pointer) #void 41267) #('FldCut' #(#pointer) #void 41268) #('FldDelete' #(#pointer #int16 #int16) #void 41310) #('FldDirty' #(#pointer) #int16 41301) #('FldDrawField' #(#pointer) #void 41269) #('FldEraseField' #(#pointer) #void 41270) #('FldFreeMemory' #(#pointer) #void 41271) #('FldGetAttributes' #(#pointer #pointer) #void 41295) #('FldGetBounds' #(#pointer #pointer) #void 41272) #('FldGetFont' #(#pointer) #int16 41280) #('FldGetInsPtPosition' #(#pointer) #int16 41285) #('FldGetMaxChars' #(#pointer) #int16 41306) #('FldGetNumberOfBlankLines' #(#pointer) #int16 41704) #('FldGetScrollPosition' #(#pointer) #int16 41288) #('FldGetScrollValues' #(#pointer #pointer #pointer #pointer) #void 41690) #('FldGetSelection' #(#pointer #pointer #pointer) #void 41274) #('FldGetTextAllocatedSize' #(#pointer) #int16 41290) #('FldGetTextHandle' #(#pointer) #pointer 41299) #('FldGetTextHeight' #(#pointer) #int16 41289) #('FldGetTextLength' #(#pointer) #int16 41291) #('FldGetTextPtr' #(#pointer) #pointer 41273) #('FldGetVisibleLines' #(#pointer) #int16 41294) #('FldGrabFocus' #(#pointer) #void 41283) #('FldHandleEvent' #(#pointer #pointer) #int16 41275) #('FldInsert' #(#pointer #pointer #int16) #int16 41309) #('FldMakeFullyVisible' #(#pointer) #int16 41314) #('FldNewField' #(#pointer #int16 #int16 #int16 #int16 #int16 #int16 #int32 #int16 #int16 #int16 #int16 #int16 #int16 #int16 #int16) #pointer 41773) #('FldPaste' #(#pointer) #void 41276) #('FldRecalculateField' #(#pointer #int16) #void 41277) #('FldReleaseFocus' #(#pointer) #void 41284) #('FldScrollField' #(#pointer #int16 #int16) #void 41292) #('FldScrollable' #(#pointer #int16) #int16 41293) #('FldSendChangeNotification' #(#pointer) #void 41297) #('FldSendHeightChangeNotification' #(#pointer #int16 #int16) #void 41313) #('FldSetAttributes' #(#pointer #pointer) #void 41296) #('FldSetBounds' #(#pointer #pointer) #void 41278) #('FldSetDirty' #(#pointer #int16) #void 41312) #('FldSetFont' #(#pointer #int16) #void 41281) #('FldSetInsPtPosition' #(#pointer #int16) #void 41286) #('FldSetInsertionPoint' #(#pointer #int16) #void 41730) #('FldSetMaxChars' #(#pointer #int16) #void 41307) #('FldSetScrollPosition' #(#pointer #int16) #void 41287) #('FldSetSelection' #(#pointer #int16 #int16) #void 41282) #('FldSetText' #(#pointer #pointer #int16 #int16) #void 41279) #('FldSetTextAllocatedSize' #(#pointer #int16) #void 41303) #('FldSetTextHandle' #(#pointer #pointer) #void 41304) #('FldSetTextPtr' #(#pointer #pointer) #void 41305) #('FldSetUsable' #(#pointer #int16) #void 41308) #('FldUndo' #(#pointer) #void 41311) #('FldWordWrap' #(#pointer #int16) #int16 41302) #('FntAverageCharWidth' #() #int16 41321) #('FntBaseLine' #() #int16 41318) #('FntCharHeight' #() #int16 41319) #('FntCharWidth' #(#int16) #int16 41322) #('FntCharsInWidth' #(#pointer #pointer #pointer #pointer) #void 41325) #('FntCharsWidth' #(#pointer #int16) #int16 41323) #('FntDefineFont' #(#int16 #pointer) #int16 41761) #('FntDescenderHeight' #() #int16 41324) #('FntGetFont' #() #int16 41315) #('FntGetFontPtr' #() #pointer 41317) #('FntGetScrollValues' #(#pointer #int16 #int16 #pointer #pointer) #void 41700) #('FntLineHeight' #() #int16 41320) #('FntLineWidth' #(#pointer #int16) #int16 41326) #('FntSetFont' #(#int16) #int16 41316) #('FntWordWrap' #(#pointer #int16) #int16 41689) #('FntWordWrapReverseNLines' #(#pointer #int16 #pointer #pointer) #void 41699) #('FontSelect' #(#int16) #int16 41760) #('FplAToF' #(#pointer #pointer) #void 41186) #('FplAdd' #(#pointer #int16 #int16) #void 41192) #('FplBase10Info' #(#int16 #pointer #pointer #pointer) #int16 41187) #('FplDiv' #(#pointer #int16 #int16) #void 41194) #('FplFToA' #(#int16 #pointer) #int16 41185) #('FplFloatToLong' #(#int16) #int32 41189) #('FplFloatToULong' #(#int16) #int32 41190) #('FplFree' #() #void 41184) #('FplInit' #() #int16 41183) #('FplLongToFloat' #(#pointer #int32) #void 41188) #('FplMul' #(#pointer #int16 #int16) #void 41191) #('FplSub' #(#pointer #int16 #int16) #void 41193) #('FrmActiveState' #(#pointer #int16) #int16 41787) #('FrmAddSpaceForObject' #(#pointer #pointer #int16 #int16) #int16 41770) #('FrmAlert' #(#int16) #int16 41362) #('FrmCloseAllForms' #() #void 41377) #('FrmCopyLabel' #(#pointer #int16 #pointer) #void 41356) #('FrmCopyTitle' #(#pointer #pointer) #void 41370) #('FrmCustomAlert' #(#int16 #pointer #pointer #pointer) #int16 41364) #('FrmDeleteForm' #(#pointer) #void 41328) #('FrmDispatchEvent' #(#pointer) #int16 41376) #('FrmDoDialog' #(#pointer) #int16 41363) #('FrmDrawForm' #(#pointer) #void 41329) #('FrmEraseForm' #(#pointer) #void 41330) #('FrmGetActiveForm' #() #pointer 41331) #('FrmGetActiveFormID' #() #int16 41333) #('FrmGetControlGroupSelection' #(#pointer #int16) #int16 41354) #('FrmGetControlValue' #(#pointer #int16) #int16 41352) #('FrmGetFirstForm' #() #pointer 41367) #('FrmGetFocus' #(#pointer) #int16 41336) #('FrmGetFormBounds' #(#pointer #pointer) #void 41339) #('FrmGetFormId' #(#pointer) #int16 41341) #('FrmGetFormPtr' #(#int16) #pointer 41342) #('FrmGetGadgetData' #(#pointer #int16) #pointer 41379) #('FrmGetLabel' #(#pointer #int16) #pointer 41358) #('FrmGetNumberOfObjects' #(#pointer) #int16 41343) #('FrmGetObjectBounds' #(#pointer #int16 #pointer) #void 41369) #('FrmGetObjectId' #(#pointer #int16) #int16 41345) #('FrmGetObjectIndex' #(#pointer #int16) #int16 41344) #('FrmGetObjectPosition' #(#pointer #int16 #pointer #pointer) #void 41350) #('FrmGetObjectPtr' #(#pointer #int16) #pointer 41347) #('FrmGetObjectType' #(#pointer #int16) #int16 41346) #('FrmGetTitle' #(#pointer) #pointer 41360) #('FrmGetUserModifiedState' #(#pointer) #int16 41334) #('FrmGetWindowHandle' #(#pointer) #pointer 41340) #('FrmGotoForm' #(#int16) #void 41371) #('FrmHandleEvent' #(#pointer #pointer) #int16 41338) #('FrmHelp' #(#int16) #void 41365) #('FrmHideObject' #(#pointer #int16) #void 41348) #('FrmInitForm' #(#int16) #pointer 41327) #('FrmNewBitmap' #(#pointer #int16 #int16 #int16 #int16) #pointer 41776) #('FrmNewForm' #(#int16 #pointer #int16 #int16 #int16 #int16 #int16 #int16 #int16 #int16) #pointer 41771) #('FrmNewGadget' #(#pointer #int16 #int16 #int16 #int16 #int16) #pointer 41777) #('FrmNewLabel' #(#pointer #int16 #pointer #int16 #int16 #int16) #pointer 41775) #('FrmPointInTitle' #(#pointer #int16 #int16) #int16 41685) #('FrmPopupForm' #(#int16) #void 41372) #('FrmRemoveObject' #(#pointer #int16) #int16 41797) #('FrmReturnToForm' #(#int16) #void 41374) #('FrmSaveAllForms' #() #void 41378) #('FrmSetActiveForm' #(#pointer) #void 41332) #('FrmSetCategoryLabel' #(#pointer #int16 #pointer) #void 41359) #('FrmSetControlGroupSelection' #(#pointer #int16 #int16) #void 41355) #('FrmSetControlValue' #(#pointer #int16 #int16) #void 41353) #('FrmSetEventHandler' #(#pointer #pointer) #void 41375) #('FrmSetFocus' #(#pointer #int16) #void 41337) #('FrmSetGadgetData' #(#pointer #int16 #pointer) #void 41380) #('FrmSetMenu' #(#pointer #int16) #void 41712) #('FrmSetNotUserModified' #(#pointer) #void 41335) #('FrmSetObjectBounds' #(#pointer #int16 #pointer) #void 41731) #('FrmSetObjectPosition' #(#pointer #int16 #int16 #int16) #void 41351) #('FrmSetTitle' #(#pointer #pointer) #void 41361) #('FrmShowObject' #(#pointer #int16) #void 41349) #('FrmUpdateForm' #(#int16 #int16) #void 41373) #('FrmUpdateScrollers' #(#pointer #int16 #int16 #int16 #int16) #void 41366) #('FrmValidatePtr' #(#pointer) #int16 41767) #('FrmVisible' #(#pointer) #int16 41368) #('FtrGet' #(#int32 #int16 #pointer) #int16 41595) #('FtrGetByIndex' #(#int16 #int16 #pointer #pointer #pointer) #int16 41597) #('FtrInit' #() #int16 41593) #('FtrSet' #(#int32 #int16 #int32) #int16 41596) #('FtrUnregister' #(#int32 #int16) #int16 41594) #('GetCharAttr' #() #pointer 41621) #('GetCharCaselessValue' #() #pointer 41622) #('GetCharSortValue' #() #pointer 41620) #('GrfAddMacro' #(#pointer #pointer #int16) #int16 41616) #('GrfAddPoint' #(#pointer) #int16 41603) #('GrfCleanState' #() #int16 41605) #('GrfDeleteMacro' #(#int16) #int16 41615) #('GrfFieldChange' #(#int16 #pointer) #int16 41619) #('GrfFilterPoints' #() #int16 41608) #('GrfFindBranch' #(#int16) #int16 41611) #('GrfFlushPoints' #() #int16 41602) #('GrfFree' #() #int16 41599) #('GrfGetAndExpandMacro' #(#pointer #pointer #pointer) #int16 41617) #('GrfGetGlyphMapping' #(#int16 #pointer #pointer #pointer #pointer) #int16 41613) #('GrfGetMacro' #(#pointer #pointer #pointer) #int16 41607) #('GrfGetMacroName' #(#int16 #pointer) #int16 41614) #('GrfGetNumPoints' #(#pointer) #int16 41609) #('GrfGetPoint' #(#int16 #pointer) #int16 41610) #('GrfGetState' #(#pointer #pointer #pointer #pointer) #int16 41600) #('GrfInit' #() #int16 41598) #('GrfInitState' #() #int16 41604) #('GrfMatch' #(#pointer #pointer #pointer #pointer #pointer) #int16 41606) #('GrfMatchGlyph' #(#pointer #int16 #int16) #int16 41612) #('GrfProcessStroke' #(#pointer #pointer #int16) #int16 41618) #('GrfSetState' #(#int16 #int16 #int16) #int16 41601) #('GsiEnable' #(#int16) #void 41629) #('GsiEnabled' #() #int16 41630) #('GsiInitialize' #() #void 41627) #('GsiSetLocation' #(#int16 #int16) #void 41628) #('GsiSetShiftState' #(#int16 #int16) #void 41631) #('HwrBacklight' #(#int16 #int16) #int16 41706) #('HwrBatteryLevel' #() #int16 41544) #('HwrCursor' #(#int16 #pointer #pointer #pointer #pointer) #int16 41543) #('HwrDelay' #(#int32) #void 41545) #('HwrDisableDataWrites' #() #void 41547) #('HwrDockSignals' #(#pointer #int16 #int16) #int16 41559) #('HwrDoze' #(#int16) #void 41535) #('HwrEnableDataWrites' #() #int16 41546) #('HwrGetRAMMapping' #(#pointer #pointer #pointer #pointer) #void 41532) #('HwrGetROMToken' #(#int16 #int32 #pointer #pointer) #int16 41792) #('HwrIRQ1Handler' #(#int32) #void 41553) #('HwrIRQ2Handler' #(#int32) #void 41554) #('HwrIRQ3Handler' #(#int32) #void 41555) #('HwrIRQ4Handler' #(#int32) #void 41556) #('HwrIRQ5Handler' #(#int32) #void 41557) #('HwrIRQ6Handler' #(#int32) #void 41558) #('HwrLCDBaseAddr' #(#pointer) #int16 41548) #('HwrLCDDrawBitmap' #(#int16 #int16 #pointer #int16) #int16 41549) #('HwrLCDGetDepth' #(#int16) #int16 41791) #('HwrLCDInit' #(#int16 #pointer #int16 #int16 #int16) #int16 41540) #('HwrLCDSleep' #(#int16 #int16) #int16 41541) #('HwrLCDWake' #() #int16 41552) #('HwrMemReadable' #(#pointer) #int32 41534) #('HwrMemWritable' #(#pointer) #int32 41533) #('HwrPluggedIn' #() #int16 41560) #('HwrSetCPUDutyCycle' #(#pointer) #int16 41539) #('HwrSetSystemClock' #(#pointer) #int16 41538) #('HwrSleep' #(#int16 #int16) #void 41536) #('HwrTimerInit' #(#int16) #int16 41542) #('HwrTimerSleep' #(#int16) #int16 41550) #('HwrTimerWake' #(#int16) #int16 41551) #('HwrWake' #() #int16 41537) #('ImcReadFieldNoSemicolon' #(#pointer #int16 #pointer #int16) #pointer 41750) #('ImcReadFieldQuotablePrintable' #(#pointer #int16 #pointer #int16 #int16 #int16) #pointer 41751) #('ImcReadPropertyParameter' #(#pointer #int16 #pointer #pointer #pointer) #void 41752) #('ImcReadWhiteSpace' #(#pointer #int16 #pointer #pointer) #void 41754) #('ImcSkipAllPropertyParameters' #(#pointer #int16 #pointer #pointer #pointer) #void 41753) #('ImcStringIsAscii' #(#pointer) #int16 41757) #('ImcWriteNoSemicolon' #(#pointer #pointer #pointer) #void 41756) #('ImcWriteQuotedPrintable' #(#pointer #pointer #pointer #int16) #void 41755) #('InsPtCheckBlink' #() #void 41391) #('InsPtEnable' #(#int16) #void 41387) #('InsPtEnabled' #() #int16 41388) #('InsPtGetHeight' #() #int16 41390) #('InsPtGetLocation' #(#pointer #pointer) #void 41386) #('InsPtInitialize' #() #void 41384) #('InsPtSetHeight' #(#int16) #void 41389) #('InsPtSetLocation' #(#int16 #int16) #void 41385) #('KeyCurrentState' #() #int32 41634) #('KeyHandleInterrupt' #(#int16 #int32) #int32 41633) #('KeyInit' #() #int16 41632) #('KeyRates' #(#int16 #pointer #pointer #pointer #pointer) #int16 41636) #('KeyResetDoubleTap' #() #int16 41635) #('KeySetMask' #(#int32) #int32 41679) #('KeySleep' #(#int16 #int16) #int16 41637) #('KeyWake' #() #int16 41638) #('LocGetNumberSeparators' #(#int16 #pointer #pointer) #void 41721) #('LstDrawList' #(#pointer) #void 41393) #('LstEraseList' #(#pointer) #void 41394) #('LstGetNumberOfItems' #(#pointer) #int16 41402) #('LstGetSelection' #(#pointer) #int16 41395) #('LstGetSelectionText' #(#pointer #int16) #pointer 41396) #('LstGetVisibleItems' #(#pointer) #int16 41727) #('LstHandleEvent' #(#pointer #pointer) #int16 41397) #('LstMakeItemVisible' #(#pointer #int16) #void 41401) #('LstNewList' #(#pointer #int16 #int16 #int16 #int16 #int16 #int16 #int16 #int16) #int16 41774) #('LstPopupList' #(#pointer) #int16 41403) #('LstScrollList' #(#pointer #int16 #int16) #int16 41723) #('LstSetDrawFunction' #(#pointer #pointer) #void 41392) #('LstSetHeight' #(#pointer #int16) #void 41398) #('LstSetListChoices' #(#pointer #pointer #pointer) #void 41400) #('LstSetPosition' #(#pointer #int16 #int16) #void 41404) #('LstSetSelection' #(#pointer #int16) #void 41399) #('LstSetTopItem' #(#pointer #int16) #void 41653) #('MdmDial' #(#pointer #pointer #pointer #pointer) #int16 41648) #('MdmHangUp' #(#pointer) #int16 41649) #('MemCardFormat' #(#int16 #pointer #pointer #pointer) #int16 40963) #('MemCardInfo' #(#int16 #pointer #pointer #pointer #pointer #pointer #pointer #pointer) #int16 40964) #('MemChunkFree' #(#pointer) #int16 40978) #('MemChunkNew' #(#int16 #int32 #int16) #pointer 40977) #('MemCmp' #(#pointer #pointer #int32) #int16 41687) #('MemDebugMode' #() #int16 41019) #('MemHandleCardNo' #(#pointer) #int16 41009) #('MemHandleDataStorage' #(#pointer) #int16 41008) #('MemHandleFlags' #(#pointer) #int16 41004) #('MemHandleFree' #(#pointer) #int16 41003) #('MemHandleHeapID' #(#pointer) #int16 41007) #('MemHandleLock' #(#pointer) #pointer 40993) #('MemHandleLockCount' #(#pointer) #int16 40991) #('MemHandleNew' #(#int32) #pointer 40990) #('MemHandleOwner' #(#pointer) #int16 41006) #('MemHandleResetLock' #(#pointer) #int16 41012) #('MemHandleResize' #(#pointer #int32) #int16 41011) #('MemHandleSetOwner' #(#pointer #int16) #int16 41010) #('MemHandleSize' #(#pointer) #int32 41005) #('MemHandleToLocalID' #(#pointer) #int32 40992) #('MemHandleUnlock' #(#pointer) #int16 40994) #('MemHeapCheck' #(#int16) #int16 41017) #('MemHeapCompact' #(#int16) #int16 40974) #('MemHeapDynamic' #(#int16) #int16 41022) #('MemHeapFlags' #(#int16) #int16 40973) #('MemHeapFreeByOwnerID' #(#int16 #int16) #int16 40976) #('MemHeapFreeBytes' #(#int16 #pointer #pointer) #int16 40971) #('MemHeapID' #(#int16 #int16) #int16 40969) #('MemHeapInit' #(#int16 #int16 #int16) #int16 40975) #('MemHeapPtr' #(#int16) #pointer 40970) #('MemHeapScramble' #(#int16) #int16 41016) #('MemHeapSize' #(#int16) #int32 40972) #('MemInit' #() #int16 40960) #('MemInitHeapTable' #(#int16) #int16 40961) #('MemKernelInit' #() #int16 41002) #('MemLocalIDKind' #(#int32) #int16 40996) #('MemLocalIDToGlobal' #(#int32 #int16) #pointer 40995) #('MemLocalIDToLockedPtr' #(#int32 #int16) #pointer 41014) #('MemLocalIDToPtr' #(#int32 #int16) #pointer 40997) #('MemMove' #(#pointer #pointer #int32) #int16 40998) #('MemNVParams' #(#int16 #pointer) #int16 41023) #('MemNumCards' #() #int16 41018) #('MemNumHeaps' #(#int16) #int16 40967) #('MemNumRAMHeaps' #(#int16) #int16 40968) #('MemPtrCardNo' #(#pointer) #int16 40985) #('MemPtrDataStorage' #(#pointer) #int16 41001) #('MemPtrFlags' #(#pointer) #int16 40981) #('MemPtrHeapID' #(#pointer) #int16 40984) #('MemPtrNew' #(#int32) #pointer 40979) #('MemPtrOwner' #(#pointer) #int16 40983) #('MemPtrRecoverHandle' #(#pointer) #pointer 40980) #('MemPtrResetLock' #(#pointer) #int16 40989) #('MemPtrResize' #(#pointer #int32) #int16 40988) #('MemPtrSetOwner' #(#pointer #int16) #int16 40987) #('MemPtrSize' #(#pointer) #int32 40982) #('MemPtrToLocalID' #(#pointer) #int32 40986) #('MemPtrUnlock' #(#pointer) #int16 41013) #('MemSemaphoreRelease' #(#int16) #int16 41021) #('MemSemaphoreReserve' #(#int16) #int16 41020) #('MemSet' #(#pointer #int32 #int16) #int16 40999) #('MemSetDebugMode' #(#int16) #int16 41015) #('MemStoreInfo' #(#int16 #int16 #pointer #pointer #pointer #pointer #pointer #pointer #pointer #pointer #pointer) #int16 40965) #('MemStoreInit' #(#int32 #int16 #int16 #int16 #pointer #pointer #int16) #int16 40962) #('MemStoreSearch' #(#pointer #int32 #pointer) #int16 41000) #('MemStoreSetInfo' #(#int16 #int16 #pointer #pointer #pointer #pointer #pointer #pointer #pointer #pointer #pointer) #int16 40966) #('MenuDispose' #(#pointer) #void 41406) #('MenuDrawMenu' #(#pointer) #void 41408) #('MenuEraseStatus' #(#pointer) #void 41409) #('MenuGetActiveMenu' #() #pointer 41410) #('MenuHandleEvent' #(#pointer #pointer #pointer) #int16 41407) #('MenuInit' #(#int16) #pointer 41405) #('MenuSetActiveMenu' #(#pointer) #pointer 41411) #('MenuSetActiveMenuRscID' #(#int16) #void 41722) #('PenCalibrate' #(#pointer #pointer #pointer #pointer) #int16 41585) #('PenClose' #() #int16 41583) #('PenGetRawPen' #(#pointer) #int16 41584) #('PenOpen' #() #int16 41582) #('PenRawToScreen' #(#pointer) #int16 41586) #('PenResetCalibration' #() #int16 41588) #('PenScreenToRaw' #(#pointer) #int16 41587) #('PenSleep' #() #int16 41589) #('PenWake' #() #int16 41590) #('PhoneNumberLookup' #(#pointer) #void 41711) #('PrefGetAppPreferences' #(#int32 #int16 #pointer #pointer #int16) #int16 41683) #('PrefGetAppPreferencesV10' #(#int32 #int16 #pointer #int16) #int16 41518) #('PrefGetPreference' #(#int16) #int32 41681) #('PrefGetPreferences' #(#pointer) #void 41516) #('PrefOpenPreferenceDB' #(#int16) #pointer 41696) #('PrefOpenPreferenceDBV10' #() #pointer 41515) #('PrefSetAppPreferences' #(#int32 #int16 #int16 #pointer #int16 #int16) #void 41684) #('PrefSetAppPreferencesV10' #(#int32 #int16 #pointer #int16) #void 41519) #('PrefSetPreference' #(#int16 #int32) #void 41682) #('PrefSetPreferences' #(#pointer) #void 41517) #('PrgHandleEvent' #(#pointer #pointer) #int16 41749) #('PrgStartDialog' #(#pointer #pointer) #pointer 41746) #('PrgStopDialog' #(#pointer #int16) #void 41747) #('PrgUpdateDialog' #(#pointer #int16 #int16 #pointer #int16) #void 41748) #('PwdExists' #() #int16 41623) #('PwdRemove' #() #void 41626) #('PwdSet' #(#pointer #pointer) #void 41625) #('PwdVerify' #(#pointer) #int16 41624) #('RctCopyRectangle' #(#pointer #pointer) #void 41413) #('RctGetIntersection' #(#pointer #pointer #pointer) #void 41417) #('RctInsetRectangle' #(#pointer #int16) #void 41414) #('RctOffsetRectangle' #(#pointer #int16 #int16) #void 41415) #('RctPtInRectangle' #(#int16 #int16 #pointer) #int16 41416) #('RctSetRectangle' #(#pointer #int16 #int16 #int16 #int16) #void 41412) #('ResLoadForm' #(#int16) #pointer 41591) #('ResLoadMenu' #(#int16) #pointer 41592) #('SclDrawScrollBar' #(#pointer) #void 41655) #('SclGetScrollBar' #(#pointer #pointer #pointer #pointer #pointer) #void 41703) #('SclHandleEvent' #(#pointer #pointer) #int16 41656) #('SclSetScrollBar' #(#pointer #int16 #int16 #int16 #int16) #void 41654) #('ScrCompressScanLine' #(#pointer #pointer #int16 #pointer #int16) #int16 41203) #('ScrCopyRectangle' #(#pointer #pointer #int16 #int16 #int16 #int16 #int16 #int16) #int16 41196) #('ScrDeCompressScanLine' #(#pointer #pointer #int16) #int16 41204) #('ScrDisplayMode' #(#int16 #pointer #pointer #pointer #pointer) #int16 41790) #('ScrDrawChars' #(#pointer #int16 #int16 #int16 #int16 #int16 #int16 #int16 #int16 #pointer #int16 #pointer) #void 41197) #('ScrDrawNotify' #(#int16 #int16 #int16 #int16) #void 41201) #('ScrInit' #() #void 41195) #('ScrLineRoutine' #(#pointer #int16 #int16 #int16 #int16) #void 41198) #('ScrRectangleRoutine' #(#pointer #int16 #int16 #int16 #int16) #void 41199) #('ScrScreenInfo' #(#pointer) #void 41200) #('ScrSendUpdateArea' #(#int16) #void 41202) #('SelectDay' #(#int16 #pointer #pointer #pointer #pointer) #int16 41680) #('SelectDayV10' #(#pointer #pointer #pointer #pointer) #int16 41562) #('SelectTime' #(#pointer #pointer #int16 #pointer #int16) #int16 41563) #('SerReceiveISP' #() #int16 41168) #('SlkClose' #() #int16 41170) #('SlkCloseSocket' #(#int16) #int16 41172) #('SlkFlushSocket' #(#int16 #int32) #int16 41175) #('SlkOpen' #() #int16 41169) #('SlkOpenSocket' #(#int16 #pointer #int16) #int16 41171) #('SlkProcessRPC' #(#pointer #pointer) #int16 41180) #('SlkReceivePacket' #(#int16 #int16 #pointer #pointer #int16 #int32) #int16 41178) #('SlkSendPacket' #(#pointer #pointer) #int16 41177) #('SlkSetSocketListener' #(#int16 #pointer) #int16 41176) #('SlkSocketRefNum' #(#int16 #pointer) #int16 41173) #('SlkSocketSetTimeout' #(#int16 #int32) #int16 41174) #('SlkSysPktDefaultResponse' #(#pointer #pointer) #int16 41179) #('SndCreateMidiList' #(#int32 #int16 #pointer #pointer) #int16 41646) #('SndDoCmd' #(#pointer #pointer #int16) #int16 41523) #('SndGetDefaultVolume' #(#pointer #pointer #pointer) #void 41522) #('SndInit' #() #int16 41520) #('SndPlaySmf' #(#pointer #int16 #pointer #pointer #pointer #pointer #int16) #int16 41645) #('SndPlaySystemSound' #(#int16) #void 41524) #('SndSetDefaultVolume' #(#pointer #pointer #pointer) #void 41521) #('StrAToI' #(#pointer) #int32 41166) #('StrCaselessCompare' #(#pointer #pointer) #int16 41162) #('StrCat' #(#pointer #pointer) #pointer 41158) #('StrChr' #(#pointer #int16) #pointer 41164) #('StrCompare' #(#pointer #pointer) #int16 41160) #('StrCopy' #(#pointer #pointer) #pointer 41157) #('StrDelocalizeNumber' #(#pointer #int16 #int16) #pointer 41720) #('StrIToA' #(#pointer #int32) #pointer 41161) #('StrIToH' #(#pointer #int32) #pointer 41163) #('StrLen' #(#pointer) #int16 41159) #('StrLocalizeNumber' #(#pointer #int16 #int16) #pointer 41719) #('StrNCaselessCompare' #(#pointer #pointer #int32) #int16 41710) #('StrNCat' #(#pointer #pointer #int16) #pointer 41686) #('StrNCompare' #(#pointer #pointer #int32) #int16 41709) #('StrNCopy' #(#pointer #pointer #int16) #pointer 41678) #('StrPrintF' #(#pointer #pointer #int32) #int16 41694) #('StrStr' #(#pointer #pointer) #pointer 41165) #('StrToLower' #(#pointer #pointer) #pointer 41167) #('StrVPrintF' #(#pointer #pointer #pointer) #int16 41695) #('SysAppExit' #(#pointer #pointer #pointer) #int16 41104) #('SysAppLaunch' #(#int16 #int32 #int16 #int16 #pointer #pointer) #int16 41102) #('SysAppLauncherDialog' #() #void 41140) #('SysAppStartup' #(#pointer #pointer #pointer) #int16 41103) #('SysBatteryDialog' #() #void 41147) #('SysBatteryInfo' #(#int16 #pointer #pointer #pointer #pointer #pointer #pointer) #int16 41764) #('SysBatteryInfoV20' #(#int16 #pointer #pointer #pointer #pointer #pointer) #int16 41142) #('SysBinarySearch' #(#pointer #int16 #int16 #pointer #pointer #int32 #pointer #int16) #int16 41715) #('SysBroadcastActionCode' #(#int16 #pointer) #int16 41097) #('SysColdBoot' #(#pointer #int32 #pointer #int32 #int32) #void 41099) #('SysCopyStringResource' #(#pointer #int16) #void 41148) #('SysCreateDataBaseList' #(#int32 #int32 #pointer #pointer #int16) #int16 41691) #('SysCreatePanelList' #(#pointer #pointer) #int16 41692) #('SysCurAppDatabase' #(#pointer #pointer) #int16 41132) #('SysCurAppInfoPV20' #() #pointer 41128) #('SysDisableInts' #() #int16 41125) #('SysDoze' #(#int16) #void 41101) #('SysErrString' #(#int16 #pointer #int16) #pointer 41716) #('SysEvGroupCreate' #(#pointer #pointer #int32) #int16 41672) #('SysEvGroupRead' #(#int32 #pointer) #int16 41674) #('SysEvGroupSignal' #(#int32 #int32 #int32 #int32) #int16 41673) #('SysEvGroupWait' #(#int32 #int32 #int32 #int32 #int32) #int16 41675) #('SysFatalAlert' #(#pointer) #int16 41133) #('SysFormPointerArrayToStrings' #(#pointer #int16) #pointer 41153) #('SysGetAppInfo' #(#pointer #pointer) #pointer 41788) #('SysGetOSVersionString' #() #pointer 41763) #('SysGetStackInfo' #(#pointer #pointer) #int16 41789) #('SysGetTrapAddress' #(#int16) #pointer 41107) #('SysGraffitiReferenceDialog' #(#int16) #void 41697) #('SysGremlins' #(#int16 #pointer) #int32 41796) #('SysHandleEvent' #(#pointer) #int16 41129) #('SysInit' #() #void 41130) #('SysInsertionSort' #(#pointer #int16 #int16 #pointer #int32) #void 41651) #('SysKernelInfo' #(#pointer) #int16 41149) #('SysKeyboardDialog' #(#int16) #void 41698) #('SysKeyboardDialogV10' #() #void 41139) #('SysLaunchConsole' #() #int16 41150) #('SysLibFind' #(#pointer #pointer) #int16 41146) #('SysLibInstall' #(#pointer #pointer) #int16 41143) #('SysLibLoad' #(#int32 #int32 #pointer) #int16 41644) #('SysLibRemove' #(#int16) #int16 41144) #('SysLibTblEntry' #(#int16) #pointer 41145) #('SysMailboxCreate' #(#pointer #pointer #int32) #int16 41657) #('SysMailboxDelete' #(#int32) #int16 41658) #('SysMailboxFlush' #(#int32) #int16 41659) #('SysMailboxSend' #(#int32 #pointer #int32) #int16 41660) #('SysMailboxWait' #(#int32 #pointer #int32 #int32) #int16 41661) #('SysNewOwnerID' #() #int16 41123) #('SysQSort' #(#pointer #int16 #int16 #pointer #int32) #void 41131) #('SysRandom' #(#int32) #int16 41154) #('SysResSemaphoreCreate' #(#pointer #pointer) #int16 41134) #('SysResSemaphoreDelete' #(#int32) #int16 41135) #('SysResSemaphoreRelease' #(#int32) #int16 41137) #('SysResSemaphoreReserve' #(#int32 #int32 #int32) #int16 41136) #('SysReset' #() #void 41100) #('SysRestoreStatus' #(#int16) #void 41126) #('SysSemaphoreCreate' #(#pointer #pointer #int32) #int16 41109) #('SysSemaphoreDelete' #(#int32) #int16 41110) #('SysSemaphoreSet' #(#int32) #int16 41124) #('SysSemaphoreSignal' #(#int32) #int16 41112) #('SysSemaphoreWait' #(#int32 #int32 #int32) #int16 41111) #('SysSetA5' #(#int32) #int32 41105) #('SysSetAutoOffTime' #(#int16) #int16 41152) #('SysSetPerformance' #(#pointer #pointer) #int16 41141) #('SysSetTrapAddress' #(#int16 #pointer) #int16 41106) #('SysSleep' #(#int16 #int16) #void 41138) #('SysStringByIndex' #(#int16 #int16 #pointer #int16) #pointer 41717) #('SysTaskCreate' #(#pointer #pointer #pointer #pointer #int32 #int32 #int32 #int32) #int16 41115) #('SysTaskDelay' #(#int32) #int16 41120) #('SysTaskDelete' #(#int32 #int32) #int16 41116) #('SysTaskID' #() #int32 41118) #('SysTaskResume' #(#int32) #int16 41666) #('SysTaskSetTermProc' #(#int32 #pointer) #int16 41121) #('SysTaskSuspend' #(#int32) #int16 41665) #('SysTaskSwitching' #(#int16) #int16 41155) #('SysTaskTrigger' #(#int32) #int16 41117) #('SysTaskUserInfoPtr' #(#int32) #pointer 41119) #('SysTaskWait' #(#int32) #int16 41662) #('SysTaskWaitClr' #() #int16 41664) #('SysTaskWake' #(#int32) #int16 41663) #('SysTicksPerSecond' #() #int16 41705) #('SysTimerCreate' #(#pointer #pointer #pointer #int32 #int32) #int16 41113) #('SysTimerDelete' #(#int32) #int16 41151) #('SysTimerRead' #(#int32 #pointer) #int16 41156) #('SysTimerWrite' #(#int32 #int32) #int16 41114) #('SysTranslateKernelErr' #(#int16) #int16 41108) #('SysUIAppSwitch' #(#int16 #int32 #int16 #pointer) #int16 41127) #('SysUIBusy' #(#int16 #int16) #int16 41765) #('SysUILaunch' #() #void 41122) #('SysUnimplemented' #() #void 41098) #('TblDrawTable' #(#pointer) #void 41418) #('TblEditing' #(#pointer) #int16 41448) #('TblEraseTable' #(#pointer) #void 41419) #('TblFindRowData' #(#pointer #int32 #pointer) #int16 41458) #('TblFindRowID' #(#pointer #int16 #pointer) #int16 41455) #('TblGetBounds' #(#pointer #pointer) #void 41434) #('TblGetColumnSpacing' #(#pointer #int16) #int16 41457) #('TblGetColumnWidth' #(#pointer #int16) #int16 41436) #('TblGetCurrentField' #(#pointer) #pointer 41449) #('TblGetItemBounds' #(#pointer #int16 #int16 #pointer) #void 41421) #('TblGetItemFont' #(#pointer #int16 #int16) #int16 41758) #('TblGetItemInt' #(#pointer #int16 #int16) #int16 41423) #('TblGetLastUsableRow' #(#pointer) #int16 41456) #('TblGetNumberOfRows' #(#pointer) #int16 41428) #('TblGetRowData' #(#pointer #int16) #int32 41459) #('TblGetRowHeight' #(#pointer #int16) #int16 41451) #('TblGetRowID' #(#pointer #int16) #int16 41437) #('TblGetSelection' #(#pointer #pointer #pointer) #int16 41441) #('TblGrabFocus' #(#pointer #int16 #int16) #void 41453) #('TblHandleEvent' #(#pointer #pointer) #int16 41420) #('TblHasScrollBar' #(#pointer #int16) #void 41702) #('TblInsertRow' #(#pointer #int16) #void 41442) #('TblMarkRowInvalid' #(#pointer #int16) #void 41439) #('TblMarkTableInvalid' #(#pointer) #void 41440) #('TblRedrawTable' #(#pointer) #void 41445) #('TblReleaseFocus' #(#pointer) #void 41447) #('TblRemoveRow' #(#pointer #int16) #void 41443) #('TblRowInvalid' #(#pointer #int16) #int16 41444) #('TblRowSelectable' #(#pointer #int16) #int16 41431) #('TblRowUsable' #(#pointer #int16) #int16 41446) #('TblSelectItem' #(#pointer #int16 #int16) #void 41422) #('TblSetBounds' #(#pointer #pointer) #void 41708) #('TblSetColumnEditIndicator' #(#pointer #int16 #int16) #void 41688) #('TblSetColumnSpacing' #(#pointer #int16 #int16) #void 41461) #('TblSetColumnUsable' #(#pointer #int16 #int16) #void 41450) #('TblSetColumnWidth' #(#pointer #int16 #int16) #void 41452) #('TblSetCustomDrawProcedure' #(#pointer #int16 #pointer) #void 41429) #('TblSetItemFont' #(#pointer #int16 #int16 #int16) #void 41759) #('TblSetItemInt' #(#pointer #int16 #int16 #int16) #void 41424) #('TblSetItemPtr' #(#pointer #int16 #int16 #pointer) #void 41454) #('TblSetItemStyle' #(#pointer #int16 #int16 #int16) #void 41425) #('TblSetLoadDataProcedure' #(#pointer #int16 #pointer) #void 41432) #('TblSetRowData' #(#pointer #int16 #int32) #void 41460) #('TblSetRowHeight' #(#pointer #int16 #int16) #void 41435) #('TblSetRowID' #(#pointer #int16 #int16) #void 41438) #('TblSetRowSelectable' #(#pointer #int16 #int16) #void 41430) #('TblSetRowStaticHeight' #(#pointer #int16 #int16) #void 41701) #('TblSetRowUsable' #(#pointer #int16 #int16) #void 41427) #('TblSetSaveDataProcedure' #(#pointer #int16 #pointer) #void 41433) #('TblUnhighlightSelection' #(#pointer) #void 41426) #('TimAdjust' #(#pointer #int32) #void 41214) #('TimDateTimeToSeconds' #(#pointer) #int32 41213) #('TimGetAlarm' #() #int32 41210) #('TimGetSeconds' #() #int32 41205) #('TimGetTicks' #() #int32 41207) #('TimHandleInterrupt' #(#int16) #void 41211) #('TimInit' #() #int16 41208) #('TimSecondsToDateTime' #(#int32 #pointer) #void 41212) #('TimSetAlarm' #(#int32) #int32 41209) #('TimSetSeconds' #(#int32) #void 41206) #('TimSleep' #(#int16 #int16) #int16 41215) #('TimWake' #() #int16 41216) #('TimeToAscii' #(#int16 #int16 #int16 #pointer) #void 41576) #('UIInitialize' #() #void 41382) #('UIReset' #() #void 41383) #('WinAddWindow' #(#pointer) #void 41466) #('WinClipRectangle' #(#pointer) #void 41490) #('WinCopyRectangle' #(#int32 #int32 #pointer #int16 #int16 #int16) #void 41481) #('WinCreateOffscreenWindow' #(#int16 #int16 #int16 #pointer) #pointer 41463) #('WinCreateWindow' #(#pointer #int16 #int16 #int16 #pointer) #pointer 41462) #('WinDeleteWindow' #(#pointer #int16) #void 41464) #('WinDisableWindow' #(#pointer) #void 41475) #('WinDisplayToWindowPt' #(#pointer #pointer) #void 41485) #('WinDrawBitmap' #(#pointer #int16 #int16) #void 41510) #('WinDrawChars' #(#pointer #int16 #int16 #int16) #void 41504) #('WinDrawGrayLine' #(#int16 #int16 #int16 #int16) #void 41492) #('WinDrawGrayRectangleFrame' #(#int16 #pointer) #void 41500) #('WinDrawInvertedChars' #(#pointer #int16 #int16 #int16) #void 41514) #('WinDrawLine' #(#int16 #int16 #int16 #int16) #void 41491) #('WinDrawRectangle' #(#pointer #int16) #void 41496) #('WinDrawRectangleFrame' #(#int16 #pointer) #void 41499) #('WinDrawWindowFrame' #() #void 41477) #('WinEnableWindow' #(#pointer) #void 41474) #('WinEraseChars' #(#pointer #int16 #int16 #int16) #void 41505) #('WinEraseLine' #(#int16 #int16 #int16 #int16) #void 41493) #('WinEraseRectangle' #(#pointer #int16) #void 41497) #('WinEraseRectangleFrame' #(#int16 #pointer) #void 41501) #('WinEraseWindow' #() #void 41478) #('WinFillLine' #(#int16 #int16 #int16 #int16) #void 41495) #('WinFillRectangle' #(#pointer #int16) #void 41513) #('WinGetActiveWindow' #() #pointer 41471) #('WinGetClip' #(#pointer) #void 41487) #('WinGetDisplayExtent' #(#pointer #pointer) #void 41483) #('WinGetDisplayWindow' #() #pointer 41472) #('WinGetDrawWindow' #() #pointer 41470) #('WinGetFirstWindow' #() #pointer 41473) #('WinGetFramesRectangle' #(#int16 #pointer #pointer) #void 41503) #('WinGetPattern' #(#pointer) #void 41507) #('WinGetWindowBounds' #(#pointer) #void 41512) #('WinGetWindowExtent' #(#pointer #pointer) #void 41484) #('WinGetWindowFrameRect' #(#pointer #pointer) #void 41476) #('WinInitializeWindow' #(#pointer) #void 41465) #('WinInvertChars' #(#pointer #int16 #int16 #int16) #void 41506) #('WinInvertLine' #(#int16 #int16 #int16 #int16) #void 41494) #('WinInvertRectangle' #(#pointer #int16) #void 41498) #('WinInvertRectangleFrame' #(#int16 #pointer) #void 41502) #('WinModal' #(#pointer) #int16 41511) #('WinMoveWindowAddr' #(#pointer #pointer) #void 41769) #('WinRemoveWindow' #(#pointer) #void 41467) #('WinResetClip' #() #void 41489) #('WinRestoreBits' #(#pointer #int16 #int16) #void 41480) #('WinSaveBits' #(#pointer #pointer) #pointer 41479) #('WinScrollRectangle' #(#pointer #int16 #int16 #pointer) #void 41482) #('WinSetActiveWindow' #(#pointer) #void 41468) #('WinSetClip' #(#pointer) #void 41488) #('WinSetColors' #(#pointer #pointer #pointer #pointer) #void 41732) #('WinSetDrawWindow' #(#pointer) #pointer 41469) #('WinSetPattern' #(#pointer) #void 41508) #('WinSetUnderlineMode' #(#int16) #int16 41509) #('WinSetWindowBounds' #(#pointer #pointer) #void 41728) #('WinValidateHandle' #(#pointer) #int16 41766) #('WinWindowToDisplayPt' #(#pointer #pointer) #void 41486))
! !
!PstPalmOSAPI class categoriesFor: #addTrap:index:argumentTypes:returnType:!*-unclassified!public! !
!PstPalmOSAPI class categoriesFor: #buildTraps!initialization!public! !
!PstPalmOSAPI class categoriesFor: #initialize!initialization!public! !
!PstPalmOSAPI class categoriesFor: #parseArgSpec:!*-unclassified!public! !
!PstPalmOSAPI class categoriesFor: #parseForthSpec:!*-unclassified!public! !
!PstPalmOSAPI class categoriesFor: #serialTrapSpecs!*-unclassified!public! !
!PstPalmOSAPI class categoriesFor: #translateForthFile:!*-unclassified!public! !
!PstPalmOSAPI class categoriesFor: #translateForthSpec:!*-unclassified!public! !
!PstPalmOSAPI class categoriesFor: #translateSysTrapHeader:!*-unclassified!public! !
!PstPalmOSAPI class categoriesFor: #trapSpecs!*-unclassified!public! !



PstGeosLibCall comment: ''!

PstGeosLibCall guid: (GUID fromString: '{B943B85C-BCA4-46BD-A1F0-E6F5F9015679}')!

!PstGeosLibCall categoriesForClass!No category! !
!PstGeosLibCall methodsFor!

bytecodes
	"Answer the bytecodes, not including the initial opcode."
	| stream |
	stream := ByteArray new writeStream.
	stream
		nextPut: ((functionNumber bitShift: -16) bitAnd: 16rFF);
                nextPut: ((functionNumber bitShift: -8) bitAnd: 16rFF);
		nextPut: (functionNumber bitAnd: 16rFF);
		nextPut: self argumentCount.
	argumentTypes do: [:type |
		stream nextPut: (self specForType: type)].
	stream nextPut: (self specForType: returnType).
	^stream contents.!

name: trapName
functionNumber: number
argumentTypes: argTypes
returnType: retType
	name := trapName.
	functionNumber := number.
	argumentTypes := argTypes.
	returnType := retType.! !
!PstGeosLibCall categoriesFor: #bytecodes!*-unclassified!public! !
!PstGeosLibCall categoriesFor: #name:functionNumber:argumentTypes:returnType:!*-unclassified!public! !



PstPalmOSTrap comment: ''!

PstPalmOSTrap guid: (GUID fromString: '{FC292CCE-D453-4AE4-ACD2-F03110B5DE62}')!

!PstPalmOSTrap categoriesForClass!No category! !
!PstPalmOSTrap methodsFor!

argumentCount
	^argumentTypes size.!

argumentWords
	^argumentTypes
		inject: 0
		into: [:words :type | words + (self wordsForType: type)].!

bytecodes
	"Answer the bytecodes, not including the initial opcode."
	| stream |
	stream := ByteArray new writeStream.
	stream
		nextPut: ((functionNumber bitShift: -8) bitAnd: 16rFF);
		nextPut: (functionNumber bitAnd: 16rFF);
		nextPut: self argumentCount.
	argumentTypes do: [:type |
		stream nextPut: (self specForType: type)].
	stream nextPut: (self specForType: returnType).
	^stream contents.
!

displayOn: stream
	stream
		print: functionNumber;
		nextPutAll: ': '.
	self printPrototypeOn: stream.!

name
	^name.!

name: trapName
functionNumber: number
argumentTypes: argTypes
returnType: retType
	name := trapName.
	functionNumber := number.
	argumentTypes := argTypes.
	returnType := retType.!

printOn: stream
	super printOn: stream.
	stream
		nextPutAll: ' (';
		display: self;
		nextPut: $).!

printPrototypeOn: stream
	stream
		nextPutAll: returnType;
		space;
		nextPutAll: name;
		nextPut: $(.
	argumentTypes
		do: [:each | stream nextPutAll: each]
		separatedBy: [stream nextPutAll: ', '].
	stream nextPut: $).!

prototype
	| stream |
	stream := String new writeStream.
	self printPrototypeOn: stream.
	^stream contents.!

specForType: type
	type == #void ifTrue: [^0].
	type == #int16 ifTrue: [^1].
	type == #int32 ifTrue: [^2].
	type == #pointer ifTrue: [^3].
	type == #uint16 ifTrue: [^4].
	type == #double ifTrue: [^5].
	self error.!

trapNumber
	^functionNumber.!

wordsForType: type
	type == #void ifTrue: [^0].
	(type == #int16 or: [type == #uint16]) ifTrue: [^1].
	(type == #int32 or: [type == #pointer]) ifTrue: [^2].
	type == #double ifTrue: [^4].
	self error.! !
!PstPalmOSTrap categoriesFor: #argumentCount!accessing!public! !
!PstPalmOSTrap categoriesFor: #argumentWords!accessing!public! !
!PstPalmOSTrap categoriesFor: #bytecodes!*-unclassified!public! !
!PstPalmOSTrap categoriesFor: #displayOn:!printing!public! !
!PstPalmOSTrap categoriesFor: #name!accessing!public! !
!PstPalmOSTrap categoriesFor: #name:functionNumber:argumentTypes:returnType:!initialization!public! !
!PstPalmOSTrap categoriesFor: #printOn:!printing!public! !
!PstPalmOSTrap categoriesFor: #printPrototypeOn:!printing!public! !
!PstPalmOSTrap categoriesFor: #prototype!printing!public! !
!PstPalmOSTrap categoriesFor: #specForType:!compiling!public! !
!PstPalmOSTrap categoriesFor: #trapNumber!accessing!public! !
!PstPalmOSTrap categoriesFor: #wordsForType:!public!utility! !



PstUncommittedPackage comment: ''!

PstUncommittedPackage guid: (GUID fromString: '{C90EE0B5-FA2F-4E5C-9520-0CF4583857EE}')!

!PstUncommittedPackage categoriesForClass!No category! !
!PstUncommittedPackage methodsFor!

displayOn: stream
	stream nextPutAll: '(uncommitted)'.!

dontSave
	^true.!

isUncommitted
	^true.!

name
	^nil.! !
!PstUncommittedPackage categoriesFor: #displayOn:!printing!public! !
!PstUncommittedPackage categoriesFor: #dontSave!accessing!public! !
!PstUncommittedPackage categoriesFor: #isUncommitted!predicates!public! !
!PstUncommittedPackage categoriesFor: #name!accessing!public! !



PstAssignmentNode comment: ''!

PstAssignmentNode guid: (GUID fromString: '{443FF37D-6F08-46E7-9554-9EB2F87FE8BE}')!

!PstAssignmentNode categoriesForClass!No category! !
!PstAssignmentNode methodsFor!

compileOn: compiler pop: pop
	| reference |
	reference := compiler resolveVariable: variable name.
	reference isNil ifTrue: [
		compiler 
			undefinedVariable: variable name
			for: variable].
	(reference isAssignable or: [hard]) ifFalse: [
		compiler
			error: variable name, ' cannot be assigned to'
			for: variable].
	value compileOn: compiler pop: false.
	pop ifFalse: [compiler dup].
	compiler 
		compiling: self;
		storeVariable: reference.!

hard: hardAssign
	"huh huh, he said 'hard'."
	hard := hardAssign.!

value
	^value.!

value: object
	value := object.!

variable
	^variable.!

variable: object
	variable := object.! !
!PstAssignmentNode categoriesFor: #compileOn:pop:!compiling!public! !
!PstAssignmentNode categoriesFor: #hard:!accessing!public! !
!PstAssignmentNode categoriesFor: #value!accessing!public! !
!PstAssignmentNode categoriesFor: #value:!accessing!public! !
!PstAssignmentNode categoriesFor: #variable!accessing!public! !
!PstAssignmentNode categoriesFor: #variable:!accessing!public! !



PstBlockNode comment: ''!

PstBlockNode guid: (GUID fromString: '{56511EDC-EC28-4FFA-9EFD-48F529D7C9CE}')!

!PstBlockNode categoriesForClass!No category! !
!PstBlockNode methodsFor!

argumentCount
	^arguments size.!

arguments
	^arguments.!

arguments: object
	arguments := object.!

compileLocalReturnOn: compiler
	(statements statements isEmpty
			or: [statements statements last isReturnNode not])
		ifTrue: [compiler return: nil].!

compileOn: compiler pop: pop
	| blockCompiler |
	blockCompiler := compiler newBlockCompilerFor: self.
	blockCompiler compiling: self.
	blockCompiler 
		compileBlock: self
		withReturn: true
		preserveLast: true.
	pop ifTrue: [
		compiler
			warning: 'Useless block'
			for: self.
		compiler pop].
	compiler integrateBlockFrom: blockCompiler.!

isBlockNode
	^true.!

statements
	^statements.!

statements: object
	statements := object.!

temporaries
	^statements temporaries.! !
!PstBlockNode categoriesFor: #argumentCount!accessing!public! !
!PstBlockNode categoriesFor: #arguments!accessing!public! !
!PstBlockNode categoriesFor: #arguments:!accessing!public! !
!PstBlockNode categoriesFor: #compileLocalReturnOn:!compiling!public! !
!PstBlockNode categoriesFor: #compileOn:pop:!compiling!public! !
!PstBlockNode categoriesFor: #isBlockNode!predicates!public! !
!PstBlockNode categoriesFor: #statements!accessing!public! !
!PstBlockNode categoriesFor: #statements:!accessing!public! !
!PstBlockNode categoriesFor: #temporaries!accessing!public! !



PstCascadeNode comment: ''!

PstCascadeNode guid: (GUID fromString: '{12B14F74-9F45-4B10-83FE-002459BAA3F6}')!

!PstCascadeNode categoriesForClass!No category! !
!PstCascadeNode methodsFor!

addMessage: messageNode
	self assert: [receiver notNil].
	messageNode receiver: receiver.
	^messages add: messageNode.!

compileCascadeOn: compiler 
receiverless: receiverless
pop: pop
	| last |
	messages keysAndValuesDo: [:index :message |
		last := index = messages size.
		last | receiverless ifFalse: [compiler dup].
		message isNil ifTrue: [
			compiler
				error: 'Dangling cascade statement'
				for: self].
		message
			compileOn: compiler
			cascaded: receiverless not
			pop: last not | pop].!

compileOn: compiler pop: pop
	| last receiverless |
	receiverless := compiler isMinimal and: [
		compiler compilingReceiverlessMethod
			or: [receiver isVariableNode
				and: [receiver isNull]]].
	receiverless := receiverless or: [
		compiler optimizesSelfCascades 
			and: [receiver isVariableNode 
			and: [receiver isSelf]]].
	receiverless ifFalse: [receiver compileOn: compiler pop: false].
	self
		compileCascadeOn: compiler
		receiverless: receiverless
		pop: pop.!

initialize
	super initialize.
	messages := OrderedCollection new.!

receiver
	^receiver.!

receiver: newReceiver
	receiver := newReceiver.! !
!PstCascadeNode categoriesFor: #addMessage:!adding!public! !
!PstCascadeNode categoriesFor: #compileCascadeOn:receiverless:pop:!compiling!public! !
!PstCascadeNode categoriesFor: #compileOn:pop:!compiling!public! !
!PstCascadeNode categoriesFor: #initialize!initialization!public! !
!PstCascadeNode categoriesFor: #receiver!accessing!public! !
!PstCascadeNode categoriesFor: #receiver:!accessing!public! !



PstLiteralNode comment: ''!

PstLiteralNode guid: (GUID fromString: '{0BA70E45-A408-4EAC-B483-AE171079E937}')!

!PstLiteralNode categoriesForClass!No category! !
!PstLiteralNode methodsFor!

compileOn: compiler pop: pop
	compiler
		compiling: self;
		pushLiteral: value.
	pop ifTrue: [
		compiler 
			warning: 'Useless reference to literal: ', value displayString
			for: self.
		compiler pop].!

isLiteralNode
	^true.!

literalValue
	"Value as an actual object, or else nil, no matter what the internal usage of 'value' is."
	^value.!

simpleLiteralValue
	^self literalValue.!

value
	^value.!

value: object
	value := object.! !
!PstLiteralNode categoriesFor: #compileOn:pop:!compiling!public! !
!PstLiteralNode categoriesFor: #isLiteralNode!predicates!public! !
!PstLiteralNode categoriesFor: #literalValue!accessing!public! !
!PstLiteralNode categoriesFor: #simpleLiteralValue!accessing!public! !
!PstLiteralNode categoriesFor: #value!accessing!public! !
!PstLiteralNode categoriesFor: #value:!accessing!public! !



PstMessageNode comment: ''!

PstMessageNode guid: (GUID fromString: '{D434DAE7-1C26-44E3-9494-663317DECC76}')!

!PstMessageNode categoriesForClass!No category! !
!PstMessageNode methodsFor!

arguments
	^arguments.!

arguments: object
	arguments := object.!

canCascade
	^(receiver isVariableNode and: [receiver isSuper])
		not.!

checkArgument: index 
forBlockWithArguments: argumentCount
for: compiler
	"Check whether the argument at 'index' is a literal block with the given number of arguments.  Answer true or false.  If index is 0, the receiver is checked."
	| argument |
	argument := index = 0
		ifTrue: [receiver]
		ifFalse: [arguments at: index].
	argument isBlockNode ifFalse: [
		compiler
			warning: 'This control structure will not be optimized
(a block was expected)'
			for: argument.
		^false].
	^argument argumentCount = argumentCount
		ifTrue: [true]
		ifFalse: [
			compiler
				warning: 'This control structure will not be optimized
(wrong number of arguments for block)'
				for: self].!

compileArgumentsOn: compiler
	arguments do: [:each |
		each 
			compileOn: compiler 
			pop: false].
!

compileCascadedSendOn: compiler
	"receiver isNil ifFalse: [receiver compileOn: compiler pop: false]."
	self compileArgumentsOn: compiler.
	compiler compiling: self.
	^compiler
		send: self selector
		argumentCount: arguments size.!

compileMinimalSendOn: compiler
	| sel receiverless |
	sel := #send:argumentCount:.
	receiverless := false.
	receiver isVariableNode ifTrue: [
		receiverless := receiver name = '_' 
			or: [receiver name = 'self'
				and: [compiler compilingReceiverlessMethod]].
		receiverless
			ifTrue: [sel := #receiverlessSend:argumentCount:].
		receiver name = 'super'
			ifTrue: [sel := #superSend:argumentCount:]].
	receiverless ifFalse: [receiver compileOn: compiler pop: false].
	self compileArgumentsOn: compiler.
	compiler compiling: self.
	compiler
		perform: sel
		with: self selector
		with: arguments size.!

compileOn: compiler cascaded: cascaded pop: pop
	cascaded ifFalse: [
		"Don't even try to optimize cascaded control structures---
while it's probably possible, it's just too confusing and doesn't buy much."
		(self optimizeOn: compiler pop: pop)
			ifTrue: [^self]].
	cascaded
		ifTrue: [
			self compileCascadedSendOn: compiler.
			pop ifTrue: [compiler pop]]
		ifFalse: [self compileSendOn: compiler pop: pop].!

compileOn: compiler pop: pop
	self
		compileOn: compiler
		cascaded: false
		pop: pop.!

compileReceiverOn: compiler
	receiver
		compileOn: compiler
		pop: false.!

compileSendOn: compiler pop: pop
	| type explicit |
	"Receiver may be nil if this is part of a cascade."
	type := receiver isNil
		ifTrue: [#self]
		ifFalse: [self receiverType].
	type == #self ifTrue: [
		explicit := compiler isBlockCompiler
				or: [PstSendInstruction canInline: selector].
		explicit ifTrue: [compiler pushSelf].
		self compileArgumentsOn: compiler.
		compiler compiling: self.
		explicit
			ifTrue: [
				compiler
					send: self selector
					argumentCount: arguments size]
			ifFalse: [
				compiler
					sendSelf: self selector
					argumentCount: arguments size].
		^pop ifTrue: [compiler pop]].
	type == #super ifTrue: [
		compiler compilationClass isNil ifTrue: [
			compiler
				error: 'Cannot use super here'
				for: self].
		compiler compilationClass superclass isNil ifTrue: [
			compiler
				error: 'No superclass; cannot use super here'
				for: self].
		compiler isBlockCompiler ifTrue: [
			compiler
				error: 'Can''t use super sends inside blocks (sorry)'
				for: self].
		self compileArgumentsOn: compiler.
		compiler compiling: self.
		compiler
			sendSuper: self selector
			argumentCount: arguments size.
		^pop ifTrue: [compiler pop]].
	type == #systrap ifTrue: [
		^compiler compileSysTrap: self pop: pop].
	type == #geos ifTrue: [
		^compiler compileGeosMessage: self pop: pop].
	receiver isNil ifFalse: [receiver compileOn: compiler pop: false].
	self compileArgumentsOn: compiler.
	compiler compiling: self.
	compiler
		send: self selector
		argumentCount: arguments size.
	pop ifTrue: [compiler pop].!

keywords
	^keywords.!

keywords: object
	| stream |
	keywords := object.
	stream := String new writeStream.
	keywords do: [:each |
		stream nextPutAll: each].
	selector := stream contents.!

optimizeOn: compiler pop: pop
	compiler compiling: self.
	^(compiler optimizeMessage: self)
		ifTrue: [
			pop ifTrue: [compiler pop].
			true]
		ifFalse: [false].!

receiver
	^receiver.!

receiver: object
	receiver := object.!

receiverType
	"Answer #self, #super, #systrap, or #normal."
	receiver isVariableNode ifTrue: [
		receiver name = 'self' ifTrue: [^#self].
		receiver name = 'super' ifTrue: [^#super].
		receiver name = 'SYSTRAP' ifTrue: [^#systrap].
		receiver name = 'GEOS' ifTrue: [^#geos]].
	^#normal.!

selector
	^selector.! !
!PstMessageNode categoriesFor: #arguments!accessing!public! !
!PstMessageNode categoriesFor: #arguments:!accessing!public! !
!PstMessageNode categoriesFor: #canCascade!predicates!public! !
!PstMessageNode categoriesFor: #checkArgument:forBlockWithArguments:for:!public!utility! !
!PstMessageNode categoriesFor: #compileArgumentsOn:!compiling!public! !
!PstMessageNode categoriesFor: #compileCascadedSendOn:!compiling!public! !
!PstMessageNode categoriesFor: #compileMinimalSendOn:!compiling!public! !
!PstMessageNode categoriesFor: #compileOn:cascaded:pop:!compiling!public! !
!PstMessageNode categoriesFor: #compileOn:pop:!compiling!public! !
!PstMessageNode categoriesFor: #compileReceiverOn:!compiling!public! !
!PstMessageNode categoriesFor: #compileSendOn:pop:!compiling!public! !
!PstMessageNode categoriesFor: #keywords!accessing!public! !
!PstMessageNode categoriesFor: #keywords:!accessing!public! !
!PstMessageNode categoriesFor: #optimizeOn:pop:!compiling!public! !
!PstMessageNode categoriesFor: #receiver!accessing!public! !
!PstMessageNode categoriesFor: #receiver:!accessing!public! !
!PstMessageNode categoriesFor: #receiverType!accessing!public! !
!PstMessageNode categoriesFor: #selector!accessing!public! !



PstMessagePattern comment: ''!

PstMessagePattern guid: (GUID fromString: '{ED1451CE-D20F-4108-8C4B-3CBCB1B133F2}')!

!PstMessagePattern categoriesForClass!No category! !
!PstMessagePattern methodsFor!

argumentRanges
	^argumentRanges.!

argumentRanges: list
	argumentRanges := list.!

arguments
	^arguments.!

arguments: object
	arguments := object.!

displayOn: stream
	super displayOn: stream.
	stream
		nextPutAll: ': #';
		nextPutAll: self selector.!

keywordRanges
	^keywordRanges.!

keywordRanges: list
	keywordRanges := list.!

keywords
	^keywords.!

keywords: object
	keywords := object.!

nodeName
	^'Message Pattern'.!

selector
	^keywords inject: String new into: [:left :right | left, right].! !
!PstMessagePattern categoriesFor: #argumentRanges!accessing!public! !
!PstMessagePattern categoriesFor: #argumentRanges:!accessing!public! !
!PstMessagePattern categoriesFor: #arguments!accessing!public! !
!PstMessagePattern categoriesFor: #arguments:!accessing!public! !
!PstMessagePattern categoriesFor: #displayOn:!printing!public! !
!PstMessagePattern categoriesFor: #keywordRanges!accessing!public! !
!PstMessagePattern categoriesFor: #keywordRanges:!accessing!public! !
!PstMessagePattern categoriesFor: #keywords!accessing!public! !
!PstMessagePattern categoriesFor: #keywords:!accessing!public! !
!PstMessagePattern categoriesFor: #nodeName!printing!public! !
!PstMessagePattern categoriesFor: #selector!accessing!public! !



PstMethodNode comment: ''!

PstMethodNode guid: (GUID fromString: '{337351B5-B9FD-42BE-98FD-F316B7A5ADCF}')!

!PstMethodNode categoriesForClass!No category! !
!PstMethodNode methodsFor!

arguments
	^pattern isNil
		ifTrue: [#()]
		ifFalse: [pattern arguments].!

commentMap
	^commentMap.!

commentMap: object
	commentMap := object.!

compileOn: compiler
	self isExpression
		ifTrue: [statements fixForExpression]
		ifFalse: [statements fixForMethod].
	compiler compileMethod: self.!

isExpression
	^pattern isNil.!

nodeName
	^'Method'.!

pattern
	^pattern.!

pattern: object
	pattern := object.!

primitive
	^primitive.!

primitive: object
	primitive := object.!

selector
	^pattern isNil
		ifTrue: [nil]
		ifFalse: [pattern selector].!

simpleLiteralValue
	"This is a bit of a kludge.  It's for the 'references to value' search command.  The purpose is to use the parser to handle the dirty work of converting a string into a simple object.  If this expression tree contains a simple reference to a literal value, answer that literal value.  Otherwise, answer nil."
	| n |
	n := self statements.
	n statements size = 1 ifFalse: [^nil].
	n := n statements first.
	^n simpleLiteralValue.!

statements
	^statements.!

statements: object
	statements := object.!

temporaries
	^statements temporaries.! !
!PstMethodNode categoriesFor: #arguments!accessing!public! !
!PstMethodNode categoriesFor: #commentMap!accessing!public! !
!PstMethodNode categoriesFor: #commentMap:!accessing!public! !
!PstMethodNode categoriesFor: #compileOn:!compiling!public! !
!PstMethodNode categoriesFor: #isExpression!predicates!public! !
!PstMethodNode categoriesFor: #nodeName!printing!public! !
!PstMethodNode categoriesFor: #pattern!accessing!public! !
!PstMethodNode categoriesFor: #pattern:!accessing!public! !
!PstMethodNode categoriesFor: #primitive!accessing!public! !
!PstMethodNode categoriesFor: #primitive:!accessing!public! !
!PstMethodNode categoriesFor: #selector!accessing!public! !
!PstMethodNode categoriesFor: #simpleLiteralValue!accessing!public! !
!PstMethodNode categoriesFor: #statements!accessing!public! !
!PstMethodNode categoriesFor: #statements:!accessing!public! !
!PstMethodNode categoriesFor: #temporaries!accessing!public! !



PstPrimitiveNode comment: ''!

PstPrimitiveNode guid: (GUID fromString: '{6F02FF9B-5E1D-4BAD-85E8-4937EC440A87}')!

!PstPrimitiveNode categoriesForClass!No category! !
!PstPrimitiveNode methodsFor!

compileOn: compiler pop: pop
	"This is handled specially by the compiler."
	self shouldNotImplement.!

index
	^index.!

index: object
	index := object.! !
!PstPrimitiveNode categoriesFor: #compileOn:pop:!*-should not implement!compiling!public! !
!PstPrimitiveNode categoriesFor: #index!accessing!public! !
!PstPrimitiveNode categoriesFor: #index:!accessing!public! !



PstReturnNode comment: ''!

PstReturnNode guid: (GUID fromString: '{D65415BE-ACCB-414D-8B34-371FEBEE942F}')!

!PstReturnNode categoriesForClass!No category! !
!PstReturnNode methodsFor!

compileOn: compiler pop: pop
	| rtype |
	compiler isBlockCompiler
		ifTrue: [
			value compileOn: compiler pop: false.
			compiler
				compiling: self;
				nonlocalReturn]
		ifFalse: [
			rtype := self specialReturnType.
			(compiler optimizesSpecialReturns
					and: [rtype notNil])
				ifTrue: [
					compiler
						compiling: self;
						return: rtype]
				ifFalse: [
					value compileOn: compiler pop: false.
					compiler
						compiling: self;
						return: nil]].!

isReturnNode
	^true.!

specialReturnType
	"Can this return be coded inline without compiling the value?"
	value isVariableNode ifTrue: [
		(value name = 'self' or: [value name = 'super'])
			ifTrue: [^#self].
		value name = 'nil' ifTrue: [^#nil].
		value name = 'true' ifTrue: [^#true].
		value name = 'false' ifTrue: [^#false]].
	^nil.!

value
	^value.!

value: object
	value := object.! !
!PstReturnNode categoriesFor: #compileOn:pop:!compiling!public! !
!PstReturnNode categoriesFor: #isReturnNode!predicates!public! !
!PstReturnNode categoriesFor: #specialReturnType!compiling!public! !
!PstReturnNode categoriesFor: #value!accessing!public! !
!PstReturnNode categoriesFor: #value:!accessing!public! !



PstStatementsNode comment: ''!

PstStatementsNode guid: (GUID fromString: '{4D388B72-5BF2-4039-ACDE-C0240531DBFB}')!

!PstStatementsNode categoriesForClass!No category! !
!PstStatementsNode methodsFor!

addStatement: statement
	^statements add: statement.!

compileOn: compiler
	self
		compileOn: compiler
		preserveLast: false.!

compileOn: compiler preserveLast: preserveLast
	| max |
	max := statements size.
	1 to: max do: [:index |
		(statements at: index)
			compileOn: compiler
			pop: (preserveLast ifTrue: [index < max] ifFalse: [true])].
	(statements isEmpty and: [preserveLast])
		ifTrue: [compiler pushNil].!

fixForExpression
	"Makes it so that the the last statement is returned as the value.  If there are no statements, nil is returned instead."
	| returnNode |
	returnNode := PstReturnNode new.
	statements isEmpty ifTrue: [
		returnNode value: 
			(PstVariableNode new name: 'nil').
		^self addStatement: returnNode].
	statements last isReturnNode ifFalse: [
		returnNode := PstReturnNode new
			value: statements last.
		statements at: statements size put: returnNode].!

fixForMethod
	"Makes it so that the 'self' is returned as the value of the statements, unless something else is explicitly returned instead."
	| returnNode |
	(statements notEmpty
			and: [statements last isReturnNode])
		ifTrue: [^self].
	returnNode := PstReturnNode new
		value: (PstVariableNode new name: 'self').
	self addStatement: returnNode.!

initialize
	super initialize.
	statements := OrderedCollection new.!

statements
	^statements.!

statements: object
	statements := object.!

temporaries
	^temporaries.!

temporaries: object
	temporaries := object.! !
!PstStatementsNode categoriesFor: #addStatement:!accessing!public! !
!PstStatementsNode categoriesFor: #compileOn:!compiling!public! !
!PstStatementsNode categoriesFor: #compileOn:preserveLast:!compiling!public! !
!PstStatementsNode categoriesFor: #fixForExpression!compiling!public! !
!PstStatementsNode categoriesFor: #fixForMethod!compiling!public! !
!PstStatementsNode categoriesFor: #initialize!initialization!public! !
!PstStatementsNode categoriesFor: #statements!accessing!public! !
!PstStatementsNode categoriesFor: #statements:!accessing!public! !
!PstStatementsNode categoriesFor: #temporaries!accessing!public! !
!PstStatementsNode categoriesFor: #temporaries:!accessing!public! !



PstVariableNode comment: ''!

PstVariableNode guid: (GUID fromString: '{E2A02D7F-E8E7-4CD6-B63C-F549CFB6BE46}')!

!PstVariableNode categoriesForClass!No category! !
!PstVariableNode methodsFor!

compileOn: compiler pop: pop
	| reference type |
	type := self pseudoVariableType.
	type isNil 
		ifTrue: [
			reference := compiler resolveVariable: name.
			reference isNil ifTrue: [
				"Check for explicit reference to _ (nil)"
				(compiler isMinimal and: [name = '_'])
					ifTrue: [compiler pushNil]
					ifFalse: [
						compiler
							undefinedVariable: name
							for: self]].
			self
				compileReferenceTo: reference
				on: compiler]
		ifFalse: [
			self 
				compilePseudoVariable: type
				on: compiler].
	pop ifTrue: [
		compiler 
			warning: 'Useless reference to ', name
			for: self.
		compiler pop].!

compilePseudoVariable: type on: compiler
	compiler compiling: self.
	type == #self
		ifTrue: [compiler pushSelf.  ^true].
	type == #super ifTrue: [
		compiler
			warning: 'The super keyword has no effect here'
			for: self.
		compiler pushSelf.
		^true].
	type == #nil ifTrue: [
		compiler pushNil.
		^true].
	type == #true ifTrue: [
		compiler pushTrue.
		^true].
	type == #false ifTrue: [
		compiler pushFalse.
		^true].
	type == #thisContext ifTrue: [
		compiler pushThisContext.
		^true].
	^false.!

compileReferenceTo: reference on: compiler
	compiler
		compiling: self;
		pushVariable: reference.!

displayOn: stream
	super displayOn: stream.
	stream
		nextPutAll: ': ';
		nextPutAll: self name.!

isNull
	"for 'receiverless' sends"
	^name = '_'.!

isSelf
	^name = 'self'.!

isSuper
	^name = 'super'.!

isVariableNode
	^true.!

name
	^name.!

name: object
	name := object.!

nodeName
	^'Variable'.!

pseudoVariableType
	"Answer a symbol representing the type of pseudo-variable this variable represents, if it is one.  If it's not a pseudo-variable, answer nil."
	name = 'self' ifTrue: [^#self].
	name = 'super' ifTrue: [^#super].
	name = 'nil' ifTrue: [^#nil].
	name = 'true' ifTrue: [^#true].
	name = 'false' ifTrue: [^#false].
	name = 'thisContext' ifTrue: [^#thisContext].
	^nil.!

simpleLiteralValue
	name = 'true' ifTrue: [^PstBasicObject forTrue].
	name = 'false' ifTrue: [^PstBasicObject forFalse].
	name = 'nil' ifTrue: [^PstBasicObject forNil].
	^super simpleLiteralValue.! !
!PstVariableNode categoriesFor: #compileOn:pop:!compiling!public! !
!PstVariableNode categoriesFor: #compilePseudoVariable:on:!compiling!public! !
!PstVariableNode categoriesFor: #compileReferenceTo:on:!compiling!public! !
!PstVariableNode categoriesFor: #displayOn:!printing!public! !
!PstVariableNode categoriesFor: #isNull!predicates!public! !
!PstVariableNode categoriesFor: #isSelf!predicates!public! !
!PstVariableNode categoriesFor: #isSuper!predicates!public! !
!PstVariableNode categoriesFor: #isVariableNode!predicates!public! !
!PstVariableNode categoriesFor: #name!accessing!public! !
!PstVariableNode categoriesFor: #name:!accessing!public! !
!PstVariableNode categoriesFor: #nodeName!printing!public! !
!PstVariableNode categoriesFor: #pseudoVariableType!compiling!public! !
!PstVariableNode categoriesFor: #simpleLiteralValue!accessing!public! !



PstCharacterLiteralNode comment: ''!

PstCharacterLiteralNode guid: (GUID fromString: '{0C002610-E8ED-406B-ADF1-A9A8E74E562E}')!

!PstCharacterLiteralNode categoriesForClass!No category! !
!PstCharacterLiteralNode methodsFor!

compileOn: compiler pop: pop
	compiler
		compiling: self;
		pushCharacter: value.
	pop ifTrue: [
		compiler 
			warning: 'Useless reference to literal: ', self literalString
			for: self.
		compiler pop].!

literalString
	^'$', (self class literalStringFor: value).!

literalValue
	^PstCharacter fromCharacter: value.! !
!PstCharacterLiteralNode categoriesFor: #compileOn:pop:!compiling!public! !
!PstCharacterLiteralNode categoriesFor: #literalString!printing!public! !
!PstCharacterLiteralNode categoriesFor: #literalValue!accessing!public! !

!PstCharacterLiteralNode class methodsFor!

characterForEscape: string
	"Answer the Character corresponding to the given escape string, or nil if none."
	^Escapes at: string ifAbsent: [nil].!

characterTypeTable
	"Answer a C-formatted byte array that can be included in the virtual machine source."
	| stream |
	stream := String new writeStream.
	((0 to: 255) collect: [:each |
			self typesForCharacter: each asCharacter])
		do: [:each | stream print: each]
		separatedBy: [stream nextPutAll: ', '].
	^stream contents.!

escapeForCharacter: character
	"Answer the escape string corresponding to the given Character, or nil if none."
	^Escapes keyAtValue: character ifAbsent: [nil].!

initialize
	"PstCharacterLiteralNode initialize."
	Escapes := Dictionary new.
	Escapes
		at: 'space' put: Character space;
		at: 'backspace' put: Character backspace;
		at: 'cr' put: (Character value: 13);
		at: 'newline' put: (Character value: 13);
		at: 'escape' put: Character esc;
		at: 'lf' put: Character lf;
		at: 'formfeed' put: Character newPage;
		at: 'null' put: Character null;
		at: 'tab' put: Character tab;
		at: 'backslash' put: $\.!

literalStringFor: character
	| string |
	string := self escapeForCharacter: character.
	string isNil ifFalse: [^'\', string].
	^character isPrintable
		ifTrue: [String with: character]
		ifFalse: ['\', character value printString].!

typesForCharacter: character
	| value |
	value := 0.
	character isAlphaNumeric 
		ifTrue: [value := value + 16r01].
	character isControl
		ifTrue: [value := value + 16r02].
	character isDigit
		ifTrue: [value := value + 16r04].
	character isLetter
		ifTrue: [value := value + 16r08].
	character isLowercase
		ifTrue: [value := value + 16r10].
	character isPrintable
		ifTrue: [value := value + 16r20].
	character isPunctuation
		ifTrue: [value := value + 16r40].
	character isWhitespace
		ifTrue: [value := value + 16r80].
	^value.! !
!PstCharacterLiteralNode class categoriesFor: #characterForEscape:!accessing!public! !
!PstCharacterLiteralNode class categoriesFor: #characterTypeTable!public!utility! !
!PstCharacterLiteralNode class categoriesFor: #escapeForCharacter:!accessing!public! !
!PstCharacterLiteralNode class categoriesFor: #initialize!initialization!public! !
!PstCharacterLiteralNode class categoriesFor: #literalStringFor:!accessing!public! !
!PstCharacterLiteralNode class categoriesFor: #typesForCharacter:!public!utility! !



PstSmalltalkParser comment: ''!

PstSmalltalkParser guid: (GUID fromString: '{2DC810AB-97F8-4E61-890C-7EF22B7EAA8B}')!

!PstSmalltalkParser categoriesForClass!No category! !
!PstSmalltalkParser methodsFor!

arrayObjectFor: arrayContents
	| array |
	array := PstClassLibrary current arrayClass
				instantiateIndexed: arrayContents size.
	arrayContents keysAndValuesDo: [:index :element |
		array indexedSlotAt: index put: element].
	^array.
!

byteArrayObjectFor: arrayContents
	| byteArray |
	byteArray := (PstClassLibrary current classNamed: 'ByteArray')
			instantiateIndexed: arrayContents size.
	arrayContents keysAndValuesDo: [:index :byte |
		byteArray byteIndexedSlotAt: index put: byte].
	^byteArray.!

doubleObjectFor: double
	^PstDouble value: double.!

integerObjectFor: integer
	^PstInteger value: integer.!

parsePrimitive
	"<primitive: 123>"
	"Answers the primitive index if parsing succeeded, or nil if not."
	"In the future, named primitives should be supported."
	| primitive |
	(token == #binop and: [value = '<'])
		ifFalse: [^nil].
	self scanToken.  "skip <"
	(token == #keyword and: [value = 'primitive:']) ifFalse: [
		self
			error: 'Expected primitive'
			at: tokenStart].
	self scanToken.
	token == #integer ifFalse: [
		self
			error: 'Expected index of primitive'
			at: tokenStart].
	primitive := value.
	self scanToken.
	(token == #binop and: [value = '>']) ifFalse: [
		self
			error: 'Expected >'
			at: tokenStart].
	self scanToken.
	^primitive.!

stringObjectFor: string
	^PstByteIndexableObject newString: string.!

symbolObjectFor: string
	^PstSymbol string: string.! !
!PstSmalltalkParser categoriesFor: #arrayObjectFor:!object creation!public! !
!PstSmalltalkParser categoriesFor: #byteArrayObjectFor:!object creation!public! !
!PstSmalltalkParser categoriesFor: #doubleObjectFor:!object creation!public! !
!PstSmalltalkParser categoriesFor: #integerObjectFor:!object creation!public! !
!PstSmalltalkParser categoriesFor: #parsePrimitive!parsing!public! !
!PstSmalltalkParser categoriesFor: #stringObjectFor:!object creation!public! !
!PstSmalltalkParser categoriesFor: #symbolObjectFor:!object creation!public! !



PstSmalltalkSystem comment: ''!

PstSmalltalkSystem guid: (GUID fromString: '{A63CB92A-4D18-4087-BD8C-77E8A294E55A}')!

!PstSmalltalkSystem categoriesForClass!No category! !
!PstSmalltalkSystem methodsFor!

classLibraryClass
	^PstSmalltalkClassLibrary.!

loadFile: aFileSpec using: aPackageLib
	"If aFileSpec exists, load it into aPackageLib"

	(File exists: aFileSpec) ifTrue:
		[aPackageLib installPackageNamed: aFileSpec.
		^true.].

	^false.!

qcompilerClass
	^PstSmalltalkCompiler.! !
!PstSmalltalkSystem categoriesFor: #classLibraryClass!parameters!public! !
!PstSmalltalkSystem categoriesFor: #loadFile:using:!*-unclassified!public! !
!PstSmalltalkSystem categoriesFor: #qcompilerClass!parameters!public! !

!PstSmalltalkSystem class methodsFor!

classLibraryClass
	^PstSmalltalkClassLibrary.!

type
	^#smalltalk.! !
!PstSmalltalkSystem class categoriesFor: #classLibraryClass!accessing!public! !
!PstSmalltalkSystem class categoriesFor: #type!accessing!public! !



PstPocketSmalltalkGEOS comment: ''!

PstPocketSmalltalkGEOS guid: (GUID fromString: '{EC7A0949-12D4-4287-AF8F-96897BB0AD7B}')!

!PstPocketSmalltalkGEOS categoriesForClass!No category! !
!PstPocketSmalltalkGEOS methodsFor!

apiClass
	^PstGeosAPI!

codeGeneratorClass
	^PstGeosCodeGenerator.!

defaultCodeFile
	^FileSaveDialog new
		fileTypes: (Array
			with: #('GEOS VM files (*.vm)' '*.vm')
			with: FileDialog allFilesType);
		defaultExtension: 'vm';
		yourself.!

doubleByteOrder
	^#[1 2 3 4 5 6 7 8]!

initialize
	"Initialize the receiver. We will try to load the standard packages into a new project."
	| fileNames locator fileSpec packLib |

	Cursor wait showWhile: [
	super initialize.
    	locator := FileLocator default.
	packLib := PstPackageLibrary current.

	"Find out which files to load."
	fileNames := self class systemFilesToLoad.

	"Try to load each file."
	fileNames do: [:each|
		fileSpec := locator localFileSpecFor: ('geos\', each).
		(self loadFile: fileSpec using: packLib) ifFalse:
			[fileSpec :=  ('c:\pst\geos\', each).
			self loadFile: fileSpec using: packLib].].

	"Now mark the two packages we just loaded as read-only."
	packLib packages do:
		[:each | (each name ~= nil) ifTrue: [each dontSave: true]].
	].
!

storeLongword: value on: stream
	"Little endian"
	self
		storeWord: (value bitAnd: 16rFFFF)
		on: stream.
	self
		storeWord: (value bitShift: -16)
		on: stream.!

storeWord: value on: stream
	"Little endian"
	stream
		nextPut: (value bitAnd: 16rFF);
		nextPut: ((value bitShift: -8) bitAnd: 16rFF).!

trapClass
	^PstGeosLibCall
! !
!PstPocketSmalltalkGEOS categoriesFor: #apiClass!*-unclassified!public! !
!PstPocketSmalltalkGEOS categoriesFor: #codeGeneratorClass!parameters!public! !
!PstPocketSmalltalkGEOS categoriesFor: #defaultCodeFile!*-unclassified!public! !
!PstPocketSmalltalkGEOS categoriesFor: #doubleByteOrder!*-unclassified!public! !
!PstPocketSmalltalkGEOS categoriesFor: #initialize!parameters!public! !
!PstPocketSmalltalkGEOS categoriesFor: #storeLongword:on:!public!utility! !
!PstPocketSmalltalkGEOS categoriesFor: #storeWord:on:!public!utility! !
!PstPocketSmalltalkGEOS categoriesFor: #trapClass!parameters!public! !

!PstPocketSmalltalkGEOS class methodsFor!

systemFilesToLoad
	"Answer a collection of file names that should be loaded into a new project."

	SystemFileNames := nil.
	(SystemFileNames isNil or: [SystemFileNames size < 1]) ifTrue: [
		SystemFileNames := #('pstcore.st' 'enums.st' 'structs.st' 'gcore.st' 'geos.st' 
						  'ansic.st' 'eci.st' 'ui.st' 'color.st' 'ruler.st' 'styles.st'
						  'text.st' 'foam.st' 'ghelpers.st').].

	^SystemFileNames.! !
!PstPocketSmalltalkGEOS class categoriesFor: #systemFilesToLoad!*-unclassified!public! !



PstPocketSmalltalkPalmOS comment: ''!

PstPocketSmalltalkPalmOS guid: (GUID fromString: '{6D08B328-8323-47CE-984F-98275C5F1093}')!

!PstPocketSmalltalkPalmOS categoriesForClass!No category! !
!PstPocketSmalltalkPalmOS methodsFor!

apiClass
	^PstPalmOSAPI!

codeGeneratorClass
	^PstPilotCodeGenerator.
!

defaultCodeFile
	^FileSaveDialog new
		fileTypes: (Array
			with: #('PRC files (*.prc)' '*.prc')
			with: FileDialog allFilesType);
		defaultExtension: 'prc';
		yourself.!

doubleByteOrder
	^#[8 7 6 5 4 3 2 1]
!

initialize
	"Initialize the receiver. We will try to load the standard packages into a new project."
	| fileNames locator fileSpec packLib |

	super initialize.
    	locator := FileLocator default.
	packLib := PstPackageLibrary current.

	"Find out which files to load."
	fileNames := self class systemFilesToLoad.

	"Try to load each file."
	fileNames do: [:each|
		fileSpec := locator localFileSpecFor: ('palmos\', each).
		(self loadFile: fileSpec using: packLib) ifFalse:
			[fileSpec := ('c:\pst\palmos\', each).
			self loadFile: fileSpec using: packLib].].

	"Now mark the two packages we just loaded as read-only."
	packLib packages do:
		[:each | (each name ~= nil) ifTrue: [each dontSave: true]].


!

storeLongword: value on: stream
	"Big endian"
	self
		storeWord: (value bitShift: -16)
		on: stream.
	self
		storeWord: (value bitAnd: 16rFFFF)
		on: stream.!

storeWord: value on: stream
	"Big endian"
	stream
		nextPut: ((value bitShift: -8) bitAnd: 16rFF);
		nextPut: (value bitAnd: 16rFF).
!

trapClass
	^PstPalmOSTrap
! !
!PstPocketSmalltalkPalmOS categoriesFor: #apiClass!*-unclassified!public! !
!PstPocketSmalltalkPalmOS categoriesFor: #codeGeneratorClass!parameters!public! !
!PstPocketSmalltalkPalmOS categoriesFor: #defaultCodeFile!*-unclassified!public! !
!PstPocketSmalltalkPalmOS categoriesFor: #doubleByteOrder!*-unclassified!public! !
!PstPocketSmalltalkPalmOS categoriesFor: #initialize!*-unclassified!public! !
!PstPocketSmalltalkPalmOS categoriesFor: #storeLongword:on:!public!utility! !
!PstPocketSmalltalkPalmOS categoriesFor: #storeWord:on:!public!utility! !
!PstPocketSmalltalkPalmOS categoriesFor: #trapClass!parameters!public! !

!PstPocketSmalltalkPalmOS class methodsFor!

systemFilesToLoad
	"Answer a collection of file names that should be loaded into a new project."

	SystemFileNames := nil.
	(SystemFileNames isNil or: [SystemFileNames size < 1]) ifTrue: [
		SystemFileNames := #('core.st' 'forms.st').].

	^SystemFileNames.
! !
!PstPocketSmalltalkPalmOS class categoriesFor: #systemFilesToLoad!*-unclassified!public! !



PstRuntimeSessionManager comment: ''!

PstRuntimeSessionManager guid: (GUID fromString: '{CB619F62-A716-4562-B64D-962FBDB6EA0D}')!

!PstRuntimeSessionManager categoriesForClass!Unclassified! !
!PstRuntimeSessionManager methodsFor!

main
	Pst initSystem.
	PstLauncher show.
!

secondaryStartup
	super secondaryStartup.

	PstSplash new showTimed.! !
!PstRuntimeSessionManager categoriesFor: #main!*-unclassified!public! !
!PstRuntimeSessionManager categoriesFor: #secondaryStartup!*-unclassified!public! !



PstSplash comment: ''!

PstSplash guid: (GUID fromString: '{30366DFF-82C0-4D12-91D6-C480073D4EA3}')!

!PstSplash categoriesForClass!Unclassified! !
!PstSplash methodsFor!

defaultWindowStyle
	"Private - Answer the default basic window creation style"

	^WS_POPUP | WS_DLGFRAME! !
!PstSplash categoriesFor: #defaultWindowStyle!*-unclassified!private! !

!PstSplash class methodsFor!

new
	"Try to get the splash bitmap."

	| bitmap |

	bitmap := (Bitmap fromFile: (File composePath: SessionManager current installationDirectory 
			subPath: 'PstSplash.bmp')
			usingLocator: FileLocator absolute).

	"bitmap := Bitmap fromFile: 'c:\pst\PstSplash.bmp'."
	^self bitmap: bitmap.
	! !
!PstSplash class categoriesFor: #new!*-unclassified!public! !



PstToolbar comment: ''!

PstToolbar guid: (GUID fromString: '{87573EB5-F2CF-41E6-9B71-A025BE5FCFAA}')!

!PstToolbar categoriesForClass!Unclassified! !
!PstToolbar class methodsFor!

referencedViews
	"The purpose of this method is to prevent the toolbars loaded as ReferenceViews from being stripped
	(the reference chasing in D4.0 does not detect the names of reference views in referencing view
	resources at present)."

	'PstEditTools Toolbar'.
	'PstDebugger Toolbar'.
	'PstTools Toolbar'.
	'PstFileTools Toolbar'.
	'PstWorkspaceTools Toolbar'.
	'PstImage Toolbar'.
	! !
!PstToolbar class categoriesFor: #referencedViews!constants!must not strip!public! !

 
"Binary Globals"!

"Resources"!

(ResourceIdentifier class: PstAboutShell name: 'Default view') assign: (Object fromBinaryStoreBytes:
#[33 83 84 66 32 48 32 70 2 12 0 1 0 0 0 86 105 101 119 82 101 115 111 117 114 99 101 0 0 0 0 14 1 36 0 83 84 66 82 101 115 111 117 114 99 101 83 84 66 66 121 116 101 65 114 114 97 121 65 99 99 101 115 115 111 114 80 114 111 120 121 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 112 10 0 0 33 83 84 66 32 48 32 78 8 12 0 10 0 0 0 83 84 66 86 105 101 119 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 146 0 0 0 9 0 0 0 83 104 101 108 108 86 105 101 119 38 0 5 0 65 114 114 97 121 24 0 0 0 0 0 0 0 0 0 0 0 194 0 0 0 2 0 0 0 1 0 158 1 1 0 2 0 96 0 0 0 0 0 0 0 6 3 3 0 82 71 66 0 0 0 0 255 1 0 0 255 1 0 0 255 1 0 0 6 2 5 0 80 111 105 110 116 0 0 0 0 67 4 0 0 215 1 0 0 135 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 14 2 26 0 83 84 66 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 18 0 0 0 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 194 0 0 0 2 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 12 0 0 0 83 116 97 116 105 99 66 105 116 109 97 112 194 0 0 0 17 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 54 0 12 0 76 97 114 103 101 73 110 116 101 103 101 114 4 0 0 0 14 1 0 68 1 0 0 0 128 1 0 0 70 4 11 0 2 0 0 0 86 97 108 117 101 72 111 108 100 101 114 0 0 0 0 0 0 0 0 32 0 0 0 6 1 16 0 67 111 109 112 97 114 105 115 111 110 80 111 108 105 99 121 0 0 0 0 6 2 7 0 77 101 115 115 97 103 101 0 0 0 0 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 146 0 0 0 2 0 0 0 61 61 194 0 0 0 0 0 0 0 70 10 10 0 3 0 0 0 68 73 66 83 101 99 116 105 111 110 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 90 2 0 0 0 0 0 0 146 0 0 0 7 0 0 0 99 117 114 114 101 110 116 146 0 0 0 13 0 0 0 80 115 116 83 112 108 97 115 104 46 98 109 112 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 146 0 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0 0 0 0 0 5 0 0 0 18 1 0 0 0 0 0 0 209 1 0 0 11 1 0 0 49 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 210 1 0 0 4 0 0 0 227 147 225 119 6 2 13 0 78 117 108 108 67 111 110 118 101 114 116 101 114 0 0 0 0 0 0 0 0 0 0 0 0 32 0 0 0 160 2 0 0 6 1 15 0 77 101 115 115 97 103 101 83 101 113 117 101 110 99 101 0 0 0 0 14 2 18 0 83 84 66 67 111 108 108 101 99 116 105 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 79 114 100 101 114 101 100 67 111 108 108 101 99 116 105 111 110 194 0 0 0 1 0 0 0 6 3 11 0 77 101 115 115 97 103 101 83 101 110 100 0 0 0 0 90 2 0 0 0 0 0 0 146 0 0 0 16 0 0 0 99 114 101 97 116 101 65 116 58 101 120 116 101 110 116 58 194 0 0 0 2 0 0 0 18 1 0 0 0 0 0 0 1 0 0 0 31 0 0 0 18 1 0 0 0 0 0 0 209 1 0 0 11 1 0 0 128 1 0 0 6 1 15 0 87 73 78 68 79 87 80 76 65 67 69 77 69 78 84 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 15 0 0 0 232 0 0 0 148 0 0 0 186 3 0 0 0 0 0 0 208 3 0 0 194 0 0 0 0 0 0 0 18 1 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 19 0 0 0 146 0 0 0 14 0 0 0 105 109 97 103 101 80 114 101 115 101 110 116 101 114 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 195 32 0 0 0 0 0 0 70 5 4 0 3 0 0 0 73 99 111 110 0 0 0 0 0 0 0 0 16 0 0 0 192 2 0 0 146 0 0 0 28 0 0 0 46 46 92 46 46 92 46 46 92 46 46 92 80 83 84 92 112 111 99 107 101 116 115 116 46 105 99 111 48 3 0 0 18 1 0 0 0 0 0 0 67 4 0 0 215 1 0 0 18 1 0 0 0 0 0 0 67 4 0 0 215 1 0 0 146 3 0 0 0 0 0 0 186 3 0 0 0 0 0 0 208 3 0 0 194 0 0 0 3 0 0 0 2 4 0 0 0 0 0 0 32 4 0 0 194 0 0 0 2 0 0 0 18 1 0 0 0 0 0 0 11 0 0 0 11 0 0 0 18 1 0 0 0 0 0 0 67 4 0 0 215 1 0 0 96 0 0 0 2 4 0 0 0 0 0 0 90 2 0 0 0 0 0 0 146 0 0 0 5 0 0 0 116 101 120 116 58 194 0 0 0 1 0 0 0 146 0 0 0 25 0 0 0 65 98 111 117 116 32 80 111 99 107 101 116 32 83 109 97 108 108 116 97 108 107 46 46 46 96 0 0 0 2 4 0 0 0 0 0 0 90 2 0 0 0 0 0 0 146 0 0 0 8 0 0 0 109 101 110 117 66 97 114 58 194 0 0 0 1 0 0 0 0 0 0 0 96 0 0 0 114 4 0 0 0 0 0 0 146 4 0 0 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 5 0 0 0 38 2 0 0 240 0 0 0 186 3 0 0 0 0 0 0 208 3 0 0 194 0 0 0 3 0 0 0 128 1 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 10 0 0 0 83 116 97 116 105 99 84 101 120 116 194 0 0 0 16 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 210 1 0 0 4 0 0 0 0 1 0 68 1 0 0 0 128 6 0 0 0 0 0 0 242 0 0 0 0 0 0 0 255 1 0 0 255 1 0 0 255 1 0 0 0 0 0 0 7 0 0 0 0 0 0 0 6 4 4 0 70 111 110 116 0 0 0 0 0 0 0 0 16 0 0 0 6 1 7 0 76 79 71 70 79 78 84 0 0 0 0 146 4 0 0 60 0 0 0 243 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 144 1 0 0 0 0 0 0 3 2 1 34 86 101 114 100 97 110 97 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18 1 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 210 1 0 0 4 0 0 0 227 147 225 119 114 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 146 3 0 0 0 0 0 0 186 3 0 0 0 0 0 0 208 3 0 0 194 0 0 0 2 0 0 0 2 4 0 0 0 0 0 0 32 4 0 0 194 0 0 0 2 0 0 0 18 1 0 0 0 0 0 0 19 2 0 0 21 0 0 0 18 1 0 0 0 0 0 0 19 2 0 0 35 1 0 0 128 6 0 0 2 4 0 0 0 0 0 0 192 5 0 0 194 0 0 0 1 0 0 0 146 0 0 0 140 0 0 0 80 111 99 107 101 116 32 83 109 97 108 108 116 97 108 107 32 49 46 54 13 10 13 10 67 111 112 121 114 105 103 104 116 32 40 67 41 32 49 57 57 56 45 50 48 48 49 32 80 111 99 107 101 116 32 83 109 97 108 108 116 97 108 107 13 10 13 10 80 111 114 116 105 111 110 115 58 13 10 67 111 112 121 114 105 103 104 116 32 40 67 41 32 50 48 48 48 32 80 101 116 114 32 78 111 118 97 107 13 10 67 111 112 121 114 105 103 104 116 32 40 67 41 32 50 48 48 48 32 74 111 101 121 32 71 105 98 115 111 110 128 6 0 0 114 4 0 0 0 0 0 0 146 4 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 9 1 0 0 10 0 0 0 18 2 0 0 155 0 0 0 186 3 0 0 0 0 0 0 208 3 0 0 192 4 0 0 208 4 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 10 0 0 0 80 117 115 104 66 117 116 116 111 110 194 0 0 0 17 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 210 1 0 0 4 0 0 0 0 32 1 68 1 0 0 0 64 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 210 1 0 0 4 0 0 0 46 162 226 119 70 4 18 0 2 0 0 0 67 111 109 109 97 110 100 68 101 115 99 114 105 112 116 105 111 110 0 0 0 0 90 2 0 0 0 0 0 0 146 0 0 0 2 0 0 0 111 107 146 0 0 0 3 0 0 0 38 79 75 1 0 0 0 0 0 0 0 0 0 0 0 3 0 0 0 146 3 0 0 0 0 0 0 186 3 0 0 0 0 0 0 208 3 0 0 194 0 0 0 3 0 0 0 2 4 0 0 0 0 0 0 32 4 0 0 194 0 0 0 2 0 0 0 18 1 0 0 0 0 0 0 185 1 0 0 85 1 0 0 18 1 0 0 0 0 0 0 171 0 0 0 61 0 0 0 64 8 0 0 2 4 0 0 0 0 0 0 90 2 0 0 0 0 0 0 146 0 0 0 10 0 0 0 105 115 69 110 97 98 108 101 100 58 194 0 0 0 1 0 0 0 32 0 0 0 64 8 0 0 2 4 0 0 0 0 0 0 192 5 0 0 194 0 0 0 1 0 0 0 146 0 0 0 3 0 0 0 38 79 75 64 8 0 0 114 4 0 0 0 0 0 0 146 4 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 220 0 0 0 170 0 0 0 49 1 0 0 200 0 0 0 186 3 0 0 0 0 0 0 208 3 0 0 192 4 0 0 208 4 0 0 0 0 0 0 19 0 0 0 208 4 0 0 0 0 0 0 19 0 0 0 70 5 4 0 3 0 0 0 73 99 111 110 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 18 1 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 18 1 0 0 7 0 0 0 99 117 114 114 101 110 116 18 1 0 0 13 0 0 0 83 104 101 108 108 86 105 101 119 46 105 99 111 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 18 1 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0])!

(ResourceIdentifier class: PstClassBrowser name: 'Default view') assign: (Object fromBinaryStoreBytes:
#[33 83 84 66 32 48 32 70 2 12 0 1 0 0 0 86 105 101 119 82 101 115 111 117 114 99 101 0 0 0 0 14 1 36 0 83 84 66 82 101 115 111 117 114 99 101 83 84 66 66 121 116 101 65 114 114 97 121 65 99 99 101 115 115 111 114 80 114 111 120 121 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 250 45 0 0 33 83 84 66 32 48 32 78 8 12 0 10 0 0 0 83 84 66 86 105 101 119 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 146 0 0 0 9 0 0 0 83 104 101 108 108 86 105 101 119 38 0 5 0 65 114 114 97 121 24 0 0 0 0 0 0 0 0 0 0 0 194 0 0 0 2 0 0 0 1 0 158 1 1 0 2 0 96 0 0 0 0 0 0 0 0 0 0 0 6 2 5 0 80 111 105 110 116 0 0 0 0 1 5 0 0 193 3 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 7 12 0 66 111 114 100 101 114 76 97 121 111 117 116 0 0 0 0 1 0 0 0 1 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 13 0 0 0 67 111 110 116 97 105 110 101 114 86 105 101 119 194 0 0 0 15 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 54 0 12 0 76 97 114 103 101 73 110 116 101 103 101 114 4 0 0 0 0 0 0 68 1 0 2 0 48 1 0 0 0 0 0 0 6 1 11 0 83 121 115 116 101 109 67 111 108 111 114 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 3 10 0 70 108 111 119 76 97 121 111 117 116 0 0 0 0 1 0 0 0 1 0 0 0 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 146 0 0 0 4 0 0 0 108 101 102 116 14 2 26 0 83 84 66 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 18 0 0 0 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 194 0 0 0 0 0 0 0 0 0 0 0 6 1 15 0 77 101 115 115 97 103 101 83 101 113 117 101 110 99 101 0 0 0 0 14 2 18 0 83 84 66 67 111 108 108 101 99 116 105 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 79 114 100 101 114 101 100 67 111 108 108 101 99 116 105 111 110 194 0 0 0 1 0 0 0 6 3 11 0 77 101 115 115 97 103 101 83 101 110 100 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 16 0 0 0 99 114 101 97 116 101 65 116 58 101 120 116 101 110 116 58 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 51 0 0 0 48 1 0 0 6 1 15 0 87 73 78 68 79 87 80 76 65 67 69 77 69 78 84 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 120 2 0 0 25 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 5 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 13 0 0 0 82 101 102 101 114 101 110 99 101 86 105 101 119 194 0 0 0 14 0 0 0 0 0 0 0 48 1 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 160 3 0 0 0 0 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 2 18 0 82 101 115 111 117 114 99 101 73 100 101 110 116 105 102 105 101 114 0 0 0 0 122 0 0 0 0 0 0 0 146 0 0 0 3 0 0 0 112 115 116 146 0 0 0 10 0 0 0 80 115 116 84 111 111 108 98 97 114 146 0 0 0 16 0 0 0 80 115 116 73 109 97 103 101 32 84 111 111 108 98 97 114 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 63 0 0 0 51 0 0 0 160 3 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 31 0 0 0 25 0 0 0 194 0 0 0 0 0 0 0 242 0 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 176 3 0 0 194 0 0 0 14 0 0 0 0 0 0 0 48 1 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 32 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18 4 0 0 0 0 0 0 48 4 0 0 146 0 0 0 16 0 0 0 80 115 116 84 111 111 108 115 32 84 111 111 108 98 97 114 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 63 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 247 0 0 0 51 0 0 0 32 5 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 31 0 0 0 0 0 0 0 154 0 0 0 25 0 0 0 0 5 0 0 16 5 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 176 3 0 0 194 0 0 0 14 0 0 0 0 0 0 0 48 1 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 16 6 0 0 0 0 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18 4 0 0 0 0 0 0 48 4 0 0 146 0 0 0 20 0 0 0 80 115 116 70 105 108 101 84 111 111 108 115 32 84 111 111 108 98 97 114 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 53 1 0 0 1 0 0 0 242 0 0 0 0 0 0 0 155 0 0 0 49 0 0 0 16 6 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 154 0 0 0 0 0 0 0 231 0 0 0 24 0 0 0 0 5 0 0 16 5 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 176 3 0 0 194 0 0 0 14 0 0 0 0 0 0 0 48 1 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 16 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18 4 0 0 0 0 0 0 48 4 0 0 146 0 0 0 20 0 0 0 80 115 116 69 100 105 116 84 111 111 108 115 32 84 111 111 108 98 97 114 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 207 1 0 0 1 0 0 0 242 0 0 0 0 0 0 0 247 0 0 0 49 0 0 0 16 7 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 231 0 0 0 0 0 0 0 98 1 0 0 24 0 0 0 0 5 0 0 16 5 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 176 3 0 0 194 0 0 0 14 0 0 0 0 0 0 0 48 1 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 0 8 0 0 0 0 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18 4 0 0 0 0 0 0 48 4 0 0 146 0 0 0 25 0 0 0 80 115 116 87 111 114 107 115 112 97 99 101 84 111 111 108 115 32 84 111 111 108 98 97 114 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 197 2 0 0 1 0 0 0 242 0 0 0 0 0 0 0 155 0 0 0 51 0 0 0 0 8 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 98 1 0 0 0 0 0 0 175 1 0 0 25 0 0 0 0 5 0 0 16 5 0 0 0 0 0 0 19 0 0 0 16 5 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 9 0 0 0 83 116 97 116 117 115 66 97 114 194 0 0 0 18 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 4 1 0 68 1 0 0 0 0 9 0 0 0 0 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 6 4 4 0 70 111 110 116 0 0 0 0 0 0 0 0 16 0 0 0 6 1 7 0 76 79 71 70 79 78 84 0 0 0 0 98 3 0 0 60 0 0 0 243 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 144 1 0 0 0 0 0 0 3 2 1 34 65 114 105 97 108 0 31 5 20 135 63 1 0 0 204 53 63 1 3 0 20 59 0 0 0 0 247 0 5 86 111 1 242 0 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 8 0 0 0 39 2 255 255 0 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 80 2 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 6 4 17 0 83 116 97 116 117 115 66 97 114 78 117 108 108 73 116 101 109 0 0 0 0 1 2 0 0 1 0 0 0 0 9 0 0 0 0 0 0 32 10 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 95 3 0 0 242 0 0 0 0 0 0 0 241 4 0 0 45 0 0 0 0 9 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 175 1 0 0 120 2 0 0 197 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 0 0 0 0 0 0 0 0 90 0 0 0 0 0 0 0 64 1 0 0 194 0 0 0 15 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 208 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 2 18 0 80 114 111 112 111 114 116 105 111 110 97 108 76 97 121 111 117 116 0 0 0 0 26 2 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 11 0 0 0 76 111 111 107 117 112 84 97 98 108 101 194 0 0 0 2 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 8 0 0 0 83 112 108 105 116 116 101 114 194 0 0 0 12 0 0 0 0 0 0 0 208 10 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 0 0 112 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 147 1 0 0 242 0 0 0 0 0 0 0 241 4 0 0 7 0 0 0 112 11 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 201 0 0 0 120 2 0 0 204 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 1 0 0 0 16 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 80 2 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 51 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 45 3 0 0 208 10 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 25 0 0 0 120 2 0 0 175 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 90 0 0 0 0 0 0 0 64 1 0 0 194 0 0 0 15 0 0 0 0 0 0 0 208 10 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 48 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18 11 0 0 0 0 0 0 26 2 0 0 0 0 0 0 64 11 0 0 194 0 0 0 2 0 0 0 90 0 0 0 0 0 0 0 128 11 0 0 194 0 0 0 12 0 0 0 0 0 0 0 48 13 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 0 0 160 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 117 2 0 0 1 0 0 0 242 0 0 0 0 0 0 0 7 0 0 0 147 1 0 0 160 13 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 58 1 0 0 0 0 0 0 61 1 0 0 201 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 1 0 0 0 32 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 194 0 0 0 2 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 8 0 0 0 84 114 101 101 86 105 101 119 194 0 0 0 25 0 0 0 0 0 0 0 48 13 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 35 0 1 68 1 4 0 0 160 14 0 0 70 3 9 0 1 0 0 0 84 114 101 101 77 111 100 101 108 0 0 0 0 0 0 0 0 6 3 8 0 84 114 101 101 78 111 100 101 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 80 2 0 0 0 0 0 0 0 0 0 0 7 0 0 0 70 5 4 0 2 0 0 0 77 101 110 117 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 12 0 0 0 70 2 15 0 1 0 0 0 67 111 109 109 97 110 100 77 101 110 117 73 116 101 109 0 0 0 0 1 0 0 0 70 4 18 0 2 0 0 0 67 111 109 109 97 110 100 68 101 115 99 114 105 112 116 105 111 110 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 11 0 0 0 97 100 100 83 117 98 99 108 97 115 115 146 0 0 0 17 0 0 0 77 97 107 101 32 38 115 117 98 99 108 97 115 115 46 46 46 1 0 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 11 0 0 0 100 101 108 101 116 101 67 108 97 115 115 146 0 0 0 13 0 0 0 38 68 101 108 101 116 101 32 99 108 97 115 115 1 0 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 9 0 0 0 102 105 110 100 67 108 97 115 115 146 0 0 0 14 0 0 0 38 70 105 110 100 32 99 108 97 115 115 46 46 46 1 0 0 0 0 0 0 0 70 1 15 0 1 0 0 0 68 105 118 105 100 101 114 77 101 110 117 73 116 101 109 0 0 0 0 1 16 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 23 0 0 0 98 114 111 119 115 101 82 101 102 101 114 101 110 99 101 115 84 111 67 108 97 115 115 146 0 0 0 17 0 0 0 38 67 108 97 115 115 32 114 101 102 101 114 101 110 99 101 115 1 0 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 34 0 0 0 98 114 111 119 115 101 82 101 102 101 114 101 110 99 101 115 84 111 73 110 115 116 97 110 99 101 86 97 114 105 97 98 108 101 146 0 0 0 21 0 0 0 38 73 110 115 116 97 110 99 101 32 118 97 114 32 114 101 102 115 46 46 46 1 0 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 31 0 0 0 98 114 111 119 115 101 82 101 102 101 114 101 110 99 101 115 84 111 67 108 97 115 115 86 97 114 105 97 98 108 101 146 0 0 0 18 0 0 0 67 108 97 115 115 32 38 118 97 114 32 114 101 102 115 46 46 46 1 0 0 0 0 0 0 0 146 16 0 0 0 0 0 0 1 16 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 14 0 0 0 114 101 99 111 109 112 105 108 101 67 108 97 115 115 146 0 0 0 16 0 0 0 38 82 101 99 111 109 112 105 108 101 32 99 108 97 115 115 1 0 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 18 0 0 0 114 101 99 111 109 112 105 108 101 72 105 101 114 97 114 99 104 121 146 0 0 0 20 0 0 0 82 101 99 111 109 112 105 108 101 32 38 104 105 101 114 97 114 99 104 121 1 0 0 0 0 0 0 0 146 16 0 0 0 0 0 0 1 16 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 18 0 0 0 99 104 97 110 103 101 67 108 97 115 115 80 97 99 107 97 103 101 146 0 0 0 18 0 0 0 67 104 97 110 103 101 32 38 112 97 99 107 97 103 101 46 46 46 1 0 0 0 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 8 0 0 0 55 2 255 255 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 66 97 115 105 99 76 105 115 116 65 98 115 116 114 97 99 116 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 18 0 0 0 73 99 111 110 105 99 76 105 115 116 65 98 115 116 114 97 99 116 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 16 0 0 0 73 99 111 110 73 109 97 103 101 77 97 110 97 103 101 114 234 1 0 0 0 0 0 0 146 0 0 0 7 0 0 0 99 117 114 114 101 110 116 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 26 2 0 0 0 0 0 0 64 11 0 0 80 2 0 0 17 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 7 0 0 0 110 111 73 99 111 110 115 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 2 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 117 2 0 0 147 1 0 0 160 14 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 12 0 0 0 99 111 110 116 101 120 116 77 101 110 117 58 194 0 0 0 1 0 0 0 96 15 0 0 160 14 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 58 1 0 0 201 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 21 0 0 0 146 0 0 0 9 0 0 0 99 108 97 115 115 84 114 101 101 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 147 1 0 0 48 13 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 120 2 0 0 201 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 160 14 0 0 160 13 0 0 90 0 0 0 0 0 0 0 64 1 0 0 194 0 0 0 15 0 0 0 0 0 0 0 48 13 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 64 21 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 7 0 0 0 84 97 98 86 105 101 119 194 0 0 0 23 0 0 0 0 0 0 0 64 21 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 2 1 68 1 0 0 0 144 21 0 0 70 3 9 0 2 0 0 0 76 105 115 116 77 111 100 101 108 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 0 0 0 0 6 0 20 0 73 100 101 110 116 105 116 121 83 101 97 114 99 104 80 111 108 105 99 121 0 0 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 8 0 0 0 47 2 255 255 0 0 0 0 208 18 0 0 240 18 0 0 32 19 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 128 19 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 2 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 119 2 0 0 61 0 0 0 144 21 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 30 0 0 0 116 99 109 83 101 116 69 120 116 101 110 100 101 100 83 116 121 108 101 58 100 119 69 120 83 116 121 108 101 58 194 0 0 0 2 0 0 0 255 255 255 255 1 0 0 0 144 21 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 59 1 0 0 30 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 21 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 90 0 0 0 0 0 0 0 176 14 0 0 194 0 0 0 25 0 0 0 0 0 0 0 64 21 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 39 0 1 68 1 4 0 0 64 23 0 0 2 15 0 0 0 0 0 0 0 0 0 0 34 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 80 2 0 0 0 0 0 0 0 0 0 0 7 0 0 0 82 15 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 10 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 9 0 0 0 110 101 119 77 101 116 104 111 100 146 0 0 0 11 0 0 0 38 78 101 119 32 109 101 116 104 111 100 1 0 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 6 0 0 0 100 101 108 101 116 101 146 0 0 0 7 0 0 0 38 68 101 108 101 116 101 1 0 0 0 0 0 0 0 146 16 0 0 0 0 0 0 1 16 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 10 0 0 0 99 97 116 101 103 111 114 105 122 101 146 0 0 0 14 0 0 0 38 67 97 116 101 103 111 114 105 122 101 46 46 46 1 0 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 113 117 105 99 107 67 97 116 101 103 111 114 105 122 101 146 0 0 0 20 0 0 0 38 81 117 105 99 107 32 99 97 116 101 103 111 114 105 122 101 46 46 46 1 0 0 0 0 0 0 0 146 16 0 0 0 0 0 0 1 16 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 18 0 0 0 98 114 111 119 115 101 73 109 112 108 101 109 101 110 116 111 114 115 146 0 0 0 13 0 0 0 38 73 109 112 108 101 109 101 110 116 111 114 115 1 0 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 13 0 0 0 98 114 111 119 115 101 83 101 110 100 101 114 115 146 0 0 0 8 0 0 0 38 83 101 110 100 101 114 115 1 0 0 0 0 0 0 0 160 17 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 19 0 0 0 99 104 97 110 103 101 77 101 116 104 111 100 80 97 99 107 97 103 101 146 0 0 0 18 0 0 0 67 104 97 110 103 101 32 38 112 97 99 107 97 103 101 46 46 46 1 0 0 0 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 8 0 0 0 55 2 255 255 0 0 0 0 208 18 0 0 240 18 0 0 32 19 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 26 2 0 0 0 0 0 0 64 11 0 0 80 2 0 0 17 0 0 0 128 19 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 2 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 61 0 0 0 242 0 0 0 0 0 0 0 119 2 0 0 87 1 0 0 64 23 0 0 210 2 0 0 0 0 0 0 32 20 0 0 194 0 0 0 1 0 0 0 176 23 0 0 64 23 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 30 0 0 0 59 1 0 0 201 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 21 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 194 0 0 0 4 0 0 0 64 23 0 0 146 0 0 0 10 0 0 0 109 101 116 104 111 100 84 114 101 101 144 21 0 0 146 0 0 0 9 0 0 0 99 108 97 115 115 83 105 100 101 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 123 2 0 0 1 0 0 0 242 0 0 0 0 0 0 0 119 2 0 0 147 1 0 0 64 21 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 61 1 0 0 0 0 0 0 120 2 0 0 201 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 2 0 0 0 144 21 0 0 64 23 0 0 16 5 0 0 0 0 0 0 19 0 0 0 16 5 0 0 0 0 0 0 19 0 0 0 112 11 0 0 90 0 0 0 0 0 0 0 64 1 0 0 194 0 0 0 15 0 0 0 0 0 0 0 208 10 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 0 28 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 90 0 0 0 0 0 0 0 160 21 0 0 194 0 0 0 23 0 0 0 0 0 0 0 0 28 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 2 1 68 1 0 0 0 80 28 0 0 242 21 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 0 0 0 0 48 22 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 8 0 0 0 47 2 255 255 0 0 0 0 208 18 0 0 240 18 0 0 32 19 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 128 19 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 2 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 61 0 0 0 80 28 0 0 210 2 0 0 0 0 0 0 224 22 0 0 194 0 0 0 2 0 0 0 255 255 255 255 1 0 0 0 80 28 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 120 2 0 0 30 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 21 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 12 0 0 0 82 105 99 104 84 101 120 116 69 100 105 116 194 0 0 0 18 0 0 0 0 0 0 0 0 28 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 68 17 33 68 1 4 0 0 144 29 0 0 0 0 0 0 6 3 3 0 82 71 66 0 0 0 0 181 1 0 0 215 1 0 0 209 1 0 0 0 0 0 0 7 0 0 0 82 15 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 10 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 6 0 0 0 97 99 99 101 112 116 146 0 0 0 7 0 0 0 38 65 99 99 101 112 116 167 32 0 0 0 0 0 0 146 16 0 0 0 0 0 0 1 16 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 12 0 0 0 99 117 116 83 101 108 101 99 116 105 111 110 146 0 0 0 4 0 0 0 67 117 38 116 177 32 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 13 0 0 0 99 111 112 121 83 101 108 101 99 116 105 111 110 146 0 0 0 5 0 0 0 38 67 111 112 121 135 32 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 14 0 0 0 112 97 115 116 101 67 108 105 112 98 111 97 114 100 146 0 0 0 6 0 0 0 38 80 97 115 116 101 173 32 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 14 0 0 0 99 108 101 97 114 83 101 108 101 99 116 105 111 110 146 0 0 0 7 0 0 0 68 101 38 108 101 116 101 93 2 0 0 0 0 0 0 128 30 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 4 0 0 0 100 111 73 116 146 0 0 0 6 0 0 0 38 68 111 32 105 116 139 32 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 7 0 0 0 112 114 105 110 116 73 116 146 0 0 0 9 0 0 0 80 38 114 105 110 116 32 105 116 137 32 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 9 0 0 0 105 110 115 112 101 99 116 73 116 146 0 0 0 11 0 0 0 38 73 110 115 112 101 99 116 32 105 116 147 32 0 0 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 4 0 0 0 211 16 46 119 6 2 13 0 78 117 108 108 67 111 110 118 101 114 116 101 114 0 0 0 0 0 0 0 0 0 0 0 0 9 0 0 0 0 0 0 0 6 1 10 0 69 68 73 84 83 84 82 69 65 77 0 0 0 0 98 3 0 0 12 0 0 0 0 0 0 0 0 0 0 0 172 118 233 8 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 6 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 61 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 89 1 0 0 144 29 0 0 210 2 0 0 0 0 0 0 32 20 0 0 194 0 0 0 1 0 0 0 16 30 0 0 144 29 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 5 0 0 0 116 101 120 116 58 194 0 0 0 1 0 0 0 6 1 8 0 82 105 99 104 84 101 120 116 0 0 0 0 146 0 0 0 120 0 0 0 123 92 114 116 102 49 92 97 110 115 105 92 97 110 115 105 99 112 103 49 50 53 50 92 100 101 102 102 48 92 100 101 102 108 97 110 103 50 48 53 55 123 92 102 111 110 116 116 98 108 123 92 102 48 92 102 114 111 109 97 110 32 84 105 109 101 115 32 78 101 119 32 82 111 109 97 110 59 125 125 13 10 92 118 105 101 119 107 105 110 100 52 92 117 99 49 92 112 97 114 100 92 102 48 92 102 115 50 50 32 13 10 92 112 97 114 32 125 13 10 144 29 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 115 101 108 101 99 116 105 111 110 82 97 110 103 101 58 194 0 0 0 1 0 0 0 6 3 8 0 73 110 116 101 114 118 97 108 0 0 0 0 3 0 0 0 1 0 0 0 3 0 0 0 144 29 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 105 115 84 101 120 116 77 111 100 105 102 105 101 100 58 194 0 0 0 1 0 0 0 32 0 0 0 144 29 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 114 101 115 101 116 67 104 97 114 70 111 114 109 97 116 194 0 0 0 0 0 0 0 144 29 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 30 0 0 0 120 2 0 0 202 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 194 0 0 0 4 0 0 0 80 28 0 0 146 0 0 0 8 0 0 0 109 111 100 101 76 105 115 116 144 29 0 0 146 0 0 0 10 0 0 0 115 111 117 114 99 101 67 111 100 101 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 153 1 0 0 242 0 0 0 0 0 0 0 241 4 0 0 149 1 0 0 0 28 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 204 0 0 0 120 2 0 0 150 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 2 0 0 0 80 28 0 0 144 29 0 0 16 5 0 0 0 0 0 0 19 0 0 0 16 5 0 0 0 0 0 0 19 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 194 0 0 0 2 0 0 0 0 9 0 0 146 0 0 0 6 0 0 0 115 116 97 116 117 115 0 0 0 0 70 5 7 0 2 0 0 0 77 101 110 117 66 97 114 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 3 0 0 0 82 15 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 12 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 192 15 0 0 146 0 0 0 17 0 0 0 77 97 107 101 32 38 115 117 98 99 108 97 115 115 46 46 46 1 0 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 16 16 0 0 146 0 0 0 13 0 0 0 38 68 101 108 101 116 101 32 99 108 97 115 115 1 0 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 96 16 0 0 146 0 0 0 14 0 0 0 38 70 105 110 100 32 99 108 97 115 115 46 46 46 1 0 0 0 0 0 0 0 146 16 0 0 0 0 0 0 1 16 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 208 16 0 0 146 0 0 0 17 0 0 0 38 67 108 97 115 115 32 114 101 102 101 114 101 110 99 101 115 1 0 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 32 17 0 0 146 0 0 0 21 0 0 0 38 73 110 115 116 97 110 99 101 32 118 97 114 32 114 101 102 115 46 46 46 1 0 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 112 17 0 0 146 0 0 0 18 0 0 0 67 108 97 115 115 32 38 118 97 114 32 114 101 102 115 46 46 46 1 0 0 0 0 0 0 0 146 16 0 0 0 0 0 0 1 16 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 208 17 0 0 146 0 0 0 16 0 0 0 38 82 101 99 111 109 112 105 108 101 32 99 108 97 115 115 1 0 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 32 18 0 0 146 0 0 0 20 0 0 0 82 101 99 111 109 112 105 108 101 32 38 104 105 101 114 97 114 99 104 121 1 0 0 0 0 0 0 0 224 37 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 128 18 0 0 146 0 0 0 18 0 0 0 67 104 97 110 103 101 32 38 112 97 99 107 97 103 101 46 46 46 1 0 0 0 0 0 0 0 146 0 0 0 6 0 0 0 38 67 108 97 115 115 0 0 0 0 82 15 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 10 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 240 23 0 0 146 0 0 0 11 0 0 0 38 78 101 119 32 109 101 116 104 111 100 1 0 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 64 24 0 0 146 0 0 0 7 0 0 0 38 68 101 108 101 116 101 1 0 0 0 0 0 0 0 146 16 0 0 0 0 0 0 1 16 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 160 24 0 0 146 0 0 0 14 0 0 0 38 67 97 116 101 103 111 114 105 122 101 46 46 46 1 0 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 240 24 0 0 146 0 0 0 20 0 0 0 38 81 117 105 99 107 32 99 97 116 101 103 111 114 105 122 101 46 46 46 1 0 0 0 0 0 0 0 146 16 0 0 0 0 0 0 1 16 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 80 25 0 0 146 0 0 0 13 0 0 0 38 73 109 112 108 101 109 101 110 116 111 114 115 1 0 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 160 25 0 0 146 0 0 0 8 0 0 0 38 83 101 110 100 101 114 115 1 0 0 0 0 0 0 0 80 18 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 240 25 0 0 146 0 0 0 18 0 0 0 67 104 97 110 103 101 32 38 112 97 99 107 97 103 101 46 46 46 1 0 0 0 0 0 0 0 146 0 0 0 7 0 0 0 38 77 101 116 104 111 100 0 0 0 0 82 15 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 10 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 80 30 0 0 146 0 0 0 7 0 0 0 38 65 99 99 101 112 116 167 32 0 0 0 0 0 0 146 16 0 0 0 0 0 0 1 16 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 176 30 0 0 146 0 0 0 4 0 0 0 67 117 38 116 177 32 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 0 31 0 0 146 0 0 0 5 0 0 0 38 67 111 112 121 135 32 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 80 31 0 0 146 0 0 0 6 0 0 0 38 80 97 115 116 101 173 32 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 160 31 0 0 146 0 0 0 7 0 0 0 68 101 38 108 101 116 101 1 0 0 0 0 0 0 0 128 40 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 240 31 0 0 146 0 0 0 6 0 0 0 38 68 111 32 73 116 139 32 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 64 32 0 0 146 0 0 0 9 0 0 0 80 38 114 105 110 116 32 73 116 137 32 0 0 0 0 0 0 130 15 0 0 0 0 0 0 1 0 0 0 162 15 0 0 0 0 0 0 144 32 0 0 146 0 0 0 11 0 0 0 38 73 110 115 112 101 99 116 32 73 116 147 32 0 0 0 0 0 0 146 0 0 0 7 0 0 0 38 83 111 117 114 99 101 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 3 16 0 65 99 99 101 108 101 114 97 116 111 114 84 97 98 108 101 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 7 0 0 0 6 2 11 0 65 115 115 111 99 105 97 116 105 111 110 0 0 0 0 167 32 0 0 96 40 0 0 50 42 0 0 0 0 0 0 177 32 0 0 160 40 0 0 50 42 0 0 0 0 0 0 135 32 0 0 208 40 0 0 50 42 0 0 0 0 0 0 173 32 0 0 0 41 0 0 50 42 0 0 0 0 0 0 139 32 0 0 96 41 0 0 50 42 0 0 0 0 0 0 137 32 0 0 144 41 0 0 50 42 0 0 0 0 0 0 147 32 0 0 192 41 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 11 0 0 0 11 0 0 0 242 0 0 0 0 0 0 0 1 5 0 0 193 3 0 0 96 0 0 0 210 2 0 0 0 0 0 0 208 33 0 0 194 0 0 0 1 0 0 0 146 0 0 0 13 0 0 0 67 108 97 115 115 32 66 114 111 119 115 101 114 96 0 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 8 0 0 0 109 101 110 117 66 97 114 58 194 0 0 0 1 0 0 0 112 36 0 0 96 0 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 5 0 0 0 133 2 0 0 229 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 208 10 0 0 0 9 0 0 48 1 0 0 16 5 0 0 0 0 0 0 19 0 0 0 70 5 4 0 3 0 0 0 73 99 111 110 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 18 1 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 18 1 0 0 7 0 0 0 99 117 114 114 101 110 116 18 1 0 0 13 0 0 0 83 104 101 108 108 86 105 101 119 46 105 99 111 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 18 1 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0])!

(ResourceIdentifier class: PstConstantsBrowser name: 'Default view') assign: (Object fromBinaryStoreBytes:
#[33 83 84 66 32 48 32 70 2 12 0 1 0 0 0 86 105 101 119 82 101 115 111 117 114 99 101 0 0 0 0 14 1 36 0 83 84 66 82 101 115 111 117 114 99 101 83 84 66 66 121 116 101 65 114 114 97 121 65 99 99 101 115 115 111 114 80 114 111 120 121 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 142 32 0 0 33 83 84 66 32 48 32 78 8 12 0 10 0 0 0 83 84 66 86 105 101 119 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 146 0 0 0 9 0 0 0 83 104 101 108 108 86 105 101 119 38 0 5 0 65 114 114 97 121 24 0 0 0 0 0 0 0 0 0 0 0 194 0 0 0 2 0 0 0 1 0 158 1 1 0 2 0 96 0 0 0 0 0 0 0 0 0 0 0 6 2 5 0 80 111 105 110 116 0 0 0 0 1 5 0 0 193 3 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 7 12 0 66 111 114 100 101 114 76 97 121 111 117 116 0 0 0 0 1 0 0 0 1 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 13 0 0 0 67 111 110 116 97 105 110 101 114 86 105 101 119 194 0 0 0 15 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 54 0 12 0 76 97 114 103 101 73 110 116 101 103 101 114 4 0 0 0 0 0 0 68 1 0 2 0 48 1 0 0 0 0 0 0 6 1 11 0 83 121 115 116 101 109 67 111 108 111 114 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 3 10 0 70 108 111 119 76 97 121 111 117 116 0 0 0 0 1 0 0 0 1 0 0 0 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 146 0 0 0 4 0 0 0 108 101 102 116 14 2 26 0 83 84 66 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 18 0 0 0 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 194 0 0 0 0 0 0 0 0 0 0 0 6 1 15 0 77 101 115 115 97 103 101 83 101 113 117 101 110 99 101 0 0 0 0 14 2 18 0 83 84 66 67 111 108 108 101 99 116 105 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 79 114 100 101 114 101 100 67 111 108 108 101 99 116 105 111 110 194 0 0 0 1 0 0 0 6 3 11 0 77 101 115 115 97 103 101 83 101 110 100 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 16 0 0 0 99 114 101 97 116 101 65 116 58 101 120 116 101 110 116 58 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 51 0 0 0 48 1 0 0 6 1 15 0 87 73 78 68 79 87 80 76 65 67 69 77 69 78 84 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 120 2 0 0 25 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 2 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 13 0 0 0 82 101 102 101 114 101 110 99 101 86 105 101 119 194 0 0 0 14 0 0 0 0 0 0 0 48 1 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 160 3 0 0 0 0 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 2 18 0 82 101 115 111 117 114 99 101 73 100 101 110 116 105 102 105 101 114 0 0 0 0 122 0 0 0 0 0 0 0 146 0 0 0 3 0 0 0 112 115 116 146 0 0 0 10 0 0 0 80 115 116 84 111 111 108 98 97 114 146 0 0 0 16 0 0 0 80 115 116 73 109 97 103 101 32 84 111 111 108 98 97 114 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 63 0 0 0 51 0 0 0 160 3 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 31 0 0 0 25 0 0 0 194 0 0 0 0 0 0 0 242 0 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 176 3 0 0 194 0 0 0 14 0 0 0 0 0 0 0 48 1 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 32 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18 4 0 0 0 0 0 0 48 4 0 0 146 0 0 0 16 0 0 0 80 115 116 84 111 111 108 115 32 84 111 111 108 98 97 114 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 63 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 247 0 0 0 51 0 0 0 32 5 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 31 0 0 0 0 0 0 0 154 0 0 0 25 0 0 0 0 5 0 0 16 5 0 0 0 0 0 0 19 0 0 0 16 5 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 9 0 0 0 83 116 97 116 117 115 66 97 114 194 0 0 0 18 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 4 1 0 68 1 0 0 0 16 6 0 0 0 0 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 6 4 4 0 70 111 110 116 0 0 0 0 0 0 0 0 16 0 0 0 6 1 7 0 76 79 71 70 79 78 84 0 0 0 0 98 3 0 0 60 0 0 0 243 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 144 1 0 0 0 0 0 0 3 2 1 34 65 114 105 97 108 0 31 5 20 135 63 1 0 0 204 53 63 1 3 0 20 59 0 0 0 0 247 0 5 86 111 1 242 0 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 8 0 0 0 39 2 255 255 0 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 80 2 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 6 4 17 0 83 116 97 116 117 115 66 97 114 78 117 108 108 73 116 101 109 0 0 0 0 1 2 0 0 1 0 0 0 16 6 0 0 0 0 0 0 48 7 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 95 3 0 0 242 0 0 0 0 0 0 0 241 4 0 0 45 0 0 0 16 6 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 175 1 0 0 120 2 0 0 197 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 0 0 0 0 0 0 0 0 90 0 0 0 0 0 0 0 64 1 0 0 194 0 0 0 15 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 224 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 2 18 0 80 114 111 112 111 114 116 105 111 110 97 108 76 97 121 111 117 116 0 0 0 0 26 2 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 11 0 0 0 76 111 111 107 117 112 84 97 98 108 101 194 0 0 0 4 0 0 0 90 0 0 0 0 0 0 0 64 1 0 0 194 0 0 0 15 0 0 0 0 0 0 0 224 7 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 128 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 34 8 0 0 0 0 0 0 26 2 0 0 0 0 0 0 80 8 0 0 194 0 0 0 2 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 8 0 0 0 83 112 108 105 116 116 101 114 194 0 0 0 12 0 0 0 0 0 0 0 128 8 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 0 0 240 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 117 2 0 0 1 0 0 0 242 0 0 0 0 0 0 0 7 0 0 0 25 2 0 0 240 8 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 58 1 0 0 0 0 0 0 61 1 0 0 12 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 1 0 0 0 32 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 194 0 0 0 4 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 7 0 0 0 76 105 115 116 66 111 120 194 0 0 0 17 0 0 0 0 0 0 0 128 8 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 1 1 49 68 1 4 0 0 16 10 0 0 70 3 9 0 2 0 0 0 76 105 115 116 77 111 100 101 108 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 0 0 0 0 6 0 20 0 73 100 101 110 116 105 116 121 83 101 97 114 99 104 80 111 108 105 99 121 0 0 0 0 6 3 3 0 82 71 66 0 0 0 0 195 1 0 0 195 1 0 0 195 1 0 0 0 0 0 0 7 0 0 0 70 5 4 0 2 0 0 0 77 101 110 117 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 5 0 0 0 70 2 15 0 1 0 0 0 67 111 109 109 97 110 100 77 101 110 117 73 116 101 109 0 0 0 0 1 0 0 0 70 4 18 0 2 0 0 0 67 111 109 109 97 110 100 68 101 115 99 114 105 112 116 105 111 110 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 11 0 0 0 97 100 100 67 97 116 101 103 111 114 121 146 0 0 0 16 0 0 0 38 65 100 100 32 99 97 116 101 103 111 114 121 46 46 46 1 0 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 14 0 0 0 114 101 110 97 109 101 67 97 116 101 103 111 114 121 146 0 0 0 19 0 0 0 38 82 101 110 97 109 101 32 99 97 116 101 103 111 114 121 46 46 46 1 0 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 14 0 0 0 100 101 108 101 116 101 67 97 116 101 103 111 114 121 146 0 0 0 16 0 0 0 38 68 101 108 101 116 101 32 99 97 116 101 103 111 114 121 1 0 0 0 0 0 0 0 70 1 15 0 1 0 0 0 68 105 118 105 100 101 114 77 101 110 117 73 116 101 109 0 0 0 0 1 16 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 12 0 0 0 102 105 110 100 67 111 110 115 116 97 110 116 146 0 0 0 17 0 0 0 38 70 105 110 100 32 99 111 110 115 116 97 110 116 46 46 46 1 0 0 0 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 4 0 0 0 244 100 227 119 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 66 97 115 105 99 76 105 115 116 65 98 115 116 114 97 99 116 1 0 0 0 32 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 117 2 0 0 25 2 0 0 16 10 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 12 0 0 0 99 111 110 116 101 120 116 77 101 110 117 58 194 0 0 0 1 0 0 0 240 10 0 0 16 10 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 17 0 0 0 104 111 114 105 122 111 110 116 97 108 69 120 116 101 110 116 58 194 0 0 0 1 0 0 0 1 0 0 0 16 10 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 58 1 0 0 12 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 146 0 0 0 10 0 0 0 99 97 116 101 103 111 114 105 101 115 90 0 0 0 0 0 0 0 32 10 0 0 194 0 0 0 17 0 0 0 0 0 0 0 128 8 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 1 1 49 68 1 4 0 0 0 14 0 0 114 10 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 0 0 0 0 176 10 0 0 194 10 0 0 0 0 0 0 195 1 0 0 195 1 0 0 195 1 0 0 0 0 0 0 7 0 0 0 226 10 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 7 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 11 0 0 0 110 101 119 67 111 110 115 116 97 110 116 146 0 0 0 16 0 0 0 38 78 101 119 32 99 111 110 115 116 97 110 116 46 46 46 1 0 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 14 0 0 0 100 101 108 101 116 101 67 111 110 115 116 97 110 116 146 0 0 0 16 0 0 0 38 68 101 108 101 116 101 32 99 111 110 115 116 97 110 116 1 0 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 18 0 0 0 99 97 116 101 103 111 114 105 122 101 67 111 110 115 116 97 110 116 146 0 0 0 14 0 0 0 38 67 97 116 101 103 111 114 105 122 101 46 46 46 1 0 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 13 0 0 0 99 104 97 110 103 101 80 97 99 107 97 103 101 146 0 0 0 18 0 0 0 67 104 97 110 103 101 32 38 112 97 99 107 97 103 101 46 46 46 1 0 0 0 0 0 0 0 34 12 0 0 0 0 0 0 1 16 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 26 0 0 0 98 114 111 119 115 101 82 101 102 101 114 101 110 99 101 115 84 111 67 111 110 115 116 97 110 116 146 0 0 0 18 0 0 0 38 66 114 111 119 115 101 32 114 101 102 101 114 101 110 99 101 115 1 0 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 19 0 0 0 97 100 100 82 101 115 111 117 114 99 101 68 97 116 97 98 97 115 101 146 0 0 0 25 0 0 0 38 65 100 100 32 114 101 115 111 117 114 99 101 32 100 97 116 97 98 97 115 101 46 46 46 1 0 0 0 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 4 0 0 0 244 100 227 119 176 12 0 0 1 0 0 0 32 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 123 2 0 0 1 0 0 0 242 0 0 0 0 0 0 0 119 2 0 0 25 2 0 0 0 14 0 0 210 2 0 0 0 0 0 0 80 13 0 0 194 0 0 0 1 0 0 0 112 14 0 0 0 14 0 0 210 2 0 0 0 0 0 0 144 13 0 0 194 0 0 0 1 0 0 0 1 0 0 0 0 14 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 61 1 0 0 0 0 0 0 120 2 0 0 12 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 146 0 0 0 9 0 0 0 99 111 110 115 116 97 110 116 115 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 25 2 0 0 128 8 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 120 2 0 0 12 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 16 10 0 0 240 8 0 0 0 14 0 0 16 5 0 0 0 0 0 0 19 0 0 0 5 0 0 0 90 0 0 0 0 0 0 0 0 9 0 0 194 0 0 0 12 0 0 0 0 0 0 0 224 7 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 0 0 64 18 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 25 2 0 0 242 0 0 0 0 0 0 0 241 4 0 0 7 0 0 0 64 18 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 12 1 0 0 120 2 0 0 15 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 1 0 0 0 16 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 194 0 0 0 2 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 12 0 0 0 82 105 99 104 84 101 120 116 69 100 105 116 194 0 0 0 18 0 0 0 0 0 0 0 224 7 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 68 17 33 68 1 4 0 0 64 19 0 0 0 0 0 0 194 10 0 0 0 0 0 0 181 1 0 0 215 1 0 0 209 1 0 0 0 0 0 0 7 0 0 0 226 10 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 10 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 6 0 0 0 97 99 99 101 112 116 146 0 0 0 7 0 0 0 38 65 99 99 101 112 116 167 32 0 0 0 0 0 0 34 12 0 0 0 0 0 0 1 16 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 12 0 0 0 99 117 116 83 101 108 101 99 116 105 111 110 146 0 0 0 4 0 0 0 67 117 38 116 177 32 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 13 0 0 0 99 111 112 121 83 101 108 101 99 116 105 111 110 146 0 0 0 5 0 0 0 38 67 111 112 121 135 32 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 14 0 0 0 112 97 115 116 101 67 108 105 112 98 111 97 114 100 146 0 0 0 6 0 0 0 38 80 97 115 116 101 173 32 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 14 0 0 0 99 108 101 97 114 83 101 108 101 99 116 105 111 110 146 0 0 0 7 0 0 0 68 101 38 108 101 116 101 93 2 0 0 0 0 0 0 32 20 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 4 0 0 0 100 111 73 116 146 0 0 0 6 0 0 0 38 68 111 32 73 116 139 32 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 7 0 0 0 112 114 105 110 116 73 116 146 0 0 0 9 0 0 0 80 38 114 105 110 116 32 73 116 137 32 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 9 0 0 0 105 110 115 112 101 99 116 73 116 146 0 0 0 11 0 0 0 38 73 110 115 112 101 99 116 32 73 116 147 32 0 0 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 4 0 0 0 211 16 46 119 6 2 13 0 78 117 108 108 67 111 110 118 101 114 116 101 114 0 0 0 0 0 0 0 0 0 0 0 0 9 0 0 0 0 0 0 0 6 1 10 0 69 68 73 84 83 84 82 69 65 77 0 0 0 0 98 3 0 0 12 0 0 0 0 0 0 0 0 0 0 0 228 55 155 22 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 6 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 31 2 0 0 242 0 0 0 0 0 0 0 241 4 0 0 15 1 0 0 64 19 0 0 210 2 0 0 0 0 0 0 80 13 0 0 194 0 0 0 1 0 0 0 176 19 0 0 64 19 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 5 0 0 0 116 101 120 116 58 194 0 0 0 1 0 0 0 6 1 8 0 82 105 99 104 84 101 120 116 0 0 0 0 146 0 0 0 120 0 0 0 123 92 114 116 102 49 92 97 110 115 105 92 97 110 115 105 99 112 103 49 50 53 50 92 100 101 102 102 48 92 100 101 102 108 97 110 103 50 48 53 55 123 92 102 111 110 116 116 98 108 123 92 102 48 92 102 114 111 109 97 110 32 84 105 109 101 115 32 78 101 119 32 82 111 109 97 110 59 125 125 13 10 92 118 105 101 119 107 105 110 100 52 92 117 99 49 92 112 97 114 100 92 102 48 92 102 115 50 50 32 13 10 92 112 97 114 32 125 13 10 64 19 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 115 101 108 101 99 116 105 111 110 82 97 110 103 101 58 194 0 0 0 1 0 0 0 6 3 8 0 73 110 116 101 114 118 97 108 0 0 0 0 3 0 0 0 1 0 0 0 3 0 0 0 64 19 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 105 115 84 101 120 116 77 111 100 105 102 105 101 100 58 194 0 0 0 1 0 0 0 32 0 0 0 64 19 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 114 101 115 101 116 67 104 97 114 70 111 114 109 97 116 194 0 0 0 0 0 0 0 64 19 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 15 1 0 0 120 2 0 0 150 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 146 0 0 0 6 0 0 0 115 111 117 114 99 101 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 51 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 45 3 0 0 224 7 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 25 0 0 0 120 2 0 0 175 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 128 8 0 0 64 18 0 0 64 19 0 0 16 5 0 0 0 0 0 0 19 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 194 0 0 0 2 0 0 0 16 6 0 0 146 0 0 0 6 0 0 0 115 116 97 116 117 115 0 0 0 0 70 5 7 0 2 0 0 0 77 101 110 117 66 97 114 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 3 0 0 0 226 10 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 5 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 80 11 0 0 146 0 0 0 16 0 0 0 38 65 100 100 32 99 97 116 101 103 111 114 121 46 46 46 1 0 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 160 11 0 0 146 0 0 0 19 0 0 0 38 82 101 110 97 109 101 32 99 97 116 101 103 111 114 121 46 46 46 1 0 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 240 11 0 0 146 0 0 0 16 0 0 0 38 68 101 108 101 116 101 32 99 97 116 101 103 111 114 121 1 0 0 0 0 0 0 0 34 12 0 0 0 0 0 0 1 16 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 96 12 0 0 146 0 0 0 17 0 0 0 38 70 105 110 100 32 99 111 110 115 116 97 110 116 46 46 46 1 0 0 0 0 0 0 0 146 0 0 0 11 0 0 0 38 67 97 116 101 103 111 114 105 101 115 0 0 0 0 226 10 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 7 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 176 14 0 0 146 0 0 0 16 0 0 0 38 78 101 119 32 99 111 110 115 116 97 110 116 46 46 46 1 0 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 0 15 0 0 146 0 0 0 16 0 0 0 38 68 101 108 101 116 101 32 99 111 110 115 116 97 110 116 1 0 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 80 15 0 0 146 0 0 0 14 0 0 0 38 67 97 116 101 103 111 114 105 122 101 46 46 46 1 0 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 160 15 0 0 146 0 0 0 18 0 0 0 67 104 97 110 103 101 32 38 112 97 99 107 97 103 101 46 46 46 1 0 0 0 0 0 0 0 34 12 0 0 0 0 0 0 1 16 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 0 16 0 0 146 0 0 0 18 0 0 0 38 66 114 111 119 115 101 32 114 101 102 101 114 101 110 99 101 115 1 0 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 80 16 0 0 146 0 0 0 25 0 0 0 38 65 100 100 32 114 101 115 111 117 114 99 101 32 100 97 116 97 98 97 115 101 46 46 46 1 0 0 0 0 0 0 0 146 0 0 0 10 0 0 0 67 38 111 110 115 116 97 110 116 115 0 0 0 0 226 10 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 10 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 240 19 0 0 146 0 0 0 7 0 0 0 38 65 99 99 101 112 116 167 32 0 0 0 0 0 0 34 12 0 0 0 0 0 0 1 16 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 80 20 0 0 146 0 0 0 4 0 0 0 67 117 38 116 177 32 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 160 20 0 0 146 0 0 0 5 0 0 0 38 67 111 112 121 135 32 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 240 20 0 0 146 0 0 0 6 0 0 0 38 80 97 115 116 101 173 32 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 64 21 0 0 146 0 0 0 7 0 0 0 68 101 38 108 101 116 101 1 0 0 0 0 0 0 0 176 28 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 144 21 0 0 146 0 0 0 6 0 0 0 38 68 111 32 73 116 139 32 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 224 21 0 0 146 0 0 0 9 0 0 0 80 38 114 105 110 116 32 73 116 137 32 0 0 0 0 0 0 18 11 0 0 0 0 0 0 1 0 0 0 50 11 0 0 0 0 0 0 48 22 0 0 146 0 0 0 11 0 0 0 38 73 110 115 112 101 99 116 32 73 116 147 32 0 0 0 0 0 0 146 0 0 0 7 0 0 0 38 83 111 117 114 99 101 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 3 16 0 65 99 99 101 108 101 114 97 116 111 114 84 97 98 108 101 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 7 0 0 0 6 2 11 0 65 115 115 111 99 105 97 116 105 111 110 0 0 0 0 167 32 0 0 144 28 0 0 98 30 0 0 0 0 0 0 177 32 0 0 208 28 0 0 98 30 0 0 0 0 0 0 135 32 0 0 0 29 0 0 98 30 0 0 0 0 0 0 173 32 0 0 48 29 0 0 98 30 0 0 0 0 0 0 139 32 0 0 144 29 0 0 98 30 0 0 0 0 0 0 137 32 0 0 192 29 0 0 98 30 0 0 0 0 0 0 147 32 0 0 240 29 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 11 0 0 0 11 0 0 0 242 0 0 0 0 0 0 0 1 5 0 0 193 3 0 0 96 0 0 0 210 2 0 0 0 0 0 0 112 23 0 0 194 0 0 0 1 0 0 0 146 0 0 0 17 0 0 0 67 111 110 115 116 97 110 116 115 32 66 114 111 119 115 101 114 96 0 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 8 0 0 0 109 101 110 117 66 97 114 58 194 0 0 0 1 0 0 0 224 25 0 0 96 0 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 5 0 0 0 133 2 0 0 229 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 16 6 0 0 224 7 0 0 48 1 0 0 16 5 0 0 0 0 0 0 19 0 0 0 70 5 4 0 3 0 0 0 73 99 111 110 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 18 1 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 18 1 0 0 7 0 0 0 99 117 114 114 101 110 116 18 1 0 0 13 0 0 0 83 104 101 108 108 86 105 101 119 46 105 99 111 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 18 1 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0])!

(ResourceIdentifier class: PstDebugger name: 'Default view') assign: (Object fromBinaryStoreBytes:
#[33 83 84 66 32 48 32 70 2 12 0 1 0 0 0 86 105 101 119 82 101 115 111 117 114 99 101 0 0 0 0 14 1 36 0 83 84 66 82 101 115 111 117 114 99 101 83 84 66 66 121 116 101 65 114 114 97 121 65 99 99 101 115 115 111 114 80 114 111 120 121 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 129 41 0 0 33 83 84 66 32 48 32 78 8 12 0 10 0 0 0 83 84 66 86 105 101 119 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 146 0 0 0 9 0 0 0 83 104 101 108 108 86 105 101 119 38 0 5 0 65 114 114 97 121 24 0 0 0 0 0 0 0 0 0 0 0 194 0 0 0 2 0 0 0 1 0 158 1 1 0 2 0 96 0 0 0 0 0 0 0 0 0 0 0 6 2 5 0 80 111 105 110 116 0 0 0 0 1 5 0 0 193 3 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 7 12 0 66 111 114 100 101 114 76 97 121 111 117 116 0 0 0 0 1 0 0 0 1 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 13 0 0 0 67 111 110 116 97 105 110 101 114 86 105 101 119 194 0 0 0 15 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 54 0 12 0 76 97 114 103 101 73 110 116 101 103 101 114 4 0 0 0 0 0 0 68 1 0 2 0 48 1 0 0 0 0 0 0 6 1 11 0 83 121 115 116 101 109 67 111 108 111 114 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 3 10 0 70 108 111 119 76 97 121 111 117 116 0 0 0 0 1 0 0 0 1 0 0 0 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 146 0 0 0 4 0 0 0 108 101 102 116 14 2 26 0 83 84 66 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 18 0 0 0 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 194 0 0 0 0 0 0 0 0 0 0 0 6 1 15 0 77 101 115 115 97 103 101 83 101 113 117 101 110 99 101 0 0 0 0 14 2 18 0 83 84 66 67 111 108 108 101 99 116 105 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 79 114 100 101 114 101 100 67 111 108 108 101 99 116 105 111 110 194 0 0 0 1 0 0 0 6 3 11 0 77 101 115 115 97 103 101 83 101 110 100 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 16 0 0 0 99 114 101 97 116 101 65 116 58 101 120 116 101 110 116 58 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 51 0 0 0 48 1 0 0 6 1 15 0 87 73 78 68 79 87 80 76 65 67 69 77 69 78 84 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 120 2 0 0 25 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 4 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 13 0 0 0 82 101 102 101 114 101 110 99 101 86 105 101 119 194 0 0 0 14 0 0 0 0 0 0 0 48 1 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 160 3 0 0 0 0 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 2 18 0 82 101 115 111 117 114 99 101 73 100 101 110 116 105 102 105 101 114 0 0 0 0 122 0 0 0 0 0 0 0 146 0 0 0 3 0 0 0 112 115 116 146 0 0 0 10 0 0 0 80 115 116 84 111 111 108 98 97 114 146 0 0 0 16 0 0 0 80 115 116 73 109 97 103 101 32 84 111 111 108 98 97 114 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 63 0 0 0 51 0 0 0 160 3 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 31 0 0 0 25 0 0 0 194 0 0 0 0 0 0 0 242 0 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 176 3 0 0 194 0 0 0 14 0 0 0 0 0 0 0 48 1 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 32 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18 4 0 0 0 0 0 0 48 4 0 0 146 0 0 0 16 0 0 0 80 115 116 84 111 111 108 115 32 84 111 111 108 98 97 114 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 63 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 247 0 0 0 51 0 0 0 32 5 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 31 0 0 0 0 0 0 0 154 0 0 0 25 0 0 0 0 5 0 0 16 5 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 176 3 0 0 194 0 0 0 14 0 0 0 0 0 0 0 48 1 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 16 6 0 0 0 0 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18 4 0 0 0 0 0 0 48 4 0 0 146 0 0 0 25 0 0 0 80 115 116 87 111 114 107 115 112 97 99 101 84 111 111 108 115 32 84 111 111 108 98 97 114 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 53 1 0 0 1 0 0 0 242 0 0 0 0 0 0 0 155 0 0 0 51 0 0 0 16 6 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 154 0 0 0 0 0 0 0 231 0 0 0 25 0 0 0 0 5 0 0 16 5 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 176 3 0 0 194 0 0 0 14 0 0 0 0 0 0 0 48 1 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 16 7 0 0 0 0 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18 4 0 0 0 0 0 0 48 4 0 0 146 0 0 0 19 0 0 0 80 115 116 68 101 98 117 103 103 101 114 32 84 111 111 108 98 97 114 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 207 1 0 0 1 0 0 0 242 0 0 0 0 0 0 0 155 0 0 0 51 0 0 0 16 7 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 231 0 0 0 0 0 0 0 52 1 0 0 25 0 0 0 0 5 0 0 16 5 0 0 0 0 0 0 19 0 0 0 16 5 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 9 0 0 0 83 116 97 116 117 115 66 97 114 194 0 0 0 18 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 4 1 0 68 1 0 0 0 16 8 0 0 0 0 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 6 4 4 0 70 111 110 116 0 0 0 0 0 0 0 0 16 0 0 0 6 1 7 0 76 79 71 70 79 78 84 0 0 0 0 98 3 0 0 60 0 0 0 243 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 144 1 0 0 0 0 0 0 3 2 1 34 65 114 105 97 108 0 31 5 20 135 63 1 0 0 204 53 63 1 3 0 20 59 0 0 0 0 247 0 5 86 111 1 242 0 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 8 0 0 0 39 2 255 255 0 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 80 2 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 6 4 17 0 83 116 97 116 117 115 66 97 114 78 117 108 108 73 116 101 109 0 0 0 0 1 2 0 0 1 0 0 0 16 8 0 0 0 0 0 0 48 9 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 95 3 0 0 242 0 0 0 0 0 0 0 241 4 0 0 45 0 0 0 16 8 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 175 1 0 0 120 2 0 0 197 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 0 0 0 0 0 0 0 0 90 0 0 0 0 0 0 0 64 1 0 0 194 0 0 0 15 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 224 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 2 18 0 80 114 111 112 111 114 116 105 111 110 97 108 76 97 121 111 117 116 0 0 0 0 26 2 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 11 0 0 0 76 111 111 107 117 112 84 97 98 108 101 194 0 0 0 8 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 8 0 0 0 83 112 108 105 116 116 101 114 194 0 0 0 12 0 0 0 0 0 0 0 224 9 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 0 0 128 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 231 1 0 0 242 0 0 0 0 0 0 0 241 4 0 0 7 0 0 0 128 10 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 243 0 0 0 120 2 0 0 246 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 1 0 0 0 90 0 0 0 0 0 0 0 64 1 0 0 194 0 0 0 15 0 0 0 0 0 0 0 224 9 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 128 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 34 10 0 0 0 0 0 0 26 2 0 0 0 0 0 0 80 10 0 0 194 0 0 0 4 0 0 0 90 0 0 0 0 0 0 0 144 10 0 0 194 0 0 0 12 0 0 0 0 0 0 0 128 11 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 0 0 240 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 79 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 7 0 0 0 240 11 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 39 0 0 0 120 2 0 0 42 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 1 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 12 0 0 0 82 105 99 104 84 101 120 116 69 100 105 116 194 0 0 0 18 0 0 0 0 0 0 0 128 11 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 68 17 33 68 1 4 0 0 208 12 0 0 0 0 0 0 6 3 3 0 82 71 66 0 0 0 0 181 1 0 0 215 1 0 0 209 1 0 0 0 0 0 0 7 0 0 0 70 5 4 0 2 0 0 0 77 101 110 117 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 10 0 0 0 70 2 15 0 1 0 0 0 67 111 109 109 97 110 100 77 101 110 117 73 116 101 109 0 0 0 0 1 0 0 0 70 4 18 0 2 0 0 0 67 111 109 109 97 110 100 68 101 115 99 114 105 112 116 105 111 110 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 6 0 0 0 97 99 99 101 112 116 146 0 0 0 7 0 0 0 38 65 99 99 101 112 116 167 32 0 0 0 0 0 0 70 1 15 0 1 0 0 0 68 105 118 105 100 101 114 77 101 110 117 73 116 101 109 0 0 0 0 1 16 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 12 0 0 0 99 117 116 83 101 108 101 99 116 105 111 110 146 0 0 0 4 0 0 0 67 117 38 116 177 32 0 0 0 0 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 13 0 0 0 99 111 112 121 83 101 108 101 99 116 105 111 110 146 0 0 0 5 0 0 0 38 67 111 112 121 135 32 0 0 0 0 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 14 0 0 0 112 97 115 116 101 67 108 105 112 98 111 97 114 100 146 0 0 0 6 0 0 0 38 80 97 115 116 101 173 32 0 0 0 0 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 14 0 0 0 99 108 101 97 114 83 101 108 101 99 116 105 111 110 146 0 0 0 7 0 0 0 68 101 38 108 101 116 101 93 2 0 0 0 0 0 0 0 14 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 4 0 0 0 100 111 73 116 146 0 0 0 6 0 0 0 38 68 111 32 105 116 139 32 0 0 0 0 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 7 0 0 0 112 114 105 110 116 73 116 146 0 0 0 9 0 0 0 80 38 114 105 110 116 32 105 116 137 32 0 0 0 0 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 9 0 0 0 105 110 115 112 101 99 116 73 116 146 0 0 0 11 0 0 0 38 73 110 115 112 101 99 116 32 105 116 147 32 0 0 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 4 0 0 0 211 16 46 119 6 2 13 0 78 117 108 108 67 111 110 118 101 114 116 101 114 0 0 0 0 0 0 0 0 0 0 0 0 9 0 0 0 0 0 0 0 6 1 10 0 69 68 73 84 83 84 82 69 65 77 0 0 0 0 98 3 0 0 12 0 0 0 0 0 0 0 0 0 0 0 244 185 113 12 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 6 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 85 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 237 0 0 0 208 12 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 12 0 0 0 99 111 110 116 101 120 116 77 101 110 117 58 194 0 0 0 1 0 0 0 96 13 0 0 208 12 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 5 0 0 0 116 101 120 116 58 194 0 0 0 1 0 0 0 6 1 8 0 82 105 99 104 84 101 120 116 0 0 0 0 146 0 0 0 120 0 0 0 123 92 114 116 102 49 92 97 110 115 105 92 97 110 115 105 99 112 103 49 50 53 50 92 100 101 102 102 48 92 100 101 102 108 97 110 103 50 48 53 55 123 92 102 111 110 116 116 98 108 123 92 102 48 92 102 114 111 109 97 110 32 84 105 109 101 115 32 78 101 119 32 82 111 109 97 110 59 125 125 13 10 92 118 105 101 119 107 105 110 100 52 92 117 99 49 92 112 97 114 100 92 102 48 92 102 115 50 50 32 13 10 92 112 97 114 32 125 13 10 208 12 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 115 101 108 101 99 116 105 111 110 82 97 110 103 101 58 194 0 0 0 1 0 0 0 6 3 8 0 73 110 116 101 114 118 97 108 0 0 0 0 3 0 0 0 1 0 0 0 3 0 0 0 208 12 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 105 115 84 101 120 116 77 111 100 105 102 105 101 100 58 194 0 0 0 1 0 0 0 32 0 0 0 208 12 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 114 101 115 101 116 67 104 97 114 70 111 114 109 97 116 194 0 0 0 0 0 0 0 208 12 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 42 0 0 0 120 2 0 0 160 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 7 0 0 0 16 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 194 0 0 0 2 0 0 0 208 12 0 0 146 0 0 0 10 0 0 0 115 111 117 114 99 101 67 111 100 101 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 237 1 0 0 242 0 0 0 0 0 0 0 241 4 0 0 65 1 0 0 128 11 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 246 0 0 0 120 2 0 0 150 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 90 0 0 0 0 0 0 0 64 1 0 0 194 0 0 0 15 0 0 0 0 0 0 0 128 11 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 192 19 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 34 10 0 0 0 0 0 0 26 2 0 0 0 0 0 0 80 10 0 0 80 2 0 0 32 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 194 0 0 0 4 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 10 0 0 0 80 117 115 104 66 117 116 116 111 110 194 0 0 0 17 0 0 0 0 0 0 0 192 19 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 32 1 68 1 0 0 0 64 20 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 4 0 0 0 46 162 226 119 162 13 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 10 0 0 0 115 105 110 103 108 101 83 116 101 112 146 0 0 0 4 0 0 0 115 116 101 112 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 2 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 165 1 0 0 79 0 0 0 64 20 0 0 210 2 0 0 0 0 0 0 112 17 0 0 194 0 0 0 1 0 0 0 146 0 0 0 4 0 0 0 115 116 101 112 64 20 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 210 0 0 0 39 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 146 0 0 0 4 0 0 0 115 116 101 112 90 0 0 0 0 0 0 0 80 20 0 0 194 0 0 0 17 0 0 0 0 0 0 0 192 19 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 32 1 68 1 0 0 0 208 21 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 4 0 0 0 46 162 226 119 162 13 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 8 0 0 0 115 116 101 112 73 110 116 111 146 0 0 0 4 0 0 0 105 110 116 111 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 2 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 165 1 0 0 1 0 0 0 242 0 0 0 0 0 0 0 165 1 0 0 79 0 0 0 208 21 0 0 210 2 0 0 0 0 0 0 112 17 0 0 194 0 0 0 1 0 0 0 146 0 0 0 4 0 0 0 105 110 116 111 208 21 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 210 0 0 0 0 0 0 0 164 1 0 0 39 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 146 0 0 0 4 0 0 0 105 110 116 111 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 79 0 0 0 192 19 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 120 2 0 0 39 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 64 20 0 0 208 21 0 0 90 0 0 0 0 0 0 0 80 20 0 0 194 0 0 0 17 0 0 0 0 0 0 0 192 19 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 32 1 68 1 0 0 0 240 23 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 4 0 0 0 46 162 226 119 162 13 0 0 0 0 0 0 0 0 0 0 146 0 0 0 6 0 0 0 114 101 115 117 109 101 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 2 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 73 3 0 0 1 0 0 0 242 0 0 0 0 0 0 0 169 1 0 0 79 0 0 0 240 23 0 0 210 2 0 0 0 0 0 0 112 17 0 0 194 0 0 0 1 0 0 0 146 0 0 0 6 0 0 0 114 101 115 117 109 101 240 23 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 164 1 0 0 0 0 0 0 120 2 0 0 39 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 16 5 0 0 0 0 0 0 19 0 0 0 240 11 0 0 208 12 0 0 16 5 0 0 0 0 0 0 19 0 0 0 5 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 7 0 0 0 76 105 115 116 66 111 120 194 0 0 0 17 0 0 0 0 0 0 0 224 9 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 1 1 49 68 1 4 0 0 48 25 0 0 70 3 9 0 2 0 0 0 76 105 115 116 77 111 100 101 108 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 0 0 0 0 6 0 20 0 73 100 101 110 116 105 116 121 83 101 97 114 99 104 80 111 108 105 99 121 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 4 0 0 0 244 100 227 119 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 66 97 115 105 99 76 105 115 116 65 98 115 116 114 97 99 116 1 0 0 0 32 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 2 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 65 1 0 0 48 25 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 17 0 0 0 104 111 114 105 122 111 110 116 97 108 69 120 116 101 110 116 58 194 0 0 0 1 0 0 0 1 0 0 0 48 25 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 120 2 0 0 160 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 5 0 0 0 90 0 0 0 0 0 0 0 144 10 0 0 194 0 0 0 12 0 0 0 0 0 0 0 224 9 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 0 0 240 26 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 65 1 0 0 242 0 0 0 0 0 0 0 241 4 0 0 7 0 0 0 240 26 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 160 0 0 0 120 2 0 0 163 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 1 0 0 0 16 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 194 0 0 0 2 0 0 0 48 25 0 0 146 0 0 0 11 0 0 0 99 111 110 116 101 120 116 76 105 115 116 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 51 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 45 3 0 0 224 9 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 25 0 0 0 120 2 0 0 175 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 5 0 0 0 48 25 0 0 240 26 0 0 90 0 0 0 0 0 0 0 64 1 0 0 194 0 0 0 15 0 0 0 0 0 0 0 224 9 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 176 28 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 34 10 0 0 0 0 0 0 26 2 0 0 0 0 0 0 80 10 0 0 194 0 0 0 2 0 0 0 90 0 0 0 0 0 0 0 144 10 0 0 194 0 0 0 12 0 0 0 0 0 0 0 176 28 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 0 0 32 29 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 117 2 0 0 1 0 0 0 242 0 0 0 0 0 0 0 7 0 0 0 161 0 0 0 32 29 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 58 1 0 0 0 0 0 0 61 1 0 0 80 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 1 0 0 0 32 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 194 0 0 0 4 0 0 0 90 0 0 0 0 0 0 0 64 25 0 0 194 0 0 0 17 0 0 0 0 0 0 0 176 28 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 1 1 49 68 1 4 0 0 32 30 0 0 146 25 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 0 0 0 0 208 25 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 4 0 0 0 244 100 227 119 240 25 0 0 1 0 0 0 32 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 2 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 117 2 0 0 161 0 0 0 32 30 0 0 210 2 0 0 0 0 0 0 144 26 0 0 194 0 0 0 1 0 0 0 1 0 0 0 32 30 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 58 1 0 0 80 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 146 0 0 0 14 0 0 0 108 111 99 97 108 70 105 101 108 100 76 105 115 116 90 0 0 0 0 0 0 0 224 12 0 0 194 0 0 0 18 0 0 0 0 0 0 0 176 28 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 68 17 33 68 1 4 0 0 96 31 0 0 0 0 0 0 50 13 0 0 0 0 0 0 181 1 0 0 215 1 0 0 209 1 0 0 0 0 0 0 7 0 0 0 82 13 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 10 0 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 192 13 0 0 146 0 0 0 7 0 0 0 38 65 99 99 101 112 116 167 32 0 0 0 0 0 0 242 13 0 0 0 0 0 0 1 16 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 48 14 0 0 146 0 0 0 4 0 0 0 67 117 38 116 177 32 0 0 0 0 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 128 14 0 0 146 0 0 0 5 0 0 0 38 67 111 112 121 135 32 0 0 0 0 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 208 14 0 0 146 0 0 0 6 0 0 0 38 80 97 115 116 101 173 32 0 0 0 0 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 32 15 0 0 146 0 0 0 7 0 0 0 68 101 38 108 101 116 101 93 2 0 0 0 0 0 0 0 32 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 112 15 0 0 146 0 0 0 6 0 0 0 38 68 111 32 105 116 139 32 0 0 0 0 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 192 15 0 0 146 0 0 0 9 0 0 0 80 38 114 105 110 116 32 105 116 137 32 0 0 0 0 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 16 16 0 0 146 0 0 0 11 0 0 0 38 73 110 115 112 101 99 116 32 105 116 147 32 0 0 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 4 0 0 0 211 16 46 119 98 16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 9 0 0 0 0 0 0 0 130 16 0 0 0 0 0 0 98 3 0 0 12 0 0 0 0 0 0 0 0 0 0 0 188 21 229 8 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 6 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 123 2 0 0 1 0 0 0 242 0 0 0 0 0 0 0 119 2 0 0 161 0 0 0 96 31 0 0 210 2 0 0 0 0 0 0 48 17 0 0 194 0 0 0 1 0 0 0 176 31 0 0 96 31 0 0 210 2 0 0 0 0 0 0 112 17 0 0 194 0 0 0 1 0 0 0 162 17 0 0 0 0 0 0 146 0 0 0 120 0 0 0 123 92 114 116 102 49 92 97 110 115 105 92 97 110 115 105 99 112 103 49 50 53 50 92 100 101 102 102 48 92 100 101 102 108 97 110 103 50 48 53 55 123 92 102 111 110 116 116 98 108 123 92 102 48 92 102 114 111 109 97 110 32 84 105 109 101 115 32 78 101 119 32 82 111 109 97 110 59 125 125 13 10 92 118 105 101 119 107 105 110 100 52 92 117 99 49 92 112 97 114 100 92 102 48 92 102 115 50 50 32 13 10 92 112 97 114 32 125 13 10 96 31 0 0 210 2 0 0 0 0 0 0 224 17 0 0 194 0 0 0 1 0 0 0 18 18 0 0 0 0 0 0 3 0 0 0 1 0 0 0 3 0 0 0 96 31 0 0 210 2 0 0 0 0 0 0 64 18 0 0 194 0 0 0 1 0 0 0 32 0 0 0 96 31 0 0 210 2 0 0 0 0 0 0 128 18 0 0 160 18 0 0 96 31 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 61 1 0 0 0 0 0 0 120 2 0 0 80 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 146 0 0 0 16 0 0 0 108 111 99 97 108 70 105 101 108 100 83 111 117 114 99 101 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 71 1 0 0 242 0 0 0 0 0 0 0 241 4 0 0 161 0 0 0 176 28 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 163 0 0 0 120 2 0 0 243 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 32 30 0 0 32 29 0 0 96 31 0 0 16 5 0 0 0 0 0 0 19 0 0 0 128 10 0 0 128 11 0 0 16 5 0 0 0 0 0 0 19 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 80 2 0 0 0 0 0 0 70 5 7 0 2 0 0 0 77 101 110 117 66 97 114 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 1 0 0 0 82 13 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 10 0 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 192 13 0 0 146 0 0 0 7 0 0 0 38 65 99 99 101 112 116 167 32 0 0 0 0 0 0 242 13 0 0 0 0 0 0 1 16 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 48 14 0 0 146 0 0 0 4 0 0 0 67 117 38 116 177 32 0 0 0 0 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 128 14 0 0 146 0 0 0 5 0 0 0 38 67 111 112 121 135 32 0 0 0 0 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 208 14 0 0 146 0 0 0 6 0 0 0 38 80 97 115 116 101 173 32 0 0 0 0 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 32 15 0 0 146 0 0 0 7 0 0 0 68 101 38 108 101 116 101 1 0 0 0 0 0 0 0 96 36 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 112 15 0 0 146 0 0 0 6 0 0 0 38 68 111 32 73 116 139 32 0 0 0 0 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 192 15 0 0 146 0 0 0 9 0 0 0 80 38 114 105 110 116 32 73 116 137 32 0 0 0 0 0 0 130 13 0 0 0 0 0 0 1 0 0 0 162 13 0 0 0 0 0 0 16 16 0 0 146 0 0 0 11 0 0 0 38 73 110 115 112 101 99 116 32 73 116 147 32 0 0 0 0 0 0 146 0 0 0 7 0 0 0 38 83 111 117 114 99 101 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 3 16 0 65 99 99 101 108 101 114 97 116 111 114 84 97 98 108 101 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 7 0 0 0 6 2 11 0 65 115 115 111 99 105 97 116 105 111 110 0 0 0 0 167 32 0 0 64 36 0 0 18 38 0 0 0 0 0 0 177 32 0 0 128 36 0 0 18 38 0 0 0 0 0 0 135 32 0 0 176 36 0 0 18 38 0 0 0 0 0 0 173 32 0 0 224 36 0 0 18 38 0 0 0 0 0 0 139 32 0 0 64 37 0 0 18 38 0 0 0 0 0 0 137 32 0 0 112 37 0 0 18 38 0 0 0 0 0 0 147 32 0 0 160 37 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 11 0 0 0 11 0 0 0 242 0 0 0 0 0 0 0 1 5 0 0 193 3 0 0 96 0 0 0 210 2 0 0 0 0 0 0 112 17 0 0 194 0 0 0 1 0 0 0 146 0 0 0 8 0 0 0 68 101 98 117 103 103 101 114 96 0 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 8 0 0 0 109 101 110 117 66 97 114 58 194 0 0 0 1 0 0 0 240 35 0 0 96 0 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 5 0 0 0 133 2 0 0 229 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 16 8 0 0 224 9 0 0 48 1 0 0 16 5 0 0 0 0 0 0 19 0 0 0 70 5 4 0 3 0 0 0 73 99 111 110 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 18 1 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 18 1 0 0 7 0 0 0 99 117 114 114 101 110 116 18 1 0 0 13 0 0 0 83 104 101 108 108 86 105 101 119 46 105 99 111 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 18 1 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0])!

(ResourceIdentifier class: PstInspector name: 'Default view') assign: (Object fromBinaryStoreBytes:
#[33 83 84 66 32 48 32 70 2 12 0 1 0 0 0 86 105 101 119 82 101 115 111 117 114 99 101 0 0 0 0 14 1 36 0 83 84 66 82 101 115 111 117 114 99 101 83 84 66 66 121 116 101 65 114 114 97 121 65 99 99 101 115 115 111 114 80 114 111 120 121 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 46 25 0 0 33 83 84 66 32 48 32 78 8 12 0 10 0 0 0 83 84 66 86 105 101 119 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 146 0 0 0 9 0 0 0 83 104 101 108 108 86 105 101 119 38 0 5 0 65 114 114 97 121 24 0 0 0 0 0 0 0 0 0 0 0 194 0 0 0 2 0 0 0 1 0 158 1 1 0 2 0 96 0 0 0 0 0 0 0 0 0 0 0 6 2 5 0 80 111 105 110 116 0 0 0 0 1 5 0 0 193 3 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 7 12 0 66 111 114 100 101 114 76 97 121 111 117 116 0 0 0 0 1 0 0 0 1 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 13 0 0 0 67 111 110 116 97 105 110 101 114 86 105 101 119 194 0 0 0 15 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 54 0 12 0 76 97 114 103 101 73 110 116 101 103 101 114 4 0 0 0 0 0 0 68 1 0 2 0 48 1 0 0 0 0 0 0 6 1 11 0 83 121 115 116 101 109 67 111 108 111 114 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 3 10 0 70 108 111 119 76 97 121 111 117 116 0 0 0 0 1 0 0 0 1 0 0 0 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 146 0 0 0 4 0 0 0 108 101 102 116 14 2 26 0 83 84 66 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 18 0 0 0 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 194 0 0 0 0 0 0 0 0 0 0 0 6 1 15 0 77 101 115 115 97 103 101 83 101 113 117 101 110 99 101 0 0 0 0 14 2 18 0 83 84 66 67 111 108 108 101 99 116 105 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 79 114 100 101 114 101 100 67 111 108 108 101 99 116 105 111 110 194 0 0 0 1 0 0 0 6 3 11 0 77 101 115 115 97 103 101 83 101 110 100 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 16 0 0 0 99 114 101 97 116 101 65 116 58 101 120 116 101 110 116 58 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 51 0 0 0 48 1 0 0 6 1 15 0 87 73 78 68 79 87 80 76 65 67 69 77 69 78 84 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 120 2 0 0 25 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 13 0 0 0 82 101 102 101 114 101 110 99 101 86 105 101 119 194 0 0 0 14 0 0 0 0 0 0 0 48 1 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 160 3 0 0 0 0 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 2 18 0 82 101 115 111 117 114 99 101 73 100 101 110 116 105 102 105 101 114 0 0 0 0 122 0 0 0 0 0 0 0 146 0 0 0 3 0 0 0 112 115 116 146 0 0 0 10 0 0 0 80 115 116 84 111 111 108 98 97 114 146 0 0 0 16 0 0 0 80 115 116 73 109 97 103 101 32 84 111 111 108 98 97 114 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 63 0 0 0 51 0 0 0 160 3 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 31 0 0 0 25 0 0 0 194 0 0 0 0 0 0 0 242 0 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 176 3 0 0 194 0 0 0 14 0 0 0 0 0 0 0 48 1 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 32 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18 4 0 0 0 0 0 0 48 4 0 0 146 0 0 0 16 0 0 0 80 115 116 84 111 111 108 115 32 84 111 111 108 98 97 114 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 63 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 247 0 0 0 51 0 0 0 32 5 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 31 0 0 0 0 0 0 0 154 0 0 0 25 0 0 0 0 5 0 0 16 5 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 176 3 0 0 194 0 0 0 14 0 0 0 0 0 0 0 48 1 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 16 6 0 0 0 0 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18 4 0 0 0 0 0 0 48 4 0 0 146 0 0 0 25 0 0 0 80 115 116 87 111 114 107 115 112 97 99 101 84 111 111 108 115 32 84 111 111 108 98 97 114 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 53 1 0 0 1 0 0 0 242 0 0 0 0 0 0 0 155 0 0 0 51 0 0 0 16 6 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 154 0 0 0 0 0 0 0 231 0 0 0 25 0 0 0 0 5 0 0 16 5 0 0 0 0 0 0 19 0 0 0 16 5 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 9 0 0 0 83 116 97 116 117 115 66 97 114 194 0 0 0 18 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 4 1 0 68 1 0 0 0 16 7 0 0 0 0 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 6 4 4 0 70 111 110 116 0 0 0 0 0 0 0 0 16 0 0 0 6 1 7 0 76 79 71 70 79 78 84 0 0 0 0 98 3 0 0 60 0 0 0 243 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 144 1 0 0 0 0 0 0 3 2 1 34 65 114 105 97 108 0 31 5 20 135 63 1 0 0 204 53 63 1 3 0 20 59 0 0 0 0 247 0 5 86 111 1 242 0 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 8 0 0 0 39 2 255 255 0 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 80 2 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 6 4 17 0 83 116 97 116 117 115 66 97 114 78 117 108 108 73 116 101 109 0 0 0 0 1 2 0 0 1 0 0 0 16 7 0 0 0 0 0 0 48 8 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 95 3 0 0 242 0 0 0 0 0 0 0 241 4 0 0 45 0 0 0 16 7 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 175 1 0 0 120 2 0 0 197 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 0 0 0 0 0 0 0 0 90 0 0 0 0 0 0 0 64 1 0 0 194 0 0 0 15 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 224 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 2 18 0 80 114 111 112 111 114 116 105 111 110 97 108 76 97 121 111 117 116 0 0 0 0 26 2 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 11 0 0 0 76 111 111 107 117 112 84 97 98 108 101 194 0 0 0 2 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 8 0 0 0 83 112 108 105 116 116 101 114 194 0 0 0 12 0 0 0 0 0 0 0 224 8 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 0 0 128 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 117 2 0 0 1 0 0 0 242 0 0 0 0 0 0 0 7 0 0 0 45 3 0 0 128 9 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 58 1 0 0 0 0 0 0 61 1 0 0 150 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 1 0 0 0 32 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 194 0 0 0 4 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 7 0 0 0 76 105 115 116 66 111 120 194 0 0 0 17 0 0 0 0 0 0 0 224 8 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 1 1 49 68 1 4 0 0 160 10 0 0 70 3 9 0 2 0 0 0 76 105 115 116 77 111 100 101 108 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 0 0 0 0 6 0 20 0 73 100 101 110 116 105 116 121 83 101 97 114 99 104 80 111 108 105 99 121 0 0 0 0 6 3 3 0 82 71 66 0 0 0 0 221 1 0 0 255 1 0 0 205 1 0 0 0 0 0 0 7 0 0 0 70 5 4 0 2 0 0 0 77 101 110 117 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 7 0 0 0 70 2 15 0 1 0 0 0 67 111 109 109 97 110 100 77 101 110 117 73 116 101 109 0 0 0 0 1 0 0 0 70 4 18 0 2 0 0 0 67 111 109 109 97 110 100 68 101 115 99 114 105 112 116 105 111 110 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 10 0 0 0 112 111 112 73 110 115 112 101 99 116 146 0 0 0 4 0 0 0 38 80 111 112 1 0 0 0 0 0 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 13 0 0 0 110 101 115 116 101 100 73 110 115 112 101 99 116 146 0 0 0 8 0 0 0 38 73 110 115 112 101 99 116 1 0 0 0 0 0 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 10 0 0 0 116 111 84 111 112 76 101 118 101 108 146 0 0 0 13 0 0 0 38 84 111 32 116 111 112 32 108 101 118 101 108 1 0 0 0 0 0 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 7 0 0 0 99 117 114 116 97 105 108 146 0 0 0 8 0 0 0 38 67 117 114 116 97 105 108 1 0 0 0 0 0 0 0 70 1 15 0 1 0 0 0 68 105 118 105 100 101 114 77 101 110 117 73 116 101 109 0 0 0 0 1 16 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 14 0 0 0 115 112 97 119 110 73 110 115 112 101 99 116 111 114 146 0 0 0 6 0 0 0 38 83 112 97 119 110 1 0 0 0 0 0 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 9 0 0 0 117 112 100 97 116 101 65 108 108 146 0 0 0 8 0 0 0 38 82 101 102 114 101 115 104 1 0 0 0 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 4 0 0 0 244 100 227 119 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 66 97 115 105 99 76 105 115 116 65 98 115 116 114 97 99 116 1 0 0 0 32 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 117 2 0 0 45 3 0 0 160 10 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 12 0 0 0 99 111 110 116 101 120 116 77 101 110 117 58 194 0 0 0 1 0 0 0 128 11 0 0 160 10 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 17 0 0 0 104 111 114 105 122 111 110 116 97 108 69 120 116 101 110 116 58 194 0 0 0 1 0 0 0 1 0 0 0 160 10 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 58 1 0 0 150 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 146 0 0 0 9 0 0 0 102 105 101 108 100 76 105 115 116 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 12 0 0 0 82 105 99 104 84 101 120 116 69 100 105 116 194 0 0 0 18 0 0 0 0 0 0 0 224 8 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 68 17 33 68 1 4 0 0 48 15 0 0 0 0 0 0 82 11 0 0 0 0 0 0 181 1 0 0 215 1 0 0 209 1 0 0 0 0 0 0 7 0 0 0 114 11 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 10 0 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 6 0 0 0 97 99 99 101 112 116 146 0 0 0 7 0 0 0 38 65 99 99 101 112 116 167 32 0 0 0 0 0 0 2 13 0 0 0 0 0 0 1 16 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 12 0 0 0 99 117 116 83 101 108 101 99 116 105 111 110 146 0 0 0 4 0 0 0 67 117 38 116 177 32 0 0 0 0 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 13 0 0 0 99 111 112 121 83 101 108 101 99 116 105 111 110 146 0 0 0 5 0 0 0 38 67 111 112 121 135 32 0 0 0 0 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 14 0 0 0 112 97 115 116 101 67 108 105 112 98 111 97 114 100 146 0 0 0 6 0 0 0 38 80 97 115 116 101 173 32 0 0 0 0 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 14 0 0 0 99 108 101 97 114 83 101 108 101 99 116 105 111 110 146 0 0 0 7 0 0 0 68 101 38 108 101 116 101 93 2 0 0 0 0 0 0 16 16 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 4 0 0 0 100 111 73 116 146 0 0 0 6 0 0 0 38 68 111 32 105 116 139 32 0 0 0 0 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 7 0 0 0 112 114 105 110 116 73 116 146 0 0 0 9 0 0 0 80 38 114 105 110 116 32 105 116 137 32 0 0 0 0 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 9 0 0 0 105 110 115 112 101 99 116 73 116 146 0 0 0 11 0 0 0 38 73 110 115 112 101 99 116 32 105 116 147 32 0 0 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 4 0 0 0 211 16 46 119 6 2 13 0 78 117 108 108 67 111 110 118 101 114 116 101 114 0 0 0 0 0 0 0 0 0 0 0 0 9 0 0 0 0 0 0 0 6 1 10 0 69 68 73 84 83 84 82 69 65 77 0 0 0 0 98 3 0 0 12 0 0 0 0 0 0 0 0 0 0 0 164 104 233 8 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 6 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 123 2 0 0 1 0 0 0 242 0 0 0 0 0 0 0 119 2 0 0 45 3 0 0 48 15 0 0 210 2 0 0 0 0 0 0 128 14 0 0 194 0 0 0 1 0 0 0 160 15 0 0 48 15 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 5 0 0 0 116 101 120 116 58 194 0 0 0 1 0 0 0 6 1 8 0 82 105 99 104 84 101 120 116 0 0 0 0 146 0 0 0 120 0 0 0 123 92 114 116 102 49 92 97 110 115 105 92 97 110 115 105 99 112 103 49 50 53 50 92 100 101 102 102 48 92 100 101 102 108 97 110 103 50 48 53 55 123 92 102 111 110 116 116 98 108 123 92 102 48 92 102 114 111 109 97 110 32 84 105 109 101 115 32 78 101 119 32 82 111 109 97 110 59 125 125 13 10 92 118 105 101 119 107 105 110 100 52 92 117 99 49 92 112 97 114 100 92 102 48 92 102 115 50 50 32 13 10 92 112 97 114 32 125 13 10 48 15 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 115 101 108 101 99 116 105 111 110 82 97 110 103 101 58 194 0 0 0 1 0 0 0 6 3 8 0 73 110 116 101 114 118 97 108 0 0 0 0 3 0 0 0 1 0 0 0 3 0 0 0 48 15 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 105 115 84 101 120 116 77 111 100 105 102 105 101 100 58 194 0 0 0 1 0 0 0 32 0 0 0 48 15 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 114 101 115 101 116 67 104 97 114 70 111 114 109 97 116 194 0 0 0 0 0 0 0 48 15 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 61 1 0 0 0 0 0 0 120 2 0 0 150 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 146 0 0 0 10 0 0 0 115 111 117 114 99 101 67 111 100 101 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 51 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 45 3 0 0 224 8 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 25 0 0 0 120 2 0 0 175 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 160 10 0 0 128 9 0 0 48 15 0 0 16 5 0 0 0 0 0 0 19 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 80 2 0 0 0 0 0 0 70 5 7 0 2 0 0 0 77 101 110 117 66 97 114 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 1 0 0 0 114 11 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 10 0 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 224 15 0 0 146 0 0 0 7 0 0 0 38 65 99 99 101 112 116 167 32 0 0 0 0 0 0 2 13 0 0 0 0 0 0 1 16 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 64 16 0 0 146 0 0 0 4 0 0 0 67 117 38 116 177 32 0 0 0 0 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 144 16 0 0 146 0 0 0 5 0 0 0 38 67 111 112 121 135 32 0 0 0 0 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 224 16 0 0 146 0 0 0 6 0 0 0 38 80 97 115 116 101 173 32 0 0 0 0 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 48 17 0 0 146 0 0 0 7 0 0 0 68 101 38 108 101 116 101 1 0 0 0 0 0 0 0 32 22 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 128 17 0 0 146 0 0 0 6 0 0 0 38 68 111 32 73 116 139 32 0 0 0 0 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 208 17 0 0 146 0 0 0 9 0 0 0 80 38 114 105 110 116 32 73 116 137 32 0 0 0 0 0 0 162 11 0 0 0 0 0 0 1 0 0 0 194 11 0 0 0 0 0 0 32 18 0 0 146 0 0 0 11 0 0 0 38 73 110 115 112 101 99 116 32 73 116 147 32 0 0 0 0 0 0 146 0 0 0 7 0 0 0 38 83 111 117 114 99 101 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 3 16 0 65 99 99 101 108 101 114 97 116 111 114 84 97 98 108 101 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 7 0 0 0 6 2 11 0 65 115 115 111 99 105 97 116 105 111 110 0 0 0 0 167 32 0 0 0 22 0 0 210 23 0 0 0 0 0 0 177 32 0 0 64 22 0 0 210 23 0 0 0 0 0 0 135 32 0 0 112 22 0 0 210 23 0 0 0 0 0 0 173 32 0 0 160 22 0 0 210 23 0 0 0 0 0 0 139 32 0 0 0 23 0 0 210 23 0 0 0 0 0 0 137 32 0 0 48 23 0 0 210 23 0 0 0 0 0 0 147 32 0 0 96 23 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 11 0 0 0 11 0 0 0 242 0 0 0 0 0 0 0 1 5 0 0 193 3 0 0 96 0 0 0 210 2 0 0 0 0 0 0 96 19 0 0 194 0 0 0 1 0 0 0 146 0 0 0 9 0 0 0 73 110 115 112 101 99 116 111 114 96 0 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 8 0 0 0 109 101 110 117 66 97 114 58 194 0 0 0 1 0 0 0 176 21 0 0 96 0 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 5 0 0 0 133 2 0 0 229 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 16 7 0 0 224 8 0 0 48 1 0 0 16 5 0 0 0 0 0 0 19 0 0 0 70 5 4 0 3 0 0 0 73 99 111 110 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 18 1 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 18 1 0 0 7 0 0 0 99 117 114 114 101 110 116 18 1 0 0 13 0 0 0 83 104 101 108 108 86 105 101 119 46 105 99 111 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 18 1 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0])!

(ResourceIdentifier class: PstLauncher name: 'Default view') assign: (Object fromBinaryStoreBytes:
#[33 83 84 66 32 48 32 70 2 12 0 1 0 0 0 86 105 101 119 82 101 115 111 117 114 99 101 0 0 0 0 14 1 36 0 83 84 66 82 101 115 111 117 114 99 101 83 84 66 66 121 116 101 65 114 114 97 121 65 99 99 101 115 115 111 114 80 114 111 120 121 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 106 19 0 0 33 83 84 66 32 48 32 78 8 12 0 10 0 0 0 83 84 66 86 105 101 119 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 146 0 0 0 9 0 0 0 83 104 101 108 108 86 105 101 119 38 0 5 0 65 114 114 97 121 24 0 0 0 0 0 0 0 0 0 0 0 194 0 0 0 2 0 0 0 1 0 158 1 1 0 2 0 96 0 0 0 0 0 0 0 6 3 3 0 82 71 66 0 0 0 0 129 1 0 0 129 1 0 0 129 1 0 0 6 2 5 0 80 111 105 110 116 0 0 0 0 59 2 0 0 111 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 7 12 0 66 111 114 100 101 114 76 97 121 111 117 116 0 0 0 0 1 0 0 0 1 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 13 0 0 0 67 111 110 116 97 105 110 101 114 86 105 101 119 194 0 0 0 15 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 54 0 12 0 76 97 114 103 101 73 110 116 101 103 101 114 4 0 0 0 0 0 0 68 1 0 2 0 80 1 0 0 0 0 0 0 6 1 11 0 83 121 115 116 101 109 67 111 108 111 114 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 3 10 0 70 108 111 119 76 97 121 111 117 116 0 0 0 0 1 0 0 0 1 0 0 0 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 146 0 0 0 4 0 0 0 108 101 102 116 14 2 26 0 83 84 66 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 18 0 0 0 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 194 0 0 0 0 0 0 0 0 0 0 0 6 1 15 0 77 101 115 115 97 103 101 83 101 113 117 101 110 99 101 0 0 0 0 14 2 18 0 83 84 66 67 111 108 108 101 99 116 105 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 79 114 100 101 114 101 100 67 111 108 108 101 99 116 105 111 110 194 0 0 0 1 0 0 0 6 3 11 0 77 101 115 115 97 103 101 83 101 110 100 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 16 0 0 0 99 114 101 97 116 101 65 116 58 101 120 116 101 110 116 58 194 0 0 0 2 0 0 0 18 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 18 1 0 0 0 0 0 0 43 2 0 0 51 0 0 0 80 1 0 0 6 1 15 0 87 73 78 68 79 87 80 76 65 67 69 77 69 78 84 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 21 1 0 0 25 0 0 0 170 2 0 0 0 0 0 0 192 2 0 0 194 0 0 0 3 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 13 0 0 0 82 101 102 101 114 101 110 99 101 86 105 101 119 194 0 0 0 14 0 0 0 0 0 0 0 80 1 0 0 194 0 0 0 2 0 0 0 162 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 192 3 0 0 0 0 0 0 194 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 2 18 0 82 101 115 111 117 114 99 101 73 100 101 110 116 105 102 105 101 114 0 0 0 0 122 0 0 0 0 0 0 0 146 0 0 0 3 0 0 0 112 115 116 146 0 0 0 10 0 0 0 80 115 116 84 111 111 108 98 97 114 146 0 0 0 16 0 0 0 80 115 116 73 109 97 103 101 32 84 111 111 108 98 97 114 0 0 0 0 130 2 0 0 0 0 0 0 170 2 0 0 0 0 0 0 192 2 0 0 194 0 0 0 1 0 0 0 242 2 0 0 0 0 0 0 16 3 0 0 194 0 0 0 2 0 0 0 18 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 18 1 0 0 0 0 0 0 63 0 0 0 51 0 0 0 192 3 0 0 98 3 0 0 0 0 0 0 130 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 31 0 0 0 25 0 0 0 194 0 0 0 0 0 0 0 18 1 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 208 3 0 0 194 0 0 0 14 0 0 0 0 0 0 0 80 1 0 0 194 0 0 0 2 0 0 0 162 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 64 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 50 4 0 0 0 0 0 0 80 4 0 0 146 0 0 0 16 0 0 0 80 115 116 84 111 111 108 115 32 84 111 111 108 98 97 114 0 0 0 0 130 2 0 0 0 0 0 0 170 2 0 0 0 0 0 0 192 2 0 0 194 0 0 0 1 0 0 0 242 2 0 0 0 0 0 0 16 3 0 0 194 0 0 0 2 0 0 0 18 1 0 0 0 0 0 0 63 0 0 0 1 0 0 0 18 1 0 0 0 0 0 0 247 0 0 0 51 0 0 0 64 5 0 0 98 3 0 0 0 0 0 0 130 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 31 0 0 0 0 0 0 0 154 0 0 0 25 0 0 0 32 5 0 0 48 5 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 208 3 0 0 194 0 0 0 14 0 0 0 0 0 0 0 80 1 0 0 194 0 0 0 2 0 0 0 162 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 48 6 0 0 0 0 0 0 194 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 50 4 0 0 0 0 0 0 80 4 0 0 146 0 0 0 20 0 0 0 80 115 116 70 105 108 101 84 111 111 108 115 32 84 111 111 108 98 97 114 0 0 0 0 130 2 0 0 0 0 0 0 170 2 0 0 0 0 0 0 192 2 0 0 194 0 0 0 1 0 0 0 242 2 0 0 0 0 0 0 16 3 0 0 194 0 0 0 2 0 0 0 18 1 0 0 0 0 0 0 53 1 0 0 1 0 0 0 18 1 0 0 0 0 0 0 155 0 0 0 49 0 0 0 48 6 0 0 98 3 0 0 0 0 0 0 130 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 154 0 0 0 0 0 0 0 231 0 0 0 24 0 0 0 32 5 0 0 48 5 0 0 0 0 0 0 19 0 0 0 48 5 0 0 0 0 0 0 19 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 58 2 0 0 0 0 0 0 80 2 0 0 112 2 0 0 0 0 0 0 70 5 7 0 2 0 0 0 77 101 110 117 66 97 114 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 5 0 0 0 70 5 4 0 2 0 0 0 77 101 110 117 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 9 0 0 0 70 2 15 0 1 0 0 0 67 111 109 109 97 110 100 77 101 110 117 73 116 101 109 0 0 0 0 1 0 0 0 70 4 18 0 2 0 0 0 67 111 109 109 97 110 100 68 101 115 99 114 105 112 116 105 111 110 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 12 0 0 0 103 101 110 101 114 97 116 101 67 111 100 101 146 0 0 0 14 0 0 0 38 71 101 110 101 114 97 116 101 32 99 111 100 101 1 0 0 0 0 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 14 0 0 0 103 101 110 101 114 97 116 101 67 111 100 101 65 115 146 0 0 0 20 0 0 0 71 101 110 101 114 97 116 101 32 38 99 111 100 101 32 97 115 46 46 46 1 0 0 0 0 0 0 0 70 1 15 0 1 0 0 0 68 105 118 105 100 101 114 77 101 110 117 73 116 101 109 0 0 0 0 1 16 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 11 0 0 0 111 112 101 110 80 114 111 106 101 99 116 146 0 0 0 16 0 0 0 38 79 112 101 110 32 112 114 111 106 101 99 116 46 46 46 1 0 0 0 0 0 0 0 114 7 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 2 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 16 0 0 0 110 101 119 80 114 111 106 101 99 116 80 97 108 109 79 83 146 0 0 0 15 0 0 0 38 80 97 108 109 79 83 32 80 114 111 106 101 99 116 1 0 0 0 0 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 14 0 0 0 110 101 119 80 114 111 106 101 99 116 71 101 111 115 146 0 0 0 13 0 0 0 38 71 69 79 83 32 80 114 111 106 101 99 116 1 0 0 0 0 0 0 0 146 0 0 0 12 0 0 0 38 78 101 119 32 112 114 111 106 101 99 116 0 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 11 0 0 0 115 97 118 101 80 114 111 106 101 99 116 146 0 0 0 13 0 0 0 38 83 97 118 101 32 112 114 111 106 101 99 116 1 0 0 0 0 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 13 0 0 0 115 97 118 101 80 114 111 106 101 99 116 65 115 146 0 0 0 19 0 0 0 83 97 118 101 32 112 114 111 106 101 99 116 32 38 97 115 46 46 46 1 0 0 0 0 0 0 0 98 8 0 0 0 0 0 0 1 16 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 13 0 0 0 101 120 105 116 83 109 97 108 108 116 97 108 107 146 0 0 0 5 0 0 0 69 38 120 105 116 1 0 0 0 0 0 0 0 146 0 0 0 7 0 0 0 38 83 121 115 116 101 109 0 0 0 0 114 7 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 5 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 16 0 0 0 111 112 101 110 67 108 97 115 115 66 114 111 119 115 101 114 146 0 0 0 14 0 0 0 38 67 108 97 115 115 32 98 114 111 119 115 101 114 1 0 0 0 0 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 13 0 0 0 111 112 101 110 87 111 114 107 115 112 97 99 101 146 0 0 0 10 0 0 0 38 87 111 114 107 115 112 97 99 101 1 0 0 0 0 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 20 0 0 0 111 112 101 110 67 111 110 115 116 97 110 116 115 66 114 111 119 115 101 114 146 0 0 0 18 0 0 0 67 38 111 110 115 116 97 110 116 115 32 98 114 111 119 115 101 114 1 0 0 0 0 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 18 0 0 0 111 112 101 110 80 97 99 107 97 103 101 66 114 111 119 115 101 114 146 0 0 0 16 0 0 0 38 80 97 99 107 97 103 101 32 98 114 111 119 115 101 114 1 0 0 0 0 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 18 0 0 0 111 112 101 110 83 121 115 116 114 97 112 66 114 111 119 115 101 114 146 0 0 0 16 0 0 0 38 83 121 115 116 114 97 112 32 66 114 111 119 115 101 114 1 0 0 0 0 0 0 0 146 0 0 0 6 0 0 0 38 84 111 111 108 115 0 0 0 0 114 7 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 6 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 22 0 0 0 102 105 110 100 77 101 116 104 111 100 115 82 101 102 101 114 114 105 110 103 84 111 146 0 0 0 23 0 0 0 77 101 116 104 111 100 115 32 114 101 102 101 114 114 105 110 103 32 116 111 46 46 46 1 0 0 0 0 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 27 0 0 0 102 105 110 100 77 101 116 104 111 100 115 67 111 110 116 97 105 110 105 110 103 83 116 114 105 110 103 146 0 0 0 28 0 0 0 77 101 116 104 111 100 115 32 99 111 110 116 97 105 110 105 110 103 32 115 116 114 105 110 103 46 46 46 1 0 0 0 0 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 16 0 0 0 102 105 110 100 73 109 112 108 101 109 101 110 116 111 114 115 146 0 0 0 18 0 0 0 73 109 112 108 101 109 101 110 116 111 114 115 32 111 102 46 46 46 1 0 0 0 0 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 11 0 0 0 102 105 110 100 83 101 110 100 101 114 115 146 0 0 0 13 0 0 0 83 101 110 100 101 114 115 32 111 102 46 46 46 1 0 0 0 0 0 0 0 98 8 0 0 0 0 0 0 1 16 0 0 114 7 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 2 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 34 0 0 0 115 104 111 119 83 101 108 101 99 116 111 114 115 83 101 110 116 66 117 116 78 111 116 73 109 112 108 101 109 101 110 116 101 100 146 0 0 0 25 0 0 0 38 83 101 110 116 32 98 117 116 32 110 111 116 32 105 109 112 108 101 109 101 110 116 101 100 1 0 0 0 0 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 34 0 0 0 115 104 111 119 83 101 108 101 99 116 111 114 115 73 109 112 108 101 109 101 110 116 101 100 66 117 116 78 111 116 83 101 110 116 146 0 0 0 25 0 0 0 38 73 109 112 108 101 109 101 110 116 101 100 32 98 117 116 32 110 111 116 32 115 101 110 116 1 0 0 0 0 0 0 0 146 0 0 0 10 0 0 0 38 83 101 108 101 99 116 111 114 115 0 0 0 0 146 0 0 0 7 0 0 0 83 38 101 97 114 99 104 0 0 0 0 114 7 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 4 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 10 0 0 0 99 104 111 111 115 101 70 111 110 116 146 0 0 0 15 0 0 0 67 104 111 111 115 101 32 38 102 111 110 116 46 46 46 1 0 0 0 0 0 0 0 112 8 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 12 0 0 0 99 108 101 97 114 71 108 111 98 97 108 115 146 0 0 0 18 0 0 0 38 67 108 101 97 114 32 115 104 97 114 101 100 32 118 97 114 115 1 0 0 0 0 0 0 0 114 7 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 2 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 20 0 0 0 115 104 111 119 77 101 116 104 111 100 83 116 97 116 105 115 116 105 99 115 146 0 0 0 14 0 0 0 38 77 101 116 104 111 100 32 99 111 117 110 116 115 1 0 0 0 0 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 25 0 0 0 115 104 111 119 73 110 115 116 114 117 99 116 105 111 110 83 116 97 116 105 115 116 105 99 115 146 0 0 0 19 0 0 0 38 73 110 115 116 114 117 99 116 105 111 110 32 99 111 117 110 116 115 1 0 0 0 0 0 0 0 146 0 0 0 11 0 0 0 38 83 116 97 116 105 115 116 105 99 115 0 0 0 0 146 0 0 0 8 0 0 0 38 79 112 116 105 111 110 115 0 0 0 0 114 7 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 1 0 0 0 162 7 0 0 0 0 0 0 1 0 0 0 194 7 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 9 0 0 0 115 104 111 119 65 98 111 117 116 146 0 0 0 9 0 0 0 38 65 98 111 117 116 46 46 46 1 0 0 0 0 0 0 0 146 0 0 0 5 0 0 0 38 72 101 108 112 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 70 5 4 0 3 0 0 0 73 99 111 110 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 10 2 0 0 0 0 0 0 146 0 0 0 7 0 0 0 99 117 114 114 101 110 116 146 0 0 0 12 0 0 0 112 111 99 107 101 116 115 116 46 105 99 111 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 146 0 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0 242 16 0 0 0 0 0 0 0 0 0 0 16 0 0 0 32 17 0 0 146 0 0 0 12 0 0 0 112 111 99 107 101 116 115 116 46 105 99 111 144 17 0 0 0 0 0 0 0 0 0 0 130 2 0 0 0 0 0 0 170 2 0 0 0 0 0 0 192 2 0 0 194 0 0 0 3 0 0 0 242 2 0 0 0 0 0 0 16 3 0 0 194 0 0 0 2 0 0 0 18 1 0 0 0 0 0 0 11 0 0 0 11 0 0 0 18 1 0 0 0 0 0 0 59 2 0 0 141 0 0 0 96 0 0 0 242 2 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 5 0 0 0 116 101 120 116 58 194 0 0 0 1 0 0 0 146 0 0 0 16 0 0 0 80 111 99 107 101 116 32 83 109 97 108 108 116 97 108 107 96 0 0 0 242 2 0 0 0 0 0 0 10 2 0 0 0 0 0 0 146 0 0 0 8 0 0 0 109 101 110 117 66 97 114 58 194 0 0 0 1 0 0 0 80 7 0 0 96 0 0 0 98 3 0 0 0 0 0 0 130 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 5 0 0 0 34 1 0 0 75 0 0 0 170 2 0 0 0 0 0 0 192 2 0 0 194 0 0 0 1 0 0 0 80 1 0 0 48 5 0 0 0 0 0 0 19 0 0 0 70 5 4 0 3 0 0 0 73 99 111 110 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 18 1 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 18 1 0 0 7 0 0 0 99 117 114 114 101 110 116 18 1 0 0 13 0 0 0 83 104 101 108 108 86 105 101 119 46 105 99 111 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 18 1 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0])!

(ResourceIdentifier class: PstMethodListBrowser name: 'Default view') assign: (Object fromBinaryStoreBytes:
#[33 83 84 66 32 48 32 70 2 12 0 1 0 0 0 86 105 101 119 82 101 115 111 117 114 99 101 0 0 0 0 14 1 36 0 83 84 66 82 101 115 111 117 114 99 101 83 84 66 66 121 116 101 65 114 114 97 121 65 99 99 101 115 115 111 114 80 114 111 120 121 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 84 19 0 0 33 83 84 66 32 48 32 78 8 12 0 10 0 0 0 83 84 66 86 105 101 119 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 146 0 0 0 9 0 0 0 83 104 101 108 108 86 105 101 119 38 0 5 0 65 114 114 97 121 24 0 0 0 0 0 0 0 0 0 0 0 194 0 0 0 2 0 0 0 1 0 158 1 1 0 2 0 96 0 0 0 0 0 0 0 0 0 0 0 6 2 5 0 80 111 105 110 116 0 0 0 0 1 5 0 0 193 3 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 7 12 0 66 111 114 100 101 114 76 97 121 111 117 116 0 0 0 0 1 0 0 0 1 0 0 0 0 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 9 0 0 0 83 116 97 116 117 115 66 97 114 194 0 0 0 18 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 54 0 12 0 76 97 114 103 101 73 110 116 101 103 101 114 4 0 0 0 4 1 0 68 1 0 0 0 48 1 0 0 0 0 0 0 6 1 11 0 83 121 115 116 101 109 67 111 108 111 114 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 6 4 4 0 70 111 110 116 0 0 0 0 0 0 0 0 16 0 0 0 6 1 7 0 76 79 71 70 79 78 84 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 60 0 0 0 243 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 144 1 0 0 0 0 0 0 3 2 1 34 65 114 105 97 108 0 120 131 66 49 15 1 0 0 196 53 15 1 2 0 144 39 0 0 0 0 191 0 253 85 63 1 242 0 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 8 0 0 0 39 2 255 255 0 0 0 0 14 2 26 0 83 84 66 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 18 0 0 0 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 194 0 0 0 0 0 0 0 14 2 18 0 83 84 66 67 111 108 108 101 99 116 105 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 79 114 100 101 114 101 100 67 111 108 108 101 99 116 105 111 110 194 0 0 0 1 0 0 0 6 4 17 0 83 116 97 116 117 115 66 97 114 78 117 108 108 73 116 101 109 0 0 0 0 1 2 0 0 1 0 0 0 48 1 0 0 0 0 0 0 240 2 0 0 0 0 0 0 6 1 15 0 77 101 115 115 97 103 101 83 101 113 117 101 110 99 101 0 0 0 0 154 2 0 0 0 0 0 0 176 2 0 0 194 0 0 0 1 0 0 0 6 3 11 0 77 101 115 115 97 103 101 83 101 110 100 0 0 0 0 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 146 0 0 0 16 0 0 0 99 114 101 97 116 101 65 116 58 101 120 116 101 110 116 58 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 95 3 0 0 242 0 0 0 0 0 0 0 241 4 0 0 45 0 0 0 48 1 0 0 6 1 15 0 87 73 78 68 79 87 80 76 65 67 69 77 69 78 84 0 0 0 0 2 2 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 175 1 0 0 120 2 0 0 197 1 0 0 154 2 0 0 0 0 0 0 176 2 0 0 128 2 0 0 242 0 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 19 0 0 0 0 0 0 0 0 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 13 0 0 0 67 111 110 116 97 105 110 101 114 86 105 101 119 194 0 0 0 15 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 16 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 2 18 0 80 114 111 112 111 114 116 105 111 110 97 108 76 97 121 111 117 116 0 0 0 0 74 2 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 11 0 0 0 76 111 111 107 117 112 84 97 98 108 101 194 0 0 0 2 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 8 0 0 0 83 112 108 105 116 116 101 114 194 0 0 0 12 0 0 0 0 0 0 0 16 4 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 0 0 208 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 3 0 0 0 0 0 0 154 2 0 0 0 0 0 0 176 2 0 0 194 0 0 0 1 0 0 0 66 3 0 0 0 0 0 0 112 3 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 173 1 0 0 242 0 0 0 0 0 0 0 241 4 0 0 7 0 0 0 208 4 0 0 194 3 0 0 0 0 0 0 2 2 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 214 0 0 0 120 2 0 0 217 0 0 0 154 2 0 0 0 0 0 0 176 2 0 0 128 2 0 0 0 4 0 0 0 0 0 0 19 0 0 0 1 0 0 0 16 0 0 0 74 2 0 0 0 0 0 0 96 2 0 0 194 0 0 0 4 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 12 0 0 0 82 105 99 104 84 101 120 116 69 100 105 116 194 0 0 0 18 0 0 0 0 0 0 0 16 4 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 68 17 33 68 1 4 0 0 240 5 0 0 0 0 0 0 6 3 3 0 82 71 66 0 0 0 0 181 1 0 0 215 1 0 0 209 1 0 0 0 0 0 0 7 0 0 0 70 5 4 0 2 0 0 0 77 101 110 117 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 10 0 0 0 70 2 15 0 1 0 0 0 67 111 109 109 97 110 100 77 101 110 117 73 116 101 109 0 0 0 0 1 0 0 0 70 4 18 0 2 0 0 0 67 111 109 109 97 110 100 68 101 115 99 114 105 112 116 105 111 110 0 0 0 0 106 3 0 0 0 0 0 0 146 0 0 0 6 0 0 0 97 99 99 101 112 116 146 0 0 0 7 0 0 0 38 65 99 99 101 112 116 167 32 0 0 0 0 0 0 70 1 15 0 1 0 0 0 68 105 118 105 100 101 114 77 101 110 117 73 116 101 109 0 0 0 0 1 16 0 0 162 6 0 0 0 0 0 0 1 0 0 0 194 6 0 0 0 0 0 0 106 3 0 0 0 0 0 0 146 0 0 0 12 0 0 0 99 117 116 83 101 108 101 99 116 105 111 110 146 0 0 0 4 0 0 0 67 117 38 116 177 32 0 0 0 0 0 0 162 6 0 0 0 0 0 0 1 0 0 0 194 6 0 0 0 0 0 0 106 3 0 0 0 0 0 0 146 0 0 0 13 0 0 0 99 111 112 121 83 101 108 101 99 116 105 111 110 146 0 0 0 5 0 0 0 38 67 111 112 121 135 32 0 0 0 0 0 0 162 6 0 0 0 0 0 0 1 0 0 0 194 6 0 0 0 0 0 0 106 3 0 0 0 0 0 0 146 0 0 0 14 0 0 0 112 97 115 116 101 67 108 105 112 98 111 97 114 100 146 0 0 0 6 0 0 0 38 80 97 115 116 101 173 32 0 0 0 0 0 0 162 6 0 0 0 0 0 0 1 0 0 0 194 6 0 0 0 0 0 0 106 3 0 0 0 0 0 0 146 0 0 0 14 0 0 0 99 108 101 97 114 83 101 108 101 99 116 105 111 110 146 0 0 0 7 0 0 0 68 101 38 108 101 116 101 93 2 0 0 0 0 0 0 32 7 0 0 162 6 0 0 0 0 0 0 1 0 0 0 194 6 0 0 0 0 0 0 106 3 0 0 0 0 0 0 146 0 0 0 4 0 0 0 100 111 73 116 146 0 0 0 6 0 0 0 38 68 111 32 105 116 139 32 0 0 0 0 0 0 162 6 0 0 0 0 0 0 1 0 0 0 194 6 0 0 0 0 0 0 106 3 0 0 0 0 0 0 146 0 0 0 7 0 0 0 112 114 105 110 116 73 116 146 0 0 0 9 0 0 0 80 38 114 105 110 116 32 105 116 137 32 0 0 0 0 0 0 162 6 0 0 0 0 0 0 1 0 0 0 194 6 0 0 0 0 0 0 106 3 0 0 0 0 0 0 146 0 0 0 9 0 0 0 105 110 115 112 101 99 116 73 116 146 0 0 0 11 0 0 0 38 73 110 115 112 101 99 116 32 105 116 147 32 0 0 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 4 0 0 0 211 16 46 119 6 2 13 0 78 117 108 108 67 111 110 118 101 114 116 101 114 0 0 0 0 0 0 0 0 0 0 0 0 9 0 0 0 0 0 0 0 6 1 10 0 69 68 73 84 83 84 82 69 65 77 0 0 0 0 2 2 0 0 12 0 0 0 0 0 0 0 0 0 0 0 236 213 227 8 2 3 0 0 0 0 0 0 154 2 0 0 0 0 0 0 176 2 0 0 194 0 0 0 6 0 0 0 66 3 0 0 0 0 0 0 112 3 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 179 1 0 0 242 0 0 0 0 0 0 0 241 4 0 0 173 1 0 0 240 5 0 0 66 3 0 0 0 0 0 0 106 3 0 0 0 0 0 0 146 0 0 0 12 0 0 0 99 111 110 116 101 120 116 77 101 110 117 58 194 0 0 0 1 0 0 0 128 6 0 0 240 5 0 0 66 3 0 0 0 0 0 0 106 3 0 0 0 0 0 0 146 0 0 0 5 0 0 0 116 101 120 116 58 194 0 0 0 1 0 0 0 6 1 8 0 82 105 99 104 84 101 120 116 0 0 0 0 146 0 0 0 120 0 0 0 123 92 114 116 102 49 92 97 110 115 105 92 97 110 115 105 99 112 103 49 50 53 50 92 100 101 102 102 48 92 100 101 102 108 97 110 103 50 48 53 55 123 92 102 111 110 116 116 98 108 123 92 102 48 92 102 114 111 109 97 110 32 84 105 109 101 115 32 78 101 119 32 82 111 109 97 110 59 125 125 13 10 92 118 105 101 119 107 105 110 100 52 92 117 99 49 92 112 97 114 100 92 102 48 92 102 115 50 50 32 13 10 92 112 97 114 32 125 13 10 240 5 0 0 66 3 0 0 0 0 0 0 106 3 0 0 0 0 0 0 146 0 0 0 15 0 0 0 115 101 108 101 99 116 105 111 110 82 97 110 103 101 58 194 0 0 0 1 0 0 0 6 3 8 0 73 110 116 101 114 118 97 108 0 0 0 0 3 0 0 0 1 0 0 0 3 0 0 0 240 5 0 0 66 3 0 0 0 0 0 0 106 3 0 0 0 0 0 0 146 0 0 0 15 0 0 0 105 115 84 101 120 116 77 111 100 105 102 105 101 100 58 194 0 0 0 1 0 0 0 32 0 0 0 240 5 0 0 66 3 0 0 0 0 0 0 106 3 0 0 0 0 0 0 146 0 0 0 15 0 0 0 114 101 115 101 116 67 104 97 114 70 111 114 109 97 116 194 0 0 0 0 0 0 0 240 5 0 0 194 3 0 0 0 0 0 0 2 2 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 217 0 0 0 120 2 0 0 175 1 0 0 154 2 0 0 0 0 0 0 176 2 0 0 128 2 0 0 0 4 0 0 0 0 0 0 19 0 0 0 146 0 0 0 10 0 0 0 115 111 117 114 99 101 67 111 100 101 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 7 0 0 0 76 105 115 116 66 111 120 194 0 0 0 17 0 0 0 0 0 0 0 16 4 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 1 1 49 68 1 4 0 0 16 12 0 0 70 3 9 0 2 0 0 0 76 105 115 116 77 111 100 101 108 0 0 0 0 154 2 0 0 0 0 0 0 176 2 0 0 128 2 0 0 0 0 0 0 6 0 20 0 73 100 101 110 116 105 116 121 83 101 97 114 99 104 80 111 108 105 99 121 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 114 6 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 4 0 0 0 162 6 0 0 0 0 0 0 1 0 0 0 194 6 0 0 0 0 0 0 106 3 0 0 0 0 0 0 146 0 0 0 12 0 0 0 100 101 108 101 116 101 77 101 116 104 111 100 146 0 0 0 14 0 0 0 38 68 101 108 101 116 101 32 109 101 116 104 111 100 1 0 0 0 0 0 0 0 18 7 0 0 0 0 0 0 1 16 0 0 162 6 0 0 0 0 0 0 1 0 0 0 194 6 0 0 0 0 0 0 106 3 0 0 0 0 0 0 146 0 0 0 13 0 0 0 98 114 111 119 115 101 83 101 110 100 101 114 115 146 0 0 0 15 0 0 0 66 114 111 119 115 101 32 38 115 101 110 100 101 114 115 1 0 0 0 0 0 0 0 162 6 0 0 0 0 0 0 1 0 0 0 194 6 0 0 0 0 0 0 106 3 0 0 0 0 0 0 146 0 0 0 18 0 0 0 98 114 111 119 115 101 73 109 112 108 101 109 101 110 116 111 114 115 146 0 0 0 20 0 0 0 66 114 111 119 115 101 32 38 105 109 112 108 101 109 101 110 116 111 114 115 1 0 0 0 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 4 0 0 0 244 100 227 119 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 66 97 115 105 99 76 105 115 116 65 98 115 116 114 97 99 116 1 0 0 0 32 0 0 0 2 3 0 0 0 0 0 0 154 2 0 0 0 0 0 0 176 2 0 0 194 0 0 0 3 0 0 0 66 3 0 0 0 0 0 0 112 3 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 173 1 0 0 16 12 0 0 66 3 0 0 0 0 0 0 80 10 0 0 194 0 0 0 1 0 0 0 192 12 0 0 16 12 0 0 66 3 0 0 0 0 0 0 106 3 0 0 0 0 0 0 146 0 0 0 17 0 0 0 104 111 114 105 122 111 110 116 97 108 69 120 116 101 110 116 58 194 0 0 0 1 0 0 0 1 0 0 0 16 12 0 0 194 3 0 0 0 0 0 0 2 2 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 120 2 0 0 214 0 0 0 154 2 0 0 0 0 0 0 176 2 0 0 128 2 0 0 0 4 0 0 0 0 0 0 19 0 0 0 146 0 0 0 10 0 0 0 109 101 116 104 111 100 76 105 115 116 0 0 0 0 2 3 0 0 0 0 0 0 154 2 0 0 0 0 0 0 176 2 0 0 194 0 0 0 1 0 0 0 66 3 0 0 0 0 0 0 112 3 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 95 3 0 0 16 4 0 0 194 3 0 0 0 0 0 0 2 2 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 120 2 0 0 175 1 0 0 154 2 0 0 0 0 0 0 176 2 0 0 194 0 0 0 3 0 0 0 16 12 0 0 208 4 0 0 240 5 0 0 0 4 0 0 0 0 0 0 19 0 0 0 74 2 0 0 0 0 0 0 96 2 0 0 128 2 0 0 0 0 0 0 70 5 7 0 2 0 0 0 77 101 110 117 66 97 114 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 1 0 0 0 114 6 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 10 0 0 0 162 6 0 0 0 0 0 0 1 0 0 0 194 6 0 0 0 0 0 0 224 6 0 0 146 0 0 0 7 0 0 0 38 65 99 99 101 112 116 167 32 0 0 0 0 0 0 18 7 0 0 0 0 0 0 1 16 0 0 162 6 0 0 0 0 0 0 1 0 0 0 194 6 0 0 0 0 0 0 80 7 0 0 146 0 0 0 4 0 0 0 67 117 38 116 177 32 0 0 0 0 0 0 162 6 0 0 0 0 0 0 1 0 0 0 194 6 0 0 0 0 0 0 160 7 0 0 146 0 0 0 5 0 0 0 38 67 111 112 121 135 32 0 0 0 0 0 0 162 6 0 0 0 0 0 0 1 0 0 0 194 6 0 0 0 0 0 0 240 7 0 0 146 0 0 0 6 0 0 0 38 80 97 115 116 101 173 32 0 0 0 0 0 0 162 6 0 0 0 0 0 0 1 0 0 0 194 6 0 0 0 0 0 0 64 8 0 0 146 0 0 0 7 0 0 0 68 101 38 108 101 116 101 1 0 0 0 0 0 0 0 112 16 0 0 162 6 0 0 0 0 0 0 1 0 0 0 194 6 0 0 0 0 0 0 144 8 0 0 146 0 0 0 6 0 0 0 38 68 111 32 73 116 139 32 0 0 0 0 0 0 162 6 0 0 0 0 0 0 1 0 0 0 194 6 0 0 0 0 0 0 224 8 0 0 146 0 0 0 9 0 0 0 80 38 114 105 110 116 32 73 116 137 32 0 0 0 0 0 0 162 6 0 0 0 0 0 0 1 0 0 0 194 6 0 0 0 0 0 0 48 9 0 0 146 0 0 0 11 0 0 0 38 73 110 115 112 101 99 116 32 73 116 147 32 0 0 0 0 0 0 146 0 0 0 7 0 0 0 38 83 111 117 114 99 101 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 3 16 0 65 99 99 101 108 101 114 97 116 111 114 84 97 98 108 101 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 7 0 0 0 6 2 11 0 65 115 115 111 99 105 97 116 105 111 110 0 0 0 0 167 32 0 0 80 16 0 0 34 18 0 0 0 0 0 0 177 32 0 0 144 16 0 0 34 18 0 0 0 0 0 0 135 32 0 0 192 16 0 0 34 18 0 0 0 0 0 0 173 32 0 0 240 16 0 0 34 18 0 0 0 0 0 0 139 32 0 0 80 17 0 0 34 18 0 0 0 0 0 0 137 32 0 0 128 17 0 0 34 18 0 0 0 0 0 0 147 32 0 0 176 17 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 3 0 0 0 0 0 0 154 2 0 0 0 0 0 0 176 2 0 0 194 0 0 0 3 0 0 0 66 3 0 0 0 0 0 0 112 3 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 11 0 0 0 11 0 0 0 242 0 0 0 0 0 0 0 1 5 0 0 193 3 0 0 96 0 0 0 66 3 0 0 0 0 0 0 144 10 0 0 194 0 0 0 1 0 0 0 146 0 0 0 11 0 0 0 77 101 116 104 111 100 32 108 105 115 116 96 0 0 0 66 3 0 0 0 0 0 0 106 3 0 0 0 0 0 0 146 0 0 0 8 0 0 0 109 101 110 117 66 97 114 58 194 0 0 0 1 0 0 0 0 16 0 0 96 0 0 0 194 3 0 0 0 0 0 0 2 2 0 0 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 5 0 0 0 133 2 0 0 229 1 0 0 154 2 0 0 0 0 0 0 176 2 0 0 194 0 0 0 2 0 0 0 48 1 0 0 16 4 0 0 0 4 0 0 0 0 0 0 19 0 0 0 70 5 4 0 3 0 0 0 73 99 111 110 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 18 1 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 18 1 0 0 7 0 0 0 99 117 114 114 101 110 116 18 1 0 0 13 0 0 0 83 104 101 108 108 86 105 101 119 46 105 99 111 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 18 1 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0])!

(ResourceIdentifier class: PstPackageBrowser name: 'Default view') assign: (Object fromBinaryStoreBytes:
#[33 83 84 66 32 48 32 70 2 12 0 1 0 0 0 86 105 101 119 82 101 115 111 117 114 99 101 0 0 0 0 14 1 36 0 83 84 66 82 101 115 111 117 114 99 101 83 84 66 66 121 116 101 65 114 114 97 121 65 99 99 101 115 115 111 114 80 114 111 120 121 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 224 33 0 0 33 83 84 66 32 48 32 78 8 12 0 10 0 0 0 83 84 66 86 105 101 119 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 146 0 0 0 9 0 0 0 83 104 101 108 108 86 105 101 119 38 0 5 0 65 114 114 97 121 24 0 0 0 0 0 0 0 0 0 0 0 194 0 0 0 2 0 0 0 1 0 158 1 1 0 2 0 96 0 0 0 0 0 0 0 0 0 0 0 6 2 5 0 80 111 105 110 116 0 0 0 0 1 5 0 0 193 3 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 7 12 0 66 111 114 100 101 114 76 97 121 111 117 116 0 0 0 0 1 0 0 0 1 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 13 0 0 0 67 111 110 116 97 105 110 101 114 86 105 101 119 194 0 0 0 15 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 54 0 12 0 76 97 114 103 101 73 110 116 101 103 101 114 4 0 0 0 0 0 0 68 1 0 2 0 48 1 0 0 0 0 0 0 6 1 11 0 83 121 115 116 101 109 67 111 108 111 114 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 3 10 0 70 108 111 119 76 97 121 111 117 116 0 0 0 0 1 0 0 0 1 0 0 0 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 146 0 0 0 4 0 0 0 108 101 102 116 14 2 26 0 83 84 66 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 18 0 0 0 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 194 0 0 0 0 0 0 0 0 0 0 0 6 1 15 0 77 101 115 115 97 103 101 83 101 113 117 101 110 99 101 0 0 0 0 14 2 18 0 83 84 66 67 111 108 108 101 99 116 105 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 79 114 100 101 114 101 100 67 111 108 108 101 99 116 105 111 110 194 0 0 0 1 0 0 0 6 3 11 0 77 101 115 115 97 103 101 83 101 110 100 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 16 0 0 0 99 114 101 97 116 101 65 116 58 101 120 116 101 110 116 58 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 51 0 0 0 48 1 0 0 6 1 15 0 87 73 78 68 79 87 80 76 65 67 69 77 69 78 84 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 120 2 0 0 25 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 2 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 13 0 0 0 82 101 102 101 114 101 110 99 101 86 105 101 119 194 0 0 0 14 0 0 0 0 0 0 0 48 1 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 160 3 0 0 0 0 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 2 18 0 82 101 115 111 117 114 99 101 73 100 101 110 116 105 102 105 101 114 0 0 0 0 122 0 0 0 0 0 0 0 146 0 0 0 3 0 0 0 112 115 116 146 0 0 0 10 0 0 0 80 115 116 84 111 111 108 98 97 114 146 0 0 0 16 0 0 0 80 115 116 73 109 97 103 101 32 84 111 111 108 98 97 114 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 63 0 0 0 51 0 0 0 160 3 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 31 0 0 0 25 0 0 0 194 0 0 0 0 0 0 0 242 0 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 176 3 0 0 194 0 0 0 14 0 0 0 0 0 0 0 48 1 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 32 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18 4 0 0 0 0 0 0 48 4 0 0 146 0 0 0 16 0 0 0 80 115 116 84 111 111 108 115 32 84 111 111 108 98 97 114 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 63 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 247 0 0 0 51 0 0 0 32 5 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 31 0 0 0 0 0 0 0 154 0 0 0 25 0 0 0 0 5 0 0 16 5 0 0 0 0 0 0 19 0 0 0 16 5 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 9 0 0 0 83 116 97 116 117 115 66 97 114 194 0 0 0 18 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 4 1 0 68 1 0 0 0 16 6 0 0 0 0 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 6 4 4 0 70 111 110 116 0 0 0 0 0 0 0 0 16 0 0 0 6 1 7 0 76 79 71 70 79 78 84 0 0 0 0 98 3 0 0 60 0 0 0 243 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 144 1 0 0 0 0 0 0 3 2 1 34 65 114 105 97 108 0 31 5 20 135 63 1 0 0 204 53 63 1 3 0 20 59 0 0 0 0 247 0 5 86 111 1 242 0 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 8 0 0 0 39 2 255 255 0 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 80 2 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 6 4 17 0 83 116 97 116 117 115 66 97 114 78 117 108 108 73 116 101 109 0 0 0 0 1 2 0 0 1 0 0 0 16 6 0 0 0 0 0 0 48 7 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 99 3 0 0 242 0 0 0 0 0 0 0 241 4 0 0 41 0 0 0 16 6 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 177 1 0 0 120 2 0 0 197 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 0 0 0 0 0 0 0 0 90 0 0 0 0 0 0 0 64 1 0 0 194 0 0 0 15 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 224 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 2 18 0 80 114 111 112 111 114 116 105 111 110 97 108 76 97 121 111 117 116 0 0 0 0 26 2 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 11 0 0 0 76 111 111 107 117 112 84 97 98 108 101 194 0 0 0 4 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 13 0 0 0 67 97 114 100 67 111 110 116 97 105 110 101 114 194 0 0 0 16 0 0 0 0 0 0 0 224 7 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 128 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 2 10 0 67 97 114 100 76 97 121 111 117 116 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 6 2 11 0 65 115 115 111 99 105 97 116 105 111 110 0 0 0 0 146 0 0 0 7 0 0 0 67 108 97 115 115 101 115 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 7 0 0 0 76 105 115 116 66 111 120 194 0 0 0 17 0 0 0 0 0 0 0 128 8 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 1 1 49 68 1 4 0 0 80 9 0 0 70 3 9 0 2 0 0 0 76 105 115 116 77 111 100 101 108 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 0 0 0 0 6 0 20 0 73 100 101 110 116 105 116 121 83 101 97 114 99 104 80 111 108 105 99 121 0 0 0 0 6 3 3 0 82 71 66 0 0 0 0 235 1 0 0 233 1 0 0 255 1 0 0 0 0 0 0 7 0 0 0 70 5 4 0 2 0 0 0 77 101 110 117 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 4 0 0 0 70 2 15 0 1 0 0 0 67 111 109 109 97 110 100 77 101 110 117 73 116 101 109 0 0 0 0 1 0 0 0 70 4 18 0 2 0 0 0 67 111 109 109 97 110 100 68 101 115 99 114 105 112 116 105 111 110 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 19 0 0 0 97 100 100 85 110 99 111 109 109 105 116 116 101 100 67 108 97 115 115 146 0 0 0 25 0 0 0 38 65 100 100 32 117 110 99 111 109 109 105 116 116 101 100 32 99 108 97 115 115 46 46 46 1 0 0 0 0 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 17 0 0 0 109 111 118 101 83 101 108 101 99 116 101 100 67 108 97 115 115 146 0 0 0 19 0 0 0 38 77 111 118 101 32 116 111 32 112 97 99 107 97 103 101 46 46 46 1 0 0 0 0 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 19 0 0 0 114 101 109 111 118 101 83 101 108 101 99 116 101 100 67 108 97 115 115 146 0 0 0 20 0 0 0 38 82 101 109 111 118 101 32 102 114 111 109 32 112 97 99 107 97 103 101 1 0 0 0 0 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 19 0 0 0 98 114 111 119 115 101 83 101 108 101 99 116 101 100 67 108 97 115 115 146 0 0 0 13 0 0 0 38 66 114 111 119 115 101 32 99 108 97 115 115 1 0 0 0 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 4 0 0 0 244 100 227 119 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 66 97 115 105 99 76 105 115 116 65 98 115 116 114 97 99 116 1 0 0 0 32 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 9 0 0 0 53 0 0 0 242 0 0 0 0 0 0 0 225 4 0 0 225 1 0 0 80 9 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 12 0 0 0 99 111 110 116 101 120 116 77 101 110 117 58 194 0 0 0 1 0 0 0 48 10 0 0 80 9 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 17 0 0 0 104 111 114 105 122 111 110 116 97 108 69 120 116 101 110 116 58 194 0 0 0 1 0 0 0 1 0 0 0 80 9 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 4 0 0 0 26 0 0 0 116 2 0 0 10 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 34 9 0 0 0 0 0 0 146 0 0 0 7 0 0 0 77 101 116 104 111 100 115 90 0 0 0 0 0 0 0 96 9 0 0 194 0 0 0 17 0 0 0 0 0 0 0 128 8 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 1 1 49 68 1 4 0 0 48 13 0 0 178 9 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 0 0 0 0 240 9 0 0 2 10 0 0 0 0 0 0 215 1 0 0 249 1 0 0 221 1 0 0 0 0 0 0 7 0 0 0 34 10 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 5 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 20 0 0 0 114 101 109 111 118 101 83 101 108 101 99 116 101 100 77 101 116 104 111 100 146 0 0 0 20 0 0 0 38 82 101 109 111 118 101 32 102 114 111 109 32 112 97 99 107 97 103 101 1 0 0 0 0 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 20 0 0 0 98 114 111 119 115 101 83 101 108 101 99 116 101 100 77 101 116 104 111 100 146 0 0 0 14 0 0 0 38 66 114 111 119 115 101 32 109 101 116 104 111 100 1 0 0 0 0 0 0 0 70 1 15 0 1 0 0 0 68 105 118 105 100 101 114 77 101 110 117 73 116 101 109 0 0 0 0 1 16 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 18 0 0 0 98 114 111 119 115 101 73 109 112 108 101 109 101 110 116 111 114 115 146 0 0 0 13 0 0 0 38 73 109 112 108 101 109 101 110 116 111 114 115 1 0 0 0 0 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 13 0 0 0 98 114 111 119 115 101 83 101 110 100 101 114 115 146 0 0 0 8 0 0 0 38 83 101 110 100 101 114 115 1 0 0 0 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 4 0 0 0 244 100 227 119 208 11 0 0 1 0 0 0 32 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 9 0 0 0 53 0 0 0 242 0 0 0 0 0 0 0 225 4 0 0 225 1 0 0 48 13 0 0 210 2 0 0 0 0 0 0 112 12 0 0 194 0 0 0 1 0 0 0 160 13 0 0 48 13 0 0 210 2 0 0 0 0 0 0 176 12 0 0 194 0 0 0 1 0 0 0 1 0 0 0 48 13 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 4 0 0 0 26 0 0 0 116 2 0 0 10 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 34 9 0 0 0 0 0 0 146 0 0 0 9 0 0 0 67 111 110 115 116 97 110 116 115 90 0 0 0 0 0 0 0 96 9 0 0 194 0 0 0 17 0 0 0 0 0 0 0 128 8 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 1 1 49 68 1 4 0 0 64 16 0 0 178 9 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 0 0 0 0 240 9 0 0 2 10 0 0 0 0 0 0 255 1 0 0 239 1 0 0 233 1 0 0 0 0 0 0 7 0 0 0 34 10 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 5 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 20 0 0 0 109 111 118 101 83 101 108 101 99 116 101 100 67 111 110 115 116 97 110 116 146 0 0 0 19 0 0 0 38 77 111 118 101 32 116 111 32 112 97 99 107 97 103 101 46 46 46 1 0 0 0 0 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 22 0 0 0 114 101 109 111 118 101 83 101 108 101 99 116 101 100 67 111 110 115 116 97 110 116 146 0 0 0 20 0 0 0 38 82 101 109 111 118 101 32 102 114 111 109 32 112 97 99 107 97 103 101 1 0 0 0 0 0 0 0 98 14 0 0 0 0 0 0 1 16 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 22 0 0 0 98 114 111 119 115 101 83 101 108 101 99 116 101 100 67 111 110 115 116 97 110 116 146 0 0 0 7 0 0 0 38 66 114 111 119 115 101 1 0 0 0 0 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 26 0 0 0 98 114 111 119 115 101 82 101 102 101 114 101 110 99 101 115 84 111 67 111 110 115 116 97 110 116 146 0 0 0 18 0 0 0 66 114 111 119 115 101 32 82 101 38 102 101 114 101 110 99 101 115 1 0 0 0 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 4 0 0 0 244 100 227 119 208 11 0 0 1 0 0 0 32 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 9 0 0 0 53 0 0 0 242 0 0 0 0 0 0 0 225 4 0 0 225 1 0 0 64 16 0 0 210 2 0 0 0 0 0 0 112 12 0 0 194 0 0 0 1 0 0 0 176 16 0 0 64 16 0 0 210 2 0 0 0 0 0 0 176 12 0 0 194 0 0 0 1 0 0 0 1 0 0 0 64 16 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 4 0 0 0 26 0 0 0 116 2 0 0 10 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 80 9 0 0 26 2 0 0 0 0 0 0 48 2 0 0 194 0 0 0 6 0 0 0 80 9 0 0 146 0 0 0 9 0 0 0 99 108 97 115 115 76 105 115 116 64 16 0 0 146 0 0 0 12 0 0 0 99 111 110 115 116 97 110 116 76 105 115 116 48 13 0 0 146 0 0 0 10 0 0 0 109 101 116 104 111 100 76 105 115 116 0 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 7 0 0 0 84 97 98 86 105 101 119 194 0 0 0 23 0 0 0 0 0 0 0 128 8 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 2 1 68 1 0 0 0 112 19 0 0 178 9 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 64 9 0 0 32 13 0 0 48 16 0 0 0 0 0 0 240 9 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 8 0 0 0 47 2 255 255 0 0 0 0 208 11 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 18 0 0 0 73 99 111 110 105 99 76 105 115 116 65 98 115 116 114 97 99 116 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 16 0 0 0 73 99 111 110 73 109 97 103 101 77 97 110 97 103 101 114 234 1 0 0 0 0 0 0 146 0 0 0 7 0 0 0 99 117 114 114 101 110 116 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 7 0 0 0 110 111 73 99 111 110 115 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 29 2 0 0 112 19 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 26 0 0 0 115 101 108 101 99 116 105 111 110 66 121 73 110 100 101 120 58 105 102 65 98 115 101 110 116 58 194 0 0 0 2 0 0 0 3 0 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 8 0 0 0 121 111 117 114 115 101 108 102 194 0 0 0 0 0 0 0 0 0 0 0 112 19 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 30 0 0 0 116 99 109 83 101 116 69 120 116 101 110 100 101 100 83 116 121 108 101 58 100 119 69 120 83 116 121 108 101 58 194 0 0 0 2 0 0 0 255 255 255 255 1 0 0 0 112 19 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 120 2 0 0 14 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 21 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 21 1 0 0 242 0 0 0 0 0 0 0 241 4 0 0 29 2 0 0 128 8 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 138 0 0 0 120 2 0 0 152 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 4 0 0 0 80 9 0 0 48 13 0 0 64 16 0 0 112 19 0 0 16 5 0 0 0 0 0 0 19 0 0 0 5 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 8 0 0 0 83 112 108 105 116 116 101 114 194 0 0 0 12 0 0 0 0 0 0 0 224 7 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 0 0 208 22 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 15 1 0 0 242 0 0 0 0 0 0 0 241 4 0 0 7 0 0 0 208 22 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 135 0 0 0 120 2 0 0 138 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 1 0 0 0 16 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 194 0 0 0 2 0 0 0 90 0 0 0 0 0 0 0 96 9 0 0 194 0 0 0 17 0 0 0 0 0 0 0 224 7 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 1 1 49 68 1 4 0 0 240 23 0 0 178 9 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 0 0 0 0 240 9 0 0 2 10 0 0 0 0 0 0 231 1 0 0 229 1 0 0 207 1 0 0 0 0 0 0 7 0 0 0 34 10 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 11 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 14 0 0 0 105 110 115 116 97 108 108 80 97 99 107 97 103 101 146 0 0 0 19 0 0 0 38 73 110 115 116 97 108 108 32 112 97 99 107 97 103 101 46 46 46 1 0 0 0 0 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 10 0 0 0 110 101 119 80 97 99 107 97 103 101 146 0 0 0 15 0 0 0 38 78 101 119 32 112 97 99 107 97 103 101 46 46 46 1 0 0 0 0 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 13 0 0 0 114 101 109 111 118 101 80 97 99 107 97 103 101 146 0 0 0 14 0 0 0 82 101 109 111 118 101 32 80 97 99 107 97 103 101 1 0 0 0 0 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 27 0 0 0 115 101 116 83 101 108 101 99 116 101 100 80 97 99 107 97 103 101 65 115 68 101 102 97 117 108 116 146 0 0 0 15 0 0 0 83 101 116 32 97 115 32 38 100 101 102 97 117 108 116 1 0 0 0 0 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 26 0 0 0 109 111 118 101 83 101 108 101 99 116 101 100 80 97 99 107 97 103 101 84 111 70 114 111 110 116 146 0 0 0 14 0 0 0 38 77 111 118 101 32 116 111 32 102 114 111 110 116 1 0 0 0 0 0 0 0 98 14 0 0 0 0 0 0 1 16 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 11 0 0 0 115 97 118 101 80 97 99 107 97 103 101 146 0 0 0 13 0 0 0 38 83 97 118 101 32 112 97 99 107 97 103 101 1 0 0 0 0 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 13 0 0 0 115 97 118 101 80 97 99 107 97 103 101 65 115 146 0 0 0 19 0 0 0 83 97 118 101 32 112 97 99 107 97 103 101 32 38 97 115 46 46 46 1 0 0 0 0 0 0 0 98 14 0 0 0 0 0 0 1 16 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 26 0 0 0 100 111 110 116 83 97 118 101 80 97 99 107 97 103 101 87 105 116 104 80 114 111 106 101 99 116 146 0 0 0 24 0 0 0 68 111 110 39 116 32 115 97 118 101 32 119 105 116 104 32 112 114 111 38 106 101 99 116 1 0 0 0 0 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 21 0 0 0 103 101 110 101 114 97 116 101 68 111 99 117 109 101 110 116 97 116 105 111 110 146 0 0 0 26 0 0 0 38 71 101 110 101 114 97 116 101 32 100 111 99 117 109 101 110 116 97 116 105 111 110 46 46 46 1 0 0 0 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 4 0 0 0 244 100 227 119 208 11 0 0 1 0 0 0 32 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 15 1 0 0 240 23 0 0 210 2 0 0 0 0 0 0 112 12 0 0 194 0 0 0 1 0 0 0 96 24 0 0 240 23 0 0 210 2 0 0 0 0 0 0 176 12 0 0 194 0 0 0 1 0 0 0 1 0 0 0 240 23 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 120 2 0 0 135 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 146 0 0 0 11 0 0 0 112 97 99 107 97 103 101 76 105 115 116 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 51 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 49 3 0 0 224 7 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 25 0 0 0 120 2 0 0 177 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 240 23 0 0 208 22 0 0 128 8 0 0 16 5 0 0 0 0 0 0 19 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 194 0 0 0 2 0 0 0 16 6 0 0 146 0 0 0 6 0 0 0 115 116 97 116 117 115 0 0 0 0 70 5 7 0 2 0 0 0 77 101 110 117 66 97 114 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 1 0 0 0 34 10 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 10 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 160 24 0 0 146 0 0 0 19 0 0 0 38 73 110 115 116 97 108 108 32 112 97 99 107 97 103 101 46 46 46 1 0 0 0 0 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 240 24 0 0 146 0 0 0 15 0 0 0 38 78 101 119 32 112 97 99 107 97 103 101 46 46 46 1 0 0 0 0 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 144 25 0 0 146 0 0 0 15 0 0 0 83 101 116 32 97 115 32 38 100 101 102 97 117 108 116 1 0 0 0 0 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 224 25 0 0 146 0 0 0 14 0 0 0 38 77 111 118 101 32 116 111 32 102 114 111 110 116 1 0 0 0 0 0 0 0 98 14 0 0 0 0 0 0 1 16 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 64 26 0 0 146 0 0 0 13 0 0 0 38 83 97 118 101 32 112 97 99 107 97 103 101 1 0 0 0 0 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 144 26 0 0 146 0 0 0 19 0 0 0 83 97 118 101 32 112 97 99 107 97 103 101 32 38 97 115 46 46 46 1 0 0 0 0 0 0 0 98 14 0 0 0 0 0 0 1 16 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 240 26 0 0 146 0 0 0 24 0 0 0 68 111 110 39 116 32 115 97 118 101 32 119 105 116 104 32 112 114 111 38 106 101 99 116 1 0 0 0 0 0 0 0 82 10 0 0 0 0 0 0 1 0 0 0 114 10 0 0 0 0 0 0 64 27 0 0 146 0 0 0 26 0 0 0 38 71 101 110 101 114 97 116 101 32 100 111 99 117 109 101 110 116 97 116 105 111 110 46 46 46 1 0 0 0 0 0 0 0 146 0 0 0 8 0 0 0 38 80 97 99 107 97 103 101 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 11 0 0 0 11 0 0 0 242 0 0 0 0 0 0 0 1 5 0 0 193 3 0 0 96 0 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 5 0 0 0 116 101 120 116 58 194 0 0 0 1 0 0 0 146 0 0 0 15 0 0 0 80 97 99 107 97 103 101 32 66 114 111 119 115 101 114 96 0 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 8 0 0 0 109 101 110 117 66 97 114 58 194 0 0 0 1 0 0 0 112 29 0 0 96 0 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 5 0 0 0 133 2 0 0 229 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 16 6 0 0 224 7 0 0 48 1 0 0 16 5 0 0 0 0 0 0 19 0 0 0 70 5 4 0 3 0 0 0 73 99 111 110 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 18 1 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 18 1 0 0 7 0 0 0 99 117 114 114 101 110 116 18 1 0 0 13 0 0 0 83 104 101 108 108 86 105 101 119 46 105 99 111 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 18 1 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0])!

(ResourceIdentifier class: PstSourceCodePresenter name: 'Workspace view') assign: (Object fromBinaryStoreBytes:
#[33 83 84 66 32 48 32 70 2 12 0 1 0 0 0 86 105 101 119 82 101 115 111 117 114 99 101 0 0 0 0 14 1 36 0 83 84 66 82 101 115 111 117 114 99 101 83 84 66 66 121 116 101 65 114 114 97 121 65 99 99 101 115 115 111 114 80 114 111 120 121 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 176 6 0 0 33 83 84 66 32 48 32 78 8 12 0 10 0 0 0 83 84 66 86 105 101 119 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 146 0 0 0 12 0 0 0 82 105 99 104 84 101 120 116 69 100 105 116 38 0 5 0 65 114 114 97 121 18 0 0 0 0 0 0 0 0 0 0 0 194 0 0 0 2 0 0 0 54 0 12 0 76 97 114 103 101 73 110 116 101 103 101 114 4 0 0 0 68 17 33 68 1 4 0 0 96 0 0 0 0 0 0 0 6 3 3 0 82 71 66 0 0 0 0 181 1 0 0 215 1 0 0 209 1 0 0 0 0 0 0 7 0 0 0 70 5 4 0 2 0 0 0 77 101 110 117 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 10 0 0 0 70 2 15 0 1 0 0 0 67 111 109 109 97 110 100 77 101 110 117 73 116 101 109 0 0 0 0 1 0 0 0 70 4 18 0 2 0 0 0 67 111 109 109 97 110 100 68 101 115 99 114 105 112 116 105 111 110 0 0 0 0 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 146 0 0 0 6 0 0 0 97 99 99 101 112 116 146 0 0 0 7 0 0 0 38 65 99 99 101 112 116 167 32 0 0 0 0 0 0 70 1 15 0 1 0 0 0 68 105 118 105 100 101 114 77 101 110 117 73 116 101 109 0 0 0 0 1 16 0 0 98 1 0 0 0 0 0 0 1 0 0 0 130 1 0 0 0 0 0 0 170 1 0 0 0 0 0 0 146 0 0 0 12 0 0 0 99 117 116 83 101 108 101 99 116 105 111 110 146 0 0 0 4 0 0 0 67 117 38 116 177 32 0 0 0 0 0 0 98 1 0 0 0 0 0 0 1 0 0 0 130 1 0 0 0 0 0 0 170 1 0 0 0 0 0 0 146 0 0 0 13 0 0 0 99 111 112 121 83 101 108 101 99 116 105 111 110 146 0 0 0 5 0 0 0 38 67 111 112 121 135 32 0 0 0 0 0 0 98 1 0 0 0 0 0 0 1 0 0 0 130 1 0 0 0 0 0 0 170 1 0 0 0 0 0 0 146 0 0 0 14 0 0 0 112 97 115 116 101 67 108 105 112 98 111 97 114 100 146 0 0 0 6 0 0 0 38 80 97 115 116 101 173 32 0 0 0 0 0 0 98 1 0 0 0 0 0 0 1 0 0 0 130 1 0 0 0 0 0 0 170 1 0 0 0 0 0 0 146 0 0 0 14 0 0 0 99 108 101 97 114 83 101 108 101 99 116 105 111 110 146 0 0 0 7 0 0 0 68 101 38 108 101 116 101 93 2 0 0 0 0 0 0 240 1 0 0 98 1 0 0 0 0 0 0 1 0 0 0 130 1 0 0 0 0 0 0 170 1 0 0 0 0 0 0 146 0 0 0 4 0 0 0 100 111 73 116 146 0 0 0 6 0 0 0 38 68 111 32 105 116 139 32 0 0 0 0 0 0 98 1 0 0 0 0 0 0 1 0 0 0 130 1 0 0 0 0 0 0 170 1 0 0 0 0 0 0 146 0 0 0 7 0 0 0 112 114 105 110 116 73 116 146 0 0 0 9 0 0 0 80 38 114 105 110 116 32 105 116 137 32 0 0 0 0 0 0 98 1 0 0 0 0 0 0 1 0 0 0 130 1 0 0 0 0 0 0 170 1 0 0 0 0 0 0 146 0 0 0 9 0 0 0 105 110 115 112 101 99 116 73 116 146 0 0 0 11 0 0 0 38 73 110 115 112 101 99 116 32 105 116 147 32 0 0 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 242 0 0 0 4 0 0 0 211 16 46 119 6 2 13 0 78 117 108 108 67 111 110 118 101 114 116 101 114 0 0 0 0 0 0 0 0 0 0 0 0 9 0 0 0 0 0 0 0 6 1 10 0 69 68 73 84 83 84 82 69 65 77 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 12 0 0 0 0 0 0 0 0 0 0 0 164 216 232 8 6 1 15 0 77 101 115 115 97 103 101 83 101 113 117 101 110 99 101 0 0 0 0 14 2 18 0 83 84 66 67 111 108 108 101 99 116 105 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 79 114 100 101 114 101 100 67 111 108 108 101 99 116 105 111 110 194 0 0 0 6 0 0 0 6 3 11 0 77 101 115 115 97 103 101 83 101 110 100 0 0 0 0 170 1 0 0 0 0 0 0 146 0 0 0 16 0 0 0 99 114 101 97 116 101 65 116 58 101 120 116 101 110 116 58 194 0 0 0 2 0 0 0 6 2 5 0 80 111 105 110 116 0 0 0 0 11 0 0 0 11 0 0 0 114 5 0 0 0 0 0 0 145 1 0 0 161 0 0 0 96 0 0 0 34 5 0 0 0 0 0 0 170 1 0 0 0 0 0 0 146 0 0 0 12 0 0 0 99 111 110 116 101 120 116 77 101 110 117 58 194 0 0 0 1 0 0 0 64 1 0 0 96 0 0 0 34 5 0 0 0 0 0 0 170 1 0 0 0 0 0 0 146 0 0 0 5 0 0 0 116 101 120 116 58 194 0 0 0 1 0 0 0 6 1 8 0 82 105 99 104 84 101 120 116 0 0 0 0 146 0 0 0 108 0 0 0 123 92 114 116 102 49 92 97 110 115 105 92 100 101 102 102 48 92 100 101 102 108 97 110 103 50 48 53 55 123 92 102 111 110 116 116 98 108 123 92 102 48 92 102 114 111 109 97 110 32 84 105 109 101 115 32 78 101 119 32 82 111 109 97 110 59 125 125 13 10 92 118 105 101 119 107 105 110 100 52 92 117 99 49 92 112 97 114 100 92 102 48 92 102 115 50 50 32 13 10 92 112 97 114 32 125 13 10 96 0 0 0 34 5 0 0 0 0 0 0 170 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 115 101 108 101 99 116 105 111 110 82 97 110 103 101 58 194 0 0 0 1 0 0 0 6 3 8 0 73 110 116 101 114 118 97 108 0 0 0 0 3 0 0 0 1 0 0 0 3 0 0 0 96 0 0 0 34 5 0 0 0 0 0 0 170 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 105 115 84 101 120 116 77 111 100 105 102 105 101 100 58 194 0 0 0 1 0 0 0 32 0 0 0 96 0 0 0 34 5 0 0 0 0 0 0 170 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 114 101 115 101 116 67 104 97 114 70 111 114 109 97 116 194 0 0 0 0 0 0 0 96 0 0 0 6 1 15 0 87 73 78 68 79 87 80 76 65 67 69 77 69 78 84 0 0 0 0 146 4 0 0 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 5 0 0 0 205 0 0 0 85 0 0 0 218 4 0 0 0 0 0 0 240 4 0 0 194 0 0 0 0 0 0 0 114 5 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 19 0 0 0 70 5 4 0 3 0 0 0 73 99 111 110 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 18 1 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 18 1 0 0 7 0 0 0 99 117 114 114 101 110 116 18 1 0 0 12 0 0 0 84 101 120 116 69 100 105 116 46 105 99 111 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 18 1 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0])!

(ResourceIdentifier class: PstSystrapBrowser name: 'Default view') assign: (Object fromBinaryStoreBytes:
#[33 83 84 66 32 48 32 70 2 12 0 1 0 0 0 86 105 101 119 82 101 115 111 117 114 99 101 0 0 0 0 14 1 36 0 83 84 66 82 101 115 111 117 114 99 101 83 84 66 66 121 116 101 65 114 114 97 121 65 99 99 101 115 115 111 114 80 114 111 120 121 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 147 13 0 0 33 83 84 66 32 48 32 78 8 12 0 10 0 0 0 83 84 66 86 105 101 119 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 146 0 0 0 9 0 0 0 83 104 101 108 108 86 105 101 119 38 0 5 0 65 114 114 97 121 24 0 0 0 0 0 0 0 0 0 0 0 194 0 0 0 2 0 0 0 1 0 158 1 1 0 2 0 96 0 0 0 0 0 0 0 0 0 0 0 6 2 5 0 80 111 105 110 116 0 0 0 0 1 5 0 0 193 3 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 7 12 0 66 111 114 100 101 114 76 97 121 111 117 116 0 0 0 0 1 0 0 0 1 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 13 0 0 0 67 111 110 116 97 105 110 101 114 86 105 101 119 194 0 0 0 15 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 54 0 12 0 76 97 114 103 101 73 110 116 101 103 101 114 4 0 0 0 0 0 0 68 1 0 2 0 48 1 0 0 0 0 0 0 6 1 11 0 83 121 115 116 101 109 67 111 108 111 114 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 3 10 0 70 108 111 119 76 97 121 111 117 116 0 0 0 0 1 0 0 0 1 0 0 0 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 146 0 0 0 4 0 0 0 108 101 102 116 14 2 26 0 83 84 66 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 18 0 0 0 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 194 0 0 0 0 0 0 0 0 0 0 0 6 1 15 0 77 101 115 115 97 103 101 83 101 113 117 101 110 99 101 0 0 0 0 14 2 18 0 83 84 66 67 111 108 108 101 99 116 105 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 79 114 100 101 114 101 100 67 111 108 108 101 99 116 105 111 110 194 0 0 0 1 0 0 0 6 3 11 0 77 101 115 115 97 103 101 83 101 110 100 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 16 0 0 0 99 114 101 97 116 101 65 116 58 101 120 116 101 110 116 58 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 51 0 0 0 48 1 0 0 6 1 15 0 87 73 78 68 79 87 80 76 65 67 69 77 69 78 84 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 120 2 0 0 25 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 2 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 13 0 0 0 82 101 102 101 114 101 110 99 101 86 105 101 119 194 0 0 0 14 0 0 0 0 0 0 0 48 1 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 160 3 0 0 0 0 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 2 18 0 82 101 115 111 117 114 99 101 73 100 101 110 116 105 102 105 101 114 0 0 0 0 122 0 0 0 0 0 0 0 146 0 0 0 3 0 0 0 112 115 116 146 0 0 0 10 0 0 0 80 115 116 84 111 111 108 98 97 114 146 0 0 0 16 0 0 0 80 115 116 73 109 97 103 101 32 84 111 111 108 98 97 114 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 63 0 0 0 51 0 0 0 160 3 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 31 0 0 0 25 0 0 0 194 0 0 0 0 0 0 0 242 0 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 176 3 0 0 194 0 0 0 14 0 0 0 0 0 0 0 48 1 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 32 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18 4 0 0 0 0 0 0 48 4 0 0 146 0 0 0 16 0 0 0 80 115 116 84 111 111 108 115 32 84 111 111 108 98 97 114 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 63 0 0 0 1 0 0 0 242 0 0 0 0 0 0 0 247 0 0 0 51 0 0 0 32 5 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 31 0 0 0 0 0 0 0 154 0 0 0 25 0 0 0 0 5 0 0 16 5 0 0 0 0 0 0 19 0 0 0 16 5 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 9 0 0 0 83 116 97 116 117 115 66 97 114 194 0 0 0 18 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 4 1 0 68 1 0 0 0 16 6 0 0 0 0 0 0 162 1 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 6 4 4 0 70 111 110 116 0 0 0 0 0 0 0 0 16 0 0 0 6 1 7 0 76 79 71 70 79 78 84 0 0 0 0 98 3 0 0 60 0 0 0 243 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 144 1 0 0 0 0 0 0 3 2 1 34 65 114 105 97 108 0 31 5 20 135 63 1 0 0 204 53 63 1 3 0 20 59 0 0 0 0 247 0 5 86 111 1 242 0 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 8 0 0 0 39 2 255 255 0 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 80 2 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 6 4 17 0 83 116 97 116 117 115 66 97 114 78 117 108 108 73 116 101 109 0 0 0 0 1 2 0 0 1 0 0 0 16 6 0 0 0 0 0 0 48 7 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 95 3 0 0 242 0 0 0 0 0 0 0 241 4 0 0 45 0 0 0 16 6 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 175 1 0 0 120 2 0 0 197 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 19 0 0 0 0 0 0 0 0 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 8 0 0 0 76 105 115 116 86 105 101 119 194 0 0 0 28 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 130 1 0 0 4 0 0 0 77 16 1 68 1 4 0 0 224 7 0 0 70 3 9 0 2 0 0 0 76 105 115 116 77 111 100 101 108 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 0 0 0 0 6 0 20 0 73 100 101 110 116 105 116 121 83 101 97 114 99 104 80 111 108 105 99 121 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 70 5 4 0 2 0 0 0 77 101 110 117 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 1 0 0 0 70 2 15 0 1 0 0 0 67 111 109 109 97 110 100 77 101 110 117 73 116 101 109 0 0 0 0 1 0 0 0 70 4 18 0 2 0 0 0 67 111 109 109 97 110 100 68 101 115 99 114 105 112 116 105 111 110 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 11 0 0 0 102 105 110 100 83 121 115 116 114 97 112 146 0 0 0 8 0 0 0 38 70 105 110 100 46 46 46 1 0 0 0 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 130 1 0 0 8 0 0 0 153 0 255 255 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 66 97 115 105 99 76 105 115 116 65 98 115 116 114 97 99 116 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 18 0 0 0 73 99 111 110 105 99 76 105 115 116 65 98 115 116 114 97 99 116 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 16 0 0 0 73 99 111 110 73 109 97 103 101 77 97 110 97 103 101 114 234 1 0 0 0 0 0 0 146 0 0 0 7 0 0 0 99 117 114 114 101 110 116 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 70 12 14 0 4 0 0 0 76 105 115 116 86 105 101 119 67 111 108 117 109 110 0 0 0 0 146 0 0 0 6 0 0 0 84 114 97 112 32 35 201 0 0 0 240 1 0 0 80 9 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 16 0 0 0 83 111 114 116 101 100 67 111 108 108 101 99 116 105 111 110 6 2 7 0 77 101 115 115 97 103 101 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 8 0 0 0 121 111 117 114 115 101 108 102 194 0 0 0 0 0 0 0 0 0 0 0 224 7 0 0 0 0 0 0 32 0 0 0 0 0 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 1 0 0 0 242 9 0 0 0 0 0 0 146 0 0 0 9 0 0 0 80 114 111 116 111 116 121 112 101 201 0 0 0 240 1 0 0 80 9 0 0 32 10 0 0 66 10 0 0 0 0 0 0 96 10 0 0 194 0 0 0 0 0 0 0 0 0 0 0 224 7 0 0 0 0 0 0 32 0 0 0 0 0 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 6 0 0 0 114 101 112 111 114 116 1 0 0 0 0 0 0 0 97 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 1 0 0 0 51 0 0 0 242 0 0 0 0 0 0 0 241 4 0 0 45 3 0 0 224 7 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 12 0 0 0 99 111 110 116 101 120 116 77 101 110 117 58 194 0 0 0 1 0 0 0 160 8 0 0 224 7 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 5 0 0 0 116 101 120 116 58 194 0 0 0 1 0 0 0 146 0 0 0 6 0 0 0 84 114 97 112 32 35 224 7 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 25 0 0 0 120 2 0 0 175 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 80 2 0 0 16 5 0 0 0 0 0 0 21 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 194 0 0 0 2 0 0 0 224 7 0 0 146 0 0 0 5 0 0 0 116 114 97 112 115 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 98 2 0 0 0 0 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 210 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 242 0 0 0 0 0 0 0 11 0 0 0 11 0 0 0 242 0 0 0 0 0 0 0 1 5 0 0 193 3 0 0 96 0 0 0 210 2 0 0 0 0 0 0 208 11 0 0 194 0 0 0 1 0 0 0 146 0 0 0 15 0 0 0 83 121 115 116 114 97 112 32 66 114 111 119 115 101 114 96 0 0 0 210 2 0 0 0 0 0 0 234 1 0 0 0 0 0 0 146 0 0 0 8 0 0 0 109 101 110 117 66 97 114 58 194 0 0 0 1 0 0 0 0 0 0 0 96 0 0 0 66 3 0 0 0 0 0 0 98 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 5 0 0 0 133 2 0 0 229 1 0 0 138 2 0 0 0 0 0 0 160 2 0 0 194 0 0 0 3 0 0 0 16 6 0 0 224 7 0 0 48 1 0 0 16 5 0 0 0 0 0 0 19 0 0 0 70 5 4 0 3 0 0 0 73 99 111 110 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 18 1 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 18 1 0 0 7 0 0 0 99 117 114 114 101 110 116 18 1 0 0 13 0 0 0 83 104 101 108 108 86 105 101 119 46 105 99 111 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 18 1 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0])!

(ResourceIdentifier class: PstToolbar name: 'PstDebugger Toolbar') assign: (Object fromBinaryStoreBytes:
#[33 83 84 66 32 48 32 70 2 12 0 1 0 0 0 86 105 101 119 82 101 115 111 117 114 99 101 0 0 0 0 14 1 36 0 83 84 66 82 101 115 111 117 114 99 101 83 84 66 66 121 116 101 65 114 114 97 121 65 99 99 101 115 115 111 114 80 114 111 120 121 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 169 5 0 0 33 83 84 66 32 48 32 78 8 12 0 10 0 0 0 83 84 66 86 105 101 119 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 146 0 0 0 7 0 0 0 84 111 111 108 98 97 114 38 0 5 0 65 114 114 97 121 25 0 0 0 0 0 0 0 0 0 0 0 194 0 0 0 2 0 0 0 54 0 12 0 76 97 114 103 101 73 110 116 101 103 101 114 4 0 0 0 100 11 0 68 1 0 2 0 96 0 0 0 0 0 0 0 6 1 11 0 83 121 115 116 101 109 67 111 108 111 114 0 0 0 0 31 0 0 0 0 0 0 0 7 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 242 0 0 0 8 0 0 0 15 1 255 255 0 0 0 0 14 2 26 0 83 84 66 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 18 0 0 0 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 194 0 0 0 0 0 0 0 74 1 0 0 0 0 0 0 96 1 0 0 194 0 0 0 6 0 0 0 245 69 0 0 6 7 13 0 84 111 111 108 98 97 114 66 117 116 116 111 110 0 0 0 0 245 69 0 0 0 0 0 0 96 0 0 0 1 0 0 0 70 4 18 0 2 0 0 0 67 111 109 109 97 110 100 68 101 115 99 114 105 112 116 105 111 110 0 0 0 0 0 0 0 0 146 0 0 0 2 0 0 0 71 111 1 0 0 0 0 0 0 0 70 8 6 0 3 0 0 0 66 105 116 109 97 112 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 146 0 0 0 7 0 0 0 99 117 114 114 101 110 116 146 0 0 0 9 0 0 0 84 111 111 108 115 46 98 109 112 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 146 0 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0 0 0 0 0 7 0 0 0 6 2 5 0 80 111 105 110 116 0 0 0 0 97 5 0 0 33 0 0 0 51 0 0 0 241 69 0 0 178 1 0 0 0 0 0 0 241 69 0 0 0 0 0 0 96 0 0 0 1 0 0 0 210 1 0 0 0 0 0 0 106 2 0 0 0 0 0 0 146 0 0 0 10 0 0 0 115 105 110 103 108 101 83 116 101 112 146 0 0 0 9 0 0 0 83 116 101 112 32 73 110 116 111 1 0 0 0 0 0 0 0 2 2 0 0 0 0 0 0 0 0 0 0 16 0 0 0 48 2 0 0 146 0 0 0 9 0 0 0 84 111 111 108 115 46 98 109 112 176 2 0 0 0 0 0 0 7 0 0 0 210 2 0 0 0 0 0 0 97 5 0 0 33 0 0 0 43 0 0 0 243 69 0 0 178 1 0 0 0 0 0 0 243 69 0 0 0 0 0 0 96 0 0 0 1 0 0 0 210 1 0 0 0 0 0 0 106 2 0 0 0 0 0 0 146 0 0 0 8 0 0 0 115 116 101 112 73 110 116 111 146 0 0 0 9 0 0 0 83 116 101 112 32 79 118 101 114 1 0 0 0 0 0 0 0 16 2 0 0 45 0 0 0 194 0 0 0 4 0 0 0 240 2 0 0 112 3 0 0 192 1 0 0 6 6 16 0 84 111 111 108 98 97 114 83 101 112 97 114 97 116 111 114 0 0 0 0 0 0 0 0 0 0 0 0 96 0 0 0 3 0 0 0 0 0 0 0 1 0 0 0 74 1 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 11 0 0 0 76 111 111 107 117 112 84 97 98 108 101 194 0 0 0 2 0 0 0 64 3 0 0 1 0 0 0 0 0 0 0 32 0 0 0 0 0 0 0 210 2 0 0 0 0 0 0 33 0 0 0 31 0 0 0 210 2 0 0 0 0 0 0 45 0 0 0 45 0 0 0 0 0 0 0 0 0 0 0 6 1 15 0 77 101 115 115 97 103 101 83 101 113 117 101 110 99 101 0 0 0 0 14 2 18 0 83 84 66 67 111 108 108 101 99 116 105 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 79 114 100 101 114 101 100 67 111 108 108 101 99 116 105 111 110 194 0 0 0 2 0 0 0 6 3 11 0 77 101 115 115 97 103 101 83 101 110 100 0 0 0 0 106 2 0 0 0 0 0 0 146 0 0 0 16 0 0 0 99 114 101 97 116 101 65 116 58 101 120 116 101 110 116 58 194 0 0 0 2 0 0 0 210 2 0 0 0 0 0 0 11 0 0 0 11 0 0 0 210 2 0 0 0 0 0 0 251 0 0 0 51 0 0 0 96 0 0 0 194 4 0 0 0 0 0 0 106 2 0 0 0 0 0 0 146 0 0 0 10 0 0 0 117 112 100 97 116 101 83 105 122 101 194 0 0 0 0 0 0 0 96 0 0 0 6 1 15 0 87 73 78 68 79 87 80 76 65 67 69 77 69 78 84 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 5 0 0 0 130 0 0 0 30 0 0 0 122 4 0 0 0 0 0 0 144 4 0 0 128 1 0 0 210 2 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 19 0 0 0 70 5 4 0 3 0 0 0 73 99 111 110 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 18 1 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 18 1 0 0 7 0 0 0 99 117 114 114 101 110 116 18 1 0 0 22 0 0 0 67 111 110 116 114 111 108 66 97 114 65 98 115 116 114 97 99 116 46 105 99 111 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 18 1 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0])!

(ResourceIdentifier class: PstToolbar name: 'PstEditTools Toolbar') assign: (Object fromBinaryStoreBytes:
#[33 83 84 66 32 48 32 70 2 12 0 1 0 0 0 86 105 101 119 82 101 115 111 117 114 99 101 0 0 0 0 14 1 36 0 83 84 66 82 101 115 111 117 114 99 101 83 84 66 66 121 116 101 65 114 114 97 121 65 99 99 101 115 115 111 114 80 114 111 120 121 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 162 7 0 0 33 83 84 66 32 48 32 78 8 12 0 10 0 0 0 83 84 66 86 105 101 119 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 146 0 0 0 7 0 0 0 84 111 111 108 98 97 114 38 0 5 0 65 114 114 97 121 25 0 0 0 0 0 0 0 0 0 0 0 194 0 0 0 2 0 0 0 54 0 12 0 76 97 114 103 101 73 110 116 101 103 101 114 4 0 0 0 100 11 0 68 1 0 2 0 96 0 0 0 0 0 0 0 6 1 11 0 83 121 115 116 101 109 67 111 108 111 114 0 0 0 0 31 0 0 0 0 0 0 0 7 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 242 0 0 0 8 0 0 0 15 1 255 255 0 0 0 0 14 2 26 0 83 84 66 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 18 0 0 0 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 194 0 0 0 2 0 0 0 82 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 8 0 0 0 67 111 109 98 111 66 111 120 194 0 0 0 17 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 242 0 0 0 4 0 0 0 3 6 49 68 1 4 0 0 144 1 0 0 70 3 9 0 2 0 0 0 76 105 115 116 77 111 100 101 108 0 0 0 0 14 2 18 0 83 84 66 67 111 108 108 101 99 116 105 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 79 114 100 101 114 101 100 67 111 108 108 101 99 116 105 111 110 194 0 0 0 0 0 0 0 0 0 0 0 6 0 20 0 73 100 101 110 116 105 116 121 83 101 97 114 99 104 80 111 108 105 99 121 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 6 4 4 0 70 111 110 116 0 0 0 0 0 0 0 0 16 0 0 0 6 1 7 0 76 79 71 70 79 78 84 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 60 0 0 0 245 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 144 1 0 0 0 0 0 0 3 2 1 34 65 114 105 97 108 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 2 5 0 80 111 105 110 116 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 242 0 0 0 4 0 0 0 206 70 231 119 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 66 97 115 105 99 76 105 115 116 65 98 115 116 114 97 99 116 1 0 0 0 233 3 0 0 6 1 15 0 77 101 115 115 97 103 101 83 101 113 117 101 110 99 101 0 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 194 0 0 0 1 0 0 0 6 3 11 0 77 101 115 115 97 103 101 83 101 110 100 0 0 0 0 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 146 0 0 0 16 0 0 0 99 114 101 97 116 101 65 116 58 101 120 116 101 110 116 58 194 0 0 0 2 0 0 0 226 2 0 0 0 0 0 0 1 0 0 0 1 0 0 0 226 2 0 0 0 0 0 0 251 0 0 0 45 0 0 0 144 1 0 0 6 1 15 0 87 73 78 68 79 87 80 76 65 67 69 77 69 78 84 0 0 0 0 194 2 0 0 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 125 0 0 0 22 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 80 2 0 0 226 2 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 19 0 0 0 146 0 0 0 8 0 0 0 112 97 99 107 97 103 101 115 74 1 0 0 0 0 0 0 96 1 0 0 194 0 0 0 10 0 0 0 91 69 0 0 6 7 19 0 84 111 111 108 98 97 114 83 121 115 116 101 109 66 117 116 116 111 110 0 0 0 0 91 69 0 0 0 0 0 0 96 0 0 0 1 0 0 0 70 4 18 0 2 0 0 0 67 111 109 109 97 110 100 68 101 115 99 114 105 112 116 105 111 110 0 0 0 0 154 3 0 0 0 0 0 0 146 0 0 0 4 0 0 0 117 110 100 111 146 0 0 0 4 0 0 0 85 110 100 111 1 0 0 0 0 0 0 0 1 0 0 0 7 0 0 0 83 69 0 0 114 4 0 0 0 0 0 0 83 69 0 0 0 0 0 0 96 0 0 0 1 0 0 0 146 4 0 0 0 0 0 0 154 3 0 0 0 0 0 0 146 0 0 0 12 0 0 0 99 117 116 83 101 108 101 99 116 105 111 110 146 0 0 0 3 0 0 0 67 117 116 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 85 69 0 0 114 4 0 0 0 0 0 0 85 69 0 0 0 0 0 0 96 0 0 0 1 0 0 0 146 4 0 0 0 0 0 0 154 3 0 0 0 0 0 0 146 0 0 0 13 0 0 0 99 111 112 121 83 101 108 101 99 116 105 111 110 146 0 0 0 4 0 0 0 67 111 112 121 1 0 0 0 0 0 0 0 1 0 0 0 3 0 0 0 87 69 0 0 114 4 0 0 0 0 0 0 87 69 0 0 0 0 0 0 96 0 0 0 1 0 0 0 146 4 0 0 0 0 0 0 154 3 0 0 0 0 0 0 146 0 0 0 14 0 0 0 112 97 115 116 101 67 108 105 112 98 111 97 114 100 146 0 0 0 5 0 0 0 80 97 115 116 101 1 0 0 0 0 0 0 0 1 0 0 0 5 0 0 0 89 69 0 0 114 4 0 0 0 0 0 0 89 69 0 0 0 0 0 0 96 0 0 0 1 0 0 0 146 4 0 0 0 0 0 0 154 3 0 0 0 0 0 0 146 0 0 0 14 0 0 0 99 108 101 97 114 83 101 108 101 99 116 105 111 110 146 0 0 0 6 0 0 0 68 101 108 101 116 101 1 0 0 0 0 0 0 0 1 0 0 0 11 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 194 0 0 0 6 0 0 0 224 4 0 0 48 5 0 0 128 5 0 0 208 5 0 0 128 4 0 0 6 6 16 0 84 111 111 108 98 97 114 83 101 112 97 114 97 116 111 114 0 0 0 0 0 0 0 0 0 0 0 0 96 0 0 0 3 0 0 0 0 0 0 0 1 0 0 0 74 1 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 11 0 0 0 76 111 111 107 117 112 84 97 98 108 101 194 0 0 0 2 0 0 0 1 0 0 0 1 0 0 0 0 0 0 0 32 0 0 0 0 0 0 0 226 2 0 0 0 0 0 0 33 0 0 0 31 0 0 0 226 2 0 0 0 0 0 0 45 0 0 0 45 0 0 0 0 0 0 0 0 0 0 0 50 3 0 0 0 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 194 0 0 0 2 0 0 0 114 3 0 0 0 0 0 0 160 3 0 0 194 0 0 0 2 0 0 0 226 2 0 0 0 0 0 0 11 0 0 0 11 0 0 0 226 2 0 0 0 0 0 0 241 0 0 0 51 0 0 0 96 0 0 0 114 3 0 0 0 0 0 0 154 3 0 0 0 0 0 0 146 0 0 0 10 0 0 0 117 112 100 97 116 101 83 105 122 101 194 0 0 0 0 0 0 0 96 0 0 0 242 3 0 0 0 0 0 0 194 2 0 0 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 5 0 0 0 125 0 0 0 30 0 0 0 26 2 0 0 0 0 0 0 48 2 0 0 80 2 0 0 226 2 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 19 0 0 0 70 5 4 0 3 0 0 0 73 99 111 110 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 18 1 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 18 1 0 0 7 0 0 0 99 117 114 114 101 110 116 18 1 0 0 22 0 0 0 67 111 110 116 114 111 108 66 97 114 65 98 115 116 114 97 99 116 46 105 99 111 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 18 1 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0])!

(ResourceIdentifier class: PstToolbar name: 'PstFileTools Toolbar') assign: (Object fromBinaryStoreBytes:
#[33 83 84 66 32 48 32 70 2 12 0 1 0 0 0 86 105 101 119 82 101 115 111 117 114 99 101 0 0 0 0 14 1 36 0 83 84 66 82 101 115 111 117 114 99 101 83 84 66 66 121 116 101 65 114 114 97 121 65 99 99 101 115 115 111 114 80 114 111 120 121 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 189 4 0 0 33 83 84 66 32 48 32 78 8 12 0 10 0 0 0 83 84 66 86 105 101 119 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 146 0 0 0 7 0 0 0 84 111 111 108 98 97 114 38 0 5 0 65 114 114 97 121 25 0 0 0 0 0 0 0 0 0 0 0 194 0 0 0 2 0 0 0 54 0 12 0 76 97 114 103 101 73 110 116 101 103 101 114 4 0 0 0 100 11 0 68 1 0 2 0 96 0 0 0 0 0 0 0 6 1 11 0 83 121 115 116 101 109 67 111 108 111 114 0 0 0 0 31 0 0 0 0 0 0 0 7 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 242 0 0 0 8 0 0 0 15 1 255 255 0 0 0 0 14 2 26 0 83 84 66 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 18 0 0 0 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 194 0 0 0 0 0 0 0 74 1 0 0 0 0 0 0 96 1 0 0 194 0 0 0 6 0 0 0 185 68 0 0 6 7 19 0 84 111 111 108 98 97 114 83 121 115 116 101 109 66 117 116 116 111 110 0 0 0 0 185 68 0 0 0 0 0 0 96 0 0 0 1 0 0 0 70 4 18 0 2 0 0 0 67 111 109 109 97 110 100 68 101 115 99 114 105 112 116 105 111 110 0 0 0 0 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 146 0 0 0 14 0 0 0 116 111 111 108 98 97 114 70 105 108 101 78 101 119 146 0 0 0 3 0 0 0 78 101 119 1 0 0 0 0 0 0 0 1 0 0 0 13 0 0 0 187 68 0 0 178 1 0 0 0 0 0 0 187 68 0 0 0 0 0 0 96 0 0 0 1 0 0 0 210 1 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 116 111 111 108 98 97 114 70 105 108 101 79 112 101 110 146 0 0 0 4 0 0 0 79 112 101 110 1 0 0 0 0 0 0 0 1 0 0 0 15 0 0 0 189 68 0 0 178 1 0 0 0 0 0 0 189 68 0 0 0 0 0 0 96 0 0 0 1 0 0 0 210 1 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 116 111 111 108 98 97 114 70 105 108 101 83 97 118 101 146 0 0 0 4 0 0 0 83 97 118 101 1 0 0 0 0 0 0 0 1 0 0 0 17 0 0 0 14 2 18 0 83 84 66 67 111 108 108 101 99 116 105 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 79 114 100 101 114 101 100 67 111 108 108 101 99 116 105 111 110 194 0 0 0 4 0 0 0 192 1 0 0 48 2 0 0 128 2 0 0 6 6 16 0 84 111 111 108 98 97 114 83 101 112 97 114 97 116 111 114 0 0 0 0 0 0 0 0 0 0 0 0 96 0 0 0 3 0 0 0 0 0 0 0 1 0 0 0 74 1 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 11 0 0 0 76 111 111 107 117 112 84 97 98 108 101 194 0 0 0 2 0 0 0 1 0 0 0 1 0 0 0 0 0 0 0 32 0 0 0 0 0 0 0 6 2 5 0 80 111 105 110 116 0 0 0 0 33 0 0 0 31 0 0 0 130 3 0 0 0 0 0 0 45 0 0 0 45 0 0 0 0 0 0 0 0 0 0 0 6 1 15 0 77 101 115 115 97 103 101 83 101 113 117 101 110 99 101 0 0 0 0 218 2 0 0 0 0 0 0 240 2 0 0 194 0 0 0 2 0 0 0 6 3 11 0 77 101 115 115 97 103 101 83 101 110 100 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 16 0 0 0 99 114 101 97 116 101 65 116 58 101 120 116 101 110 116 58 194 0 0 0 2 0 0 0 130 3 0 0 0 0 0 0 11 0 0 0 11 0 0 0 130 3 0 0 0 0 0 0 151 0 0 0 51 0 0 0 96 0 0 0 242 3 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 10 0 0 0 117 112 100 97 116 101 83 105 122 101 194 0 0 0 0 0 0 0 96 0 0 0 6 1 15 0 87 73 78 68 79 87 80 76 65 67 69 77 69 78 84 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 5 0 0 0 80 0 0 0 30 0 0 0 218 2 0 0 0 0 0 0 240 2 0 0 128 1 0 0 130 3 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 19 0 0 0 70 5 4 0 3 0 0 0 73 99 111 110 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 18 1 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 18 1 0 0 7 0 0 0 99 117 114 114 101 110 116 18 1 0 0 22 0 0 0 67 111 110 116 114 111 108 66 97 114 65 98 115 116 114 97 99 116 46 105 99 111 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 18 1 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0])!

(ResourceIdentifier class: PstToolbar name: 'PstImage Toolbar') assign: (Object fromBinaryStoreBytes:
#[33 83 84 66 32 48 32 70 2 12 0 1 0 0 0 86 105 101 119 82 101 115 111 117 114 99 101 0 0 0 0 14 1 36 0 83 84 66 82 101 115 111 117 114 99 101 83 84 66 66 121 116 101 65 114 114 97 121 65 99 99 101 115 115 111 114 80 114 111 120 121 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 80 5 0 0 33 83 84 66 32 48 32 78 8 12 0 10 0 0 0 83 84 66 86 105 101 119 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 146 0 0 0 7 0 0 0 84 111 111 108 98 97 114 38 0 5 0 65 114 114 97 121 25 0 0 0 0 0 0 0 0 0 0 0 194 0 0 0 2 0 0 0 54 0 12 0 76 97 114 103 101 73 110 116 101 103 101 114 4 0 0 0 100 11 0 68 65 0 2 0 96 0 0 0 0 0 0 0 6 1 11 0 83 121 115 116 101 109 67 111 108 111 114 0 0 0 0 31 0 0 0 0 0 0 0 7 2 0 0 0 0 0 0 6 4 4 0 70 111 110 116 0 0 0 0 0 0 0 0 16 0 0 0 6 1 7 0 76 79 71 70 79 78 84 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 60 0 0 0 243 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 144 1 0 0 0 0 0 0 3 2 1 34 65 114 105 97 108 0 31 5 20 135 63 1 0 0 204 53 63 1 3 0 20 59 0 0 0 0 247 0 5 86 111 1 6 2 5 0 80 111 105 110 116 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 242 0 0 0 8 0 0 0 15 1 255 255 0 0 0 0 14 2 26 0 83 84 66 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 18 0 0 0 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 194 0 0 0 0 0 0 0 202 1 0 0 0 0 0 0 224 1 0 0 194 0 0 0 2 0 0 0 35 68 0 0 6 7 13 0 84 111 111 108 98 97 114 66 117 116 116 111 110 0 0 0 0 35 68 0 0 0 0 0 0 96 0 0 0 1 0 0 0 70 4 18 0 2 0 0 0 67 111 109 109 97 110 100 68 101 115 99 114 105 112 116 105 111 110 0 0 0 0 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 146 0 0 0 18 0 0 0 116 111 111 108 98 97 114 83 97 118 101 80 114 111 106 101 99 116 146 0 0 0 13 0 0 0 83 97 118 101 32 80 114 111 105 106 101 99 116 1 0 0 0 0 0 0 0 70 8 6 0 3 0 0 0 66 105 116 109 97 112 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 122 2 0 0 0 0 0 0 146 0 0 0 7 0 0 0 99 117 114 114 101 110 116 146 0 0 0 9 0 0 0 84 111 111 108 115 46 98 109 112 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 146 0 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0 0 0 0 0 7 0 0 0 146 1 0 0 0 0 0 0 97 5 0 0 33 0 0 0 27 0 0 0 14 2 18 0 83 84 66 67 111 108 108 101 99 116 105 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 79 114 100 101 114 101 100 67 111 108 108 101 99 116 105 111 110 194 0 0 0 2 0 0 0 64 2 0 0 6 6 16 0 84 111 111 108 98 97 114 83 101 112 97 114 97 116 111 114 0 0 0 0 0 0 0 0 0 0 0 0 96 0 0 0 3 0 0 0 0 0 0 0 1 0 0 0 202 1 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 11 0 0 0 76 111 111 107 117 112 84 97 98 108 101 194 0 0 0 2 0 0 0 192 2 0 0 1 0 0 0 0 0 0 0 32 0 0 0 0 0 0 0 146 1 0 0 0 0 0 0 33 0 0 0 31 0 0 0 146 1 0 0 0 0 0 0 45 0 0 0 45 0 0 0 0 0 0 0 0 0 0 0 6 1 15 0 77 101 115 115 97 103 101 83 101 113 117 101 110 99 101 0 0 0 0 138 3 0 0 0 0 0 0 160 3 0 0 194 0 0 0 2 0 0 0 6 3 11 0 77 101 115 115 97 103 101 83 101 110 100 0 0 0 0 122 2 0 0 0 0 0 0 146 0 0 0 16 0 0 0 99 114 101 97 116 101 65 116 58 101 120 116 101 110 116 58 194 0 0 0 2 0 0 0 146 1 0 0 0 0 0 0 11 0 0 0 11 0 0 0 146 1 0 0 0 0 0 0 61 0 0 0 51 0 0 0 96 0 0 0 146 4 0 0 0 0 0 0 122 2 0 0 0 0 0 0 146 0 0 0 10 0 0 0 117 112 100 97 116 101 83 105 122 101 194 0 0 0 0 0 0 0 96 0 0 0 6 1 15 0 87 73 78 68 79 87 80 76 65 67 69 77 69 78 84 0 0 0 0 114 1 0 0 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 5 0 0 0 35 0 0 0 30 0 0 0 138 3 0 0 0 0 0 0 160 3 0 0 0 2 0 0 146 1 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 19 0 0 0 70 5 4 0 3 0 0 0 73 99 111 110 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 18 1 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 18 1 0 0 7 0 0 0 99 117 114 114 101 110 116 18 1 0 0 22 0 0 0 67 111 110 116 114 111 108 66 97 114 65 98 115 116 114 97 99 116 46 105 99 111 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 18 1 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0])!

(ResourceIdentifier class: PstToolbar name: 'PstTools Toolbar') assign: (Object fromBinaryStoreBytes:
#[33 83 84 66 32 48 32 70 2 12 0 1 0 0 0 86 105 101 119 82 101 115 111 117 114 99 101 0 0 0 0 14 1 36 0 83 84 66 82 101 115 111 117 114 99 101 83 84 66 66 121 116 101 65 114 114 97 121 65 99 99 101 115 115 111 114 80 114 111 120 121 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 54 7 0 0 33 83 84 66 32 48 32 78 8 12 0 10 0 0 0 83 84 66 86 105 101 119 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 146 0 0 0 7 0 0 0 84 111 111 108 98 97 114 38 0 5 0 65 114 114 97 121 25 0 0 0 0 0 0 0 0 0 0 0 194 0 0 0 2 0 0 0 54 0 12 0 76 97 114 103 101 73 110 116 101 103 101 114 4 0 0 0 100 11 0 68 1 0 2 0 96 0 0 0 0 0 0 0 6 1 11 0 83 121 115 116 101 109 67 111 108 111 114 0 0 0 0 31 0 0 0 0 0 0 0 7 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 242 0 0 0 8 0 0 0 15 1 255 255 0 0 0 0 14 2 26 0 83 84 66 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 18 0 0 0 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 194 0 0 0 0 0 0 0 74 1 0 0 0 0 0 0 96 1 0 0 194 0 0 0 10 0 0 0 141 67 0 0 6 7 13 0 84 111 111 108 98 97 114 66 117 116 116 111 110 0 0 0 0 141 67 0 0 0 0 0 0 96 0 0 0 1 0 0 0 70 4 18 0 2 0 0 0 67 111 109 109 97 110 100 68 101 115 99 114 105 112 116 105 111 110 0 0 0 0 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 146 0 0 0 25 0 0 0 116 111 111 108 98 97 114 79 112 101 110 83 121 115 116 114 97 112 66 114 111 119 115 101 114 146 0 0 0 20 0 0 0 79 112 101 110 32 83 121 115 116 114 97 112 32 66 114 111 119 115 101 114 1 0 0 0 0 0 0 0 70 8 6 0 3 0 0 0 66 105 116 109 97 112 0 0 0 0 0 0 0 0 16 0 0 0 70 3 12 0 1 0 0 0 67 108 97 115 115 76 111 99 97 116 111 114 0 0 0 0 0 0 0 0 0 0 0 0 146 0 0 0 9 0 0 0 66 121 116 101 65 114 114 97 121 146 0 0 0 9 0 0 0 84 111 111 108 115 46 98 109 112 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 146 0 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0 0 0 0 0 7 0 0 0 6 2 5 0 80 111 105 110 116 0 0 0 0 1 5 0 0 31 0 0 0 11 0 0 0 133 67 0 0 178 1 0 0 0 0 0 0 133 67 0 0 0 0 0 0 96 0 0 0 1 0 0 0 210 1 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 23 0 0 0 116 111 111 108 98 97 114 79 112 101 110 67 108 97 115 115 66 114 111 119 115 101 114 146 0 0 0 18 0 0 0 79 112 101 110 32 67 108 97 115 115 32 66 114 111 119 115 101 114 1 0 0 0 0 0 0 0 50 2 0 0 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 250 1 0 0 0 0 0 0 146 0 0 0 7 0 0 0 99 117 114 114 101 110 116 146 0 0 0 9 0 0 0 84 111 111 108 115 46 98 109 112 160 2 0 0 0 0 0 0 7 0 0 0 194 2 0 0 0 0 0 0 97 5 0 0 33 0 0 0 17 0 0 0 135 67 0 0 178 1 0 0 0 0 0 0 135 67 0 0 0 0 0 0 96 0 0 0 1 0 0 0 210 1 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 20 0 0 0 116 111 111 108 98 97 114 79 112 101 110 87 111 114 107 115 112 97 99 101 146 0 0 0 18 0 0 0 79 112 101 110 32 78 101 119 32 87 111 114 107 115 112 97 99 101 1 0 0 0 0 0 0 0 48 3 0 0 7 0 0 0 137 67 0 0 178 1 0 0 0 0 0 0 137 67 0 0 0 0 0 0 96 0 0 0 1 0 0 0 210 1 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 27 0 0 0 116 111 111 108 98 97 114 79 112 101 110 67 111 110 115 116 97 110 116 115 66 114 111 119 115 101 114 146 0 0 0 22 0 0 0 79 112 101 110 32 67 111 110 115 116 97 110 116 115 32 66 114 111 119 115 101 114 1 0 0 0 0 0 0 0 64 2 0 0 21 0 0 0 139 67 0 0 178 1 0 0 0 0 0 0 139 67 0 0 0 0 0 0 96 0 0 0 1 0 0 0 210 1 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 25 0 0 0 116 111 111 108 98 97 114 79 112 101 110 80 97 99 107 97 103 101 66 114 111 119 115 101 114 146 0 0 0 20 0 0 0 79 112 101 110 32 80 97 99 107 97 103 101 32 66 114 111 119 115 101 114 1 0 0 0 0 0 0 0 64 2 0 0 3 0 0 0 194 0 0 0 6 0 0 0 224 2 0 0 192 3 0 0 16 4 0 0 96 4 0 0 192 1 0 0 6 6 16 0 84 111 111 108 98 97 114 83 101 112 97 114 97 116 111 114 0 0 0 0 0 0 0 0 0 0 0 0 96 0 0 0 3 0 0 0 0 0 0 0 1 0 0 0 74 1 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 11 0 0 0 76 111 111 107 117 112 84 97 98 108 101 194 0 0 0 2 0 0 0 48 3 0 0 1 0 0 0 0 0 0 0 32 0 0 0 0 0 0 0 194 2 0 0 0 0 0 0 33 0 0 0 31 0 0 0 194 2 0 0 0 0 0 0 45 0 0 0 45 0 0 0 0 0 0 0 0 0 0 0 6 1 15 0 77 101 115 115 97 103 101 83 101 113 117 101 110 99 101 0 0 0 0 14 2 18 0 83 84 66 67 111 108 108 101 99 116 105 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 79 114 100 101 114 101 100 67 111 108 108 101 99 116 105 111 110 194 0 0 0 2 0 0 0 6 3 11 0 77 101 115 115 97 103 101 83 101 110 100 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 16 0 0 0 99 114 101 97 116 101 65 116 58 101 120 116 101 110 116 58 194 0 0 0 2 0 0 0 194 2 0 0 0 0 0 0 11 0 0 0 11 0 0 0 194 2 0 0 0 0 0 0 135 1 0 0 51 0 0 0 96 0 0 0 178 5 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 10 0 0 0 117 112 100 97 116 101 83 105 122 101 194 0 0 0 0 0 0 0 96 0 0 0 6 1 15 0 87 73 78 68 79 87 80 76 65 67 69 77 69 78 84 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 5 0 0 0 200 0 0 0 30 0 0 0 106 5 0 0 0 0 0 0 128 5 0 0 128 1 0 0 194 2 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 19 0 0 0 70 5 4 0 3 0 0 0 73 99 111 110 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 18 1 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 18 1 0 0 7 0 0 0 99 117 114 114 101 110 116 18 1 0 0 22 0 0 0 67 111 110 116 114 111 108 66 97 114 65 98 115 116 114 97 99 116 46 105 99 111 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 18 1 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0])!

(ResourceIdentifier class: PstToolbar name: 'PstWorkspaceTools Toolbar') assign: (Object fromBinaryStoreBytes:
#[33 83 84 66 32 48 32 70 2 12 0 1 0 0 0 86 105 101 119 82 101 115 111 117 114 99 101 0 0 0 0 14 1 36 0 83 84 66 82 101 115 111 117 114 99 101 83 84 66 66 121 116 101 65 114 114 97 121 65 99 99 101 115 115 111 114 80 114 111 120 121 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 206 5 0 0 33 83 84 66 32 48 32 78 8 12 0 10 0 0 0 83 84 66 86 105 101 119 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 146 0 0 0 7 0 0 0 84 111 111 108 98 97 114 38 0 5 0 65 114 114 97 121 25 0 0 0 0 0 0 0 0 0 0 0 194 0 0 0 2 0 0 0 54 0 12 0 76 97 114 103 101 73 110 116 101 103 101 114 4 0 0 0 100 11 0 68 1 0 2 0 96 0 0 0 0 0 0 0 6 1 11 0 83 121 115 116 101 109 67 111 108 111 114 0 0 0 0 31 0 0 0 0 0 0 0 7 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 242 0 0 0 8 0 0 0 15 1 255 255 0 0 0 0 14 2 26 0 83 84 66 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 18 0 0 0 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 194 0 0 0 0 0 0 0 74 1 0 0 0 0 0 0 96 1 0 0 194 0 0 0 6 0 0 0 235 66 0 0 6 7 13 0 84 111 111 108 98 97 114 66 117 116 116 111 110 0 0 0 0 235 66 0 0 0 0 0 0 96 0 0 0 1 0 0 0 70 4 18 0 2 0 0 0 67 111 109 109 97 110 100 68 101 115 99 114 105 112 116 105 111 110 0 0 0 0 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 146 0 0 0 7 0 0 0 112 114 105 110 116 73 116 146 0 0 0 10 0 0 0 68 105 115 112 108 97 121 32 73 116 1 0 0 0 0 0 0 0 70 8 6 0 3 0 0 0 66 105 116 109 97 112 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 250 1 0 0 0 0 0 0 146 0 0 0 7 0 0 0 99 117 114 114 101 110 116 146 0 0 0 9 0 0 0 84 111 111 108 115 46 98 109 112 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 146 0 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0 0 0 0 0 7 0 0 0 6 2 5 0 80 111 105 110 116 0 0 0 0 97 5 0 0 33 0 0 0 55 0 0 0 237 66 0 0 178 1 0 0 0 0 0 0 237 66 0 0 0 0 0 0 96 0 0 0 1 0 0 0 210 1 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 4 0 0 0 100 111 73 116 146 0 0 0 11 0 0 0 69 118 97 108 117 97 116 101 32 73 116 1 0 0 0 0 0 0 0 50 2 0 0 0 0 0 0 0 0 0 0 16 0 0 0 96 2 0 0 146 0 0 0 9 0 0 0 84 111 111 108 115 46 98 109 112 208 2 0 0 0 0 0 0 7 0 0 0 242 2 0 0 0 0 0 0 97 5 0 0 33 0 0 0 57 0 0 0 239 66 0 0 178 1 0 0 0 0 0 0 239 66 0 0 0 0 0 0 96 0 0 0 1 0 0 0 210 1 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 9 0 0 0 105 110 115 112 101 99 116 73 116 146 0 0 0 10 0 0 0 73 110 115 112 101 99 116 32 73 116 1 0 0 0 0 0 0 0 64 2 0 0 59 0 0 0 14 2 18 0 83 84 66 67 111 108 108 101 99 116 105 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 79 114 100 101 114 101 100 67 111 108 108 101 99 116 105 111 110 194 0 0 0 4 0 0 0 192 1 0 0 16 3 0 0 144 3 0 0 6 6 16 0 84 111 111 108 98 97 114 83 101 112 97 114 97 116 111 114 0 0 0 0 0 0 0 0 0 0 0 0 96 0 0 0 3 0 0 0 0 0 0 0 1 0 0 0 74 1 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 11 0 0 0 76 111 111 107 117 112 84 97 98 108 101 194 0 0 0 2 0 0 0 64 2 0 0 1 0 0 0 0 0 0 0 32 0 0 0 0 0 0 0 242 2 0 0 0 0 0 0 33 0 0 0 31 0 0 0 242 2 0 0 0 0 0 0 45 0 0 0 45 0 0 0 0 0 0 0 0 0 0 0 6 1 15 0 77 101 115 115 97 103 101 83 101 113 117 101 110 99 101 0 0 0 0 234 3 0 0 0 0 0 0 0 4 0 0 194 0 0 0 2 0 0 0 6 3 11 0 77 101 115 115 97 103 101 83 101 110 100 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 16 0 0 0 99 114 101 97 116 101 65 116 58 101 120 116 101 110 116 58 194 0 0 0 2 0 0 0 242 2 0 0 0 0 0 0 11 0 0 0 11 0 0 0 242 2 0 0 0 0 0 0 151 0 0 0 51 0 0 0 96 0 0 0 242 4 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 10 0 0 0 117 112 100 97 116 101 83 105 122 101 194 0 0 0 0 0 0 0 96 0 0 0 6 1 15 0 87 73 78 68 79 87 80 76 65 67 69 77 69 78 84 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 5 0 0 0 80 0 0 0 30 0 0 0 234 3 0 0 0 0 0 0 0 4 0 0 128 1 0 0 242 2 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 19 0 0 0 70 5 4 0 3 0 0 0 73 99 111 110 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 18 1 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 18 1 0 0 7 0 0 0 99 117 114 114 101 110 116 18 1 0 0 22 0 0 0 67 111 110 116 114 111 108 66 97 114 65 98 115 116 114 97 99 116 46 105 99 111 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 18 1 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0])!

(ResourceIdentifier class: PstWorkspace name: 'Default view') assign: (Object fromBinaryStoreBytes:
#[33 83 84 66 32 48 32 70 2 12 0 1 0 0 0 86 105 101 119 82 101 115 111 117 114 99 101 0 0 0 0 14 1 36 0 83 84 66 82 101 115 111 117 114 99 101 83 84 66 66 121 116 101 65 114 114 97 121 65 99 99 101 115 115 111 114 80 114 111 120 121 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 196 18 0 0 33 83 84 66 32 48 32 78 8 12 0 10 0 0 0 83 84 66 86 105 101 119 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 146 0 0 0 9 0 0 0 83 104 101 108 108 86 105 101 119 38 0 5 0 65 114 114 97 121 24 0 0 0 0 0 0 0 0 0 0 0 194 0 0 0 2 0 0 0 1 0 158 1 1 0 2 0 96 0 0 0 0 0 0 0 6 1 11 0 83 121 115 116 101 109 67 111 108 111 114 0 0 0 0 31 0 0 0 6 2 5 0 80 111 105 110 116 0 0 0 0 1 5 0 0 193 3 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 7 12 0 66 111 114 100 101 114 76 97 121 111 117 116 0 0 0 0 1 0 0 0 1 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 13 0 0 0 67 111 110 116 97 105 110 101 114 86 105 101 119 194 0 0 0 15 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 54 0 12 0 76 97 114 103 101 73 110 116 101 103 101 114 4 0 0 0 0 0 0 68 1 0 2 0 80 1 0 0 0 0 0 0 242 0 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 3 10 0 70 108 111 119 76 97 121 111 117 116 0 0 0 0 1 0 0 0 1 0 0 0 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 146 0 0 0 4 0 0 0 108 101 102 116 14 2 26 0 83 84 66 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 18 0 0 0 73 100 101 110 116 105 116 121 68 105 99 116 105 111 110 97 114 121 194 0 0 0 0 0 0 0 0 0 0 0 6 1 15 0 77 101 115 115 97 103 101 83 101 113 117 101 110 99 101 0 0 0 0 14 2 18 0 83 84 66 67 111 108 108 101 99 116 105 111 110 80 114 111 120 121 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 17 0 0 0 79 114 100 101 114 101 100 67 111 108 108 101 99 116 105 111 110 194 0 0 0 1 0 0 0 6 3 11 0 77 101 115 115 97 103 101 83 101 110 100 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 16 0 0 0 99 114 101 97 116 101 65 116 58 101 120 116 101 110 116 58 194 0 0 0 2 0 0 0 18 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 18 1 0 0 0 0 0 0 241 4 0 0 51 0 0 0 80 1 0 0 6 1 15 0 87 73 78 68 79 87 80 76 65 67 69 77 69 78 84 0 0 0 0 54 0 9 0 66 121 116 101 65 114 114 97 121 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 120 2 0 0 25 0 0 0 154 2 0 0 0 0 0 0 176 2 0 0 194 0 0 0 3 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 13 0 0 0 82 101 102 101 114 101 110 99 101 86 105 101 119 194 0 0 0 14 0 0 0 0 0 0 0 80 1 0 0 194 0 0 0 2 0 0 0 162 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 176 3 0 0 0 0 0 0 242 0 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 2 18 0 82 101 115 111 117 114 99 101 73 100 101 110 116 105 102 105 101 114 0 0 0 0 122 0 0 0 0 0 0 0 146 0 0 0 3 0 0 0 112 115 116 146 0 0 0 10 0 0 0 80 115 116 84 111 111 108 98 97 114 146 0 0 0 16 0 0 0 80 115 116 73 109 97 103 101 32 84 111 111 108 98 97 114 0 0 0 0 114 2 0 0 0 0 0 0 154 2 0 0 0 0 0 0 176 2 0 0 194 0 0 0 1 0 0 0 226 2 0 0 0 0 0 0 0 3 0 0 194 0 0 0 2 0 0 0 18 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 18 1 0 0 0 0 0 0 63 0 0 0 51 0 0 0 176 3 0 0 82 3 0 0 0 0 0 0 114 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 31 0 0 0 25 0 0 0 194 0 0 0 0 0 0 0 18 1 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 192 3 0 0 194 0 0 0 14 0 0 0 0 0 0 0 80 1 0 0 194 0 0 0 2 0 0 0 162 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 48 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 34 4 0 0 0 0 0 0 64 4 0 0 146 0 0 0 16 0 0 0 80 115 116 84 111 111 108 115 32 84 111 111 108 98 97 114 0 0 0 0 114 2 0 0 0 0 0 0 154 2 0 0 0 0 0 0 176 2 0 0 194 0 0 0 1 0 0 0 226 2 0 0 0 0 0 0 0 3 0 0 194 0 0 0 2 0 0 0 18 1 0 0 0 0 0 0 63 0 0 0 1 0 0 0 18 1 0 0 0 0 0 0 247 0 0 0 51 0 0 0 48 5 0 0 82 3 0 0 0 0 0 0 114 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 31 0 0 0 0 0 0 0 154 0 0 0 25 0 0 0 16 5 0 0 32 5 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 192 3 0 0 194 0 0 0 14 0 0 0 0 0 0 0 80 1 0 0 194 0 0 0 2 0 0 0 162 1 0 0 4 0 0 0 0 0 0 68 1 0 2 0 32 6 0 0 0 0 0 0 242 0 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 34 4 0 0 0 0 0 0 64 4 0 0 146 0 0 0 25 0 0 0 80 115 116 87 111 114 107 115 112 97 99 101 84 111 111 108 115 32 84 111 111 108 98 97 114 0 0 0 0 114 2 0 0 0 0 0 0 154 2 0 0 0 0 0 0 176 2 0 0 194 0 0 0 1 0 0 0 226 2 0 0 0 0 0 0 0 3 0 0 194 0 0 0 2 0 0 0 18 1 0 0 0 0 0 0 53 1 0 0 1 0 0 0 18 1 0 0 0 0 0 0 155 0 0 0 51 0 0 0 32 6 0 0 82 3 0 0 0 0 0 0 114 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 154 0 0 0 0 0 0 0 231 0 0 0 25 0 0 0 16 5 0 0 32 5 0 0 0 0 0 0 19 0 0 0 32 5 0 0 0 0 0 0 19 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 9 0 0 0 83 116 97 116 117 115 66 97 114 194 0 0 0 18 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 162 1 0 0 4 0 0 0 4 1 0 68 1 0 0 0 32 7 0 0 0 0 0 0 242 0 0 0 0 0 0 0 31 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 6 4 4 0 70 111 110 116 0 0 0 0 0 0 0 0 16 0 0 0 6 1 7 0 76 79 71 70 79 78 84 0 0 0 0 114 3 0 0 60 0 0 0 243 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 144 1 0 0 0 0 0 0 3 2 1 34 65 114 105 97 108 0 31 5 20 135 63 1 0 0 204 53 63 1 3 0 20 59 0 0 0 0 247 0 5 86 111 1 18 1 0 0 0 0 0 0 193 0 0 0 193 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 162 1 0 0 8 0 0 0 39 2 255 255 0 0 0 0 42 2 0 0 0 0 0 0 64 2 0 0 96 2 0 0 154 2 0 0 0 0 0 0 176 2 0 0 194 0 0 0 1 0 0 0 6 4 17 0 83 116 97 116 117 115 66 97 114 78 117 108 108 73 116 101 109 0 0 0 0 1 2 0 0 1 0 0 0 32 7 0 0 0 0 0 0 64 8 0 0 0 0 0 0 114 2 0 0 0 0 0 0 154 2 0 0 0 0 0 0 176 2 0 0 194 0 0 0 1 0 0 0 226 2 0 0 0 0 0 0 0 3 0 0 194 0 0 0 2 0 0 0 18 1 0 0 0 0 0 0 1 0 0 0 99 3 0 0 18 1 0 0 0 0 0 0 241 4 0 0 41 0 0 0 32 7 0 0 82 3 0 0 0 0 0 0 114 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 177 1 0 0 120 2 0 0 197 1 0 0 154 2 0 0 0 0 0 0 176 2 0 0 96 2 0 0 32 5 0 0 0 0 0 0 19 0 0 0 0 0 0 0 0 0 0 0 90 0 0 0 0 0 0 0 122 0 0 0 0 0 0 0 160 0 0 0 146 0 0 0 12 0 0 0 82 105 99 104 84 101 120 116 69 100 105 116 194 0 0 0 18 0 0 0 0 0 0 0 96 0 0 0 194 0 0 0 2 0 0 0 162 1 0 0 4 0 0 0 68 17 33 68 1 4 0 0 240 8 0 0 0 0 0 0 6 3 3 0 82 71 66 0 0 0 0 181 1 0 0 215 1 0 0 209 1 0 0 0 0 0 0 7 0 0 0 70 5 4 0 2 0 0 0 77 101 110 117 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 10 0 0 0 70 2 15 0 1 0 0 0 67 111 109 109 97 110 100 77 101 110 117 73 116 101 109 0 0 0 0 1 0 0 0 70 4 18 0 2 0 0 0 67 111 109 109 97 110 100 68 101 115 99 114 105 112 116 105 111 110 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 6 0 0 0 97 99 99 101 112 116 146 0 0 0 7 0 0 0 38 65 99 99 101 112 116 167 32 0 0 0 0 0 0 70 1 15 0 1 0 0 0 68 105 118 105 100 101 114 77 101 110 117 73 116 101 109 0 0 0 0 1 16 0 0 162 9 0 0 0 0 0 0 1 0 0 0 194 9 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 12 0 0 0 99 117 116 83 101 108 101 99 116 105 111 110 146 0 0 0 4 0 0 0 67 117 38 116 177 32 0 0 0 0 0 0 162 9 0 0 0 0 0 0 1 0 0 0 194 9 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 13 0 0 0 99 111 112 121 83 101 108 101 99 116 105 111 110 146 0 0 0 5 0 0 0 38 67 111 112 121 135 32 0 0 0 0 0 0 162 9 0 0 0 0 0 0 1 0 0 0 194 9 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 14 0 0 0 112 97 115 116 101 67 108 105 112 98 111 97 114 100 146 0 0 0 6 0 0 0 38 80 97 115 116 101 173 32 0 0 0 0 0 0 162 9 0 0 0 0 0 0 1 0 0 0 194 9 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 14 0 0 0 99 108 101 97 114 83 101 108 101 99 116 105 111 110 146 0 0 0 7 0 0 0 68 101 38 108 101 116 101 93 2 0 0 0 0 0 0 32 10 0 0 162 9 0 0 0 0 0 0 1 0 0 0 194 9 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 4 0 0 0 100 111 73 116 146 0 0 0 6 0 0 0 38 68 111 32 105 116 139 32 0 0 0 0 0 0 162 9 0 0 0 0 0 0 1 0 0 0 194 9 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 7 0 0 0 112 114 105 110 116 73 116 146 0 0 0 9 0 0 0 80 38 114 105 110 116 32 105 116 137 32 0 0 0 0 0 0 162 9 0 0 0 0 0 0 1 0 0 0 194 9 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 9 0 0 0 105 110 115 112 101 99 116 73 116 146 0 0 0 11 0 0 0 38 73 110 115 112 101 99 116 32 105 116 147 32 0 0 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 162 1 0 0 4 0 0 0 211 16 46 119 6 2 13 0 78 117 108 108 67 111 110 118 101 114 116 101 114 0 0 0 0 0 0 0 0 0 0 0 0 9 0 0 0 0 0 0 0 6 1 10 0 69 68 73 84 83 84 82 69 65 77 0 0 0 0 114 3 0 0 12 0 0 0 0 0 0 0 0 0 0 0 228 177 113 12 114 2 0 0 0 0 0 0 154 2 0 0 0 0 0 0 176 2 0 0 194 0 0 0 6 0 0 0 226 2 0 0 0 0 0 0 0 3 0 0 194 0 0 0 2 0 0 0 18 1 0 0 0 0 0 0 1 0 0 0 51 0 0 0 18 1 0 0 0 0 0 0 241 4 0 0 49 3 0 0 240 8 0 0 226 2 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 12 0 0 0 99 111 110 116 101 120 116 77 101 110 117 58 194 0 0 0 1 0 0 0 128 9 0 0 240 8 0 0 226 2 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 5 0 0 0 116 101 120 116 58 194 0 0 0 1 0 0 0 6 1 8 0 82 105 99 104 84 101 120 116 0 0 0 0 146 0 0 0 120 0 0 0 123 92 114 116 102 49 92 97 110 115 105 92 97 110 115 105 99 112 103 49 50 53 50 92 100 101 102 102 48 92 100 101 102 108 97 110 103 50 48 53 55 123 92 102 111 110 116 116 98 108 123 92 102 48 92 102 114 111 109 97 110 32 84 105 109 101 115 32 78 101 119 32 82 111 109 97 110 59 125 125 13 10 92 118 105 101 119 107 105 110 100 52 92 117 99 49 92 112 97 114 100 92 102 48 92 102 115 50 50 32 13 10 92 112 97 114 32 125 13 10 240 8 0 0 226 2 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 115 101 108 101 99 116 105 111 110 82 97 110 103 101 58 194 0 0 0 1 0 0 0 6 3 8 0 73 110 116 101 114 118 97 108 0 0 0 0 3 0 0 0 1 0 0 0 3 0 0 0 240 8 0 0 226 2 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 105 115 84 101 120 116 77 111 100 105 102 105 101 100 58 194 0 0 0 1 0 0 0 32 0 0 0 240 8 0 0 226 2 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 15 0 0 0 114 101 115 101 116 67 104 97 114 70 111 114 109 97 116 194 0 0 0 0 0 0 0 240 8 0 0 82 3 0 0 0 0 0 0 114 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 25 0 0 0 120 2 0 0 177 1 0 0 154 2 0 0 0 0 0 0 176 2 0 0 96 2 0 0 32 5 0 0 0 0 0 0 19 0 0 0 42 2 0 0 0 0 0 0 64 2 0 0 194 0 0 0 2 0 0 0 240 8 0 0 146 0 0 0 10 0 0 0 115 111 117 114 99 101 67 111 100 101 0 0 0 0 70 5 7 0 2 0 0 0 77 101 110 117 66 97 114 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 1 0 0 0 114 9 0 0 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 10 0 0 0 162 9 0 0 0 0 0 0 1 0 0 0 194 9 0 0 0 0 0 0 224 9 0 0 146 0 0 0 7 0 0 0 38 65 99 99 101 112 116 167 32 0 0 0 0 0 0 18 10 0 0 0 0 0 0 1 16 0 0 162 9 0 0 0 0 0 0 1 0 0 0 194 9 0 0 0 0 0 0 80 10 0 0 146 0 0 0 4 0 0 0 67 117 38 116 177 32 0 0 0 0 0 0 162 9 0 0 0 0 0 0 1 0 0 0 194 9 0 0 0 0 0 0 160 10 0 0 146 0 0 0 5 0 0 0 38 67 111 112 121 135 32 0 0 0 0 0 0 162 9 0 0 0 0 0 0 1 0 0 0 194 9 0 0 0 0 0 0 240 10 0 0 146 0 0 0 6 0 0 0 38 80 97 115 116 101 173 32 0 0 0 0 0 0 162 9 0 0 0 0 0 0 1 0 0 0 194 9 0 0 0 0 0 0 64 11 0 0 146 0 0 0 7 0 0 0 68 101 38 108 101 116 101 1 0 0 0 0 0 0 0 176 15 0 0 162 9 0 0 0 0 0 0 1 0 0 0 194 9 0 0 0 0 0 0 144 11 0 0 146 0 0 0 6 0 0 0 38 68 111 32 73 116 139 32 0 0 0 0 0 0 162 9 0 0 0 0 0 0 1 0 0 0 194 9 0 0 0 0 0 0 224 11 0 0 146 0 0 0 9 0 0 0 80 38 114 105 110 116 32 73 116 137 32 0 0 0 0 0 0 162 9 0 0 0 0 0 0 1 0 0 0 194 9 0 0 0 0 0 0 48 12 0 0 146 0 0 0 11 0 0 0 38 73 110 115 112 101 99 116 32 73 116 147 32 0 0 0 0 0 0 146 0 0 0 7 0 0 0 38 83 111 117 114 99 101 0 0 0 0 146 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 3 16 0 65 99 99 101 108 101 114 97 116 111 114 84 97 98 108 101 0 0 0 0 0 0 0 0 16 0 0 0 194 0 0 0 7 0 0 0 6 2 11 0 65 115 115 111 99 105 97 116 105 111 110 0 0 0 0 167 32 0 0 144 15 0 0 98 17 0 0 0 0 0 0 177 32 0 0 208 15 0 0 98 17 0 0 0 0 0 0 135 32 0 0 0 16 0 0 98 17 0 0 0 0 0 0 173 32 0 0 48 16 0 0 98 17 0 0 0 0 0 0 139 32 0 0 144 16 0 0 98 17 0 0 0 0 0 0 137 32 0 0 192 16 0 0 98 17 0 0 0 0 0 0 147 32 0 0 240 16 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 114 2 0 0 0 0 0 0 154 2 0 0 0 0 0 0 176 2 0 0 194 0 0 0 3 0 0 0 226 2 0 0 0 0 0 0 0 3 0 0 194 0 0 0 2 0 0 0 18 1 0 0 0 0 0 0 11 0 0 0 11 0 0 0 18 1 0 0 0 0 0 0 1 5 0 0 193 3 0 0 96 0 0 0 226 2 0 0 0 0 0 0 144 13 0 0 194 0 0 0 1 0 0 0 146 0 0 0 9 0 0 0 87 111 114 107 115 112 97 99 101 96 0 0 0 226 2 0 0 0 0 0 0 250 1 0 0 0 0 0 0 146 0 0 0 8 0 0 0 109 101 110 117 66 97 114 58 194 0 0 0 1 0 0 0 64 15 0 0 96 0 0 0 82 3 0 0 0 0 0 0 114 3 0 0 44 0 0 0 44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 5 0 0 0 133 2 0 0 229 1 0 0 154 2 0 0 0 0 0 0 176 2 0 0 194 0 0 0 3 0 0 0 32 7 0 0 240 8 0 0 80 1 0 0 32 5 0 0 0 0 0 0 19 0 0 0 70 5 4 0 3 0 0 0 73 99 111 110 0 0 0 0 0 0 0 0 16 0 0 0 14 2 17 0 83 84 66 83 105 110 103 108 101 116 111 110 80 114 111 120 121 0 0 0 0 78 2 13 0 1 0 0 0 83 84 66 67 108 97 115 115 80 114 111 120 121 0 0 0 0 54 0 6 0 83 116 114 105 110 103 7 0 0 0 68 111 108 112 104 105 110 18 1 0 0 24 0 0 0 73 109 97 103 101 82 101 108 97 116 105 118 101 70 105 108 101 76 111 99 97 116 111 114 14 1 14 0 83 84 66 83 121 109 98 111 108 80 114 111 120 121 0 0 0 0 18 1 0 0 7 0 0 0 99 117 114 114 101 110 116 18 1 0 0 13 0 0 0 83 104 101 108 108 86 105 101 119 46 105 99 111 14 2 31 0 83 84 66 69 120 116 101 114 110 97 108 82 101 115 111 117 114 99 101 76 105 98 114 97 114 121 80 114 111 120 121 0 0 0 0 18 1 0 0 16 0 0 0 100 111 108 112 104 105 110 100 114 48 48 52 46 100 108 108 0 0 0 0])!

